###############################################################################
#                                                                             #
#    Copyright © 2012-2013 -- IRB/INSERM                                      #
#                            (Institut de Recherche en Biothérapie /          #
#                             Institut National de la Santé et de la          #
#                             Recherche Médicale)                             #
#                                                                             #
#  Auteurs/Authors:  Jerôme AUDOUX <jerome.audoux@univ-montp2.fr>             #
#                    Alban MANCHERON  <alban.mancheron@lirmm.fr>              #
#                    Nicolas PHILIPPE <nicolas.philippe@inserm.fr>            #
#                                                                             #
#  -------------------------------------------------------------------------  #
#                                                                             #
#  Ce fichier fait partie de la suite CracTools qui contient plusieurs pipeline# 
#  intégrés permettant de traiter les évênements biologiques présents dans du #
#  RNA-Seq. Les CracTools travaillent à partir d'un fichier SAM de CRAC et d'un# 
#  fichier d'annotation au format GFF3.                                       #
#                                                                             #
#  Ce logiciel est régi  par la licence CeCILL  soumise au droit français et  #
#  respectant les principes  de diffusion des logiciels libres.  Vous pouvez  #
#  utiliser, modifier et/ou redistribuer ce programme sous les conditions de  #
#  la licence CeCILL  telle que diffusée par le CEA,  le CNRS et l'INRIA sur  #
#  le site "http://www.cecill.info".                                          #
#                                                                             #
#  En contrepartie de l'accessibilité au code source et des droits de copie,  #
#  de modification et de redistribution accordés par cette licence, il n'est  #
#  offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,  #
#  seule une responsabilité  restreinte pèse  sur l'auteur du programme,  le  #
#  titulaire des droits patrimoniaux et les concédants successifs.            #
#                                                                             #
#  À  cet égard  l'attention de  l'utilisateur est  attirée sur  les risques  #
#  associés  au chargement,  à  l'utilisation,  à  la modification  et/ou au  #
#  développement  et à la reproduction du  logiciel par  l'utilisateur étant  #
#  donné  sa spécificité  de logiciel libre,  qui peut le rendre  complexe à  #
#  manipuler et qui le réserve donc à des développeurs et des professionnels  #
#  avertis  possédant  des  connaissances  informatiques  approfondies.  Les  #
#  utilisateurs  sont donc  invités  à  charger  et  tester  l'adéquation du  #
#  logiciel  à leurs besoins  dans des conditions  permettant  d'assurer  la  #
#  sécurité de leurs systêmes et ou de leurs données et,  plus généralement,  #
#  à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.         #
#                                                                             #
#  Le fait  que vous puissiez accéder  à cet en-tête signifie  que vous avez  #
#  pris connaissance  de la licence CeCILL,  et que vous en avez accepté les  #
#  termes.                                                                    #
#                                                                             #
#  -------------------------------------------------------------------------  #
#                                                                             #
#  This file is part of the CracTools which provide several integrated        #
#  pipeline to analyze biological events present in RNA-Seq data. CracTools   #
#  work on a SAM file generated by CRAC and an annotation file in GFF3 format.#
#                                                                             #
#  This software is governed by the CeCILL license under French law and       #
#  abiding by the rules of distribution of free software. You can use,        #
#  modify and/ or redistribute the software under the terms of the CeCILL     #
#  license as circulated by CEA, CNRS and INRIA at the following URL          #
#  "http://www.cecill.info".                                                  #
#                                                                             #
#  As a counterpart to the access to the source code and rights to copy,      #
#  modify and redistribute granted by the license, users are provided only    #
#  with a limited warranty and the software's author, the holder of the       #
#  economic rights, and the successive licensors have only limited            #
#  liability.                                                                 #
#                                                                             #
#  In this respect, the user's attention is drawn to the risks associated     #
#  with loading, using, modifying and/or developing or reproducing the        #
#  software by the user in light of its specific status of free software,     #
#  that may mean that it is complicated to manipulate, and that also          #
#  therefore means that it is reserved for developers and experienced         #
#  professionals having in-depth computer knowledge. Users are therefore      #
#  encouraged to load and test the software's suitability as regards their    #
#  requirements in conditions enabling the security of their systems and/or   #
#  data to be ensured and, more generally, to use and operate it in the same  #
#  conditions as regards security.                                            #
#                                                                             #
#  The fact that you are presently reading this means that you have had       #
#  knowledge of the CeCILL license and that you accept its terms.             #
#                                                                             #
###############################################################################


###############################################################################
#                              MODULE SKELETON                                #
###############################################################################
# 
# Introduction :
# =============================================================================
#
# DigitagCT is made of several modules which are all constructed using the
# same skeleton (see below).
# Each module is using the "DGEStrucut" and for each tag add some new
# informations as "columns" in the output file.
#
# Each modules have to defined these 3 entities :
# =============================================================================
#
# 1.PROCESSING MODULE : this part is where the computational work is done.
#                       Basically, a test is made to know if the module has to
#                       be activated (ex : if file.module exists).
#                       The the module iterate through all dge tags and add
#                       some new data using method "addGenericElement" from
#                       Structure.
# 2.TITLES :            Each module have to define a function to output the
#                       new columns name that will be printed in the output file.
#                       It's expected that this function output an array of
#                       strings.
# 3.OUTPUT :            As well, each module has to define an other function,
#                       that given a tag in parameter will output the data for
#                       each columns defined by the "TITLES" function.
# 
# Exemple Skeleton :
# =============================================================================
#
# 1. PROCESS DATA
# -----------------------------------------------------------------------------
# if(defined $module_file) {
#   $tag_it = $DGEStruct->iterator();
#   while (my $tag = $tag_it->()) {
#     my %module_data;
#     $DGEStruct->addGenericElement($tag,'module_data',\%module_cross);
#   }
# }
# 
# 2. TITLES
# -----------------------------------------------------------------------------
# sub getModuleTitles {
#   my @output;
#   if(defined $module_file) {
#   }
#   return @output;
# }
# 
# 3. OUTPUT
# -----------------------------------------------------------------------------
# sub getModuleOutput($) {
#   my $tag = shift;
#   my @output;
#   if(defined $DGEStruct->getGenericElement($tag,'module_data')) {
#     my %module_data = %{$DGEStruct->getGenericElement($tag,'module_data')};
#   }
#   return (@output);
# }
#

package CracTools::DigitagCT::Analyzer;

use strict;
use warnings;
use Carp;

sub new {
  my $class = shift;
  my %args = @_;

  croak "Missing Digitag structure in argument" unless defined $args{digitag_struct};

  my $self = bless {
    digitag_struct => $args{digitag_struct},
  },$class;

  return $self;
}

sub getHeaders {
  #croak "This method should be overriden and never called";
  return ();
}

sub getOutput {
  #croak "This method should be overriden and never called";
  return ();
}

sub digitagStruct {
  my $self = shift;
  return $self->{digitag_struct}
}

1;
