# Generated by default/object.tt
package Paws::GlueDataBrew::Dataset;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str');
  has CreateDate => (is => 'ro', isa => 'Str');
  has CreatedBy => (is => 'ro', isa => 'Str');
  has Format => (is => 'ro', isa => 'Str');
  has FormatOptions => (is => 'ro', isa => 'Paws::GlueDataBrew::FormatOptions');
  has Input => (is => 'ro', isa => 'Paws::GlueDataBrew::Input', required => 1);
  has LastModifiedBy => (is => 'ro', isa => 'Str');
  has LastModifiedDate => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has PathOptions => (is => 'ro', isa => 'Paws::GlueDataBrew::PathOptions');
  has ResourceArn => (is => 'ro', isa => 'Str');
  has Source => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'Paws::GlueDataBrew::TagMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::Dataset

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::Dataset object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::Dataset object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Represents a dataset that can be processed by DataBrew.

=head1 ATTRIBUTES


=head2 AccountId => Str

The ID of the Amazon Web Services account that owns the dataset.


=head2 CreateDate => Str

The date and time that the dataset was created.


=head2 CreatedBy => Str

The Amazon Resource Name (ARN) of the user who created the dataset.


=head2 Format => Str

The file format of a dataset that is created from an Amazon S3 file or
folder.


=head2 FormatOptions => L<Paws::GlueDataBrew::FormatOptions>

A set of options that define how DataBrew interprets the data in the
dataset.


=head2 B<REQUIRED> Input => L<Paws::GlueDataBrew::Input>

Information on how DataBrew can find the dataset, in either the Glue
Data Catalog or Amazon S3.


=head2 LastModifiedBy => Str

The Amazon Resource Name (ARN) of the user who last modified the
dataset.


=head2 LastModifiedDate => Str

The last modification date and time of the dataset.


=head2 B<REQUIRED> Name => Str

The unique name of the dataset.


=head2 PathOptions => L<Paws::GlueDataBrew::PathOptions>

A set of options that defines how DataBrew interprets an Amazon S3 path
of the dataset.


=head2 ResourceArn => Str

The unique Amazon Resource Name (ARN) for the dataset.


=head2 Source => Str

The location of the data for the dataset, either Amazon S3 or the Glue
Data Catalog.


=head2 Tags => L<Paws::GlueDataBrew::TagMap>

Metadata tags that have been applied to the dataset.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

