package Net::Amazon::EMR::InstanceGroupStateChangeReason;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;

subtype 'Net::Amazon::EMR::Type::InstanceGroupStateChangeReason::Code' => as 'Str' => where { m/^(?:INTERNAL_ERROR | VALIDATION_ERROR | INSTANCE_FAILURE | CLUSTER_TERMINATED)$/x };

has 'Code' => ( is => 'ro',
                isa => 'Net::Amazon::EMR::Type::InstanceGroupStateChangeReason::Code',
);

has 'Message' => ( is => 'ro', 
                   isa => 'Net::Amazon::EMR::Type::UnconstrainedStr',
                   coerce => 1,
               );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::InstanceGroupStateChangeReason

=head1 DESCRIPTION

Implements the InstanceGroupStateChangeReason data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_InstanceGroupStateChangeReason.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
