# NAME

RT::Extension::RichtextCustomField - CF with wysiwyg editor

# DESCRIPTION

Provide a new type of [custom field](https://docs.bestpractical.com/rt/5.0.2/RT/CustomField.html), similar to Text but with wysiwyg editor when editing value.

# RT VERSION

Works with RT 4.2 or greater. Since RT 5.0.3, there is a new `HTML` type of CustomField which has the same role as this plugin, so it is useless from RT 5.0.3.

If you have install this plugin and want to migrate to RT 5.0.3, all you have to do is to add the following line to file `/opt/rt5/etc/update/5.0.3/schema.Pg` if your RT uses PostgreSQL database, or create `/opt/rt5/etc/update/5.0.3/schema.mysql`, `/opt/rt5/etc/update/5.0.3/` or `/opt/rt5/etc/update/5.0.3/` according to your RT database type, with this single line:

    UPDATE CustomFields SET Type = 'HTML', EntryHint = 'Fill in one HTML area' WHERE Type = 'Richtext';

This will be processed by standard RT database upgrade with `/opt/rt5/sbin/rt-setup-database --action upgrade`.

# INSTALLATION

- `perl Makefile.PL`
- `make`
- `make install`

    May need root permissions

- Patch your RT

    `RichtextCustomField` requires a small patch to allow  [custom fields](https://docs.bestpractical.com/rt/5.0.2/RT/CustomField.html) with `Richtext` type to be chosen as recipient for extracting from a [ticket](https://docs.bestpractical.com/rt/5.0.2/RT/Ticket.html) into an [article](https://docs.bestpractical.com/rt/5.0.2/RT/Article.pm). _You have to apply this patch if you need this feature, and only in this case._

    For RT 4.4 or lower, apply the included patch:

        cd /opt/rt5 # Your location may be different
        patch -p1 < /download/dir/RT-Extension-RichtextCustomField/patches/4.4-add-Richtext-CFs-ExtractArticleFromTicket.patch

- Edit your `/opt/rt5/etc/RT_SiteConfig.pm`

    If you are using RT 4.2 or greater, add this line:

        Plugin('RT::Extension::RichtextCustomField');

    For RT 4.0, add this line:

        Set(@Plugins, qw(RT::Extension::RichtextCustomField));

    or add `RT::Extension::RichtextCustomField` to your existing `@Plugins` line.

- Clear your mason cache

        rm -rf /opt/rt5/var/mason_data/obj

- Restart your webserver

# AUTHOR

Grald Sdrati-Dinet <gibus@easter-eggs.com>

# REPOSITORY

[https://github.com/gibus/RT-Extension-RichtextCustomField](https://github.com/gibus/RT-Extension-RichtextCustomField)

# BUGS

All bugs should be reported via email to

[bug-RT-Extension-RichtextCustomField@rt.cpan.org](mailto:bug-RT-Extension-RichtextCustomField@rt.cpan.org)

or via the web at

[rt.cpan.org](http://rt.cpan.org/Public/Dist/Display.html?Name=RT-Extension-RichtextCustomField).

# LICENSE AND COPYRIGHT

This software is Copyright (c) 2017 by Grald Sdrati-Dinet, Easter-Eggs

This is free software, licensed under:

The GNU General Public License, Version 3, June 2007
