package Net::DashCS::Types::validateLocation;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'http://dashcs.com/api/v1/emergency' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %location_of :ATTR(:get<location>);

__PACKAGE__->_factory(
    [ qw(        location

    ) ],
    {
        'location' => \%location_of,
    },
    {
        'location' => 'Net::DashCS::Types::location',
    },
    {

        'location' => 'location',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Net::DashCS::Types::validateLocation

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
validateLocation from the namespace http://dashcs.com/api/v1/emergency.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * location




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Net::DashCS::Types::validateLocation
   location =>  { # Net::DashCS::Types::location
     activatedtime =>  $some_value, # dateTime
     address1 =>  $some_value, # string
     address2 =>  $some_value, # string
     callername =>  $some_value, # string
     comments =>  $some_value, # string
     community =>  $some_value, # string
     customerorderid =>  $some_value, # string
     latitude =>  $some_value, # double
     legacydata =>  { # Net::DashCS::Types::legacyLocationData
       housenumber =>  $some_value, # string
       predirectional =>  $some_value, # string
       streetname =>  $some_value, # string
       suite =>  $some_value, # string
     },
     locationid =>  $some_value, # string
     longitude =>  $some_value, # double
     plusfour =>  $some_value, # string
     postalcode =>  $some_value, # string
     state =>  $some_value, # string
     status =>  { # Net::DashCS::Types::locationStatus
       code => $some_value, # locationStatusCode
       description =>  $some_value, # string
     },
     type => $some_value, # locationType
     updatetime =>  $some_value, # dateTime
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

