# Generated by default/object.tt
package Paws::ACMPCA::PolicyInformation;
  use Moose;
  has CertPolicyId => (is => 'ro', isa => 'Str', required => 1);
  has PolicyQualifiers => (is => 'ro', isa => 'ArrayRef[Paws::ACMPCA::PolicyQualifierInfo]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::PolicyInformation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::PolicyInformation object:

  $service_obj->Method(Att1 => { CertPolicyId => $value, ..., PolicyQualifiers => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::PolicyInformation object:

  $result = $service_obj->Method(...);
  $result->Att1->CertPolicyId

=head1 DESCRIPTION

Defines the X.509 C<CertificatePolicies> extension.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CertPolicyId => Str

Specifies the object identifier (OID) of the certificate policy under
which the certificate was issued. For more information, see NIST's
definition of Object Identifier (OID)
(https://csrc.nist.gov/glossary/term/Object_Identifier).


=head2 PolicyQualifiers => ArrayRef[L<Paws::ACMPCA::PolicyQualifierInfo>]

Modifies the given C<CertPolicyId> with a qualifier. ACM Private CA
supports the certification practice statement (CPS) qualifier.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

