### The DnD system

use EyeofTheBeholder::DnDStr;
use EyeofTheBeholder::DnDDex;
use EyeofTheBeholder::DnDInt;
use EyeofTheBeholder::DnDWis;
use EyeofTheBeholder::DnDCon;
use EyeofTheBeholder::DnDCha;

use EyeofTheBeholder::DnDAC;

class EyeofTheBeholder::DnDCharSys {

	has $!str;
	has $!dex;
	has $!int;
	has $!wis;
	has $!con;
	has $!cha;

	has $!AC;

       submethod BUILD() {

		$!str = DnDStr.new;
		$!dex = DnDDex.new;
		$!int = DnDInt.new;
		$!wis = DnDWis.new;
		$!con = DnDCon.new;
		$!cha = DnDCha.new;

		$!AC = DnDAC.new;

		self.init;
		
	}

	submethod init {

		self.roll-statlines-0;
		self.roll-AC-0;

	}

	submethod roll-statlines-0 {

		$!str.set(18.rand.Int);
		$!dex.set(18.rand.Int);
		$!int.set(18.rand.Int);
		$!wis.set(18.rand.Int);
		$!con.set(18.rand.Int);
		$!cha.set(18.rand.Int);

	}
	
	submethod roll-AC-0 {

		### NOTE FIXME 15
		$!AC.set(15.rand.Int);

	}

	### adds to stats
	submethod add-to-strength($plus) {

		$!str.add($plus);

	}

	submethod add-to-dexterity($plus) {

		$!dex.add($plus);

	}

	submethod add-to-intelligence($plus) {

		$!int.add($plus);

	}

	submethod add-to-wisdom($plus) {

		$!wis.add($plus);

	}

	submethod add-to-constitution($plus) {

		$!con.add($plus);

	}

	submethod add-to-charisma($plus) {

		$!cha.add($plus);

	}

	### substracts from stats
	submethod sub-to-strength($minus) {

		$!str.sub($minus);

	}

	submethod sub-to-dexterity($minus) {

		$!dex.sub($minus);

	}

	submethod sub-to-intelligence($minus) {

		$!int.sub($minus);

	}

	submethod sub-to-wisdom($minus) {

		$!wis.sub($minus);

	}

	submethod sub-to-constitution($minus) {

		$!con.sub($minus);

	}

	submethod sub-to-charisma($minus) {

		$!cha.sub($minus);

	}


}
