/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_grid_ActionColumn({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.grid.Column","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='docClass'>Ext.grid.Column</a><div class='subclass '><strong>Ext.grid.ActionColumn</strong></div></div></div><h4>Files</h4><div class='dependency'><a href='source/Column.html#Ext-grid-ActionColumn' target='_blank'>Column.js</a></div></pre><div class='doc-contents'><p>A Grid column type which renders an icon, or a series of icons in a grid cell, and offers a scoped click\nhandler for each icon. Example usage:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.grid.GridPanel\" rel=\"Ext.grid.GridPanel\" class=\"docClass\">Ext.grid.GridPanel</a>({\n    store: myStore,\n    columns: [\n        {\n            xtype: 'actioncolumn',\n            width: 50,\n            items: [\n                {\n                    icon   : 'sell.gif',                // Use a URL in the icon config\n                    tooltip: 'Sell stock',\n                    handler: function(grid, rowIndex, colIndex) {\n                        var rec = store.getAt(rowIndex);\n                        alert(\"Sell \" + rec.get('company'));\n                    }\n                },\n                {\n                    getClass: function(v, meta, rec) {  // Or return a class from a function\n                        if (rec.get('change') < 0) {\n                            this.items[1].tooltip = 'Do not buy!';\n                            return 'alert-col';\n                        } else {\n                            this.items[1].tooltip = 'Buy stock';\n                            return 'buy-col';\n                        }\n                    },\n                    handler: function(grid, rowIndex, colIndex) {\n                        var rec = store.getAt(rowIndex);\n                        alert(\"Buy \" + rec.get('company'));\n                    }\n                }\n            ]\n        }\n        //any other columns here\n    ]\n});\n</pre>\n\n\n<p></code></p>\n\n<p>The action column can be at any index in the columns array, and a grid can have any number of\naction columns. </p>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-align' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-align' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-align' class='name expandable'>align</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. Set the CSS text-align property of the column.  Defaults to undefined.</p>\n</div></div></div><div id='cfg-altText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-cfg-altText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-cfg-altText' class='name expandable'>altText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The alt text to use for the image element. ...</div><div class='long'><p>The alt text to use for the image element. Defaults to <tt>''</tt>.</p>\n<p>Defaults to: <code>''</code></p></div></div></div><div id='cfg-css' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-css' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-css' class='name expandable'>css</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. An inline style definition string which is applied to all table cells in the column\n(excluding headers). Defaults to undefined.</p>\n</div></div></div><div id='cfg-dataIndex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-dataIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-dataIndex' class='name expandable'>dataIndex</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Required. ...</div><div class='long'><p><b>Required</b>. The name of the field in the\ngrid's <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>'s <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> definition from\nwhich to draw the column's value.</p>\n\n</div></div></div><div id='cfg-editable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-editable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-editable' class='name expandable'>editable</a><span> : Boolean</span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. Defaults to <tt>true</tt>, enabling the configured\n<tt><a href=\"#!/api/Ext.grid.Column-cfg-editor\" rel=\"Ext.grid.Column-cfg-editor\" class=\"docClass\">editor</a></tt>.  Set to <tt>false</tt> to initially disable editing on this column.\nThe initial configuration may be dynamically altered using\n<a href=\"#!/api/Ext.grid.ColumnModel\" rel=\"Ext.grid.ColumnModel\" class=\"docClass\">Ext.grid.ColumnModel</a>.<a href=\"#!/api/Ext.grid.ColumnModel-method-setEditable\" rel=\"Ext.grid.ColumnModel-method-setEditable\" class=\"docClass\">setEditable()</a>.</p>\n</div></div></div><div id='cfg-editor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-editor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-editor' class='name expandable'>editor</a><span> : <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. The <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a> to use when editing values in this column\nif editing is supported by the grid. See <tt><a href=\"#!/api/Ext.grid.Column-cfg-editable\" rel=\"Ext.grid.Column-cfg-editable\" class=\"docClass\">editable</a></tt> also.</p>\n</div></div></div><div id='cfg-emptyGroupText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-emptyGroupText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-emptyGroupText' class='name expandable'>emptyGroupText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. If the grid is being rendered by an <a href=\"#!/api/Ext.grid.GroupingView\" rel=\"Ext.grid.GroupingView\" class=\"docClass\">Ext.grid.GroupingView</a>, this option\nmay be used to specify the text to display when there is an empty group value. Defaults to the\n<a href=\"#!/api/Ext.grid.GroupingView\" rel=\"Ext.grid.GroupingView\" class=\"docClass\">Ext.grid.GroupingView</a>.<a href=\"#!/api/Ext.grid.GroupingView-cfg-emptyGroupText\" rel=\"Ext.grid.GroupingView-cfg-emptyGroupText\" class=\"docClass\">emptyGroupText</a>.</p>\n</div></div></div><div id='cfg-fixed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-fixed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-fixed' class='name expandable'>fixed</a><span> : Boolean</span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. <tt>true</tt> if the column width cannot be changed.  Defaults to <tt>false</tt>.</p>\n</div></div></div><div id='cfg-getClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-cfg-getClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-cfg-getClass' class='name expandable'>getClass</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>A function which returns the CSS class to apply to the icon image. ...</div><div class='long'><p>A function which returns the CSS class to apply to the icon image.\nThe function is passed the following parameters:<div class=\"mdetail-params\"><ul></p>\n\n<pre><code>&lt;li&gt;&lt;b&gt;v&lt;/b&gt; : Object&lt;p class=\"sub-desc\"&gt;The value of the column's configured field (if any).&lt;/p&gt;&lt;/li&gt;\n&lt;li&gt;&lt;b&gt;metadata&lt;/b&gt; : Object&lt;p class=\"sub-desc\"&gt;An object in which you may set the following attributes:&lt;ul&gt;\n    &lt;li&gt;&lt;b&gt;css&lt;/b&gt; : String&lt;p class=\"sub-desc\"&gt;A CSS class name to add to the cell's TD element.&lt;/p&gt;&lt;/li&gt;\n    &lt;li&gt;&lt;b&gt;attr&lt;/b&gt; : String&lt;p class=\"sub-desc\"&gt;An HTML attribute definition string to apply to the data container element &lt;i&gt;within&lt;/i&gt; the table cell\n    (e.g. 'style=\"color:red;\"').&lt;/p&gt;&lt;/li&gt;\n&lt;/ul&gt;&lt;/p&gt;&lt;/li&gt;\n&lt;li&gt;&lt;b&gt;r&lt;/b&gt; : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>&lt;p class=\"sub-desc\"&gt;The Record providing the data.&lt;/p&gt;&lt;/li&gt;\n&lt;li&gt;&lt;b&gt;rowIndex&lt;/b&gt; : Number&lt;p class=\"sub-desc\"&gt;The row index..&lt;/p&gt;&lt;/li&gt;\n&lt;li&gt;&lt;b&gt;colIndex&lt;/b&gt; : Number&lt;p class=\"sub-desc\"&gt;The column index.&lt;/p&gt;&lt;/li&gt;\n&lt;li&gt;&lt;b&gt;store&lt;/b&gt; : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>&lt;p class=\"sub-desc\"&gt;The Store which is providing the data Model.&lt;/p&gt;&lt;/li&gt;\n</code></pre>\n\n<p></ul></div></p>\n</div></div></div><div id='cfg-groupName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-groupName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-groupName' class='name expandable'>groupName</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. If the grid is being rendered by an <a href=\"#!/api/Ext.grid.GroupingView\" rel=\"Ext.grid.GroupingView\" class=\"docClass\">Ext.grid.GroupingView</a>, this option\nmay be used to specify the text with which to prefix the group field value in the group header line.\nSee also <a href=\"#!/api/Ext.grid.Column-cfg-groupRenderer\" rel=\"Ext.grid.Column-cfg-groupRenderer\" class=\"docClass\">groupRenderer</a> and\n<a href=\"#!/api/Ext.grid.GroupingView\" rel=\"Ext.grid.GroupingView\" class=\"docClass\">Ext.grid.GroupingView</a>.<a href=\"#!/api/Ext.grid.GroupingView-cfg-showGroupName\" rel=\"Ext.grid.GroupingView-cfg-showGroupName\" class=\"docClass\">showGroupName</a>.</p>\n</div></div></div><div id='cfg-groupRenderer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-groupRenderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-groupRenderer' class='name expandable'>groupRenderer</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. If the grid is being rendered by an <a href=\"#!/api/Ext.grid.GroupingView\" rel=\"Ext.grid.GroupingView\" class=\"docClass\">Ext.grid.GroupingView</a>, this option\nmay be used to specify the function used to format the grouping field value for display in the group\n<a href=\"#!/api/Ext.grid.Column-cfg-groupName\" rel=\"Ext.grid.Column-cfg-groupName\" class=\"docClass\">header</a>.  If a <tt><b>groupRenderer</b></tt> is not specified, the configured\n<tt><b><a href=\"#!/api/Ext.grid.Column-property-renderer\" rel=\"Ext.grid.Column-property-renderer\" class=\"docClass\">renderer</a></b></tt> will be called; if a <tt><b><a href=\"#!/api/Ext.grid.Column-property-renderer\" rel=\"Ext.grid.Column-property-renderer\" class=\"docClass\">renderer</a></b></tt> is also not specified\nthe new value of the group field will be used.</p>\n\n\n<p>The called function (either the <tt><b>groupRenderer</b></tt> or <tt><b><a href=\"#!/api/Ext.grid.Column-property-renderer\" rel=\"Ext.grid.Column-property-renderer\" class=\"docClass\">renderer</a></b></tt>) will be\npassed the following parameters:\n<div class=\"mdetail-params\"><ul>\n<li><b>v</b> : Object<p class=\"sub-desc\">The new value of the group field.</p></li>\n<li><b>unused</b> : undefined<p class=\"sub-desc\">Unused parameter.</p></li>\n<li><b>r</b> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><p class=\"sub-desc\">The Record providing the data\nfor the row which caused group change.</p></li>\n<li><b>rowIndex</b> : Number<p class=\"sub-desc\">The row index of the Record which caused group change.</p></li>\n<li><b>colIndex</b> : Number<p class=\"sub-desc\">The column index of the group field.</p></li>\n<li><b>ds</b> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><p class=\"sub-desc\">The Store which is providing the data Model.</p></li>\n</ul></div></p>\n\n\n<p>The function should return a string value.</p>\n\n</div></div></div><div id='cfg-groupable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-groupable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-groupable' class='name expandable'>groupable</a><span> : Boolean</span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. If the grid is being rendered by an <a href=\"#!/api/Ext.grid.GroupingView\" rel=\"Ext.grid.GroupingView\" class=\"docClass\">Ext.grid.GroupingView</a>, this option\nmay be used to disable the header menu item to group by the column selected. Defaults to <tt>true</tt>,\nwhich enables the header menu group option.  Set to <tt>false</tt> to disable (but still show) the\ngroup option in the header menu for the column. See also <code><a href=\"#!/api/Ext.grid.Column-cfg-groupName\" rel=\"Ext.grid.Column-cfg-groupName\" class=\"docClass\">groupName</a></code>.</p>\n</div></div></div><div id='cfg-handler' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-cfg-handler' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-cfg-handler' class='name expandable'>handler</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>A function called when the icon is clicked. ...</div><div class='long'><p>A function called when the icon is clicked.\nThe handler is passed the following parameters:<div class=\"mdetail-params\"><ul>\n<li><code>grid</code> : GridPanel<div class=\"sub-desc\">The owning GridPanel.</div></li>\n<li><code>rowIndex</code> : Number<div class=\"sub-desc\">The row index clicked on.</div></li>\n<li><code>colIndex</code> : Number<div class=\"sub-desc\">The column index clicked on.</div></li>\n<li><code>item</code> : Object<div class=\"sub-desc\">The clicked item (or this Column if multiple\n<a href=\"#!/api/Ext.grid.ActionColumn-cfg-items\" rel=\"Ext.grid.ActionColumn-cfg-items\" class=\"docClass\">items</a> were not configured).</div></li>\n<li><code>e</code> : Event<div class=\"sub-desc\">The click event.</div></li>\n</ul></div></p>\n</div></div></div><div id='cfg-header' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-header' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-header' class='name expandable'>header</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. The header text to be used as innerHTML\n(html tags are accepted) to display in the Grid view.  <b>Note</b>: to\nhave a clickable header with no text displayed use <tt>'&amp;#160;'</tt>.</p>\n</div></div></div><div id='cfg-hidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-hidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-hidden' class='name expandable'>hidden</a><span> : Boolean</span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. <tt>true</tt> to initially hide this column. Defaults to <tt>false</tt>.\nA hidden column <a href=\"#!/api/Ext.grid.GridPanel-cfg-enableColumnHide\" rel=\"Ext.grid.GridPanel-cfg-enableColumnHide\" class=\"docClass\">may be shown via the header row menu</a>.\nIf a column is never to be shown, simply do not include this column in the Column Model at all.</p>\n</div></div></div><div id='cfg-hideable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-hideable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-hideable' class='name expandable'>hideable</a><span> : Boolean</span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. Specify as <tt>false</tt> to prevent the user from hiding this column\n(defaults to true).  To disallow column hiding globally for all columns in the grid, use\n<a href=\"#!/api/Ext.grid.GridPanel-cfg-enableColumnHide\" rel=\"Ext.grid.GridPanel-cfg-enableColumnHide\" class=\"docClass\">Ext.grid.GridPanel.enableColumnHide</a> instead.</p>\n</div></div></div><div id='cfg-icon' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-cfg-icon' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-cfg-icon' class='name expandable'>icon</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The URL of an image to display as the clickable element in the column. ...</div><div class='long'><p>The URL of an image to display as the clickable element in the column.\nOptional - defaults to <code><a href=\"#!/api/Ext-property-BLANK_IMAGE_URL\" rel=\"Ext-property-BLANK_IMAGE_URL\" class=\"docClass\">Ext.BLANK_IMAGE_URL</a></code>.</p>\n</div></div></div><div id='cfg-iconCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-cfg-iconCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-cfg-iconCls' class='name expandable'>iconCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A CSS class to apply to the icon image. ...</div><div class='long'><p>A CSS class to apply to the icon image. To determine the class dynamically, configure the Column with a <code><a href=\"#!/api/Ext.grid.ActionColumn-cfg-getClass\" rel=\"Ext.grid.ActionColumn-cfg-getClass\" class=\"docClass\">getClass</a></code> function.</p>\n</div></div></div><div id='cfg-id' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-id' class='name expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. A name which identifies this column (defaults to the column's initial\nordinal position.) The <tt>id</tt> is used to create a CSS <b>class</b> name which is applied to all\ntable cells (including headers) in that column (in this context the <tt>id</tt> does not need to be\nunique). The class name takes the form of</p>\n\n<pre>x-grid3-td-<b>id</b></pre>\n\n\n<p>Header cells will also receive this class name, but will also have the class</p>\n\n<pre>x-grid3-hd</pre>\n\n\n<p>So, to target header cells, use CSS selectors such as:</p>\n\n<pre>.x-grid3-hd-row .x-grid3-td-<b>id</b></pre>\n\n\n<p>The <a href=\"#!/api/Ext.grid.GridPanel-cfg-autoExpandColumn\" rel=\"Ext.grid.GridPanel-cfg-autoExpandColumn\" class=\"docClass\">Ext.grid.GridPanel.autoExpandColumn</a> grid config option references the column via this\nunique identifier.</p>\n</div></div></div><div id='cfg-isColumn' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-isColumn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-isColumn' class='name expandable'>isColumn</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Used by ColumnModel setConfig method to avoid reprocessing a Column\nif isColumn is not set ColumnModel will recreate ...</div><div class='long'><p>Used by ColumnModel setConfig method to avoid reprocessing a Column\nif <code>isColumn</code> is not set ColumnModel will recreate a new <a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">Ext.grid.Column</a>\nDefaults to true.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-items' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-cfg-items' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-cfg-items' class='name expandable'>items</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An Array which may contain multiple icon definitions, each element of which may contain:\n\n\nicon : StringThe url of an...</div><div class='long'><p>An Array which may contain multiple icon definitions, each element of which may contain:</p>\n\n<div class=\"mdetail-params\"><ul>\n<li><code>icon</code> : String<div class=\"sub-desc\">The url of an image to display as the clickable element \nin the column.</div></li>\n<li><code>iconCls</code> : String<div class=\"sub-desc\">A CSS class to apply to the icon image.\nTo determine the class dynamically, configure the item with a <code>getClass</code> function.</div></li>\n<li><code>getClass</code> : Function<div class=\"sub-desc\">A function which returns the CSS class to apply to the icon image.\nThe function is passed the following parameters:<ul>\n    <li><b>v</b> : Object<p class=\"sub-desc\">The value of the column's configured field (if any).</p></li>\n    <li><b>metadata</b> : Object<p class=\"sub-desc\">An object in which you may set the following attributes:<ul>\n        <li><b>css</b> : String<p class=\"sub-desc\">A CSS class name to add to the cell's TD element.</p></li>\n        <li><b>attr</b> : String<p class=\"sub-desc\">An HTML attribute definition string to apply to the data container element <i>within</i> the table cell\n        (e.g. 'style=\"color:red;\"').</p></li>\n    </ul></p></li>\n    <li><b>r</b> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><p class=\"sub-desc\">The Record providing the data.</p></li>\n    <li><b>rowIndex</b> : Number<p class=\"sub-desc\">The row index..</p></li>\n    <li><b>colIndex</b> : Number<p class=\"sub-desc\">The column index.</p></li>\n    <li><b>store</b> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><p class=\"sub-desc\">The Store which is providing the data Model.</p></li>\n</ul></div></li>\n<li><code>handler</code> : Function<div class=\"sub-desc\">A function called when the icon is clicked.</div></li>\n<li><code>scope</code> : Scope<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the \n<code>handler</code> and <code>getClass</code> functions are executed. Fallback defaults are this Column's\nconfigured scope, then this Column.</div></li>\n<li><code>tooltip</code> : String<div class=\"sub-desc\">A tooltip message to be displayed on hover. \n<a href=\"#!/api/Ext.QuickTips-method-init\" rel=\"Ext.QuickTips-method-init\" class=\"docClass\">Ext.QuickTips</a> must have been initialized.</div></li>\n</ul></div>\n\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-menuDisabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-menuDisabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-menuDisabled' class='name expandable'>menuDisabled</a><span> : Boolean</span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. <tt>true</tt> to disable the column menu. Defaults to <tt>false</tt>.</p>\n</div></div></div><div id='cfg-renderer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-renderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-renderer' class='name expandable'>renderer</a><span> : Mixed</span></div><div class='description'><div class='short'>For an alternative to specifying a renderer see xtype\n\n\nOptional. ...</div><div class='long'><p>For an alternative to specifying a renderer see <code><a href=\"#!/api/Ext.grid.Column-cfg-xtype\" rel=\"Ext.grid.Column-cfg-xtype\" class=\"docClass\">xtype</a></code></p>\n\n\n<p>Optional. A renderer is an 'interceptor' method which can be used transform data (value,\nappearance, etc.) before it is rendered). This may be specified in either of three ways:\n<div class=\"mdetail-params\"><ul>\n<li>A renderer function used to return HTML markup for a cell given the cell's data value.</li>\n<li>A string which references a property name of the <a href=\"#!/api/Ext.util.Format\" rel=\"Ext.util.Format\" class=\"docClass\">Ext.util.Format</a> class which\nprovides a renderer function.</li>\n<li>An object specifying both the renderer function, and its execution scope (<tt><b>this</b></tt>\nreference) e.g.:<pre style=\"margin-left:1.2em\"><code>\n{\n    fn: this.gridRenderer,\n    scope: this\n}\n</code></pre></li></ul></div>\nIf not specified, the default renderer uses the raw data value.</p>\n\n\n<p>For information about the renderer function (passed parameters, etc.), see\n<a href=\"#!/api/Ext.grid.ColumnModel-method-setRenderer\" rel=\"Ext.grid.ColumnModel-method-setRenderer\" class=\"docClass\">Ext.grid.ColumnModel.setRenderer</a>. An example of specifying renderer function inline:</p>\n\n\n<pre><code>var companyColumn = {\n   header: 'Company Name',\n   dataIndex: 'company',\n   renderer: function(value, metaData, record, rowIndex, colIndex, store) {\n      // provide the logic depending on business rules\n      // name of your own choosing to manipulate the cell depending upon\n      // the data in the underlying Record object.\n      if (value == 'whatever') {\n          //metaData.css : String : A CSS class name to add to the TD element of the cell.\n          //metaData.attr : String : An html attribute definition string to apply to\n          //                         the data container element within the table\n          //                         cell (e.g. 'style=\"color:red;\"').\n          metaData.css = 'name-of-css-class-you-will-define';\n      }\n      return value;\n   }\n}\n</code></pre>\n\n\n<p>See also <a href=\"#!/api/Ext.grid.Column-cfg-scope\" rel=\"Ext.grid.Column-cfg-scope\" class=\"docClass\">scope</a>.</p>\n</div></div></div><div id='cfg-resizable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-resizable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-resizable' class='name expandable'>resizable</a><span> : Boolean</span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. <tt>false</tt> to disable column resizing. Defaults to <tt>true</tt>.</p>\n</div></div></div><div id='cfg-scope' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-cfg-scope' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-cfg-scope' class='name expandable'>scope</a><span> : Object</span></div><div class='description'><div class='short'>The scope (this reference) in which the handler\nand getClass fuctions are executed. ...</div><div class='long'><p>The scope (<tt><b>this</b></tt> reference) in which the <code><a href=\"#!/api/Ext.grid.ActionColumn-cfg-handler\" rel=\"Ext.grid.ActionColumn-cfg-handler\" class=\"docClass\">handler</a></code>\nand <code><a href=\"#!/api/Ext.grid.ActionColumn-cfg-getClass\" rel=\"Ext.grid.ActionColumn-cfg-getClass\" class=\"docClass\">getClass</a></code> fuctions are executed. Defaults to this Column.</p>\n<p>Overrides: <a href='#!/api/Ext.grid.Column-cfg-scope' rel='Ext.grid.Column-cfg-scope' class='docClass'>Ext.grid.Column.scope</a></p></div></div></div><div id='cfg-sortable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-sortable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-sortable' class='name expandable'>sortable</a><span> : Boolean</span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. <tt>true</tt> if sorting is to be allowed on this column.\nDefaults to the value of the <code><a href=\"#!/api/Ext.grid.ColumnModel-cfg-defaultSortable\" rel=\"Ext.grid.ColumnModel-cfg-defaultSortable\" class=\"docClass\">Ext.grid.ColumnModel.defaultSortable</a></code> property.\nWhether local/remote sorting is used is specified in <code><a href=\"#!/api/Ext.data.Store-cfg-remoteSort\" rel=\"Ext.data.Store-cfg-remoteSort\" class=\"docClass\">Ext.data.Store.remoteSort</a></code>.</p>\n</div></div></div><div id='cfg-stopSelection' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-cfg-stopSelection' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-cfg-stopSelection' class='name expandable'>stopSelection</a><span> : Boolean</span></div><div class='description'><div class='short'>Defaults to true. ...</div><div class='long'><p>Defaults to <code>true</code>. Prevent grid <i>row</i> selection upon mousedown.</p>\n</div></div></div><div id='cfg-tooltip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-cfg-tooltip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-cfg-tooltip' class='name expandable'>tooltip</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A tooltip message to be displayed on hover. ...</div><div class='long'><p>A tooltip message to be displayed on hover. <a href=\"#!/api/Ext.QuickTips-method-init\" rel=\"Ext.QuickTips-method-init\" class=\"docClass\">Ext.QuickTips</a> must have\nbeen initialized.</p>\n<p>Overrides: <a href='#!/api/Ext.grid.Column-cfg-tooltip' rel='Ext.grid.Column-cfg-tooltip' class='docClass'>Ext.grid.Column.tooltip</a></p></div></div></div><div id='cfg-width' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-width' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-width' class='name expandable'>width</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. The initial width in pixels of the column.\nThe width of each column can also be affected if any of the following are configured:</p>\n\n<div class=\"mdetail-params\"><ul>\n<li><a href=\"#!/api/Ext.grid.GridPanel\" rel=\"Ext.grid.GridPanel\" class=\"docClass\">Ext.grid.GridPanel</a>.<tt><a href=\"#!/api/Ext.grid.GridPanel-cfg-autoExpandColumn\" rel=\"Ext.grid.GridPanel-cfg-autoExpandColumn\" class=\"docClass\">autoExpandColumn</a></tt></li>\n<li><a href=\"#!/api/Ext.grid.GridView\" rel=\"Ext.grid.GridView\" class=\"docClass\">Ext.grid.GridView</a>.<tt><a href=\"#!/api/Ext.grid.GridView-cfg-forceFit\" rel=\"Ext.grid.GridView-cfg-forceFit\" class=\"docClass\">forceFit</a></tt>\n<div class=\"sub-desc\">\n<p>By specifying <tt>forceFit:true</tt>, <a href=\"#!/api/Ext.grid.Column-cfg-fixed\" rel=\"Ext.grid.Column-cfg-fixed\" class=\"docClass\">non-fixed width</a> columns will be\nre-proportioned (based on the relative initial widths) to fill the width of the grid so\nthat no horizontal scrollbar is shown.</p>\n</div></li>\n<li><a href=\"#!/api/Ext.grid.GridView\" rel=\"Ext.grid.GridView\" class=\"docClass\">Ext.grid.GridView</a>.<tt><a href=\"#!/api/Ext.grid.GridView-cfg-autoFill\" rel=\"Ext.grid.GridView-cfg-autoFill\" class=\"docClass\">autoFill</a></tt></li>\n<li><a href=\"#!/api/Ext.grid.GridPanel\" rel=\"Ext.grid.GridPanel\" class=\"docClass\">Ext.grid.GridPanel</a>.<tt><a href=\"#!/api/Ext.grid.GridPanel-cfg-minColumnWidth\" rel=\"Ext.grid.GridPanel-cfg-minColumnWidth\" class=\"docClass\">minColumnWidth</a></tt></li>\n<br><p><b>Note</b>: when the width of each column is determined, a space on the right side\nis reserved for the vertical scrollbar.  The\n<a href=\"#!/api/Ext.grid.GridView\" rel=\"Ext.grid.GridView\" class=\"docClass\">Ext.grid.GridView</a>.<tt><a href=\"#!/api/Ext.grid.GridView-cfg-scrollOffset\" rel=\"Ext.grid.GridView-cfg-scrollOffset\" class=\"docClass\">scrollOffset</a></tt>\ncan be modified to reduce or eliminate the reserved offset.</p>\n\n</ul></div></div></div></div><div id='cfg-xtype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-cfg-xtype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-cfg-xtype' class='name expandable'>xtype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. A String which references a predefined <a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">Ext.grid.Column</a> subclass\ntype which is preconfigured with an appropriate <code><a href=\"#!/api/Ext.grid.Column-property-renderer\" rel=\"Ext.grid.Column-property-renderer\" class=\"docClass\">renderer</a></code> to be easily\nconfigured into a ColumnModel. The predefined <a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">Ext.grid.Column</a> subclass types are:</p>\n\n<div class=\"mdetail-params\"><ul>\n<li><b><tt>gridcolumn</tt></b> : <a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">Ext.grid.Column</a> (<b>Default</b>)<p class=\"sub-desc\"></p></li>\n<li><b><tt>booleancolumn</tt></b> : <a href=\"#!/api/Ext.grid.BooleanColumn\" rel=\"Ext.grid.BooleanColumn\" class=\"docClass\">Ext.grid.BooleanColumn</a><p class=\"sub-desc\"></p></li>\n<li><b><tt>numbercolumn</tt></b> : <a href=\"#!/api/Ext.grid.NumberColumn\" rel=\"Ext.grid.NumberColumn\" class=\"docClass\">Ext.grid.NumberColumn</a><p class=\"sub-desc\"></p></li>\n<li><b><tt>datecolumn</tt></b> : <a href=\"#!/api/Ext.grid.DateColumn\" rel=\"Ext.grid.DateColumn\" class=\"docClass\">Ext.grid.DateColumn</a><p class=\"sub-desc\"></p></li>\n<li><b><tt>templatecolumn</tt></b> : <a href=\"#!/api/Ext.grid.TemplateColumn\" rel=\"Ext.grid.TemplateColumn\" class=\"docClass\">Ext.grid.TemplateColumn</a><p class=\"sub-desc\"></p></li>\n</ul></div>\n\n\n<p>Configuration properties for the specified <code>xtype</code> may be specified with\nthe Column configuration properties, for example:</p>\n\n\n<pre><code>var grid = new <a href=\"#!/api/Ext.grid.GridPanel\" rel=\"Ext.grid.GridPanel\" class=\"docClass\">Ext.grid.GridPanel</a>({\n    ...\n    columns: [{\n        header: 'Last Updated',\n        dataIndex: 'lastChange',\n        width: 85,\n        sortable: true,\n        //renderer: <a href=\"#!/api/Ext.util.Format-method-dateRenderer\" rel=\"Ext.util.Format-method-dateRenderer\" class=\"docClass\">Ext.util.Format.dateRenderer</a>('m/d/Y'),\n        xtype: 'datecolumn', // use xtype instead of renderer\n        format: 'M/d/Y' // configuration property for <a href=\"#!/api/Ext.grid.DateColumn\" rel=\"Ext.grid.DateColumn\" class=\"docClass\">Ext.grid.DateColumn</a>\n    }, {\n        ...\n    }]\n});\n</code></pre>\n\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-actionIdRe' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-property-actionIdRe' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-property-actionIdRe' class='name expandable'>actionIdRe</a><span> : RegExp</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>/x-action-col-(\\d+)/</code></p></div></div></div><div id='property-renderer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-property-renderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-property-renderer' class='name expandable'>renderer</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. A function which returns displayable data when passed the following parameters:</p>\n\n<div class=\"mdetail-params\"><ul>\n<li><b>value</b> : Object<p class=\"sub-desc\">The data value for the cell.</p></li>\n<li><b>metadata</b> : Object<p class=\"sub-desc\">An object in which you may set the following attributes:<ul>\n<li><b>css</b> : String<p class=\"sub-desc\">A CSS class name to add to the cell's TD element.</p></li>\n<li><b>attr</b> : String<p class=\"sub-desc\">An HTML attribute definition string to apply to the data container\nelement <i>within</i> the table cell (e.g. 'style=\"color:red;\"').</p></li></ul></p></li>\n<li><b>record</b> : Ext.data.record<p class=\"sub-desc\">The <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> from which the data was\nextracted.</p></li>\n<li><b>rowIndex</b> : Number<p class=\"sub-desc\">Row index</p></li>\n<li><b>colIndex</b> : Number<p class=\"sub-desc\">Column index</p></li>\n<li><b>store</b> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><p class=\"sub-desc\">The <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> object from which the Record\nwas extracted.</p></li>\n</ul></div>\n\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.grid.ActionColumn-method-constructor' class='name expandable'>Ext.grid.ActionColumn</a>( <span class='pre'>cfg</span> ) : <a href=\"#!/api/Ext.grid.ActionColumn\" rel=\"Ext.grid.ActionColumn\" class=\"docClass\">Ext.grid.ActionColumn</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.grid.ActionColumn\" rel=\"Ext.grid.ActionColumn\" class=\"docClass\">Ext.grid.ActionColumn</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.grid.Column-method-constructor' rel='Ext.grid.Column-method-constructor' class='docClass'>Ext.grid.Column.constructor</a></p></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Clean up. ...</div><div class='long'><p>Clean up. Remove any Editor. Remove any listeners.</p>\n<p>Overrides: <a href='#!/api/Ext.grid.Column-method-destroy' rel='Ext.grid.Column-method-destroy' class='docClass'>Ext.grid.Column.destroy</a></p></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-getCellEditor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-method-getCellEditor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-method-getCellEditor' class='name expandable'>getCellEditor</a>( <span class='pre'>rowIndex</span> ) : <a href=\"#!/api/Ext.Editor\" rel=\"Ext.Editor\" class=\"docClass\">Ext.Editor</a></div><div class='description'><div class='short'>Returns the editor defined for this column that was created to wrap the Field\nused to edit the cell. ...</div><div class='long'><p>Returns the <a href=\"#!/api/Ext.Editor\" rel=\"Ext.Editor\" class=\"docClass\">editor</a> defined for this column that was created to wrap the <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Field</a>\nused to edit the cell.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rowIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The row index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Editor\" rel=\"Ext.Editor\" class=\"docClass\">Ext.Editor</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getEditor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-method-getEditor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-method-getEditor' class='name expandable'>getEditor</a>( <span class='pre'>rowIndex</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rowIndex</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-processEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.ActionColumn'>Ext.grid.ActionColumn</span><br/><a href='source/Column.html#Ext-grid-ActionColumn-method-processEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ActionColumn-method-processEvent' class='name expandable'>processEvent</a>( <span class='pre'>name, e, grid, rowIndex, colIndex</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Process and refire events routed from the GridView's processEvent method. ...</div><div class='long'><p>Process and refire events routed from the GridView's processEvent method.\nAlso fires any configured click handlers. By default, cancels the mousedown event to prevent selection.\nReturns the event handler's status to allow cancelling of GridView's bubbling process.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>grid</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>rowIndex</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>colIndex</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.grid.Column-method-processEvent' rel='Ext.grid.Column-method-processEvent' class='docClass'>Ext.grid.Column.processEvent</a></p></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setEditor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-method-setEditor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-method-setEditor' class='name expandable'>setEditor</a>( <span class='pre'>editor</span> )</div><div class='description'><div class='short'>Sets a new editor for this column. ...</div><div class='long'><p>Sets a new editor for this column.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>editor</span> : <a href=\"#!/api/Ext.Editor\" rel=\"Ext.Editor\" class=\"docClass\">Ext.Editor</a>/<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a><div class='sub-desc'><p>The editor to set</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-click' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-event-click' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-event-click' class='name expandable'>click</a>( <span class='pre'>this, The, rowIndex, e</span> )</div><div class='description'><div class='short'>Fires when this Column is clicked. ...</div><div class='long'><p>Fires when this Column is clicked.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Column<div class='sub-desc'>\n</div></li><li><span class='pre'>The</span> : Grid<div class='sub-desc'><p>owning GridPanel</p>\n</div></li><li><span class='pre'>rowIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-contextmenu' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-event-contextmenu' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-event-contextmenu' class='name expandable'>contextmenu</a>( <span class='pre'>this, The, rowIndex, e</span> )</div><div class='description'><div class='short'>Fires when this Column is right clicked. ...</div><div class='long'><p>Fires when this Column is right clicked.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Column<div class='sub-desc'>\n</div></li><li><span class='pre'>The</span> : Grid<div class='sub-desc'><p>owning GridPanel</p>\n</div></li><li><span class='pre'>rowIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-dblclick' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-event-dblclick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-event-dblclick' class='name expandable'>dblclick</a>( <span class='pre'>this, The, rowIndex, e</span> )</div><div class='description'><div class='short'>Fires when this Column is double clicked. ...</div><div class='long'><p>Fires when this Column is double clicked.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Column<div class='sub-desc'>\n</div></li><li><span class='pre'>The</span> : Grid<div class='sub-desc'><p>owning GridPanel</p>\n</div></li><li><span class='pre'>rowIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-mousedown' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.Column' rel='Ext.grid.Column' class='defined-in docClass'>Ext.grid.Column</a><br/><a href='source/Column.html#Ext-grid-Column-event-mousedown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.Column-event-mousedown' class='name expandable'>mousedown</a>( <span class='pre'>this, The, rowIndex, e</span> )</div><div class='description'><div class='short'>Fires when this Column receives a mousedown event. ...</div><div class='long'><p>Fires when this Column receives a mousedown event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Column<div class='sub-desc'>\n</div></li><li><span class='pre'>The</span> : Grid<div class='sub-desc'><p>owning GridPanel</p>\n</div></li><li><span class='pre'>rowIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable","Ext.grid.Column"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"Column.html#Ext-grid-ActionColumn","filename":"Column.js"}],"linenr":464,"members":{"property":[{"tagname":"property","owner":"Ext.grid.ActionColumn","meta":{"private":true},"name":"actionIdRe","id":"property-actionIdRe"},{"tagname":"property","owner":"Ext.grid.Column","meta":{},"name":"renderer","id":"property-renderer"}],"cfg":[{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"align","id":"cfg-align"},{"tagname":"cfg","owner":"Ext.grid.ActionColumn","meta":{},"name":"altText","id":"cfg-altText"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"css","id":"cfg-css"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"dataIndex","id":"cfg-dataIndex"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"editable","id":"cfg-editable"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"editor","id":"cfg-editor"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"emptyGroupText","id":"cfg-emptyGroupText"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"fixed","id":"cfg-fixed"},{"tagname":"cfg","owner":"Ext.grid.ActionColumn","meta":{},"name":"getClass","id":"cfg-getClass"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"groupName","id":"cfg-groupName"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"groupRenderer","id":"cfg-groupRenderer"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"groupable","id":"cfg-groupable"},{"tagname":"cfg","owner":"Ext.grid.ActionColumn","meta":{},"name":"handler","id":"cfg-handler"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"header","id":"cfg-header"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"hidden","id":"cfg-hidden"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"hideable","id":"cfg-hideable"},{"tagname":"cfg","owner":"Ext.grid.ActionColumn","meta":{},"name":"icon","id":"cfg-icon"},{"tagname":"cfg","owner":"Ext.grid.ActionColumn","meta":{},"name":"iconCls","id":"cfg-iconCls"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"id","id":"cfg-id"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{"private":true},"name":"isColumn","id":"cfg-isColumn"},{"tagname":"cfg","owner":"Ext.grid.ActionColumn","meta":{},"name":"items","id":"cfg-items"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"menuDisabled","id":"cfg-menuDisabled"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"renderer","id":"cfg-renderer"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"resizable","id":"cfg-resizable"},{"tagname":"cfg","owner":"Ext.grid.ActionColumn","meta":{},"name":"scope","id":"cfg-scope"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"sortable","id":"cfg-sortable"},{"tagname":"cfg","owner":"Ext.grid.ActionColumn","meta":{},"name":"stopSelection","id":"cfg-stopSelection"},{"tagname":"cfg","owner":"Ext.grid.ActionColumn","meta":{},"name":"tooltip","id":"cfg-tooltip"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"width","id":"cfg-width"},{"tagname":"cfg","owner":"Ext.grid.Column","meta":{},"name":"xtype","id":"cfg-xtype"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.grid.ActionColumn","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.grid.ActionColumn","meta":{"private":true},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.grid.Column","meta":{},"name":"getCellEditor","id":"method-getCellEditor"},{"tagname":"method","owner":"Ext.grid.Column","meta":{"private":true},"name":"getEditor","id":"method-getEditor"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.grid.ActionColumn","meta":{"private":true},"name":"processEvent","id":"method-processEvent"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.grid.Column","meta":{},"name":"setEditor","id":"method-setEditor"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"}],"event":[{"tagname":"event","owner":"Ext.grid.Column","meta":{},"name":"click","id":"event-click"},{"tagname":"event","owner":"Ext.grid.Column","meta":{},"name":"contextmenu","id":"event-contextmenu"},{"tagname":"event","owner":"Ext.grid.Column","meta":{},"name":"dblclick","id":"event-dblclick"},{"tagname":"event","owner":"Ext.grid.Column","meta":{},"name":"mousedown","id":"event-mousedown"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.grid.ActionColumn","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.grid.ActionColumn","mixins":[],"mixedInto":[]});