/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.interactions.InvalidCoordinatesException;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.internal.Coordinates;

public class HtmlUnitMouse
implements Mouse {
    private final HtmlUnitDriver parent;
    private final HtmlUnitKeyboard keyboard;
    private DomElement currentActiveElement;

    public HtmlUnitMouse(HtmlUnitDriver parent, HtmlUnitKeyboard keyboard) {
        this.parent = parent;
        this.keyboard = keyboard;
    }

    private DomElement getElementForOperation(Coordinates potentialCoordinates) {
        if (potentialCoordinates != null) {
            return (DomElement)potentialCoordinates.getAuxiliary();
        }
        if (this.currentActiveElement == null) {
            throw new InvalidCoordinatesException("About to perform an interaction that relies on the active element, but there isn't one.");
        }
        return this.currentActiveElement;
    }

    @Override
    public void click(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent.click(element, false);
    }

    void click(DomElement element, boolean directClick) {
        if (!element.isDisplayed()) {
            throw new ElementNotInteractableException("You may only interact with visible elements");
        }
        this.moveOutIfNeeded(element);
        try {
            element.mouseOver();
            element.mouseMove();
            element.click(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed() || directClick && element instanceof HtmlOption, this.keyboard.isAltPressed());
            this.updateActiveElement(element);
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
        catch (ScriptException e) {
            System.out.println(e.getMessage());
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SocketTimeoutException) {
                throw new TimeoutException(cause);
            }
            throw e;
        }
    }

    private void moveOutIfNeeded(DomElement element) {
        try {
            if (this.currentActiveElement != element) {
                if (this.currentActiveElement != null) {
                    this.currentActiveElement.mouseOver(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                    this.currentActiveElement.mouseOut(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                    this.currentActiveElement.blur();
                }
                if (element != null) {
                    element.mouseMove(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                    element.mouseOver(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                }
            }
        }
        catch (ScriptException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private void updateActiveElement(DomElement element) {
        if (element != null) {
            this.currentActiveElement = element;
        }
    }

    @Override
    public void doubleClick(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent.doubleClick(element);
    }

    void doubleClick(DomElement element) {
        this.moveOutIfNeeded(element);
        try {
            element.dblClick(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed());
            this.updateActiveElement(element);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void contextClick(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.moveOutIfNeeded(element);
        element.rightClick(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed());
        this.updateActiveElement(element);
    }

    @Override
    public void mouseDown(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent.mouseDown(element);
    }

    void mouseDown(DomElement element) {
        this.moveOutIfNeeded(element);
        element.mouseDown(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
        this.updateActiveElement(element);
    }

    @Override
    public void mouseUp(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent.mouseUp(element);
    }

    void mouseUp(DomElement element) {
        this.moveOutIfNeeded(element);
        element.mouseUp(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
        this.updateActiveElement(element);
    }

    @Override
    public void mouseMove(Coordinates elementCoordinates) {
        DomElement element = (DomElement)elementCoordinates.getAuxiliary();
        this.parent.mouseMove(element);
    }

    void mouseMove(DomElement element) {
        this.moveOutIfNeeded(element);
        this.updateActiveElement(element);
    }

    @Override
    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        throw new UnsupportedOperationException("Moving to arbitrary X,Y coordinates not supported.");
    }
}

