# Generated by default/object.tt
package Paws::LookoutMetrics::AnomalyGroup;
  use Moose;
  has AnomalyGroupId => (is => 'ro', isa => 'Str');
  has AnomalyGroupScore => (is => 'ro', isa => 'Num');
  has EndTime => (is => 'ro', isa => 'Str');
  has MetricLevelImpactList => (is => 'ro', isa => 'ArrayRef[Paws::LookoutMetrics::MetricLevelImpact]');
  has PrimaryMetricName => (is => 'ro', isa => 'Str');
  has StartTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::AnomalyGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::AnomalyGroup object:

  $service_obj->Method(Att1 => { AnomalyGroupId => $value, ..., StartTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::AnomalyGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->AnomalyGroupId

=head1 DESCRIPTION

A group of anomalous metrics

=head1 ATTRIBUTES


=head2 AnomalyGroupId => Str

The ID of the anomaly group.


=head2 AnomalyGroupScore => Num

The severity score of the group.


=head2 EndTime => Str

The end time for the group.


=head2 MetricLevelImpactList => ArrayRef[L<Paws::LookoutMetrics::MetricLevelImpact>]

A list of measures affected by the anomaly.


=head2 PrimaryMetricName => Str

The name of the primary affected measure for the group.


=head2 StartTime => Str

The start time for the group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

