/*
 * Generated by util/mkerr.pl DO NOT EDIT
 * Copyright 1995-2016 The OpenSSL Project Authors. All Rights Reserved.
 *
 * Licensed under the OpenSSL license (the "License").  You may not use
 * this file except in compliance with the License.  You can obtain a copy
 * in the file LICENSE in the source distribution or at
 * https://www.openssl.org/source/license.html
 */

#include <stdio.h>
#include <openssl/err.h>
#include "internal/dso.h"

/* BEGIN ERROR CODES */
#ifndef OPENSSL_NO_ERR

# define ERR_FUNC(func) ERR_PACK(ERR_LIB_DSO,func,0)
# define ERR_REASON(reason) ERR_PACK(ERR_LIB_DSO,0,reason)

static ERR_STRING_DATA DSO_str_functs[] = {
    {ERR_FUNC(DSO_F_DLFCN_BIND_FUNC), "dlfcn_bind_func"},
    {ERR_FUNC(DSO_F_DLFCN_LOAD), "dlfcn_load"},
    {ERR_FUNC(DSO_F_DLFCN_MERGER), "dlfcn_merger"},
    {ERR_FUNC(DSO_F_DLFCN_NAME_CONVERTER), "dlfcn_name_converter"},
    {ERR_FUNC(DSO_F_DLFCN_UNLOAD), "dlfcn_unload"},
    {ERR_FUNC(DSO_F_DL_BIND_FUNC), "dl_bind_func"},
    {ERR_FUNC(DSO_F_DL_LOAD), "dl_load"},
    {ERR_FUNC(DSO_F_DL_MERGER), "dl_merger"},
    {ERR_FUNC(DSO_F_DL_NAME_CONVERTER), "dl_name_converter"},
    {ERR_FUNC(DSO_F_DL_UNLOAD), "dl_unload"},
    {ERR_FUNC(DSO_F_DSO_BIND_FUNC), "DSO_bind_func"},
    {ERR_FUNC(DSO_F_DSO_CONVERT_FILENAME), "DSO_convert_filename"},
    {ERR_FUNC(DSO_F_DSO_CTRL), "DSO_ctrl"},
    {ERR_FUNC(DSO_F_DSO_FREE), "DSO_free"},
    {ERR_FUNC(DSO_F_DSO_GET_FILENAME), "DSO_get_filename"},
    {ERR_FUNC(DSO_F_DSO_GLOBAL_LOOKUP), "DSO_global_lookup"},
    {ERR_FUNC(DSO_F_DSO_LOAD), "DSO_load"},
    {ERR_FUNC(DSO_F_DSO_MERGE), "DSO_merge"},
    {ERR_FUNC(DSO_F_DSO_NEW_METHOD), "DSO_new_method"},
    {ERR_FUNC(DSO_F_DSO_PATHBYADDR), "DSO_pathbyaddr"},
    {ERR_FUNC(DSO_F_DSO_SET_FILENAME), "DSO_set_filename"},
    {ERR_FUNC(DSO_F_DSO_UP_REF), "DSO_up_ref"},
    {ERR_FUNC(DSO_F_VMS_BIND_SYM), "vms_bind_sym"},
    {ERR_FUNC(DSO_F_VMS_LOAD), "vms_load"},
    {ERR_FUNC(DSO_F_VMS_MERGER), "vms_merger"},
    {ERR_FUNC(DSO_F_VMS_UNLOAD), "vms_unload"},
    {ERR_FUNC(DSO_F_WIN32_BIND_FUNC), "win32_bind_func"},
    {ERR_FUNC(DSO_F_WIN32_GLOBALLOOKUP), "win32_globallookup"},
    {ERR_FUNC(DSO_F_WIN32_JOINER), "win32_joiner"},
    {ERR_FUNC(DSO_F_WIN32_LOAD), "win32_load"},
    {ERR_FUNC(DSO_F_WIN32_MERGER), "win32_merger"},
    {ERR_FUNC(DSO_F_WIN32_NAME_CONVERTER), "win32_name_converter"},
    {ERR_FUNC(DSO_F_WIN32_PATHBYADDR), "win32_pathbyaddr"},
    {ERR_FUNC(DSO_F_WIN32_SPLITTER), "win32_splitter"},
    {ERR_FUNC(DSO_F_WIN32_UNLOAD), "win32_unload"},
    {0, NULL}
};

static ERR_STRING_DATA DSO_str_reasons[] = {
    {ERR_REASON(DSO_R_CTRL_FAILED), "control command failed"},
    {ERR_REASON(DSO_R_DSO_ALREADY_LOADED), "dso already loaded"},
    {ERR_REASON(DSO_R_EMPTY_FILE_STRUCTURE), "empty file structure"},
    {ERR_REASON(DSO_R_FAILURE), "failure"},
    {ERR_REASON(DSO_R_FILENAME_TOO_BIG), "filename too big"},
    {ERR_REASON(DSO_R_FINISH_FAILED), "cleanup method function failed"},
    {ERR_REASON(DSO_R_INCORRECT_FILE_SYNTAX), "incorrect file syntax"},
    {ERR_REASON(DSO_R_LOAD_FAILED), "could not load the shared library"},
    {ERR_REASON(DSO_R_NAME_TRANSLATION_FAILED), "name translation failed"},
    {ERR_REASON(DSO_R_NO_FILENAME), "no filename"},
    {ERR_REASON(DSO_R_NULL_HANDLE), "a null shared library handle was used"},
    {ERR_REASON(DSO_R_SET_FILENAME_FAILED), "set filename failed"},
    {ERR_REASON(DSO_R_STACK_ERROR), "the meth_data stack is corrupt"},
    {ERR_REASON(DSO_R_SYM_FAILURE),
     "could not bind to the requested symbol name"},
    {ERR_REASON(DSO_R_UNLOAD_FAILED), "could not unload the shared library"},
    {ERR_REASON(DSO_R_UNSUPPORTED), "functionality not supported"},
    {0, NULL}
};

#endif

int ERR_load_DSO_strings(void)
{
#ifndef OPENSSL_NO_ERR

    if (ERR_func_error_string(DSO_str_functs[0].error) == NULL) {
        ERR_load_strings(0, DSO_str_functs);
        ERR_load_strings(0, DSO_str_reasons);
    }
#endif
    return 1;
}
