# This Makefile.PL for Sodium-FFI was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Sodium is a modern, easy-to-use software library for encryption, decryption, signatures, password hashing, and more.",
  "AUTHOR" => "Chase Whitener <capoeirab\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Alien::Base::Wrapper" => 0,
    "Alien::Sodium" => "2.00",
    "ExtUtils::MakeMaker" => 0,
    "FFI::Build::MM" => "0.83"
  },
  "DISTNAME" => "Sodium-FFI",
  "LICENSE" => "perl",
  "NAME" => "Sodium::FFI",
  "PREREQ_PM" => {
    "Alien::Base::Wrapper" => 0,
    "Alien::Sodium" => "2.000",
    "Carp" => 0,
    "Cwd" => 0,
    "Exporter" => "5.57",
    "FFI::Platypus" => "1.00",
    "File::Basename" => 0,
    "File::ShareDir" => 0,
    "File::Spec" => 0,
    "Path::Tiny" => 0,
    "Ref::Util" => 0,
    "Sub::Util" => 0,
    "feature" => 0,
    "strict" => 0,
    "utf8" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "Test::More" => "0.88"
  },
  "VERSION" => "0.009",
  "test" => {
    "TESTS" => "t/*.t t/aead/*.t t/pub_key_crypto/*.t"
  }
);

my %FallbackPrereqs = (
  "Alien::Base::Wrapper" => 0,
  "Alien::Sodium" => "2.000",
  "Carp" => 0,
  "Cwd" => 0,
  "Exporter" => "5.57",
  "ExtUtils::MakeMaker" => 0,
  "FFI::Platypus" => "1.00",
  "File::Basename" => 0,
  "File::ShareDir" => 0,
  "File::Spec" => 0,
  "Path::Tiny" => 0,
  "Ref::Util" => 0,
  "Sub::Util" => 0,
  "Test::More" => "0.88",
  "feature" => 0,
  "strict" => 0,
  "utf8" => 0,
  "warnings" => 0
);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
use FFI::Build::MM 0.83;
my $fbmm = FFI::Build::MM->new;
%WriteMakefileArgs = $fbmm->mm_args(%WriteMakefileArgs);
# END code inserted by Dist::Zilla::Plugin::FFI::Build

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
BEGIN {
  # append to any existing postamble.
  if(my $old = MY->can('postamble'))
  {
    no warnings 'redefine';
    *MY::postamble = sub {
      $old->(@_) .
      "\n" .
      $fbmm->mm_postamble;
    };
  }
  else
  {
    *MY::postamble = sub {
      $fbmm->mm_postamble;
    };
  }
}
# END code inserted by Dist::Zilla::Plugin::FFI::Build
