# Generated by default/object.tt
package Paws::AutoScaling::MixedInstancesPolicy;
  use Moose;
  has InstancesDistribution => (is => 'ro', isa => 'Paws::AutoScaling::InstancesDistribution');
  has LaunchTemplate => (is => 'ro', isa => 'Paws::AutoScaling::LaunchTemplate');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AutoScaling::MixedInstancesPolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AutoScaling::MixedInstancesPolicy object:

  $service_obj->Method(Att1 => { InstancesDistribution => $value, ..., LaunchTemplate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AutoScaling::MixedInstancesPolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->InstancesDistribution

=head1 DESCRIPTION

Describes a mixed instances policy for an Auto Scaling group. With
mixed instances, your Auto Scaling group can provision a combination of
On-Demand Instances and Spot Instances across multiple instance types.
For more information, see Auto Scaling groups with multiple instance
types and purchase options
(https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html)
in the I<Amazon EC2 Auto Scaling User Guide>.

You can create a mixed instances policy for a new Auto Scaling group,
or you can create it for an existing group by updating the group to
specify C<MixedInstancesPolicy> as the top-level property instead of a
launch configuration or launch template.

=head1 ATTRIBUTES


=head2 InstancesDistribution => L<Paws::AutoScaling::InstancesDistribution>

Specifies the instances distribution. If not provided, the value for
each property in C<InstancesDistribution> uses a default value.


=head2 LaunchTemplate => L<Paws::AutoScaling::LaunchTemplate>

Specifies the launch template to use and optionally the instance types
(overrides) that are used to provision EC2 instances to fulfill
On-Demand and Spot capacities. Required when creating a mixed instances
policy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

