# Generated by default/object.tt
package Paws::RedShift::VpcEndpoint;
  use Moose;
  has NetworkInterfaces => (is => 'ro', isa => 'ArrayRef[Paws::RedShift::NetworkInterface]', request_name => 'NetworkInterface', traits => ['NameInRequest']);
  has VpcEndpointId => (is => 'ro', isa => 'Str');
  has VpcId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::RedShift::VpcEndpoint

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::RedShift::VpcEndpoint object:

  $service_obj->Method(Att1 => { NetworkInterfaces => $value, ..., VpcId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::RedShift::VpcEndpoint object:

  $result = $service_obj->Method(...);
  $result->Att1->NetworkInterfaces

=head1 DESCRIPTION

The connection endpoint for connecting to an Amazon Redshift cluster
through the proxy.

=head1 ATTRIBUTES


=head2 NetworkInterfaces => ArrayRef[L<Paws::RedShift::NetworkInterface>]

One or more network interfaces of the endpoint. Also known as an
interface endpoint.


=head2 VpcEndpointId => Str

The connection endpoint ID for connecting an Amazon Redshift cluster
through the proxy.


=head2 VpcId => Str

The VPC identifier that the endpoint is associated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::RedShift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

