/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntPredicate;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSingletonSet;

public class SameNameTest
extends NodeTest
implements QNameTest {
    private NodeInfo origin;

    public SameNameTest(NodeInfo origin) {
        this.origin = origin;
    }

    public int getNodeKind() {
        return this.origin.getNodeKind();
    }

    public UType getUType() {
        return UType.fromTypeCode(this.origin.getNodeKind());
    }

    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        if (nodeKind != this.origin.getNodeKind()) {
            return false;
        }
        if (name.hasFingerprint() && this.origin.hasFingerprint()) {
            return name.getFingerprint() == this.origin.getFingerprint();
        }
        return name.hasURI(this.origin.getURI()) && name.getLocalPart().equals(this.origin.getLocalPart());
    }

    public IntPredicate getMatcher(final NodeVectorTree tree) {
        final byte[] nodeKindArray = tree.getNodeKindArray();
        final int[] nameCodeArray = tree.getNameCodeArray();
        return new IntPredicate(){

            public boolean matches(int nodeNr) {
                int k = nodeKindArray[nodeNr];
                if (k == 4) {
                    k = 3;
                }
                if (k != SameNameTest.this.origin.getNodeKind()) {
                    return false;
                }
                if (SameNameTest.this.origin.hasFingerprint()) {
                    return (nameCodeArray[nodeNr] & 0xFFFFF) == SameNameTest.this.origin.getFingerprint();
                }
                return Navigator.haveSameName(tree.getNode(nodeNr), SameNameTest.this.origin);
            }
        };
    }

    public boolean matchesNode(NodeInfo node) {
        return node == this.origin || node.getNodeKind() == this.origin.getNodeKind() && Navigator.haveSameName(node, this.origin);
    }

    public boolean matches(StructuredQName qname) {
        return NameOfNode.makeName(this.origin).getStructuredQName().equals(qname);
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getFingerprint() {
        if (this.origin.hasFingerprint()) {
            return this.origin.getFingerprint();
        }
        NamePool pool = this.origin.getConfiguration().getNamePool();
        return pool.allocateFingerprint(this.origin.getURI(), this.origin.getLocalPart());
    }

    public int getPrimitiveType() {
        return this.origin.getNodeKind();
    }

    public int getNodeKindMask() {
        return 1 << this.origin.getNodeKind();
    }

    public IntSet getRequiredNodeNames() {
        return new IntSingletonSet(this.getFingerprint());
    }

    public String getNamespaceURI() {
        return this.origin.getURI();
    }

    public String getLocalPart() {
        return this.origin.getLocalPart();
    }

    public String toString() {
        switch (this.origin.getNodeKind()) {
            case 1: {
                return "element(" + NameOfNode.makeName(this.origin).getStructuredQName().getEQName() + ")";
            }
            case 2: {
                return "attribute(" + NameOfNode.makeName(this.origin).getStructuredQName().getEQName() + ")";
            }
            case 7: {
                return "processing-instruction(" + this.origin.getLocalPart() + ')';
            }
            case 13: {
                return "namespace-node(" + this.origin.getLocalPart() + ')';
            }
            case 8: {
                return "comment()";
            }
            case 9: {
                return "document-node()";
            }
            case 3: {
                return "text()";
            }
        }
        return "***";
    }

    public int hashCode() {
        return this.origin.getNodeKind() << 20 ^ this.origin.getURI().hashCode() ^ this.origin.getLocalPart().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof SameNameTest && this.matchesNode(((SameNameTest)other).origin);
    }

    public NameTest getEquivalentNameTest() {
        return new NameTest(this.origin.getNodeKind(), this.origin.getURI(), this.origin.getLocalPart(), this.origin.getConfiguration().getNamePool());
    }

    public String generateJavaScriptNameTest(int targetVersion) {
        return "false";
    }

    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) throws XPathException {
        throw new XPathException("Cannot generate JS code for a SameNameTest", "SXJS0001");
    }
}

