# Generated by default/object.tt
package Paws::CodeBuild::ProjectSource;
  use Moose;
  has Auth => (is => 'ro', isa => 'Paws::CodeBuild::SourceAuth', request_name => 'auth', traits => ['NameInRequest']);
  has Buildspec => (is => 'ro', isa => 'Str', request_name => 'buildspec', traits => ['NameInRequest']);
  has BuildStatusConfig => (is => 'ro', isa => 'Paws::CodeBuild::BuildStatusConfig', request_name => 'buildStatusConfig', traits => ['NameInRequest']);
  has GitCloneDepth => (is => 'ro', isa => 'Int', request_name => 'gitCloneDepth', traits => ['NameInRequest']);
  has GitSubmodulesConfig => (is => 'ro', isa => 'Paws::CodeBuild::GitSubmodulesConfig', request_name => 'gitSubmodulesConfig', traits => ['NameInRequest']);
  has InsecureSsl => (is => 'ro', isa => 'Bool', request_name => 'insecureSsl', traits => ['NameInRequest']);
  has Location => (is => 'ro', isa => 'Str', request_name => 'location', traits => ['NameInRequest']);
  has ReportBuildStatus => (is => 'ro', isa => 'Bool', request_name => 'reportBuildStatus', traits => ['NameInRequest']);
  has SourceIdentifier => (is => 'ro', isa => 'Str', request_name => 'sourceIdentifier', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeBuild::ProjectSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeBuild::ProjectSource object:

  $service_obj->Method(Att1 => { Auth => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeBuild::ProjectSource object:

  $result = $service_obj->Method(...);
  $result->Att1->Auth

=head1 DESCRIPTION

Information about the build input source code for the build project.

=head1 ATTRIBUTES


=head2 Auth => L<Paws::CodeBuild::SourceAuth>

Information about the authorization settings for CodeBuild to access
the source code to be built.

This information is for the CodeBuild console's use only. Your code
should not get or set this information directly.


=head2 Buildspec => Str

The buildspec file declaration to use for the builds in this build
project.

If this value is set, it can be either an inline buildspec definition,
the path to an alternate buildspec file relative to the value of the
built-in C<CODEBUILD_SRC_DIR> environment variable, or the path to an
S3 bucket. The bucket must be in the same Region as the build project.
Specify the buildspec file using its ARN (for example,
C<arn:aws:s3:::my-codebuild-sample2/buildspec.yml>). If this value is
not provided or is set to an empty string, the source code must contain
a buildspec file in its root directory. For more information, see
Buildspec File Name and Storage Location
(https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage).


=head2 BuildStatusConfig => L<Paws::CodeBuild::BuildStatusConfig>

Contains information that defines how the build project reports the
build status to the source provider. This option is only used when the
source provider is C<GITHUB>, C<GITHUB_ENTERPRISE>, or C<BITBUCKET>.


=head2 GitCloneDepth => Int

Information about the Git clone depth for the build project.


=head2 GitSubmodulesConfig => L<Paws::CodeBuild::GitSubmodulesConfig>

Information about the Git submodules configuration for the build
project.


=head2 InsecureSsl => Bool

Enable this flag to ignore SSL warnings while connecting to the project
source code.


=head2 Location => Str

Information about the location of the source code to be built. Valid
values include:

=over

=item *

For source code settings that are specified in the source action of a
pipeline in CodePipeline, C<location> should not be specified. If it is
specified, CodePipeline ignores it. This is because CodePipeline uses
the settings in a pipeline's source action instead of this value.

=item *

For source code in an CodeCommit repository, the HTTPS clone URL to the
repository that contains the source code and the buildspec file (for
example,
C<https://git-codecommit.E<lt>region-IDE<gt>.amazonaws.com/v1/repos/E<lt>repo-nameE<gt>>).

=item *

For source code in an Amazon S3 input bucket, one of the following.

=over

=item *

The path to the ZIP file that contains the source code (for example,
C<E<lt>bucket-nameE<gt>/E<lt>pathE<gt>/E<lt>object-nameE<gt>.zip>).

=item *

The path to the folder that contains the source code (for example,
C<E<lt>bucket-nameE<gt>/E<lt>path-to-source-codeE<gt>/E<lt>folderE<gt>/>).

=back

=item *

For source code in a GitHub repository, the HTTPS clone URL to the
repository that contains the source and the buildspec file. You must
connect your account to your GitHub account. Use the CodeBuild console
to start creating a build project. When you use the console to connect
(or reconnect) with GitHub, on the GitHub B<Authorize application>
page, for B<Organization access>, choose B<Request access> next to each
repository you want to allow CodeBuild to have access to, and then
choose B<Authorize application>. (After you have connected to your
GitHub account, you do not need to finish creating the build project.
You can leave the CodeBuild console.) To instruct CodeBuild to use this
connection, in the C<source> object, set the C<auth> object's C<type>
value to C<OAUTH>.

=item *

For source code in a Bitbucket repository, the HTTPS clone URL to the
repository that contains the source and the buildspec file. You must
connect your Amazon Web Services account to your Bitbucket account. Use
the CodeBuild console to start creating a build project. When you use
the console to connect (or reconnect) with Bitbucket, on the Bitbucket
B<Confirm access to your account> page, choose B<Grant access>. (After
you have connected to your Bitbucket account, you do not need to finish
creating the build project. You can leave the CodeBuild console.) To
instruct CodeBuild to use this connection, in the C<source> object, set
the C<auth> object's C<type> value to C<OAUTH>.

=back

If you specify C<CODEPIPELINE> for the C<Type> property, don't specify
this property. For all of the other types, you must specify
C<Location>.


=head2 ReportBuildStatus => Bool

Set to true to report the status of a build's start and finish to your
source provider. This option is valid only when your source provider is
GitHub, GitHub Enterprise, or Bitbucket. If this is set and you use a
different source provider, an C<invalidInputException> is thrown.

To be able to report the build status to the source provider, the user
associated with the source provider must have write access to the repo.
If the user does not have write access, the build status cannot be
updated. For more information, see Source provider access
(https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html)
in the I<CodeBuild User Guide>.

The status of a build triggered by a webhook is always reported to your
source provider.


=head2 SourceIdentifier => Str

An identifier for this project source. The identifier can only contain
alphanumeric characters and underscores, and must be less than 128
characters in length.


=head2 B<REQUIRED> Type => Str

The type of repository that contains the source code to be built. Valid
values include:

=over

=item *

C<BITBUCKET>: The source code is in a Bitbucket repository.

=item *

C<CODECOMMIT>: The source code is in an CodeCommit repository.

=item *

C<CODEPIPELINE>: The source code settings are specified in the source
action of a pipeline in CodePipeline.

=item *

C<GITHUB>: The source code is in a GitHub or GitHub Enterprise Cloud
repository.

=item *

C<GITHUB_ENTERPRISE>: The source code is in a GitHub Enterprise Server
repository.

=item *

C<NO_SOURCE>: The project does not have input source code.

=item *

C<S3>: The source code is in an Amazon S3 bucket.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeBuild>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

