#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"


MODULE = Unicode::Property::XS      PACKAGE = Unicode::Property::XS

int
Legal(ucs_char_value)
        unsigned int ucs_char_value;
    PREINIT:
        int ord_low;
    CODE:
        ord_low = ucs_char_value % 0x10000;
        if ((ucs_char_value >=   0xD800 && ucs_char_value <=  0xDFFF) ||
            (ucs_char_value >=   0xFDD0 && ucs_char_value <=  0xFDEF) ||
            (ucs_char_value >=  0x40000 && ucs_char_value <= 0xE0000) ||
            (ucs_char_value >=  0xE01F0 && ucs_char_value <= 0xEFFFF) || /* 0xE0001 .. E01EF */
            (ord_low        >=   0xFFFE && ord_low        <=  0xFFFF) ||
            (ucs_char_value >= 0x110000)) {
            RETVAL = 0;
        } else {
            RETVAL = 1;
        }
    OUTPUT:
        RETVAL





void
L(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,0,0,11,12,1,1,1,
        1,1,1,13,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,14,1,15,16,1,1,1,1,1,
        1,1,1,1,1,17,0,0,0,0,0,0,0,0,18,19,
        20,21,22,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,23,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,24,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,254,255,255,7,254,255,255,7,
        0,0,0,0,0,4,32,4,255,255,127,255,255,255,127,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,3,0,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,195,255,3,0,31,64,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,
        64,215,255,255,251,255,255,255,255,127,255,255,255,255,191,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        3,252,255,255,255,255,255,255,255,127,255,255,255,255,255,3,
        255,255,0,0,0,0,254,255,255,255,127,2,254,255,255,255,
        255,0,0,0,0,0,0,0,0,0,255,255,255,7,7,0,
        0,0,0,0,254,255,255,7,255,7,0,0,0,192,254,255,
        255,255,255,255,255,255,255,255,255,255,47,0,96,192,0,156,
        0,0,253,255,255,255,0,0,0,224,255,255,255,63,0,0,
        255,255,255,255,63,0,2,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        240,255,255,255,255,255,255,35,0,0,1,255,3,0,0,32,
        224,159,249,255,255,253,197,35,0,64,0,176,3,0,3,0,
        224,135,249,255,255,253,109,3,0,0,0,94,0,0,28,0,
        224,191,251,255,255,253,237,35,0,0,1,0,3,0,0,0,
        224,159,249,255,255,253,237,35,0,0,0,176,3,0,2,0,
        232,199,61,214,24,199,255,3,0,0,0,0,0,0,0,0},
        {
        224,223,253,255,255,253,239,3,0,0,0,0,3,0,0,0,
        224,223,253,255,255,253,239,35,0,0,0,64,3,0,0,0,
        224,223,253,255,255,253,255,3,0,0,0,0,3,0,0,0,
        224,255,127,252,255,255,251,47,127,0,0,0,0,0,0,0,
        254,255,255,255,255,255,13,0,127,0,0,0,0,0,0,0,
        150,37,240,254,174,236,13,32,95,0,0,48,0,0,0,0,
        1,0,0,0,0,0,0,0,255,254,255,255,255,7,0,0,
        0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,251,6,0,0,0,0,63,0,0,0,0,0,
        0,0,0,0,255,255,255,255,63,0,255,255,255,255,255,23,
        255,255,255,255,255,255,255,255,255,255,255,131,255,255,255,255,
        255,255,255,255,7,255,255,255,255,255,255,255,255,255,255,3,
        255,255,255,255,255,255,255,255,255,61,127,61,255,255,255,255,
        255,61,255,255,255,255,61,127,61,255,127,255,255,255,255,255,
        255,255,61,255,255,255,255,255,255,255,255,7,0,0,0,0,
        255,255,0,0,255,255,255,255,255,255,255,255,255,255,31,0},
        {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,159,127,0,
        254,255,255,7,255,255,255,255,255,255,255,255,255,7,0,0,
        255,223,3,0,255,255,3,0,255,255,3,0,255,223,1,0,
        255,255,255,255,255,255,15,0,0,0,128,16,0,0,0,0},
        {
        0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,0,
        255,255,255,255,255,1,0,0,0,0,0,0,0,0,0,0,
        255,255,255,31,0,0,0,0,0,0,255,255,255,63,31,0,
        255,255,255,255,255,3,0,0,254,0,0,0,0,0,0,0,
        255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,3,
        255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,
        255,255,255,255,255,255,223,95,220,31,207,15,255,31,220,31},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,
        0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,
        132,252,47,62,80,189,251,243,224,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,127,255,255,255,255,255,127,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,
        255,255,255,255,63,0,255,255,255,255,255,255,63,128,0,0,
        255,255,127,0,127,127,127,127,127,127,127,127,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        96,0,0,0,0,0,62,24,254,255,255,255,255,255,255,255,
        255,255,127,224,254,255,255,255,255,255,255,255,255,255,255,247,
        224,255,255,255,255,31,254,255,255,255,255,255,255,255,255,255,
        255,127,0,0,255,255,255,0,0,0,0,0,0,0,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        187,247,255,255,7,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,63,255,255,255,255,255,255,255,7,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        127,0,248,160,255,253,127,95,219,255,255,255,255,255,255,255,
        255,255,255,255,255,255,3,0,0,0,248,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,63,0,0,255,255,255,255,255,255,
        255,255,252,255,255,255,255,255,255,0,0,0,0,0,255,15,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,
        0,0,0,0,254,255,255,7,254,255,255,7,192,255,255,255,
        255,255,255,255,255,255,255,127,252,252,252,28,0,0,0,0},
        {
        255,239,255,255,127,255,255,183,255,63,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,127,0,0,255,255,255,3,0,0,0,0,0,0,
        255,255,255,63,255,255,255,255,15,255,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        63,253,255,255,255,255,191,145,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,0,239,254,255,255,15,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,
        255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,
        191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,63,255,255,255,253,255,255,247,255,255,255,247,
        255,255,223,255,255,255,223,255,255,127,255,255,255,127,255,255,
        255,253,255,255,255,253,255,255,247,3,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
LC(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,4,0,0,5,6,0,0,7,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,9,
        0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,254,255,255,7,254,255,255,7,
        0,0,0,0,0,4,32,4,255,255,127,255,255,255,127,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,247,240,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,3,0,255,255,255,255,255,255,
        255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        64,215,255,255,251,255,255,255,255,127,255,255,255,255,191,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        3,252,255,255,255,255,255,255,255,127,255,255,255,255,255,3,
        255,255,0,0,0,0,254,255,255,255,127,0,254,255,255,255,
        255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,255,255,63,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,15,0,0,0,0,0,0,252,255,255,254,
        255,255,255,7,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,3,
        255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,
        255,255,255,255,255,255,223,95,220,31,207,15,255,31,220,31},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        132,252,47,62,80,189,27,242,224,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,127,255,255,255,255,255,127,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,
        255,255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        127,0,248,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,254,255,255,7,254,255,255,7,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,
        255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,
        191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,63,255,255,255,253,255,255,247,255,255,255,247,
        255,255,223,255,255,255,223,255,255,127,255,255,255,127,255,255,
        255,253,255,255,255,253,255,255,247,3,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Lu(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,4,0,0,5,6,0,0,7,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,254,255,255,7,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,127,127,0,0,0,0,
        85,85,85,85,85,85,85,170,170,84,85,85,85,85,85,43,
        214,206,219,177,213,210,174,17,144,164,170,74,85,85,210,85,
        85,85,85,85,85,85,5,108,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        64,215,254,255,251,15,0,0,0,0,28,85,85,85,144,230},
        {
        255,255,255,255,255,255,0,0,0,0,0,0,85,85,85,85,
        1,84,85,85,85,85,85,85,171,42,85,85,85,85,85,1,
        85,85,0,0,0,0,254,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,255,255,63,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
        85,85,21,0,85,85,85,85,85,85,85,85,85,85,85,1,
        0,255,0,63,0,255,0,255,0,63,0,170,0,255,0,0,
        0,0,0,0,0,0,0,15,0,15,0,15,0,31,0,15},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        132,56,39,62,80,61,11,192,32,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,127,0,0,0,0,0,0,0,0,0,0,
        85,85,85,85,85,85,85,85,85,85,85,85,5,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,254,255,255,7,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,3,0,0,240,255,255,63,0,0,0,255,255,255,
        3,0,0,208,100,222,63,0,0,0,255,255,255,3,0,0,
        176,231,223,31,0,0,0,123,95,252,1,0,0,240,255,255,
        63,0,0,0,255,255,255,3,0,0,240,255,255,63,0,0,
        0,255,255,255,3,0,0,240,255,255,63,0,0,0,255,255,
        255,3,0,0,0,255,255,255,1,0,0,0,252,255,255,7,
        0,0,0,240,255,255,31,0,0,0,192,255,255,127,0,0,
        0,0,255,255,255,1,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Ll(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,0,4,5,0,0,6,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,8,
        0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,7,
        0,0,0,0,0,4,32,4,0,0,0,128,255,255,127,255,
        170,170,170,170,170,170,170,85,85,171,170,170,170,170,170,212,
        41,49,36,78,42,45,81,230,64,82,85,181,170,170,41,170,
        170,170,170,170,170,170,250,147,1,0,255,255,255,255,255,255,
        255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,1,0,0,240,255,255,255,127,227,170,170,170,47,25},
        {
        0,0,0,0,0,0,255,255,255,255,255,255,170,170,170,170,
        2,168,170,170,170,170,170,170,84,85,170,170,170,170,170,2,
        170,170,0,0,0,0,0,0,0,0,0,0,254,255,255,255,
        255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,15,0,0,0,0,0,0,252,255,255,254,
        255,255,255,7,0,0,0,0,0,0,0,0,0,0,0,0,
        170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,
        170,170,234,15,170,170,170,170,170,170,170,170,170,170,170,2,
        255,0,63,0,255,0,255,0,63,0,255,0,255,0,255,63,
        255,0,255,0,255,0,223,64,220,0,207,0,255,0,220,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,196,8,0,0,128,16,50,192,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,255,255,255,255,255,127,0,0,0,0,
        170,170,170,170,170,170,170,170,170,170,170,170,26,0,0,0,
        255,255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        127,0,248,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,254,255,255,7,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,252,255,255,15,0,0,192,223,255,255,0,0,0,
        252,255,255,15,0,0,192,235,239,255,0,0,0,252,255,255,
        15,0,0,192,255,255,255,0,0,0,252,255,255,15,0,0,
        192,255,255,255,0,0,0,252,255,255,15,0,0,192,255,255,
        255,0,0,0,252,255,255,15,0,0,192,255,255,255,0,0,
        0,252,255,255,63,0,0,0,252,255,255,247,3,0,0,240,
        255,255,223,15,0,0,192,255,255,127,63,0,0,0,255,255,
        255,253,0,0,0,252,255,255,247,3,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Lt(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,32,9,0,0,0,0,4,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,255,0,255,0,255,0,16,0,16,0,0,0,0,0,16}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Lm(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,4,5,6,7,8,9,0,0,10,11,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,255,255,195,255,3,0,31,64,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,240,255,255,255,255,255,255,3,0,0,1,
        0,0,0,248,255,255,255,255,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        32,0,0,0,0,0,62,8,0,0,0,0,0,0,0,0,
        0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,112,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
        0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Lo(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,0,9,0,0,10,11,1,1,1,
        1,1,1,12,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,13,14,15,16,1,1,1,1,1,
        1,1,1,1,1,17,0,0,0,0,0,0,0,0,18,19,
        20,21,22,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,23,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,8,15,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,255,255,7,7,0,
        0,0,0,0,254,255,255,7,254,7,0,0,0,192,254,255,
        255,255,255,255,255,255,255,255,255,255,47,0,0,192,0,156,
        0,0,253,255,255,255,0,0,0,224,255,255,255,63,0,0,
        255,255,255,255,63,0,2,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        240,255,255,255,255,255,255,35,0,0,1,255,3,0,0,32,
        224,159,249,255,255,253,197,35,0,64,0,176,3,0,3,0,
        224,135,249,255,255,253,109,3,0,0,0,94,0,0,28,0,
        224,191,251,255,255,253,237,35,0,0,1,0,3,0,0,0,
        224,159,249,255,255,253,237,35,0,0,0,176,3,0,2,0,
        232,199,61,214,24,199,255,3,0,0,0,0,0,0,0,0},
        {
        224,223,253,255,255,253,239,3,0,0,0,0,3,0,0,0,
        224,223,253,255,255,253,239,35,0,0,0,64,3,0,0,0,
        224,223,253,255,255,253,255,3,0,0,0,0,3,0,0,0,
        224,255,127,252,255,255,251,47,127,0,0,0,0,0,0,0,
        254,255,255,255,255,255,13,0,63,0,0,0,0,0,0,0,
        150,37,240,254,174,236,13,32,31,0,0,48,0,0,0,0,
        1,0,0,0,0,0,0,0,255,254,255,255,255,7,0,0,
        0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,251,6,0,0,0,0,63,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,7,
        255,255,255,255,255,255,255,255,255,255,255,131,255,255,255,255,
        255,255,255,255,7,255,255,255,255,255,255,255,255,255,255,3,
        255,255,255,255,255,255,255,255,255,61,127,61,255,255,255,255,
        255,61,255,255,255,255,61,127,61,255,127,255,255,255,255,255,
        255,255,61,255,255,255,255,255,255,255,255,7,0,0,0,0,
        255,255,0,0,255,255,255,255,255,255,255,255,255,255,31,0},
        {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,159,127,0,
        254,255,255,7,255,255,255,255,255,255,255,255,255,7,0,0,
        255,223,3,0,255,255,3,0,255,255,3,0,255,223,1,0,
        255,255,255,255,255,255,15,0,0,0,0,16,0,0,0,0},
        {
        0,0,0,0,255,255,255,255,247,255,255,255,255,255,255,0,
        255,255,255,255,255,1,0,0,0,0,0,0,0,0,0,0,
        255,255,255,31,0,0,0,0,0,0,255,255,255,63,31,0,
        255,255,255,255,255,3,0,0,254,0,0,0,0,0,0,0,
        255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,224,1,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,255,255,255,255,255,255,63,0,0,0,
        255,255,127,0,127,127,127,127,127,127,127,127,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        64,0,0,0,0,0,0,16,254,255,255,255,255,255,255,255,
        255,255,127,128,254,255,255,255,255,255,255,255,255,255,255,135,
        224,255,255,255,255,31,254,255,255,255,255,255,255,255,255,255,
        255,127,0,0,255,255,255,0,0,0,0,0,0,0,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        255,255,223,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        187,247,255,255,7,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,63,255,255,255,255,255,255,255,7,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        0,0,0,160,255,253,127,95,219,255,255,255,255,255,255,255,
        255,255,255,255,255,255,3,0,0,0,248,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,63,0,0,255,255,255,255,255,255,
        255,255,252,255,255,255,255,255,255,0,0,0,0,0,255,15,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,254,255,
        255,255,255,63,255,255,255,127,252,252,252,28,0,0,0,0},
        {
        255,239,255,255,127,255,255,183,255,63,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,127,0,0,255,255,255,3,0,0,0,0,0,0,
        255,255,255,63,255,255,255,255,15,255,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        63,253,255,255,255,255,191,145,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,0,239,254,255,255,15,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
M(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,0,0,0,11,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,14,
        0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        120,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,254,255,255,255,255,187,182,0,0,0,0,0,0,0,
        0,0,63,0,0,0,0,0,0,248,255,127,0,0,1,0,
        0,0,0,0,0,0,0,0,0,0,192,223,159,61,0,0,
        0,0,2,0,0,0,255,255,255,7,0,0,0,0,0,0,
        0,0,0,0,192,255,1,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        14,0,0,0,0,0,0,208,255,63,30,0,12,0,0,0,
        14,0,0,0,0,0,0,208,159,57,128,0,12,0,0,0,
        14,0,0,0,0,0,0,208,135,57,0,0,0,0,3,0,
        14,0,0,0,0,0,0,208,191,59,0,0,12,0,0,0,
        14,0,0,0,0,0,0,208,143,57,192,0,0,0,0,0,
        4,0,0,0,0,0,0,192,199,61,128,0,0,0,0,0},
        {
        14,0,0,0,0,0,0,192,223,61,96,0,0,0,0,0,
        12,0,0,0,0,0,0,208,223,61,96,0,0,0,0,0,
        12,0,0,0,0,0,0,192,207,61,128,0,0,0,0,0,
        12,0,0,0,0,0,0,0,0,132,95,255,0,0,12,0,
        0,0,0,0,0,0,242,7,128,127,0,0,0,0,0,0,
        0,0,0,0,0,0,242,27,0,63,0,0,0,0,0,0,
        0,0,0,3,0,0,160,194,0,0,0,0,0,0,254,255,
        223,0,255,254,255,255,255,31,64,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,240,199,3,0,0,192,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,28,0,0,0,28,0,0,0,12,0,0,0,12,0,
        0,0,0,0,0,0,192,255,255,255,15,32,0,0,0,0},
        {
        0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,15,255,15,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,255,255,1,3,0,0,0,0,0,0,
        0,0,128,15,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,255,255,15,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,252,0,0,0,0,0,0,0,0,0,0,
        0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        68,8,0,0,248,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,0,0,15,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        110,240,0,0,0,0,0,135,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,224,227,7,248,
        231,15,0,0,0,60,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
        static const unsigned char e_pn[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Mn(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,0,0,0,11,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,14,
        0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,254,255,255,255,255,187,182,0,0,0,0,0,0,0,
        0,0,63,0,0,0,0,0,0,248,255,127,0,0,1,0,
        0,0,0,0,0,0,0,0,0,0,192,159,159,61,0,0,
        0,0,2,0,0,0,255,255,255,7,0,0,0,0,0,0,
        0,0,0,0,192,255,1,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        6,0,0,0,0,0,0,16,254,33,30,0,12,0,0,0,
        2,0,0,0,0,0,0,16,30,32,0,0,12,0,0,0,
        6,0,0,0,0,0,0,16,134,57,0,0,0,0,3,0,
        6,0,0,0,0,0,0,16,190,33,0,0,12,0,0,0,
        2,0,0,0,0,0,0,144,14,32,64,0,0,0,0,0,
        4,0,0,0,0,0,0,0,1,32,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,192,193,61,96,0,0,0,0,0,
        0,0,0,0,0,0,0,144,64,48,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,14,32,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,4,92,0,0,0,0,0,
        0,0,0,0,0,0,242,7,128,127,0,0,0,0,0,0,
        0,0,0,0,0,0,242,27,0,63,0,0,0,0,0,0,
        0,0,0,3,0,0,160,2,0,0,0,0,0,0,254,127,
        223,0,255,254,255,255,255,31,64,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,224,197,2,0,0,0,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,28,0,0,0,28,0,0,0,12,0,0,0,12,0,
        0,0,0,0,0,0,128,63,64,254,15,32,0,0,0,0},
        {
        0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,135,1,4,14,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,31,226,15,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,252,0,0,0,0,0,0,0,0,0,0,
        0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        64,8,0,0,96,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,0,0,15,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        110,240,0,0,0,0,0,135,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,128,3,0,248,
        231,15,0,0,0,60,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
        static const unsigned char e_pn[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Mc(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,2,3,4,5,6,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        8,0,0,0,0,0,0,192,1,30,0,0,0,0,0,0,
        12,0,0,0,0,0,0,192,129,25,128,0,0,0,0,0,
        8,0,0,0,0,0,0,192,1,0,0,0,0,0,0,0,
        8,0,0,0,0,0,0,192,1,26,0,0,0,0,0,0,
        12,0,0,0,0,0,0,64,129,25,128,0,0,0,0,0,
        0,0,0,0,0,0,0,192,198,29,128,0,0,0,0,0},
        {
        14,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,
        12,0,0,0,0,0,0,64,159,13,96,0,0,0,0,0,
        12,0,0,0,0,0,0,192,193,29,128,0,0,0,0,0,
        12,0,0,0,0,0,0,0,0,128,3,255,0,0,12,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,128,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,16,2,1,0,0,192,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,64,192,191,1,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,120,14,251,1,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,255,255,1,3,0,0,0,0,0,0,
        0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        4,0,0,0,152,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,96,224,7,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Me(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,2,0,0,0,0,0,0,3,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,224,29,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
N(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,0,9,10,0,11,12,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,
        14,15,16,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,17,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,255,3,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,12,114,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,3,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,240,3,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,7,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,3,0,0,0,0,
        0,0,0,0,255,255,15,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,255,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,31,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,192,1,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,3,255,3},
        {
        0,0,255,3,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,3,
        255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,248,255,255,255,255,255,
        15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,
        255,255,255,15,0,0,0,0,0,0,0,0,0,252,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,255,
        255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        128,0,0,0,254,3,0,7,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,3,0,0,0,0,254,255,0,0,0,0,
        255,3,0,0,0,0,254,255,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,3,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        128,255,255,255,255,255,15,0,255,255,255,255,255,255,255,1,
        0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,15,0,0,0,0,4,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,62,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,192,255,255,255,255,255,255}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Nd(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,
        0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,255,3,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,3,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,3,0,0,0,0,
        0,0,0,0,255,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,255,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,3,0,0},
        {
        0,0,255,3,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,3,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,192,255,255,255,255,255,255}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Nl(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,2,0,0,3,0,0,0,4,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,192,1,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,
        15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        128,0,0,0,254,3,0,7,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,31,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,62,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
No(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,3,4,5,6,0,0,7,8,0,9,10,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        11,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,12,114,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,252,15,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,31,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,3},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,3,
        255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,248,255,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,
        255,255,255,15,0,0,0,0,0,0,0,0,0,252,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,255,
        255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,3,0,0,0,0,254,255,0,0,0,0,
        255,3,0,0,0,0,254,255,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        128,255,255,255,255,255,15,0,0,0,0,0,0,0,224,1,
        0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
P(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,0,9,10,11,12,13,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,
        15,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,238,247,0,140,1,0,0,184,0,0,0,40,
        0,0,0,0,2,8,128,136,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,
        128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,252,0,0,0,0,
        0,6,0,0,0,0,0,64,73,0,0,0,0,0,24,0,
        0,48,0,200,0,0,0,0,0,0,0,0,0,60,0,0,
        0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,
        255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,48,0,1,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,
        0,0,0,0,0,0,0,0,0,128,0,12,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        240,255,7,0,0,0,0,60,0,0,0,0,0,0,0,0,
        32,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,254,1,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,
        0,0,0,24,0,0,0,0,0,0,0,0,0,56,0,0,
        0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,112,7,0,0,0,0},
        {
        255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,
        0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,255,255,255,0,255,255,239,255,251,127,0,0,0,96,
        0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,255,63,0,
        0,0,0,0,0,0,0,0,96,0,0,0,192,15,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        248,255,255,1,0,0,0,0,0,0,0,15,0,0,0,48,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        14,255,243,255,0,0,1,32,0,0,0,0,0,0,0,0,
        0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,3,0,0,255,255,255,255,247,255,11,13,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        238,247,0,140,1,0,0,184,0,0,0,168,63,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,1,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Pc(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,128,1,0,16,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,24,0,0,224,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Pd(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,4,0,5,0,0,6,7,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,63,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,16,0,0,1,0,0,0,0,0,0,0,0,0,
        0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,6,0,0,0,0,1,8,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Ps(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,3,0,4,0,0,5,6,7,0,8,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,1,0,0,0,0,0,8,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,68,0,0,0,0,32,0,0,0,0,0,0,32,
        0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,85,21,0,
        0,0,0,0,0,0,0,0,32,0,0,0,64,5,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        168,170,170,0,0,0,0,0,0,0,0,5,0,0,0,16,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,85,81,37,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,128,0,0,0,160,170,138,0,0,42,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,1,0,0,0,0,0,8,0,0,0,136,4,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Pe(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,3,0,4,0,0,5,6,7,0,8,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,2,0,0,0,0,0,32,0,0,0,32,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,64,
        0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,170,42,0,
        0,0,0,0,0,0,0,0,64,0,0,0,128,10,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        80,85,85,1,0,0,0,0,0,0,0,10,0,0,0,32,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,170,162,202,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,1,0,0,64,85,21,1,0,84,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,2,0,0,0,0,0,32,0,0,0,32,9,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Pi(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,0,0,4,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,153,0,0,0,2,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        20,18,0,16,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Pf(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,0,0,4,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,34,0,0,0,4,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        40,36,0,32,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Po(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,0,9,0,0,10,11,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,
        13,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,238,212,0,140,1,0,0,16,0,0,0,0,
        0,0,0,0,2,0,128,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,
        128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,252,0,0,0,0,
        0,2,0,0,0,0,0,64,73,0,0,0,0,0,24,0,
        0,48,0,200,0,0,0,0,0,0,0,0,0,60,0,0,
        0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,
        255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,48,0,1,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,
        0,0,0,0,0,0,0,0,0,128,0,12,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        240,255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,
        32,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,254,1,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,
        0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,112,7,0,0,0,0},
        {
        191,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,
        0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,192,0,255,0,255,121,142,255,235,127,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        195,201,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        14,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,127,2,0,0,1,0,96,30,247,128,3,13,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        238,212,0,140,1,0,0,16,0,0,0,0,50,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,1,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
S(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,11,12,13,14,0,0,0,
        0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,16,17,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,19,
        20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,21,22,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,16,8,0,112,0,0,0,64,1,0,0,80,
        0,0,0,0,252,211,83,1,0,0,128,0,0,0,128,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,60,0,252,255,224,191,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,
        48,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,96,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,4,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,7},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        14,0,248,252,0,0,80,1,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,192,191,159,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
        0,0,255,3,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,160,3,224,0,224,0,224,0,96},
        {
        0,0,0,0,0,0,0,0,16,0,4,0,0,0,0,28,
        0,28,0,0,255,255,63,0,0,0,0,0,0,0,0,0,
        123,3,208,193,175,66,4,12,31,28,0,0,0,0,0,0,
        0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,249,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,143,255,255,255,255,15,0,0,0,0},
        {
        255,255,255,255,127,0,0,0,255,7,0,0,0,0,0,0,
        0,0,0,240,255,255,255,255,255,255,255,255,255,3,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,31,255,255,3,0,0,0,0,0,0,0,0,0,
        222,243,255,255,255,254,255,255,255,175,71,127,254,0,0,0,
        0,0,16,255,255,255,254,127,31,0,255,255,63,0,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        7,0,0,254,255,255,255,255,255,255,255,240,255,255,255,207,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,224,7,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,251,255,255,255,255,255,255,255,255,255,255,15,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,63,0,0,0,255,15},
        {
        16,0,12,0,1,0,192,192,0,0,0,0,0,0,0,0,
        0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,195,255,0,0,0,0,255,255,0,0,0,0,0,0,
        255,255,255,127,0,252,255,255,15,0,1,0,255,255,255,255,
        0,252,255,255,255,255,1,0,255,255,255,255,255,255,255,127,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,255,255,255,255,255,127,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,
        0,0,0,0,0,0,0,0,0,0,0,0,116,2,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        16,8,0,112,0,0,0,64,1,0,0,80,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,127,127,0,48},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        4,0,0,0,0,0,128,255,0,0,0,0,0,0,0,254,
        255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,
        255,255,255,255,127,252,255,255,255,255,255,255,31,28,0,0,
        24,240,255,255,255,195,255,255,255,255,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,35,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,2,0,0,8,0,0,0,8,
        0,0,32,0,0,0,32,0,0,128,0,0,0,128,0,0,
        0,2,0,0,0,2,0,0,8,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Sm(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,4,5,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,8,0,112,0,0,0,0,0,0,0,80,
        0,0,0,0,0,16,2,0,0,0,128,0,0,0,128,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0},
        {
        0,0,0,0,0,0,0,0,16,0,4,0,0,0,0,28,
        0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,31,8,0,0,0,0,0,0,
        0,0,31,12,73,64,0,0,0,192,20,0,0,0,240,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,15,0,0,3,0,0,0,0,0,0,0,0,0,0,16,
        0,0,0,248,255,255,15,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,128,0,2,0,0,0,0,0,0,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,31,0,255,255,63,0,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        7,0,0,254,255,255,255,255,255,255,255,240,255,255,255,207,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,116,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,8,0,112,0,0,0,0,0,0,0,80,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,4,30,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,2,0,0,8,0,0,0,8,
        0,0,32,0,0,0,32,0,0,128,0,0,0,128,0,0,
        0,2,0,0,0,2,0,0,8,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Sc(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,0,6,0,0,7,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,63,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
        0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,99,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Sk(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,3,0,0,0,0,4,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,64,1,0,0,0,
        0,0,0,0,0,129,16,1,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,60,0,252,255,224,191,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,
        48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,160,3,224,0,224,0,224,0,96},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,64,1,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
So(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,0,7,0,8,9,10,11,12,0,0,0,
        0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,14,15,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
        17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,192,66,65,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,96,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,5},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        14,0,248,252,0,0,80,1,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,192,191,159,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
        0,0,255,3,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        123,3,208,193,175,66,4,12,0,20,0,0,0,0,0,0,
        0,0,224,243,182,191,255,255,255,63,235,255,255,255,15,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,240,255,255,252,249,255,255,255,255,255,255,255,255,255,239,
        255,255,255,7,0,0,128,255,255,255,255,15,0,0,0,0},
        {
        255,255,255,255,127,0,0,0,255,7,0,0,0,0,0,0,
        0,0,0,240,255,255,255,255,255,255,255,255,255,3,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,127,255,253,255,255,255,255,255,255,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,127,255,255,
        255,255,255,31,255,255,3,0,0,0,0,0,0,0,0,0,
        222,243,255,255,255,254,255,255,255,175,71,127,254,0,0,0,
        0,0,16,255,255,255,254,127,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,224,7,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,251,255,255,255,255,255,255,255,255,255,255,15,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,63,0,0,0,255,15},
        {
        16,0,12,0,1,0,192,192,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,195,255,0,0,0,0,255,255,0,0,0,0,0,0,
        255,255,255,127,0,252,255,255,15,0,1,0,255,255,255,255,
        0,252,255,255,255,255,1,0,255,255,255,255,255,255,255,127,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,255,255,255,255,255,127,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,16,97,0,48},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        4,0,0,0,0,0,128,255,0,0,0,0,0,0,0,254,
        255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,
        255,255,255,255,127,252,255,255,255,255,255,255,31,28,0,0,
        24,240,255,255,255,195,255,255,255,255,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,35,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Z(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,3,4,0,5,0,0,0,6,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,7,0,0,0,131,0,0,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Zs(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,3,4,0,5,0,0,0,6,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,7,0,0,0,128,0,0,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Zl(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Zp(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
C(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,11,12,13,14,0,0,0,
        0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,16,0,17,18,0,0,0,0,0,
        0,0,0,0,0,19,0,0,1,1,1,1,1,1,20,21,
        22,23,24,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,25,26,1,1,1,1,1,1,1,1,1,27,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,28,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,29,30,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,31 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,128,
        255,255,255,255,0,32,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,252,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,187,
        15,40,0,0,4,0,0,0,0,128,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        128,0,0,0,0,0,0,0,0,128,0,0,0,0,0,252,
        0,0,255,255,255,255,1,0,0,0,128,1,1,0,0,0,
        0,249,1,0,0,0,0,4,0,255,0,0,0,248,224,255,
        255,7,192,55,1,0,0,248,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,
        0,192,0,0,0,0,0,0,0,24,0,0,0,192,255,255,
        0,0,0,0,0,0,252,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        1,0,0,0,0,0,0,12,0,192,224,0,0,0,254,223,
        17,96,6,0,0,2,58,12,96,134,127,79,48,0,0,248,
        17,120,6,0,0,2,146,44,120,198,255,161,63,0,224,255,
        17,64,4,0,0,2,18,12,64,196,254,255,48,0,253,255,
        17,96,6,0,0,2,18,12,112,198,63,79,60,0,252,255,
        19,56,194,41,231,56,0,60,56,194,127,255,63,0,0,248},
        {
        17,32,2,0,0,2,16,60,32,194,159,255,60,0,255,255,
        19,32,2,0,0,2,16,12,32,194,159,191,60,0,255,255,
        19,32,2,0,0,2,0,60,48,194,127,255,60,0,255,255,
        19,0,128,3,0,0,4,208,128,123,160,0,255,255,227,255,
        1,0,0,0,0,0,0,120,0,0,0,240,255,255,255,255,
        105,218,15,1,81,19,0,196,160,192,0,204,255,255,255,255,
        0,0,0,0,0,0,0,0,0,1,0,0,0,248,1,0,
        0,240,0,1,0,0,0,32,0,96,252,255,255,255,255,255},
        {
        0,0,0,0,4,9,56,252,0,0,0,252,255,255,255,255,
        255,255,255,255,0,0,0,0,192,255,0,0,0,0,0,224,
        0,0,0,0,0,0,0,0,0,0,0,124,0,0,0,0,
        0,0,0,0,248,0,0,0,0,0,0,0,0,0,0,252,
        0,0,0,0,0,0,0,0,0,194,128,194,0,0,0,0,
        0,194,0,0,0,0,194,128,194,0,128,0,0,0,0,0,
        0,0,194,0,0,0,0,0,0,0,0,120,0,0,0,224,
        0,0,0,252,0,0,0,0,0,0,0,0,0,0,224,255},
        {
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,
        0,0,0,224,0,0,0,0,0,0,0,0,0,0,254,255,
        0,32,224,255,0,0,128,255,0,0,240,255,0,32,242,255,
        0,0,0,0,0,0,48,0,0,0,0,192,0,252,0,252},
        {
        0,128,0,252,0,0,0,0,0,0,0,0,0,0,0,255,
        0,0,0,0,0,252,255,255,255,255,255,255,255,255,255,255,
        0,0,0,224,0,240,0,240,14,0,0,0,0,192,224,255,
        0,0,0,0,0,252,0,0,0,252,0,60,0,0,0,0,
        0,0,0,48,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,240,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,252,
        0,0,192,192,0,0,0,0,192,192,0,85,0,0,0,192,
        0,0,0,0,0,0,32,0,32,0,48,16,0,0,35,128},
        {
        0,248,0,0,0,124,0,0,0,0,0,0,255,255,12,0,
        0,128,224,255,0,0,192,255,255,255,0,0,0,240,255,255,
        0,0,0,0,0,0,0,0,0,224,7,0,0,0,0,0,
        240,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,240,255,255,255,255},
        {
        0,0,0,0,128,255,255,255,0,248,255,255,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,224,0,0,252,255,255,255,255,255,255,255,255,255,
        33,12,0,0,0,1,0,0,0,80,184,128,1,0,0,0,
        0,0,224,0,0,0,1,128,128,255,0,0,0,240,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,240,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,128,0,0,0,0,0,128,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,1,
        0,0,0,0,192,255,0,0,0,0,0,0,192,127,255,255,
        0,0,128,255,128,128,128,128,128,128,128,128,255,255,255,255,
        0,0,0,207,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,4,0,0,0,0,0,0,0,0,0,0,240,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,192,255,255,255,0,240},
        {
        0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
        0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,
        31,0,0,0,0,224,1,0,0,0,0,0,0,0,0,0,
        0,128,0,0,0,0,0,255,0,0,255,255,255,255,0,0,
        0,0,0,128,0,0,0,0,240,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,240,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,224,0,0,0,0,0,0,128,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,240,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,240,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,192,0,0,0,0,0,0,0,248,0,0,
        0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,255,
        128,255,7,31,0,0,128,160,36,0,0,0,0,0,0,0,
        0,0,0,0,0,0,252,255,255,255,7,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,
        0,0,3,0,0,0,0,0,0,255,0,0,0,0,0,192,
        0,0,0,252,240,255,0,0,0,0,8,0,128,240,32,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,128,3,3,3,227,128,128,255,15},
        {
        0,16,0,0,128,0,0,72,0,192,0,192,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,
        120,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,
        0,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,128,240,255,0,0,0,248,255,255,255,255,255,255,
        0,0,0,64,0,0,0,0,240,0,192,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,192,0,252,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        192,2,0,0,0,0,64,110,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        144,15,16,1,0,0,240,120,0,255,0,254,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,255,
        0,0,0,0,128,3,0,0,0,0,0,0,0,0,248,7,
        0,0,0,0,0,0,0,0,0,0,0,192,255,255,255,255,
        0,0,0,0,0,0,0,0,192,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,
        0,0,0,32,155,33,0,20,16,0,0,0,0,0,0,0,
        64,24,32,32,0,0,0,132,160,3,2,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,192,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63}
 };
        static const unsigned char e_pn[] = {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Cc(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,128,
        255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Cf(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,4,0,0,5,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,
        0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,48,0,0,0,0,0,0,0,0,0},
        {
        0,248,0,0,0,124,0,0,0,0,0,0,15,252,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
        static const unsigned char e_pn[] = {
        2,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Cs(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Co(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Cn(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,11,12,13,14,0,0,0,
        0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,16,0,17,18,0,0,0,0,0,
        0,0,0,0,0,19,0,0,0,0,0,0,0,0,20,21,
        22,23,24,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,25,26,1,1,1,1,1,1,1,1,1,27,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,28,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,29,30,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,31 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,252,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,187,
        15,40,0,0,4,0,0,0,0,128,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        128,0,0,0,0,0,0,0,0,128,0,0,0,0,0,252,
        0,0,255,255,255,255,1,0,0,0,128,1,1,0,0,0,
        0,249,1,0,0,0,0,4,0,255,0,0,0,248,224,255,
        240,7,192,55,1,0,0,248,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,64,0,0,0,0,0,0,0,24,0,0,0,192,255,255,
        0,0,0,0,0,0,252,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        1,0,0,0,0,0,0,12,0,192,224,0,0,0,254,223,
        17,96,6,0,0,2,58,12,96,134,127,79,48,0,0,248,
        17,120,6,0,0,2,146,44,120,198,255,161,63,0,224,255,
        17,64,4,0,0,2,18,12,64,196,254,255,48,0,253,255,
        17,96,6,0,0,2,18,12,112,198,63,79,60,0,252,255,
        19,56,194,41,231,56,0,60,56,194,127,255,63,0,0,248},
        {
        17,32,2,0,0,2,16,60,32,194,159,255,60,0,255,255,
        19,32,2,0,0,2,16,12,32,194,159,191,60,0,255,255,
        19,32,2,0,0,2,0,60,48,194,127,255,60,0,255,255,
        19,0,128,3,0,0,4,208,128,123,160,0,255,255,227,255,
        1,0,0,0,0,0,0,120,0,0,0,240,255,255,255,255,
        105,218,15,1,81,19,0,196,160,192,0,204,255,255,255,255,
        0,0,0,0,0,0,0,0,0,1,0,0,0,248,1,0,
        0,240,0,1,0,0,0,32,0,96,252,255,255,255,255,255},
        {
        0,0,0,0,4,9,56,252,0,0,0,252,255,255,255,255,
        255,255,255,255,0,0,0,0,192,255,0,0,0,0,0,224,
        0,0,0,0,0,0,0,0,0,0,0,124,0,0,0,0,
        0,0,0,0,248,0,0,0,0,0,0,0,0,0,0,252,
        0,0,0,0,0,0,0,0,0,194,128,194,0,0,0,0,
        0,194,0,0,0,0,194,128,194,0,128,0,0,0,0,0,
        0,0,194,0,0,0,0,0,0,0,0,120,0,0,0,224,
        0,0,0,252,0,0,0,0,0,0,0,0,0,0,224,255},
        {
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,
        0,0,0,224,0,0,0,0,0,0,0,0,0,0,254,255,
        0,32,224,255,0,0,128,255,0,0,240,255,0,32,242,255,
        0,0,0,0,0,0,0,0,0,0,0,192,0,252,0,252},
        {
        0,128,0,252,0,0,0,0,0,0,0,0,0,0,0,255,
        0,0,0,0,0,252,255,255,255,255,255,255,255,255,255,255,
        0,0,0,224,0,240,0,240,14,0,0,0,0,192,224,255,
        0,0,0,0,0,252,0,0,0,252,0,60,0,0,0,0,
        0,0,0,48,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,240,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,252,
        0,0,192,192,0,0,0,0,192,192,0,85,0,0,0,192,
        0,0,0,0,0,0,32,0,32,0,48,16,0,0,35,128},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,240,3,12,0,
        0,128,224,255,0,0,192,255,255,255,0,0,0,240,255,255,
        0,0,0,0,0,0,0,0,0,224,7,0,0,0,0,0,
        240,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,240,255,255,255,255},
        {
        0,0,0,0,128,255,255,255,0,248,255,255,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,224,0,0,252,255,255,255,255,255,255,255,255,255,
        33,12,0,0,0,1,0,0,0,80,184,128,1,0,0,0,
        0,0,224,0,0,0,1,128,128,255,0,0,0,240,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,240,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,128,0,0,0,0,0,128,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,1,
        0,0,0,0,192,255,0,0,0,0,0,0,192,127,255,255,
        0,0,128,255,128,128,128,128,128,128,128,128,255,255,255,255,
        0,0,0,207,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,4,0,0,0,0,0,0,0,0,0,0,240,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,192,255,255,255,0,240},
        {
        0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
        0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,
        31,0,0,0,0,224,1,0,0,0,0,0,0,0,0,0,
        0,128,0,0,0,0,0,255,0,0,255,255,255,255,0,0,
        0,0,0,128,0,0,0,0,240,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,240,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,224,0,0,0,0,0,0,128,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,240,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,240,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,192,0,0,0,0,0,0,0,248,0,0,
        0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,255,
        128,255,7,31,0,0,128,160,36,0,0,0,0,0,0,0,
        0,0,0,0,0,0,252,255,255,255,7,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,
        0,0,3,0,0,0,0,0,0,255,0,0,0,0,0,192,
        0,0,0,252,240,255,0,0,0,0,8,0,128,240,32,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,128,3,3,3,227,128,128,255,1},
        {
        0,16,0,0,128,0,0,72,0,192,0,192,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,
        120,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,
        0,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,128,240,255,0,0,0,248,255,255,255,255,255,255,
        0,0,0,64,0,0,0,0,240,0,192,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,192,0,252,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        192,2,0,0,0,0,64,110,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        144,15,16,1,0,0,240,120,0,255,0,254,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,255,
        0,0,0,0,128,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,192,255,255,255,255,
        0,0,0,0,0,0,0,0,192,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,
        0,0,0,32,155,33,0,20,16,0,0,0,0,0,0,0,
        64,24,32,32,0,0,0,132,160,3,2,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,192,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63}
 };
        static const unsigned char e_pn[] = {
        253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiL(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,11,12,13,14,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,15,16,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,
        19,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,21,22,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,254,255,255,7,254,255,255,7,
        0,0,0,0,0,4,32,4,255,255,127,255,255,255,127,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,3,0,255,255,255,255,255,255,
        255,255,255,255,255,255,255,249,3,0,3,0,31,64,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,
        64,215,255,255,251,255,255,255,255,127,255,255,255,255,191,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        7,252,255,255,255,255,255,255,255,127,255,255,255,255,255,3,
        255,255,0,0,0,0,254,255,255,255,127,254,254,255,255,255,
        255,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        248,255,255,255,255,255,255,227,1,30,1,255,243,255,1,32,
        236,159,249,255,255,253,197,227,129,89,128,176,195,255,243,7,
        232,135,249,255,255,253,109,195,1,0,0,94,192,255,28,0,
        232,191,251,255,255,253,237,227,1,26,1,0,195,255,0,0,
        236,159,249,255,255,253,237,99,129,25,128,176,195,255,3,0,
        232,199,61,214,24,199,255,195,198,29,128,0,192,255,7,0},
        {
        238,223,253,255,255,253,239,3,30,0,0,0,195,255,0,0,
        236,223,253,255,255,253,239,227,223,13,96,64,195,255,0,0,
        236,223,253,255,255,253,255,195,193,29,128,0,195,255,0,0,
        236,255,127,252,255,255,251,47,127,128,3,255,0,0,28,0,
        254,255,255,255,255,255,13,0,127,128,255,15,0,0,0,0,
        150,37,240,254,174,236,13,32,95,0,255,51,0,0,0,0,
        255,255,255,252,255,255,95,193,255,254,255,255,255,7,0,128,
        32,15,0,0,0,0,0,192,191,159,3,0,0,0,0,0},
        {
        255,255,255,255,251,22,2,1,255,255,255,0,0,0,0,0,
        0,0,0,0,255,255,255,255,63,0,255,255,255,255,255,31,
        255,255,255,255,255,255,255,255,255,255,255,131,255,255,255,255,
        255,255,255,255,7,255,255,255,255,255,255,255,255,255,255,3,
        255,255,255,255,255,255,255,255,255,61,127,61,255,255,255,255,
        255,61,255,255,255,255,61,127,61,255,127,255,255,255,255,255,
        255,255,61,255,255,255,255,255,255,255,255,7,255,255,255,31,
        255,255,0,0,255,255,255,255,255,255,255,255,255,255,31,0},
        {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,0,
        254,255,255,7,255,255,255,255,255,255,255,255,255,255,1,0,
        255,223,3,0,255,255,99,0,255,255,3,0,255,223,1,0,
        255,255,255,255,255,255,127,192,191,1,240,23,255,3,0,0},
        {
        0,0,255,3,255,255,255,255,255,255,255,255,255,255,255,0,
        255,255,255,255,255,1,0,0,0,0,0,0,0,0,0,0,
        255,255,255,31,120,0,251,1,192,255,255,255,255,63,31,0,
        255,255,255,255,255,3,255,255,255,3,255,3,0,0,0,0,
        255,255,127,206,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,3,
        255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,
        255,255,255,255,255,255,223,95,220,31,207,15,255,31,220,31},
        {
        0,64,0,0,0,0,0,0,0,0,0,0,0,0,2,128,
        0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,
        132,252,47,62,80,189,251,243,224,3,0,0,255,255,255,255,
        15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,192,255,255,255,255,255,255,255,255,7,
        0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,240,255,255,255,255,255,255,255,255,255,3,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,127,255,255,255,255,255,127,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,
        255,255,255,255,63,0,255,255,255,255,255,255,63,128,0,0,
        255,255,127,0,127,127,127,127,127,127,127,127,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        224,0,0,0,254,3,62,31,254,255,255,255,255,255,255,255,
        255,255,127,224,254,255,255,255,255,255,255,255,255,255,255,247,
        224,255,255,255,255,31,254,255,255,255,255,255,255,255,255,255,
        255,127,255,255,255,255,255,0,0,0,0,0,0,0,255,255,
        255,255,255,31,255,255,255,255,15,0,0,0,255,255,255,143,
        255,255,255,255,255,255,1,0,255,15,255,255,255,255,255,127,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,248,
        255,255,255,255,255,255,255,255,255,255,255,63,255,255,255,127},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        187,247,255,255,159,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,63,255,255,255,255,255,255,255,7,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        127,0,248,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,254,255,255,7,254,255,255,7,192,255,255,255,
        255,255,255,255,255,255,255,127,252,252,252,28,0,0,0,0},
        {
        255,239,255,255,127,255,255,183,255,63,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,
        133,255,255,255,255,255,143,255,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,127,15,0,255,255,255,7,0,0,0,0,0,0,
        255,255,255,191,255,255,255,255,15,255,1,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,255,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,
        255,255,255,255,127,252,255,255,255,255,255,255,127,252,7,0,
        24,240,255,255,255,195,255,255,255,255,255,63,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,
        255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,
        191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,63,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiLRE(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiLRO(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiR(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,2,0,0,0,0,0,0,3,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,
        0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,64,73,0,255,255,255,7,31,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,160,255,253,127,95,219,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        63,253,255,255,255,255,191,145,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,0,239,254,255,255,15,0,255,0,255,1,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiAL(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,4,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        15,40,0,200,254,255,255,7,255,7,0,0,0,224,254,255,
        255,255,255,255,255,255,255,255,255,255,63,32,96,192,0,252,
        255,63,253,255,255,255,0,0,0,224,255,255,255,63,0,0,
        255,255,255,255,63,0,2,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,
        255,255,255,255,255,255,3,0,0,0,248,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,63,0,0,255,255,255,255,255,255,
        255,255,252,255,255,255,255,255,255,0,0,0,0,0,255,31,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiRLE(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiRLO(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiPDF(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiEN(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,0,0,4,5,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,255,3,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,12,2,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,3,
        255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,3,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,192,255,255,255,255,255,255}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiES(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,
        0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiET(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,0,6,0,0,7,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,60,0,3,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0},
        {
        0,0,0,0,0,0,31,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,63,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,128,0,6,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,99,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiAN(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,27,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiCS(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,0,0,4,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,208,0,4,0,0,0,0,0,0,0,0,
        0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,128,0,0,16,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,37,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,208,0,4,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiNSM(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,0,0,0,11,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,14,
        0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        120,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,254,255,255,255,255,187,182,0,0,0,0,0,0,0,
        0,0,63,0,0,0,0,0,0,248,255,127,0,0,1,0,
        0,0,0,0,0,0,0,0,0,0,192,223,159,61,0,0,
        0,0,2,0,0,0,255,255,255,7,0,0,0,0,0,0,
        0,0,0,0,192,255,1,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        6,0,0,0,0,0,0,16,254,33,30,0,12,0,0,0,
        2,0,0,0,0,0,0,16,30,32,0,0,12,0,0,0,
        6,0,0,0,0,0,0,16,134,57,0,0,0,0,3,0,
        6,0,0,0,0,0,0,16,190,33,0,0,12,0,0,0,
        2,0,0,0,0,0,0,144,14,32,64,0,0,0,0,0,
        4,0,0,0,0,0,0,0,1,32,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,192,193,61,96,0,0,0,0,0,
        0,0,0,0,0,0,0,16,0,48,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,14,32,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,4,92,0,0,0,0,0,
        0,0,0,0,0,0,242,7,128,127,0,0,0,0,0,0,
        0,0,0,0,0,0,242,27,0,63,0,0,0,0,0,0,
        0,0,0,3,0,0,160,2,0,0,0,0,0,0,254,127,
        223,0,255,254,255,255,255,31,64,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,224,197,2,0,0,0,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,28,0,0,0,28,0,0,0,12,0,0,0,12,0,
        0,0,0,0,0,0,128,63,64,254,15,32,0,0,0,0},
        {
        0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,135,15,4,14,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,255,255,15,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,252,0,0,0,0,0,0,0,0,0,0,
        0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        68,8,0,0,96,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,0,0,15,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        110,240,0,0,0,0,0,135,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,128,3,0,248,
        231,15,0,0,0,60,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
        static const unsigned char e_pn[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiBN(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,0,0,4,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,193,255,15,0,0,0,0,0,0,0,0,0,0,0,128,
        223,255,255,255,0,32,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,56,0,0,0,0,0,0,0,0,0,0,15,252,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
        static const unsigned char e_pn[] = {
        2,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiB(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,36,0,112,0,0,0,0,0,0,0,0,0,0,0,0,
        32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiS(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,10,0,128,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiWS(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,3,4,0,5,0,0,0,6,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,16,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,7,0,0,0,1,0,0,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiON(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,11,12,13,14,0,0,0,
        0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,16,17,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,
        19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,198,7,0,248,1,0,0,248,1,0,0,120,
        0,0,0,0,194,219,208,249,0,0,128,0,0,0,128,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,6,252,255,252,255,224,191,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,64,
        176,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,5},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,60,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,3,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,3},
        {
        255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,49,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,192,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,160,3,224,0,224,0,224,0,96},
        {
        0,0,255,255,255,0,224,255,239,255,255,127,0,0,0,112,
        0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        123,3,208,193,175,2,4,12,31,28,248,255,0,0,0,0,
        0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,243,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,248,
        255,255,223,255,255,255,255,255,255,255,255,15,0,0,0,0},
        {
        255,255,255,255,127,0,0,0,255,7,0,0,255,255,255,255,
        255,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,31,255,239,3,0,0,0,0,0,0,0,0,0,
        222,243,255,255,255,254,255,255,255,175,71,127,254,255,255,255,
        255,255,31,255,255,255,254,127,127,0,255,255,255,15,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,224,7,0,254,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,251,255,255,255,255,255,255,255,255,255,255,15,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,63,0,0,0,255,15},
        {
        30,255,255,255,1,0,193,224,0,0,0,0,0,0,0,0,
        0,0,0,24,1,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,
        0,0,0,96,0,0,0,0,0,0,255,255,0,0,0,112,
        0,0,0,0,0,0,254,255,0,240,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,7,
        0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,128},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,255,255,255,255,255,127,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,
        0,0,255,3,0,0,255,255,255,255,210,127,115,9,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        198,7,0,248,1,0,0,248,1,0,0,248,63,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,28,127,0,62},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        2,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,
        255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,62,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,35,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Arabic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,4,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,232,63,64,254,255,255,7,254,7,192,127,0,252,254,255,
        255,255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,255,255,255,63,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,
        255,255,255,255,255,255,3,0,0,0,248,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,63,0,0,255,255,255,255,255,255,
        255,255,252,255,255,255,255,255,255,0,0,0,0,0,255,31,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Armenian(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,254,255,255,255,127,254,254,255,255,255,
        255,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,248,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Bengali(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        238,159,249,255,255,253,197,243,159,121,128,176,207,255,255,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Bopomofo(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        224,255,255,255,255,31,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Braille(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Buginese(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,207,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Buhid(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,15,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
CanadianAboriginal(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Cherokee(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,255,255,255,255,255,255,255,255,31,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Coptic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,252,255,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,7,0,254,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Cypriot(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        63,253,255,255,255,255,191,145,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Cyrillic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,2,0,0,0,0,0,3,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        127,255,255,255,255,255,255,255,255,127,255,255,255,255,255,3,
        255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,1,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Deseret(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Devanagari(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        254,255,255,255,255,255,255,243,255,63,31,255,207,255,0,32,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Ethiopic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,2,0,0,0,0,0,0,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,61,127,61,255,255,255,255,
        255,61,255,255,255,255,61,127,61,255,127,255,255,255,255,255,
        255,255,61,255,255,255,255,255,255,255,255,135,255,255,255,31,
        255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,127,0,127,127,127,127,127,127,127,127,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Georgian(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,2,0,0,0,0,0,0,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,255,255,63,0,255,255,255,255,255,23,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Glagolitic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,127,255,255,255,255,255,127,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Gothic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,255,255,255,7,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Greek(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,3,4,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,4,
        112,215,255,255,251,255,255,255,255,127,255,255,3,0,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,192,7,0,0,0,0,0,224,195,7,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,
        255,255,255,255,255,255,223,255,223,255,207,239,255,255,220,127},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,
        255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,63,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Gujarati(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        238,191,251,255,255,253,237,243,191,59,1,0,207,255,2,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Gurmukhi(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        238,135,249,255,255,253,109,211,135,57,0,94,192,255,31,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Han(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,2,3,1,1,1,
        1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,5,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,7,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,251,255,255,255,255,255,255,255,255,255,255,15,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,63,0,0,0,0,0},
        {
        160,0,0,0,254,3,0,15,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,63,255,255,255,255,255,255,255,7,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Hangul(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,2,0,0,0,0,0,0,0,3,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,
        1,1,1,1,1,4,0,0,0,0,0,0,0,0,0,5,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,131,255,255,255,255,
        255,255,255,255,7,255,255,255,255,255,255,255,255,255,255,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,254,255,255,255,255,255,255,255,255,255,
        255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,127,0,0,0,0,0,0,0,0,255,255,255,63,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,255,127,252,252,252,28,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Hanunoo(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,31,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Hebrew(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,254,255,255,255,255,251,255,0,255,255,255,7,31,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,224,255,255,127,95,219,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Hiragana(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,254,255,255,255,255,255,255,255,
        255,255,127,224,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Inherited(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,0,4,5,0,0,0,6,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,248,63,0,0,0,1,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,255,255,15,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,252,0,0,0,0,0,0,0,0,0,0,
        0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,0,0,15,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,128,3,0,248,
        231,15,0,0,0,60,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
        static const unsigned char e_pn[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Kannada(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        236,223,253,255,255,253,239,243,223,61,96,64,195,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Katakana(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,254,255,255,255,255,255,255,255,255,255,255,231,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,255,254,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Kharoshthi(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        111,240,239,254,255,255,15,135,255,0,255,1,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Khmer(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,63,255,3,255,3},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Lao(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        150,37,240,254,174,236,255,59,95,63,255,51,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Latin(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,3,4,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,6,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,254,255,255,7,254,255,255,7,
        0,0,0,0,0,4,0,4,255,255,127,255,255,255,127,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,3,0,255,255,255,255,255,255,
        255,255,255,255,255,255,255,1,0,0,0,0,31,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,63,240,255,255,255,255,255,31,60,248,255,254,
        255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,
        0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,254,255,255,7,254,255,255,7,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Limbu(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,31,255,15,255,15,241,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
LinearB(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,239,255,255,127,255,255,183,255,63,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Malayalam(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        236,223,253,255,255,253,255,195,207,61,128,0,195,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Mongolian(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,127,255,3,255,255,255,255,255,255,255,255,255,255,255,0,
        255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Myanmar(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,251,246,199,3,255,255,255,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
NewTaiLue(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,3,255,255,255,3,255,195,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Ogham(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,31,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
OldItalic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,127,15,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
OldPersian(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,255,255,15,255,63,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Oriya(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        238,159,249,255,255,253,237,243,143,57,192,176,195,255,3,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Osmanya(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,63,255,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Runic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,255,255,255,255,255,255,255,199,1,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Shavian(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Sinhala(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        236,255,127,252,255,255,251,47,127,132,95,255,0,0,28,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
SylotiNagri(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Syriac(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,191,255,255,255,255,255,255,255,231,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Tagalog(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,223,31,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Tagbanwa(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,223,13,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
TaiLe(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,255,255,63,31,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Tamil(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        236,199,61,214,24,199,255,195,199,61,128,0,192,255,255,7}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Telugu(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        238,223,253,255,255,253,239,195,223,61,96,0,195,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Thaana(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Thai(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        254,255,255,255,255,255,255,7,255,255,255,15,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Tibetan(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,254,255,255,255,7,254,255,
        255,15,255,254,255,255,255,223,255,159,3,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Tifinagh(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,255,255,255,255,255,255,63,128,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Ugaritic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Yi(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,31,255,255,255,255,255,255,127,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
ASCIIHexDigit(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,255,3,126,0,0,0,126,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
BidiControl(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,192,0,0,0,124,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Dash(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,4,0,5,0,0,6,7,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,63,0,0,0,0,0,0,0,8,0,0,0,0,8,
        0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,16,0,0,1,0,0,0,0,0,0,0,0,0,
        0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,6,0,0,0,0,1,8,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Deprecated(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,3,0,0,4,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,8,0,0,0,0,0,8,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,252,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Diacritic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,0,0,0,0,10,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,12,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,64,1,0,0,0,
        0,0,0,0,0,129,144,1,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,127,255,224,7,0,48,4,
        48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
        0,0,254,255,251,255,255,187,22,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,248,135,1,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,128,97,28,0,0,
        0,0,0,0,0,0,255,255,255,7,0,0,0,0,0,0,
        0,0,0,0,192,255,1,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,16,0,32,30,0,0,0,0,0,
        0,0,0,0,0,0,0,16,0,32,0,0,0,0,0,0,
        0,0,0,0,0,0,0,16,0,32,0,0,0,0,0,0,
        0,0,0,0,0,0,0,16,0,32,0,0,0,0,0,0,
        0,0,0,0,0,0,0,16,0,32,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,
        0,0,0,0,0,0,0,16,0,32,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,128,95,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,
        0,0,0,3,0,0,160,194,0,0,0,0,0,0,0,0,
        220,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,128,2,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,254,15,32,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,240,255,255,255,255,255,255,255,7,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,160,3,224,0,224,0,224,0,96},
        {
        0,0,0,0,0,252,0,0,0,0,0,0,0,0,0,0,
        0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,16,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,64,1,0,0,0,0,0,1,0,
        0,0,0,192,0,0,0,0,0,0,0,0,8,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,128,227,7,248,
        231,15,0,0,0,60,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Extender(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,4,0,0,5,0,0,0,0,0,6,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        32,0,0,0,0,0,62,0,0,0,0,0,0,0,0,0,
        0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,112,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
HexDigit(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,255,3,126,0,0,0,126,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,3,126,0,0,0,126,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Hyphen(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,4,0,5,0,0,6,7,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,32,0,0,0,0,0,0,0,0,0,0,32,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Ideographic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,
        1,1,1,3,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,4,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,6,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        192,0,0,0,254,3,0,7,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,63,0,0,0,0,0,0,0,0,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
IDSBinaryOperator(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,15}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
IDSTrinaryOperator(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
JoinControl(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
LogicalOrderException(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
NoncharacterCodePoint(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
OtherAlphabetic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,0,0,9,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,
        0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,255,187,182,0,0,0,0,0,0,0,
        0,0,63,0,0,0,0,0,0,248,255,126,0,0,1,0,
        0,0,0,0,0,0,0,0,0,0,192,31,158,33,0,0,
        0,0,2,0,0,0,255,255,0,0,0,0,0,0,0,0,
        0,0,0,0,192,255,1,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        14,0,0,0,0,0,0,192,255,31,0,0,12,0,0,0,
        14,0,0,0,0,0,0,192,159,25,128,0,12,0,0,0,
        14,0,0,0,0,0,0,192,135,25,0,0,0,0,3,0,
        14,0,0,0,0,0,0,192,191,27,0,0,12,0,0,0,
        14,0,0,0,0,0,0,192,143,25,192,0,0,0,0,0,
        4,0,0,0,0,0,0,192,199,29,128,0,0,0,0,0},
        {
        14,0,0,0,0,0,0,192,223,29,96,0,0,0,0,0,
        12,0,0,0,0,0,0,192,223,29,96,0,0,0,0,0,
        12,0,0,0,0,0,0,192,207,29,128,0,0,0,0,0,
        12,0,0,0,0,0,0,0,0,128,95,255,0,0,12,0,
        0,0,0,0,0,0,242,7,0,32,0,0,0,0,0,0,
        0,0,0,0,0,0,242,27,0,32,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,
        3,0,255,254,255,255,255,31,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,240,71,1,0,0,192,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,
        0,0,0,0,0,0,192,255,255,1,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,15,255,1,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,255,255,1,3,0,0,0,0,0,0,
        0,0,128,15,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,192,255,255,255,255,255,255,3,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,248,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        110,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
OtherDefaultIgnorableCodePoint(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,128,1,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,240,3,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,1,0,0,0,0,0,0,0,0,0,255,1}
 };
        static const unsigned char e_pn[] = {
        253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
OtherGraphemeExtend(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,2,3,0,0,0,0,4,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,64,0,0,128,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,64,0,0,128,0,0,0,0,0,
        0,0,0,0,0,0,0,64,0,0,128,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,4,0,96,0,0,0,0,0,
        0,0,0,0,0,0,0,64,0,0,128,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,128,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,32,192,7,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
OtherIDStart(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,1,0,64,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
OtherIDContinue(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,254,3,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
OtherLowercase(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,3,4,5,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,255,1,3,0,0,0,31,0,0,0,
        0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,4,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,240,255,255,255,255,255,255,3,0,0,1,
        0,0,0,248,255,255,255,255,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,255,255,3,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
OtherMath(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,4,5,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,39,0,0,0,51,0},
        {
        0,0,64,0,0,0,28,0,1,0,0,0,14,0,0,96,
        0,96,0,0,0,0,0,0,0,0,255,31,98,0,0,0,
        4,252,47,62,16,179,251,241,224,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,128,0,0,0,1,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,96,0,0,0,192,15,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        248,255,255,1,0,0,0,0,0,0,0,15,0,0,0,48,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,10,1,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,80,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,
        255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,
        191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,255,255,255,253,255,255,247,255,255,255,247,
        255,255,223,255,255,255,223,255,255,127,255,255,255,127,255,255,
        255,253,255,255,255,253,255,255,247,195,255,255,255,255,255,255}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
OtherUppercase(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,192,255,255,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
PatternSyntax(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,4,1,5,6,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,254,255,0,252,1,0,0,120,1,0,0,120,
        0,0,0,0,254,90,67,136,0,0,128,0,0,0,128,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,255,255,255,0,255,127,254,255,239,127,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,
        0,0,240,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        14,255,255,255,1,0,1,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,96,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
PatternWhiteSpace(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,62,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,192,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
QuotationMark(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,0,0,0,4,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,132,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,8,0,8,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,255,0,0,0,6,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,240,0,224,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        132,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Radical(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,251,255,255,255,255,255,255,255,255,255,255,15,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,63,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
SoftDotted(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,0,4,5,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
        0,0,0,32,0,0,4,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0},
        {
        0,0,0,0,0,0,0,0,0,0,64,1,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,
        0,0,64,0,16,1,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,12,0,0,0,0,0,192,0,0,0,0,0,
        0,12,0,0,0,0,0,192,0,0,0,0,0,0,12,0,
        0,0,0,0,192,0,0,0,0,0,0,12,0,0,0,0,
        0,192,0,0,0,0,0,0,12,0,0,0,0,0,192,0,
        0,0,0,0,0,12,0,0,0,0,0,192,0,0,0,0,
        0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
STerm(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,0,5,6,7,0,8,0,0,0,9,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,2,64,0,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,
        7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,132,1,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        8,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,48,128,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,196,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        2,64,0,128,0,0,0,0,0,0,0,0,2,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
TerminalPunctuation(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,0,9,0,0,0,10,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,2,80,0,140,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,
        128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,2,0,0,0,0,0,0,8,0,0,0,0,0,0,0,
        0,16,0,136,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,
        255,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,225,7,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,254,1,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,112,4,0,0,0,0},
        {
        60,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,48,128,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,247,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        2,80,0,140,0,0,0,0,0,0,0,0,18,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
UnifiedIdeograph(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,
        1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,3,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,5,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,192,26,128,154,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
VariationSelector(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
        static const unsigned char e_pn[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
WhiteSpace(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,3,4,0,5,0,0,0,6,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,62,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        32,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,7,0,0,0,131,0,0,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Alphabetic(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,11,0,12,13,1,1,1,
        1,1,1,14,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,15,1,16,17,1,1,1,1,1,
        1,1,1,1,1,18,0,0,0,0,0,0,0,0,19,20,
        21,22,23,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,25,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,254,255,255,7,254,255,255,7,
        0,0,0,0,0,4,32,4,255,255,127,255,255,255,127,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,3,0,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,195,255,3,0,31,64,0,0,
        0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,4,
        64,215,255,255,251,255,255,255,255,127,255,255,255,255,191,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        3,252,255,255,255,255,255,255,255,127,255,255,255,255,255,3,
        255,255,0,0,0,0,254,255,255,255,127,2,254,255,255,255,
        255,0,0,0,0,0,255,187,182,0,255,255,255,7,7,0,
        0,0,63,0,254,255,255,7,255,255,255,126,0,192,255,255,
        255,255,255,255,255,255,255,255,255,255,239,31,254,225,0,156,
        0,0,255,255,255,255,255,255,0,224,255,255,255,63,0,0,
        255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        254,255,255,255,255,255,255,227,255,31,1,255,15,0,0,32,
        238,159,249,255,255,253,197,227,159,89,128,176,15,0,3,0,
        238,135,249,255,255,253,109,195,135,25,0,94,0,0,31,0,
        238,191,251,255,255,253,237,227,191,27,1,0,15,0,0,0,
        238,159,249,255,255,253,237,227,143,25,192,176,3,0,2,0,
        236,199,61,214,24,199,255,195,199,29,128,0,0,0,0,0},
        {
        238,223,253,255,255,253,239,195,223,29,96,0,3,0,0,0,
        236,223,253,255,255,253,239,227,223,29,96,64,3,0,0,0,
        236,223,253,255,255,253,255,195,207,29,128,0,3,0,0,0,
        236,255,127,252,255,255,251,47,127,128,95,255,0,0,12,0,
        254,255,255,255,255,255,255,7,127,32,0,0,0,0,0,0,
        150,37,240,254,174,236,255,59,95,32,0,48,0,0,0,0,
        1,0,0,0,0,0,0,0,255,254,255,255,255,7,254,255,
        3,15,255,254,255,255,255,31,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,251,246,71,1,0,0,255,3,0,0,0,0,
        0,0,0,0,255,255,255,255,63,0,255,255,255,255,255,23,
        255,255,255,255,255,255,255,255,255,255,255,131,255,255,255,255,
        255,255,255,255,7,255,255,255,255,255,255,255,255,255,255,3,
        255,255,255,255,255,255,255,255,255,61,127,61,255,255,255,255,
        255,61,255,255,255,255,61,127,61,255,127,255,255,255,255,255,
        255,255,61,255,255,255,255,255,255,255,255,135,0,0,0,0,
        255,255,0,0,255,255,255,255,255,255,255,255,255,255,31,0},
        {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,159,127,0,
        254,255,255,7,255,255,255,255,255,255,255,255,255,7,0,0,
        255,223,15,0,255,255,15,0,255,255,15,0,255,223,13,0,
        255,255,255,255,255,255,207,255,255,1,128,16,0,0,0,0},
        {
        0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,0,
        255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,
        255,255,255,31,255,15,255,1,0,0,255,255,255,63,31,0,
        255,255,255,255,255,3,255,255,255,3,0,0,0,0,0,0,
        255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,3,
        255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,
        255,255,255,255,255,255,223,95,220,31,207,15,255,31,220,31},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,
        0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,
        132,252,47,62,80,189,251,243,224,3,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,192,255,255,255,255,255,255,3,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,127,255,255,255,255,255,127,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,
        255,255,255,255,63,0,255,255,255,255,255,255,63,128,0,0,
        255,255,127,0,127,127,127,127,127,127,127,127,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        96,0,0,0,0,0,62,24,254,255,255,255,255,255,255,255,
        255,255,127,224,254,255,255,255,255,255,255,255,255,255,255,247,
        224,255,255,255,255,31,254,255,255,255,255,255,255,255,255,255,
        255,127,0,0,255,255,255,0,0,0,0,0,0,0,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        187,247,255,255,255,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,63,255,255,255,255,255,255,255,7,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        127,0,248,224,255,253,127,95,219,255,255,255,255,255,255,255,
        255,255,255,255,255,255,3,0,0,0,248,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,63,0,0,255,255,255,255,255,255,
        255,255,252,255,255,255,255,255,255,0,0,0,0,0,255,15,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,
        0,0,0,0,254,255,255,7,254,255,255,7,192,255,255,255,
        255,255,255,255,255,255,255,127,252,252,252,28,0,0,0,0},
        {
        255,239,255,255,127,255,255,183,255,63,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,127,0,0,255,255,255,3,0,0,0,0,0,0,
        255,255,255,63,255,255,255,255,15,255,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        63,253,255,255,255,255,191,145,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        111,240,239,254,255,255,15,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,
        255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,
        191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,63,255,255,255,253,255,255,247,255,255,255,247,
        255,255,223,255,255,255,223,255,255,127,255,255,255,127,255,255,
        255,253,255,255,255,253,255,255,247,3,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Lowercase(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,0,4,5,6,0,7,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,9,
        0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,7,
        0,0,0,0,0,4,32,4,0,0,0,128,255,255,127,255,
        170,170,170,170,170,170,170,85,85,171,170,170,170,170,170,212,
        41,49,36,78,42,45,81,230,64,82,85,181,170,170,41,170,
        170,170,170,170,170,170,250,147,1,0,255,255,255,255,255,255,
        255,255,255,255,255,255,255,1,3,0,0,0,31,0,0,0,
        0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,4,
        0,0,1,0,0,240,255,255,255,127,227,170,170,170,47,25},
        {
        0,0,0,0,0,0,255,255,255,255,255,255,170,170,170,170,
        2,168,170,170,170,170,170,170,84,85,170,170,170,170,170,2,
        170,170,0,0,0,0,0,0,0,0,0,0,254,255,255,255,
        255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
        170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,
        170,170,234,15,170,170,170,170,170,170,170,170,170,170,170,2,
        255,0,63,0,255,0,255,0,63,0,255,0,255,0,255,63,
        255,0,255,0,255,0,223,64,220,0,207,0,255,0,220,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,
        0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,196,8,0,0,128,16,50,192,3,0,0,0,0,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,255,255,255,3,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,255,255,255,255,255,127,0,0,0,0,
        170,170,170,170,170,170,170,170,170,170,170,170,26,0,0,0,
        255,255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        127,0,248,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,254,255,255,7,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,252,255,255,15,0,0,192,223,255,255,0,0,0,
        252,255,255,15,0,0,192,235,239,255,0,0,0,252,255,255,
        15,0,0,192,255,255,255,0,0,0,252,255,255,15,0,0,
        192,255,255,255,0,0,0,252,255,255,15,0,0,192,255,255,
        255,0,0,0,252,255,255,15,0,0,192,255,255,255,0,0,
        0,252,255,255,63,0,0,0,252,255,255,247,3,0,0,240,
        255,255,223,15,0,0,192,255,255,127,63,0,0,0,255,255,
        255,253,0,0,0,252,255,255,247,3,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Uppercase(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,4,0,0,5,6,7,0,8,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,
        0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,254,255,255,7,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,127,127,0,0,0,0,
        85,85,85,85,85,85,85,170,170,84,85,85,85,85,85,43,
        214,206,219,177,213,210,174,17,144,164,170,74,85,85,210,85,
        85,85,85,85,85,85,5,108,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        64,215,254,255,251,15,0,0,0,0,28,85,85,85,144,230},
        {
        255,255,255,255,255,255,0,0,0,0,0,0,85,85,85,85,
        1,84,85,85,85,85,85,85,171,42,85,85,85,85,85,1,
        85,85,0,0,0,0,254,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,255,255,255,255,63,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
        85,85,21,0,85,85,85,85,85,85,85,85,85,85,85,1,
        0,255,0,63,0,255,0,255,0,63,0,170,0,255,0,0,
        0,0,0,0,0,0,0,15,0,15,0,15,0,31,0,15},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        132,56,39,62,80,61,11,192,32,0,0,0,255,255,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,192,255,255,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,127,0,0,0,0,0,0,0,0,0,0,
        85,85,85,85,85,85,85,85,85,85,85,85,5,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,254,255,255,7,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,3,0,0,240,255,255,63,0,0,0,255,255,255,
        3,0,0,208,100,222,63,0,0,0,255,255,255,3,0,0,
        176,231,223,31,0,0,0,123,95,252,1,0,0,240,255,255,
        63,0,0,0,255,255,255,3,0,0,240,255,255,63,0,0,
        0,255,255,255,3,0,0,240,255,255,63,0,0,0,255,255,
        255,3,0,0,0,255,255,255,1,0,0,0,252,255,255,7,
        0,0,0,240,255,255,31,0,0,0,192,255,255,127,0,0,
        0,0,255,255,255,1,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Math(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,3,4,5,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,8,0,112,0,0,0,64,0,0,0,80,
        0,0,0,0,0,16,2,0,0,0,128,0,0,0,128,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,39,0,0,0,115,0},
        {
        0,0,64,0,0,0,28,0,17,0,4,0,14,0,0,124,
        0,124,0,0,0,0,0,0,0,0,255,31,98,0,0,0,
        4,252,47,62,16,179,251,241,255,11,0,0,0,0,0,0,
        0,0,31,12,73,64,0,0,0,192,20,0,0,0,240,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,15,0,0,3,0,0,0,0,0,0,0,0,0,0,16,
        0,0,0,248,255,255,143,0,0,0,1,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,128,0,2,0,0,0,0,0,0,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,127,0,255,255,255,15,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,126,1,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,8,0,112,0,0,0,80,0,0,0,80,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,4,30,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,
        255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,
        191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,195,255,255,255,255,255,255}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
IDStart(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,0,0,11,12,1,1,1,
        1,1,1,13,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,14,1,15,16,1,1,1,1,1,
        1,1,1,1,1,17,0,0,0,0,0,0,0,0,18,19,
        20,21,22,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,23,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,24,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,254,255,255,7,254,255,255,7,
        0,0,0,0,0,4,32,4,255,255,127,255,255,255,127,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,3,0,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,195,255,3,0,31,64,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,
        64,215,255,255,251,255,255,255,255,127,255,255,255,255,191,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        3,252,255,255,255,255,255,255,255,127,255,255,255,255,255,3,
        255,255,0,0,0,0,254,255,255,255,127,2,254,255,255,255,
        255,0,0,0,0,0,0,0,0,0,255,255,255,7,7,0,
        0,0,0,0,254,255,255,7,255,7,0,0,0,192,254,255,
        255,255,255,255,255,255,255,255,255,255,47,0,96,192,0,156,
        0,0,253,255,255,255,0,0,0,224,255,255,255,63,0,0,
        255,255,255,255,63,0,2,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        240,255,255,255,255,255,255,35,0,0,1,255,3,0,0,32,
        224,159,249,255,255,253,197,35,0,64,0,176,3,0,3,0,
        224,135,249,255,255,253,109,3,0,0,0,94,0,0,28,0,
        224,191,251,255,255,253,237,35,0,0,1,0,3,0,0,0,
        224,159,249,255,255,253,237,35,0,0,0,176,3,0,2,0,
        232,199,61,214,24,199,255,3,0,0,0,0,0,0,0,0},
        {
        224,223,253,255,255,253,239,3,0,0,0,0,3,0,0,0,
        224,223,253,255,255,253,239,35,0,0,0,64,3,0,0,0,
        224,223,253,255,255,253,255,3,0,0,0,0,3,0,0,0,
        224,255,127,252,255,255,251,47,127,0,0,0,0,0,0,0,
        254,255,255,255,255,255,13,0,127,0,0,0,0,0,0,0,
        150,37,240,254,174,236,13,32,95,0,0,48,0,0,0,0,
        1,0,0,0,0,0,0,0,255,254,255,255,255,7,0,0,
        0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,251,6,0,0,0,0,63,0,0,0,0,0,
        0,0,0,0,255,255,255,255,63,0,255,255,255,255,255,23,
        255,255,255,255,255,255,255,255,255,255,255,131,255,255,255,255,
        255,255,255,255,7,255,255,255,255,255,255,255,255,255,255,3,
        255,255,255,255,255,255,255,255,255,61,127,61,255,255,255,255,
        255,61,255,255,255,255,61,127,61,255,127,255,255,255,255,255,
        255,255,61,255,255,255,255,255,255,255,255,7,0,0,0,0,
        255,255,0,0,255,255,255,255,255,255,255,255,255,255,31,0},
        {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,159,127,0,
        254,255,255,7,255,255,255,255,255,255,255,255,255,199,1,0,
        255,223,3,0,255,255,3,0,255,255,3,0,255,223,1,0,
        255,255,255,255,255,255,15,0,0,0,128,16,0,0,0,0},
        {
        0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,0,
        255,255,255,255,255,1,0,0,0,0,0,0,0,0,0,0,
        255,255,255,31,0,0,0,0,0,0,255,255,255,63,31,0,
        255,255,255,255,255,3,0,0,254,0,0,0,0,0,0,0,
        255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,3,
        255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,
        255,255,255,255,255,255,223,95,220,31,207,15,255,31,220,31},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,
        0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,
        132,252,47,62,80,189,251,243,224,3,0,0,255,255,255,255,
        15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,127,255,255,255,255,255,127,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,
        255,255,255,255,63,0,255,255,255,255,255,255,63,128,0,0,
        255,255,127,0,127,127,127,127,127,127,127,127,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        224,0,0,0,254,3,62,31,254,255,255,255,255,255,255,255,
        255,255,127,224,254,255,255,255,255,255,255,255,255,255,255,247,
        224,255,255,255,255,31,254,255,255,255,255,255,255,255,255,255,
        255,127,0,0,255,255,255,0,0,0,0,0,0,0,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        187,247,255,255,7,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,63,255,255,255,255,255,255,255,7,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        127,0,248,160,255,253,127,95,219,255,255,255,255,255,255,255,
        255,255,255,255,255,255,3,0,0,0,248,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,63,0,0,255,255,255,255,255,255,
        255,255,252,255,255,255,255,255,255,0,0,0,0,0,255,15,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,
        0,0,0,0,254,255,255,7,254,255,255,7,192,255,255,255,
        255,255,255,255,255,255,255,127,252,252,252,28,0,0,0,0},
        {
        255,239,255,255,127,255,255,183,255,63,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,31,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,127,0,0,255,255,255,7,0,0,0,0,0,0,
        255,255,255,63,255,255,255,255,15,255,62,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        63,253,255,255,255,255,191,145,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,0,239,254,255,255,15,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,
        255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,
        191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,63,255,255,255,253,255,255,247,255,255,255,247,
        255,255,223,255,255,255,223,255,255,127,255,255,255,127,255,255,
        255,253,255,255,255,253,255,255,247,3,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
IDContinue(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,0,0,11,12,1,1,1,
        1,1,1,13,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,14,1,15,16,1,1,1,1,1,
        1,1,1,1,1,17,0,0,0,0,0,0,0,0,18,19,
        20,21,22,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,23,24,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,25,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,255,3,254,255,255,135,254,255,255,7,
        0,0,0,0,0,4,32,4,255,255,127,255,255,255,127,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,3,0,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,195,255,3,0,31,64,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,4,
        64,215,255,255,251,255,255,255,255,127,255,255,255,255,191,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        123,252,255,255,255,255,255,255,255,127,255,255,255,255,255,3,
        255,255,0,0,0,0,254,255,255,255,127,2,254,255,255,255,
        255,0,254,255,255,255,255,187,182,0,255,255,255,7,7,0,
        0,0,63,0,254,255,255,7,255,255,255,127,255,195,255,255,
        255,255,255,255,255,255,255,255,255,255,239,159,255,253,255,159,
        0,0,255,255,255,255,255,255,255,231,255,255,255,63,0,0,
        255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        254,255,255,255,255,255,255,243,255,63,31,255,207,255,0,32,
        238,159,249,255,255,253,197,243,159,121,128,176,207,255,3,0,
        238,135,249,255,255,253,109,211,135,57,0,94,192,255,31,0,
        238,191,251,255,255,253,237,243,191,59,1,0,207,255,0,0,
        238,159,249,255,255,253,237,243,143,57,192,176,195,255,2,0,
        236,199,61,214,24,199,255,195,199,61,128,0,192,255,0,0},
        {
        238,223,253,255,255,253,239,195,223,61,96,0,195,255,0,0,
        236,223,253,255,255,253,239,243,223,61,96,64,195,255,0,0,
        236,223,253,255,255,253,255,195,207,61,128,0,195,255,0,0,
        236,255,127,252,255,255,251,47,127,132,95,255,0,0,12,0,
        254,255,255,255,255,255,255,7,255,127,255,3,0,0,0,0,
        150,37,240,254,174,236,255,59,95,63,255,51,0,0,0,0,
        1,0,0,3,255,3,160,194,255,254,255,255,255,7,254,255,
        223,15,255,254,255,255,255,31,64,0,0,0,0,0,0,0},
        {
        255,255,255,255,251,246,199,3,255,3,255,3,0,0,0,0,
        0,0,0,0,255,255,255,255,63,0,255,255,255,255,255,23,
        255,255,255,255,255,255,255,255,255,255,255,131,255,255,255,255,
        255,255,255,255,7,255,255,255,255,255,255,255,255,255,255,3,
        255,255,255,255,255,255,255,255,255,61,127,61,255,255,255,255,
        255,61,255,255,255,255,61,127,61,255,127,255,255,255,255,255,
        255,255,61,255,255,255,255,255,255,255,255,135,0,0,0,0,
        255,255,0,0,255,255,255,255,255,255,255,255,255,255,31,0},
        {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,159,127,0,
        254,255,255,7,255,255,255,255,255,255,255,255,255,199,1,0,
        255,223,31,0,255,255,31,0,255,255,15,0,255,223,13,0,
        255,255,255,255,255,255,207,255,255,255,143,48,255,3,0,0},
        {
        0,56,255,3,255,255,255,255,255,255,255,255,255,255,255,0,
        255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,
        255,255,255,31,255,15,255,15,192,255,255,255,255,63,31,0,
        255,255,255,255,255,3,255,255,255,3,255,3,0,0,0,0,
        255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,3,
        255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,
        255,255,255,255,255,255,223,95,220,31,207,15,255,31,220,31},
        {
        0,0,0,0,0,0,0,128,1,0,16,0,0,0,2,128,
        0,0,31,0,0,0,0,0,0,0,255,31,226,15,0,0,
        132,252,47,62,80,189,251,243,224,3,0,0,255,255,255,255,
        15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,127,255,255,255,255,255,127,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,
        255,255,255,255,63,0,255,255,255,255,255,255,63,128,0,0,
        255,255,127,0,127,127,127,127,127,127,127,127,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        224,0,0,0,254,255,62,31,254,255,255,255,255,255,255,255,
        255,255,127,230,254,255,255,255,255,255,255,255,255,255,255,247,
        224,255,255,255,255,31,254,255,255,255,255,255,255,255,255,255,
        255,127,0,0,255,255,255,0,0,0,0,0,0,0,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,63,255,255,255,255,255,255,255,7,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        127,0,248,224,255,253,127,95,219,255,255,255,255,255,255,255,
        255,255,255,255,255,255,3,0,0,0,248,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,63,0,0,255,255,255,255,255,255,
        255,255,252,255,255,255,255,255,255,0,0,0,0,0,255,15,
        255,255,0,0,15,0,24,0,0,224,0,0,0,0,223,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,
        0,0,255,3,254,255,255,135,254,255,255,7,192,255,255,255,
        255,255,255,255,255,255,255,127,252,252,252,28,0,0,0,0},
        {
        255,239,255,255,127,255,255,183,255,63,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,31,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,127,0,0,255,255,255,7,0,0,0,0,0,0,
        255,255,255,63,255,255,255,255,15,255,62,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,255,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        63,253,255,255,255,255,191,145,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        111,240,239,254,255,255,15,135,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,224,227,7,248,
        231,15,0,0,0,60,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,
        255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,
        191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,63,255,255,255,253,255,255,247,255,255,255,247,
        255,255,223,255,255,255,223,255,255,127,255,255,255,127,255,255,
        255,253,255,255,255,253,255,255,247,195,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
        static const unsigned char e_pn[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Any(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,2,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,0,0,0,0,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63}
 };
#define e_pv 1        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Assigned(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,11,12,13,14,1,1,1,
        1,1,1,15,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,16,1,17,18,1,1,1,1,1,
        1,1,1,1,1,19,0,0,1,1,1,1,1,1,20,21,
        22,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,25,26,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,27,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,3,0,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,48,68,
        240,215,255,255,251,255,255,255,255,127,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        127,255,255,255,255,255,255,255,255,127,255,255,255,255,255,3,
        255,255,0,0,0,0,254,255,255,255,127,254,254,255,255,255,
        255,6,254,255,255,255,255,251,255,0,255,255,255,7,31,0,
        15,248,63,200,254,255,255,7,255,255,255,127,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,191,255,255,255,255,255,255,255,231,255,255,255,63,0,0,
        255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        254,255,255,255,255,255,255,243,255,63,31,255,255,255,1,32,
        238,159,249,255,255,253,197,243,159,121,128,176,207,255,255,7,
        238,135,249,255,255,253,109,211,135,57,0,94,192,255,31,0,
        238,191,251,255,255,253,237,243,191,59,1,0,207,255,2,0,
        238,159,249,255,255,253,237,243,143,57,192,176,195,255,3,0,
        236,199,61,214,24,199,255,195,199,61,128,0,192,255,255,7},
        {
        238,223,253,255,255,253,239,195,223,61,96,0,195,255,0,0,
        236,223,253,255,255,253,239,243,223,61,96,64,195,255,0,0,
        236,223,253,255,255,253,255,195,207,61,128,0,195,255,0,0,
        236,255,127,252,255,255,251,47,127,132,95,255,0,0,28,0,
        254,255,255,255,255,255,255,135,255,255,255,15,0,0,0,0,
        150,37,240,254,174,236,255,59,95,63,255,51,0,0,0,0,
        255,255,255,255,255,255,255,255,255,254,255,255,255,7,254,255,
        255,15,255,254,255,255,255,223,255,159,3,0,0,0,0,0},
        {
        255,255,255,255,251,246,199,3,255,255,255,3,0,0,0,0,
        0,0,0,0,255,255,255,255,63,0,255,255,255,255,255,31,
        255,255,255,255,255,255,255,255,255,255,255,131,255,255,255,255,
        255,255,255,255,7,255,255,255,255,255,255,255,255,255,255,3,
        255,255,255,255,255,255,255,255,255,61,127,61,255,255,255,255,
        255,61,255,255,255,255,61,127,61,255,127,255,255,255,255,255,
        255,255,61,255,255,255,255,255,255,255,255,135,255,255,255,31,
        255,255,255,3,255,255,255,255,255,255,255,255,255,255,31,0},
        {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,0,
        255,255,255,31,255,255,255,255,255,255,255,255,255,255,1,0,
        255,223,31,0,255,255,127,0,255,255,15,0,255,223,13,0,
        255,255,255,255,255,255,255,255,255,255,255,63,255,3,255,3},
        {
        255,127,255,3,255,255,255,255,255,255,255,255,255,255,255,0,
        255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,
        255,255,255,31,255,15,255,15,241,255,255,255,255,63,31,0,
        255,255,255,255,255,3,255,255,255,3,255,195,255,255,255,255,
        255,255,255,207,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,3,
        255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,
        255,255,255,255,255,255,223,255,223,255,207,239,255,255,220,127},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,15,252,243,255,
        255,127,31,0,255,255,63,0,0,0,255,255,255,15,0,0,
        255,255,255,255,255,255,255,255,255,31,248,255,255,255,255,255,
        15,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0},
        {
        255,255,255,255,127,0,0,0,255,7,0,0,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,31,255,255,3,0,0,0,0,0,0,0,0,0,
        222,243,255,255,255,254,255,255,255,175,71,127,254,255,255,255,
        255,255,31,255,255,255,254,127,127,0,255,255,255,15,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,127,255,255,255,255,255,127,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,7,0,254,
        255,255,255,255,63,0,255,255,255,255,255,255,63,128,0,0,
        255,255,127,0,127,127,127,127,127,127,127,127,0,0,0,0,
        255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,251,255,255,255,255,255,255,255,255,255,255,15,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,63,0,0,0,255,15},
        {
        255,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,
        255,255,127,254,255,255,255,255,255,255,255,255,255,255,255,255,
        224,255,255,255,255,31,254,255,255,255,255,255,255,255,255,255,
        255,127,255,255,255,255,255,0,255,255,0,0,0,0,255,255,
        255,255,255,127,255,255,255,255,15,0,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,31,255,255,255,255,255,255,127,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,63,255,255,255,255,255,255,255,7,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        127,0,248,224,255,255,127,95,219,255,255,255,255,255,255,255,
        255,255,255,255,255,255,3,0,0,0,248,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,
        255,255,252,255,255,255,255,255,255,0,0,0,0,0,255,63,
        255,255,255,3,15,0,255,255,255,255,247,255,127,15,223,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,159,
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,127,252,252,252,28,127,127,0,62},
        {
        255,239,255,255,127,255,255,183,255,63,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,
        135,255,255,255,255,255,143,255,255,255,255,255,255,255,255,255,
        255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,127,15,0,255,255,255,7,0,0,0,0,0,0,
        255,255,255,191,255,255,255,255,15,255,63,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,255,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        63,253,255,255,255,255,191,145,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        111,240,239,254,255,255,15,135,255,0,255,1,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,
        255,255,255,255,127,252,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,63,0,0,0,0,
        255,255,255,255,255,255,255,255,63,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,
        255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,
        191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,63,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,195,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
        static const unsigned char e_pn[] = {
        2,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Unassigned(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,8,9,10,11,12,13,14,0,0,0,
        0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,16,0,17,18,0,0,0,0,0,
        0,0,0,0,0,19,0,0,0,0,0,0,0,0,20,21,
        22,23,24,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,25,26,1,1,1,1,1,1,1,1,1,27,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,28,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,29,30,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,31 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,252,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,187,
        15,40,0,0,4,0,0,0,0,128,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        128,0,0,0,0,0,0,0,0,128,0,0,0,0,0,252,
        0,0,255,255,255,255,1,0,0,0,128,1,1,0,0,0,
        0,249,1,0,0,0,0,4,0,255,0,0,0,248,224,255,
        240,7,192,55,1,0,0,248,0,0,0,128,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,64,0,0,0,0,0,0,0,24,0,0,0,192,255,255,
        0,0,0,0,0,0,252,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        1,0,0,0,0,0,0,12,0,192,224,0,0,0,254,223,
        17,96,6,0,0,2,58,12,96,134,127,79,48,0,0,248,
        17,120,6,0,0,2,146,44,120,198,255,161,63,0,224,255,
        17,64,4,0,0,2,18,12,64,196,254,255,48,0,253,255,
        17,96,6,0,0,2,18,12,112,198,63,79,60,0,252,255,
        19,56,194,41,231,56,0,60,56,194,127,255,63,0,0,248},
        {
        17,32,2,0,0,2,16,60,32,194,159,255,60,0,255,255,
        19,32,2,0,0,2,16,12,32,194,159,191,60,0,255,255,
        19,32,2,0,0,2,0,60,48,194,127,255,60,0,255,255,
        19,0,128,3,0,0,4,208,128,123,160,0,255,255,227,255,
        1,0,0,0,0,0,0,120,0,0,0,240,255,255,255,255,
        105,218,15,1,81,19,0,196,160,192,0,204,255,255,255,255,
        0,0,0,0,0,0,0,0,0,1,0,0,0,248,1,0,
        0,240,0,1,0,0,0,32,0,96,252,255,255,255,255,255},
        {
        0,0,0,0,4,9,56,252,0,0,0,252,255,255,255,255,
        255,255,255,255,0,0,0,0,192,255,0,0,0,0,0,224,
        0,0,0,0,0,0,0,0,0,0,0,124,0,0,0,0,
        0,0,0,0,248,0,0,0,0,0,0,0,0,0,0,252,
        0,0,0,0,0,0,0,0,0,194,128,194,0,0,0,0,
        0,194,0,0,0,0,194,128,194,0,128,0,0,0,0,0,
        0,0,194,0,0,0,0,0,0,0,0,120,0,0,0,224,
        0,0,0,252,0,0,0,0,0,0,0,0,0,0,224,255},
        {
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,
        0,0,0,224,0,0,0,0,0,0,0,0,0,0,254,255,
        0,32,224,255,0,0,128,255,0,0,240,255,0,32,242,255,
        0,0,0,0,0,0,0,0,0,0,0,192,0,252,0,252},
        {
        0,128,0,252,0,0,0,0,0,0,0,0,0,0,0,255,
        0,0,0,0,0,252,255,255,255,255,255,255,255,255,255,255,
        0,0,0,224,0,240,0,240,14,0,0,0,0,192,224,255,
        0,0,0,0,0,252,0,0,0,252,0,60,0,0,0,0,
        0,0,0,48,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,240,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,252,
        0,0,192,192,0,0,0,0,192,192,0,85,0,0,0,192,
        0,0,0,0,0,0,32,0,32,0,48,16,0,0,35,128},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,240,3,12,0,
        0,128,224,255,0,0,192,255,255,255,0,0,0,240,255,255,
        0,0,0,0,0,0,0,0,0,224,7,0,0,0,0,0,
        240,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,240,255,255,255,255},
        {
        0,0,0,0,128,255,255,255,0,248,255,255,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,224,0,0,252,255,255,255,255,255,255,255,255,255,
        33,12,0,0,0,1,0,0,0,80,184,128,1,0,0,0,
        0,0,224,0,0,0,1,128,128,255,0,0,0,240,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,240,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,128,0,0,0,0,0,128,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,1,
        0,0,0,0,192,255,0,0,0,0,0,0,192,127,255,255,
        0,0,128,255,128,128,128,128,128,128,128,128,255,255,255,255,
        0,0,0,207,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,4,0,0,0,0,0,0,0,0,0,0,240,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,192,255,255,255,0,240},
        {
        0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
        0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,
        31,0,0,0,0,224,1,0,0,0,0,0,0,0,0,0,
        0,128,0,0,0,0,0,255,0,0,255,255,255,255,0,0,
        0,0,0,128,0,0,0,0,240,255,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,240,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,224,0,0,0,0,0,0,128,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,240,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,240,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,192,0,0,0,0,0,0,0,248,0,0,
        0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,255,
        128,255,7,31,0,0,128,160,36,0,0,0,0,0,0,0,
        0,0,0,0,0,0,252,255,255,255,7,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,
        0,0,3,0,0,0,0,0,0,255,0,0,0,0,0,192,
        0,0,0,252,240,255,0,0,0,0,8,0,128,240,32,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,128,3,3,3,227,128,128,255,1},
        {
        0,16,0,0,128,0,0,72,0,192,0,192,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,
        120,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,
        0,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,128,240,255,0,0,0,248,255,255,255,255,255,255,
        0,0,0,64,0,0,0,0,240,0,192,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,192,0,252,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        192,2,0,0,0,0,64,110,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        144,15,16,1,0,0,240,120,0,255,0,254,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,255,
        0,0,0,0,128,3,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,192,255,255,255,255,
        0,0,0,0,0,0,0,0,192,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,
        0,0,0,32,155,33,0,20,16,0,0,0,0,0,0,0,
        64,24,32,32,0,0,0,132,160,3,2,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,192,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63}
 };
        static const unsigned char e_pn[] = {
        253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
ASCII(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
Common(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,4,5,6,7,0,0,8,9,10,11,12,0,0,0,
        0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,1,1,1,1,1,15,16,
        17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,18,19,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,1,0,0,248,1,0,0,248,
        255,255,255,255,255,251,255,251,0,0,128,0,0,0,128,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,254,255,255,255,255,224,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,
        128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        15,16,0,136,0,0,0,0,1,0,0,0,255,3,0,0,
        0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,48,0,1,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,
        0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,207,255,255,255,255,255,255,255,255,255,255,15,252,241,127,
        255,127,0,0,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,191,243,255,255,255,31,248,255,255,255,255,255,
        15,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0},
        {
        255,255,255,255,127,0,0,0,255,7,0,0,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,31,255,255,3,0,0,0,0,0,0,0,0,0,
        222,243,255,255,255,254,255,255,255,175,71,127,254,255,255,255,
        255,255,31,255,255,255,254,127,127,0,255,255,255,15,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,15},
        {
        95,255,255,255,1,0,255,240,0,0,0,0,0,0,0,0,
        0,0,0,24,1,0,0,0,0,0,0,0,0,0,0,24,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,255,0,0,0,0,255,255,0,0,0,0,0,0,
        0,0,0,0,255,255,255,255,15,0,255,255,0,0,0,192,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,
        0,0,255,3,0,0,255,255,255,255,247,255,127,15,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,
        254,255,255,255,1,0,0,248,1,0,0,248,63,0,1,0,
        0,0,0,192,0,0,0,0,0,0,0,0,127,127,0,62},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        135,255,255,255,255,255,143,255,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,
        255,255,255,255,127,252,255,255,255,255,255,255,127,252,255,7,
        24,240,255,255,255,195,255,255,255,255,255,63,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,
        255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,
        191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,63,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,195,255,255,255,255,255,255}
 };
        static const unsigned char e_pn[] = {
        2,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
EaF(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        254,255,255,255,255,255,255,255,255,255,255,255,1,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,127,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
EaH(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,31,0,127,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
EaA(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,0,0,0,0,0,0,4,5,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,1,1,1,1,1,6,7,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,146,101,223,247,64,0,129,193,67,55,141,87,
        2,0,10,8,192,8,14,129,23,47,12,0,192,8,0,0,
        0,0,0,0,0,0,0,0,0,64,85,21,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,
        0,0,0,0,0,0,0,0,144,46,1,175,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,
        0,0,254,255,255,3,254,255,251,3,0,0,0,0,0,0},
        {
        2,0,255,255,255,255,255,255,255,255,2,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,121,51,247,0,45,72,0,0,0,0,0,0,16,128,
        30,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,
        40,2,72,0,70,8,0,0,0,0,24,120,255,15,255,3,
        0,0,255,3,0,0,0,3,0,0,20,0,128,0,0,0,
        141,137,34,228,169,95,240,48,0,17,4,0,243,204,0,0,
        204,0,32,2,32,0,0,128,0,0,0,0,0,0,0,0,
        0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,251,255,255,
        255,255,255,255,255,255,255,255,255,15,255,255,255,255,15,0,
        255,255,60,0,251,3,204,48,195,201,3,0,60,128,0,0,
        96,194,48,80,0,0,0,0,5,0,0,0,187,183,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,32,0,0,0,0,0,0,192,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32}
 };
        static const unsigned char e_pn[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
EaNa(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,0,0,0,0,0,0,0,0,3,4,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,127,
        0,0,0,0,108,144,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,192,15,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
EaW(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,2,0,0,0,3,0,0,4,5,1,1,1,
        1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,7,1,8,0,1,1,1,1,1,
        1,1,1,1,1,9,0,0,0,0,0,0,0,0,10,11,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,12,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,13 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15},
        {
        254,255,255,255,255,255,255,127,254,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,127,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,3,0,0,255,255,255,255,255,255,255,15,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
EaN(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,3,1,1,4,1,1,1,5,6,7,8,9,0,0,0,
        0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,11,12,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,14,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,128,
        255,255,255,255,1,10,32,8,191,255,126,62,188,200,114,168,
        253,255,245,247,63,247,241,126,232,208,243,255,63,247,255,255,
        255,255,255,255,255,255,255,255,255,191,170,234,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,253,255,253,255,255,255,
        255,255,255,255,255,255,255,255,111,209,254,80,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,255,
        255,255,1,0,0,252,1,0,4,252,255,255,255,255,255,255},
        {
        253,255,0,0,0,0,0,0,0,0,253,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,134,204,8,255,210,183,255,255,255,255,255,255,227,127,
        225,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,
        215,253,183,255,185,247,255,255,255,127,224,135,0,240,0,252,
        31,0,0,252,255,255,255,252,255,255,235,255,127,255,255,255,
        114,118,221,27,86,160,15,207,255,238,251,255,12,51,255,255,
        51,255,223,253,223,255,255,127,255,255,255,255,255,255,255,255,
        255,255,251,255,255,249,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,7,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,
        0,0,0,0,0,0,0,0,0,240,0,0,0,0,240,255,
        0,0,195,255,4,252,51,207,60,54,252,255,195,127,255,255,
        159,61,207,175,255,255,255,255,250,255,255,255,68,72,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,223,255,255,255,255,255,255,63,0,
        255,255,255,255,255,255,255,255,255,255,255,255,63,0,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        159,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,0,0,0,0,255,63,
        0,0,0,0,15,0,0,0,0,0,0,0,0,0,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30}
 };
        static const unsigned char e_pn[] = {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
EaFullwidth0(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,2,0,0,0,3,0,0,4,5,1,1,1,
        1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,7,1,8,0,1,1,1,1,1,
        1,1,1,1,1,9,0,0,0,0,0,0,0,0,10,11,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,12,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,13 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15},
        {
        255,255,255,255,255,255,255,127,254,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,127,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,3,0,0,255,255,255,255,255,255,255,15,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        254,255,255,255,255,255,255,255,255,255,255,255,1,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,127,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
EaFullwidth1(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        0,0,0,0,2,0,0,0,3,0,0,4,5,1,1,1,
        1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,7,1,8,0,1,1,1,1,1,
        1,1,1,1,1,9,0,0,0,0,0,0,0,0,10,11,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,12,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,13 };
        static const unsigned char r[][128] = { 

        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15},
        {
        255,255,255,255,255,255,255,127,254,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,127,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,255,3,0,0,255,255,255,255,255,255,255,15,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        254,255,255,255,255,255,255,255,255,255,255,255,1,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,127,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63}
 };
#define e_pv 0        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
EaHalfwidth0(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,1,1,1,3,1,1,1,4,5,1,6,7,0,0,0,
        0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,9,10,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,1,1,1,1,1,11,12,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,240,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,243,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,127,248,255,255,255,255,255,
        31,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,249,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,7,0,0,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,15,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,0,0,0,0,255,63,
        255,255,0,0,15,0,0,0,0,0,0,0,0,0,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,31,0,127,0,62}
 };
        static const unsigned char e_pn[] = {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


void
EaHalfwidth1(...)
    PPCODE:                                                    // r = root pv = page_value pn = page_name
        static const unsigned char pv[] = { 
        2,1,1,1,3,1,1,1,4,5,1,6,7,0,0,0,
        0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,9,10,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,1,1,1,1,1,11,12,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
        static const unsigned char r[][128] = { 

        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,240,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,
        0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,243,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,127,248,255,255,255,255,255,
        31,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,249,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,7,0,0,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,15,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
        {
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,0,0,0,0,255,63,
        255,255,0,0,15,0,0,0,0,0,0,0,0,0,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,31,0,127,0,62}
 };
        static const unsigned char e_pn[] = {
        254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
        255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0};        
        unsigned int i;

        EXTEND(SP, items);
        for( i = 0; i < items; ++i) {
            unsigned int ucs_char;
            unsigned int high;
            unsigned int idx;        
            unsigned int low;

            ucs_char = (unsigned int)SvUV(ST(i));

            high = ucs_char >>  10;             /* divide 0x400 */

            if( ucs_char < 0x40000 ) {                   /*  have table, ucs_char is in usual part  */ 
                if( (idx = pv[high]) < 2 ) {
                    ucs_char = pv[high];                      /* pv = page_value, uniform value in this page */
                } else {
                    low  = ucs_char & 0x3FF;             /* mod 0x400 */
                    ucs_char = (r[idx-2][low>>3] >> (low & 0x7)) & 1 ; // 8
                }
            } else if( ucs_char >= 0xE0001 && ucs_char <= 0xE01EF ) { // note: in a page
#ifdef e_pv
                    ucs_char = e_pv ;                         /* e_pv = e_page_value */
#undef e_pv
#else
                    ucs_char = (e_pn[(ucs_char & 0xFFFF) >> 3] >> (ucs_char & 0x7)) & 1 ; // 8
#endif
            } else if( ucs_char >= 0xF0000 ) {           /* when ucs_char is large, optimized nested if-else */
                if( ucs_char    <= 0xFFFFD ) {
                    ucs_char = 15;               /* Plane 15 */
                } else if( ucs_char >= 0x100000 && ucs_char <= 0x10FFFD ) {
                    ucs_char = 16;                /* Plane 16 */
                } else {
                    ucs_char = 0;                /* FFFFE, FFFFF, 0x11xxxx or so... */
                }
            } else {
                    ucs_char = -1 ;               /* 0x40000, 0xC1234, or so... */
            }
            mPUSHu(ucs_char);
        }
        XSRETURN(items);


