# *** DO NOT EDIT *** generated file *** DO NOT EDIT ***
#
# generated by lib/Net/IDN/UTS46/GenTests.PL from data/IdnaTest.txt
# see repository at http://github.com/cfaerber/Net-IDN-Encode for source files
#
use strict;
use utf8;
use warnings;

BEGIN {
  binmode STDOUT, ':utf8';
  binmode STDERR, ':utf8';
}

use Test::More tests => 3788 + 1;
use Test::NoWarnings;

use Unicode::UCD;
use Net::IDN::UTS46 (':all');

no warnings 'utf8';

our $UCD_VERSION = eval('v'.(Unicode::UCD::UnicodeVersion()));

my %p = ("TransitionalProcessing" => "1");

is(eval{uts46_to_ascii("fass.de", %p)},	"fass.de",	"to_ascii\(\'fass\.de\'\)\ \[data\/IdnaTest\.txt\:61\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("faß.de", %p)},	"fass.de",	"to_ascii\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:62\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Faß.de", %p)},	"fass.de",	"to_ascii\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:64\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fa-hia.de", %p)},	"xn--fa-hia.de",	"to_ascii\(\'xn\-\-fa\-hia\.de\'\)\ \[data\/IdnaTest\.txt\:66\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à\x{05D0}", %p)},	undef,	"to_ascii\(\'à\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:70\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}\x{05D0}", %p)},	undef,	"to_ascii\(\'a\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:71\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}\x{05D0}", %p)},	undef,	"to_ascii\(\'A\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:72\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À\x{05D0}", %p)},	undef,	"to_ascii\(\'À\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:73\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0à.\x{05D0}", %p)},	"xn--0-sfa.xn--4db",	"to_ascii\(\'0à\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:74\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0a\x{0300}.\x{05D0}", %p)},	"xn--0-sfa.xn--4db",	"to_ascii\(\'0a\\u0300\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:75\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0A\x{0300}.\x{05D0}", %p)},	"xn--0-sfa.xn--4db",	"to_ascii\(\'0A\\u0300\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:76\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0À.\x{05D0}", %p)},	"xn--0-sfa.xn--4db",	"to_ascii\(\'0À\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:77\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0-sfa.xn--4db", %p)},	"xn--0-sfa.xn--4db",	"to_ascii\(\'xn\-\-0\-sfa\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:78\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à.\x{05D0}\x{0308}", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'à\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:79\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}.\x{05D0}\x{0308}", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'a\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:80\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}.\x{05D0}\x{0308}", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'A\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:81\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À.\x{05D0}\x{0308}", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'À\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:82\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca.xn--ssa73l", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'xn\-\-0ca\.xn\-\-ssa73l\'\)\ \[data\/IdnaTest\.txt\:83\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_ascii\(\'à\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:84\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_ascii\(\'a\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:85\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_ascii\(\'A\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:86\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_ascii\(\'À\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:87\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}.\x{05D0}", %p)},	undef,	"to_ascii\(\'\\u0308\.\\u05D0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:88\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à.\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'à\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:89\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'a\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:90\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'A\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:91\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À.\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'À\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:92\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("àˇ.\x{05D0}", %p)},	"xn--0ca88g.xn--4db",	"to_ascii\(\'àˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:93\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}ˇ.\x{05D0}", %p)},	"xn--0ca88g.xn--4db",	"to_ascii\(\'a\\u0300ˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:94\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}ˇ.\x{05D0}", %p)},	"xn--0ca88g.xn--4db",	"to_ascii\(\'A\\u0300ˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:95\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Àˇ.\x{05D0}", %p)},	"xn--0ca88g.xn--4db",	"to_ascii\(\'Àˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:96\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca88g.xn--4db", %p)},	"xn--0ca88g.xn--4db",	"to_ascii\(\'xn\-\-0ca88g\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:97\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à\x{0308}.\x{05D0}", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'à\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:98\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}\x{0308}.\x{05D0}", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'a\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:99\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}\x{0308}.\x{05D0}", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'A\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:100\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À\x{0308}.\x{05D0}", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'À\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:101\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca81i.xn--4db", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'xn\-\-0ca81i\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:102\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{200C}b", %p)},	"ab",	"to_ascii\(\'a\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:106\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200C}B", %p)},	"ab",	"to_ascii\(\'A\\u200CB\'\)\ \[data\/IdnaTest\.txt\:108\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200C}b", %p)},	"ab",	"to_ascii\(\'A\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:110\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ab", %p)},	"ab",	"to_ascii\(\'ab\'\)\ \[data\/IdnaTest\.txt\:112\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{094D}\x{200C}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:113\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200C}B", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:115\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200C}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:117\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-fsf", %p)},	"xn--ab-fsf",	"to_ascii\(\'xn\-\-ab\-fsf\'\)\ \[data\/IdnaTest\.txt\:119\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{094D}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'a\\u094Db\'\)\ \[data\/IdnaTest\.txt\:120\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}B", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094DB\'\)\ \[data\/IdnaTest\.txt\:121\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094Db\'\)\ \[data\/IdnaTest\.txt\:122\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-fsf604u", %p)},	"xn--ab-fsf604u",	"to_ascii\(\'xn\-\-ab\-fsf604u\'\)\ \[data\/IdnaTest\.txt\:123\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:124\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:126\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:128\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:130\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:132\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:133\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:134\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{200D}b", %p)},	"ab",	"to_ascii\(\'a\\u200Db\'\)\ \[data\/IdnaTest\.txt\:135\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200D}B", %p)},	"ab",	"to_ascii\(\'A\\u200DB\'\)\ \[data\/IdnaTest\.txt\:137\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200D}b", %p)},	"ab",	"to_ascii\(\'A\\u200Db\'\)\ \[data\/IdnaTest\.txt\:139\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{094D}\x{200D}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:141\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200D}B", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:143\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200D}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:145\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-fsf014u", %p)},	"xn--ab-fsf014u",	"to_ascii\(\'xn\-\-ab\-fsf014u\'\)\ \[data\/IdnaTest\.txt\:147\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:148\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:150\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:152\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:154\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:156\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:158\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:160\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("¡", %p)},	"xn--7a",	"to_ascii\(\'\¡\'\)\ \[data\/IdnaTest\.txt\:165\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7a", %p)},	"xn--7a",	"to_ascii\(\'xn\-\-7a\'\)\ \[data\/IdnaTest\.txt\:166\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("᧚", %p)},	"xn--pkf",	"to_ascii\(\'᧚\'\)\ \[data\/IdnaTest\.txt\:167\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("xn--pkf", %p)},	"xn--pkf",	"to_ascii\(\'xn\-\-pkf\'\)\ \[data\/IdnaTest\.txt\:168\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("。", %p)},	undef,	"to_ascii\(\'\。\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:169\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("ꭠ", %p)},	"xn--3y9a",	"to_ascii\(\'ꭠ\'\)\ \[data\/IdnaTest\.txt\:170\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("xn--3y9a", %p)},	"xn--3y9a",	"to_ascii\(\'xn\-\-3y9a\'\)\ \[data\/IdnaTest\.txt\:171\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("1234567890ä1234567890123456789012345678901234567890123456", %p)},	undef,	"to_ascii\(\'1234567890ä1234567890123456789012345678901234567890123456\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:172\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1234567890a\x{0308}1234567890123456789012345678901234567890123456", %p)},	undef,	"to_ascii\(\'1234567890a\\u03081234567890123456789012345678901234567890123456\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:173\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1234567890A\x{0308}1234567890123456789012345678901234567890123456", %p)},	undef,	"to_ascii\(\'1234567890A\\u03081234567890123456789012345678901234567890123456\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:174\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1234567890Ä1234567890123456789012345678901234567890123456", %p)},	undef,	"to_ascii\(\'1234567890Ä1234567890123456789012345678901234567890123456\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:175\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.eXample.cOm", %p)},	"www.example.com",	"to_ascii\(\'www\.eXample\.cOm\'\)\ \[data\/IdnaTest\.txt\:176\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Bücher.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'Bücher\.de\'\)\ \[data\/IdnaTest\.txt\:177\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Bu\x{0308}cher.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'Bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:178\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("bu\x{0308}cher.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:179\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("bücher.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'bücher\.de\'\)\ \[data\/IdnaTest\.txt\:180\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("BÜCHER.DE", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'BÜCHER\.DE\'\)\ \[data\/IdnaTest\.txt\:181\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("BU\x{0308}CHER.DE", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'BU\\u0308CHER\.DE\'\)\ \[data\/IdnaTest\.txt\:182\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bcher-kva.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'xn\-\-bcher\-kva\.de\'\)\ \[data\/IdnaTest\.txt\:183\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ÖBB", %p)},	"xn--bb-eka",	"to_ascii\(\'ÖBB\'\)\ \[data\/IdnaTest\.txt\:184\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("O\x{0308}BB", %p)},	"xn--bb-eka",	"to_ascii\(\'O\\u0308BB\'\)\ \[data\/IdnaTest\.txt\:185\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("o\x{0308}bb", %p)},	"xn--bb-eka",	"to_ascii\(\'o\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:186\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("öbb", %p)},	"xn--bb-eka",	"to_ascii\(\'öbb\'\)\ \[data\/IdnaTest\.txt\:187\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Öbb", %p)},	"xn--bb-eka",	"to_ascii\(\'Öbb\'\)\ \[data\/IdnaTest\.txt\:188\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("O\x{0308}bb", %p)},	"xn--bb-eka",	"to_ascii\(\'O\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:189\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bb-eka", %p)},	"xn--bb-eka",	"to_ascii\(\'xn\-\-bb\-eka\'\)\ \[data\/IdnaTest\.txt\:190\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλος.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:191\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βο\x{0301}λος.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:193\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ΒΟ\x{0301}ΛΟΣ.COM", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'ΒΟ\\u0301ΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:195\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ΒΌΛΟΣ.COM", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'ΒΌΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:196\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλοσ.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:197\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βο\x{0301}λοσ.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:198\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βο\x{0301}λοσ.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'Βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:199\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλοσ.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'Βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:200\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmq6b.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'xn\-\-nxasmq6b\.com\'\)\ \[data\/IdnaTest\.txt\:201\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βο\x{0301}λος.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'Βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:202\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλος.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:204\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmm1c.com", %p)},	"xn--nxasmm1c.com",	"to_ascii\(\'xn\-\-nxasmm1c\.com\'\)\ \[data\/IdnaTest\.txt\:206\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmm1c", %p)},	"xn--nxasmm1c",	"to_ascii\(\'xn\-\-nxasmm1c\'\)\ \[data\/IdnaTest\.txt\:207\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλος", %p)},	"xn--nxasmq6b",	"to_ascii\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:208\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βο\x{0301}λος", %p)},	"xn--nxasmq6b",	"to_ascii\(\'βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:210\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ΒΟ\x{0301}ΛΟΣ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'ΒΟ\\u0301ΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:212\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ΒΌΛΟΣ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'ΒΌΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:213\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλοσ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'βόλοσ\'\)\ \[data\/IdnaTest\.txt\:214\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βο\x{0301}λοσ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:215\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βο\x{0301}λοσ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'Βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:216\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλοσ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'Βόλοσ\'\)\ \[data\/IdnaTest\.txt\:217\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmq6b", %p)},	"xn--nxasmq6b",	"to_ascii\(\'xn\-\-nxasmq6b\'\)\ \[data\/IdnaTest\.txt\:218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλος", %p)},	"xn--nxasmq6b",	"to_ascii\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:219\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βο\x{0301}λος", %p)},	"xn--nxasmq6b",	"to_ascii\(\'Βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:221\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:223\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.xn--10cl1a0b.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'www\.xn\-\-10cl1a0b\.com\'\)\ \[data\/IdnaTest\.txt\:225\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.ශ\x{0DCA}ර\x{0DD3}.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:226\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.xn--10cl1a0b660p.com", %p)},	"www.xn--10cl1a0b660p.com",	"to_ascii\(\'www\.xn\-\-10cl1a0b660p\.com\'\)\ \[data\/IdnaTest\.txt\:227\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"xn--mgba3gch31f",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:228\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f", %p)},	"xn--mgba3gch31f",	"to_ascii\(\'xn\-\-mgba3gch31f\'\)\ \[data\/IdnaTest\.txt\:230\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}", %p)},	"xn--mgba3gch31f",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:231\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f060k", %p)},	"xn--mgba3gch31f060k",	"to_ascii\(\'xn\-\-mgba3gch31f060k\'\)\ \[data\/IdnaTest\.txt\:232\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f060k.com", %p)},	"xn--mgba3gch31f060k.com",	"to_ascii\(\'xn\-\-mgba3gch31f060k\.com\'\)\ \[data\/IdnaTest\.txt\:233\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:234\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f.com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'xn\-\-mgba3gch31f\.com\'\)\ \[data\/IdnaTest\.txt\:236\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:237\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b．c。d｡", %p)},	"a.b.c.d.",	"to_ascii\(\'a\.b．c\。d｡\'\)\ \[data\/IdnaTest\.txt\:238\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.c。d。", %p)},	"a.b.c.d.",	"to_ascii\(\'a\.b\.c\。d\。\'\)\ \[data\/IdnaTest\.txt\:239\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.c.d.", %p)},	"a.b.c.d.",	"to_ascii\(\'a\.b\.c\.d\.\'\)\ \[data\/IdnaTest\.txt\:240\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:241\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:242\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ü.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:243\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("u\x{0308}.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'u\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:244\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tda.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'xn\-\-tda\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:245\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ü.ü", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'ü\.ü\'\)\ \[data\/IdnaTest\.txt\:246\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("u\x{0308}.u\x{0308}", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'u\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:247\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.U\x{0308}", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.U\\u0308\'\)\ \[data\/IdnaTest\.txt\:248\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.Ü", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.Ü\'\)\ \[data\/IdnaTest\.txt\:249\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.ü", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.ü\'\)\ \[data\/IdnaTest\.txt\:250\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.u\x{0308}", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:251\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u-ccb", %p)},	undef,	"to_ascii\(\'xn\-\-u\-ccb\'\)\ throws\ error\ V1\ \[data\/IdnaTest\.txt\:252\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a⒈com", %p)},	undef,	"to_ascii\(\'a⒈com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:253\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a1.com", %p)},	"a1.com",	"to_ascii\(\'a1\.com\'\)\ \[data\/IdnaTest\.txt\:254\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A⒈COM", %p)},	undef,	"to_ascii\(\'A⒈COM\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:255\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A⒈Com", %p)},	undef,	"to_ascii\(\'A⒈Com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:256\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-ecp.ru", %p)},	undef,	"to_ascii\(\'xn\-\-a\-ecp\.ru\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:257\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0.pt", %p)},	undef,	"to_ascii\(\'xn\-\-0\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:258\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\.pt\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:259\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-Ä.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:260\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-A\x{0308}.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:261\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-a\x{0308}.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\-a\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:262\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-ä.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\-ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:263\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--A-Ä.PT", %p)},	undef,	"to_ascii\(\'XN\-\-A\-Ä\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:264\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--A-A\x{0308}.PT", %p)},	undef,	"to_ascii\(\'XN\-\-A\-A\\u0308\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:265\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--A-A\x{0308}.pt", %p)},	undef,	"to_ascii\(\'Xn\-\-A\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:266\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--A-Ä.pt", %p)},	undef,	"to_ascii\(\'Xn\-\-A\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:267\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。ＪＰ", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\。ＪＰ\'\)\ \[data\/IdnaTest\.txt\:268\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。JP", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\。JP\'\)\ \[data\/IdnaTest\.txt\:269\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wgv71a119e.jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'xn\-\-wgv71a119e\.jp\'\)\ \[data\/IdnaTest\.txt\:270\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語.jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\.jp\'\)\ \[data\/IdnaTest\.txt\:271\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。ｊｐ", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\。ｊｐ\'\)\ \[data\/IdnaTest\.txt\:272\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。Ｊｐ", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\。Ｊｐ\'\)\ \[data\/IdnaTest\.txt\:273\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("☕", %p)},	"xn--53h",	"to_ascii\(\'\☕\'\)\ \[data\/IdnaTest\.txt\:274\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--53h", %p)},	"xn--53h",	"to_ascii\(\'xn\-\-53h\'\)\ \[data\/IdnaTest\.txt\:275\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_ascii\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:276\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_ascii\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:278\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_ascii\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:280\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_ascii\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:282\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_ascii\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:284\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_ascii\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:286\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_ascii\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:288\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_ascii\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:290\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	"xn--bss",	"to_ascii\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ \[data\/IdnaTest\.txt\:292\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	"xn--bss",	"to_ascii\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ \[data\/IdnaTest\.txt\:294\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	"xn--bss",	"to_ascii\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ \[data\/IdnaTest\.txt\:296\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	"xn--bss",	"to_ascii\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ \[data\/IdnaTest\.txt\:298\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bss", %p)},	"xn--bss",	"to_ascii\(\'xn\-\-bss\'\)\ \[data\/IdnaTest\.txt\:300\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("夙", %p)},	"xn--bss",	"to_ascii\(\'夙\'\)\ \[data\/IdnaTest\.txt\:301\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	"xn--bss",	"to_ascii\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ \[data\/IdnaTest\.txt\:302\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}ſ\x{2064}𝔰󠇯ﬄ", %p)},	"xn--bssffl",	"to_ascii\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00ſ\\u2064𝔰\󠇯ﬄ\'\)\ \[data\/IdnaTest\.txt\:304\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s󠇯ffl", %p)},	"xn--bssffl",	"to_ascii\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:305\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("x\x{034F}n\x{200B}-\x{00AD}-\x{180C}b\x{FE00}s\x{2064}s󠇯ffl", %p)},	"xn--bssffl",	"to_ascii\(\'x\\u034Fn\\u200B\-\\u00AD\-\\u180Cb\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:306\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("X\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}S󠇯FFL", %p)},	"xn--bssffl",	"to_ascii\(\'X\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064S\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:307\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("X\x{034F}n\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s󠇯ffl", %p)},	"xn--bssffl",	"to_ascii\(\'X\\u034Fn\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:308\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--bssffl", %p)},	"xn--bssffl",	"to_ascii\(\'xn\-\-bssffl\'\)\ \[data\/IdnaTest\.txt\:309\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("夡夞夜夙", %p)},	"xn--bssffl",	"to_ascii\(\'夡夞夜夙\'\)\ \[data\/IdnaTest\.txt\:310\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}S\x{2064}𝔰󠇯FFL", %p)},	"xn--bssffl",	"to_ascii\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00S\\u2064𝔰\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:311\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}s󠇯FFL", %p)},	"xn--bssffl",	"to_ascii\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064s\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:312\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}s\x{2064}𝔰󠇯ffl", %p)},	"xn--bssffl",	"to_ascii\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00s\\u2064𝔰\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:313\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:314\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:315\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:316\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:317\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:318\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_2\ A4_1\ \[data\/IdnaTest\.txt\:319\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä1234567890123456789012345678901234567890123456789012345", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:320\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'a\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:321\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'A\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:322\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä1234567890123456789012345678901234567890123456789012345", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'Ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:323\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1234567890123456789012345678901234567890123456789012345-9te", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'xn\-\-1234567890123456789012345678901234567890123456789012345\-9te\'\)\ \[data\/IdnaTest\.txt\:324\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:325\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:326\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:327\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:328\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:329\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:330\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:331\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:332\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:333\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:334\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:335\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:336\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:337\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:338\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:339\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:341\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:343\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:344\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:345\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:346\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_2\ A4_1\ \[data\/IdnaTest\.txt\:347\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_2\ A4_1\ \[data\/IdnaTest\.txt\:348\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_2\ A4_1\ \[data\/IdnaTest\.txt\:349\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_2\ A4_1\ \[data\/IdnaTest\.txt\:350\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..-q--a-.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.\-q\-\-a\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:351\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..-q--ä-.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.\-q\-\-ä\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:352\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..-q--a\x{0308}-.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.\-q\-\-a\\u0308\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:353\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B..-Q--A\x{0308}-.E", %p)},	undef,	"to_ascii\(\'A\.B\.\.\-Q\-\-A\\u0308\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:354\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B..-Q--Ä-.E", %p)},	undef,	"to_ascii\(\'A\.B\.\.\-Q\-\-Ä\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:355\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..xn---q----jra.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.xn\-\-\-q\-\-\-\-jra\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:356\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a..c", %p)},	undef,	"to_ascii\(\'a\.\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:357\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.-b.", %p)},	undef,	"to_ascii\(\'a\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:358\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b-.c", %p)},	undef,	"to_ascii\(\'a\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:359\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.-.c", %p)},	undef,	"to_ascii\(\'a\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:360\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.bc--de.f", %p)},	undef,	"to_ascii\(\'a\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:361\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.\x{00AD}.c", %p)},	undef,	"to_ascii\(\'ä\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:362\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}.\x{00AD}.c", %p)},	undef,	"to_ascii\(\'a\\u0308\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:363\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.\x{00AD}.C", %p)},	undef,	"to_ascii\(\'A\\u0308\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:364\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.\x{00AD}.C", %p)},	undef,	"to_ascii\(\'Ä\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:365\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.-b.", %p)},	undef,	"to_ascii\(\'ä\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:366\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}.-b.", %p)},	undef,	"to_ascii\(\'a\\u0308\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:367\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.-B.", %p)},	undef,	"to_ascii\(\'A\\u0308\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:368\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.-B.", %p)},	undef,	"to_ascii\(\'Ä\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:369\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.b-.c", %p)},	undef,	"to_ascii\(\'ä\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:370\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}.b-.c", %p)},	undef,	"to_ascii\(\'a\\u0308\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:371\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.B-.C", %p)},	undef,	"to_ascii\(\'A\\u0308\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:372\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.B-.C", %p)},	undef,	"to_ascii\(\'Ä\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:373\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.-.c", %p)},	undef,	"to_ascii\(\'ä\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:374\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}.-.c", %p)},	undef,	"to_ascii\(\'a\\u0308\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:375\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.-.C", %p)},	undef,	"to_ascii\(\'A\\u0308\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:376\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.-.C", %p)},	undef,	"to_ascii\(\'Ä\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:377\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.bc--de.f", %p)},	undef,	"to_ascii\(\'ä\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:378\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}.bc--de.f", %p)},	undef,	"to_ascii\(\'a\\u0308\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:379\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.BC--DE.F", %p)},	undef,	"to_ascii\(\'A\\u0308\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:380\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.BC--DE.F", %p)},	undef,	"to_ascii\(\'Ä\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:381\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.\x{0308}c.d", %p)},	undef,	"to_ascii\(\'a\.b\.\\u0308c\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:382\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B.\x{0308}C.D", %p)},	undef,	"to_ascii\(\'A\.B\.\\u0308C\.D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:383\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.xn--c-bcb.d", %p)},	undef,	"to_ascii\(\'a\.b\.xn\-\-c\-bcb\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:384\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A0", %p)},	"a0",	"to_ascii\(\'A0\'\)\ \[data\/IdnaTest\.txt\:385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0A", %p)},	"0a",	"to_ascii\(\'0A\'\)\ \[data\/IdnaTest\.txt\:386\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0A.\x{05D0}", %p)},	"0a.xn--4db",	"to_ascii\(\'0A\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:387\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0a.xn--4db", %p)},	"0a.xn--4db",	"to_ascii\(\'0a\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:388\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("c.xn--0-eha.xn--4db", %p)},	"c.xn--0-eha.xn--4db",	"to_ascii\(\'c\.xn\-\-0\-eha\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:389\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("c.0ü.\x{05D0}", %p)},	"c.xn--0-eha.xn--4db",	"to_ascii\(\'c\.0ü\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:390\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("c.0u\x{0308}.\x{05D0}", %p)},	"c.xn--0-eha.xn--4db",	"to_ascii\(\'c\.0u\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:391\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("C.0U\x{0308}.\x{05D0}", %p)},	"c.xn--0-eha.xn--4db",	"to_ascii\(\'C\.0U\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:392\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("C.0Ü.\x{05D0}", %p)},	"c.xn--0-eha.xn--4db",	"to_ascii\(\'C\.0Ü\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:393\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("b-.\x{05D0}", %p)},	undef,	"to_ascii\(\'b\-\.\\u05D0\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:394\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("d.xn----dha.xn--4db", %p)},	undef,	"to_ascii\(\'d\.xn\-\-\-\-dha\.xn\-\-4db\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:395\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{05D0}", %p)},	undef,	"to_ascii\(\'a\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:396\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{05D0}", %p)},	undef,	"to_ascii\(\'A\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:397\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{05D0}\x{05C7}", %p)},	"xn--vdbr",	"to_ascii\(\'\\u05D0\\u05C7\'\)\ \[data\/IdnaTest\.txt\:398\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--vdbr", %p)},	"xn--vdbr",	"to_ascii\(\'xn\-\-vdbr\'\)\ \[data\/IdnaTest\.txt\:399\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{05D0}9\x{05C7}", %p)},	"xn--9-ihcz",	"to_ascii\(\'\\u05D09\\u05C7\'\)\ \[data\/IdnaTest\.txt\:400\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--9-ihcz", %p)},	"xn--9-ihcz",	"to_ascii\(\'xn\-\-9\-ihcz\'\)\ \[data\/IdnaTest\.txt\:401\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{05D0}a\x{05C7}", %p)},	undef,	"to_ascii\(\'\\u05D0a\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:402\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{05D0}A\x{05C7}", %p)},	undef,	"to_ascii\(\'\\u05D0A\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:403\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{05D0}\x{05EA}", %p)},	"xn--4db6c",	"to_ascii\(\'\\u05D0\\u05EA\'\)\ \[data\/IdnaTest\.txt\:404\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4db6c", %p)},	"xn--4db6c",	"to_ascii\(\'xn\-\-4db6c\'\)\ \[data\/IdnaTest\.txt\:405\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}\x{05F3}\x{05EA}", %p)},	"xn--4db6c0a",	"to_ascii\(\'\\u05D0\\u05F3\\u05EA\'\)\ \[data\/IdnaTest\.txt\:406\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4db6c0a", %p)},	"xn--4db6c0a",	"to_ascii\(\'xn\-\-4db6c0a\'\)\ \[data\/IdnaTest\.txt\:407\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{05D0}Tz", %p)},	undef,	"to_ascii\(\'a\\u05D0Tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:408\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{05D0}tz", %p)},	undef,	"to_ascii\(\'a\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:409\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{05D0}TZ", %p)},	undef,	"to_ascii\(\'A\\u05D0TZ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:410\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{05D0}tz", %p)},	undef,	"to_ascii\(\'A\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:411\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}T\x{05EA}", %p)},	undef,	"to_ascii\(\'\\u05D0T\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:412\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}t\x{05EA}", %p)},	undef,	"to_ascii\(\'\\u05D0t\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:413\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}7\x{05EA}", %p)},	"xn--7-zhc3f",	"to_ascii\(\'\\u05D07\\u05EA\'\)\ \[data\/IdnaTest\.txt\:414\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7-zhc3f", %p)},	"xn--7-zhc3f",	"to_ascii\(\'xn\-\-7\-zhc3f\'\)\ \[data\/IdnaTest\.txt\:415\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}\x{0667}\x{05EA}", %p)},	"xn--4db6c6t",	"to_ascii\(\'\\u05D0\\u0667\\u05EA\'\)\ \[data\/IdnaTest\.txt\:416\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4db6c6t", %p)},	"xn--4db6c6t",	"to_ascii\(\'xn\-\-4db6c6t\'\)\ \[data\/IdnaTest\.txt\:417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a7\x{0667}z", %p)},	undef,	"to_ascii\(\'a7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:418\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A7\x{0667}Z", %p)},	undef,	"to_ascii\(\'A7\\u0667Z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:419\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A7\x{0667}z", %p)},	undef,	"to_ascii\(\'A7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:420\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}7\x{0667}\x{05EA}", %p)},	undef,	"to_ascii\(\'\\u05D07\\u0667\\u05EA\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:421\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{0BCD}\x{200D}", %p)},	"xn--dmc4b",	"to_ascii\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:422\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc4b", %p)},	"xn--dmc4b",	"to_ascii\(\'xn\-\-dmc4b\'\)\ \[data\/IdnaTest\.txt\:424\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{0BCD}", %p)},	"xn--dmc4b",	"to_ascii\(\'ஹ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:425\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc4b194h", %p)},	"xn--dmc4b194h",	"to_ascii\(\'xn\-\-dmc4b194h\'\)\ \[data\/IdnaTest\.txt\:426\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{200D}", %p)},	"xn--dmc",	"to_ascii\(\'ஹ\\u200D\'\)\ \[data\/IdnaTest\.txt\:427\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc", %p)},	"xn--dmc",	"to_ascii\(\'xn\-\-dmc\'\)\ \[data\/IdnaTest\.txt\:429\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ", %p)},	"xn--dmc",	"to_ascii\(\'ஹ\'\)\ \[data\/IdnaTest\.txt\:430\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:431\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{0BCD}\x{200C}", %p)},	"xn--dmc4b",	"to_ascii\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:433\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc4by94h", %p)},	"xn--dmc4by94h",	"to_ascii\(\'xn\-\-dmc4by94h\'\)\ \[data\/IdnaTest\.txt\:435\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{200C}", %p)},	"xn--dmc",	"to_ascii\(\'ஹ\\u200C\'\)\ \[data\/IdnaTest\.txt\:436\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:438\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"xn--ghb2gxqia",	"to_ascii\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:440\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2gxqia", %p)},	"xn--ghb2gxqia",	"to_ascii\(\'xn\-\-ghb2gxqia\'\)\ \[data\/IdnaTest\.txt\:442\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{06ED}\x{06EF}", %p)},	"xn--ghb2gxqia",	"to_ascii\(\'\\u0644\\u0670\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:443\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2gxqia7523a", %p)},	"xn--ghb2gxqia7523a",	"to_ascii\(\'xn\-\-ghb2gxqia7523a\'\)\ \[data\/IdnaTest\.txt\:444\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"xn--ghb2g3q",	"to_ascii\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:445\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2g3q", %p)},	"xn--ghb2g3q",	"to_ascii\(\'xn\-\-ghb2g3q\'\)\ \[data\/IdnaTest\.txt\:447\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{06EF}", %p)},	"xn--ghb2g3q",	"to_ascii\(\'\\u0644\\u0670\\u06EF\'\)\ \[data\/IdnaTest\.txt\:448\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2g3qq34f", %p)},	"xn--ghb2g3qq34f",	"to_ascii\(\'xn\-\-ghb2g3qq34f\'\)\ \[data\/IdnaTest\.txt\:449\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"xn--ghb25aga",	"to_ascii\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:450\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb25aga", %p)},	"xn--ghb25aga",	"to_ascii\(\'xn\-\-ghb25aga\'\)\ \[data\/IdnaTest\.txt\:452\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{06ED}\x{06EF}", %p)},	"xn--ghb25aga",	"to_ascii\(\'\\u0644\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:453\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb25aga828w", %p)},	"xn--ghb25aga828w",	"to_ascii\(\'xn\-\-ghb25aga828w\'\)\ \[data\/IdnaTest\.txt\:454\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{200C}\x{06EF}", %p)},	"xn--ghb65a",	"to_ascii\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:455\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb65a", %p)},	"xn--ghb65a",	"to_ascii\(\'xn\-\-ghb65a\'\)\ \[data\/IdnaTest\.txt\:457\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{06EF}", %p)},	"xn--ghb65a",	"to_ascii\(\'\\u0644\\u06EF\'\)\ \[data\/IdnaTest\.txt\:458\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb65a953d", %p)},	"xn--ghb65a953d",	"to_ascii\(\'xn\-\-ghb65a953d\'\)\ \[data\/IdnaTest\.txt\:459\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	"xn--ghb2gxq",	"to_ascii\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ \[data\/IdnaTest\.txt\:460\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2gxq", %p)},	"xn--ghb2gxq",	"to_ascii\(\'xn\-\-ghb2gxq\'\)\ \[data\/IdnaTest\.txt\:462\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{06ED}", %p)},	"xn--ghb2gxq",	"to_ascii\(\'\\u0644\\u0670\\u06ED\'\)\ \[data\/IdnaTest\.txt\:463\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06EF}\x{200C}\x{06EF}", %p)},	"xn--cmba",	"to_ascii\(\'\\u06EF\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:464\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cmba", %p)},	"xn--cmba",	"to_ascii\(\'xn\-\-cmba\'\)\ \[data\/IdnaTest\.txt\:466\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06EF}\x{06EF}", %p)},	"xn--cmba",	"to_ascii\(\'\\u06EF\\u06EF\'\)\ \[data\/IdnaTest\.txt\:467\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{200C}", %p)},	"xn--ghb",	"to_ascii\(\'\\u0644\\u200C\'\)\ \[data\/IdnaTest\.txt\:468\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb", %p)},	"xn--ghb",	"to_ascii\(\'xn\-\-ghb\'\)\ \[data\/IdnaTest\.txt\:470\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}", %p)},	"xn--ghb",	"to_ascii\(\'\\u0644\'\)\ \[data\/IdnaTest\.txt\:471\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒕∝\x{065F}򓤦．-󠄯", %p)},	undef,	"to_ascii\(\'⒕\∝\\u065F\?．\-\󠄯\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:475\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("14.∝\x{065F}򓤦.-󠄯", %p)},	undef,	"to_ascii\(\'14\.\∝\\u065F\?\.\-\󠄯\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:476\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡣ.\x{07CF}", %p)},	"xn--8c9a.xn--qsb",	"to_ascii\(\'ꡣ\.\\u07CF\'\)\ \[data\/IdnaTest\.txt\:477\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("xn--8c9a.xn--qsb", %p)},	"xn--8c9a.xn--qsb",	"to_ascii\(\'xn\-\-8c9a\.xn\-\-qsb\'\)\ \[data\/IdnaTest\.txt\:478\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("≯\x{0603}｡-", %p)},	undef,	"to_ascii\(\'\≯\\u0603｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:479\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{0603}｡-", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u0603｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:480\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯\x{0603}。-", %p)},	undef,	"to_ascii\(\'\≯\\u0603\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:481\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{0603}。-", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u0603\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:482\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛𐹧⾕.\x{115F}󠗰ςႭ", %p)},	undef,	"to_ascii\(\'⾛𐹧⾕\.\\u115F\?ςႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:483\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走𐹧谷.\x{115F}󠗰ςႭ", %p)},	undef,	"to_ascii\(\'走𐹧谷\.\\u115F\?ςႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:484\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走𐹧谷.\x{115F}󠗰ςⴍ", %p)},	undef,	"to_ascii\(\'走𐹧谷\.\\u115F\?ςⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:485\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走𐹧谷.\x{115F}󠗰ΣႭ", %p)},	undef,	"to_ascii\(\'走𐹧谷\.\\u115F\?ΣႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:486\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走𐹧谷.\x{115F}󠗰σⴍ", %p)},	undef,	"to_ascii\(\'走𐹧谷\.\\u115F\?σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:487\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走𐹧谷.\x{115F}󠗰Σⴍ", %p)},	undef,	"to_ascii\(\'走𐹧谷\.\\u115F\?Σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:488\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛𐹧⾕.\x{115F}󠗰ςⴍ", %p)},	undef,	"to_ascii\(\'⾛𐹧⾕\.\\u115F\?ςⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:489\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛𐹧⾕.\x{115F}󠗰ΣႭ", %p)},	undef,	"to_ascii\(\'⾛𐹧⾕\.\\u115F\?ΣႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:490\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛𐹧⾕.\x{115F}󠗰σⴍ", %p)},	undef,	"to_ascii\(\'⾛𐹧⾕\.\\u115F\?σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:491\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛𐹧⾕.\x{115F}󠗰Σⴍ", %p)},	undef,	"to_ascii\(\'⾛𐹧⾕\.\\u115F\?Σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:492\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}≠ᢙ≯.솣-ᡴႠ", %p)},	undef,	"to_ascii\(\'\\u200D\≠ᢙ\≯\.솣\-ᡴႠ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:493\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}=\x{0338}ᢙ>\x{0338}.솣-ᡴႠ", %p)},	undef,	"to_ascii\(\'\\u200D\=\\u0338ᢙ\>\\u0338\.솣\-ᡴႠ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:495\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}=\x{0338}ᢙ>\x{0338}.솣-ᡴⴀ", %p)},	undef,	"to_ascii\(\'\\u200D\=\\u0338ᢙ\>\\u0338\.솣\-ᡴⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:497\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}≠ᢙ≯.솣-ᡴⴀ", %p)},	undef,	"to_ascii\(\'\\u200D\≠ᢙ\≯\.솣\-ᡴⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:499\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񯞜．𐿇\x{0FA2}\x{077D}\x{0600}", %p)},	undef,	"to_ascii\(\'\?．\?\\u0FA2\\u077D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:501\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񯞜．𐿇\x{0FA1}\x{0FB7}\x{077D}\x{0600}", %p)},	undef,	"to_ascii\(\'\?．\?\\u0FA1\\u0FB7\\u077D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:502\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񯞜.𐿇\x{0FA1}\x{0FB7}\x{077D}\x{0600}", %p)},	undef,	"to_ascii\(\'\?\.\?\\u0FA1\\u0FB7\\u077D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:503\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𣳔\x{0303}.𑓂", %p)},	undef,	"to_ascii\(\'𣳔\\u0303\.𑓂\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:504\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞤀𞥅񘐱。󠄌Ⴣꡥ", %p)},	undef,	"to_ascii\(\'\?\?\?\。\󠄌Ⴣꡥ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:505\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤀𞥅񘐱。󠄌ⴣꡥ", %p)},	undef,	"to_ascii\(\'\?\?\?\。\󠄌ⴣꡥ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:506\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿ς𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿ς𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:507\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿ς𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿ς𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:508\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿Σ𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿Σ𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:509\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿Σ𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿Σ𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:510\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿σ𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿σ𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:511\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿σ𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿σ𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:512\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200D}。𞤍\x{200C}\x{200D}⒈", %p)},	undef,	"to_ascii\(\'\-\\u200D\。\?\\u200C\\u200D⒈\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:513\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("-\x{200D}。𞤍\x{200C}\x{200D}1.", %p)},	undef,	"to_ascii\(\'\-\\u200D\。\?\\u200C\\u200D1\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:515\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}򅎭.Ⴒ𑇀", %p)},	undef,	"to_ascii\(\'\\u200C\?\.Ⴒ𑇀\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:517\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}򅎭.ⴒ𑇀", %p)},	undef,	"to_ascii\(\'\\u200C\?\.ⴒ𑇀\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:519\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("繱𑖿\x{200D}.８︒", %p)},	undef,	"to_ascii\(\'繱𑖿\\u200D\.８︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:521\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("繱𑖿\x{200D}.8。", %p)},	"xn--gl0as212a.8.",	"to_ascii\(\'繱𑖿\\u200D\.8\。\'\)\ \[data\/IdnaTest\.txt\:522\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--gl0as212a.8.", %p)},	"xn--gl0as212a.8.",	"to_ascii\(\'xn\-\-gl0as212a\.8\.\'\)\ \[data\/IdnaTest\.txt\:524\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("繱𑖿.8.", %p)},	"xn--gl0as212a.8.",	"to_ascii\(\'繱𑖿\.8\.\'\)\ \[data\/IdnaTest\.txt\:525\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--1ug6928ac48e.8.", %p)},	"xn--1ug6928ac48e.8.",	"to_ascii\(\'xn\-\-1ug6928ac48e\.8\.\'\)\ \[data\/IdnaTest\.txt\:526\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("繱𑖿\x{200D}.8.", %p)},	"xn--gl0as212a.8.",	"to_ascii\(\'繱𑖿\\u200D\.8\.\'\)\ \[data\/IdnaTest\.txt\:527\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("󠆾．𞀈", %p)},	undef,	"to_ascii\(\'\󠆾．\?\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:529\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("󠆾.𞀈", %p)},	undef,	"to_ascii\(\'\󠆾\.\?\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:530\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ß\x{06EB}。\x{200D}", %p)},	"xn--ss-59d.",	"to_ascii\(\'ß\\u06EB\。\\u200D\'\)\ \[data\/IdnaTest\.txt\:531\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS\x{06EB}。\x{200D}", %p)},	"xn--ss-59d.",	"to_ascii\(\'SS\\u06EB\。\\u200D\'\)\ \[data\/IdnaTest\.txt\:533\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{06EB}。\x{200D}", %p)},	"xn--ss-59d.",	"to_ascii\(\'ss\\u06EB\。\\u200D\'\)\ \[data\/IdnaTest\.txt\:535\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{06EB}。\x{200D}", %p)},	"xn--ss-59d.",	"to_ascii\(\'Ss\\u06EB\。\\u200D\'\)\ \[data\/IdnaTest\.txt\:537\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-59d.", %p)},	"xn--ss-59d.",	"to_ascii\(\'xn\-\-ss\-59d\.\'\)\ \[data\/IdnaTest\.txt\:539\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{06EB}.", %p)},	"xn--ss-59d.",	"to_ascii\(\'ss\\u06EB\.\'\)\ \[data\/IdnaTest\.txt\:540\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS\x{06EB}.", %p)},	"xn--ss-59d.",	"to_ascii\(\'SS\\u06EB\.\'\)\ \[data\/IdnaTest\.txt\:541\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{06EB}.", %p)},	"xn--ss-59d.",	"to_ascii\(\'Ss\\u06EB\.\'\)\ \[data\/IdnaTest\.txt\:542\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠐵\x{200C}⒈．󠎇", %p)},	undef,	"to_ascii\(\'\?\\u200C⒈．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:543\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠐵\x{200C}1..󠎇", %p)},	undef,	"to_ascii\(\'\?\\u200C1\.\.\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:545\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟈣\x{065F}\x{AAB2}ß。󌓧", %p)},	undef,	"to_ascii\(\'\?\\u065F\\uAAB2ß\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:547\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟈣\x{065F}\x{AAB2}SS。󌓧", %p)},	undef,	"to_ascii\(\'\?\\u065F\\uAAB2SS\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:548\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟈣\x{065F}\x{AAB2}ss。󌓧", %p)},	undef,	"to_ascii\(\'\?\\u065F\\uAAB2ss\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:549\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟈣\x{065F}\x{AAB2}Ss。󌓧", %p)},	undef,	"to_ascii\(\'\?\\u065F\\uAAB2Ss\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:550\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0774}\x{200C}𞤿。𽘐䉜\x{200D}񿤼", %p)},	undef,	"to_ascii\(\'\\u0774\\u200C\?\。\?䉜\\u200D\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:551\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜ςᡱ⒈.≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?ςᡱ⒈\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:553\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜ςᡱ⒈.<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?ςᡱ⒈\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:554\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜ςᡱ1..≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?ςᡱ1\.\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:555\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜ςᡱ1..<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?ςᡱ1\.\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:556\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜Σᡱ1..<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?Σᡱ1\.\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:557\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜Σᡱ1..≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?Σᡱ1\.\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:558\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜σᡱ1..≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?σᡱ1\.\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:559\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜σᡱ1..<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?σᡱ1\.\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:560\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜Σᡱ⒈.<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?Σᡱ⒈\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:561\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜Σᡱ⒈.≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?Σᡱ⒈\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:562\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜σᡱ⒈.≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?σᡱ⒈\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:563\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜σᡱ⒈.<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?σᡱ⒈\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:564\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{3164}\x{094D}Ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_ascii\(\'\\u3164\\u094DႠ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:565\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1160}\x{094D}Ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_ascii\(\'\\u1160\\u094DႠ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:566\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1160}\x{094D}ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_ascii\(\'\\u1160\\u094Dⴀ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:567\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{3164}\x{094D}ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_ascii\(\'\\u3164\\u094Dⴀ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:568\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("❣\x{200D}．\x{09CD}𑰽\x{0612}\x{A929}", %p)},	undef,	"to_ascii\(\'\❣\\u200D．\\u09CD\?\\u0612\\uA929\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:569\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("❣\x{200D}.\x{09CD}𑰽\x{0612}\x{A929}", %p)},	undef,	"to_ascii\(\'\❣\\u200D\.\\u09CD\?\\u0612\\uA929\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:571\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("≮𐳺𐹄.≯񪮸ꡅ", %p)},	undef,	"to_ascii\(\'\≮𐳺\?\.\≯\?ꡅ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:573\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𐳺𐹄.>\x{0338}񪮸ꡅ", %p)},	undef,	"to_ascii\(\'\<\\u0338𐳺\?\.\>\\u0338\?ꡅ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:574\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0CCC}𐧅𐳏󠲺｡\x{0CCD}ᠦ", %p)},	undef,	"to_ascii\(\'\\u0CCC𐧅𐳏\?｡\\u0CCDᠦ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:575\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0CCC}𐧅𐳏󠲺。\x{0CCD}ᠦ", %p)},	undef,	"to_ascii\(\'\\u0CCC𐧅𐳏\?\。\\u0CCDᠦ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:576\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0CCC}𐧅𐲏󠲺。\x{0CCD}ᠦ", %p)},	undef,	"to_ascii\(\'\\u0CCC𐧅𐲏\?\。\\u0CCDᠦ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:577\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0CCC}𐧅𐲏󠲺｡\x{0CCD}ᠦ", %p)},	undef,	"to_ascii\(\'\\u0CCC𐧅𐲏\?｡\\u0CCDᠦ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:578\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0349}。𧡫", %p)},	undef,	"to_ascii\(\'\\u0349\。𧡫\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:579\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰿󠅦．\x{1160}", %p)},	undef,	"to_ascii\(\'\?\󠅦．\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:580\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰿󠅦.\x{1160}", %p)},	undef,	"to_ascii\(\'\?\󠅦\.\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:581\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𞤆\x{200D}。󸼄𞳒", %p)},	undef,	"to_ascii\(\'\-\?\\u200D\。\?\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:582\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡏ󠇶≯𳾽。\x{1DFD}⾇滸𐹰", %p)},	undef,	"to_ascii\(\'ꡏ\?\≯\?\。\\u1DFD⾇滸𐹰\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:584\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡏ󠇶>\x{0338}𳾽。\x{1DFD}⾇滸𐹰", %p)},	undef,	"to_ascii\(\'ꡏ\?\>\\u0338\?\。\\u1DFD⾇滸𐹰\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:585\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡏ󠇶≯𳾽。\x{1DFD}舛滸𐹰", %p)},	undef,	"to_ascii\(\'ꡏ\?\≯\?\。\\u1DFD舛滸𐹰\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:586\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡏ󠇶>\x{0338}𳾽。\x{1DFD}舛滸𐹰", %p)},	undef,	"to_ascii\(\'ꡏ\?\>\\u0338\?\。\\u1DFD舛滸𐹰\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:587\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("蔏｡𑰺", %p)},	undef,	"to_ascii\(\'蔏｡\?\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:588\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("蔏。𑰺", %p)},	undef,	"to_ascii\(\'蔏\。\?\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:589\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𝟿𐮋。󠄊", %p)},	undef,	"to_ascii\(\'𝟿𐮋\。\󠄊\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:590\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("9𐮋。󠄊", %p)},	undef,	"to_ascii\(\'9𐮋\。\󠄊\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:591\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󟇇-䟖F。\x{07CB}⒈\x{0662}", %p)},	undef,	"to_ascii\(\'\?\-䟖F\。\\u07CB⒈\\u0662\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:592\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟇇-䟖F。\x{07CB}1.\x{0662}", %p)},	undef,	"to_ascii\(\'\?\-䟖F\。\\u07CB1\.\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:593\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟇇-䟖f。\x{07CB}1.\x{0662}", %p)},	undef,	"to_ascii\(\'\?\-䟖f\。\\u07CB1\.\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:594\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟇇-䟖f。\x{07CB}⒈\x{0662}", %p)},	undef,	"to_ascii\(\'\?\-䟖f\。\\u07CB⒈\\u0662\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:595\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}｡𐹺", %p)},	undef,	"to_ascii\(\'\\u200C｡𐹺\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:596\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}。𐹺", %p)},	undef,	"to_ascii\(\'\\u200C\。𐹺\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:598\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐡆.≯\x{200C}-𞥀", %p)},	undef,	"to_ascii\(\'𐡆\.\≯\\u200C\-\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:600\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡆.>\x{0338}\x{200C}-𞥀", %p)},	undef,	"to_ascii\(\'𐡆\.\>\\u0338\\u200C\-\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:602\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁀-。≠\x{FCD7}", %p)},	undef,	"to_ascii\(\'\?\-\。\≠\\uFCD7\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:604\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁀-。=\x{0338}\x{FCD7}", %p)},	undef,	"to_ascii\(\'\?\-\。\=\\u0338\\uFCD7\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:605\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁀-。≠\x{0647}\x{062C}", %p)},	undef,	"to_ascii\(\'\?\-\。\≠\\u0647\\u062C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:606\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁀-。=\x{0338}\x{0647}\x{062C}", %p)},	undef,	"to_ascii\(\'\?\-\。\=\\u0338\\u0647\\u062C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:607\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻬹𑈵。\x{200D}𞨶", %p)},	undef,	"to_ascii\(\'\?𑈵\。\\u200D\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:608\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑋧\x{A9C0}2｡㧉򒖄", %p)},	undef,	"to_ascii\(\'𑋧\\uA9C02｡㧉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:610\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑋧\x{A9C0}2。㧉򒖄", %p)},	undef,	"to_ascii\(\'𑋧\\uA9C02\。㧉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:611\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𽬄𐹴𞩥。≯6", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹴\?\。\≯6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:612\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𽬄𐹴𞩥。>\x{0338}6", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹴\?\。\>\\u03386\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:614\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑁿．𐹦𻞵-\x{200D}", %p)},	undef,	"to_ascii\(\'𑁿．𐹦\?\-\\u200D\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:616\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑁿.𐹦𻞵-\x{200D}", %p)},	undef,	"to_ascii\(\'𑁿\.𐹦\?\-\\u200D\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:618\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸ς𺱀｡\x{FFA0}", %p)},	undef,	"to_ascii\(\'\⤸ς\?｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:620\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸ς𺱀。\x{1160}", %p)},	undef,	"to_ascii\(\'\⤸ς\?\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:621\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸Σ𺱀。\x{1160}", %p)},	undef,	"to_ascii\(\'\⤸Σ\?\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:622\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸σ𺱀。\x{1160}", %p)},	undef,	"to_ascii\(\'\⤸σ\?\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:623\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸Σ𺱀｡\x{FFA0}", %p)},	undef,	"to_ascii\(\'\⤸Σ\?｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:624\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸σ𺱀｡\x{FFA0}", %p)},	undef,	"to_ascii\(\'\⤸σ\?｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:625\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0765}\x{1035}𐫔\x{06D5}.𐦬𑋪Ⴃ", %p)},	undef,	"to_ascii\(\'\\u0765\\u1035𐫔\\u06D5\.𐦬𑋪Ⴃ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:626\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0765}\x{1035}𐫔\x{06D5}.𐦬𑋪ⴃ", %p)},	undef,	"to_ascii\(\'\\u0765\\u1035𐫔\\u06D5\.𐦬𑋪ⴃ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:627\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0661}\x{1B44}-킼.\x{1BAA}\x{0616}\x{066C}≯", %p)},	undef,	"to_ascii\(\'\\u0661\\u1B44\-킼\.\\u1BAA\\u0616\\u066C\≯\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:628\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0661}\x{1B44}-킼.\x{1BAA}\x{0616}\x{066C}>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0661\\u1B44\-킼\.\\u1BAA\\u0616\\u066C\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:629\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。\x{06C2}\x{0604}򅖡𑓂", %p)},	undef,	"to_ascii\(\'\-\。\\u06C2\\u0604\?𑓂\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:630\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。\x{06C1}\x{0654}\x{0604}򅖡𑓂", %p)},	undef,	"to_ascii\(\'\-\。\\u06C1\\u0654\\u0604\?𑓂\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:631\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}󯑖󠁐．\x{05BD}𙮰ꡝ𐋡", %p)},	undef,	"to_ascii\(\'\\u200D\?\?．\\u05BD\?ꡝ𐋡\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:632\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}󯑖󠁐.\x{05BD}𙮰ꡝ𐋡", %p)},	undef,	"to_ascii\(\'\\u200D\?\?\.\\u05BD\?ꡝ𐋡\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:634\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒􃈵ς񀠇｡𐮈", %p)},	undef,	"to_ascii\(\'︒\?ς\?｡𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:636\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。􃈵ς񀠇。𐮈", %p)},	undef,	"to_ascii\(\'\。\?ς\?\。𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:637\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。􃈵Σ񀠇。𐮈", %p)},	undef,	"to_ascii\(\'\。\?Σ\?\。𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:638\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。􃈵σ񀠇。𐮈", %p)},	undef,	"to_ascii\(\'\。\?σ\?\。𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:639\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒􃈵Σ񀠇｡𐮈", %p)},	undef,	"to_ascii\(\'︒\?Σ\?｡𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:640\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒􃈵σ񀠇｡𐮈", %p)},	undef,	"to_ascii\(\'︒\?σ\?｡𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:641\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D9}．\x{06EE}󆾃≯󠅲", %p)},	undef,	"to_ascii\(\'\\u07D9．\\u06EE\?\≯\󠅲\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:642\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D9}．\x{06EE}󆾃>\x{0338}󠅲", %p)},	undef,	"to_ascii\(\'\\u07D9．\\u06EE\?\>\\u0338\󠅲\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:643\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D9}.\x{06EE}󆾃≯󠅲", %p)},	undef,	"to_ascii\(\'\\u07D9\.\\u06EE\?\≯\󠅲\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:644\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D9}.\x{06EE}󆾃>\x{0338}󠅲", %p)},	undef,	"to_ascii\(\'\\u07D9\.\\u06EE\?\>\\u0338\󠅲\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:645\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1A73}󚙸.𐭍", %p)},	undef,	"to_ascii\(\'\\u1A73\?\.𐭍\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:646\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒉󠊓≠｡Ⴟ⬣Ⴈ", %p)},	undef,	"to_ascii\(\'⒉\?\≠｡Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:647\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒉󠊓=\x{0338}｡Ⴟ⬣Ⴈ", %p)},	undef,	"to_ascii\(\'⒉\?\=\\u0338｡Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:648\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2.󠊓≠。Ⴟ⬣Ⴈ", %p)},	undef,	"to_ascii\(\'2\.\?\≠\。Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:649\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2.󠊓=\x{0338}。Ⴟ⬣Ⴈ", %p)},	undef,	"to_ascii\(\'2\.\?\=\\u0338\。Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:650\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2.󠊓=\x{0338}。ⴟ⬣ⴈ", %p)},	undef,	"to_ascii\(\'2\.\?\=\\u0338\。ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:651\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2.󠊓≠。ⴟ⬣ⴈ", %p)},	undef,	"to_ascii\(\'2\.\?\≠\。ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:652\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒉󠊓=\x{0338}｡ⴟ⬣ⴈ", %p)},	undef,	"to_ascii\(\'⒉\?\=\\u0338｡ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:653\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒉󠊓≠｡ⴟ⬣ⴈ", %p)},	undef,	"to_ascii\(\'⒉\?\≠｡ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:654\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-󠉱\x{0FB8}Ⴥ。-𐹽\x{0774}𞣑", %p)},	undef,	"to_ascii\(\'\-\?\\u0FB8Ⴥ\。\-𐹽\\u0774𞣑\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:655\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-󠉱\x{0FB8}ⴥ。-𐹽\x{0774}𞣑", %p)},	undef,	"to_ascii\(\'\-\?\\u0FB8ⴥ\。\-𐹽\\u0774𞣑\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:656\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0659}。𑄴︒\x{0627}\x{07DD}", %p)},	undef,	"to_ascii\(\'\\u0659\。𑄴︒\\u0627\\u07DD\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:657\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{0659}。𑄴。\x{0627}\x{07DD}", %p)},	undef,	"to_ascii\(\'\\u0659\。𑄴\。\\u0627\\u07DD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:658\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴙ\x{0638}.󠆓\x{200D}", %p)},	undef,	"to_ascii\(\'Ⴙ\\u0638\.\󠆓\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:659\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴙ\x{0638}.󠆓\x{200D}", %p)},	undef,	"to_ascii\(\'ⴙ\\u0638\.\󠆓\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:661\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󠆸｡₆０𐺧\x{0756}", %p)},	undef,	"to_ascii\(\'\󠆸｡₆０\?\\u0756\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:663\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆸。60𐺧\x{0756}", %p)},	undef,	"to_ascii\(\'\󠆸\。60\?\\u0756\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:664\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("6\x{084F}｡-𑈴", %p)},	undef,	"to_ascii\(\'6\\u084F｡\-𑈴\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:665\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("6\x{084F}。-𑈴", %p)},	undef,	"to_ascii\(\'6\\u084F\。\-𑈴\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:666\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰｡\x{0ACD}ς𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰｡\\u0ACDς\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:667\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰。\x{0ACD}ς𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰\。\\u0ACDς\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:669\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰。\x{0ACD}Σ𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰\。\\u0ACDΣ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:671\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰。\x{0ACD}σ𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰\。\\u0ACDσ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:673\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰｡\x{0ACD}Σ𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰｡\\u0ACDΣ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:675\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰｡\x{0ACD}σ𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰｡\\u0ACDσ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:677\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈񟄜Ⴓ⒪．\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_ascii\(\'⒈\?Ⴓ⒪．\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:679\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.񟄜Ⴓ(o).\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_ascii\(\'1\.\?Ⴓ\(o\)\.\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:680\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.񟄜ⴓ(o).\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_ascii\(\'1\.\?ⴓ\(o\)\.\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:681\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.񟄜Ⴓ(O).\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_ascii\(\'1\.\?Ⴓ\(O\)\.\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:682\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈񟄜ⴓ⒪．\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_ascii\(\'⒈\?ⴓ⒪．\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:683\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤷.𐮐𞢁𐹠\x{0624}", %p)},	"xn--ve6h.xn--jgb1694kz0b2176a",	"to_ascii\(\'\?\.𐮐𞢁𐹠\\u0624\'\)\ \[data\/IdnaTest\.txt\:684\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤷.𐮐𞢁𐹠\x{0648}\x{0654}", %p)},	"xn--ve6h.xn--jgb1694kz0b2176a",	"to_ascii\(\'\?\.𐮐𞢁𐹠\\u0648\\u0654\'\)\ \[data\/IdnaTest\.txt\:685\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--ve6h.xn--jgb1694kz0b2176a", %p)},	"xn--ve6h.xn--jgb1694kz0b2176a",	"to_ascii\(\'xn\-\-ve6h\.xn\-\-jgb1694kz0b2176a\'\)\ \[data\/IdnaTest\.txt\:686\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐲈-｡𑄳񢌻", %p)},	undef,	"to_ascii\(\'𐲈\-｡𑄳\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:687\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐲈-。𑄳񢌻", %p)},	undef,	"to_ascii\(\'𐲈\-\。𑄳\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:688\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳈-。𑄳񢌻", %p)},	undef,	"to_ascii\(\'𐳈\-\。𑄳\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:689\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳈-｡𑄳񢌻", %p)},	undef,	"to_ascii\(\'𐳈\-｡𑄳\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:690\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-󠉖ꡧ．󠊂񇆃🄉", %p)},	undef,	"to_ascii\(\'\-\?ꡧ．\?\?🄉\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:691\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-󠉖ꡧ.󠊂񇆃8,", %p)},	undef,	"to_ascii\(\'\-\?ꡧ\.\?\?8\,\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:692\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠾛󠈴臯𧔤.\x{0768}𝟝", %p)},	undef,	"to_ascii\(\'\?\?臯𧔤\.\\u0768𝟝\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:693\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠾛󠈴臯𧔤.\x{0768}5", %p)},	undef,	"to_ascii\(\'\?\?臯𧔤\.\\u07685\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:694\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𐹣．𝨿", %p)},	undef,	"to_ascii\(\'\≮𐹣．𝨿\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:695\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𐹣．𝨿", %p)},	undef,	"to_ascii\(\'\<\\u0338𐹣．𝨿\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:696\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𐹣.𝨿", %p)},	undef,	"to_ascii\(\'\≮𐹣\.𝨿\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:697\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𐹣.𝨿", %p)},	undef,	"to_ascii\(\'\<\\u0338𐹣\.𝨿\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:698\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𐹯ᯛ\x{0A4D}｡脥", %p)},	undef,	"to_ascii\(\'𐹯ᯛ\\u0A4D｡脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:699\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𐹯ᯛ\x{0A4D}。脥", %p)},	undef,	"to_ascii\(\'𐹯ᯛ\\u0A4D\。脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:700\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{1B44}\x{115F}𞷿򃀍.-", %p)},	undef,	"to_ascii\(\'\\u1B44\\u115F\?\?\.\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:701\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}｡\x{0354}", %p)},	undef,	"to_ascii\(\'\\u200C｡\\u0354\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:702\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。\x{0354}", %p)},	undef,	"to_ascii\(\'\\u200C\。\\u0354\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:704\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤥󠅮．ᡄႮ", %p)},	undef,	"to_ascii\(\'\?\󠅮．ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:706\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤥󠅮.ᡄႮ", %p)},	undef,	"to_ascii\(\'\?\󠅮\.ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:707\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤥󠅮.ᡄⴎ", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'\?\󠅮\.ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:708\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--de6h.xn--37e857h", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'xn\-\-de6h\.xn\-\-37e857h\'\)\ \[data\/IdnaTest\.txt\:709\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤥.ᡄⴎ", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'\?\.ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:710\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞤥.ᡄႮ", %p)},	undef,	"to_ascii\(\'\?\.ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:711\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤥󠅮．ᡄⴎ", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'\?\󠅮．ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:712\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤧𝨨Ξ．𪺏㛨❸", %p)},	undef,	"to_ascii\(\'\?𝨨Ξ．𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:713\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤧𝨨Ξ.𪺏㛨❸", %p)},	undef,	"to_ascii\(\'\?𝨨Ξ\.𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:714\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤧𝨨ξ.𪺏㛨❸", %p)},	undef,	"to_ascii\(\'\?𝨨ξ\.𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:715\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤧𝨨ξ．𪺏㛨❸", %p)},	undef,	"to_ascii\(\'\?𝨨ξ．𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:716\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("᠆몆\x{200C}-｡Ⴛ𐦅︒", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-｡Ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:717\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-｡Ⴛ𐦅︒", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-｡Ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:719\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-。Ⴛ𐦅。", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-\。Ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:721\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-。Ⴛ𐦅。", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-\。Ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:723\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-。ⴛ𐦅。", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-\。ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:725\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-。ⴛ𐦅。", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-\。ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:727\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-｡ⴛ𐦅︒", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-｡ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:729\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-｡ⴛ𐦅︒", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-｡ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:731\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠾳.︒⥱\x{200C}𐹬", %p)},	undef,	"to_ascii\(\'\?\.︒\⥱\\u200C𐹬\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:733\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠾳.。⥱\x{200C}𐹬", %p)},	undef,	"to_ascii\(\'\?\.\。\⥱\\u200C𐹬\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:735\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯖.𐹠Ⴑ񚇜𐫊", %p)},	undef,	"to_ascii\(\'\?\.𐹠Ⴑ\?𐫊\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:737\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯖.𐹠ⴑ񚇜𐫊", %p)},	undef,	"to_ascii\(\'\?\.𐹠ⴑ\?𐫊\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:738\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FA4}񱤯．𝟭Ⴛ", %p)},	undef,	"to_ascii\(\'\\u0FA4\?．𝟭Ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:739\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FA4}񱤯.1Ⴛ", %p)},	undef,	"to_ascii\(\'\\u0FA4\?\.1Ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:740\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FA4}񱤯.1ⴛ", %p)},	undef,	"to_ascii\(\'\\u0FA4\?\.1ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:741\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FA4}񱤯．𝟭ⴛ", %p)},	undef,	"to_ascii\(\'\\u0FA4\?．𝟭ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:742\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{0826}齀。릿𐸋", %p)},	undef,	"to_ascii\(\'\-\\u0826齀\。릿\?\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{0826}齀。릿𐸋", %p)},	undef,	"to_ascii\(\'\-\\u0826齀\。릿\?\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:744\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠔊\x{071C}鹝꾗。񾵐\x{200D}\x{200D}⏃", %p)},	undef,	"to_ascii\(\'\?\\u071C鹝꾗\。\?\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:745\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠔊\x{071C}鹝꾗。񾵐\x{200D}\x{200D}⏃", %p)},	undef,	"to_ascii\(\'\?\\u071C鹝꾗\。\?\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:747\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮．-\x{0708}--", %p)},	undef,	"to_ascii\(\'\≮．\-\\u0708\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:749\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}．-\x{0708}--", %p)},	undef,	"to_ascii\(\'\<\\u0338．\-\\u0708\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:750\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮.-\x{0708}--", %p)},	undef,	"to_ascii\(\'\≮\.\-\\u0708\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:751\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}.-\x{0708}--", %p)},	undef,	"to_ascii\(\'\<\\u0338\.\-\\u0708\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:752\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}ς𝟩", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200Dς𝟩\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:753\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}ς7", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200Dς7\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:755\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}Σ7", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200DΣ7\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:757\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}σ7", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200Dσ7\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:759\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}Σ𝟩", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200DΣ𝟩\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:761\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}σ𝟩", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200Dσ𝟩\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:763\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς򅜌８.𞭤", %p)},	undef,	"to_ascii\(\'ς\?８\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:765\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς򅜌8.𞭤", %p)},	undef,	"to_ascii\(\'ς\?8\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:766\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ򅜌8.𞭤", %p)},	undef,	"to_ascii\(\'Σ\?8\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:767\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ򅜌8.𞭤", %p)},	undef,	"to_ascii\(\'σ\?8\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:768\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ򅜌８.𞭤", %p)},	undef,	"to_ascii\(\'Σ\?８\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:769\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ򅜌８.𞭤", %p)},	undef,	"to_ascii\(\'σ\?８\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:770\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ᡑ🄀\x{0684}．-𐫄𑲤", %p)},	undef,	"to_ascii\(\'\\u200Cᡑ🄀\\u0684．\-𐫄\?\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:771\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}ᡑ0.\x{0684}.-𐫄𑲤", %p)},	undef,	"to_ascii\(\'\\u200Cᡑ0\.\\u0684\.\-𐫄\?\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:773\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𖠍。𐪿넯򞵲", %p)},	undef,	"to_ascii\(\'𖠍\。\?넯\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:775\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖠍。𐪿넯򞵲", %p)},	undef,	"to_ascii\(\'𖠍\。\?넯\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:776\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠇Ⴘ。\x{0603}Ⴈ𝆊", %p)},	undef,	"to_ascii\(\'᠇Ⴘ\。\\u0603Ⴈ𝆊\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:777\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠇ⴘ。\x{0603}ⴈ𝆊", %p)},	undef,	"to_ascii\(\'᠇ⴘ\。\\u0603ⴈ𝆊\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:778\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒚󠋑𞤰。牣\x{0667}Ⴜᣥ", %p)},	undef,	"to_ascii\(\'⒚\?\?\。牣\\u0667Ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:779\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("19.󠋑𞤰。牣\x{0667}Ⴜᣥ", %p)},	undef,	"to_ascii\(\'19\.\?\?\。牣\\u0667Ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:780\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("19.󠋑𞤰。牣\x{0667}ⴜᣥ", %p)},	undef,	"to_ascii\(\'19\.\?\?\。牣\\u0667ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:781\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒚󠋑𞤰。牣\x{0667}ⴜᣥ", %p)},	undef,	"to_ascii\(\'⒚\?\?\。牣\\u0667ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:782\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐋱𐰽⒈.Ⴓ", %p)},	undef,	"to_ascii\(\'\-𐋱𐰽⒈\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:783\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐋱𐰽1..Ⴓ", %p)},	undef,	"to_ascii\(\'\-𐋱𐰽1\.\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ A4_2\ \[data\/IdnaTest\.txt\:784\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-𐋱𐰽1..ⴓ", %p)},	undef,	"to_ascii\(\'\-𐋱𐰽1\.\.ⴓ\'\)\ throws\ error\ V3\ B1\ A4_2\ \[data\/IdnaTest\.txt\:785\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-𐋱𐰽⒈.ⴓ", %p)},	undef,	"to_ascii\(\'\-𐋱𐰽⒈\.ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:786\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}긃.榶-", %p)},	undef,	"to_ascii\(\'\\u200C긃\.榶\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:787\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}긃.榶-", %p)},	undef,	"to_ascii\(\'\\u200C긃\.榶\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:789\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("뉓泓𜵽.\x{09CD}\x{200D}", %p)},	undef,	"to_ascii\(\'뉓泓\?\.\\u09CD\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:791\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("뉓泓𜵽.\x{09CD}\x{200D}", %p)},	undef,	"to_ascii\(\'뉓泓\?\.\\u09CD\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:792\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴ß｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴ß｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:793\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴ß。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴ß\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:795\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴SS。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴SS\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:797\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴ss。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴ss\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:799\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴Ss。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴Ss\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:801\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴SS｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴SS｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:803\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴ss｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴ss｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:805\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴Ss｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴Ss｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:807\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1B44}．\x{1BAA}-≮≠", %p)},	undef,	"to_ascii\(\'\\u1B44．\\u1BAA\-\≮\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:809\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1B44}．\x{1BAA}-<\x{0338}=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u1B44．\\u1BAA\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:810\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1B44}.\x{1BAA}-≮≠", %p)},	undef,	"to_ascii\(\'\\u1B44\.\\u1BAA\-\≮\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:811\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1B44}.\x{1BAA}-<\x{0338}=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u1B44\.\\u1BAA\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:812\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}Ⴑ\x{115F}．𑄴Ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3Ⴑ\\u115F．𑄴Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:813\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}Ⴑ\x{115F}.𑄴Ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3Ⴑ\\u115F\.𑄴Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:814\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}ⴑ\x{115F}.𑄴ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3ⴑ\\u115F\.𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:815\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}Ⴑ\x{115F}.𑄴ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3Ⴑ\\u115F\.𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:816\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}ⴑ\x{115F}．𑄴ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3ⴑ\\u115F．𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:817\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}Ⴑ\x{115F}．𑄴ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3Ⴑ\\u115F．𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:818\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𜉆。Ⴃ𐴣𐹹똯", %p)},	undef,	"to_ascii\(\'\?\。Ⴃ\?𐹹똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:819\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𜉆。Ⴃ𐴣𐹹똯", %p)},	undef,	"to_ascii\(\'\?\。Ⴃ\?𐹹똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:820\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𜉆。ⴃ𐴣𐹹똯", %p)},	undef,	"to_ascii\(\'\?\。ⴃ\?𐹹똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:821\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𜉆。ⴃ𐴣𐹹똯", %p)},	undef,	"to_ascii\(\'\?\。ⴃ\?𐹹똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:822\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫀｡⳻󠙾󠄷\x{3164}", %p)},	undef,	"to_ascii\(\'𐫀｡⳻\?\󠄷\\u3164\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:823\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫀。⳻󠙾󠄷\x{1160}", %p)},	undef,	"to_ascii\(\'𐫀\。⳻\?\󠄷\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:824\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{079A}⾇．\x{071E}-𐋰", %p)},	undef,	"to_ascii\(\'\\u079A⾇．\\u071E\-𐋰\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:825\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{079A}舛.\x{071E}-𐋰", %p)},	undef,	"to_ascii\(\'\\u079A舛\.\\u071E\-𐋰\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:826\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴉ猕󹛫≮．︒", %p)},	undef,	"to_ascii\(\'Ⴉ猕\?\≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:827\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴉ猕󹛫<\x{0338}．︒", %p)},	undef,	"to_ascii\(\'Ⴉ猕\?\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:828\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴉ猕󹛫≮.。", %p)},	undef,	"to_ascii\(\'Ⴉ猕\?\≮\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:829\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴉ猕󹛫<\x{0338}.。", %p)},	undef,	"to_ascii\(\'Ⴉ猕\?\<\\u0338\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:830\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴉ猕󹛫<\x{0338}.。", %p)},	undef,	"to_ascii\(\'ⴉ猕\?\<\\u0338\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:831\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴉ猕󹛫≮.。", %p)},	undef,	"to_ascii\(\'ⴉ猕\?\≮\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:832\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴉ猕󹛫<\x{0338}．︒", %p)},	undef,	"to_ascii\(\'ⴉ猕\?\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:833\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴉ猕󹛫≮．︒", %p)},	undef,	"to_ascii\(\'ⴉ猕\?\≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:834\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("🏮｡\x{062B}鳳\x{07E2}󠅉", %p)},	undef,	"to_ascii\(\'🏮｡\\u062B鳳\\u07E2\󠅉\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:835\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("🏮。\x{062B}鳳\x{07E2}󠅉", %p)},	undef,	"to_ascii\(\'🏮\。\\u062B鳳\\u07E2\󠅉\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:836\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}𐹶。ß", %p)},	undef,	"to_ascii\(\'\\u200D𐹶\。ß\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:837\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}𐹶。SS", %p)},	undef,	"to_ascii\(\'\\u200D𐹶\。SS\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:839\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Å둄-．\x{200C}", %p)},	undef,	"to_ascii\(\'Å둄\-．\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:841\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{030A}둄-．\x{200C}", %p)},	undef,	"to_ascii\(\'A\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:843\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Å둄-.\x{200C}", %p)},	undef,	"to_ascii\(\'Å둄\-\.\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:845\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{030A}둄-.\x{200C}", %p)},	undef,	"to_ascii\(\'A\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:847\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{030A}둄-.\x{200C}", %p)},	undef,	"to_ascii\(\'a\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:849\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("å둄-.\x{200C}", %p)},	undef,	"to_ascii\(\'å둄\-\.\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:851\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{030A}둄-．\x{200C}", %p)},	undef,	"to_ascii\(\'a\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:853\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("å둄-．\x{200C}", %p)},	undef,	"to_ascii\(\'å둄\-．\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:855\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{3099}򬎑\x{1DD7}𞤀.򱲢-\x{0953}", %p)},	undef,	"to_ascii\(\'\\u3099\?\\u1DD7\?\.\?\-\\u0953\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:857\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς.ß񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'ς\.ß\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:858\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ.SS񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'Σ\.SS\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:859\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ.ss񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'σ\.ss\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:860\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ.ss񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'Σ\.ss\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:861\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ.ß񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'Σ\.ß\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:862\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ.ß񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'σ\.ß\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:863\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ꡀ𞀟｡\x{066B}\x{0599}", %p)},	undef,	"to_ascii\(\'ꡀ\?｡\\u066B\\u0599\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:864\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ꡀ𞀟。\x{066B}\x{0599}", %p)},	undef,	"to_ascii\(\'ꡀ\?\。\\u066B\\u0599\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:865\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򈛉\x{200C}\x{08A9}｡⧅񘘡-𐭡", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u08A9｡\⧅\?\-𐭡\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:866\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈛉\x{200C}\x{08A9}。⧅񘘡-𐭡", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u08A9\。\⧅\?\-𐭡\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:868\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("룱\x{200D}𰍨\x{200C}。𝨖︒", %p)},	undef,	"to_ascii\(\'룱\\u200D\?\\u200C\。𝨖︒\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:870\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("룱\x{200D}𰍨\x{200C}。𝨖︒", %p)},	undef,	"to_ascii\(\'룱\\u200D\?\\u200C\。𝨖︒\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:872\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("룱\x{200D}𰍨\x{200C}。𝨖。", %p)},	undef,	"to_ascii\(\'룱\\u200D\?\\u200C\。𝨖\。\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:874\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("룱\x{200D}𰍨\x{200C}。𝨖。", %p)},	undef,	"to_ascii\(\'룱\\u200D\?\\u200C\。𝨖\。\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:876\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄄．\x{1CDC}⒈ß", %p)},	undef,	"to_ascii\(\'🄄．\\u1CDC⒈ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:878\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3,.\x{1CDC}1.ß", %p)},	undef,	"to_ascii\(\'3\,\.\\u1CDC1\.ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:879\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3,.\x{1CDC}1.SS", %p)},	undef,	"to_ascii\(\'3\,\.\\u1CDC1\.SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:880\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄄．\x{1CDC}⒈SS", %p)},	undef,	"to_ascii\(\'🄄．\\u1CDC⒈SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:881\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄄．\x{1CDC}⒈ss", %p)},	undef,	"to_ascii\(\'🄄．\\u1CDC⒈ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:882\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄄．\x{1CDC}⒈Ss", %p)},	undef,	"to_ascii\(\'🄄．\\u1CDC⒈Ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:883\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񇌍\x{2D7F}｡𞼓򡄨𑐺", %p)},	undef,	"to_ascii\(\'\?\\u2D7F｡\?\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:884\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񇌍\x{2D7F}。𞼓򡄨𑐺", %p)},	undef,	"to_ascii\(\'\?\\u2D7F\。\?\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:885\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DFD}\x{103A}\x{094D}．≠\x{200D}㇛", %p)},	undef,	"to_ascii\(\'\\u1DFD\\u103A\\u094D．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:886\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{103A}\x{094D}\x{1DFD}．≠\x{200D}㇛", %p)},	undef,	"to_ascii\(\'\\u103A\\u094D\\u1DFD．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:888\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{103A}\x{094D}\x{1DFD}．=\x{0338}\x{200D}㇛", %p)},	undef,	"to_ascii\(\'\\u103A\\u094D\\u1DFD．\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:890\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{103A}\x{094D}\x{1DFD}.≠\x{200D}㇛", %p)},	undef,	"to_ascii\(\'\\u103A\\u094D\\u1DFD\.\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:892\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{103A}\x{094D}\x{1DFD}.=\x{0338}\x{200D}㇛", %p)},	undef,	"to_ascii\(\'\\u103A\\u094D\\u1DFD\.\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:894\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴁ𐋨娤.\x{200D}\x{033C}\x{0662}𑖿", %p)},	undef,	"to_ascii\(\'Ⴁ𐋨娤\.\\u200D\\u033C\\u0662𑖿\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:896\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ⴁ𐋨娤.\x{200D}\x{033C}\x{0662}𑖿", %p)},	undef,	"to_ascii\(\'ⴁ𐋨娤\.\\u200D\\u033C\\u0662𑖿\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:898\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("🄀Ⴄ\x{0669}\x{0820}。⒈\x{0FB6}ß", %p)},	undef,	"to_ascii\(\'🄀Ⴄ\\u0669\\u0820\。⒈\\u0FB6ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:900\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.Ⴄ\x{0669}\x{0820}。1.\x{0FB6}ß", %p)},	undef,	"to_ascii\(\'0\.Ⴄ\\u0669\\u0820\。1\.\\u0FB6ß\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:901\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("0.ⴄ\x{0669}\x{0820}。1.\x{0FB6}ß", %p)},	undef,	"to_ascii\(\'0\.ⴄ\\u0669\\u0820\。1\.\\u0FB6ß\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:902\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("0.Ⴄ\x{0669}\x{0820}。1.\x{0FB6}SS", %p)},	undef,	"to_ascii\(\'0\.Ⴄ\\u0669\\u0820\。1\.\\u0FB6SS\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:903\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("0.ⴄ\x{0669}\x{0820}。1.\x{0FB6}ss", %p)},	undef,	"to_ascii\(\'0\.ⴄ\\u0669\\u0820\。1\.\\u0FB6ss\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:904\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("0.Ⴄ\x{0669}\x{0820}。1.\x{0FB6}Ss", %p)},	undef,	"to_ascii\(\'0\.Ⴄ\\u0669\\u0820\。1\.\\u0FB6Ss\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:905\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄀ⴄ\x{0669}\x{0820}。⒈\x{0FB6}ß", %p)},	undef,	"to_ascii\(\'🄀ⴄ\\u0669\\u0820\。⒈\\u0FB6ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:906\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄀Ⴄ\x{0669}\x{0820}。⒈\x{0FB6}SS", %p)},	undef,	"to_ascii\(\'🄀Ⴄ\\u0669\\u0820\。⒈\\u0FB6SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:907\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄀ⴄ\x{0669}\x{0820}。⒈\x{0FB6}ss", %p)},	undef,	"to_ascii\(\'🄀ⴄ\\u0669\\u0820\。⒈\\u0FB6ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:908\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄀Ⴄ\x{0669}\x{0820}。⒈\x{0FB6}Ss", %p)},	undef,	"to_ascii\(\'🄀Ⴄ\\u0669\\u0820\。⒈\\u0FB6Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:909\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠.\x{200C}-\x{066B}", %p)},	undef,	"to_ascii\(\'\≠\.\\u200C\-\\u066B\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:910\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}.\x{200C}-\x{066B}", %p)},	undef,	"to_ascii\(\'\=\\u0338\.\\u200C\-\\u066B\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:912\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0660}۱｡󠳶𞠁\x{0665}", %p)},	undef,	"to_ascii\(\'\\u0660۱｡\?𞠁\\u0665\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:914\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0660}۱。󠳶𞠁\x{0665}", %p)},	undef,	"to_ascii\(\'\\u0660۱\。\?𞠁\\u0665\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:915\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{0663}⒖。󱅉𽷛\x{1BF3}", %p)},	undef,	"to_ascii\(\'\\u200C\\u0663⒖\。\?\?\\u1BF3\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:916\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{0663}15.。󱅉𽷛\x{1BF3}", %p)},	undef,	"to_ascii\(\'\\u200C\\u066315\.\。\?\?\\u1BF3\'\)\ throws\ error\ P1\ V6\ B1\ A4_2\ \[data\/IdnaTest\.txt\:918\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}.-逋񳦭󙙮", %p)},	undef,	"to_ascii\(\'\\u1BF3\.\-逋\?\?\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:920\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{3164}\x{200D}ς", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u3164\\u200Dς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:921\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{1160}\x{200D}ς", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u1160\\u200Dς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:923\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{1160}\x{200D}Σ", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u1160\\u200DΣ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:925\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{1160}\x{200D}σ", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u1160\\u200Dσ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:927\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{3164}\x{200D}Σ", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u3164\\u200DΣ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:929\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{3164}\x{200D}σ", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u3164\\u200Dσ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:931\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡆႣ｡󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'ᡆႣ｡\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:933\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡆႣ。󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'ᡆႣ\。\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:935\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡆⴃ。󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'ᡆⴃ\。\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:937\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡆⴃ｡󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'ᡆⴃ｡\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:939\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵．ς𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵．ς𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:941\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵.ς𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵\.ς𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:943\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵.Σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵\.Σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:945\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵.σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵\.σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:947\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵．Σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵．Σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:949\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵．σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵．σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:951\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{17B5}。𞯸ꡀ🄋", %p)},	undef,	"to_ascii\(\'\\u17B5\。\?ꡀ🄋\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:953\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󐪺暑．⾑\x{0668}", %p)},	undef,	"to_ascii\(\'\?暑．⾑\\u0668\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:954\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󐪺暑.襾\x{0668}", %p)},	undef,	"to_ascii\(\'\?暑\.襾\\u0668\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:955\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄚≯ꡢ。\x{0891}\x{1DFF}", %p)},	undef,	"to_ascii\(\'\󠄚\≯ꡢ\。\\u0891\\u1DFF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:956\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄚>\x{0338}ꡢ。\x{0891}\x{1DFF}", %p)},	undef,	"to_ascii\(\'\󠄚\>\\u0338ꡢ\。\\u0891\\u1DFF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:957\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FDC3}𮁱\x{0B4D}𐨿.󐧤Ⴗ", %p)},	undef,	"to_ascii\(\'\\uFDC3\?\\u0B4D𐨿\.\?Ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:958\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0643}\x{0645}\x{0645}𮁱\x{0B4D}𐨿.󐧤Ⴗ", %p)},	undef,	"to_ascii\(\'\\u0643\\u0645\\u0645\?\\u0B4D𐨿\.\?Ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:959\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0643}\x{0645}\x{0645}𮁱\x{0B4D}𐨿.󐧤ⴗ", %p)},	undef,	"to_ascii\(\'\\u0643\\u0645\\u0645\?\\u0B4D𐨿\.\?ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:960\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FDC3}𮁱\x{0B4D}𐨿.󐧤ⴗ", %p)},	undef,	"to_ascii\(\'\\uFDC3\?\\u0B4D𐨿\.\?ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:961\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞀨｡\x{1B44}򡛨𞎇", %p)},	undef,	"to_ascii\(\'\?｡\\u1B44\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:962\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞀨。\x{1B44}򡛨𞎇", %p)},	undef,	"to_ascii\(\'\?\。\\u1B44\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣼\x{200C}．𐺰\x{200C}ᡟ", %p)},	undef,	"to_ascii\(\'\?\\u200C．\?\\u200Cᡟ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:964\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣼\x{200C}.𐺰\x{200C}ᡟ", %p)},	undef,	"to_ascii\(\'\?\\u200C\.\?\\u200Cᡟ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:966\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢛ󨅟ß.ጧ", %p)},	undef,	"to_ascii\(\'ᢛ\?ß\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:968\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢛ󨅟SS.ጧ", %p)},	undef,	"to_ascii\(\'ᢛ\?SS\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:969\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢛ󨅟ss.ጧ", %p)},	undef,	"to_ascii\(\'ᢛ\?ss\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:970\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢛ󨅟Ss.ጧ", %p)},	undef,	"to_ascii\(\'ᢛ\?Ss\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:971\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⮒\x{200C}.񒚗\x{200C}", %p)},	undef,	"to_ascii\(\'\⮒\\u200C\.\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:972\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤂񹞁𐹯。Ⴜ", %p)},	undef,	"to_ascii\(\'\?\?𐹯\。Ⴜ\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:974\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤂񹞁𐹯。ⴜ", %p)},	undef,	"to_ascii\(\'\?\?𐹯\。ⴜ\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:975\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹵⮣\x{200C}𑄰｡񷴿\x{FCB7}", %p)},	undef,	"to_ascii\(\'𐹵\⮣\\u200C𑄰｡\?\\uFCB7\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:976\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹵⮣\x{200C}𑄰。񷴿\x{0636}\x{0645}", %p)},	undef,	"to_ascii\(\'𐹵\⮣\\u200C𑄰\。\?\\u0636\\u0645\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:978\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴒ。デß𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。デß\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:980\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴒ。テ\x{3099}ß𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。テ\\u3099ß\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:981\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴒ。テ\x{3099}ß𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'ⴒ\。テ\\u3099ß\?\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:982\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴒ。デß𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'ⴒ\。デß\?\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:983\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴒ。デSS𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。デSS\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:984\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴒ。テ\x{3099}SS𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。テ\\u3099SS\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:985\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴒ。テ\x{3099}ss𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'ⴒ\。テ\\u3099ss\?\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:986\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴒ。デss𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'ⴒ\。デss\?\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:987\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴒ。デSs𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。デSs\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:988\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴒ。テ\x{3099}Ss𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。テ\\u3099Ss\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:989\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𑁿\x{0D4D}．７-\x{07D2}", %p)},	undef,	"to_ascii\(\'𑁿\\u0D4D．７\-\\u07D2\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:990\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𑁿\x{0D4D}.7-\x{07D2}", %p)},	undef,	"to_ascii\(\'𑁿\\u0D4D\.7\-\\u07D2\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:991\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("≯𑜫󠭇.\x{1734}񒞤𑍬ᢧ", %p)},	undef,	"to_ascii\(\'\≯𑜫\?\.\\u1734\?𑍬ᢧ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:992\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}𑜫󠭇.\x{1734}񒞤𑍬ᢧ", %p)},	undef,	"to_ascii\(\'\>\\u0338𑜫\?\.\\u1734\?𑍬ᢧ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:993\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DDB}򎐙Ⴗ쏔。\x{0781}", %p)},	undef,	"to_ascii\(\'\\u1DDB\?Ⴗ쏔\。\\u0781\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:994\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DDB}򎐙Ⴗ쏔。\x{0781}", %p)},	undef,	"to_ascii\(\'\\u1DDB\?Ⴗ쏔\。\\u0781\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:995\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DDB}򎐙ⴗ쏔。\x{0781}", %p)},	undef,	"to_ascii\(\'\\u1DDB\?ⴗ쏔\。\\u0781\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:996\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DDB}򎐙ⴗ쏔。\x{0781}", %p)},	undef,	"to_ascii\(\'\\u1DDB\?ⴗ쏔\。\\u0781\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:997\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß｡𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'ß｡𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:998\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß。𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'ß\。𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:999\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß。𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ß\。𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1000\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS。𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'SS\。𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1002\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss。𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ss\。𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1003\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss.xn--lgd921mvv0m", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ss\.xn\-\-lgd921mvv0m\'\)\ \[data\/IdnaTest\.txt\:1004\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss.𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ss\.𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1005\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS.𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'SS\.𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1006\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--zca.xn--lgd921mvv0m", %p)},	"xn--zca.xn--lgd921mvv0m",	"to_ascii\(\'xn\-\-zca\.xn\-\-lgd921mvv0m\'\)\ \[data\/IdnaTest\.txt\:1007\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß.𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ß\.𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1008\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß｡𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ß｡𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1010\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS｡𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'SS｡𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1012\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss｡𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ss｡𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1013\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-\x{069E}𐶡.\x{200C}⾝\x{09CD}", %p)},	undef,	"to_ascii\(\'\-\\u069E\?\.\\u200C⾝\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1014\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{069E}𐶡.\x{200C}身\x{09CD}", %p)},	undef,	"to_ascii\(\'\-\\u069E\?\.\\u200C身\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1016\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("😮\x{0764}𑈵𞀖.💅\x{200D}", %p)},	undef,	"to_ascii\(\'😮\\u0764\?𑈵\.💅\\u200D\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1018\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("😮\x{0764}𑈵𞀖.💅\x{200D}", %p)},	undef,	"to_ascii\(\'😮\\u0764𑈵\?\.💅\\u200D\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1020\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{08F2}\x{200D}꙳\x{0712}.ᢏ\x{200C}󠍄", %p)},	undef,	"to_ascii\(\'\\u08F2\\u200D꙳\\u0712\.ᢏ\\u200C\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1022\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴑ．\x{06BF}𞯓ᠲ", %p)},	undef,	"to_ascii\(\'Ⴑ．\\u06BF\?ᠲ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1024\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴑ.\x{06BF}𞯓ᠲ", %p)},	undef,	"to_ascii\(\'Ⴑ\.\\u06BF\?ᠲ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1025\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴑ.\x{06BF}𞯓ᠲ", %p)},	undef,	"to_ascii\(\'ⴑ\.\\u06BF\?ᠲ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1026\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴑ．\x{06BF}𞯓ᠲ", %p)},	undef,	"to_ascii\(\'ⴑ．\\u06BF\?ᠲ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1027\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1A5A}𛦝\x{0C4D}。𚝬𝟵", %p)},	undef,	"to_ascii\(\'\\u1A5A\?\\u0C4D\。\?𝟵\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1028\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1A5A}𛦝\x{0C4D}。𚝬9", %p)},	undef,	"to_ascii\(\'\\u1A5A\?\\u0C4D\。\?9\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1029\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{06A0}𿺆𝟗｡Ⴣ꒘\x{FCD0}񐘖", %p)},	undef,	"to_ascii\(\'\\u200C\\u06A0\?𝟗｡Ⴣ꒘\\uFCD0\?\'\)\ throws\ error\ P1\ V6\ B2\ B5\ \[data\/IdnaTest\.txt\:1030\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{06A0}𿺆9。Ⴣ꒘\x{0645}\x{062E}񐘖", %p)},	undef,	"to_ascii\(\'\\u200C\\u06A0\?9\。Ⴣ꒘\\u0645\\u062E\?\'\)\ throws\ error\ P1\ V6\ B2\ B5\ \[data\/IdnaTest\.txt\:1032\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{06A0}𿺆9。ⴣ꒘\x{0645}\x{062E}񐘖", %p)},	undef,	"to_ascii\(\'\\u200C\\u06A0\?9\。ⴣ꒘\\u0645\\u062E\?\'\)\ throws\ error\ P1\ V6\ B2\ B5\ \[data\/IdnaTest\.txt\:1034\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{06A0}𿺆𝟗｡ⴣ꒘\x{FCD0}񐘖", %p)},	undef,	"to_ascii\(\'\\u200C\\u06A0\?𝟗｡ⴣ꒘\\uFCD0\?\'\)\ throws\ error\ P1\ V6\ B2\ B5\ \[data\/IdnaTest\.txt\:1036\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡖ｡\x{031F}񗛨\x{0B82}-", %p)},	undef,	"to_ascii\(\'ᡖ｡\\u031F\?\\u0B82\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1038\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡖ。\x{031F}񗛨\x{0B82}-", %p)},	undef,	"to_ascii\(\'ᡖ\。\\u031F\?\\u0B82\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1039\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞠠浘。絧𞀀", %p)},	undef,	"to_ascii\(\'𞠠浘\。絧\?\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1040\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0596}Ⴋ．𝟳≯︒\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596Ⴋ．𝟳\≯︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1041\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}Ⴋ．𝟳>\x{0338}︒\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596Ⴋ．𝟳\>\\u0338︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1042\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}Ⴋ.7≯。\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596Ⴋ\.7\≯\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1043\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}Ⴋ.7>\x{0338}。\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596Ⴋ\.7\>\\u0338\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1044\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}ⴋ.7>\x{0338}。\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596ⴋ\.7\>\\u0338\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1045\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}ⴋ.7≯。\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596ⴋ\.7\≯\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1046\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}ⴋ．𝟳>\x{0338}︒\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596ⴋ．𝟳\>\\u0338︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1047\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}ⴋ．𝟳≯︒\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596ⴋ．𝟳\≯︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1048\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}F𑓂。󠺨︒\x{077E}𐹢", %p)},	undef,	"to_ascii\(\'\\u200DF𑓂\。\?︒\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1049\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}F𑓂。󠺨。\x{077E}𐹢", %p)},	undef,	"to_ascii\(\'\\u200DF𑓂\。\?\。\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1051\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}f𑓂。󠺨。\x{077E}𐹢", %p)},	undef,	"to_ascii\(\'\\u200Df𑓂\。\?\。\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1053\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}f𑓂。󠺨︒\x{077E}𐹢", %p)},	undef,	"to_ascii\(\'\\u200Df𑓂\。\?︒\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1055\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0845}🄇𐼗︒｡𐹻𑜫", %p)},	undef,	"to_ascii\(\'\\u0845🄇\?︒｡𐹻𑜫\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:1057\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0845}6,𐼗。。𐹻𑜫", %p)},	undef,	"to_ascii\(\'\\u08456\,\?\。\。𐹻𑜫\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:1058\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹈.\x{1DC0}𑈱𐦭", %p)},	undef,	"to_ascii\(\'\?\.\\u1DC0𑈱𐦭\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1059\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴂ䠺。𞤃񅏎󙮦\x{0693}", %p)},	undef,	"to_ascii\(\'Ⴂ䠺\。\?\?\?\\u0693\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1060\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴂ䠺。𞤃񅏎󙮦\x{0693}", %p)},	undef,	"to_ascii\(\'ⴂ䠺\。\?\?\?\\u0693\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1061\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄇伐︒.𜙚\x{A8C4}", %p)},	undef,	"to_ascii\(\'🄇伐︒\.\?\\uA8C4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1062\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6,伐。.𜙚\x{A8C4}", %p)},	undef,	"to_ascii\(\'6\,伐\。\.\?\\uA8C4\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1063\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹠\x{ABED}\x{FFFB}。\x{200D}𐫓Ⴚ𑂹", %p)},	undef,	"to_ascii\(\'\\u200D𐹠\\uABED\\uFFFB\。\\u200D𐫓Ⴚ𑂹\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1064\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹠\x{ABED}\x{FFFB}。\x{200D}𐫓ⴚ𑂹", %p)},	undef,	"to_ascii\(\'\\u200D𐹠\\uABED\\uFFFB\。\\u200D𐫓ⴚ𑂹\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1066\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆠．񷐴󌟈", %p)},	undef,	"to_ascii\(\'\󠆠．\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1068\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆠.񷐴󌟈", %p)},	undef,	"to_ascii\(\'\󠆠\.\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1069\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫃\x{200C}Ⴆ.≠𞷙", %p)},	undef,	"to_ascii\(\'𐫃\\u200CႦ\.\≠\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1070\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫃\x{200C}Ⴆ.=\x{0338}𞷙", %p)},	undef,	"to_ascii\(\'𐫃\\u200CႦ\.\=\\u0338\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1072\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫃\x{200C}ⴆ.=\x{0338}𞷙", %p)},	undef,	"to_ascii\(\'𐫃\\u200Cⴆ\.\=\\u0338\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1074\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫃\x{200C}ⴆ.≠𞷙", %p)},	undef,	"to_ascii\(\'𐫃\\u200Cⴆ\.\≠\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1076\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁲𙩢𝟥ꘌ．\x{0841}", %p)},	undef,	"to_ascii\(\'\?\?𝟥ꘌ．\\u0841\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1078\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁲𙩢3ꘌ.\x{0841}", %p)},	undef,	"to_ascii\(\'\?\?3ꘌ\.\\u0841\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1079\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.\x{1886}󡲣-", %p)},	undef,	"to_ascii\(\'\-\.\\u1886\?\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1080\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}｡\x{200C}𞰆ς", %p)},	undef,	"to_ascii\(\'\?\\u200C｡\\u200C\?ς\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1081\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}。\x{200C}𞰆ς", %p)},	undef,	"to_ascii\(\'\?\\u200C\。\\u200C\?ς\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1083\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}。\x{200C}𞰆Σ", %p)},	undef,	"to_ascii\(\'\?\\u200C\。\\u200C\?Σ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1085\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}。\x{200C}𞰆σ", %p)},	undef,	"to_ascii\(\'\?\\u200C\。\\u200C\?σ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1087\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}｡\x{200C}𞰆Σ", %p)},	undef,	"to_ascii\(\'\?\\u200C｡\\u200C\?Σ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1089\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}｡\x{200C}𞰆σ", %p)},	undef,	"to_ascii\(\'\?\\u200C｡\\u200C\?σ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1091\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("堕𑓂\x{1B02}。𐮇𞤽\x{200C}-", %p)},	undef,	"to_ascii\(\'堕𑓂\\u1B02\。𐮇\?\\u200C\-\'\)\ throws\ error\ V3\ B3\ \[data\/IdnaTest\.txt\:1093\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥς\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?｡ᡥς\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1095\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥς\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?\。ᡥς\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1096\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥΣ\x{062A}Σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?\。ᡥΣ\\u062AΣ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1097\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥσ\x{062A}σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?\。ᡥσ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1098\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥΣ\x{062A}σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?\。ᡥΣ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1099\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥΣ\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?\。ᡥΣ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1100\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥσ\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?\。ᡥσ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1101\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥΣ\x{062A}Σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?｡ᡥΣ\\u062AΣ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1102\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥσ\x{062A}σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?｡ᡥσ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1103\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥΣ\x{062A}σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?｡ᡥΣ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1104\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥΣ\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?｡ᡥΣ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1105\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥσ\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ\?｡ᡥσ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1106\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󏒰．-𝟻ß", %p)},	undef,	"to_ascii\(\'\?．\-𝟻ß\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1107\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰.-5ß", %p)},	undef,	"to_ascii\(\'\?\.\-5ß\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1108\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰.-5SS", %p)},	undef,	"to_ascii\(\'\?\.\-5SS\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1109\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰．-𝟻SS", %p)},	undef,	"to_ascii\(\'\?．\-𝟻SS\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1110\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰．-𝟻ss", %p)},	undef,	"to_ascii\(\'\?．\-𝟻ss\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1111\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰．-𝟻Ss", %p)},	undef,	"to_ascii\(\'\?．\-𝟻Ss\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1112\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐨿.🤒Ⴥ򑮶", %p)},	undef,	"to_ascii\(\'\\u200D𐨿\.🤒Ⴥ\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1113\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐨿.🤒ⴥ򑮶", %p)},	undef,	"to_ascii\(\'\\u200D𐨿\.🤒ⴥ\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1115\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𵋅。ß𬵩\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。ß𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1117\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𵋅。SS𬵩\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。SS𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1119\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𵋅。ss𬵩\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。ss𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1121\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𵋅。Ss𬵩\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。Ss𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1123\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𭉝。\x{07F1}\x{0301}𞹻", %p)},	undef,	"to_ascii\(\'\\u200C\?\。\\u07F1\\u0301𞹻\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1125\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𭉝。\x{07F1}\x{0301}\x{063A}", %p)},	undef,	"to_ascii\(\'\\u200C\?\。\\u07F1\\u0301\\u063A\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1127\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞼌\x{200C}𑈶。𐹡", %p)},	undef,	"to_ascii\(\'\?\\u200C𑈶\。𐹡\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1129\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}ς≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBς\≠\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1131\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}ς=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBς\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1133\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}ς≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBς\≠\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1135\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}ς=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBς\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1137\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}Σ=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBΣ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1139\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}Σ≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBΣ\≠\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1141\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}σ≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBσ\≠\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1143\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}σ=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBσ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1145\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}Σ=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBΣ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1147\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}Σ≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBΣ\≠\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1149\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}σ≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBσ\≠\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1151\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}σ=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBσ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1153\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒋｡⒈\x{200D}򳴢", %p)},	undef,	"to_ascii\(\'⒋｡⒈\\u200D\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1155\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4.。1.\x{200D}򳴢", %p)},	undef,	"to_ascii\(\'4\.\。1\.\\u200D\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1157\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ß｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ß｡𐇽\\u1A60\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1159\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ß｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ß｡\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1160\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ß。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ß\。\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}SS。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644SS\。\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1162\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ss。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ss\。\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1163\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}Ss。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644Ss\。\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1164\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}SS｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644SS｡\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1165\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ss｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ss｡\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1166\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}Ss｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644Ss｡\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1167\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}SS｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644SS｡𐇽\\u1A60\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1168\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ss｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ss｡𐇽\\u1A60\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1169\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}Ss｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644Ss｡𐇽\\u1A60\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1170\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹽𑄳񼜲.\x{1DDF}\x{17B8}\x{A806}𑜫", %p)},	undef,	"to_ascii\(\'𐹽𑄳\?\.\\u1DDF\\u17B8\\uA806𑜫\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1171\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴓ𑜫\x{200D}򗭓．\x{06A7}𑰶", %p)},	undef,	"to_ascii\(\'Ⴓ𑜫\\u200D\?．\\u06A7\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1172\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴓ𑜫\x{200D}򗭓.\x{06A7}𑰶", %p)},	undef,	"to_ascii\(\'Ⴓ𑜫\\u200D\?\.\\u06A7\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1173\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴓ𑜫\x{200D}򗭓.\x{06A7}𑰶", %p)},	undef,	"to_ascii\(\'ⴓ𑜫\\u200D\?\.\\u06A7\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1174\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴓ𑜫\x{200D}򗭓．\x{06A7}𑰶", %p)},	undef,	"to_ascii\(\'ⴓ𑜫\\u200D\?．\\u06A7\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1175\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨿.🄆—", %p)},	undef,	"to_ascii\(\'𐨿\.🄆\—\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1176\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨿.5,—", %p)},	undef,	"to_ascii\(\'𐨿\.5\,\—\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1177\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔊱񁦮۸。󠾭-", %p)},	undef,	"to_ascii\(\'\?\?۸\。\?\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1178\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼗸\x{07CD}𐹮。\x{06DD}ᡎᠴ", %p)},	undef,	"to_ascii\(\'\?\\u07CD𐹮\。\\u06DDᡎᠴ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1179\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ᠮႾ🄂.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200DᠮႾ🄂\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1180\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ᠮႾ1,.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200DᠮႾ1\,\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1182\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ᠮⴞ1,.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200Dᠮⴞ1\,\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1184\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ᠮⴞ🄂.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200Dᠮⴞ🄂\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1186\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0601}\x{0697}．𑚶񼡷⾆", %p)},	undef,	"to_ascii\(\'\\u0601\\u0697．𑚶\?⾆\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1188\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0601}\x{0697}.𑚶񼡷舌", %p)},	undef,	"to_ascii\(\'\\u0601\\u0697\.𑚶\?舌\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1189\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🞅󠳡󜍙.񲖷", %p)},	undef,	"to_ascii\(\'🞅\?\?\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1190\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{20E7}񯡎-򫣝.4Ⴄ\x{200C}", %p)},	undef,	"to_ascii\(\'\\u20E7\?\-\?\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1191\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{20E7}񯡎-򫣝.4ⴄ\x{200C}", %p)},	undef,	"to_ascii\(\'\\u20E7\?\-\?\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1193\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ｡𝌠ß𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ｡𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1195\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ。𝌠ß𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\。𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1197\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ。𝌠SS𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\。𝌠SS𖫱\'\)\ \[data\/IdnaTest\.txt\:1199\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ。𝌠ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\。𝌠ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1200\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ。𝌠Ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\。𝌠Ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1201\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--hwe.xn--ss-ci1ub261a", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'xn\-\-hwe\.xn\-\-ss\-ci1ub261a\'\)\ \[data\/IdnaTest\.txt\:1202\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ.𝌠ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\.𝌠ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1203\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ.𝌠SS𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\.𝌠SS𖫱\'\)\ \[data\/IdnaTest\.txt\:1204\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ.𝌠Ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\.𝌠Ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1205\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--hwe.xn--zca4946pblnc", %p)},	"xn--hwe.xn--zca4946pblnc",	"to_ascii\(\'xn\-\-hwe\.xn\-\-zca4946pblnc\'\)\ \[data\/IdnaTest\.txt\:1206\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ.𝌠ß𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\.𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1207\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ｡𝌠SS𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ｡𝌠SS𖫱\'\)\ \[data\/IdnaTest\.txt\:1209\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ｡𝌠ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ｡𝌠ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1210\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ｡𝌠Ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ｡𝌠Ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1211\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("₁｡𞤫ꡪ", %p)},	undef,	"to_ascii\(\'₁｡\?ꡪ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1212\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1。𞤫ꡪ", %p)},	undef,	"to_ascii\(\'1\。\?ꡪ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1213\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𯻼\x{200C}.𞶞򻙤񥘇", %p)},	undef,	"to_ascii\(\'\?\\u200C\.\?\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1214\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑄≯｡𑜤", %p)},	undef,	"to_ascii\(\'\?\≯｡𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1216\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑄>\x{0338}｡𑜤", %p)},	undef,	"to_ascii\(\'\?\>\\u0338｡𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1217\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑄≯。𑜤", %p)},	undef,	"to_ascii\(\'\?\≯\。𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑄>\x{0338}。𑜤", %p)},	undef,	"to_ascii\(\'\?\>\\u0338\。𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1219\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴋ≮𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_ascii\(\'Ⴋ\≮\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1220\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴋ<\x{0338}𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_ascii\(\'Ⴋ\<\\u0338\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1222\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴋ<\x{0338}𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_ascii\(\'ⴋ\<\\u0338\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1224\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴋ≮𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_ascii\(\'ⴋ\≮\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1226\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17D2}.򆽒≯", %p)},	undef,	"to_ascii\(\'\\u17D2\.\?\≯\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1228\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17D2}.򆽒>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u17D2\.\?\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1229\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}．𐨺É⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734．𐨺É\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1230\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}．𐨺E\x{0301}⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734．𐨺E\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1231\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}.𐨺É⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734\.𐨺É\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1232\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}.𐨺E\x{0301}⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734\.𐨺E\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1233\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}.𐨺e\x{0301}⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734\.𐨺e\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1234\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}.𐨺é⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734\.𐨺é\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1235\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}．𐨺e\x{0301}⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734．𐨺e\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1236\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}．𐨺é⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734．𐨺é\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1237\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢇ\x{200D}\x{A8C4}｡︒𞤺", %p)},	undef,	"to_ascii\(\'ᢇ\\u200D\\uA8C4｡︒\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1238\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ᢇ\x{200D}\x{A8C4}。。𞤺", %p)},	undef,	"to_ascii\(\'ᢇ\\u200D\\uA8C4\。\。\?\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:1240\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞩬򖙱\x{1714}\x{200C}｡\x{0631}\x{07AA}≮", %p)},	undef,	"to_ascii\(\'\?\?\\u1714\\u200C｡\\u0631\\u07AA\≮\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1242\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞩬򖙱\x{1714}\x{200C}｡\x{0631}\x{07AA}<\x{0338}", %p)},	undef,	"to_ascii\(\'\?\?\\u1714\\u200C｡\\u0631\\u07AA\<\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1243\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞩬򖙱\x{1714}\x{200C}。\x{0631}\x{07AA}≮", %p)},	undef,	"to_ascii\(\'\?\?\\u1714\\u200C\。\\u0631\\u07AA\≮\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1244\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞩬򖙱\x{1714}\x{200C}。\x{0631}\x{07AA}<\x{0338}", %p)},	undef,	"to_ascii\(\'\?\?\\u1714\\u200C\。\\u0631\\u07AA\<\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1245\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴣ．\x{0653}ᢤ", %p)},	undef,	"to_ascii\(\'Ⴣ．\\u0653ᢤ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1246\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴣ.\x{0653}ᢤ", %p)},	undef,	"to_ascii\(\'Ⴣ\.\\u0653ᢤ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1247\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴣ.\x{0653}ᢤ", %p)},	undef,	"to_ascii\(\'ⴣ\.\\u0653ᢤ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1248\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴣ．\x{0653}ᢤ", %p)},	undef,	"to_ascii\(\'ⴣ．\\u0653ᢤ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1249\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󠄈\x{0813}．싉򄆻Ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813．싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1250\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}．싉򄆻Ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813．싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1251\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}.싉򄆻Ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813\.싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1252\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}.싉򄆻Ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813\.싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1253\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}.싉򄆻ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813\.싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1254\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}.싉򄆻ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813\.싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1255\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}．싉򄆻ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813．싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1256\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}．싉򄆻ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813．싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1257\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{AA2C}𑲫≮．⤂", %p)},	undef,	"to_ascii\(\'\\uAA2C\?\≮．\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1258\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{AA2C}𑲫<\x{0338}．⤂", %p)},	undef,	"to_ascii\(\'\\uAA2C\?\<\\u0338．\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1259\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{AA2C}𑲫≮.⤂", %p)},	undef,	"to_ascii\(\'\\uAA2C\?\≮\.\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1260\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{AA2C}𑲫<\x{0338}.⤂", %p)},	undef,	"to_ascii\(\'\\uAA2C\?\<\\u0338\.\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1261\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮Ⴢ．Ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮Ⴢ．Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1262\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}Ⴢ．Ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338Ⴢ．Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1263\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮Ⴢ.Ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮Ⴢ\.Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1264\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}Ⴢ.Ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338Ⴢ\.Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1265\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}ⴢ.ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1266\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮ⴢ.ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1267\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮Ⴢ.ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮Ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1268\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}Ⴢ.ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338Ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1269\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}ⴢ．ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1270\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮ⴢ．ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1271\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮Ⴢ．ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮Ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1272\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}Ⴢ．ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338Ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1273\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𑁅。-", %p)},	undef,	"to_ascii\(\'𑁅\。\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1274\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0DCA}򕸽󠧱｡饈≠\x{0664}", %p)},	undef,	"to_ascii\(\'\\u0DCA\?\?｡饈\≠\\u0664\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1275\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0DCA}򕸽󠧱｡饈=\x{0338}\x{0664}", %p)},	undef,	"to_ascii\(\'\\u0DCA\?\?｡饈\=\\u0338\\u0664\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1276\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0DCA}򕸽󠧱。饈≠\x{0664}", %p)},	undef,	"to_ascii\(\'\\u0DCA\?\?\。饈\≠\\u0664\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1277\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0DCA}򕸽󠧱。饈=\x{0338}\x{0664}", %p)},	undef,	"to_ascii\(\'\\u0DCA\?\?\。饈\=\\u0338\\u0664\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1278\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥃ᠠ⁷｡≯邅⬻4", %p)},	undef,	"to_ascii\(\'\?ᠠ⁷｡\≯邅\⬻4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1279\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥃ᠠ⁷｡>\x{0338}邅⬻4", %p)},	undef,	"to_ascii\(\'\?ᠠ⁷｡\>\\u0338邅\⬻4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1280\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥃ᠠ7。≯邅⬻4", %p)},	undef,	"to_ascii\(\'\?ᠠ7\。\≯邅\⬻4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1281\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥃ᠠ7。>\x{0338}邅⬻4", %p)},	undef,	"to_ascii\(\'\?ᠠ7\。\>\\u0338邅\⬻4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1282\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򠿯ᡳ-𑐻.𐹴𐋫\x{0605}󑎳", %p)},	undef,	"to_ascii\(\'\?ᡳ\-\?\.𐹴𐋫\\u0605\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1283\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򠶆\x{0845}\x{0A51}.넨-󶧈", %p)},	undef,	"to_ascii\(\'\?\\u0845\\u0A51\.넨\-\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1284\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򠶆\x{0845}\x{0A51}.넨-󶧈", %p)},	undef,	"to_ascii\(\'\?\\u0845\\u0A51\.넨\-\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1285\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡦᡑ\x{200D}⒈。𐋣-", %p)},	undef,	"to_ascii\(\'ꡦᡑ\\u200D⒈\。𐋣\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1286\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ꡦᡑ\x{200D}1.。𐋣-", %p)},	undef,	"to_ascii\(\'ꡦᡑ\\u200D1\.\。𐋣\-\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:1288\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴌ。􍼠\x{FB69}", %p)},	undef,	"to_ascii\(\'Ⴌ\。\?\\uFB69\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1290\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴌ。􍼠\x{0679}", %p)},	undef,	"to_ascii\(\'Ⴌ\。\?\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1291\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴌ。􍼠\x{0679}", %p)},	undef,	"to_ascii\(\'ⴌ\。\?\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1292\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴌ。􍼠\x{FB69}", %p)},	undef,	"to_ascii\(\'ⴌ\。\?\\uFB69\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1293\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐮁𐭱.\x{0F84}\x{135E}-\x{1CFA}", %p)},	undef,	"to_ascii\(\'𐮁𐭱\.\\u0F84\\u135E\-\\u1CFA\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1294\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈䰹\x{200D}-。웈", %p)},	undef,	"to_ascii\(\'⒈䰹\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1295\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈䰹\x{200D}-。웈", %p)},	undef,	"to_ascii\(\'⒈䰹\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1297\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.䰹\x{200D}-。웈", %p)},	undef,	"to_ascii\(\'1\.䰹\\u200D\-\。웈\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1299\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.䰹\x{200D}-。웈", %p)},	undef,	"to_ascii\(\'1\.䰹\\u200D\-\。웈\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1301\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("て。\x{200C}󠳽\x{07F3}", %p)},	undef,	"to_ascii\(\'て\。\\u200C\?\\u07F3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1303\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ς｡\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'ς｡\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1305\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ς。\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'ς\。\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1306\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("Σ。\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'Σ\。\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1307\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("σ。\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'σ\。\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1308\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("Σ｡\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'Σ｡\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1309\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("σ｡\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'σ｡\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1310\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0BCD}󥫅򌉑.ႢႵ", %p)},	undef,	"to_ascii\(\'\\u0BCD\?\?\.ႢႵ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1311\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0BCD}󥫅򌉑.ⴂⴕ", %p)},	undef,	"to_ascii\(\'\\u0BCD\?\?\.ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1312\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0BCD}󥫅򌉑.Ⴂⴕ", %p)},	undef,	"to_ascii\(\'\\u0BCD\?\?\.Ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1313\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1C32}🄈⾛\x{05A6}．\x{200D}򯥤\x{07FD}", %p)},	undef,	"to_ascii\(\'\\u1C32🄈⾛\\u05A6．\\u200D\?\\u07FD\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1314\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1C32}7,走\x{05A6}.\x{200D}򯥤\x{07FD}", %p)},	undef,	"to_ascii\(\'\\u1C327\,走\\u05A6\.\\u200D\?\\u07FD\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1316\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢗ｡Ӏ񝄻", %p)},	undef,	"to_ascii\(\'ᢗ｡Ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1318\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢗ。Ӏ񝄻", %p)},	undef,	"to_ascii\(\'ᢗ\。Ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1319\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢗ。ӏ񝄻", %p)},	undef,	"to_ascii\(\'ᢗ\。ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1320\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢗ｡ӏ񝄻", %p)},	undef,	"to_ascii\(\'ᢗ｡ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1321\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0668}-。񠏇🝆ᄾ", %p)},	undef,	"to_ascii\(\'\\u0668\-\。\?🝆ᄾ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1322\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-𐋷𖾑。󠆬", %p)},	undef,	"to_ascii\(\'\-𐋷𖾑\。\󠆬\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1323\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}𐹳🐴멈.\x{ABED}񐡼", %p)},	undef,	"to_ascii\(\'\\u200C𐹳🐴멈\.\\uABED\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1324\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𐹳🐴멈.\x{ABED}񐡼", %p)},	undef,	"to_ascii\(\'\\u200C𐹳🐴멈\.\\uABED\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1326\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮.\x{0769}\x{0603}", %p)},	undef,	"to_ascii\(\'\≮\.\\u0769\\u0603\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1328\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}.\x{0769}\x{0603}", %p)},	undef,	"to_ascii\(\'\<\\u0338\.\\u0769\\u0603\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1329\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐶭⾆｡\x{200C}𑚶򟱃𞰘", %p)},	undef,	"to_ascii\(\'\?⾆｡\\u200C𑚶\?\?\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:1330\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐶭舌。\x{200C}𑚶򟱃𞰘", %p)},	undef,	"to_ascii\(\'\?舌\。\\u200C𑚶\?\?\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:1332\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴠ-.𝟷ς𞴺ς", %p)},	undef,	"to_ascii\(\'\\u200CჀ\-\.𝟷ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1334\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴠ-.1ς𞴺ς", %p)},	undef,	"to_ascii\(\'\\u200CჀ\-\.1ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1336\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴠ-.1ς𞴺ς", %p)},	undef,	"to_ascii\(\'\\u200Cⴠ\-\.1ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1338\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴠ-.1Σ𞴺Σ", %p)},	undef,	"to_ascii\(\'\\u200CჀ\-\.1Σ\?Σ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴠ-.1σ𞴺σ", %p)},	undef,	"to_ascii\(\'\\u200Cⴠ\-\.1σ\?σ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴠ-.𝟷ς𞴺ς", %p)},	undef,	"to_ascii\(\'\\u200Cⴠ\-\.𝟷ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1344\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴠ-.𝟷Σ𞴺Σ", %p)},	undef,	"to_ascii\(\'\\u200CჀ\-\.𝟷Σ\?Σ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1346\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴠ-.𝟷σ𞴺σ", %p)},	undef,	"to_ascii\(\'\\u200Cⴠ\-\.𝟷σ\?σ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1348\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑲘󠄒𓑡｡𝟪Ⴜ", %p)},	undef,	"to_ascii\(\'\?\󠄒\?｡𝟪Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1350\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑲘󠄒𓑡。8Ⴜ", %p)},	undef,	"to_ascii\(\'\?\󠄒\?\。8Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1351\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑲘󠄒𓑡。8ⴜ", %p)},	undef,	"to_ascii\(\'\?\󠄒\?\。8ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1352\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑲘󠄒𓑡｡𝟪ⴜ", %p)},	undef,	"to_ascii\(\'\?\󠄒\?｡𝟪ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1353\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("䪏\x{06AB}\x{07E0}\x{0941}｡뭕ᢝ\x{17B9}", %p)},	undef,	"to_ascii\(\'䪏\\u06AB\\u07E0\\u0941｡뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1354\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("䪏\x{06AB}\x{07E0}\x{0941}｡뭕ᢝ\x{17B9}", %p)},	undef,	"to_ascii\(\'䪏\\u06AB\\u07E0\\u0941｡뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1355\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("䪏\x{06AB}\x{07E0}\x{0941}。뭕ᢝ\x{17B9}", %p)},	undef,	"to_ascii\(\'䪏\\u06AB\\u07E0\\u0941\。뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1356\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("䪏\x{06AB}\x{07E0}\x{0941}。뭕ᢝ\x{17B9}", %p)},	undef,	"to_ascii\(\'䪏\\u06AB\\u07E0\\u0941\。뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1357\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{1BAB}｡🂉󠁰", %p)},	undef,	"to_ascii\(\'\\u1BAB｡🂉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1358\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAB}。🂉󠁰", %p)},	undef,	"to_ascii\(\'\\u1BAB\。🂉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1359\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󩎃\x{0AC4}。ς\x{200D}𐹮𑈵", %p)},	undef,	"to_ascii\(\'\?\\u0AC4\。ς\\u200D𐹮𑈵\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1360\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󩎃\x{0AC4}。Σ\x{200D}𐹮𑈵", %p)},	undef,	"to_ascii\(\'\?\\u0AC4\。Σ\\u200D𐹮𑈵\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1362\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󩎃\x{0AC4}。σ\x{200D}𐹮𑈵", %p)},	undef,	"to_ascii\(\'\?\\u0AC4\。σ\\u200D𐹮𑈵\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1364\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐫀ᡂ𑜫．𑘿", %p)},	undef,	"to_ascii\(\'𐫀ᡂ𑜫．𑘿\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:1366\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐫀ᡂ𑜫.𑘿", %p)},	undef,	"to_ascii\(\'𐫀ᡂ𑜫\.𑘿\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:1367\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󬚶󸋖򖩰-。\x{200C}", %p)},	undef,	"to_ascii\(\'\?\?\?\-\。\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1368\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣．\x{07C2}", %p)},	undef,	"to_ascii\(\'𐹣．\\u07C2\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1370\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣.\x{07C2}", %p)},	undef,	"to_ascii\(\'𐹣\.\\u07C2\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1371\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-\x{07E1}｡Ↄ", %p)},	undef,	"to_ascii\(\'\-\\u07E1｡Ↄ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1372\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{07E1}。Ↄ", %p)},	undef,	"to_ascii\(\'\-\\u07E1\。Ↄ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1373\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("-\x{07E1}。ↄ", %p)},	undef,	"to_ascii\(\'\-\\u07E1\。ↄ\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1374\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("-\x{07E1}｡ↄ", %p)},	undef,	"to_ascii\(\'\-\\u07E1｡ↄ\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1375\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}-︒󠄄。ß哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-︒\󠄄\。ß哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1376\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-。󠄄。ß哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-\。\󠄄\。ß哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:1378\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-。󠄄。SS哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-\。\󠄄\。SS哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:1380\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-。󠄄。ss哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-\。\󠄄\。ss哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:1382\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-。󠄄。Ss哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-\。\󠄄\。Ss哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:1384\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-︒󠄄。SS哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-︒\󠄄\。SS哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1386\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-︒󠄄。ss哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-︒\󠄄\。ss哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1388\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-︒󠄄。Ss哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-︒\󠄄\。Ss哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1390\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒．\x{FE2F}𑑂", %p)},	undef,	"to_ascii\(\'︒．\\uFE2F\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1392\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒．𑑂\x{FE2F}", %p)},	undef,	"to_ascii\(\'︒．\?\\uFE2F\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1393\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("。.𑑂\x{FE2F}", %p)},	undef,	"to_ascii\(\'\。\.\?\\uFE2F\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1394\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{A92C}。\x{200D}", %p)},	undef,	"to_ascii\(\'\\uA92C\。\\u200D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1395\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}󠸡｡\x{FCD7}", %p)},	undef,	"to_ascii\(\'\\u200D\?｡\\uFCD7\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1397\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}󠸡。\x{0647}\x{062C}", %p)},	undef,	"to_ascii\(\'\\u200D\?\。\\u0647\\u062C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1399\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-Ⴄ𝟢\x{0663}．𑍴ς", %p)},	undef,	"to_ascii\(\'\-Ⴄ𝟢\\u0663．𑍴ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1401\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-Ⴄ0\x{0663}.𑍴ς", %p)},	undef,	"to_ascii\(\'\-Ⴄ0\\u0663\.𑍴ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1402\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-ⴄ0\x{0663}.𑍴ς", %p)},	undef,	"to_ascii\(\'\-ⴄ0\\u0663\.𑍴ς\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1403\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-Ⴄ0\x{0663}.𑍴Σ", %p)},	undef,	"to_ascii\(\'\-Ⴄ0\\u0663\.𑍴Σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1404\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-ⴄ0\x{0663}.𑍴σ", %p)},	undef,	"to_ascii\(\'\-ⴄ0\\u0663\.𑍴σ\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1405\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-ⴄ𝟢\x{0663}．𑍴ς", %p)},	undef,	"to_ascii\(\'\-ⴄ𝟢\\u0663．𑍴ς\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1406\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-Ⴄ𝟢\x{0663}．𑍴Σ", %p)},	undef,	"to_ascii\(\'\-Ⴄ𝟢\\u0663．𑍴Σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1407\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-ⴄ𝟢\x{0663}．𑍴σ", %p)},	undef,	"to_ascii\(\'\-ⴄ𝟢\\u0663．𑍴σ\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1408\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󦈄。-", %p)},	undef,	"to_ascii\(\'\?\。\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1409\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮．򶈮\x{0F18}ß≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮．\?\\u0F18ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1410\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮．򶈮\x{0F18}ß>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮．\?\\u0F18ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1411\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮.򶈮\x{0F18}ß≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮\.\?\\u0F18ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1412\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮.򶈮\x{0F18}ß>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮\.\?\\u0F18ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1413\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮.򶈮\x{0F18}SS>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮\.\?\\u0F18SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1414\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮.򶈮\x{0F18}SS≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮\.\?\\u0F18SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1415\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮.򶈮\x{0F18}ss≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮\.\?\\u0F18ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1416\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮.򶈮\x{0F18}ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮\.\?\\u0F18ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮.򶈮\x{0F18}Ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮\.\?\\u0F18Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1418\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮.򶈮\x{0F18}Ss≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮\.\?\\u0F18Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1419\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮．򶈮\x{0F18}SS>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮．\?\\u0F18SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1420\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮．򶈮\x{0F18}SS≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮．\?\\u0F18SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1421\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮．򶈮\x{0F18}ss≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮．\?\\u0F18ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1422\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮．򶈮\x{0F18}ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮．\?\\u0F18ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1423\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮．򶈮\x{0F18}Ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮．\?\\u0F18Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1424\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮．򶈮\x{0F18}Ss≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮．\?\\u0F18Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1425\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1𐋸\x{0664}｡󠢮\x{FBA4}񷝊", %p)},	undef,	"to_ascii\(\'1𐋸\\u0664｡\?\\uFBA4\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1426\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1𐋸\x{0664}。󠢮\x{06C0}񷝊", %p)},	undef,	"to_ascii\(\'1𐋸\\u0664\。\?\\u06C0\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1427\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1𐋸\x{0664}。󠢮\x{06D5}\x{0654}񷝊", %p)},	undef,	"to_ascii\(\'1𐋸\\u0664\。\?\\u06D5\\u0654\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1428\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("儭-｡𐹴Ⴢ񥳠\x{200C}", %p)},	undef,	"to_ascii\(\'儭\-｡𐹴Ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1429\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("儭-。𐹴Ⴢ񥳠\x{200C}", %p)},	undef,	"to_ascii\(\'儭\-\。𐹴Ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1431\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("儭-。𐹴ⴢ񥳠\x{200C}", %p)},	undef,	"to_ascii\(\'儭\-\。𐹴ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1433\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("儭-｡𐹴ⴢ񥳠\x{200C}", %p)},	undef,	"to_ascii\(\'儭\-｡𐹴ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1435\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟺𐋷\x{06B9}．𞤭򿍡", %p)},	undef,	"to_ascii\(\'𝟺𐋷\\u06B9．\?\?\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1437\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4𐋷\x{06B9}.𞤭򿍡", %p)},	undef,	"to_ascii\(\'4𐋷\\u06B9\.\?\?\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1438\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯-ꡋ𑲣.⒈𐹭", %p)},	undef,	"to_ascii\(\'\≯\-ꡋ\?\.⒈𐹭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1439\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}-ꡋ𑲣.⒈𐹭", %p)},	undef,	"to_ascii\(\'\>\\u0338\-ꡋ\?\.⒈𐹭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1440\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯-ꡋ𑲣.1.𐹭", %p)},	undef,	"to_ascii\(\'\≯\-ꡋ\?\.1\.𐹭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1441\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}-ꡋ𑲣.1.𐹭", %p)},	undef,	"to_ascii\(\'\>\\u0338\-ꡋ\?\.1\.𐹭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1442\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0330}．󰜱蚀", %p)},	undef,	"to_ascii\(\'\\u0330．\?蚀\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1443\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0330}.󰜱蚀", %p)},	undef,	"to_ascii\(\'\\u0330\.\?蚀\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1444\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FB39}Ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_ascii\(\'\\uFB39Ⴘ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1445\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D9}\x{05BC}Ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_ascii\(\'\\u05D9\\u05BCႸ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1446\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{05D9}\x{05BC}ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_ascii\(\'\\u05D9\\u05BCⴘ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1447\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{05D9}\x{05BC}Ⴘ.𞡼𑇀SS\x{20D7}", %p)},	undef,	"to_ascii\(\'\\u05D9\\u05BCႸ\.𞡼𑇀SS\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1448\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{05D9}\x{05BC}ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_ascii\(\'\\u05D9\\u05BCⴘ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1449\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{05D9}\x{05BC}Ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_ascii\(\'\\u05D9\\u05BCႸ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1450\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{FB39}ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_ascii\(\'\\uFB39ⴘ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1451\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{FB39}Ⴘ.𞡼𑇀SS\x{20D7}", %p)},	undef,	"to_ascii\(\'\\uFB39Ⴘ\.𞡼𑇀SS\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1452\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{FB39}ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_ascii\(\'\\uFB39ⴘ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1453\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{FB39}Ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_ascii\(\'\\uFB39Ⴘ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1454\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BA3}𐹰򁱓｡凬", %p)},	undef,	"to_ascii\(\'\\u1BA3𐹰\?｡凬\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1455\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BA3}𐹰򁱓。凬", %p)},	undef,	"to_ascii\(\'\\u1BA3𐹰\?\。凬\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1456\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🢟🄈\x{200D}ꡎ｡\x{0F84}", %p)},	undef,	"to_ascii\(\'🢟🄈\\u200Dꡎ｡\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1457\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🢟7,\x{200D}ꡎ。\x{0F84}", %p)},	undef,	"to_ascii\(\'🢟7\,\\u200Dꡎ\。\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1459\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡔ。\x{1039}ᢇ", %p)},	undef,	"to_ascii\(\'ꡔ\。\\u1039ᢇ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1461\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{20EB}≮.𝨖", %p)},	undef,	"to_ascii\(\'\\u20EB\≮\.𝨖\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1462\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{20EB}<\x{0338}.𝨖", %p)},	undef,	"to_ascii\(\'\\u20EB\<\\u0338\.𝨖\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1463\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴢ≯褦．ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'Ⴢ\≯褦．ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1464\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴢ>\x{0338}褦．ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'Ⴢ\>\\u0338褦．ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1465\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴢ≯褦.ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'Ⴢ\≯褦\.ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1466\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴢ>\x{0338}褦.ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'Ⴢ\>\\u0338褦\.ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1467\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴢ>\x{0338}褦.ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'ⴢ\>\\u0338褦\.ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1468\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴢ≯褦.ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'ⴢ\≯褦\.ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1469\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴢ>\x{0338}褦．ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'ⴢ\>\\u0338褦．ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1470\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴢ≯褦．ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'ⴢ\≯褦．ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1471\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򊉆󠆒\x{200C}\x{A953}。𞤙\x{067B}ꡘ", %p)},	undef,	"to_ascii\(\'\?\󠆒\\u200C\\uA953\。\?\\u067Bꡘ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1472\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.≯", %p)},	undef,	"to_ascii\(\'\\u200C\.\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1474\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1476\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𰅧񣩠-．\x{ABED}-悜", %p)},	undef,	"to_ascii\(\'\?\?\-．\\uABED\-悜\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1478\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𰅧񣩠-.\x{ABED}-悜", %p)},	undef,	"to_ascii\(\'\?\?\-\.\\uABED\-悜\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1479\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡉ𶓧⬞ᢜ.-\x{200D}𞣑\x{202E}", %p)},	undef,	"to_ascii\(\'ᡉ\?\⬞ᢜ\.\-\\u200D𞣑\\u202E\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1480\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒐\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_ascii\(\'⒐\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1482\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_ascii\(\'9\.\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1484\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("9.\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_ascii\(\'9\.\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1486\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("9.\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_ascii\(\'9\.\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1488\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒐\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_ascii\(\'⒐\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1490\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒐\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_ascii\(\'⒐\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1492\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{07E1}\x{200C}。--⸬", %p)},	undef,	"to_ascii\(\'\\u07E1\\u200C\。\-\-\⸬\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1494\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞥓．\x{0718}", %p)},	"xn--of6h.xn--inb",	"to_ascii\(\'\?．\\u0718\'\)\ \[data\/IdnaTest\.txt\:1496\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞥓.\x{0718}", %p)},	"xn--of6h.xn--inb",	"to_ascii\(\'\?\.\\u0718\'\)\ \[data\/IdnaTest\.txt\:1497\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--of6h.xn--inb", %p)},	"xn--of6h.xn--inb",	"to_ascii\(\'xn\-\-of6h\.xn\-\-inb\'\)\ \[data\/IdnaTest\.txt\:1498\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󠄽-．-\x{0DCA}", %p)},	undef,	"to_ascii\(\'\󠄽\-．\-\\u0DCA\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1499\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄽-.-\x{0DCA}", %p)},	undef,	"to_ascii\(\'\󠄽\-\.\-\\u0DCA\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1500\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("󠇝\x{075B}-.\x{1927}", %p)},	undef,	"to_ascii\(\'\󠇝\\u075B\-\.\\u1927\'\)\ throws\ error\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1501\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞤴󠆹⦉𐹺.\x{A806}⒌󘤸", %p)},	undef,	"to_ascii\(\'\?\󠆹\⦉𐹺\.\\uA806⒌\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1502\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤴󠆹⦉𐹺.\x{A806}5.󘤸", %p)},	undef,	"to_ascii\(\'\?\󠆹\⦉𐹺\.\\uA8065\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1503\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠄸₀。𑖿\x{200C}𐦂\x{200D}", %p)},	undef,	"to_ascii\(\'\󠄸₀\。𑖿\\u200C𐦂\\u200D\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1504\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠄸0。𑖿\x{200C}𐦂\x{200D}", %p)},	undef,	"to_ascii\(\'\󠄸0\。𑖿\\u200C𐦂\\u200D\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1506\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴚ𐋸󠄄。𝟝ퟶ\x{103A}", %p)},	undef,	"to_ascii\(\'Ⴚ𐋸\󠄄\。𝟝ퟶ\\u103A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1508\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴚ𐋸󠄄。5ퟶ\x{103A}", %p)},	undef,	"to_ascii\(\'Ⴚ𐋸\󠄄\。5ퟶ\\u103A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1509\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ⴚ𐋸󠄄。5ퟶ\x{103A}", %p)},	"xn--ilj2659d.xn--5-dug9054m",	"to_ascii\(\'ⴚ𐋸\󠄄\。5ퟶ\\u103A\'\)\ \[data\/IdnaTest\.txt\:1510\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--ilj2659d.xn--5-dug9054m", %p)},	"xn--ilj2659d.xn--5-dug9054m",	"to_ascii\(\'xn\-\-ilj2659d\.xn\-\-5\-dug9054m\'\)\ \[data\/IdnaTest\.txt\:1511\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ⴚ𐋸.5ퟶ\x{103A}", %p)},	"xn--ilj2659d.xn--5-dug9054m",	"to_ascii\(\'ⴚ𐋸\.5ퟶ\\u103A\'\)\ \[data\/IdnaTest\.txt\:1512\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴚ𐋸.5ퟶ\x{103A}", %p)},	undef,	"to_ascii\(\'Ⴚ𐋸\.5ퟶ\\u103A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1513\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ⴚ𐋸󠄄。𝟝ퟶ\x{103A}", %p)},	"xn--ilj2659d.xn--5-dug9054m",	"to_ascii\(\'ⴚ𐋸\󠄄\。𝟝ퟶ\\u103A\'\)\ \[data\/IdnaTest\.txt\:1514\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}-ᠹ﹪.\x{1DE1}\x{1922}", %p)},	undef,	"to_ascii\(\'\\u200D\-ᠹ﹪\.\\u1DE1\\u1922\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1515\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-ᠹ%.\x{1DE1}\x{1922}", %p)},	undef,	"to_ascii\(\'\\u200D\-ᠹ\%\.\\u1DE1\\u1922\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1517\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠.ᠿ", %p)},	undef,	"to_ascii\(\'\≠\.ᠿ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1519\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}.ᠿ", %p)},	undef,	"to_ascii\(\'\=\\u0338\.ᠿ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1520\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0723}\x{05A3}｡㌪", %p)},	"xn--ucb18e.xn--eck4c5a",	"to_ascii\(\'\\u0723\\u05A3｡㌪\'\)\ \[data\/IdnaTest\.txt\:1521\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0723}\x{05A3}。ハイツ", %p)},	"xn--ucb18e.xn--eck4c5a",	"to_ascii\(\'\\u0723\\u05A3\。ハイツ\'\)\ \[data\/IdnaTest\.txt\:1522\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ucb18e.xn--eck4c5a", %p)},	"xn--ucb18e.xn--eck4c5a",	"to_ascii\(\'xn\-\-ucb18e\.xn\-\-eck4c5a\'\)\ \[data\/IdnaTest\.txt\:1523\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0723}\x{05A3}.ハイツ", %p)},	"xn--ucb18e.xn--eck4c5a",	"to_ascii\(\'\\u0723\\u05A3\.ハイツ\'\)\ \[data\/IdnaTest\.txt\:1524\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞷥󠆀≮.\x{2D7F}-", %p)},	undef,	"to_ascii\(\'\?\󠆀\≮\.\\u2D7F\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1525\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞷥󠆀<\x{0338}.\x{2D7F}-", %p)},	undef,	"to_ascii\(\'\?\󠆀\<\\u0338\.\\u2D7F\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1526\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("₆榎򦖎\x{0D4D}｡𞤅\x{06ED}\x{FC5A}󠮨", %p)},	undef,	"to_ascii\(\'₆榎\?\\u0D4D｡\?\\u06ED\\uFC5A\?\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:1527\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6榎򦖎\x{0D4D}。𞤅\x{06ED}\x{064A}\x{064A}󠮨", %p)},	undef,	"to_ascii\(\'6榎\?\\u0D4D\。\?\\u06ED\\u064A\\u064A\?\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:1528\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𣩫．򌑲", %p)},	undef,	"to_ascii\(\'𣩫．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1529\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𣩫.򌑲", %p)},	undef,	"to_ascii\(\'𣩫\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1530\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}︒｡\x{06B9}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200D︒｡\\u06B9\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1531\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。。\x{06B9}\x{200C}", %p)},	"xn--skb",	"to_ascii\(\'\\u200D\。\。\\u06B9\\u200C\'\)\ \[data\/IdnaTest\.txt\:1533\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--skb", %p)},	"xn--skb",	"to_ascii\(\'xn\-\-skb\'\)\ \[data\/IdnaTest\.txt\:1535\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06B9}", %p)},	"xn--skb",	"to_ascii\(\'\\u06B9\'\)\ \[data\/IdnaTest\.txt\:1536\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹦\x{200C}𐹶。\x{206D}", %p)},	undef,	"to_ascii\(\'𐹦\\u200C𐹶\。\\u206D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1537\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{0C4D}𝨾\x{05A9}𝟭。-𑜨", %p)},	undef,	"to_ascii\(\'\\u0C4D𝨾\\u05A9𝟭\。\-𑜨\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1539\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{0C4D}𝨾\x{05A9}1。-𑜨", %p)},	undef,	"to_ascii\(\'\\u0C4D𝨾\\u05A91\。\-𑜨\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1540\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򣿈。뙏", %p)},	undef,	"to_ascii\(\'\?\。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1541\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򣿈。뙏", %p)},	undef,	"to_ascii\(\'\?\。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1542\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񕨚󠄌󑽀ᡀ.\x{08B6}", %p)},	undef,	"to_ascii\(\'\?\󠄌\?ᡀ\.\\u08B6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1543\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}｡񅁛", %p)},	undef,	"to_ascii\(\'\\u200D｡\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1544\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。񅁛", %p)},	undef,	"to_ascii\(\'\\u200D\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1546\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{084B}皥．-", %p)},	undef,	"to_ascii\(\'\\u084B皥．\-\'\)\ throws\ error\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:1548\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{084B}皥.-", %p)},	undef,	"to_ascii\(\'\\u084B皥\.\-\'\)\ throws\ error\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:1549\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐣸\x{0315}𐮇．⒈ꡦ", %p)},	undef,	"to_ascii\(\'\?\\u0315𐮇．⒈ꡦ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1550\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐣸\x{0315}𐮇.1.ꡦ", %p)},	undef,	"to_ascii\(\'\?\\u0315𐮇\.1\.ꡦ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1551\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}ā𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0ā𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1552\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}a\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1554\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}ā𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160ā𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1556\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}a\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1558\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}a\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'ⴛ\\u200C\\u05A2\\u200D\。\\u1160a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1560\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}ā𐹦", %p)},	undef,	"to_ascii\(\'ⴛ\\u200C\\u05A2\\u200D\。\\u1160ā𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1562\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}Ā𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160Ā𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1564\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}A\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160A\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1566\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}a\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1568\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}ā𐹦", %p)},	undef,	"to_ascii\(\'ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0ā𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1570\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}Ā𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0Ā𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1572\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}A\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0A\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1574\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FFF9}\x{200C}｡曳⾑𐋰≯", %p)},	undef,	"to_ascii\(\'\\uFFF9\\u200C｡曳⾑𐋰\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1576\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FFF9}\x{200C}｡曳⾑𐋰>\x{0338}", %p)},	undef,	"to_ascii\(\'\\uFFF9\\u200C｡曳⾑𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1578\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FFF9}\x{200C}。曳襾𐋰≯", %p)},	undef,	"to_ascii\(\'\\uFFF9\\u200C\。曳襾𐋰\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1580\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FFF9}\x{200C}。曳襾𐋰>\x{0338}", %p)},	undef,	"to_ascii\(\'\\uFFF9\\u200C\。曳襾𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1582\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯⒈。ß", %p)},	undef,	"to_ascii\(\'\≯⒈\。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1584\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}⒈。ß", %p)},	undef,	"to_ascii\(\'\>\\u0338⒈\。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1585\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯1.。ß", %p)},	undef,	"to_ascii\(\'\≯1\.\。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1586\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}1.。ß", %p)},	undef,	"to_ascii\(\'\>\\u03381\.\。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1587\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}1.。SS", %p)},	undef,	"to_ascii\(\'\>\\u03381\.\。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1588\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯1.。SS", %p)},	undef,	"to_ascii\(\'\≯1\.\。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1589\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}⒈。SS", %p)},	undef,	"to_ascii\(\'\>\\u0338⒈\。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1590\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯⒈。SS", %p)},	undef,	"to_ascii\(\'\≯⒈\。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1591\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0667}\x{200D}\x{FB96}｡\x{07DA}-₆Ⴙ", %p)},	undef,	"to_ascii\(\'\\u0667\\u200D\\uFB96｡\\u07DA\-₆Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1592\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0667}\x{200D}\x{06B3}。\x{07DA}-6Ⴙ", %p)},	undef,	"to_ascii\(\'\\u0667\\u200D\\u06B3\。\\u07DA\-6Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1594\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{0667}\x{200D}\x{06B3}。\x{07DA}-6ⴙ", %p)},	undef,	"to_ascii\(\'\\u0667\\u200D\\u06B3\。\\u07DA\-6ⴙ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1596\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{0667}\x{200D}\x{FB96}｡\x{07DA}-₆ⴙ", %p)},	undef,	"to_ascii\(\'\\u0667\\u200D\\uFB96｡\\u07DA\-₆ⴙ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1598\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}｡≠", %p)},	undef,	"to_ascii\(\'\\u200C｡\≠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1600\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}｡=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C｡\=\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1602\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。≠", %p)},	undef,	"to_ascii\(\'\\u200C\。\≠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1604\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1606\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𑖿𝨔.ᡟ𑖿\x{1B42}\x{200C}", %p)},	undef,	"to_ascii\(\'𑖿𝨔\.ᡟ𑖿\\u1B42\\u200C\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1608\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򔣳\x{200D}򑝱.𖬴Ↄ≠-", %p)},	undef,	"to_ascii\(\'\?\\u200D\?\.𖬴Ↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ \[data\/IdnaTest\.txt\:1610\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔣳\x{200D}򑝱.𖬴Ↄ=\x{0338}-", %p)},	undef,	"to_ascii\(\'\?\\u200D\?\.𖬴Ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ \[data\/IdnaTest\.txt\:1612\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔣳\x{200D}򑝱.𖬴ↄ=\x{0338}-", %p)},	undef,	"to_ascii\(\'\?\\u200D\?\.𖬴ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ \[data\/IdnaTest\.txt\:1614\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔣳\x{200D}򑝱.𖬴ↄ≠-", %p)},	undef,	"to_ascii\(\'\?\\u200D\?\.𖬴ↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ \[data\/IdnaTest\.txt\:1616\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}ς\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2ς\\u200D𝟳\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1618\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}ς\x{200D}7。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2ς\\u200D7\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1620\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}Σ\x{200D}7。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2Σ\\u200D7\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1622\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}σ\x{200D}7。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2σ\\u200D7\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1624\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}Σ\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2Σ\\u200D𝟳\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1626\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}σ\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2σ\\u200D𝟳\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1628\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹰.\x{0600}", %p)},	undef,	"to_ascii\(\'𐹰\.\\u0600\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1630\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{08A8}.𱠖", %p)},	undef,	"to_ascii\(\'\-\\u08A8\.\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1631\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯𞱸󠇀。誆⒈", %p)},	undef,	"to_ascii\(\'\≯\?\󠇀\。誆⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1632\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}𞱸󠇀。誆⒈", %p)},	undef,	"to_ascii\(\'\>\\u0338\?\󠇀\。誆⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1633\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯𞱸󠇀。誆1.", %p)},	undef,	"to_ascii\(\'\≯\?\󠇀\。誆1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1634\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}𞱸󠇀。誆1.", %p)},	undef,	"to_ascii\(\'\>\\u0338\?\󠇀\。誆1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1635\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0616}𞥙䐊\x{0650}．︒\x{0645}↺\x{069C}", %p)},	undef,	"to_ascii\(\'\\u0616\?䐊\\u0650．︒\\u0645\↺\\u069C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1636\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{0616}𞥙䐊\x{0650}.。\x{0645}↺\x{069C}", %p)},	undef,	"to_ascii\(\'\\u0616\?䐊\\u0650\.\。\\u0645\↺\\u069C\'\)\ throws\ error\ V5\ B1\ A4_2\ \[data\/IdnaTest\.txt\:1637\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.\x{200C}\x{0AC5}󩸤۴", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.\\u200C\\u0AC5\?۴\'\)\ throws\ error\ P1\ V6\ V5\ A3\ \[data\/IdnaTest\.txt\:1638\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.\x{200C}\x{0AC5}󩸤۴", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.\\u200C\\u0AC5\?۴\'\)\ throws\ error\ P1\ V6\ V5\ A3\ \[data\/IdnaTest\.txt\:1640\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴌ.𐹾︒𑁿𞾄", %p)},	undef,	"to_ascii\(\'Ⴌ\.𐹾︒𑁿\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1642\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴌ.𐹾。𑁿𞾄", %p)},	undef,	"to_ascii\(\'Ⴌ\.𐹾\。𑁿\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1643\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴌ.𐹾。𑁿𞾄", %p)},	undef,	"to_ascii\(\'ⴌ\.𐹾\。𑁿\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1644\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴌ.𐹾︒𑁿𞾄", %p)},	undef,	"to_ascii\(\'ⴌ\.𐹾︒𑁿\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1645\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񧞿╏。𞩕󠁾", %p)},	undef,	"to_ascii\(\'\?\╏\。\?\?\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:1646\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}┮󠇐．\x{0C00}\x{0C4D}\x{1734}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D\┮\󠇐．\\u0C00\\u0C4D\\u1734\\u200D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1647\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}┮󠇐.\x{0C00}\x{0C4D}\x{1734}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D\┮\󠇐\.\\u0C00\\u0C4D\\u1734\\u200D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1649\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򹚪｡🄂", %p)},	undef,	"to_ascii\(\'\?｡🄂\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1651\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򹚪。1,", %p)},	undef,	"to_ascii\(\'\?\。1\,\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1652\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𑍨刍.🛦", %p)},	undef,	"to_ascii\(\'𑍨刍\.🛦\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1653\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󠌏3｡\x{1BF1}𝟒", %p)},	undef,	"to_ascii\(\'\?3｡\\u1BF1𝟒\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1654\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠌏3。\x{1BF1}4", %p)},	undef,	"to_ascii\(\'\?3\。\\u1BF14\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1655\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0687}６Ⴔ辘.\x{FD22}\x{0687}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0687６Ⴔ辘\.\\uFD22\\u0687\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1656\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0687}6Ⴔ辘.\x{0635}\x{064A}\x{0687}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06876Ⴔ辘\.\\u0635\\u064A\\u0687\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1658\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0687}6ⴔ辘.\x{0635}\x{064A}\x{0687}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06876ⴔ辘\.\\u0635\\u064A\\u0687\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1660\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0687}６ⴔ辘.\x{FD22}\x{0687}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0687６ⴔ辘\.\\uFD22\\u0687\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1662\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󠄍.𐮭𞰬򻫞۹", %p)},	undef,	"to_ascii\(\'\󠄍\.𐮭\?\?۹\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1664\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A87D}≯．򻲀򒳄", %p)},	undef,	"to_ascii\(\'\\uA87D\≯．\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1665\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A87D}>\x{0338}．򻲀򒳄", %p)},	undef,	"to_ascii\(\'\\uA87D\>\\u0338．\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1666\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A87D}≯.򻲀򒳄", %p)},	undef,	"to_ascii\(\'\\uA87D\≯\.\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1667\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A87D}>\x{0338}.򻲀򒳄", %p)},	undef,	"to_ascii\(\'\\uA87D\>\\u0338\.\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1668\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ςო\x{067B}.ς\x{0714}", %p)},	undef,	"to_ascii\(\'ςო\\u067B\.ς\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1669\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σო\x{067B}.Σ\x{0714}", %p)},	undef,	"to_ascii\(\'Σო\\u067B\.Σ\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1670\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σო\x{067B}.σ\x{0714}", %p)},	undef,	"to_ascii\(\'σო\\u067B\.σ\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1671\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σო\x{067B}.σ\x{0714}", %p)},	undef,	"to_ascii\(\'Σო\\u067B\.σ\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1672\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σო\x{067B}.ς\x{0714}", %p)},	undef,	"to_ascii\(\'Σო\\u067B\.ς\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1673\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σო\x{067B}.ς\x{0714}", %p)},	undef,	"to_ascii\(\'σო\\u067B\.ς\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1674\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򄖚\x{0748}𠄯\x{075F}｡󠛩", %p)},	undef,	"to_ascii\(\'\?\\u0748𠄯\\u075F｡\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1675\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򄖚\x{0748}𠄯\x{075F}。󠛩", %p)},	undef,	"to_ascii\(\'\?\\u0748𠄯\\u075F\。\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1676\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛．\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_ascii\(\'\?．\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1677\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛．\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_ascii\(\'\?．\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1679\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛.\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_ascii\(\'\?\.\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1681\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛.\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_ascii\(\'\?\.\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1683\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛.\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_ascii\(\'\?\.\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1685\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛.\x{200D}䤫≠ⴞ", %p)},	undef,	"to_ascii\(\'\?\.\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1687\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛．\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_ascii\(\'\?．\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1689\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛．\x{200D}䤫≠ⴞ", %p)},	undef,	"to_ascii\(\'\?．\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1691\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐽘𑈵．𐹣🕥", %p)},	undef,	"to_ascii\(\'\?𑈵．𐹣🕥\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1693\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐽘𑈵.𐹣🕥", %p)},	undef,	"to_ascii\(\'\?𑈵\.𐹣🕥\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1694\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒊⒈𑁄。9", %p)},	undef,	"to_ascii\(\'⒊⒈𑁄\。9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1695\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("3.1.𑁄。9", %p)},	undef,	"to_ascii\(\'3\.1\.𑁄\。9\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1696\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-\x{200C}\x{2DF1}≮．𐹱򭏴4₉", %p)},	undef,	"to_ascii\(\'\-\\u200C\\u2DF1\≮．𐹱\?4₉\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1697\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200C}\x{2DF1}<\x{0338}．𐹱򭏴4₉", %p)},	undef,	"to_ascii\(\'\-\\u200C\\u2DF1\<\\u0338．𐹱\?4₉\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1699\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200C}\x{2DF1}≮.𐹱򭏴49", %p)},	undef,	"to_ascii\(\'\-\\u200C\\u2DF1\≮\.𐹱\?49\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1701\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200C}\x{2DF1}<\x{0338}.𐹱򭏴49", %p)},	undef,	"to_ascii\(\'\-\\u200C\\u2DF1\<\\u0338\.𐹱\?49\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1703\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≯딾｡\x{0847}", %p)},	undef,	"to_ascii\(\'\-\≯딾｡\\u0847\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1705\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("->\x{0338}딾｡\x{0847}", %p)},	undef,	"to_ascii\(\'\-\>\\u0338딾｡\\u0847\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1706\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≯딾。\x{0847}", %p)},	undef,	"to_ascii\(\'\-\≯딾\。\\u0847\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1707\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("->\x{0338}딾。\x{0847}", %p)},	undef,	"to_ascii\(\'\-\>\\u0338딾\。\\u0847\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1708\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑙢⒈𐹠-｡󠗐\x{200C}", %p)},	undef,	"to_ascii\(\'\?⒈𐹠\-｡\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1709\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑙢1.𐹠-。󠗐\x{200C}", %p)},	undef,	"to_ascii\(\'\?1\.𐹠\-\。\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1711\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{034A}．𐨎", %p)},	undef,	"to_ascii\(\'\\u034A．𐨎\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1713\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{034A}.𐨎", %p)},	undef,	"to_ascii\(\'\\u034A\.𐨎\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1714\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("훉≮｡\x{0E34}", %p)},	undef,	"to_ascii\(\'훉\≮｡\\u0E34\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1715\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("훉<\x{0338}｡\x{0E34}", %p)},	undef,	"to_ascii\(\'훉\<\\u0338｡\\u0E34\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1716\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("훉≮。\x{0E34}", %p)},	undef,	"to_ascii\(\'훉\≮\。\\u0E34\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1717\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("훉<\x{0338}。\x{0E34}", %p)},	undef,	"to_ascii\(\'훉\<\\u0338\。\\u0E34\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1718\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DF7}򞣉🃘．𴈇𝟸\x{0659}𞤯", %p)},	undef,	"to_ascii\(\'\\u2DF7\?🃘．\?𝟸\\u0659\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1719\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DF7}򞣉🃘.𴈇2\x{0659}𞤯", %p)},	undef,	"to_ascii\(\'\\u2DF7\?🃘\.\?2\\u0659\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1720\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩ßᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_ascii\(\'\?ßᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:1721\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩ßᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_ascii\(\'\?ßᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:1723\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩SSᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_ascii\(\'\?SSᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:1725\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩ssᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_ascii\(\'\?ssᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:1727\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩Ssᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_ascii\(\'\?Ssᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:1729\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩SSᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_ascii\(\'\?SSᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:1731\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩ssᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_ascii\(\'\?ssᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:1733\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩Ssᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_ascii\(\'\?Ssᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:1735\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡆ。Ↄ\x{0FB5}놮-", %p)},	undef,	"to_ascii\(\'ꡆ\。Ↄ\\u0FB5놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1737\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡆ。Ↄ\x{0FB5}놮-", %p)},	undef,	"to_ascii\(\'ꡆ\。Ↄ\\u0FB5놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1738\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡆ。ↄ\x{0FB5}놮-", %p)},	undef,	"to_ascii\(\'ꡆ\。ↄ\\u0FB5놮\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1739\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡆ。ↄ\x{0FB5}놮-", %p)},	undef,	"to_ascii\(\'ꡆ\。ↄ\\u0FB5놮\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1740\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{FDAD}\x{200D}.񥰌\x{06A9}", %p)},	undef,	"to_ascii\(\'\\uFDAD\\u200D\.\?\\u06A9\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1741\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0645}\x{064A}\x{200D}.񥰌\x{06A9}", %p)},	undef,	"to_ascii\(\'\\u0644\\u0645\\u064A\\u200D\.\?\\u06A9\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ\x{1C2F}𐳒≯。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'Ⴜ\\u1C2F𐳒\≯\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1745\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ\x{1C2F}𐳒>\x{0338}。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'Ⴜ\\u1C2F𐳒\>\\u0338\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1746\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴜ\x{1C2F}𐳒>\x{0338}。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'ⴜ\\u1C2F𐳒\>\\u0338\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1747\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴜ\x{1C2F}𐳒≯。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'ⴜ\\u1C2F𐳒\≯\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1748\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ\x{1C2F}𐲒≯。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'Ⴜ\\u1C2F𐲒\≯\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1749\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ\x{1C2F}𐲒>\x{0338}。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'Ⴜ\\u1C2F𐲒\>\\u0338\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1750\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋵。\x{FCEC}", %p)},	"xn--p97c.xn--fhbe",	"to_ascii\(\'𐋵\。\\uFCEC\'\)\ \[data\/IdnaTest\.txt\:1751\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋵。\x{0643}\x{0645}", %p)},	"xn--p97c.xn--fhbe",	"to_ascii\(\'𐋵\。\\u0643\\u0645\'\)\ \[data\/IdnaTest\.txt\:1752\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--p97c.xn--fhbe", %p)},	"xn--p97c.xn--fhbe",	"to_ascii\(\'xn\-\-p97c\.xn\-\-fhbe\'\)\ \[data\/IdnaTest\.txt\:1753\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋵.\x{0643}\x{0645}", %p)},	"xn--p97c.xn--fhbe",	"to_ascii\(\'𐋵\.\\u0643\\u0645\'\)\ \[data\/IdnaTest\.txt\:1754\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("≮𝅶．񱲁\x{AAEC}\x{2E48}󰥭", %p)},	undef,	"to_ascii\(\'\≮\?．\?\\uAAEC\\u2E48\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1755\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𝅶．񱲁\x{AAEC}\x{2E48}󰥭", %p)},	undef,	"to_ascii\(\'\<\\u0338\?．\?\\uAAEC\\u2E48\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1756\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𝅶.񱲁\x{AAEC}\x{2E48}󰥭", %p)},	undef,	"to_ascii\(\'\≮\?\.\?\\uAAEC\\u2E48\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1757\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𝅶.񱲁\x{AAEC}\x{2E48}󰥭", %p)},	undef,	"to_ascii\(\'\<\\u0338\?\.\?\\uAAEC\\u2E48\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1758\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DF0}\x{0358}ᢕ．\x{0361}𐹷󠴍", %p)},	undef,	"to_ascii\(\'\\u2DF0\\u0358ᢕ．\\u0361𐹷\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1759\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DF0}\x{0358}ᢕ.\x{0361}𐹷󠴍", %p)},	undef,	"to_ascii\(\'\\u2DF0\\u0358ᢕ\.\\u0361𐹷\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1760\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{FD79}ᡐ\x{200C}\x{06AD}．𑋪\x{05C7}", %p)},	undef,	"to_ascii\(\'\\uFD79ᡐ\\u200C\\u06AD．𑋪\\u05C7\'\)\ throws\ error\ V5\ B2\ \[data\/IdnaTest\.txt\:1761\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{063A}\x{0645}\x{0645}ᡐ\x{200C}\x{06AD}.𑋪\x{05C7}", %p)},	undef,	"to_ascii\(\'\\u063A\\u0645\\u0645ᡐ\\u200C\\u06AD\.𑋪\\u05C7\'\)\ throws\ error\ V5\ B2\ \[data\/IdnaTest\.txt\:1762\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𑑂｡\x{200D}󥞀🞕򥁔", %p)},	undef,	"to_ascii\(\'\?｡\\u200D\?🞕\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1763\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑂。\x{200D}󥞀🞕򥁔", %p)},	undef,	"to_ascii\(\'\?\。\\u200D\?🞕\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1765\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{05E9}。⒚", %p)},	undef,	"to_ascii\(\'\-\\u05E9\。⒚\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1767\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{05E9}。19.", %p)},	undef,	"to_ascii\(\'\-\\u05E9\。19\.\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1768\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("􊾻\x{0845}\x{200C}｡ᢎ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\\u0845\\u200C｡ᢎ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1769\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("􊾻\x{0845}\x{200C}。ᢎ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\\u0845\\u200C\。ᢎ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1771\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ß\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:1773\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß\x{09C1}\x{1DED}。\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ß\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:1775\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("SS\x{09C1}\x{1DED}。\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'SS\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:1777\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss\x{09C1}\x{1DED}。\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ss\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:1778\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Ss\x{09C1}\x{1DED}。\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'Ss\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:1779\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--ss-e2f077r.xn--85-psd", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'xn\-\-ss\-e2f077r\.xn\-\-85\-psd\'\)\ \[data\/IdnaTest\.txt\:1780\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss\x{09C1}\x{1DED}.\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ss\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:1781\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("SS\x{09C1}\x{1DED}.\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'SS\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:1782\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Ss\x{09C1}\x{1DED}.\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'Ss\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:1783\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--zca266bwrr.xn--85-psd", %p)},	"xn--zca266bwrr.xn--85-psd",	"to_ascii\(\'xn\-\-zca266bwrr\.xn\-\-85\-psd\'\)\ \[data\/IdnaTest\.txt\:1784\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß\x{09C1}\x{1DED}.\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ß\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:1785\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("SS\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'SS\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:1787\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ss\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:1788\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Ss\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'Ss\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:1789\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅𝟣．₃𐹥ß", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅𝟣．₃𐹥ß\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1790\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅1.3𐹥ß", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅1\.3𐹥ß\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1791\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅1.3𐹥SS", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅1\.3𐹥SS\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1792\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅1.3𐹥ss", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅1\.3𐹥ss\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1793\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅1.3𐹥Ss", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅1\.3𐹥Ss\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1794\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅𝟣．₃𐹥SS", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅𝟣．₃𐹥SS\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1795\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅𝟣．₃𐹥ss", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅𝟣．₃𐹥ss\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1796\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅𝟣．₃𐹥Ss", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅𝟣．₃𐹥Ss\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1797\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{072B}｡𑓂⒈𑜫󠿻", %p)},	undef,	"to_ascii\(\'\\u072B｡𑓂⒈𑜫\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1798\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{072B}。𑓂1.𑜫󠿻", %p)},	undef,	"to_ascii\(\'\\u072B\。𑓂1\.𑜫\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1799\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FE0D}છ。嵨", %p)},	"xn--6dc.xn--tot",	"to_ascii\(\'\\uFE0Dછ\。嵨\'\)\ \[data\/IdnaTest\.txt\:1800\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6dc.xn--tot", %p)},	"xn--6dc.xn--tot",	"to_ascii\(\'xn\-\-6dc\.xn\-\-tot\'\)\ \[data\/IdnaTest\.txt\:1801\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("છ.嵨", %p)},	"xn--6dc.xn--tot",	"to_ascii\(\'છ\.嵨\'\)\ \[data\/IdnaTest\.txt\:1802\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔ≠Ⴀ.𐹥𐹰", %p)},	undef,	"to_ascii\(\'Ⴔ\≠Ⴀ\.𐹥𐹰\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1803\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔ=\x{0338}Ⴀ.𐹥𐹰", %p)},	undef,	"to_ascii\(\'Ⴔ\=\\u0338Ⴀ\.𐹥𐹰\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1804\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴔ=\x{0338}ⴀ.𐹥𐹰", %p)},	undef,	"to_ascii\(\'ⴔ\=\\u0338ⴀ\.𐹥𐹰\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1805\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴔ≠ⴀ.𐹥𐹰", %p)},	undef,	"to_ascii\(\'ⴔ\≠ⴀ\.𐹥𐹰\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1806\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200C}⒙𐫥｡𝨵", %p)},	undef,	"to_ascii\(\'\-\\u200C⒙𐫥｡𝨵\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1807\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("-\x{200C}18.𐫥。𝨵", %p)},	undef,	"to_ascii\(\'\-\\u200C18\.𐫥\。𝨵\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1809\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("︒.ʌᠣ-𐹽", %p)},	undef,	"to_ascii\(\'︒\.ʌᠣ\-𐹽\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1811\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("。.ʌᠣ-𐹽", %p)},	undef,	"to_ascii\(\'\。\.ʌᠣ\-𐹽\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1812\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("。.Ʌᠣ-𐹽", %p)},	undef,	"to_ascii\(\'\。\.Ʌᠣ\-𐹽\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1813\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("︒.Ʌᠣ-𐹽", %p)},	undef,	"to_ascii\(\'︒\.Ʌᠣ\-𐹽\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1814\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FE05}︒。𦀾\x{1CE0}", %p)},	undef,	"to_ascii\(\'\\uFE05︒\。𦀾\\u1CE0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1815\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{FE05}。。𦀾\x{1CE0}", %p)},	"xn--t6f5138v",	"to_ascii\(\'\\uFE05\。\。𦀾\\u1CE0\'\)\ \[data\/IdnaTest\.txt\:1816\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("xn--t6f5138v", %p)},	"xn--t6f5138v",	"to_ascii\(\'xn\-\-t6f5138v\'\)\ \[data\/IdnaTest\.txt\:1817\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𦀾\x{1CE0}", %p)},	"xn--t6f5138v",	"to_ascii\(\'𦀾\\u1CE0\'\)\ \[data\/IdnaTest\.txt\:1818\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞮑ß􏞞。ᡁ", %p)},	undef,	"to_ascii\(\'\?ß\?\。ᡁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1819\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮑SS􏞞。ᡁ", %p)},	undef,	"to_ascii\(\'\?SS\?\。ᡁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1820\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮑ss􏞞。ᡁ", %p)},	undef,	"to_ascii\(\'\?ss\?\。ᡁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1821\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮑Ss􏞞。ᡁ", %p)},	undef,	"to_ascii\(\'\?Ss\?\。ᡁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1822\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A953}\x{200D}\x{062C}\x{066C}。𱆎󻡟\x{200C}󠅆", %p)},	undef,	"to_ascii\(\'\\uA953\\u200D\\u062C\\u066C\。\?\?\\u200C\󠅆\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1823\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-ß\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?．\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1825\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-ß\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?．\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1827\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-ß\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?\.\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1829\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-ß\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\.\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1831\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-SS\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\.\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1833\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-SS\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?\.\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1835\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-ss\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?\.\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1837\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-ss\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\.\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1839\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\.\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1841\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-Ss\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?\.\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1843\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-SS\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?．\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1845\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-SS\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?．\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1847\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-ss\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?．\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1849\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-ss\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?．\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1851\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?．\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1853\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-Ss\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?．\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1855\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡙ\x{200C}｡≯𐋲≠", %p)},	undef,	"to_ascii\(\'ᡙ\\u200C｡\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1857\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡙ\x{200C}｡>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_ascii\(\'ᡙ\\u200C｡\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1859\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡙ\x{200C}。≯𐋲≠", %p)},	undef,	"to_ascii\(\'ᡙ\\u200C\。\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1861\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡙ\x{200C}。>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_ascii\(\'ᡙ\\u200C\。\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1863\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹧𞲄󠁭񆼩。\x{034E}🄀", %p)},	undef,	"to_ascii\(\'𐹧\?\?\?\。\\u034E🄀\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1865\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹧𞲄󠁭񆼩。\x{034E}0.", %p)},	undef,	"to_ascii\(\'𐹧\?\?\?\。\\u034E0\.\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1866\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴄ．\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_ascii\(\'Ⴄ．\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1867\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴄ.\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_ascii\(\'Ⴄ\.\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1869\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴄ.\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_ascii\(\'ⴄ\.\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1871\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴄ.\x{200D}\x{0721}󻣋Σ", %p)},	undef,	"to_ascii\(\'Ⴄ\.\\u200D\\u0721\?Σ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1873\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴄ.\x{200D}\x{0721}󻣋σ", %p)},	undef,	"to_ascii\(\'ⴄ\.\\u200D\\u0721\?σ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1875\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴄ．\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_ascii\(\'ⴄ．\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1877\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴄ．\x{200D}\x{0721}󻣋Σ", %p)},	undef,	"to_ascii\(\'Ⴄ．\\u200D\\u0721\?Σ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1879\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴄ．\x{200D}\x{0721}󻣋σ", %p)},	undef,	"to_ascii\(\'ⴄ．\\u200D\\u0721\?σ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1881\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򮵛\x{0613}.Ⴕ", %p)},	undef,	"to_ascii\(\'\?\\u0613\.Ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1883\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򮵛\x{0613}.ⴕ", %p)},	undef,	"to_ascii\(\'\?\\u0613\.ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1884\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯\x{1DF3}𞤥。\x{200C}\x{A8C4}󠪉\x{200D}", %p)},	undef,	"to_ascii\(\'\≯\\u1DF3\?\。\\u200C\\uA8C4\?\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1885\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{1DF3}𞤥。\x{200C}\x{A8C4}󠪉\x{200D}", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u1DF3\?\。\\u200C\\uA8C4\?\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1887\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠄷｡򒑁", %p)},	undef,	"to_ascii\(\'\\u200C\󠄷｡\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1889\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠄷。򒑁", %p)},	undef,	"to_ascii\(\'\\u200C\󠄷\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1891\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈\x{0DD6}焅.󗡙\x{200D}ꡟ", %p)},	undef,	"to_ascii\(\'⒈\\u0DD6焅\.\?\\u200Dꡟ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1893\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.\x{0DD6}焅.󗡙\x{200D}ꡟ", %p)},	undef,	"to_ascii\(\'1\.\\u0DD6焅\.\?\\u200Dꡟ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1895\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}ς≮.ς𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDς\≮\.ς𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1897\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}ς<\x{0338}.ς𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDς\<\\u0338\.ς𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1898\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}Σ<\x{0338}.Σ𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDΣ\<\\u0338\.Σ𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1899\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}Σ≮.Σ𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDΣ\≮\.Σ𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1900\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}σ≮.σ𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDσ\≮\.σ𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1901\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}σ<\x{0338}.σ𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDσ\<\\u0338\.σ𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1902\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򢦾ß\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_ascii\(\'\?ß\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1903\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򢦾SS\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_ascii\(\'\?SS\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1904\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򢦾ss\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_ascii\(\'\?ss\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1905\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򢦾Ss\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_ascii\(\'\?Ss\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1906\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𞣄｡⒈", %p)},	undef,	"to_ascii\(\'\-𞣄｡⒈\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1907\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-𞣄。1.", %p)},	undef,	"to_ascii\(\'\-𞣄\。1\.\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1908\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񈠢𐫖𝟡。\x{063E}𑘿", %p)},	undef,	"to_ascii\(\'\?𐫖𝟡\。\\u063E𑘿\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1909\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񈠢𐫖9。\x{063E}𑘿", %p)},	undef,	"to_ascii\(\'\?𐫖9\。\\u063E𑘿\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1910\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0668}\x{FC8C}\x{0668}\x{1A5D}.\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0668\\uFC8C\\u0668\\u1A5D\.\\u200D\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1911\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0668}\x{0646}\x{0645}\x{0668}\x{1A5D}.\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0668\\u0646\\u0645\\u0668\\u1A5D\.\\u200D\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1913\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𝟘．Ⴇ󀳑\x{FD50}񫃱", %p)},	undef,	"to_ascii\(\'𝟘．Ⴇ\?\\uFD50\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1915\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.Ⴇ󀳑\x{062A}\x{062C}\x{0645}񫃱", %p)},	undef,	"to_ascii\(\'0\.Ⴇ\?\\u062A\\u062C\\u0645\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1916\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.ⴇ󀳑\x{062A}\x{062C}\x{0645}񫃱", %p)},	undef,	"to_ascii\(\'0\.ⴇ\?\\u062A\\u062C\\u0645\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1917\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟘．ⴇ󀳑\x{FD50}񫃱", %p)},	undef,	"to_ascii\(\'𝟘．ⴇ\?\\uFD50\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1918\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("𑇀▍.⁞ᠰ", %p)},	undef,	"to_ascii\(\'𑇀\▍\.\⁞ᠰ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1919\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}-\x{067A}.򏯩", %p)},	undef,	"to_ascii\(\'\\u200D\-\\u067A\.\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1920\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᠢ𐮂𐫘寐｡\x{200C}≯✳", %p)},	undef,	"to_ascii\(\'ᠢ𐮂𐫘寐｡\\u200C\≯\✳\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1922\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᠢ𐮂𐫘寐｡\x{200C}>\x{0338}✳", %p)},	undef,	"to_ascii\(\'ᠢ𐮂𐫘寐｡\\u200C\>\\u0338\✳\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1924\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᠢ𐮂𐫘寐。\x{200C}≯✳", %p)},	undef,	"to_ascii\(\'ᠢ𐮂𐫘寐\。\\u200C\≯\✳\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1926\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᠢ𐮂𐫘寐。\x{200C}>\x{0338}✳", %p)},	undef,	"to_ascii\(\'ᠢ𐮂𐫘寐\。\\u200C\>\\u0338\✳\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1928\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}｡󸲜ႺႴ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D｡\?ႺႴ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1930\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。󸲜ႺႴ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D\。\?ႺႴ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1932\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。󸲜ⴚⴔ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D\。\?ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1934\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。󸲜Ⴚⴔ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D\。\?Ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1936\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}｡󸲜ⴚⴔ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D｡\?ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1938\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}｡󸲜Ⴚⴔ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D｡\?Ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1940\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-3.\x{200D}ヌᢕ", %p)},	undef,	"to_ascii\(\'\-3\.\\u200Dヌᢕ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1942\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂃\x{0666}ß\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_ascii\(\'🂃\\u0666ß\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1944\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂃\x{0666}SS\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_ascii\(\'🂃\\u0666SS\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1946\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂃\x{0666}ss\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_ascii\(\'🂃\\u0666ss\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1948\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂃\x{0666}Ss\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_ascii\(\'🂃\\u0666Ss\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1950\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꇟ-𐾺\x{069F}。򰀺\x{200C}", %p)},	undef,	"to_ascii\(\'ꇟ\-\?\\u069F\。\?\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1952\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0665}.\x{0484}𐨗𝩋𴤃", %p)},	undef,	"to_ascii\(\'\\u0665\.\\u0484𐨗𝩋\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1954\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.񱼓\x{0649}𐨿", %p)},	undef,	"to_ascii\(\'\-\.\?\\u0649𐨿\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1955\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨ς.𞶙녫ß", %p)},	undef,	"to_ascii\(\'\?ς\.\?녫ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1956\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨ς.𞶙녫ß", %p)},	undef,	"to_ascii\(\'\?ς\.\?녫ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1957\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨Σ.𞶙녫SS", %p)},	undef,	"to_ascii\(\'\?Σ\.\?녫SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1958\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨Σ.𞶙녫SS", %p)},	undef,	"to_ascii\(\'\?Σ\.\?녫SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1959\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨σ.𞶙녫ss", %p)},	undef,	"to_ascii\(\'\?σ\.\?녫ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1960\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨σ.𞶙녫ss", %p)},	undef,	"to_ascii\(\'\?σ\.\?녫ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1961\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨Σ.𞶙녫Ss", %p)},	undef,	"to_ascii\(\'\?Σ\.\?녫Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1962\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨Σ.𞶙녫Ss", %p)},	undef,	"to_ascii\(\'\?Σ\.\?녫Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ\x{17D2}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⅎ\\u17D2\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1964\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ\x{17D2}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⅎ\\u17D2\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1966\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ\x{17D2}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⅎ\\u17D2\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1968\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ\x{17D2}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⅎ\\u17D2\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1970\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ\x{17D2}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'ⅎ\\u17D2\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1972\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ\x{17D2}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'ⅎ\\u17D2\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1974\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ\x{17D2}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'ⅎ\\u17D2\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1976\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ\x{17D2}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'ⅎ\\u17D2\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1978\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋺\x{AAF6}\x{A953}󧦉．\x{200C}\x{1714}\x{068F}", %p)},	undef,	"to_ascii\(\'𐋺\\uAAF6\\uA953\?．\\u200C\\u1714\\u068F\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1980\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋺\x{AAF6}\x{A953}󧦉.\x{200C}\x{1714}\x{068F}", %p)},	undef,	"to_ascii\(\'𐋺\\uAAF6\\uA953\?\.\\u200C\\u1714\\u068F\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1982\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񺔯\x{0FA8}．≯", %p)},	undef,	"to_ascii\(\'\?\\u0FA8．\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1984\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񺔯\x{0FA8}．>\x{0338}", %p)},	undef,	"to_ascii\(\'\?\\u0FA8．\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1985\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񺔯\x{0FA8}.≯", %p)},	undef,	"to_ascii\(\'\?\\u0FA8\.\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1986\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񺔯\x{0FA8}.>\x{0338}", %p)},	undef,	"to_ascii\(\'\?\\u0FA8\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1987\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𞡄Ⴓ．𐇽", %p)},	undef,	"to_ascii\(\'\\u200D𞡄Ⴓ．𐇽\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:1988\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𞡄Ⴓ.𐇽", %p)},	undef,	"to_ascii\(\'\\u200D𞡄Ⴓ\.𐇽\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:1990\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}𞡄ⴓ.𐇽", %p)},	undef,	"to_ascii\(\'\\u200D𞡄ⴓ\.𐇽\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:1992\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}𞡄ⴓ．𐇽", %p)},	undef,	"to_ascii\(\'\\u200D𞡄ⴓ．𐇽\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:1994\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒ß\x{A8EA}．ᡤ", %p)},	undef,	"to_ascii\(\'𐪒ß\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1996\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒ß\x{A8EA}.ᡤ", %p)},	undef,	"to_ascii\(\'𐪒ß\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1997\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒SS\x{A8EA}.ᡤ", %p)},	undef,	"to_ascii\(\'𐪒SS\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1998\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒ss\x{A8EA}.ᡤ", %p)},	undef,	"to_ascii\(\'𐪒ss\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1999\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒Ss\x{A8EA}.ᡤ", %p)},	undef,	"to_ascii\(\'𐪒Ss\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2000\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒SS\x{A8EA}．ᡤ", %p)},	undef,	"to_ascii\(\'𐪒SS\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2001\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒ss\x{A8EA}．ᡤ", %p)},	undef,	"to_ascii\(\'𐪒ss\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2002\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒Ss\x{A8EA}．ᡤ", %p)},	undef,	"to_ascii\(\'𐪒Ss\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2003\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("𐨿󠆌鸮𑚶.ς", %p)},	undef,	"to_ascii\(\'𐨿\󠆌鸮𑚶\.ς\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2004\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("𐨿󠆌鸮𑚶.Σ", %p)},	undef,	"to_ascii\(\'𐨿\󠆌鸮𑚶\.Σ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2005\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("𐨿󠆌鸮𑚶.σ", %p)},	undef,	"to_ascii\(\'𐨿\󠆌鸮𑚶\.σ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2006\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⒗𞤬。-𑚶", %p)},	undef,	"to_ascii\(\'⒗\?\。\-𑚶\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2007\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("16.𞤬。-𑚶", %p)},	undef,	"to_ascii\(\'16\.\?\。\-𑚶\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2008\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{08B3}𞤿⾫｡𐹣\x{068F}⒈", %p)},	undef,	"to_ascii\(\'\\u08B3\?⾫｡𐹣\\u068F⒈\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2009\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{08B3}𞤿隹。𐹣\x{068F}1.", %p)},	undef,	"to_ascii\(\'\\u08B3\?隹\。𐹣\\u068F1\.\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2010\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{2433}𚎛𝟧\x{0661}.ᡢ8\x{0F72}\x{0600}", %p)},	undef,	"to_ascii\(\'\\u2433\?𝟧\\u0661\.ᡢ8\\u0F72\\u0600\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2011\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2433}𚎛5\x{0661}.ᡢ8\x{0F72}\x{0600}", %p)},	undef,	"to_ascii\(\'\\u2433\?5\\u0661\.ᡢ8\\u0F72\\u0600\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2012\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹠.🄀⒒-󨰈", %p)},	undef,	"to_ascii\(\'𐹠\.🄀⒒\-\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2013\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹠.0.11.-󨰈", %p)},	undef,	"to_ascii\(\'𐹠\.0\.11\.\-\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2014\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς-。\x{200C}𝟭-", %p)},	undef,	"to_ascii\(\'ς\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2015\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς-。\x{200C}1-", %p)},	undef,	"to_ascii\(\'ς\-\。\\u200C1\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2017\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ-。\x{200C}1-", %p)},	undef,	"to_ascii\(\'Σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2019\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ-。\x{200C}1-", %p)},	undef,	"to_ascii\(\'σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2021\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ-。\x{200C}𝟭-", %p)},	undef,	"to_ascii\(\'Σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2023\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ-。\x{200C}𝟭-", %p)},	undef,	"to_ascii\(\'σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2025\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1734}-\x{0CE2}．󠄩Ⴄ", %p)},	undef,	"to_ascii\(\'\\u1734\-\\u0CE2．\󠄩Ⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2027\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1734}-\x{0CE2}.󠄩Ⴄ", %p)},	undef,	"to_ascii\(\'\\u1734\-\\u0CE2\.\󠄩Ⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2028\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{1734}-\x{0CE2}.󠄩ⴄ", %p)},	undef,	"to_ascii\(\'\\u1734\-\\u0CE2\.\󠄩ⴄ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2029\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{1734}-\x{0CE2}．󠄩ⴄ", %p)},	undef,	"to_ascii\(\'\\u1734\-\\u0CE2．\󠄩ⴄ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2030\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򭈗♋\x{06BB}𐦥｡\x{0954}⒈", %p)},	undef,	"to_ascii\(\'\?\♋\\u06BB𐦥｡\\u0954⒈\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2031\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򭈗♋\x{06BB}𐦥。\x{0954}1.", %p)},	undef,	"to_ascii\(\'\?\♋\\u06BB𐦥\。\\u09541\.\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2032\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{05A4}．\x{06C1}\x{1AB3}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u05A4．\\u06C1\\u1AB3\\u200C\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2033\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{05A4}.\x{06C1}\x{1AB3}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u05A4\.\\u06C1\\u1AB3\\u200C\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2035\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񢭏\x{0846}≮\x{0ACD}．𞦊", %p)},	undef,	"to_ascii\(\'\?\\u0846\≮\\u0ACD．\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2037\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񢭏\x{0846}<\x{0338}\x{0ACD}．𞦊", %p)},	undef,	"to_ascii\(\'\?\\u0846\<\\u0338\\u0ACD．\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2038\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񢭏\x{0846}≮\x{0ACD}.𞦊", %p)},	undef,	"to_ascii\(\'\?\\u0846\≮\\u0ACD\.\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2039\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񢭏\x{0846}<\x{0338}\x{0ACD}.𞦊", %p)},	undef,	"to_ascii\(\'\?\\u0846\<\\u0338\\u0ACD\.\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2040\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。𞀘⒈ꡍ擉", %p)},	undef,	"to_ascii\(\'\\u200D\。\?⒈ꡍ擉\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2041\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200D}。𞀘1.ꡍ擉", %p)},	undef,	"to_ascii\(\'\\u200D\。\?1\.ꡍ擉\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2043\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("₈\x{07CB}．\x{FB64}≠", %p)},	undef,	"to_ascii\(\'₈\\u07CB．\\uFB64\≠\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2045\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("₈\x{07CB}．\x{FB64}=\x{0338}", %p)},	undef,	"to_ascii\(\'₈\\u07CB．\\uFB64\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2046\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8\x{07CB}.\x{067F}≠", %p)},	undef,	"to_ascii\(\'8\\u07CB\.\\u067F\≠\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2047\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8\x{07CB}.\x{067F}=\x{0338}", %p)},	undef,	"to_ascii\(\'8\\u07CB\.\\u067F\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2048\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢡ\x{07DE}򹐣.⒒\x{0642}𑍦", %p)},	undef,	"to_ascii\(\'ᢡ\\u07DE\?\.⒒\\u0642𑍦\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:2049\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢡ\x{07DE}򹐣.11.\x{0642}𑍦", %p)},	undef,	"to_ascii\(\'ᢡ\\u07DE\?\.11\.\\u0642𑍦\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2050\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0E48}-𐹺𝟜.\x{0363}\x{06E1}⒏", %p)},	undef,	"to_ascii\(\'\\u0E48\-𐹺𝟜\.\\u0363\\u06E1⒏\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2051\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0E48}-𐹺4.\x{0363}\x{06E1}8.", %p)},	undef,	"to_ascii\(\'\\u0E48\-𐹺4\.\\u0363\\u06E18\.\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2052\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⫐｡Ⴠ-󃐢", %p)},	undef,	"to_ascii\(\'\⫐｡Ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2053\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⫐。Ⴠ-󃐢", %p)},	undef,	"to_ascii\(\'\⫐\。Ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2054\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⫐。ⴠ-󃐢", %p)},	undef,	"to_ascii\(\'\⫐\。ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2055\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⫐｡ⴠ-󃐢", %p)},	undef,	"to_ascii\(\'\⫐｡ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2056\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑑂◊．⦟∠", %p)},	undef,	"to_ascii\(\'\?\◊．\⦟\∠\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2057\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑑂◊.⦟∠", %p)},	undef,	"to_ascii\(\'\?\◊\.\⦟\∠\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2058\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𿌰-\x{0662}。󋸛ꡂ", %p)},	undef,	"to_ascii\(\'\?\-\\u0662\。\?ꡂ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2059\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0678}。󠏬\x{0741}𞪭𐹪", %p)},	undef,	"to_ascii\(\'\\u0678\。\?\\u0741\?𐹪\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2060\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{064A}\x{0674}。󠏬\x{0741}𞪭𐹪", %p)},	undef,	"to_ascii\(\'\\u064A\\u0674\。\?\\u0741\?𐹪\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2061\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫆ꌄ｡\x{200D}ᣬ", %p)},	undef,	"to_ascii\(\'𐫆ꌄ｡\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2062\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫆ꌄ。\x{200D}ᣬ", %p)},	undef,	"to_ascii\(\'𐫆ꌄ\。\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2064\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("₀\x{0662}。󅪞≯-", %p)},	undef,	"to_ascii\(\'₀\\u0662\。\?\≯\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2066\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("₀\x{0662}。󅪞>\x{0338}-", %p)},	undef,	"to_ascii\(\'₀\\u0662\。\?\>\\u0338\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2067\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0\x{0662}。󅪞≯-", %p)},	undef,	"to_ascii\(\'0\\u0662\。\?\≯\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2068\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0\x{0662}。󅪞>\x{0338}-", %p)},	undef,	"to_ascii\(\'0\\u0662\。\?\>\\u0338\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2069\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{031C}𐹫-𞯃.𐋤\x{0845}", %p)},	undef,	"to_ascii\(\'\\u031C𐹫\-\?\.𐋤\\u0845\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2070\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠｡𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\≠｡𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2071\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}｡𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\=\\u0338｡𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2072\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠。𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\≠\。𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2073\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}。𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\=\\u0338\。𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2074\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}。𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\=\\u0338\。𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2075\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠。𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\≠\。𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2076\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}｡𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\=\\u0338｡𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2077\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠｡𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\≠｡𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2078\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖫳≠.Ⴀ𐮀", %p)},	undef,	"to_ascii\(\'𖫳\≠\.Ⴀ𐮀\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2079\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖫳=\x{0338}.Ⴀ𐮀", %p)},	undef,	"to_ascii\(\'𖫳\=\\u0338\.Ⴀ𐮀\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2080\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖫳=\x{0338}.ⴀ𐮀", %p)},	undef,	"to_ascii\(\'𖫳\=\\u0338\.ⴀ𐮀\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2081\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖫳≠.ⴀ𐮀", %p)},	undef,	"to_ascii\(\'𖫳\≠\.ⴀ𐮀\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2082\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅾\x{0736}\x{0726}．ᢚ閪\x{08E2}𝩟", %p)},	undef,	"to_ascii\(\'\󠅾\\u0736\\u0726．ᢚ閪\\u08E2𝩟\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2083\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅾\x{0736}\x{0726}.ᢚ閪\x{08E2}𝩟", %p)},	undef,	"to_ascii\(\'\󠅾\\u0736\\u0726\.ᢚ閪\\u08E2𝩟\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2084\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}󠇜\x{06CB}\x{A8E9}｡\x{20DD}\x{0FB0}-ᛟ", %p)},	undef,	"to_ascii\(\'\\u200D\󠇜\\u06CB\\uA8E9｡\\u20DD\\u0FB0\-ᛟ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2085\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}󠇜\x{06CB}\x{A8E9}。\x{20DD}\x{0FB0}-ᛟ", %p)},	undef,	"to_ascii\(\'\\u200D\󠇜\\u06CB\\uA8E9\。\\u20DD\\u0FB0\-ᛟ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2087\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("헁󘖙\x{0E3A}󚍚。\x{06BA}𝟜", %p)},	undef,	"to_ascii\(\'헁\?\\u0E3A\?\。\\u06BA𝟜\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2089\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("헁󘖙\x{0E3A}󚍚。\x{06BA}𝟜", %p)},	undef,	"to_ascii\(\'헁\?\\u0E3A\?\。\\u06BA𝟜\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2090\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("헁󘖙\x{0E3A}󚍚。\x{06BA}4", %p)},	undef,	"to_ascii\(\'헁\?\\u0E3A\?\。\\u06BA4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2091\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("헁󘖙\x{0E3A}󚍚。\x{06BA}4", %p)},	undef,	"to_ascii\(\'헁\?\\u0E3A\?\。\\u06BA4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2092\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹭｡󃱂\x{200C}Ⴞ", %p)},	undef,	"to_ascii\(\'𐹭｡\?\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2093\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹭。󃱂\x{200C}Ⴞ", %p)},	undef,	"to_ascii\(\'𐹭\。\?\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2095\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹭。󃱂\x{200C}ⴞ", %p)},	undef,	"to_ascii\(\'𐹭\。\?\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2097\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹭｡󃱂\x{200C}ⴞ", %p)},	undef,	"to_ascii\(\'𐹭｡\?\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2099\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A953}.\x{033D}𑂽馋", %p)},	undef,	"to_ascii\(\'\\uA953\.\\u033D\?馋\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2101\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󈫝򪛸\x{200D}｡䜖", %p)},	undef,	"to_ascii\(\'\?\?\\u200D｡䜖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2102\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󈫝򪛸\x{200D}。䜖", %p)},	undef,	"to_ascii\(\'\?\?\\u200D\。䜖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2104\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡯ⚉姶🄉．۷\x{200D}🎪\x{200D}", %p)},	undef,	"to_ascii\(\'ᡯ\⚉姶🄉．۷\\u200D🎪\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2106\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡯ⚉姶8,.۷\x{200D}🎪\x{200D}", %p)},	undef,	"to_ascii\(\'ᡯ\⚉姶8\,\.۷\\u200D🎪\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2108\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞽀.𐹸🚖\x{0E3A}", %p)},	undef,	"to_ascii\(\'\?\.𐹸🚖\\u0E3A\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2110\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔᠵ｡𐹧\x{0747}۹", %p)},	undef,	"to_ascii\(\'Ⴔᠵ｡𐹧\\u0747۹\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2111\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔᠵ。𐹧\x{0747}۹", %p)},	undef,	"to_ascii\(\'Ⴔᠵ\。𐹧\\u0747۹\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2112\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ⴔᠵ。𐹧\x{0747}۹", %p)},	undef,	"to_ascii\(\'ⴔᠵ\。𐹧\\u0747۹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2113\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ⴔᠵ｡𐹧\x{0747}۹", %p)},	undef,	"to_ascii\(\'ⴔᠵ｡𐹧\\u0747۹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2114\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{135F}ᡈ\x{200C}．︒-𖾐-", %p)},	undef,	"to_ascii\(\'\\u135Fᡈ\\u200C．︒\-𖾐\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:2115\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{135F}ᡈ\x{200C}.。-𖾐-", %p)},	undef,	"to_ascii\(\'\\u135Fᡈ\\u200C\.\。\-𖾐\-\'\)\ throws\ error\ V5\ V3\ A4_2\ \[data\/IdnaTest\.txt\:2117\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⒈\x{0601}⒖\x{200C}.\x{1DF0}\x{07DB}", %p)},	undef,	"to_ascii\(\'⒈\\u0601⒖\\u200C\.\\u1DF0\\u07DB\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2119\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.\x{0601}15.\x{200C}.\x{1DF0}\x{07DB}", %p)},	undef,	"to_ascii\(\'1\.\\u060115\.\\u200C\.\\u1DF0\\u07DB\'\)\ throws\ error\ P1\ V6\ V5\ B1\ A4_2\ \[data\/IdnaTest\.txt\:2121\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝩜。-\x{0B4D}Ⴋ", %p)},	undef,	"to_ascii\(\'𝩜\。\-\\u0B4DႫ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:2123\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝩜。-\x{0B4D}ⴋ", %p)},	undef,	"to_ascii\(\'𝩜\。\-\\u0B4Dⴋ\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:2124\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ßჀ.\x{0620}刯Ⴝ", %p)},	undef,	"to_ascii\(\'ßჀ\.\\u0620刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2125\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("ßⴠ.\x{0620}刯ⴝ", %p)},	undef,	"to_ascii\(\'ßⴠ\.\\u0620刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2126\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SSჀ.\x{0620}刯Ⴝ", %p)},	undef,	"to_ascii\(\'SSჀ\.\\u0620刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2127\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("ssⴠ.\x{0620}刯ⴝ", %p)},	undef,	"to_ascii\(\'ssⴠ\.\\u0620刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2128\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ssⴠ.\x{0620}刯Ⴝ", %p)},	undef,	"to_ascii\(\'Ssⴠ\.\\u0620刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2129\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}ႣℲ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣℲ｡ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2130\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}ႣℲ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣℲ｡ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2131\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}ႣℲ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣℲ\。ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2132\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}ႣℲ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣℲ\。ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2133\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{1BAA}ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAⴃⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2134\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{1BAA}ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAⴃⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2135\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{1BAA}Ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2136\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}Ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2137\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{1BAA}ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAⴃⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2138\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{1BAA}ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAⴃⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2139\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{1BAA}Ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2140\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}Ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2141\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{06EC}.\x{08A2}𐹫\x{067C}", %p)},	undef,	"to_ascii\(\'\\u06EC\.\\u08A2𐹫\\u067C\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2142\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{06B6}\x{06DF}。₇\x{A806}", %p)},	"xn--pkb6f.xn--7-x93e",	"to_ascii\(\'\\u06B6\\u06DF\。₇\\uA806\'\)\ \[data\/IdnaTest\.txt\:2143\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{06B6}\x{06DF}。7\x{A806}", %p)},	"xn--pkb6f.xn--7-x93e",	"to_ascii\(\'\\u06B6\\u06DF\。7\\uA806\'\)\ \[data\/IdnaTest\.txt\:2144\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--pkb6f.xn--7-x93e", %p)},	"xn--pkb6f.xn--7-x93e",	"to_ascii\(\'xn\-\-pkb6f\.xn\-\-7\-x93e\'\)\ \[data\/IdnaTest\.txt\:2145\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{06B6}\x{06DF}.7\x{A806}", %p)},	"xn--pkb6f.xn--7-x93e",	"to_ascii\(\'\\u06B6\\u06DF\.7\\uA806\'\)\ \[data\/IdnaTest\.txt\:2146\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴣ𐹻.\x{200C}𝪣≮󠩉", %p)},	undef,	"to_ascii\(\'Ⴣ𐹻\.\\u200C𝪣\≮\?\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2147\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴣ𐹻.\x{200C}𝪣<\x{0338}󠩉", %p)},	undef,	"to_ascii\(\'Ⴣ𐹻\.\\u200C𝪣\<\\u0338\?\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2149\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴣ𐹻.\x{200C}𝪣<\x{0338}󠩉", %p)},	undef,	"to_ascii\(\'ⴣ𐹻\.\\u200C𝪣\<\\u0338\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2151\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴣ𐹻.\x{200C}𝪣≮󠩉", %p)},	undef,	"to_ascii\(\'ⴣ𐹻\.\\u200C𝪣\≮\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2153\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝟵隁⯮．\x{180D}\x{200C}", %p)},	"xn--9-mfs8024b.",	"to_ascii\(\'𝟵隁\⯮．\\u180D\\u200C\'\)\ \[data\/IdnaTest\.txt\:2155\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("9隁⯮.\x{180D}\x{200C}", %p)},	"xn--9-mfs8024b.",	"to_ascii\(\'9隁\⯮\.\\u180D\\u200C\'\)\ \[data\/IdnaTest\.txt\:2157\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("xn--9-mfs8024b.", %p)},	"xn--9-mfs8024b.",	"to_ascii\(\'xn\-\-9\-mfs8024b\.\'\)\ \[data\/IdnaTest\.txt\:2159\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("9隁⯮.", %p)},	"xn--9-mfs8024b.",	"to_ascii\(\'9隁\⯮\.\'\)\ \[data\/IdnaTest\.txt\:2160\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⒏𐹧｡Ⴣ\x{0F84}彦", %p)},	undef,	"to_ascii\(\'⒏𐹧｡Ⴣ\\u0F84彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8.𐹧。Ⴣ\x{0F84}彦", %p)},	undef,	"to_ascii\(\'8\.𐹧\。Ⴣ\\u0F84彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2162\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("8.𐹧。ⴣ\x{0F84}彦", %p)},	undef,	"to_ascii\(\'8\.𐹧\。ⴣ\\u0F84彦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2163\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⒏𐹧｡ⴣ\x{0F84}彦", %p)},	undef,	"to_ascii\(\'⒏𐹧｡ⴣ\\u0F84彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2164\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-问񬰔⒛。\x{0604}-񜗉橬", %p)},	undef,	"to_ascii\(\'\-问\?⒛\。\\u0604\-\?橬\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2165\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-问񬰔20.。\x{0604}-񜗉橬", %p)},	undef,	"to_ascii\(\'\-问\?20\.\。\\u0604\-\?橬\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:2166\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAC}Ⴌ\x{200C}\x{0325}。𝟸", %p)},	undef,	"to_ascii\(\'\\u1BACႬ\\u200C\\u0325\。𝟸\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2167\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAC}Ⴌ\x{200C}\x{0325}。2", %p)},	undef,	"to_ascii\(\'\\u1BACႬ\\u200C\\u0325\。2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2169\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{1BAC}ⴌ\x{200C}\x{0325}。2", %p)},	undef,	"to_ascii\(\'\\u1BACⴌ\\u200C\\u0325\。2\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2171\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{1BAC}ⴌ\x{200C}\x{0325}。𝟸", %p)},	undef,	"to_ascii\(\'\\u1BACⴌ\\u200C\\u0325\。𝟸\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2173\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{DC5F}。\x{A806}\x{0669}󠒩", %p)},	undef,	"to_ascii\(\'\\uDC5F\。\\uA806\\u0669\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ A3\ \[data\/IdnaTest\.txt\:2175\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄁\x{035F}⾶｡₇︒눇≮", %p)},	undef,	"to_ascii\(\'\󠄁\\u035F⾶｡₇︒눇\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2176\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄁\x{035F}⾶｡₇︒눇<\x{0338}", %p)},	undef,	"to_ascii\(\'\󠄁\\u035F⾶｡₇︒눇\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2177\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄁\x{035F}飛。7。눇≮", %p)},	undef,	"to_ascii\(\'\󠄁\\u035F飛\。7\。눇\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2178\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄁\x{035F}飛。7。눇<\x{0338}", %p)},	undef,	"to_ascii\(\'\󠄁\\u035F飛\。7\。눇\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2179\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}\x{FE09}𐹴\x{200D}．\x{200C}⿃", %p)},	undef,	"to_ascii\(\'\\u200C\\uFE09𐹴\\u200D．\\u200C⿃\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2180\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}\x{FE09}𐹴\x{200D}.\x{200C}鳥", %p)},	undef,	"to_ascii\(\'\\u200C\\uFE09𐹴\\u200D\.\\u200C鳥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2182\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("🍮．\x{200D}󠗒𐦁𝨝", %p)},	undef,	"to_ascii\(\'🍮．\\u200D\?𐦁𝨝\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2184\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🍮.\x{200D}󠗒𐦁𝨝", %p)},	undef,	"to_ascii\(\'🍮\.\\u200D\?𐦁𝨝\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2186\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}\x{0943}.𞤓\x{200D}", %p)},	"xn--2ib43l.xn--te6h",	"to_ascii\(\'\\u067D\\u0943\.\?\\u200D\'\)\ \[data\/IdnaTest\.txt\:2188\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--2ib43l.xn--te6h", %p)},	"xn--2ib43l.xn--te6h",	"to_ascii\(\'xn\-\-2ib43l\.xn\-\-te6h\'\)\ \[data\/IdnaTest\.txt\:2190\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}\x{0943}.𞤵", %p)},	"xn--2ib43l.xn--te6h",	"to_ascii\(\'\\u067D\\u0943\.\?\'\)\ \[data\/IdnaTest\.txt\:2191\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0664}\x{0A4D}-．󥜽\x{1039}񦦐", %p)},	undef,	"to_ascii\(\'\\u0664\\u0A4D\-．\?\\u1039\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2192\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}\x{0A4D}-.󥜽\x{1039}񦦐", %p)},	undef,	"to_ascii\(\'\\u0664\\u0A4D\-\.\?\\u1039\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2193\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{103A}-𐹸｡\x{AA29}\x{200C}𐹴≮", %p)},	undef,	"to_ascii\(\'4\\u103A\-𐹸｡\\uAA29\\u200C𐹴\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2194\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{103A}-𐹸｡\x{AA29}\x{200C}𐹴<\x{0338}", %p)},	undef,	"to_ascii\(\'4\\u103A\-𐹸｡\\uAA29\\u200C𐹴\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2196\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{103A}-𐹸。\x{AA29}\x{200C}𐹴≮", %p)},	undef,	"to_ascii\(\'4\\u103A\-𐹸\。\\uAA29\\u200C𐹴\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2198\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{103A}-𐹸。\x{AA29}\x{200C}𐹴<\x{0338}", %p)},	undef,	"to_ascii\(\'4\\u103A\-𐹸\。\\uAA29\\u200C𐹴\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2200\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。\x{FFA0}\x{0F84}\x{0F96}", %p)},	undef,	"to_ascii\(\'\\u200C\。\\uFFA0\\u0F84\\u0F96\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2202\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。\x{1160}\x{0F84}\x{0F96}", %p)},	undef,	"to_ascii\(\'\\u200C\。\\u1160\\u0F84\\u0F96\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2204\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯򍘅．\x{200D}𐅼򲇛", %p)},	undef,	"to_ascii\(\'\≯\?．\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2206\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}򍘅．\x{200D}𐅼򲇛", %p)},	undef,	"to_ascii\(\'\>\\u0338\?．\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2208\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯򍘅.\x{200D}𐅼򲇛", %p)},	undef,	"to_ascii\(\'\≯\?\.\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2210\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}򍘅.\x{200D}𐅼򲇛", %p)},	undef,	"to_ascii\(\'\>\\u0338\?\.\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2212\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}ß𐰯｡𝟕𐫫", %p)},	undef,	"to_ascii\(\'\\u0641ß𐰯｡𝟕𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2214\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}ß𐰯。7𐫫", %p)},	undef,	"to_ascii\(\'\\u0641ß𐰯\。7𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2215\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}SS𐰯。7𐫫", %p)},	undef,	"to_ascii\(\'\\u0641SS𐰯\。7𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2216\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}ss𐰯。7𐫫", %p)},	undef,	"to_ascii\(\'\\u0641ss𐰯\。7𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2217\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}Ss𐰯。7𐫫", %p)},	undef,	"to_ascii\(\'\\u0641Ss𐰯\。7𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2218\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}SS𐰯｡𝟕𐫫", %p)},	undef,	"to_ascii\(\'\\u0641SS𐰯｡𝟕𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2219\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}ss𐰯｡𝟕𐫫", %p)},	undef,	"to_ascii\(\'\\u0641ss𐰯｡𝟕𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2220\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}Ss𐰯｡𝟕𐫫", %p)},	undef,	"to_ascii\(\'\\u0641Ss𐰯｡𝟕𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2221\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ß\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_ascii\(\'ß\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2222\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_ascii\(\'SS\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2223\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_ascii\(\'ss\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2224\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_ascii\(\'Ss\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2225\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-｡󠉗⒌𞯛", %p)},	undef,	"to_ascii\(\'\-｡\?⒌\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2226\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。󠉗5.𞯛", %p)},	undef,	"to_ascii\(\'\-\。\?5\.\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2227\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏ς．-≮\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?ς．\-\≮\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2228\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏ς．-<\x{0338}\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?ς．\-\<\\u0338\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2229\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏ς.-≮\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?ς\.\-\≮\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2230\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏ς.-<\x{0338}\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?ς\.\-\<\\u0338\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2231\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏Σ.-<\x{0338}\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?Σ\.\-\<\\u0338\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2232\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏Σ.-≮\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?Σ\.\-\≮\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2233\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏σ.-≮\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?σ\.\-\≮\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2234\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏σ.-<\x{0338}\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?σ\.\-\<\\u0338\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2235\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏Σ．-<\x{0338}\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?Σ．\-\<\\u0338\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2236\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏Σ．-≮\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?Σ．\-\≮\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2237\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏σ．-≮\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?σ．\-\≮\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2238\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏σ．-<\x{0338}\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?σ．\-\<\\u0338\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2239\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡗ\x{08B8}\x{0719}．񔤔󠛙\x{0C4D}\x{FC3E}", %p)},	undef,	"to_ascii\(\'ꡗ\\u08B8\\u0719．\?\?\\u0C4D\\uFC3E\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2240\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡗ\x{08B8}\x{0719}.񔤔󠛙\x{0C4D}\x{0643}\x{064A}", %p)},	undef,	"to_ascii\(\'ꡗ\\u08B8\\u0719\.\?\?\\u0C4D\\u0643\\u064A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2241\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐠰\x{08B7}𞤌𐫭。𐋦\x{17CD}𝩃", %p)},	"xn--dzb5191kezbrw47a.xn--p4e3841jz9tf",	"to_ascii\(\'𐠰\\u08B7\?𐫭\。𐋦\\u17CD𝩃\'\)\ \[data\/IdnaTest\.txt\:2242\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--dzb5191kezbrw47a.xn--p4e3841jz9tf", %p)},	"xn--dzb5191kezbrw47a.xn--p4e3841jz9tf",	"to_ascii\(\'xn\-\-dzb5191kezbrw47a\.xn\-\-p4e3841jz9tf\'\)\ \[data\/IdnaTest\.txt\:2243\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐠰\x{08B7}𞤮𐫭.𐋦\x{17CD}𝩃", %p)},	"xn--dzb5191kezbrw47a.xn--p4e3841jz9tf",	"to_ascii\(\'𐠰\\u08B7\?𐫭\.𐋦\\u17CD𝩃\'\)\ \[data\/IdnaTest\.txt\:2244\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("₂㘷--。\x{06D3}\x{200C}𐫆𑖿", %p)},	undef,	"to_ascii\(\'₂㘷\-\-\。\\u06D3\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2245\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("₂㘷--。\x{06D2}\x{0654}\x{200C}𐫆𑖿", %p)},	undef,	"to_ascii\(\'₂㘷\-\-\。\\u06D2\\u0654\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2247\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("2㘷--。\x{06D3}\x{200C}𐫆𑖿", %p)},	undef,	"to_ascii\(\'2㘷\-\-\。\\u06D3\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2249\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("2㘷--。\x{06D2}\x{0654}\x{200C}𐫆𑖿", %p)},	undef,	"to_ascii\(\'2㘷\-\-\。\\u06D2\\u0654\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2251\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("-𘊻．ᡮ\x{062D}-", %p)},	undef,	"to_ascii\(\'\-\?．ᡮ\\u062D\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2253\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("-𘊻.ᡮ\x{062D}-", %p)},	undef,	"to_ascii\(\'\-\?\.ᡮ\\u062D\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2254\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-ß｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-ß｡ᢣ𐹭\\u063F\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2255\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-ß。ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-ß\。ᢣ𐹭\\u063F\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2257\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-SS。ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-SS\。ᢣ𐹭\\u063F\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2259\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-ss。ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-ss\。ᢣ𐹭\\u063F\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2261\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-Ss。ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-Ss\。ᢣ𐹭\\u063F\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2263\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-SS｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-SS｡ᢣ𐹭\\u063F\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2265\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-ss｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-ss｡ᢣ𐹭\\u063F\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2267\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-Ss｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-Ss｡ᢣ𐹭\\u063F\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2269\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("꧐Ӏ\x{1BAA}\x{08F6}．눵", %p)},	undef,	"to_ascii\(\'꧐Ӏ\\u1BAA\\u08F6．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2271\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("꧐Ӏ\x{1BAA}\x{08F6}．눵", %p)},	undef,	"to_ascii\(\'꧐Ӏ\\u1BAA\\u08F6．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2272\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("꧐Ӏ\x{1BAA}\x{08F6}.눵", %p)},	undef,	"to_ascii\(\'꧐Ӏ\\u1BAA\\u08F6\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2273\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("꧐Ӏ\x{1BAA}\x{08F6}.눵", %p)},	undef,	"to_ascii\(\'꧐Ӏ\\u1BAA\\u08F6\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2274\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("꧐ӏ\x{1BAA}\x{08F6}.눵", %p)},	"xn--s5a04sn4u297k.xn--2e1b",	"to_ascii\(\'꧐ӏ\\u1BAA\\u08F6\.눵\'\)\ \[data\/IdnaTest\.txt\:2275\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("꧐ӏ\x{1BAA}\x{08F6}.눵", %p)},	"xn--s5a04sn4u297k.xn--2e1b",	"to_ascii\(\'꧐ӏ\\u1BAA\\u08F6\.눵\'\)\ \[data\/IdnaTest\.txt\:2276\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("xn--s5a04sn4u297k.xn--2e1b", %p)},	"xn--s5a04sn4u297k.xn--2e1b",	"to_ascii\(\'xn\-\-s5a04sn4u297k\.xn\-\-2e1b\'\)\ \[data\/IdnaTest\.txt\:2277\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("꧐ӏ\x{1BAA}\x{08F6}．눵", %p)},	"xn--s5a04sn4u297k.xn--2e1b",	"to_ascii\(\'꧐ӏ\\u1BAA\\u08F6．눵\'\)\ \[data\/IdnaTest\.txt\:2278\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("꧐ӏ\x{1BAA}\x{08F6}．눵", %p)},	"xn--s5a04sn4u297k.xn--2e1b",	"to_ascii\(\'꧐ӏ\\u1BAA\\u08F6．눵\'\)\ \[data\/IdnaTest\.txt\:2279\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{A8EA}｡𖄿𑆾󠇗", %p)},	undef,	"to_ascii\(\'\\uA8EA｡\?𑆾\󠇗\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2280\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A8EA}。𖄿𑆾󠇗", %p)},	undef,	"to_ascii\(\'\\uA8EA\。\?𑆾\󠇗\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2281\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󇓓𑚳。񐷿≯⾇", %p)},	undef,	"to_ascii\(\'\?𑚳\。\?\≯⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2282\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󇓓𑚳。񐷿>\x{0338}⾇", %p)},	undef,	"to_ascii\(\'\?𑚳\。\?\>\\u0338⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2283\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󇓓𑚳。񐷿≯舛", %p)},	undef,	"to_ascii\(\'\?𑚳\。\?\≯舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2284\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󇓓𑚳。񐷿>\x{0338}舛", %p)},	undef,	"to_ascii\(\'\?𑚳\。\?\>\\u0338舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2285\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫇\x{0661}\x{200C}．\x{200D}\x{200C}", %p)},	"xn--9hb7344k.",	"to_ascii\(\'𐫇\\u0661\\u200C．\\u200D\\u200C\'\)\ \[data\/IdnaTest\.txt\:2286\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫇\x{0661}\x{200C}.\x{200D}\x{200C}", %p)},	"xn--9hb7344k.",	"to_ascii\(\'𐫇\\u0661\\u200C\.\\u200D\\u200C\'\)\ \[data\/IdnaTest\.txt\:2288\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--9hb7344k.", %p)},	"xn--9hb7344k.",	"to_ascii\(\'xn\-\-9hb7344k\.\'\)\ \[data\/IdnaTest\.txt\:2290\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫇\x{0661}.", %p)},	"xn--9hb7344k.",	"to_ascii\(\'𐫇\\u0661\.\'\)\ \[data\/IdnaTest\.txt\:2291\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񡅈砪≯ᢑ｡≯𝩚򓴔\x{200C}", %p)},	undef,	"to_ascii\(\'\?砪\≯ᢑ｡\≯𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2292\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񡅈砪>\x{0338}ᢑ｡>\x{0338}𝩚򓴔\x{200C}", %p)},	undef,	"to_ascii\(\'\?砪\>\\u0338ᢑ｡\>\\u0338𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2294\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񡅈砪≯ᢑ。≯𝩚򓴔\x{200C}", %p)},	undef,	"to_ascii\(\'\?砪\≯ᢑ\。\≯𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2296\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񡅈砪>\x{0338}ᢑ。>\x{0338}𝩚򓴔\x{200C}", %p)},	undef,	"to_ascii\(\'\?砪\>\\u0338ᢑ\。\>\\u0338𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2298\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴥ.𑄳㊸", %p)},	undef,	"to_ascii\(\'Ⴥ\.𑄳㊸\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2300\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴥ.𑄳43", %p)},	undef,	"to_ascii\(\'Ⴥ\.𑄳43\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2301\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ⴥ.𑄳43", %p)},	undef,	"to_ascii\(\'ⴥ\.𑄳43\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2302\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ⴥ.𑄳㊸", %p)},	undef,	"to_ascii\(\'ⴥ\.𑄳㊸\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2303\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𝟎\x{0663}。Ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_ascii\(\'𝟎\\u0663\。Ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2304\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0\x{0663}。Ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_ascii\(\'0\\u0663\。Ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2305\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("0\x{0663}。ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_ascii\(\'0\\u0663\。ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2306\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("𝟎\x{0663}。ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_ascii\(\'𝟎\\u0663\。ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2307\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񗪨󠄉\x{FFA0}\x{0FB7}.񸞰\x{A953}", %p)},	undef,	"to_ascii\(\'\?\󠄉\\uFFA0\\u0FB7\.\?\\uA953\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2308\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗪨󠄉\x{1160}\x{0FB7}.񸞰\x{A953}", %p)},	undef,	"to_ascii\(\'\?\󠄉\\u1160\\u0FB7\.\?\\uA953\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2309\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{0618}.۳\x{200C}\x{A953}", %p)},	undef,	"to_ascii\(\'\\u0618\.۳\\u200C\\uA953\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2310\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ᡌ．︒ᢑ", %p)},	undef,	"to_ascii\(\'ᡌ．︒ᢑ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2312\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡌ.。ᢑ", %p)},	undef,	"to_ascii\(\'ᡌ\.\。ᢑ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:2313\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑋪\x{1073}｡𞽧", %p)},	undef,	"to_ascii\(\'𑋪\\u1073｡\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2314\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑋪\x{1073}。𞽧", %p)},	undef,	"to_ascii\(\'𑋪\\u1073\。\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2315\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞷏。ᠢ򓘆", %p)},	undef,	"to_ascii\(\'\?\。ᠢ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2316\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑄳㴼．\x{200C}𐹡\x{20EB}񫺦", %p)},	undef,	"to_ascii\(\'𑄳㴼．\\u200C𐹡\\u20EB\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2317\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑄳㴼.\x{200C}𐹡\x{20EB}񫺦", %p)},	undef,	"to_ascii\(\'𑄳㴼\.\\u200C𐹡\\u20EB\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2319\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񠻟𐹳𑈯｡\x{031D}", %p)},	undef,	"to_ascii\(\'\?𐹳𑈯｡\\u031D\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2321\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񠻟𐹳𑈯。\x{031D}", %p)},	undef,	"to_ascii\(\'\?𐹳𑈯\。\\u031D\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2322\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢊ뾜󠱴𑚶。\x{089D}𐹥", %p)},	undef,	"to_ascii\(\'ᢊ뾜\?𑚶\。\\u089D𐹥\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2323\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢊ뾜󠱴𑚶。\x{089D}𐹥", %p)},	undef,	"to_ascii\(\'ᢊ뾜\?𑚶\。\\u089D𐹥\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2324\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹥≠｡𐋲󠧠\x{200C}", %p)},	undef,	"to_ascii\(\'𐹥\≠｡𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2325\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹥=\x{0338}｡𐋲󠧠\x{200C}", %p)},	undef,	"to_ascii\(\'𐹥\=\\u0338｡𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2327\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹥≠。𐋲󠧠\x{200C}", %p)},	undef,	"to_ascii\(\'𐹥\≠\。𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2329\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹥=\x{0338}。𐋲󠧠\x{200C}", %p)},	undef,	"to_ascii\(\'𐹥\=\\u0338\。𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2331\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}񙯠\x{094D}．\x{200D}\x{A953}𐪤", %p)},	undef,	"to_ascii\(\'\\u115F\?\\u094D．\\u200D\\uA953\?\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2333\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}񙯠\x{094D}.\x{200D}\x{A953}𐪤", %p)},	undef,	"to_ascii\(\'\\u115F\?\\u094D\.\\u200D\\uA953\?\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2335\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򌋔󠆎󠆗𑲕。≮", %p)},	undef,	"to_ascii\(\'\?\󠆎\󠆗\?\。\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2337\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򌋔󠆎󠆗𑲕。<\x{0338}", %p)},	undef,	"to_ascii\(\'\?\󠆎\󠆗\?\。\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2338\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆦.\x{08E3}暀≠", %p)},	undef,	"to_ascii\(\'\󠆦\.\\u08E3暀\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2339\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆦.\x{08E3}暀=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠆦\.\\u08E3暀\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡤\x{ABED}｡\x{FD30}򜖅\x{1DF0}", %p)},	undef,	"to_ascii\(\'𐡤\\uABED｡\\uFD30\?\\u1DF0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2341\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡤\x{ABED}。\x{0634}\x{0645}򜖅\x{1DF0}", %p)},	undef,	"to_ascii\(\'𐡤\\uABED\。\\u0634\\u0645\?\\u1DF0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝉃\x{200D}⒈｡Ⴌ𞱓", %p)},	undef,	"to_ascii\(\'𝉃\\u200D⒈｡Ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2343\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝉃\x{200D}1.。Ⴌ𞱓", %p)},	undef,	"to_ascii\(\'𝉃\\u200D1\.\。Ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2345\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝉃\x{200D}1.。ⴌ𞱓", %p)},	undef,	"to_ascii\(\'𝉃\\u200D1\.\。ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2347\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝉃\x{200D}⒈｡ⴌ𞱓", %p)},	undef,	"to_ascii\(\'𝉃\\u200D⒈｡ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2349\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣙\x{0A4D}𱫘𞤸.ς񵯞􈰔", %p)},	undef,	"to_ascii\(\'\?\\u0A4D\?\?\.ς\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2351\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣙\x{0A4D}𱫘𞤸.Σ񵯞􈰔", %p)},	undef,	"to_ascii\(\'\?\\u0A4D\?\?\.Σ\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2352\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣙\x{0A4D}𱫘𞤸.σ񵯞􈰔", %p)},	undef,	"to_ascii\(\'\?\\u0A4D\?\?\.σ\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2353\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D3}。\x{200C}𐫀򞭱", %p)},	undef,	"to_ascii\(\'\\u07D3\。\\u200C𐫀\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2354\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{1C2E}𞀝.\x{05A6}ꡟ𞤕󠆖", %p)},	undef,	"to_ascii\(\'\\u1C2E\?\.\\u05A6ꡟ\?\󠆖\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2356\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("䂹󾖅𐋦．\x{200D}", %p)},	undef,	"to_ascii\(\'䂹\?𐋦．\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2357\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䂹󾖅𐋦.\x{200D}", %p)},	undef,	"to_ascii\(\'䂹\?𐋦\.\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2359\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9C0}\x{200C}𐹲\x{200C}｡\x{0767}🄉", %p)},	undef,	"to_ascii\(\'\\uA9C0\\u200C𐹲\\u200C｡\\u0767🄉\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2361\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9C0}\x{200C}𐹲\x{200C}。\x{0767}8,", %p)},	undef,	"to_ascii\(\'\\uA9C0\\u200C𐹲\\u200C\。\\u07678\,\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ B3\ \[data\/IdnaTest\.txt\:2363\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒｡Ⴃ≯", %p)},	undef,	"to_ascii\(\'︒｡Ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2365\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒｡Ⴃ>\x{0338}", %p)},	undef,	"to_ascii\(\'︒｡Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2366\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。。Ⴃ≯", %p)},	undef,	"to_ascii\(\'\。\。Ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2367\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。。Ⴃ>\x{0338}", %p)},	undef,	"to_ascii\(\'\。\。Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2368\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。。ⴃ>\x{0338}", %p)},	undef,	"to_ascii\(\'\。\。ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2369\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。。ⴃ≯", %p)},	undef,	"to_ascii\(\'\。\。ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2370\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒｡ⴃ>\x{0338}", %p)},	undef,	"to_ascii\(\'︒｡ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2371\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒｡ⴃ≯", %p)},	undef,	"to_ascii\(\'︒｡ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2372\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹮｡󠢼\x{200D}", %p)},	undef,	"to_ascii\(\'𐹮｡\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2373\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹮。󠢼\x{200D}", %p)},	undef,	"to_ascii\(\'𐹮\。\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2375\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴞ𐹨｡︒\x{077D}\x{200D}Ⴏ", %p)},	undef,	"to_ascii\(\'Ⴞ𐹨｡︒\\u077D\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2377\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴞ𐹨。。\x{077D}\x{200D}Ⴏ", %p)},	undef,	"to_ascii\(\'Ⴞ𐹨\。\。\\u077D\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ B2\ B3\ \[data\/IdnaTest\.txt\:2379\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ⴞ𐹨。。\x{077D}\x{200D}ⴏ", %p)},	undef,	"to_ascii\(\'ⴞ𐹨\。\。\\u077D\\u200Dⴏ\'\)\ throws\ error\ B5\ B6\ A4_2\ B2\ B3\ \[data\/IdnaTest\.txt\:2381\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ⴞ𐹨｡︒\x{077D}\x{200D}ⴏ", %p)},	undef,	"to_ascii\(\'ⴞ𐹨｡︒\\u077D\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2383\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴆ𝟹。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_ascii\(\'\\u200CႦ𝟹\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴆ3。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_ascii\(\'\\u200CႦ3\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2387\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{200C}ⴆ3。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_ascii\(\'\\u200Cⴆ3\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:2389\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{200C}ⴆ𝟹。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_ascii\(\'\\u200Cⴆ𝟹\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:2391\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("箃Ⴡ-󠁝｡≠-🤖", %p)},	undef,	"to_ascii\(\'箃Ⴡ\-\?｡\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2393\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃Ⴡ-󠁝｡=\x{0338}-🤖", %p)},	undef,	"to_ascii\(\'箃Ⴡ\-\?｡\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2394\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃Ⴡ-󠁝。≠-🤖", %p)},	undef,	"to_ascii\(\'箃Ⴡ\-\?\。\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2395\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃Ⴡ-󠁝。=\x{0338}-🤖", %p)},	undef,	"to_ascii\(\'箃Ⴡ\-\?\。\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2396\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃ⴡ-󠁝。=\x{0338}-🤖", %p)},	undef,	"to_ascii\(\'箃ⴡ\-\?\。\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2397\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃ⴡ-󠁝。≠-🤖", %p)},	undef,	"to_ascii\(\'箃ⴡ\-\?\。\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2398\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃ⴡ-󠁝｡=\x{0338}-🤖", %p)},	undef,	"to_ascii\(\'箃ⴡ\-\?｡\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2399\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃ⴡ-󠁝｡≠-🤖", %p)},	undef,	"to_ascii\(\'箃ⴡ\-\?｡\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2400\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{07E5}.\x{06B5}", %p)},	"xn--dtb.xn--okb",	"to_ascii\(\'\\u07E5\.\\u06B5\'\)\ \[data\/IdnaTest\.txt\:2401\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("xn--dtb.xn--okb", %p)},	"xn--dtb.xn--okb",	"to_ascii\(\'xn\-\-dtb\.xn\-\-okb\'\)\ \[data\/IdnaTest\.txt\:2402\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}\x{200D}.𞤿", %p)},	"xn--3e6h",	"to_ascii\(\'\\u200C\\u200D\.\?\'\)\ \[data\/IdnaTest\.txt\:2403\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--3e6h", %p)},	"xn--3e6h",	"to_ascii\(\'xn\-\-3e6h\'\)\ \[data\/IdnaTest\.txt\:2405\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤿", %p)},	"xn--3e6h",	"to_ascii\(\'\?\'\)\ \[data\/IdnaTest\.txt\:2406\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("🜑𐹧\x{0639}.ς𑍍蜹", %p)},	undef,	"to_ascii\(\'🜑𐹧\\u0639\.ς𑍍蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2407\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("🜑𐹧\x{0639}.Σ𑍍蜹", %p)},	undef,	"to_ascii\(\'🜑𐹧\\u0639\.Σ𑍍蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2408\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("🜑𐹧\x{0639}.σ𑍍蜹", %p)},	undef,	"to_ascii\(\'🜑𐹧\\u0639\.σ𑍍蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2409\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򫠐ス􆟤\x{0669}．󚃟", %p)},	undef,	"to_ascii\(\'\?ス\?\\u0669．\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2410\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򫠐ス􆟤\x{0669}.󚃟", %p)},	undef,	"to_ascii\(\'\?ス\?\\u0669\.\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2411\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪣򕡝．\x{059A}\x{D850}\x{06C2}", %p)},	undef,	"to_ascii\(\'𝪣\?．\\u059A\\uD850\\u06C2\'\)\ throws\ error\ P1\ V5\ V6\ B1\ A3\ \[data\/IdnaTest\.txt\:2412\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪣򕡝．\x{059A}\x{D850}\x{06C1}\x{0654}", %p)},	undef,	"to_ascii\(\'𝪣\?．\\u059A\\uD850\\u06C1\\u0654\'\)\ throws\ error\ P1\ V5\ V6\ B1\ A3\ \[data\/IdnaTest\.txt\:2413\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪣򕡝.\x{059A}\x{D850}\x{06C2}", %p)},	undef,	"to_ascii\(\'𝪣\?\.\\u059A\\uD850\\u06C2\'\)\ throws\ error\ P1\ V5\ V6\ B1\ A3\ \[data\/IdnaTest\.txt\:2414\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪣򕡝.\x{059A}\x{D850}\x{06C1}\x{0654}", %p)},	undef,	"to_ascii\(\'𝪣\?\.\\u059A\\uD850\\u06C1\\u0654\'\)\ throws\ error\ P1\ V5\ V6\ B1\ A3\ \[data\/IdnaTest\.txt\:2415\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0660}򪓵\x{200C}。\x{0757}", %p)},	undef,	"to_ascii\(\'\\u0660\?\\u200C\。\\u0757\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2416\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{103A}\x{200D}\x{200C}。-\x{200C}", %p)},	undef,	"to_ascii\(\'\\u103A\\u200D\\u200C\。\-\\u200C\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:2418\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("︒｡\x{1B44}ᡉ", %p)},	undef,	"to_ascii\(\'︒｡\\u1B44ᡉ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2420\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("。。\x{1B44}ᡉ", %p)},	undef,	"to_ascii\(\'\。\。\\u1B44ᡉ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2421\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}ß。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_ascii\(\'\\u0758ß\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2422\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}ß。ጫᢊ\x{0768}2", %p)},	undef,	"to_ascii\(\'\\u0758ß\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2423\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}SS。ጫᢊ\x{0768}2", %p)},	undef,	"to_ascii\(\'\\u0758SS\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2424\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}ss。ጫᢊ\x{0768}2", %p)},	undef,	"to_ascii\(\'\\u0758ss\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2425\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}Ss。ጫᢊ\x{0768}2", %p)},	undef,	"to_ascii\(\'\\u0758Ss\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2426\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}SS。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_ascii\(\'\\u0758SS\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2427\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}ss。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_ascii\(\'\\u0758ss\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2428\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}Ss。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_ascii\(\'\\u0758Ss\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2429\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{07C3}𞶇ᚲ.\x{0902}\x{0353}𝟚\x{09CD}", %p)},	undef,	"to_ascii\(\'\\u07C3\?ᚲ\.\\u0902\\u0353𝟚\\u09CD\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2430\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07C3}𞶇ᚲ.\x{0902}\x{0353}2\x{09CD}", %p)},	undef,	"to_ascii\(\'\\u07C3\?ᚲ\.\\u0902\\u03532\\u09CD\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2431\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{1BAB}︒\x{200D}.񒶈񥹓", %p)},	undef,	"to_ascii\(\'\-\\u1BAB︒\\u200D\.\?\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2432\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{1BAB}。\x{200D}.񒶈񥹓", %p)},	undef,	"to_ascii\(\'\-\\u1BAB\。\\u200D\.\?\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2434\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠦮.≯𞀆", %p)},	undef,	"to_ascii\(\'\?\.\≯\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2436\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠦮.>\x{0338}𞀆", %p)},	undef,	"to_ascii\(\'\?\.\>\\u0338\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2437\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𑄳󠊗𐹩。𞮱", %p)},	undef,	"to_ascii\(\'\-𑄳\?𐹩\。\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2438\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06B9}．ᡳ\x{115F}", %p)},	undef,	"to_ascii\(\'\\u06B9．ᡳ\\u115F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2439\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06B9}.ᡳ\x{115F}", %p)},	undef,	"to_ascii\(\'\\u06B9\.ᡳ\\u115F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2440\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㨛𘱎.︒𝟕\x{0D01}", %p)},	undef,	"to_ascii\(\'㨛\?\.︒𝟕\\u0D01\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2441\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㨛𘱎.。7\x{0D01}", %p)},	undef,	"to_ascii\(\'㨛\?\.\。7\\u0D01\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2442\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-｡𞷁\x{2064}𞤣≮", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-｡\?\\u2064\?\≮\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2443\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-｡𞷁\x{2064}𞤣<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-｡\?\\u2064\?\<\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2444\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-。𞷁\x{2064}𞤣≮", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-\。\?\\u2064\?\≮\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2445\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-。𞷁\x{2064}𞤣<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-\。\?\\u2064\?\<\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2446\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß\x{200C}\x{AAF6}ᢥ．⊶ჁႶ", %p)},	undef,	"to_ascii\(\'ß\\u200C\\uAAF6ᢥ．\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2447\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß\x{200C}\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_ascii\(\'ß\\u200C\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2449\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ß\x{200C}\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'ß\\u200C\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:2451\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS\x{200C}\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_ascii\(\'SS\\u200C\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2453\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ss\x{200C}\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'ss\\u200C\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:2455\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ss\x{200C}\x{AAF6}ᢥ.⊶Ⴡⴖ", %p)},	undef,	"to_ascii\(\'Ss\\u200C\\uAAF6ᢥ\.\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2457\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("xn--ss-4epx629f.xn--ifh802b6a", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'xn\-\-ss\-4epx629f\.xn\-\-ifh802b6a\'\)\ \[data\/IdnaTest\.txt\:2459\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ss\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'ss\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:2460\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_ascii\(\'SS\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2461\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{AAF6}ᢥ.⊶Ⴡⴖ", %p)},	undef,	"to_ascii\(\'Ss\\uAAF6ᢥ\.\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2462\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ß\x{200C}\x{AAF6}ᢥ．⊶ⴡⴖ", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'ß\\u200C\\uAAF6ᢥ．\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:2463\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS\x{200C}\x{AAF6}ᢥ．⊶ჁႶ", %p)},	undef,	"to_ascii\(\'SS\\u200C\\uAAF6ᢥ．\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2465\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ss\x{200C}\x{AAF6}ᢥ．⊶ⴡⴖ", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'ss\\u200C\\uAAF6ᢥ．\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:2467\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ss\x{200C}\x{AAF6}ᢥ．⊶Ⴡⴖ", %p)},	undef,	"to_ascii\(\'Ss\\u200C\\uAAF6ᢥ．\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2469\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。ς󠁉", %p)},	undef,	"to_ascii\(\'\\u200D\。ς\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2471\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。Σ󠁉", %p)},	undef,	"to_ascii\(\'\\u200D\。Σ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2473\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。σ󠁉", %p)},	undef,	"to_ascii\(\'\\u200D\。σ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2475\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑ß.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_ascii\(\'\?ß\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:2477\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑SS.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_ascii\(\'\?SS\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:2479\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑ss.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_ascii\(\'\?ss\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:2481\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑Ss.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_ascii\(\'\?Ss\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:2483\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑘽\x{200D}𞤧．𐹧󡦪-", %p)},	undef,	"to_ascii\(\'𑘽\\u200D\?．𐹧\?\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2485\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑘽\x{200D}𞤧.𐹧󡦪-", %p)},	undef,	"to_ascii\(\'𑘽\\u200D\?\.𐹧\?\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2487\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒒򨘙򳳠𑓀.-󞡊", %p)},	undef,	"to_ascii\(\'⒒\?\?𑓀\.\-\?\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2489\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("11.򨘙򳳠𑓀.-󞡊", %p)},	undef,	"to_ascii\(\'11\.\?\?𑓀\.\-\?\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2490\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-｡\x{200D}", %p)},	undef,	"to_ascii\(\'\-｡\\u200D\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2491\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。\x{200D}", %p)},	undef,	"to_ascii\(\'\-\。\\u200D\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2493\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ．ς¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ．ς¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2495\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ．ς¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ．ς¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2496\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ.ς1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2497\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ.ς1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2498\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ.Σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2499\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ.Σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2500\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ.σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2501\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ.σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2502\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ．Σ¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ．Σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2503\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ．Σ¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ．Σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2504\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ．σ¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ．σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2505\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ．σ¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ．σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2506\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ቬ򔠼񁗶｡𐨬𝟠", %p)},	undef,	"to_ascii\(\'ቬ\?\?｡𐨬𝟠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2507\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ቬ򔠼񁗶。𐨬8", %p)},	undef,	"to_ascii\(\'ቬ\?\?\。𐨬8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2508\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐱲。蔫\x{0766}", %p)},	undef,	"to_ascii\(\'\?\。蔫\\u0766\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2509\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򒲧₃｡ꡚ𛇑󠄳\x{0647}", %p)},	undef,	"to_ascii\(\'\?₃｡ꡚ\?\󠄳\\u0647\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2510\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򒲧3。ꡚ𛇑󠄳\x{0647}", %p)},	undef,	"to_ascii\(\'\?3\。ꡚ\?\󠄳\\u0647\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2511\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}≠.ß", %p)},	undef,	"to_ascii\(\'蓸\\u0642\≠\.ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2512\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}=\x{0338}.ß", %p)},	undef,	"to_ascii\(\'蓸\\u0642\=\\u0338\.ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2513\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}=\x{0338}.SS", %p)},	undef,	"to_ascii\(\'蓸\\u0642\=\\u0338\.SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2514\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}≠.SS", %p)},	undef,	"to_ascii\(\'蓸\\u0642\≠\.SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2515\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{084E}\x{067A}\x{0DD3}⒊.𐹹𞱩󠃪\x{200C}", %p)},	undef,	"to_ascii\(\'\\u084E\\u067A\\u0DD3⒊\.𐹹\?\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2516\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{084E}\x{067A}\x{0DD3}3..𐹹𞱩󠃪\x{200C}", %p)},	undef,	"to_ascii\(\'\\u084E\\u067A\\u0DD33\.\.𐹹\?\?\\u200C\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:2518\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς\x{200D}-.Ⴣ𦟙", %p)},	undef,	"to_ascii\(\'ς\\u200D\-\.Ⴣ𦟙\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2520\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ς\x{200D}-.ⴣ𦟙", %p)},	undef,	"to_ascii\(\'ς\\u200D\-\.ⴣ𦟙\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2522\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Σ\x{200D}-.Ⴣ𦟙", %p)},	undef,	"to_ascii\(\'Σ\\u200D\-\.Ⴣ𦟙\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2524\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("σ\x{200D}-.ⴣ𦟙", %p)},	undef,	"to_ascii\(\'σ\\u200D\-\.ⴣ𦟙\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2526\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("≠。🞳𝟲", %p)},	undef,	"to_ascii\(\'\≠\。🞳𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2528\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}。🞳𝟲", %p)},	undef,	"to_ascii\(\'\=\\u0338\。🞳𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2529\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠。🞳6", %p)},	undef,	"to_ascii\(\'\≠\。🞳6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2530\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}。🞳6", %p)},	undef,	"to_ascii\(\'\=\\u0338\。🞳6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2531\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󅬽.蠔", %p)},	undef,	"to_ascii\(\'\?\.蠔\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2532\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{08E6}\x{200D}．뼽", %p)},	undef,	"to_ascii\(\'\\u08E6\\u200D．뼽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2533\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{08E6}\x{200D}．뼽", %p)},	undef,	"to_ascii\(\'\\u08E6\\u200D．뼽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2535\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{08E6}\x{200D}.뼽", %p)},	undef,	"to_ascii\(\'\\u08E6\\u200D\.뼽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2537\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{08E6}\x{200D}.뼽", %p)},	undef,	"to_ascii\(\'\\u08E6\\u200D\.뼽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2539\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("₇\x{0BCD}􃂷\x{06D2}。👖\x{0675}-𞪑", %p)},	undef,	"to_ascii\(\'₇\\u0BCD\?\\u06D2\。👖\\u0675\-\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2541\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("7\x{0BCD}􃂷\x{06D2}。👖\x{0627}\x{0674}-𞪑", %p)},	undef,	"to_ascii\(\'7\\u0BCD\?\\u06D2\。👖\\u0627\\u0674\-\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2542\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("-｡\x{077B}", %p)},	undef,	"to_ascii\(\'\-｡\\u077B\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2543\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("-。\x{077B}", %p)},	undef,	"to_ascii\(\'\-\。\\u077B\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2544\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𑇌𵛓｡-⒈ꡏ\x{072B}", %p)},	undef,	"to_ascii\(\'𑇌\?｡\-⒈ꡏ\\u072B\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2545\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑇌𵛓。-1.ꡏ\x{072B}", %p)},	undef,	"to_ascii\(\'𑇌\?\。\-1\.ꡏ\\u072B\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2546\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("璛\x{1734}\x{06AF}.-", %p)},	undef,	"to_ascii\(\'璛\\u1734\\u06AF\.\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2547\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠆰\x{08A1}\x{0A4D}샕．𐹲휁", %p)},	undef,	"to_ascii\(\'\󠆰\\u08A1\\u0A4D샕．𐹲휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2548\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠆰\x{08A1}\x{0A4D}샕．𐹲휁", %p)},	undef,	"to_ascii\(\'\󠆰\\u08A1\\u0A4D샕．𐹲휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2549\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠆰\x{08A1}\x{0A4D}샕.𐹲휁", %p)},	undef,	"to_ascii\(\'\󠆰\\u08A1\\u0A4D샕\.𐹲휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2550\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠆰\x{08A1}\x{0A4D}샕.𐹲휁", %p)},	undef,	"to_ascii\(\'\󠆰\\u08A1\\u0A4D샕\.𐹲휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2551\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񍨽．񋸕", %p)},	undef,	"to_ascii\(\'\?．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2552\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񍨽.񋸕", %p)},	undef,	"to_ascii\(\'\?\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2553\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{067D}𞥕｡𑑂𞤶Ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D\?｡\?\?Ⴍ\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2554\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{067D}𞥕。𑑂𞤶Ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D\?\。\?\?Ⴍ\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2555\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}𞥕。𑑂𞤶ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D\?\。\?\?ⴍ\-\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:2556\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}𞥕｡𑑂𞤶ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D\?｡\?\?ⴍ\-\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:2557\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐯀𐸉𞧏。񢚧₄Ⴋ񂹫", %p)},	undef,	"to_ascii\(\'\?\?\?\。\?₄Ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2558\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯀𐸉𞧏。񢚧4Ⴋ񂹫", %p)},	undef,	"to_ascii\(\'\?\?\?\。\?4Ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2559\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯀𐸉𞧏。񢚧4ⴋ񂹫", %p)},	undef,	"to_ascii\(\'\?\?\?\。\?4ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2560\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯀𐸉𞧏。񢚧₄ⴋ񂹫", %p)},	undef,	"to_ascii\(\'\?\?\?\。\?₄ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2561\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{06BD}︒󠑥.≠", %p)},	undef,	"to_ascii\(\'4\\u06BD︒\?\.\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2562\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{06BD}︒󠑥.=\x{0338}", %p)},	undef,	"to_ascii\(\'4\\u06BD︒\?\.\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2563\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{06BD}。󠑥.≠", %p)},	undef,	"to_ascii\(\'4\\u06BD\。\?\.\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2564\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{06BD}。󠑥.=\x{0338}", %p)},	undef,	"to_ascii\(\'4\\u06BD\。\?\.\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2565\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟓。\x{06D7}", %p)},	undef,	"to_ascii\(\'𝟓\。\\u06D7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2566\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("5。\x{06D7}", %p)},	undef,	"to_ascii\(\'5\。\\u06D7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2567\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}򺸩.⾕", %p)},	undef,	"to_ascii\(\'\\u200C\?\.⾕\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2568\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}򺸩.谷", %p)},	undef,	"to_ascii\(\'\\u200C\?\.谷\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2570\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒󎰇\x{200D}.-\x{073C}\x{200C}", %p)},	undef,	"to_ascii\(\'︒\?\\u200D\.\-\\u073C\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2572\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。󎰇\x{200D}.-\x{073C}\x{200C}", %p)},	undef,	"to_ascii\(\'\。\?\\u200D\.\-\\u073C\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2574\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯𞤟。ᡨ", %p)},	undef,	"to_ascii\(\'\≯\?\。ᡨ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2576\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}𞤟。ᡨ", %p)},	undef,	"to_ascii\(\'\>\\u0338\?\。ᡨ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2577\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{0F74}𫫰𝨄。\x{0713}𐹦", %p)},	undef,	"to_ascii\(\'\\u0F74𫫰𝨄\。\\u0713𐹦\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2578\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{033C}\x{07DB}⁷𝟹｡𝟬", %p)},	undef,	"to_ascii\(\'\\u033C\\u07DB⁷𝟹｡𝟬\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2579\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{033C}\x{07DB}73。0", %p)},	undef,	"to_ascii\(\'\\u033C\\u07DB73\。0\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2580\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}．𝟗", %p)},	"9",	"to_ascii\(\'\\u200D．𝟗\'\)\ \[data\/IdnaTest\.txt\:2581\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}.9", %p)},	"9",	"to_ascii\(\'\\u200D\.9\'\)\ \[data\/IdnaTest\.txt\:2583\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9", %p)},	"9",	"to_ascii\(\'9\'\)\ \[data\/IdnaTest\.txt\:2585\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{0779}ᡭ𪕈。\x{06B6}\x{08D9}", %p)},	undef,	"to_ascii\(\'\\u0779ᡭ𪕈\。\\u06B6\\u08D9\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2586\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0726}５\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_ascii\(\'\\u0726５\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2587\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0726}５\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_ascii\(\'\\u0726５\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2588\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0726}5\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_ascii\(\'\\u07265\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2589\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0726}5\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_ascii\(\'\\u07265\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2590\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴍ𿣍ꡨ\x{05AE}。Ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⴍ\?ꡨ\\u05AE\。Ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2591\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴍ𿣍ꡨ\x{05AE}。ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'ⴍ\?ꡨ\\u05AE\。ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2593\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋰。󑓱", %p)},	undef,	"to_ascii\(\'𐋰\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2595\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󡎦\x{17B4}\x{0B4D}.𐹾", %p)},	undef,	"to_ascii\(\'\?\\u17B4\\u0B4D\.𐹾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2596\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}Ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFႫ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2597\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}Ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFႫ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2598\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}Ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFႫ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2599\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}Ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFႫ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2600\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFⴋ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2601\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFⴋ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2602\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFⴋ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2603\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFⴋ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2604\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0784}．𞡝\x{0601}", %p)},	undef,	"to_ascii\(\'\\u0784．𞡝\\u0601\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2605\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0784}.𞡝\x{0601}", %p)},	undef,	"to_ascii\(\'\\u0784\.𞡝\\u0601\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2606\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0ACD}₃.8\x{A8C4}\x{200D}🃤", %p)},	undef,	"to_ascii\(\'\\u0ACD₃\.8\\uA8C4\\u200D🃤\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2607\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0ACD}3.8\x{A8C4}\x{200D}🃤", %p)},	undef,	"to_ascii\(\'\\u0ACD3\.8\\uA8C4\\u200D🃤\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2608\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("℻⩷𝆆。𞤠󠆁\x{180C}", %p)},	"xn--fax-4c9a1676t.xn--6e6h",	"to_ascii\(\'℻\⩷𝆆\。\?\󠆁\\u180C\'\)\ \[data\/IdnaTest\.txt\:2609\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("FAX⩷𝆆。𞤠󠆁\x{180C}", %p)},	"xn--fax-4c9a1676t.xn--6e6h",	"to_ascii\(\'FAX\⩷𝆆\。\?\󠆁\\u180C\'\)\ \[data\/IdnaTest\.txt\:2610\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("fax⩷𝆆。𞤠󠆁\x{180C}", %p)},	"xn--fax-4c9a1676t.xn--6e6h",	"to_ascii\(\'fax\⩷𝆆\。\?\󠆁\\u180C\'\)\ \[data\/IdnaTest\.txt\:2611\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("Fax⩷𝆆。𞤠󠆁\x{180C}", %p)},	"xn--fax-4c9a1676t.xn--6e6h",	"to_ascii\(\'Fax\⩷𝆆\。\?\󠆁\\u180C\'\)\ \[data\/IdnaTest\.txt\:2612\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--fax-4c9a1676t.xn--6e6h", %p)},	"xn--fax-4c9a1676t.xn--6e6h",	"to_ascii\(\'xn\-\-fax\-4c9a1676t\.xn\-\-6e6h\'\)\ \[data\/IdnaTest\.txt\:2613\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("fax⩷𝆆.𞥂", %p)},	"xn--fax-4c9a1676t.xn--6e6h",	"to_ascii\(\'fax\⩷𝆆\.\?\'\)\ \[data\/IdnaTest\.txt\:2614\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("FAX⩷𝆆.𞥂", %p)},	"xn--fax-4c9a1676t.xn--6e6h",	"to_ascii\(\'FAX\⩷𝆆\.\?\'\)\ \[data\/IdnaTest\.txt\:2615\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("Fax⩷𝆆.𞥂", %p)},	"xn--fax-4c9a1676t.xn--6e6h",	"to_ascii\(\'Fax\⩷𝆆\.\?\'\)\ \[data\/IdnaTest\.txt\:2616\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ꡕ≠\x{105E}󮿱｡𐵧󠄫\x{FFA0}", %p)},	undef,	"to_ascii\(\'ꡕ\≠\\u105E\?｡\?\󠄫\\uFFA0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2617\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡕ=\x{0338}\x{105E}󮿱｡𐵧󠄫\x{FFA0}", %p)},	undef,	"to_ascii\(\'ꡕ\=\\u0338\\u105E\?｡\?\󠄫\\uFFA0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2618\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡕ≠\x{105E}󮿱。𐵧󠄫\x{1160}", %p)},	undef,	"to_ascii\(\'ꡕ\≠\\u105E\?\。\?\󠄫\\u1160\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2619\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡕ=\x{0338}\x{105E}󮿱。𐵧󠄫\x{1160}", %p)},	undef,	"to_ascii\(\'ꡕ\=\\u0338\\u105E\?\。\?\󠄫\\u1160\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2620\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("鱊。\x{200C}", %p)},	"xn--rt6a.",	"to_ascii\(\'鱊\。\\u200C\'\)\ \[data\/IdnaTest\.txt\:2621\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rt6a.", %p)},	"xn--rt6a.",	"to_ascii\(\'xn\-\-rt6a\.\'\)\ \[data\/IdnaTest\.txt\:2623\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("鱊.", %p)},	"xn--rt6a.",	"to_ascii\(\'鱊\.\'\)\ \[data\/IdnaTest\.txt\:2624\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("8𐹣．𑍨", %p)},	undef,	"to_ascii\(\'8𐹣．𑍨\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2625\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("8𐹣.𑍨", %p)},	undef,	"to_ascii\(\'8𐹣\.𑍨\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2626\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("⏹𐧀．𐫯", %p)},	undef,	"to_ascii\(\'\⏹𐧀．𐫯\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2627\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("⏹𐧀.𐫯", %p)},	undef,	"to_ascii\(\'\⏹𐧀\.𐫯\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2628\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤺\x{07CC}4．\x{200D}", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'\?\\u07CC4．\\u200D\'\)\ \[data\/IdnaTest\.txt\:2629\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤺\x{07CC}4.\x{200D}", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'\?\\u07CC4\.\\u200D\'\)\ \[data\/IdnaTest\.txt\:2631\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--4-0bd15808a.", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'xn\-\-4\-0bd15808a\.\'\)\ \[data\/IdnaTest\.txt\:2633\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤺\x{07CC}4.", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'\?\\u07CC4\.\'\)\ \[data\/IdnaTest\.txt\:2634\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⒗\x{0981}\x{20EF}-.\x{08E2}•", %p)},	undef,	"to_ascii\(\'⒗\\u0981\\u20EF\-\.\\u08E2\•\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2635\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("16.\x{0981}\x{20EF}-.\x{08E2}•", %p)},	undef,	"to_ascii\(\'16\.\\u0981\\u20EF\-\.\\u08E2\•\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2636\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-｡䏛", %p)},	undef,	"to_ascii\(\'\-｡䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2637\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。䏛", %p)},	undef,	"to_ascii\(\'\-\。䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2638\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񒃠．\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?．\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2639\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񒃠.\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?\.\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2641\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈⓰󥣇｡𐹠\x{200D}򗷦Ⴕ", %p)},	undef,	"to_ascii\(\'⒈⓰\?｡𐹠\\u200D\?Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2643\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.⓰󥣇。𐹠\x{200D}򗷦Ⴕ", %p)},	undef,	"to_ascii\(\'1\.⓰\?\。𐹠\\u200D\?Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2645\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.⓰󥣇。𐹠\x{200D}򗷦ⴕ", %p)},	undef,	"to_ascii\(\'1\.⓰\?\。𐹠\\u200D\?ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2647\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈⓰󥣇｡𐹠\x{200D}򗷦ⴕ", %p)},	undef,	"to_ascii\(\'⒈⓰\?｡𐹠\\u200D\?ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2649\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-ß｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-ß｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2651\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-ß。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-ß\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2652\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-SS。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-SS\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2653\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-ss。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-ss\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2654\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-Ss。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-Ss\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2655\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-SS｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-SS｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2656\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-ss｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-ss｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2657\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-Ss｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-Ss｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2658\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑇀.󠨱", %p)},	undef,	"to_ascii\(\'𑇀\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2659\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("␒3\x{FB88}｡𝟘𐨿𐹆", %p)},	undef,	"to_ascii\(\'\␒3\\uFB88｡𝟘𐨿\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2660\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("␒3\x{0688}。0𐨿𐹆", %p)},	undef,	"to_ascii\(\'\␒3\\u0688\。0𐨿\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2661\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{076B}６\x{0A81}\x{08A6}。\x{1DE3}", %p)},	undef,	"to_ascii\(\'\\u076B６\\u0A81\\u08A6\。\\u1DE3\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2662\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{076B}6\x{0A81}\x{08A6}。\x{1DE3}", %p)},	undef,	"to_ascii\(\'\\u076B6\\u0A81\\u08A6\。\\u1DE3\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2663\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0605}-𽤞Ⴂ。򅤶\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0605\-\?Ⴂ\。\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2664\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0605}-𽤞ⴂ。򅤶\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0605\-\?ⴂ\。\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2666\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５≯ß", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\≯ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2668\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５>\x{0338}ß", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2669\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5≯ß", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\≯ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2670\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5>\x{0338}ß", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2671\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5>\x{0338}SS", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2672\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5≯SS", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\≯SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2673\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5≯ss", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\≯ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2674\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5>\x{0338}ss", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2675\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5>\x{0338}Ss", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2676\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5≯Ss", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\≯Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2677\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５>\x{0338}SS", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2678\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５≯SS", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\≯SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2679\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５≯ss", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\≯ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2680\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５>\x{0338}ss", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2681\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５>\x{0338}Ss", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2682\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５≯Ss", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\≯Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2683\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0ACD}8\x{200D}．򾂈\x{075C}", %p)},	undef,	"to_ascii\(\'\\u0ACD8\\u200D．\?\\u075C\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2684\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0ACD}8\x{200D}.򾂈\x{075C}", %p)},	undef,	"to_ascii\(\'\\u0ACD8\\u200D\.\?\\u075C\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2686\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򸷆\x{0A70}≮򹓙．񞎧⁷󠯙\x{06B6}", %p)},	undef,	"to_ascii\(\'\?\\u0A70\≮\?．\?⁷\?\\u06B6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2688\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򸷆\x{0A70}<\x{0338}򹓙．񞎧⁷󠯙\x{06B6}", %p)},	undef,	"to_ascii\(\'\?\\u0A70\<\\u0338\?．\?⁷\?\\u06B6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2689\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򸷆\x{0A70}≮򹓙.񞎧7󠯙\x{06B6}", %p)},	undef,	"to_ascii\(\'\?\\u0A70\≮\?\.\?7\?\\u06B6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2690\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򸷆\x{0A70}<\x{0338}򹓙.񞎧7󠯙\x{06B6}", %p)},	undef,	"to_ascii\(\'\?\\u0A70\<\\u0338\?\.\?7\?\\u06B6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2691\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤪.ς", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'\?\.ς\'\)\ \[data\/IdnaTest\.txt\:2692\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤪.Σ", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'\?\.Σ\'\)\ \[data\/IdnaTest\.txt\:2694\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤪.σ", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'\?\.σ\'\)\ \[data\/IdnaTest\.txt\:2695\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--ie6h.xn--4xa", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'xn\-\-ie6h\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2696\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--ie6h.xn--3xa", %p)},	"xn--ie6h.xn--3xa",	"to_ascii\(\'xn\-\-ie6h\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:2697\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}Ⴚ｡ς", %p)},	undef,	"to_ascii\(\'\\u200CႺ｡ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2698\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴚ。ς", %p)},	undef,	"to_ascii\(\'\\u200CႺ\。ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2700\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}ⴚ。ς", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'\\u200Cⴚ\。ς\'\)\ \[data\/IdnaTest\.txt\:2702\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}Ⴚ。Σ", %p)},	undef,	"to_ascii\(\'\\u200CႺ\。Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2704\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}ⴚ。σ", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'\\u200Cⴚ\。σ\'\)\ \[data\/IdnaTest\.txt\:2706\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--ilj.xn--4xa", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'xn\-\-ilj\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2708\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴚ.σ", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'ⴚ\.σ\'\)\ \[data\/IdnaTest\.txt\:2709\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴚ.Σ", %p)},	undef,	"to_ascii\(\'Ⴚ\.Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2710\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴚ.ς", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'ⴚ\.ς\'\)\ \[data\/IdnaTest\.txt\:2711\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴚ.ς", %p)},	undef,	"to_ascii\(\'Ⴚ\.ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2713\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--ilj.xn--3xa", %p)},	"xn--ilj.xn--3xa",	"to_ascii\(\'xn\-\-ilj\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:2714\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴚ.σ", %p)},	undef,	"to_ascii\(\'Ⴚ\.σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2715\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}ⴚ｡ς", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'\\u200Cⴚ｡ς\'\)\ \[data\/IdnaTest\.txt\:2716\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}Ⴚ｡Σ", %p)},	undef,	"to_ascii\(\'\\u200CႺ｡Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2718\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}ⴚ｡σ", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'\\u200Cⴚ｡σ\'\)\ \[data\/IdnaTest\.txt\:2720\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤃．𐹦", %p)},	undef,	"to_ascii\(\'\?．𐹦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2722\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤃.𐹦", %p)},	undef,	"to_ascii\(\'\?\.𐹦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2723\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{200D}⾕。\x{200C}\x{0310}\x{A953}ꡎ", %p)},	undef,	"to_ascii\(\'\\u200D⾕\。\\u200C\\u0310\\uA953ꡎ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2724\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{200D}⾕。\x{200C}\x{A953}\x{0310}ꡎ", %p)},	undef,	"to_ascii\(\'\\u200D⾕\。\\u200C\\uA953\\u0310ꡎ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2726\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{200D}谷。\x{200C}\x{A953}\x{0310}ꡎ", %p)},	undef,	"to_ascii\(\'\\u200D谷\。\\u200C\\uA953\\u0310ꡎ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2728\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔．𞤐\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔．\?\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2730\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔．𞤐\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔．\?\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2732\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔.𞤐\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔\.\?\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2734\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔.𞤐\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔\.\?\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2736\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񔲵５ᦛς.\x{A8C4}\x{077B}\x{1CD2}\x{0738}", %p)},	undef,	"to_ascii\(\'\?５ᦛς\.\\uA8C4\\u077B\\u1CD2\\u0738\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2738\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵５ᦛς.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?５ᦛς\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2739\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵5ᦛς.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?5ᦛς\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2740\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵5ᦛΣ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?5ᦛΣ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2741\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵5ᦛσ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?5ᦛσ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2742\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵５ᦛΣ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?５ᦛΣ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵５ᦛσ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?５ᦛσ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2744\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵５ᦛΣ.\x{A8C4}\x{077B}\x{1CD2}\x{0738}", %p)},	undef,	"to_ascii\(\'\?５ᦛΣ\.\\uA8C4\\u077B\\u1CD2\\u0738\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2745\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵５ᦛσ.\x{A8C4}\x{077B}\x{1CD2}\x{0738}", %p)},	undef,	"to_ascii\(\'\?５ᦛσ\.\\uA8C4\\u077B\\u1CD2\\u0738\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2746\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("淽。ᠾ", %p)},	"xn--34w.xn--x7e",	"to_ascii\(\'淽\。ᠾ\'\)\ \[data\/IdnaTest\.txt\:2747\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--34w.xn--x7e", %p)},	"xn--34w.xn--x7e",	"to_ascii\(\'xn\-\-34w\.xn\-\-x7e\'\)\ \[data\/IdnaTest\.txt\:2748\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("淽.ᠾ", %p)},	"xn--34w.xn--x7e",	"to_ascii\(\'淽\.ᠾ\'\)\ \[data\/IdnaTest\.txt\:2749\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐹴𑘷。-", %p)},	undef,	"to_ascii\(\'𐹴𑘷\。\-\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:2750\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򬨩Ⴓ❓｡𑄨", %p)},	undef,	"to_ascii\(\'\?Ⴓ\❓｡𑄨\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2751\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򬨩Ⴓ❓。𑄨", %p)},	undef,	"to_ascii\(\'\?Ⴓ\❓\。𑄨\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2752\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򬨩ⴓ❓。𑄨", %p)},	undef,	"to_ascii\(\'\?ⴓ\❓\。𑄨\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2753\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򬨩ⴓ❓｡𑄨", %p)},	undef,	"to_ascii\(\'\?ⴓ\❓｡𑄨\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2754\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ｡ßႣ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡\?Ⴇ｡ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2755\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ。ßႣ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡\?Ⴇ\。ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2757\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤌ⴇ。ßⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡\?ⴇ\。ßⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2759\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ。SSႣ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡\?Ⴇ\。SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2761\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤌ⴇ。ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡\?ⴇ\。ssⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2763\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ。Ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡\?Ⴇ\。Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2765\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤌ⴇ｡ßⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡\?ⴇ｡ßⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2767\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ｡SSႣ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡\?Ⴇ｡SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2769\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤌ⴇ｡ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡\?ⴇ｡ssⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2771\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ｡Ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡\?Ⴇ｡Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2773\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17FF}｡𞬳", %p)},	undef,	"to_ascii\(\'\\u17FF｡\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2775\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17FF}。𞬳", %p)},	undef,	"to_ascii\(\'\\u17FF\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2776\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{0652}\x{200D}｡\x{0CCD}𑚳", %p)},	undef,	"to_ascii\(\'\\u0652\\u200D｡\\u0CCD𑚳\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2777\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{0652}\x{200D}。\x{0CCD}𑚳", %p)},	undef,	"to_ascii\(\'\\u0652\\u200D\。\\u0CCD𑚳\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2779\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-≠ᠻ．\x{076D}𞥃≮󟷺", %p)},	undef,	"to_ascii\(\'\-\≠ᠻ．\\u076D\?\≮\?\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2781\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-=\x{0338}ᠻ．\x{076D}𞥃<\x{0338}󟷺", %p)},	undef,	"to_ascii\(\'\-\=\\u0338ᠻ．\\u076D\?\<\\u0338\?\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2782\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≠ᠻ.\x{076D}𞥃≮󟷺", %p)},	undef,	"to_ascii\(\'\-\≠ᠻ\.\\u076D\?\≮\?\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2783\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-=\x{0338}ᠻ.\x{076D}𞥃<\x{0338}󟷺", %p)},	undef,	"to_ascii\(\'\-\=\\u0338ᠻ\.\\u076D\?\<\\u0338\?\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2784\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠰆≯\x{07B5}𐻪．򊥕≮𑁆\x{084C}", %p)},	undef,	"to_ascii\(\'\?\≯\\u07B5\?．\?\≮𑁆\\u084C\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2785\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠰆>\x{0338}\x{07B5}𐻪．򊥕<\x{0338}𑁆\x{084C}", %p)},	undef,	"to_ascii\(\'\?\>\\u0338\\u07B5\?．\?\<\\u0338𑁆\\u084C\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2786\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠰆≯\x{07B5}𐻪.򊥕≮𑁆\x{084C}", %p)},	undef,	"to_ascii\(\'\?\≯\\u07B5\?\.\?\≮𑁆\\u084C\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2787\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠰆>\x{0338}\x{07B5}𐻪.򊥕<\x{0338}𑁆\x{084C}", %p)},	undef,	"to_ascii\(\'\?\>\\u0338\\u07B5\?\.\?\<\\u0338𑁆\\u084C\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2788\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠󦋂.\x{0600}\x{0BCD}-\x{06B9}", %p)},	undef,	"to_ascii\(\'\≠\?\.\\u0600\\u0BCD\-\\u06B9\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2789\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}󦋂.\x{0600}\x{0BCD}-\x{06B9}", %p)},	undef,	"to_ascii\(\'\=\\u0338\?\.\\u0600\\u0BCD\-\\u06B9\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2790\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17DD}󠁣≠｡𐹼𐋤", %p)},	undef,	"to_ascii\(\'\\u17DD\?\≠｡𐹼𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2791\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17DD}󠁣=\x{0338}｡𐹼𐋤", %p)},	undef,	"to_ascii\(\'\\u17DD\?\=\\u0338｡𐹼𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2792\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17DD}󠁣≠。𐹼𐋤", %p)},	undef,	"to_ascii\(\'\\u17DD\?\≠\。𐹼𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2793\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17DD}󠁣=\x{0338}。𐹼𐋤", %p)},	undef,	"to_ascii\(\'\\u17DD\?\=\\u0338\。𐹼𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2794\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𰀻񆬗｡𝩨🕮ß", %p)},	undef,	"to_ascii\(\'ß\?\?｡𝩨🕮ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2795\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𰀻񆬗。𝩨🕮ß", %p)},	undef,	"to_ascii\(\'ß\?\?\。𝩨🕮ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2796\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS𰀻񆬗。𝩨🕮SS", %p)},	undef,	"to_ascii\(\'SS\?\?\。𝩨🕮SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2797\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss𰀻񆬗。𝩨🕮ss", %p)},	undef,	"to_ascii\(\'ss\?\?\。𝩨🕮ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2798\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss𰀻񆬗。𝩨🕮Ss", %p)},	undef,	"to_ascii\(\'Ss\?\?\。𝩨🕮Ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2799\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS𰀻񆬗｡𝩨🕮SS", %p)},	undef,	"to_ascii\(\'SS\?\?｡𝩨🕮SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2800\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss𰀻񆬗｡𝩨🕮ss", %p)},	undef,	"to_ascii\(\'ss\?\?｡𝩨🕮ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2801\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss𰀻񆬗｡𝩨🕮Ss", %p)},	undef,	"to_ascii\(\'Ss\?\?｡𝩨🕮Ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2802\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200D\。\\u200C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:2803\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0483}𐭞\x{200D}.\x{17B9}𞯌򟩚", %p)},	undef,	"to_ascii\(\'\\u0483𐭞\\u200D\.\\u17B9\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2805\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𐠨\x{200C}临。ꡢ򄷞ⶏ𐹣", %p)},	undef,	"to_ascii\(\'\\u200C𐠨\\u200C临\。ꡢ\?ⶏ𐹣\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2807\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠑘．󠄮", %p)},	undef,	"to_ascii\(\'\?．\󠄮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2809\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠑘.󠄮", %p)},	undef,	"to_ascii\(\'\?\.\󠄮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2810\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫄\x{0D4D}．\x{AAF6}", %p)},	undef,	"to_ascii\(\'𐫄\\u0D4D．\\uAAF6\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2811\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫄\x{0D4D}.\x{AAF6}", %p)},	undef,	"to_ascii\(\'𐫄\\u0D4D\.\\uAAF6\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2812\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{A9B7}󝵙멹。⒛󠨇", %p)},	undef,	"to_ascii\(\'\\uA9B7\?멹\。⒛\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2813\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B7}󝵙멹。⒛󠨇", %p)},	undef,	"to_ascii\(\'\\uA9B7\?멹\。⒛\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2814\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B7}󝵙멹。20.󠨇", %p)},	undef,	"to_ascii\(\'\\uA9B7\?멹\。20\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2815\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B7}󝵙멹。20.󠨇", %p)},	undef,	"to_ascii\(\'\\uA9B7\?멹\。20\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2816\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_ascii\(\'Ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2817\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_ascii\(\'Ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2818\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_ascii\(\'Ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2819\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_ascii\(\'Ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2820\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_ascii\(\'ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2821\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_ascii\(\'ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2822\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_ascii\(\'ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2823\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_ascii\(\'ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2824\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}｡︒", %p)},	undef,	"to_ascii\(\'\\u200C｡︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2825\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。。", %p)},	undef,	"to_ascii\(\'\\u200C\。\。\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:2827\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯\x{076D}．₄", %p)},	undef,	"to_ascii\(\'\≯\\u076D．₄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2829\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{076D}．₄", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u076D．₄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2830\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯\x{076D}.4", %p)},	undef,	"to_ascii\(\'\≯\\u076D\.4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2831\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{076D}.4", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u076D\.4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2832\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-𝟹.ß-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-𝟹\.ß\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2833\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-3.ß-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-3\.ß\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2835\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-3.SS-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-3\.SS\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2837\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-3.ss-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-3\.ss\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2839\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-3.Ss-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-3\.Ss\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2841\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-𝟹.SS-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-𝟹\.SS\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2843\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-𝟹.ss-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-𝟹\.ss\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2845\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-𝟹.Ss-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-𝟹\.Ss\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:2847\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FD08}𝟦\x{0647}󎊯｡Ӏ", %p)},	undef,	"to_ascii\(\'\\uFD08𝟦\\u0647\?｡Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2849\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0636}\x{064A}4\x{0647}󎊯。Ӏ", %p)},	undef,	"to_ascii\(\'\\u0636\\u064A4\\u0647\?\。Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2850\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0636}\x{064A}4\x{0647}󎊯。ӏ", %p)},	undef,	"to_ascii\(\'\\u0636\\u064A4\\u0647\?\。ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2851\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FD08}𝟦\x{0647}󎊯｡ӏ", %p)},	undef,	"to_ascii\(\'\\uFD08𝟦\\u0647\?｡ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2852\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.\x{0602}\x{0622}𑆾🐹", %p)},	undef,	"to_ascii\(\'\-\.\\u0602\\u0622𑆾🐹\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2853\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.\x{0602}\x{0627}\x{0653}𑆾🐹", %p)},	undef,	"to_ascii\(\'\-\.\\u0602\\u0627\\u0653𑆾🐹\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2854\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󙶜ᢘ。\x{1A7F}⺢", %p)},	undef,	"to_ascii\(\'\?ᢘ\。\\u1A7F⺢\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2855\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠ႷᠤႫ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠ႷᠤႫ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2856\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}ႷᠤႫ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338ႷᠤႫ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2857\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠ႷᠤႫ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠ႷᠤႫ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2858\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}ႷᠤႫ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338ႷᠤႫ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2859\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2860\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2861\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠Ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠Ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2862\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}Ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338Ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2863\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2864\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2865\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠Ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠Ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2866\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}Ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338Ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ A3\ \[data\/IdnaTest\.txt\:2867\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0667}.𐥨", %p)},	undef,	"to_ascii\(\'\\u0667\.\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2868\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9C0}𝟯｡\x{200D}񼑥𐹪\x{1BF3}", %p)},	undef,	"to_ascii\(\'\\uA9C0𝟯｡\\u200D\?𐹪\\u1BF3\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:2869\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9C0}3。\x{200D}񼑥𐹪\x{1BF3}", %p)},	undef,	"to_ascii\(\'\\uA9C03\。\\u200D\?𐹪\\u1BF3\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:2871\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򣕄4񠖽.≯\x{0664}𑀾󠸌", %p)},	undef,	"to_ascii\(\'\?4\?\.\≯\\u0664𑀾\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2873\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򣕄4񠖽.>\x{0338}\x{0664}𑀾󠸌", %p)},	undef,	"to_ascii\(\'\?4\?\.\>\\u0338\\u0664𑀾\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2874\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򗆧𝟯。⒈\x{1A76}𝟚򠘌", %p)},	undef,	"to_ascii\(\'\?𝟯\。⒈\\u1A76𝟚\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2875\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򗆧3。1.\x{1A76}2򠘌", %p)},	undef,	"to_ascii\(\'\?3\。1\.\\u1A762\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2876\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}₅⒈。≯𝟴\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D₅⒈\。\≯𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2877\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}₅⒈。>\x{0338}𝟴\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D₅⒈\。\>\\u0338𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2879\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}51.。≯8\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D51\.\。\≯8\\u200D\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2881\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}51.。>\x{0338}8\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D51\.\。\>\\u03388\\u200D\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2883\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡰ\x{0697}\x{1086}．򪘙\x{072F}≠\x{200C}", %p)},	undef,	"to_ascii\(\'ꡰ\\u0697\\u1086．\?\\u072F\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2885\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡰ\x{0697}\x{1086}．򪘙\x{072F}=\x{0338}\x{200C}", %p)},	undef,	"to_ascii\(\'ꡰ\\u0697\\u1086．\?\\u072F\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2887\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡰ\x{0697}\x{1086}.򪘙\x{072F}≠\x{200C}", %p)},	undef,	"to_ascii\(\'ꡰ\\u0697\\u1086\.\?\\u072F\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2889\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡰ\x{0697}\x{1086}.򪘙\x{072F}=\x{0338}\x{200C}", %p)},	undef,	"to_ascii\(\'ꡰ\\u0697\\u1086\.\?\\u072F\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2891\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑄱｡򪌿𐹵", %p)},	undef,	"to_ascii\(\'𑄱｡\?𐹵\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2893\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑄱。򪌿𐹵", %p)},	undef,	"to_ascii\(\'𑄱\。\?𐹵\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2894\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟥\x{0600}。\x{073D}", %p)},	undef,	"to_ascii\(\'𝟥\\u0600\。\\u073D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2895\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3\x{0600}。\x{073D}", %p)},	undef,	"to_ascii\(\'3\\u0600\。\\u073D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2896\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0637}𐹣\x{0666}.\x{076D}긷", %p)},	undef,	"to_ascii\(\'\\u0637𐹣\\u0666\.\\u076D긷\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2897\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0637}𐹣\x{0666}.\x{076D}긷", %p)},	undef,	"to_ascii\(\'\\u0637𐹣\\u0666\.\\u076D긷\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2898\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("︒Ↄ\x{2DE7}򾀃．Ⴗ𐣞", %p)},	undef,	"to_ascii\(\'︒Ↄ\\u2DE7\?．Ⴗ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2899\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。Ↄ\x{2DE7}򾀃.Ⴗ𐣞", %p)},	undef,	"to_ascii\(\'\。Ↄ\\u2DE7\?\.Ⴗ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2900\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。ↄ\x{2DE7}򾀃.ⴗ𐣞", %p)},	undef,	"to_ascii\(\'\。ↄ\\u2DE7\?\.ⴗ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2901\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒ↄ\x{2DE7}򾀃．ⴗ𐣞", %p)},	undef,	"to_ascii\(\'︒ↄ\\u2DE7\?．ⴗ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2902\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0600}.\x{05B1}", %p)},	undef,	"to_ascii\(\'\\u0600\.\\u05B1\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2903\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς≯｡𐹽", %p)},	undef,	"to_ascii\(\'ς\≯｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2904\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς>\x{0338}｡𐹽", %p)},	undef,	"to_ascii\(\'ς\>\\u0338｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2905\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς≯。𐹽", %p)},	undef,	"to_ascii\(\'ς\≯\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2906\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς>\x{0338}。𐹽", %p)},	undef,	"to_ascii\(\'ς\>\\u0338\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2907\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ>\x{0338}。𐹽", %p)},	undef,	"to_ascii\(\'Σ\>\\u0338\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2908\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ≯。𐹽", %p)},	undef,	"to_ascii\(\'Σ\≯\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2909\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ≯。𐹽", %p)},	undef,	"to_ascii\(\'σ\≯\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2910\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ>\x{0338}。𐹽", %p)},	undef,	"to_ascii\(\'σ\>\\u0338\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2911\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ>\x{0338}｡𐹽", %p)},	undef,	"to_ascii\(\'Σ\>\\u0338｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2912\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ≯｡𐹽", %p)},	undef,	"to_ascii\(\'Σ\≯｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2913\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ≯｡𐹽", %p)},	undef,	"to_ascii\(\'σ\≯｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2914\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ>\x{0338}｡𐹽", %p)},	undef,	"to_ascii\(\'σ\>\\u0338｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2915\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{17D2}\x{200D}\x{075F}。𐹶", %p)},	undef,	"to_ascii\(\'\\u17D2\\u200D\\u075F\。𐹶\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2916\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𾷂\x{0A42}Ⴊ񂂟.≮", %p)},	undef,	"to_ascii\(\'\?\\u0A42Ⴊ\?\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2917\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾷂\x{0A42}Ⴊ񂂟.<\x{0338}", %p)},	undef,	"to_ascii\(\'\?\\u0A42Ⴊ\?\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2918\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾷂\x{0A42}ⴊ񂂟.<\x{0338}", %p)},	undef,	"to_ascii\(\'\?\\u0A42ⴊ\?\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2919\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾷂\x{0A42}ⴊ񂂟.≮", %p)},	undef,	"to_ascii\(\'\?\\u0A42ⴊ\?\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2920\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡠ．۲", %p)},	"xn--5c9a.xn--fmb",	"to_ascii\(\'ꡠ．۲\'\)\ \[data\/IdnaTest\.txt\:2921\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡠ.۲", %p)},	"xn--5c9a.xn--fmb",	"to_ascii\(\'ꡠ\.۲\'\)\ \[data\/IdnaTest\.txt\:2922\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("xn--5c9a.xn--fmb", %p)},	"xn--5c9a.xn--fmb",	"to_ascii\(\'xn\-\-5c9a\.xn\-\-fmb\'\)\ \[data\/IdnaTest\.txt\:2923\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐹣񄷄｡ꡬ🄄", %p)},	undef,	"to_ascii\(\'𐹣\?｡ꡬ🄄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2924\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹣񄷄。ꡬ3,", %p)},	undef,	"to_ascii\(\'𐹣\?\。ꡬ3\,\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2925\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{0C4D}𞾀𑲓｡\x{200D}\x{0D4D}", %p)},	undef,	"to_ascii\(\'\-\\u0C4D\?\?｡\\u200D\\u0D4D\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2926\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{0C4D}𞾀𑲓。\x{200D}\x{0D4D}", %p)},	undef,	"to_ascii\(\'\-\\u0C4D\?\?\。\\u200D\\u0D4D\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2928\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A67D}\x{200C}霣🄆｡\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_ascii\(\'\\uA67D\\u200C霣🄆｡\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2930\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A67D}\x{200C}霣🄆｡\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_ascii\(\'\\uA67D\\u200C霣🄆｡\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2932\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A67D}\x{200C}霣5,。\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_ascii\(\'\\uA67D\\u200C霣5\,\。\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2934\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("兎｡ᠼ󠴜𑚶𑰿", %p)},	undef,	"to_ascii\(\'兎｡ᠼ\?𑚶\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2936\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("兎。ᠼ󠴜𑚶𑰿", %p)},	undef,	"to_ascii\(\'兎\。ᠼ\?𑚶\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2937\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟙｡\x{200D}𝟸\x{200D}⁷", %p)},	"1.27",	"to_ascii\(\'𝟙｡\\u200D𝟸\\u200D⁷\'\)\ \[data\/IdnaTest\.txt\:2938\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1。\x{200D}2\x{200D}7", %p)},	"1.27",	"to_ascii\(\'1\。\\u200D2\\u200D7\'\)\ \[data\/IdnaTest\.txt\:2940\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.27", %p)},	"1.27",	"to_ascii\(\'1\.27\'\)\ \[data\/IdnaTest\.txt\:2942\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡨ-｡󠻋𝟷", %p)},	undef,	"to_ascii\(\'ᡨ\-｡\?𝟷\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2943\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡨ-。󠻋1", %p)},	undef,	"to_ascii\(\'ᡨ\-\。\?1\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2944\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰻񵀐𐫚．\x{0668}⁹", %p)},	undef,	"to_ascii\(\'\?\?𐫚．\\u0668⁹\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2945\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰻񵀐𐫚.\x{0668}9", %p)},	undef,	"to_ascii\(\'\?\?𐫚\.\\u06689\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2946\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ򈷭\x{0F80}⾇。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⴜ\?\\u0F80⾇\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2947\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ򈷭\x{0F80}舛。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⴜ\?\\u0F80舛\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2949\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴜ򈷭\x{0F80}舛。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'ⴜ\?\\u0F80舛\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2951\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴜ򈷭\x{0F80}⾇。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'ⴜ\?\\u0F80⾇\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2953\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𑁆𝟰.\x{200D}", %p)},	undef,	"to_ascii\(\'𑁆𝟰\.\\u200D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2955\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𑁆4.\x{200D}", %p)},	undef,	"to_ascii\(\'𑁆4\.\\u200D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2957\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񮴘Ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?Ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2959\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘Ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?Ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2961\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘Ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?Ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘Ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?Ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2965\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2967\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2969\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2971\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2973\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󚀅-\x{0BCD}。\x{06B9}", %p)},	undef,	"to_ascii\(\'\?\-\\u0BCD\。\\u06B9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2975\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡃ𝟧≯ᠣ．氁񨏱ꁫ", %p)},	undef,	"to_ascii\(\'ᡃ𝟧\≯ᠣ．氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2976\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡃ𝟧>\x{0338}ᠣ．氁񨏱ꁫ", %p)},	undef,	"to_ascii\(\'ᡃ𝟧\>\\u0338ᠣ．氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2977\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡃ5≯ᠣ.氁񨏱ꁫ", %p)},	undef,	"to_ascii\(\'ᡃ5\≯ᠣ\.氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2978\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡃ5>\x{0338}ᠣ.氁񨏱ꁫ", %p)},	undef,	"to_ascii\(\'ᡃ5\>\\u0338ᠣ\.氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2979\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐹬𝩇．\x{0F76}", %p)},	undef,	"to_ascii\(\'𐹬𝩇．\\u0F76\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2980\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐹬𝩇．\x{0FB2}\x{0F80}", %p)},	undef,	"to_ascii\(\'𐹬𝩇．\\u0FB2\\u0F80\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2981\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐹬𝩇.\x{0FB2}\x{0F80}", %p)},	undef,	"to_ascii\(\'𐹬𝩇\.\\u0FB2\\u0F80\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2982\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-𑈶⒏．⒎𰛢󠎭", %p)},	undef,	"to_ascii\(\'\-𑈶⒏．⒎\?\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2983\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𑈶8..7.𰛢󠎭", %p)},	undef,	"to_ascii\(\'\-𑈶8\.\.7\.\?\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2984\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴁ畝\x{200D}．≮", %p)},	undef,	"to_ascii\(\'\\u200CႡ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2985\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200CႡ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2987\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴁ畝\x{200D}.≮", %p)},	undef,	"to_ascii\(\'\\u200CႡ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2989\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200CႡ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2991\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200Cⴁ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2993\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴁ畝\x{200D}.≮", %p)},	undef,	"to_ascii\(\'\\u200Cⴁ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2995\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200Cⴁ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2997\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴁ畝\x{200D}．≮", %p)},	undef,	"to_ascii\(\'\\u200Cⴁ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2999\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("歷｡𐹻≯󳛽\x{200D}", %p)},	undef,	"to_ascii\(\'歷｡𐹻\≯\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3001\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("歷｡𐹻>\x{0338}󳛽\x{200D}", %p)},	undef,	"to_ascii\(\'歷｡𐹻\>\\u0338\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3003\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("歷。𐹻≯󳛽\x{200D}", %p)},	undef,	"to_ascii\(\'歷\。𐹻\≯\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3005\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("歷。𐹻>\x{0338}󳛽\x{200D}", %p)},	undef,	"to_ascii\(\'歷\。𐹻\>\\u0338\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3007\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0ECB}\x{200D}．鎁󠰑", %p)},	undef,	"to_ascii\(\'\\u0ECB\\u200D．鎁\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3009\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0ECB}\x{200D}.鎁󠰑", %p)},	undef,	"to_ascii\(\'\\u0ECB\\u200D\.鎁\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3011\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200C}𞤀｡𱘅𐶃", %p)},	undef,	"to_ascii\(\'\\u200D\\u200C\?｡\?\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3013\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200C}𞤀。𱘅𐶃", %p)},	undef,	"to_ascii\(\'\\u200D\\u200C\?\。\?\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3015\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠𝟫-.ς⒍𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠𝟫\-\.ς⒍𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3017\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}𝟫-.ς⒍𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u0338𝟫\-\.ς⒍𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3018\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠9-.ς6.𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠9\-\.ς6\.𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3019\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}9-.ς6.𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u03389\-\.ς6\.𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3020\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}9-.Σ6.𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u03389\-\.Σ6\.𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3021\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠9-.Σ6.𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠9\-\.Σ6\.𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3022\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠9-.σ6.𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠9\-\.σ6\.𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3023\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}9-.σ6.𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u03389\-\.σ6\.𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3024\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}𝟫-.Σ⒍𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u0338𝟫\-\.Σ⒍𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3025\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠𝟫-.Σ⒍𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠𝟫\-\.Σ⒍𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3026\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠𝟫-.σ⒍𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠𝟫\-\.σ⒍𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3027\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}𝟫-.σ⒍𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u0338𝟫\-\.σ⒍𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3028\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򉛴.-ᡢ\x{0592}𝨠", %p)},	undef,	"to_ascii\(\'\?\.\-ᡢ\\u0592𝨠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3029\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}⒈ß󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB⒈ß\󠄽\。\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3030\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}1.ß󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB1\.ß\󠄽\。\?\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3031\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}1.SS󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB1\.SS\󠄽\。\?\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3032\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}1.ss󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB1\.ss\󠄽\。\?\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3033\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}1.Ss󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB1\.Ss\󠄽\。\?\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3034\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}⒈SS󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB⒈SS\󠄽\。\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3035\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}⒈ss󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB⒈ss\󠄽\。\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3036\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}⒈Ss󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB⒈Ss\󠄽\。\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3037\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫．\x{1BAA}ςႦ\x{200D}", %p)},	undef,	"to_ascii\(\'\?．\\u1BAAςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3038\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫.\x{1BAA}ςႦ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\.\\u1BAAςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3040\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫.\x{1BAA}ςⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\.\\u1BAAςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3042\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫.\x{1BAA}ΣႦ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\.\\u1BAAΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3044\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫.\x{1BAA}σⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\.\\u1BAAσⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3046\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫.\x{1BAA}Σⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\.\\u1BAAΣⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3048\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫．\x{1BAA}ςⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?．\\u1BAAςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3050\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫．\x{1BAA}ΣႦ\x{200D}", %p)},	undef,	"to_ascii\(\'\?．\\u1BAAΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3052\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫．\x{1BAA}σⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?．\\u1BAAσⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3054\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫．\x{1BAA}Σⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?．\\u1BAAΣⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3056\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆\x{08E2}.𝈴", %p)},	undef,	"to_ascii\(\'⾆\\u08E2\.𝈴\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3058\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌\x{08E2}.𝈴", %p)},	undef,	"to_ascii\(\'舌\\u08E2\.𝈴\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3059\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⫞𐹶𖫴。⭠⒈", %p)},	undef,	"to_ascii\(\'\⫞𐹶𖫴\。\⭠⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3060\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("⫞𐹶𖫴。⭠1.", %p)},	undef,	"to_ascii\(\'\⫞𐹶𖫴\。\⭠1\.\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3061\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⒈\x{200C}\x{AAEC}︒．\x{0ACD}", %p)},	undef,	"to_ascii\(\'⒈\\u200C\\uAAEC︒．\\u0ACD\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3062\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("1.\x{200C}\x{AAEC}。.\x{0ACD}", %p)},	undef,	"to_ascii\(\'1\.\\u200C\\uAAEC\。\.\\u0ACD\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:3064\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0C46}。䰀\x{0668}𞭅󠅼", %p)},	undef,	"to_ascii\(\'\\u0C46\。䰀\\u0668\?\󠅼\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3066\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_ascii\(\'ß\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3067\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_ascii\(\'SS\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3069\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_ascii\(\'ss\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3071\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_ascii\(\'Ss\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3073\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑓂\x{200C}≮.≮", %p)},	undef,	"to_ascii\(\'𑓂\\u200C\≮\.\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3075\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑓂\x{200C}<\x{0338}.<\x{0338}", %p)},	undef,	"to_ascii\(\'𑓂\\u200C\<\\u0338\.\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3076\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🕼．\x{FFA0}", %p)},	undef,	"to_ascii\(\'🕼．\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3077\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🕼.\x{1160}", %p)},	undef,	"to_ascii\(\'🕼\.\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3078\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡔ\x{FD82}。񷘎", %p)},	undef,	"to_ascii\(\'ᡔ\\uFD82\。\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3079\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡔ\x{0644}\x{062D}\x{0649}。񷘎", %p)},	undef,	"to_ascii\(\'ᡔ\\u0644\\u062D\\u0649\。\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3080\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("爕򳙑．𝟰気", %p)},	undef,	"to_ascii\(\'爕\?．𝟰気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3081\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("爕򳙑.4気", %p)},	undef,	"to_ascii\(\'爕\?\.4気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3082\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒋𑍍Ⴝ-．𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_ascii\(\'⒋𑍍Ⴝ\-．\?\\u0DCA\\u05B5\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3083\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4.𑍍Ⴝ-.𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_ascii\(\'4\.𑍍Ⴝ\-\.\?\\u0DCA\\u05B5\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3084\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4.𑍍ⴝ-.𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_ascii\(\'4\.𑍍ⴝ\-\.\?\\u0DCA\\u05B5\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3085\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒋𑍍ⴝ-．𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_ascii\(\'⒋𑍍ⴝ\-．\?\\u0DCA\\u05B5\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3086\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󞝃。򑆃񉢗--", %p)},	undef,	"to_ascii\(\'\?\。\?\?\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ \[data\/IdnaTest\.txt\:3087\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}\x{07DF}｡\x{200C}\x{ABED}", %p)},	undef,	"to_ascii\(\'\\u200D\\u07DF｡\\u200C\\uABED\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3088\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}\x{07DF}。\x{200C}\x{ABED}", %p)},	undef,	"to_ascii\(\'\\u200D\\u07DF\。\\u200C\\uABED\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3090\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞮽\x{07FF}\x{084E}｡ᢍ򝹁𐫘", %p)},	undef,	"to_ascii\(\'\?\\u07FF\\u084E｡ᢍ\?𐫘\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3092\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮽\x{07FF}\x{084E}。ᢍ򝹁𐫘", %p)},	undef,	"to_ascii\(\'\?\\u07FF\\u084E\。ᢍ\?𐫘\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3093\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06ED}𞺌𑄚\x{1714}.ꡞ\x{08B7}", %p)},	undef,	"to_ascii\(\'\\u06ED𞺌𑄚\\u1714\.ꡞ\\u08B7\'\)\ throws\ error\ V5\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:3094\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06ED}\x{0645}𑄚\x{1714}.ꡞ\x{08B7}", %p)},	undef,	"to_ascii\(\'\\u06ED\\u0645𑄚\\u1714\.ꡞ\\u08B7\'\)\ throws\ error\ V5\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:3095\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡ς\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡ς\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3096\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡ς\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡ς\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3097\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。ς\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。ς\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3098\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。ς\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。ς\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3099\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}Σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063CΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3100\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}Σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063CΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3101\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3102\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3103\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3104\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3105\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3106\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3107\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3108\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3109\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}Σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063CΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3110\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}Σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063CΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3111\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3112\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3113\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3114\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3115\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3116\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3117\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3118\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3119\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蔰。󠁹\x{08DD}-𑈵", %p)},	undef,	"to_ascii\(\'蔰\。\?\\u08DD\-𑈵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3120\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ςჅ。\x{075A}", %p)},	undef,	"to_ascii\(\'ςჅ\。\\u075A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3121\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ςⴥ。\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'ςⴥ\。\\u075A\'\)\ \[data\/IdnaTest\.txt\:3122\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ΣჅ。\x{075A}", %p)},	undef,	"to_ascii\(\'ΣჅ\。\\u075A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3124\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("σⴥ。\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'σⴥ\。\\u075A\'\)\ \[data\/IdnaTest\.txt\:3125\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("Σⴥ。\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'Σⴥ\。\\u075A\'\)\ \[data\/IdnaTest\.txt\:3126\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--4xa203s.xn--epb", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'xn\-\-4xa203s\.xn\-\-epb\'\)\ \[data\/IdnaTest\.txt\:3127\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("σⴥ.\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'σⴥ\.\\u075A\'\)\ \[data\/IdnaTest\.txt\:3128\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ΣჅ.\x{075A}", %p)},	undef,	"to_ascii\(\'ΣჅ\.\\u075A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3129\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("Σⴥ.\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'Σⴥ\.\\u075A\'\)\ \[data\/IdnaTest\.txt\:3130\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--3xa403s.xn--epb", %p)},	"xn--3xa403s.xn--epb",	"to_ascii\(\'xn\-\-3xa403s\.xn\-\-epb\'\)\ \[data\/IdnaTest\.txt\:3131\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ςⴥ.\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'ςⴥ\.\\u075A\'\)\ \[data\/IdnaTest\.txt\:3132\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0C4D}Ⴉ𞰓．\x{1B72}", %p)},	undef,	"to_ascii\(\'\\u0C4DႩ\?．\\u1B72\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3134\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C4D}Ⴉ𞰓.\x{1B72}", %p)},	undef,	"to_ascii\(\'\\u0C4DႩ\?\.\\u1B72\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3135\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C4D}ⴉ𞰓.\x{1B72}", %p)},	undef,	"to_ascii\(\'\\u0C4Dⴉ\?\.\\u1B72\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3136\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C4D}ⴉ𞰓．\x{1B72}", %p)},	undef,	"to_ascii\(\'\\u0C4Dⴉ\?．\\u1B72\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3137\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⮷≮񎈴󠄟。𐠄", %p)},	undef,	"to_ascii\(\'\⮷\≮\?\󠄟\。𐠄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3138\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⮷<\x{0338}񎈴󠄟。𐠄", %p)},	undef,	"to_ascii\(\'\⮷\<\\u0338\?\󠄟\。𐠄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3139\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}｡\x{200D}ẏ\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC｡\\u200Dẏ\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:3140\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}｡\x{200D}y\x{0307}\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC｡\\u200Dy\\u0307\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:3142\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}。\x{200D}ẏ\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\。\\u200Dẏ\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:3144\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}。\x{200D}y\x{0307}\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\。\\u200Dy\\u0307\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:3146\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}。\x{200D}Y\x{0307}\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\。\\u200DY\\u0307\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:3148\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}。\x{200D}Ẏ\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\。\\u200DẎ\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:3150\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vkb.xn--08e172a", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'xn\-\-vkb\.xn\-\-08e172a\'\)\ \[data\/IdnaTest\.txt\:3152\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}.ẏᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\.ẏᡤ\'\)\ \[data\/IdnaTest\.txt\:3153\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}.y\x{0307}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\.y\\u0307ᡤ\'\)\ \[data\/IdnaTest\.txt\:3154\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}.Y\x{0307}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\.Y\\u0307ᡤ\'\)\ \[data\/IdnaTest\.txt\:3155\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}.Ẏᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\.Ẏᡤ\'\)\ \[data\/IdnaTest\.txt\:3156\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}｡\x{200D}Y\x{0307}\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC｡\\u200DY\\u0307\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:3157\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}｡\x{200D}Ẏ\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC｡\\u200DẎ\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:3159\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹹𑲛。񑂐\x{0DCA}", %p)},	undef,	"to_ascii\(\'𐹹\?\。\?\\u0DCA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≠𑈵｡嵕\x{FEF1}۴\x{A953}", %p)},	undef,	"to_ascii\(\'\-\≠𑈵｡嵕\\uFEF1۴\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3162\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-=\x{0338}𑈵｡嵕\x{FEF1}۴\x{A953}", %p)},	undef,	"to_ascii\(\'\-\=\\u0338𑈵｡嵕\\uFEF1۴\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3163\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≠𑈵。嵕\x{064A}۴\x{A953}", %p)},	undef,	"to_ascii\(\'\-\≠𑈵\。嵕\\u064A۴\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3164\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-=\x{0338}𑈵。嵕\x{064A}۴\x{A953}", %p)},	undef,	"to_ascii\(\'\-\=\\u0338𑈵\。嵕\\u064A۴\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3165\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񍸰𐹶\x{076E}．\x{06C1}\x{200D}≯\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹶\\u076E．\\u06C1\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B3\ \[data\/IdnaTest\.txt\:3166\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񍸰𐹶\x{076E}．\x{06C1}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹶\\u076E．\\u06C1\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B3\ \[data\/IdnaTest\.txt\:3168\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񍸰𐹶\x{076E}.\x{06C1}\x{200D}≯\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹶\\u076E\.\\u06C1\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B3\ \[data\/IdnaTest\.txt\:3170\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񍸰𐹶\x{076E}.\x{06C1}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹶\\u076E\.\\u06C1\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B3\ \[data\/IdnaTest\.txt\:3172\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮．\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_ascii\(\'\≮．\\u17B5\\u0855𐫔\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3174\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}．\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_ascii\(\'\<\\u0338．\\u17B5\\u0855𐫔\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3175\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮.\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_ascii\(\'\≮\.\\u17B5\\u0855𐫔\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3176\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}.\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_ascii\(\'\<\\u0338\.\\u17B5\\u0855𐫔\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3177\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐩗\x{200D}｡ႩႵ", %p)},	undef,	"to_ascii\(\'𐩗\\u200D｡ႩႵ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3178\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐩗\x{200D}。ႩႵ", %p)},	undef,	"to_ascii\(\'𐩗\\u200D\。ႩႵ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3180\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐩗\x{200D}。ⴉⴕ", %p)},	"xn--pt9c.xn--0kjya",	"to_ascii\(\'𐩗\\u200D\。ⴉⴕ\'\)\ \[data\/IdnaTest\.txt\:3182\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐩗\x{200D}。Ⴉⴕ", %p)},	undef,	"to_ascii\(\'𐩗\\u200D\。Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3184\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--pt9c.xn--0kjya", %p)},	"xn--pt9c.xn--0kjya",	"to_ascii\(\'xn\-\-pt9c\.xn\-\-0kjya\'\)\ \[data\/IdnaTest\.txt\:3186\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐩗.ⴉⴕ", %p)},	"xn--pt9c.xn--0kjya",	"to_ascii\(\'𐩗\.ⴉⴕ\'\)\ \[data\/IdnaTest\.txt\:3187\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐩗.ႩႵ", %p)},	undef,	"to_ascii\(\'𐩗\.ႩႵ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3188\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐩗.Ⴉⴕ", %p)},	undef,	"to_ascii\(\'𐩗\.Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3189\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐩗\x{200D}｡ⴉⴕ", %p)},	"xn--pt9c.xn--0kjya",	"to_ascii\(\'𐩗\\u200D｡ⴉⴕ\'\)\ \[data\/IdnaTest\.txt\:3190\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐩗\x{200D}｡Ⴉⴕ", %p)},	undef,	"to_ascii\(\'𐩗\\u200D｡Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3192\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}ㄤ．\x{032E}󕨑\x{09C2}", %p)},	undef,	"to_ascii\(\'\\u200C\\u200Cㄤ．\\u032E\?\\u09C2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3194\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}ㄤ.\x{032E}󕨑\x{09C2}", %p)},	undef,	"to_ascii\(\'\\u200C\\u200Cㄤ\.\\u032E\?\\u09C2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3196\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋻｡-\x{200C}𐫄Ⴗ", %p)},	undef,	"to_ascii\(\'𐋻｡\-\\u200C𐫄Ⴗ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3198\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋻。-\x{200C}𐫄Ⴗ", %p)},	undef,	"to_ascii\(\'𐋻\。\-\\u200C𐫄Ⴗ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3200\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋻。-\x{200C}𐫄ⴗ", %p)},	undef,	"to_ascii\(\'𐋻\。\-\\u200C𐫄ⴗ\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:3202\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋻｡-\x{200C}𐫄ⴗ", %p)},	undef,	"to_ascii\(\'𐋻｡\-\\u200C𐫄ⴗ\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:3204\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("🙑𐷺．≠\x{200C}", %p)},	undef,	"to_ascii\(\'🙑\?．\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3206\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🙑𐷺．=\x{0338}\x{200C}", %p)},	undef,	"to_ascii\(\'🙑\?．\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3208\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🙑𐷺.≠\x{200C}", %p)},	undef,	"to_ascii\(\'🙑\?\.\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3210\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🙑𐷺.=\x{0338}\x{200C}", %p)},	undef,	"to_ascii\(\'🙑\?\.\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3212\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{064C}\x{1CD2}｡𞮞\x{2D7F}⧎", %p)},	undef,	"to_ascii\(\'\\u064C\\u1CD2｡\?\\u2D7F\⧎\'\)\ throws\ error\ P1\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:3214\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{064C}\x{1CD2}。𞮞\x{2D7F}⧎", %p)},	undef,	"to_ascii\(\'\\u064C\\u1CD2\。\?\\u2D7F\⧎\'\)\ throws\ error\ P1\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:3215\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔ𝨨₃󠁦．𝟳𑂹\x{0B82}", %p)},	undef,	"to_ascii\(\'Ⴔ𝨨₃\?．𝟳𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3216\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔ𝨨3󠁦.7𑂹\x{0B82}", %p)},	undef,	"to_ascii\(\'Ⴔ𝨨3\?\.7𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3217\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴔ𝨨3󠁦.7𑂹\x{0B82}", %p)},	undef,	"to_ascii\(\'ⴔ𝨨3\?\.7𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴔ𝨨₃󠁦．𝟳𑂹\x{0B82}", %p)},	undef,	"to_ascii\(\'ⴔ𝨨₃\?．𝟳𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3219\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䏈\x{200C}。\x{200C}⒈񱢕", %p)},	undef,	"to_ascii\(\'䏈\\u200C\。\\u200C⒈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3220\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䏈\x{200C}。\x{200C}1.񱢕", %p)},	undef,	"to_ascii\(\'䏈\\u200C\。\\u200C1\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3222\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("１\x{AAF6}ß𑲥｡\x{1DD8}", %p)},	undef,	"to_ascii\(\'１\\uAAF6ß\?｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3224\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1\x{AAF6}ß𑲥。\x{1DD8}", %p)},	undef,	"to_ascii\(\'1\\uAAF6ß\?\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3225\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1\x{AAF6}SS𑲥。\x{1DD8}", %p)},	undef,	"to_ascii\(\'1\\uAAF6SS\?\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3226\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1\x{AAF6}ss𑲥。\x{1DD8}", %p)},	undef,	"to_ascii\(\'1\\uAAF6ss\?\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3227\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1\x{AAF6}Ss𑲥。\x{1DD8}", %p)},	undef,	"to_ascii\(\'1\\uAAF6Ss\?\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3228\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("１\x{AAF6}SS𑲥｡\x{1DD8}", %p)},	undef,	"to_ascii\(\'１\\uAAF6SS\?｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3229\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("１\x{AAF6}ss𑲥｡\x{1DD8}", %p)},	undef,	"to_ascii\(\'１\\uAAF6ss\?｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3230\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("１\x{AAF6}Ss𑲥｡\x{1DD8}", %p)},	undef,	"to_ascii\(\'１\\uAAF6Ss\?｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3231\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}񫶩𞪯\x{0CCD}｡\x{077C}⒈", %p)},	undef,	"to_ascii\(\'\\u200D\?\?\\u0CCD｡\\u077C⒈\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3232\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񫶩𞪯\x{0CCD}。\x{077C}1.", %p)},	undef,	"to_ascii\(\'\\u200D\?\?\\u0CCD\。\\u077C1\.\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3234\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1AB6}．𞤳򓢖򻉒\x{07D7}", %p)},	undef,	"to_ascii\(\'\\u1AB6．\?\?\?\\u07D7\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:3236\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1AB6}.𞤳򓢖򻉒\x{07D7}", %p)},	undef,	"to_ascii\(\'\\u1AB6\.\?\?\?\\u07D7\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:3237\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0842}𞩚⒈．󠬌８򏳏\x{0770}", %p)},	undef,	"to_ascii\(\'\\u0842\?⒈．\?８\?\\u0770\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3238\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0842}𞩚1..󠬌8򏳏\x{0770}", %p)},	undef,	"to_ascii\(\'\\u0842\?1\.\.\?8\?\\u0770\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3239\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0361}𐫫\x{0369}ᡷ。-󠰛鞰", %p)},	undef,	"to_ascii\(\'\\u0361𐫫\\u0369ᡷ\。\-\?鞰\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3240\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-.\x{0ACD}剘ß𐫃", %p)},	undef,	"to_ascii\(\'\-\.\\u0ACD剘ß𐫃\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3241\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-.\x{0ACD}剘SS𐫃", %p)},	undef,	"to_ascii\(\'\-\.\\u0ACD剘SS𐫃\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3242\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-.\x{0ACD}剘ss𐫃", %p)},	undef,	"to_ascii\(\'\-\.\\u0ACD剘ss𐫃\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3243\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-.\x{0ACD}剘Ss𐫃", %p)},	undef,	"to_ascii\(\'\-\.\\u0ACD剘Ss𐫃\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3244\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{08FB}𞵸｡-", %p)},	undef,	"to_ascii\(\'\\u08FB\?｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3245\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08FB}𞵸。-", %p)},	undef,	"to_ascii\(\'\\u08FB\?\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3246\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈󠈻𐹲｡≠\x{0603}𐹽", %p)},	undef,	"to_ascii\(\'⒈\?𐹲｡\≠\\u0603𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3247\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈󠈻𐹲｡=\x{0338}\x{0603}𐹽", %p)},	undef,	"to_ascii\(\'⒈\?𐹲｡\=\\u0338\\u0603𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3248\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.󠈻𐹲。≠\x{0603}𐹽", %p)},	undef,	"to_ascii\(\'1\.\?𐹲\。\≠\\u0603𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3249\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.󠈻𐹲。=\x{0338}\x{0603}𐹽", %p)},	undef,	"to_ascii\(\'1\.\?𐹲\。\=\\u0338\\u0603𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3250\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹢󠈚Ⴎ\x{200C}.㖾𐹡", %p)},	undef,	"to_ascii\(\'𐹢\?Ⴎ\\u200C\.㖾𐹡\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:3251\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹢󠈚ⴎ\x{200C}.㖾𐹡", %p)},	undef,	"to_ascii\(\'𐹢\?ⴎ\\u200C\.㖾𐹡\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:3253\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗．\x{07C7}ᡖႳႧ", %p)},	undef,	"to_ascii\(\'\?．\\u07C7ᡖႳႧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3255\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗.\x{07C7}ᡖႳႧ", %p)},	undef,	"to_ascii\(\'\?\.\\u07C7ᡖႳႧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3256\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗.\x{07C7}ᡖⴓⴇ", %p)},	undef,	"to_ascii\(\'\?\.\\u07C7ᡖⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3257\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗.\x{07C7}ᡖႳⴇ", %p)},	undef,	"to_ascii\(\'\?\.\\u07C7ᡖႳⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3258\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗．\x{07C7}ᡖⴓⴇ", %p)},	undef,	"to_ascii\(\'\?．\\u07C7ᡖⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3259\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗．\x{07C7}ᡖႳⴇ", %p)},	undef,	"to_ascii\(\'\?．\\u07C7ᡖႳⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3260\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}􅍉.\x{06B3}\x{0775}", %p)},	undef,	"to_ascii\(\'\\u200D\?\.\\u06B3\\u0775\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3261\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲤱⒛⾳．ꡦ⒈", %p)},	undef,	"to_ascii\(\'\?⒛⾳．ꡦ⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3263\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲤱20.音.ꡦ1.", %p)},	undef,	"to_ascii\(\'\?20\.音\.ꡦ1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3264\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07DC}８񳦓-｡򞲙𑁿𐩥\x{09CD}", %p)},	undef,	"to_ascii\(\'\\u07DC８\?\-｡\?𑁿𐩥\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3265\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07DC}8񳦓-。򞲙𑁿𐩥\x{09CD}", %p)},	undef,	"to_ascii\(\'\\u07DC8\?\-\。\?𑁿𐩥\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3266\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰≮ß\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\≮ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3267\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰<\x{0338}ß\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\<\\u0338ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3268\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴕ。۰<\x{0338}ß\x{0745}", %p)},	undef,	"to_ascii\(\'ⴕ\。۰\<\\u0338ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3269\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴕ。۰≮ß\x{0745}", %p)},	undef,	"to_ascii\(\'ⴕ\。۰\≮ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3270\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰≮SS\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\≮SS\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3271\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰<\x{0338}SS\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\<\\u0338SS\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3272\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴕ。۰<\x{0338}ss\x{0745}", %p)},	undef,	"to_ascii\(\'ⴕ\。۰\<\\u0338ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3273\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴕ。۰≮ss\x{0745}", %p)},	undef,	"to_ascii\(\'ⴕ\。۰\≮ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3274\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰≮Ss\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\≮Ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3275\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰<\x{0338}Ss\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\<\\u0338Ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3276\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{07E9}-.𝨗꒱\x{1B72}", %p)},	undef,	"to_ascii\(\'\\u07E9\-\.𝨗꒱\\u1B72\'\)\ throws\ error\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:3277\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞼸\x{200C}.≯䕵⫧", %p)},	undef,	"to_ascii\(\'\?\\u200C\.\≯䕵\⫧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3278\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞼸\x{200C}.>\x{0338}䕵⫧", %p)},	undef,	"to_ascii\(\'\?\\u200C\.\>\\u0338䕵\⫧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3280\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨅ß\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_ascii\(\'𐨅ß\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3282\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐨅ß\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_ascii\(\'𐨅ß\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3283\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐨅SS\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_ascii\(\'𐨅SS\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3284\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐨅ss\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_ascii\(\'𐨅ss\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3285\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐨅Ss\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_ascii\(\'𐨅Ss\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3286\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐨅SS\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_ascii\(\'𐨅SS\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3287\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨅ss\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_ascii\(\'𐨅ss\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3288\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨅Ss\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_ascii\(\'𐨅Ss\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3289\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≮🡒\x{1CED}.񏿾Ⴁ\x{0714}", %p)},	undef,	"to_ascii\(\'\-\≮🡒\\u1CED\.\?Ⴁ\\u0714\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3290\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-<\x{0338}🡒\x{1CED}.񏿾Ⴁ\x{0714}", %p)},	undef,	"to_ascii\(\'\-\<\\u0338🡒\\u1CED\.\?Ⴁ\\u0714\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3291\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-<\x{0338}🡒\x{1CED}.񏿾ⴁ\x{0714}", %p)},	undef,	"to_ascii\(\'\-\<\\u0338🡒\\u1CED\.\?ⴁ\\u0714\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3292\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≮🡒\x{1CED}.񏿾ⴁ\x{0714}", %p)},	undef,	"to_ascii\(\'\-\≮🡒\\u1CED\.\?ⴁ\\u0714\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3293\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤨｡ꡏ\x{200D}\x{200C}", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'\?｡ꡏ\\u200D\\u200C\'\)\ \[data\/IdnaTest\.txt\:3294\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤨。ꡏ\x{200D}\x{200C}", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'\?\。ꡏ\\u200D\\u200C\'\)\ \[data\/IdnaTest\.txt\:3296\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--ge6h.xn--oc9a", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'xn\-\-ge6h\.xn\-\-oc9a\'\)\ \[data\/IdnaTest\.txt\:3298\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤨.ꡏ", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'\?\.ꡏ\'\)\ \[data\/IdnaTest\.txt\:3299\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("󠅹𑂶．ᢌ𑂹\x{0669}", %p)},	undef,	"to_ascii\(\'\󠅹𑂶．ᢌ𑂹\\u0669\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3300\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("󠅹𑂶.ᢌ𑂹\x{0669}", %p)},	undef,	"to_ascii\(\'\󠅹𑂶\.ᢌ𑂹\\u0669\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3301\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⅎ󠅺񝵒。≯⾑", %p)},	undef,	"to_ascii\(\'Ⅎ\󠅺\?\。\≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3302\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ󠅺񝵒。>\x{0338}⾑", %p)},	undef,	"to_ascii\(\'Ⅎ\󠅺\?\。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3303\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ󠅺񝵒。≯襾", %p)},	undef,	"to_ascii\(\'Ⅎ\󠅺\?\。\≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3304\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ󠅺񝵒。>\x{0338}襾", %p)},	undef,	"to_ascii\(\'Ⅎ\󠅺\?\。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3305\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ󠅺񝵒。>\x{0338}襾", %p)},	undef,	"to_ascii\(\'ⅎ\󠅺\?\。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3306\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ󠅺񝵒。≯襾", %p)},	undef,	"to_ascii\(\'ⅎ\󠅺\?\。\≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3307\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ󠅺񝵒。>\x{0338}⾑", %p)},	undef,	"to_ascii\(\'ⅎ\󠅺\?\。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3308\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ󠅺񝵒。≯⾑", %p)},	undef,	"to_ascii\(\'ⅎ\󠅺\?\。\≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3309\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_ascii\(\'ς\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3310\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_ascii\(\'ς\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3312\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_ascii\(\'Σ\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3314\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_ascii\(\'σ\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3316\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_ascii\(\'Σ\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3318\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_ascii\(\'σ\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3320\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.ßႩ-", %p)},	undef,	"to_ascii\(\'\\u200C\.ßႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3322\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}.ßⴉ-", %p)},	undef,	"to_ascii\(\'\\u200C\.ßⴉ\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3324\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}.SSႩ-", %p)},	undef,	"to_ascii\(\'\\u200C\.SSႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3326\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}.ssⴉ-", %p)},	undef,	"to_ascii\(\'\\u200C\.ssⴉ\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3328\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}.Ssⴉ-", %p)},	undef,	"to_ascii\(\'\\u200C\.Ssⴉ\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3330\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󍭲𐫍㓱。⾑", %p)},	undef,	"to_ascii\(\'\?𐫍㓱\。⾑\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3332\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󍭲𐫍㓱。襾", %p)},	undef,	"to_ascii\(\'\?𐫍㓱\。襾\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3333\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06A0}𐮋𐹰≮。≯󠦗\x{200D}", %p)},	undef,	"to_ascii\(\'\\u06A0𐮋𐹰\≮\。\≯\?\\u200D\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3334\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06A0}𐮋𐹰<\x{0338}。>\x{0338}󠦗\x{200D}", %p)},	undef,	"to_ascii\(\'\\u06A0𐮋𐹰\<\\u0338\。\>\\u0338\?\\u200D\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3336\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟞｡񃰶\x{0777}\x{08B0}⩋", %p)},	undef,	"to_ascii\(\'𝟞｡\?\\u0777\\u08B0\⩋\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3338\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6。񃰶\x{0777}\x{08B0}⩋", %p)},	undef,	"to_ascii\(\'6\。\?\\u0777\\u08B0\⩋\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3339\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-\x{FCFD}。𑇀𑍴", %p)},	undef,	"to_ascii\(\'\-\\uFCFD\。𑇀𑍴\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3340\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-\x{FCFD}。𑇀𑍴", %p)},	undef,	"to_ascii\(\'\-\\uFCFD\。𑇀𑍴\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3341\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-\x{0634}\x{0649}。𑇀𑍴", %p)},	undef,	"to_ascii\(\'\-\\u0634\\u0649\。𑇀𑍴\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3342\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}󠊶𝟏.\x{0D43}򪥐𐹬󊓶", %p)},	undef,	"to_ascii\(\'\\u200C\?𝟏\.\\u0D43\?𐹬\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3343\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠊶1.\x{0D43}򪥐𐹬󊓶", %p)},	undef,	"to_ascii\(\'\\u200C\?1\.\\u0D43\?𐹬\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3345\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--𝟰.ß", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-𝟰\.ß\'\)\ \[data\/IdnaTest\.txt\:3347\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--4.ß", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-4\.ß\'\)\ \[data\/IdnaTest\.txt\:3349\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--4.SS", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-4\.SS\'\)\ \[data\/IdnaTest\.txt\:3351\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----4-p16k.ss", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'xn\-\-\-\-4\-p16k\.ss\'\)\ \[data\/IdnaTest\.txt\:3352\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----4-p16k.xn--zca", %p)},	"xn----4-p16k.xn--zca",	"to_ascii\(\'xn\-\-\-\-4\-p16k\.xn\-\-zca\'\)\ \[data\/IdnaTest\.txt\:3353\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--𝟰.SS", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-𝟰\.SS\'\)\ \[data\/IdnaTest\.txt\:3354\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{1BF2}.𐹢𞀖\x{200C}", %p)},	undef,	"to_ascii\(\'\\u1BF2\.𐹢\?\\u200C\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3355\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󃲙󠋘｡\x{DEDE}-\x{200D}", %p)},	undef,	"to_ascii\(\'\?\?｡\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ A3\ \[data\/IdnaTest\.txt\:3357\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󃲙󠋘。\x{DEDE}-\x{200D}", %p)},	undef,	"to_ascii\(\'\?\?\。\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ A3\ \[data\/IdnaTest\.txt\:3359\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1A60}．𞵷-𝪩悎", %p)},	undef,	"to_ascii\(\'\\u1A60．\?\-𝪩悎\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3361\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1A60}.𞵷-𝪩悎", %p)},	undef,	"to_ascii\(\'\\u1A60\.\?\-𝪩悎\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3362\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𛜯󠊛．𞤳񏥾", %p)},	undef,	"to_ascii\(\'\?\?．\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3363\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𛜯󠊛.𞤳񏥾", %p)},	undef,	"to_ascii\(\'\?\?\.\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3364\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{071C}𐫒\x{062E}.𐋲", %p)},	"xn--tgb98b8643d.xn--m97c",	"to_ascii\(\'\\u071C𐫒\\u062E\.𐋲\'\)\ \[data\/IdnaTest\.txt\:3365\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--tgb98b8643d.xn--m97c", %p)},	"xn--tgb98b8643d.xn--m97c",	"to_ascii\(\'xn\-\-tgb98b8643d\.xn\-\-m97c\'\)\ \[data\/IdnaTest\.txt\:3366\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐼑𞤓\x{0637}\x{08E2}.\x{DF56}", %p)},	undef,	"to_ascii\(\'\?\?\\u0637\\u08E2\.\\uDF56\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3367\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ↄ。\x{0A4D}\x{1CD4}𞷣", %p)},	undef,	"to_ascii\(\'Ↄ\。\\u0A4D\\u1CD4\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3368\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ↄ。\x{1CD4}\x{0A4D}𞷣", %p)},	undef,	"to_ascii\(\'Ↄ\。\\u1CD4\\u0A4D\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3369\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ↄ。\x{1CD4}\x{0A4D}𞷣", %p)},	undef,	"to_ascii\(\'ↄ\。\\u1CD4\\u0A4D\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3370\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ↄ。\x{0A4D}\x{1CD4}𞷣", %p)},	undef,	"to_ascii\(\'ↄ\。\\u0A4D\\u1CD4\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3371\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠪢-。򛂏≮𑜫", %p)},	undef,	"to_ascii\(\'\?\-\。\?\≮𑜫\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3372\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠪢-。򛂏<\x{0338}𑜫", %p)},	undef,	"to_ascii\(\'\?\-\。\?\<\\u0338𑜫\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3373\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠉹\x{200D}。򌿧≮Ⴉ", %p)},	undef,	"to_ascii\(\'\\u200C\?\\u200D\。\?\≮Ⴉ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3374\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠉹\x{200D}。򌿧<\x{0338}Ⴉ", %p)},	undef,	"to_ascii\(\'\\u200C\?\\u200D\。\?\<\\u0338Ⴉ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3376\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠉹\x{200D}。򌿧<\x{0338}ⴉ", %p)},	undef,	"to_ascii\(\'\\u200C\?\\u200D\。\?\<\\u0338ⴉ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3378\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠉹\x{200D}。򌿧≮ⴉ", %p)},	undef,	"to_ascii\(\'\\u200C\?\\u200D\。\?\≮ⴉ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3380\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹯-𑄴\x{08BC}。︒䖐⾆", %p)},	undef,	"to_ascii\(\'𐹯\-𑄴\\u08BC\。︒䖐⾆\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3382\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹯-𑄴\x{08BC}。。䖐舌", %p)},	undef,	"to_ascii\(\'𐹯\-𑄴\\u08BC\。\。䖐舌\'\)\ throws\ error\ B1\ A4_2\ \[data\/IdnaTest\.txt\:3383\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𝪞Ⴐ｡쪡", %p)},	undef,	"to_ascii\(\'𝪞Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3384\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪞Ⴐ｡쪡", %p)},	undef,	"to_ascii\(\'𝪞Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪞Ⴐ。쪡", %p)},	undef,	"to_ascii\(\'𝪞Ⴐ\。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3386\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪞Ⴐ。쪡", %p)},	undef,	"to_ascii\(\'𝪞Ⴐ\。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3387\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝪞ⴐ。쪡", %p)},	undef,	"to_ascii\(\'𝪞ⴐ\。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3388\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝪞ⴐ。쪡", %p)},	undef,	"to_ascii\(\'𝪞ⴐ\。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3389\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝪞ⴐ｡쪡", %p)},	undef,	"to_ascii\(\'𝪞ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3390\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝪞ⴐ｡쪡", %p)},	undef,	"to_ascii\(\'𝪞ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3391\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0E3A}쩁𐹬.􋉳", %p)},	undef,	"to_ascii\(\'\\u0E3A쩁𐹬\.\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3392\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0E3A}쩁𐹬.􋉳", %p)},	undef,	"to_ascii\(\'\\u0E3A쩁𐹬\.\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3393\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡅ０\x{200C}｡⎢󤨄", %p)},	undef,	"to_ascii\(\'ᡅ０\\u200C｡\⎢\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3394\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡅ0\x{200C}。⎢󤨄", %p)},	undef,	"to_ascii\(\'ᡅ0\\u200C\。\⎢\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3396\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚９ꍩ\x{17D3}．\x{200D}ß", %p)},	undef,	"to_ascii\(\'\?９ꍩ\\u17D3．\\u200Dß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3398\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚9ꍩ\x{17D3}.\x{200D}ß", %p)},	undef,	"to_ascii\(\'\?9ꍩ\\u17D3\.\\u200Dß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3400\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚9ꍩ\x{17D3}.\x{200D}SS", %p)},	undef,	"to_ascii\(\'\?9ꍩ\\u17D3\.\\u200DSS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3402\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚9ꍩ\x{17D3}.\x{200D}ss", %p)},	undef,	"to_ascii\(\'\?9ꍩ\\u17D3\.\\u200Dss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3404\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚9ꍩ\x{17D3}.\x{200D}Ss", %p)},	undef,	"to_ascii\(\'\?9ꍩ\\u17D3\.\\u200DSs\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3406\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚９ꍩ\x{17D3}．\x{200D}SS", %p)},	undef,	"to_ascii\(\'\?９ꍩ\\u17D3．\\u200DSS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3408\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚９ꍩ\x{17D3}．\x{200D}ss", %p)},	undef,	"to_ascii\(\'\?９ꍩ\\u17D3．\\u200Dss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3410\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚９ꍩ\x{17D3}．\x{200D}Ss", %p)},	undef,	"to_ascii\(\'\?９ꍩ\\u17D3．\\u200DSs\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3412\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ꗷ𑆀.\x{075D}𐩒", %p)},	"xn--ju8a625r.xn--hpb0073k",	"to_ascii\(\'ꗷ𑆀\.\\u075D𐩒\'\)\ \[data\/IdnaTest\.txt\:3414\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("xn--ju8a625r.xn--hpb0073k", %p)},	"xn--ju8a625r.xn--hpb0073k",	"to_ascii\(\'xn\-\-ju8a625r\.xn\-\-hpb0073k\'\)\ \[data\/IdnaTest\.txt\:3415\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⒐≯-。︒򩑣-񞛠", %p)},	undef,	"to_ascii\(\'⒐\≯\-\。︒\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3416\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒐>\x{0338}-。︒򩑣-񞛠", %p)},	undef,	"to_ascii\(\'⒐\>\\u0338\-\。︒\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.≯-。。򩑣-񞛠", %p)},	undef,	"to_ascii\(\'9\.\≯\-\。\。\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3418\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.>\x{0338}-。。򩑣-񞛠", %p)},	undef,	"to_ascii\(\'9\.\>\\u0338\-\。\。\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3419\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈪚\x{0CE3}Ⴡ󠢏．\x{061D}", %p)},	undef,	"to_ascii\(\'\?\\u0CE3Ⴡ\?．\\u061D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3420\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈪚\x{0CE3}Ⴡ󠢏.\x{061D}", %p)},	undef,	"to_ascii\(\'\?\\u0CE3Ⴡ\?\.\\u061D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3421\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈪚\x{0CE3}ⴡ󠢏.\x{061D}", %p)},	undef,	"to_ascii\(\'\?\\u0CE3ⴡ\?\.\\u061D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3422\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈪚\x{0CE3}ⴡ󠢏．\x{061D}", %p)},	undef,	"to_ascii\(\'\?\\u0CE3ⴡ\?．\\u061D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3423\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{1DEB}。𐋩\x{0638}-𐫮", %p)},	undef,	"to_ascii\(\'\\u1DEB\。𐋩\\u0638\-𐫮\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3424\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("싇。⾇𐳋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐳋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3425\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。⾇𐳋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐳋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3426\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。舛𐳋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐳋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3427\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。舛𐳋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐳋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3428\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。舛𐳋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3429\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。舛𐳋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3430\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("싇。舛𐲋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐲋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3431\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。舛𐲋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐲋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3432\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。舛𐲋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3433\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。舛𐲋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3434\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。⾇𐳋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3435\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。⾇𐳋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3436\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("싇。⾇𐲋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐲋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3437\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。⾇𐲋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐲋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3438\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。⾇𐲋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3439\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。⾇𐲋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3440\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐹠ς。\x{200C}\x{06BF}Ⴠ", %p)},	undef,	"to_ascii\(\'𐹠ς\。\\u200C\\u06BFჀ\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3441\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹠ς。\x{200C}\x{06BF}ⴠ", %p)},	undef,	"to_ascii\(\'𐹠ς\。\\u200C\\u06BFⴠ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3443\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐹠Σ。\x{200C}\x{06BF}Ⴠ", %p)},	undef,	"to_ascii\(\'𐹠Σ\。\\u200C\\u06BFჀ\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3445\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹠σ。\x{200C}\x{06BF}ⴠ", %p)},	undef,	"to_ascii\(\'𐹠σ\。\\u200C\\u06BFⴠ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3447\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򇒐\x{200C}\x{0604}.\x{069A}-ß", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u0604\.\\u069A\-ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:3449\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򇒐\x{200C}\x{0604}.\x{069A}-SS", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u0604\.\\u069A\-SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:3451\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򇒐\x{200C}\x{0604}.\x{069A}-ss", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u0604\.\\u069A\-ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:3453\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򇒐\x{200C}\x{0604}.\x{069A}-Ss", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u0604\.\\u069A\-Ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:3455\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{FBB0}󅄞𐸚", %p)},	undef,	"to_ascii\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\uFBB0\?\?\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3457\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{06D3}󅄞𐸚", %p)},	undef,	"to_ascii\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\u06D3\?\?\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3459\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{06D2}\x{0654}󅄞𐸚", %p)},	undef,	"to_ascii\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\u06D2\\u0654\?\?\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3461\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򡶱｡𐮬≠", %p)},	undef,	"to_ascii\(\'\?｡𐮬\≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3463\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򡶱｡𐮬=\x{0338}", %p)},	undef,	"to_ascii\(\'\?｡𐮬\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3464\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򡶱。𐮬≠", %p)},	undef,	"to_ascii\(\'\?\。𐮬\≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3465\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򡶱。𐮬=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\。𐮬\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3466\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FB2}𞶅｡𐹮𐹷덝۵", %p)},	undef,	"to_ascii\(\'\\u0FB2\?｡𐹮𐹷덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3467\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FB2}𞶅｡𐹮𐹷덝۵", %p)},	undef,	"to_ascii\(\'\\u0FB2\?｡𐹮𐹷덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3468\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FB2}𞶅。𐹮𐹷덝۵", %p)},	undef,	"to_ascii\(\'\\u0FB2\?\。𐹮𐹷덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3469\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FB2}𞶅。𐹮𐹷덝۵", %p)},	undef,	"to_ascii\(\'\\u0FB2\?\。𐹮𐹷덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3470\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴏ󠅋-．\x{200D}Ⴉ", %p)},	undef,	"to_ascii\(\'Ⴏ\󠅋\-．\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3471\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴏ󠅋-.\x{200D}Ⴉ", %p)},	undef,	"to_ascii\(\'Ⴏ\󠅋\-\.\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3473\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴏ󠅋-.\x{200D}ⴉ", %p)},	undef,	"to_ascii\(\'ⴏ\󠅋\-\.\\u200Dⴉ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3475\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴏ󠅋-．\x{200D}ⴉ", %p)},	undef,	"to_ascii\(\'ⴏ\󠅋\-．\\u200Dⴉ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3477\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⇧𐨏󠾈󯶅。\x{0600}󠈵󠆉", %p)},	undef,	"to_ascii\(\'\⇧𐨏\?\?\。\\u0600\?\󠆉\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3479\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠𐮂.↑🄇⒈", %p)},	undef,	"to_ascii\(\'\≠𐮂\.\↑🄇⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3480\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}𐮂.↑🄇⒈", %p)},	undef,	"to_ascii\(\'\=\\u0338𐮂\.\↑🄇⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3481\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠𐮂.↑6,1.", %p)},	undef,	"to_ascii\(\'\≠𐮂\.\↑6\,1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3482\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}𐮂.↑6,1.", %p)},	undef,	"to_ascii\(\'\=\\u0338𐮂\.\↑6\,1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3483\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝩏󠲉ß.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_ascii\(\'𝩏\?ß\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3484\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝩏󠲉SS.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_ascii\(\'𝩏\?SS\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3486\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝩏󠲉ss.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_ascii\(\'𝩏\?ss\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3488\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝩏󠲉Ss.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_ascii\(\'𝩏\?Ss\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3490\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𐵳񗘁Ⴇ｡\x{A67A}", %p)},	undef,	"to_ascii\(\'ß\?\?Ⴇ｡\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3492\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𐵳񗘁Ⴇ。\x{A67A}", %p)},	undef,	"to_ascii\(\'ß\?\?Ⴇ\。\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3493\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𐵳񗘁ⴇ。\x{A67A}", %p)},	undef,	"to_ascii\(\'ß\?\?ⴇ\。\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3494\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS𐵳񗘁Ⴇ。\x{A67A}", %p)},	undef,	"to_ascii\(\'SS\?\?Ⴇ\。\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3495\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss𐵳񗘁ⴇ。\x{A67A}", %p)},	undef,	"to_ascii\(\'ss\?\?ⴇ\。\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3496\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss𐵳񗘁Ⴇ。\x{A67A}", %p)},	undef,	"to_ascii\(\'Ss\?\?Ⴇ\。\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3497\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𐵳񗘁ⴇ｡\x{A67A}", %p)},	undef,	"to_ascii\(\'ß\?\?ⴇ｡\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3498\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS𐵳񗘁Ⴇ｡\x{A67A}", %p)},	undef,	"to_ascii\(\'SS\?\?Ⴇ｡\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3499\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss𐵳񗘁ⴇ｡\x{A67A}", %p)},	undef,	"to_ascii\(\'ss\?\?ⴇ｡\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3500\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss𐵳񗘁Ⴇ｡\x{A67A}", %p)},	undef,	"to_ascii\(\'Ss\?\?Ⴇ｡\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3501\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{1714}。󠆣-𑋪", %p)},	undef,	"to_ascii\(\'\\u1714\。\󠆣\-𑋪\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3502\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{ABE8}-．򨏜\x{05BD}ß", %p)},	undef,	"to_ascii\(\'\\uABE8\-．\?\\u05BDß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3503\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-.򨏜\x{05BD}ß", %p)},	undef,	"to_ascii\(\'\\uABE8\-\.\?\\u05BDß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3504\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-.򨏜\x{05BD}SS", %p)},	undef,	"to_ascii\(\'\\uABE8\-\.\?\\u05BDSS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3505\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-.򨏜\x{05BD}ss", %p)},	undef,	"to_ascii\(\'\\uABE8\-\.\?\\u05BDss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3506\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-.򨏜\x{05BD}Ss", %p)},	undef,	"to_ascii\(\'\\uABE8\-\.\?\\u05BDSs\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3507\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-．򨏜\x{05BD}SS", %p)},	undef,	"to_ascii\(\'\\uABE8\-．\?\\u05BDSS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3508\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-．򨏜\x{05BD}ss", %p)},	undef,	"to_ascii\(\'\\uABE8\-．\?\\u05BDss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3509\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-．򨏜\x{05BD}Ss", %p)},	undef,	"to_ascii\(\'\\uABE8\-．\?\\u05BDSs\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3510\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡓ-≮。\x{066B}󠅱ᡄ", %p)},	undef,	"to_ascii\(\'ᡓ\-\≮\。\\u066B\󠅱ᡄ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3511\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡓ-<\x{0338}。\x{066B}󠅱ᡄ", %p)},	undef,	"to_ascii\(\'ᡓ\-\<\\u0338\。\\u066B\󠅱ᡄ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3512\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝟥♮𑜫\x{08ED}．\x{17D2}𑜫8󠆏", %p)},	undef,	"to_ascii\(\'𝟥\♮𑜫\\u08ED．\\u17D2𑜫8\󠆏\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3513\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("3♮𑜫\x{08ED}.\x{17D2}𑜫8󠆏", %p)},	undef,	"to_ascii\(\'3\♮𑜫\\u08ED\.\\u17D2𑜫8\󠆏\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3514\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-｡򕌀\x{200D}❡", %p)},	undef,	"to_ascii\(\'\-｡\?\\u200D\❡\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3515\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。򕌀\x{200D}❡", %p)},	undef,	"to_ascii\(\'\-\。\?\\u200D\❡\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3517\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟓☱𝟐򥰵｡𝪮񐡳", %p)},	undef,	"to_ascii\(\'𝟓\☱𝟐\?｡𝪮\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3519\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("5☱2򥰵。𝪮񐡳", %p)},	undef,	"to_ascii\(\'5\☱2\?\。𝪮\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3520\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.-├򖦣", %p)},	undef,	"to_ascii\(\'\-\.\-\├\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3521\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05A5}\x{076D}｡\x{200D}󠀘", %p)},	undef,	"to_ascii\(\'\\u05A5\\u076D｡\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3522\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05A5}\x{076D}。\x{200D}󠀘", %p)},	undef,	"to_ascii\(\'\\u05A5\\u076D\。\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3524\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉Ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_ascii\(\'쥥\?Ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3526\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉Ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_ascii\(\'쥥\?Ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3528\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉Ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_ascii\(\'쥥\?Ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3530\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉Ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_ascii\(\'쥥\?Ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3532\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_ascii\(\'쥥\?ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3534\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_ascii\(\'쥥\?ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3536\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_ascii\(\'쥥\?ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3538\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_ascii\(\'쥥\?ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3540\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{0827}𝟶\x{06A0}-。𑄳", %p)},	undef,	"to_ascii\(\'\\u0827𝟶\\u06A0\-\。𑄳\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3542\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{0827}0\x{06A0}-。𑄳", %p)},	undef,	"to_ascii\(\'\\u08270\\u06A0\-\。𑄳\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3543\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ς．\x{FDC1}🞛⒈", %p)},	undef,	"to_ascii\(\'ς．\\uFDC1🞛⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3544\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ς.\x{0641}\x{0645}\x{064A}🞛1.", %p)},	"xn--4xa.xn--1-gocmu97674d.",	"to_ascii\(\'ς\.\\u0641\\u0645\\u064A🞛1\.\'\)\ \[data\/IdnaTest\.txt\:3545\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Σ.\x{0641}\x{0645}\x{064A}🞛1.", %p)},	"xn--4xa.xn--1-gocmu97674d.",	"to_ascii\(\'Σ\.\\u0641\\u0645\\u064A🞛1\.\'\)\ \[data\/IdnaTest\.txt\:3547\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("σ.\x{0641}\x{0645}\x{064A}🞛1.", %p)},	"xn--4xa.xn--1-gocmu97674d.",	"to_ascii\(\'σ\.\\u0641\\u0645\\u064A🞛1\.\'\)\ \[data\/IdnaTest\.txt\:3548\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--4xa.xn--1-gocmu97674d.", %p)},	"xn--4xa.xn--1-gocmu97674d.",	"to_ascii\(\'xn\-\-4xa\.xn\-\-1\-gocmu97674d\.\'\)\ \[data\/IdnaTest\.txt\:3549\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--3xa.xn--1-gocmu97674d.", %p)},	"xn--3xa.xn--1-gocmu97674d.",	"to_ascii\(\'xn\-\-3xa\.xn\-\-1\-gocmu97674d\.\'\)\ \[data\/IdnaTest\.txt\:3550\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Σ．\x{FDC1}🞛⒈", %p)},	undef,	"to_ascii\(\'Σ．\\uFDC1🞛⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3551\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ．\x{FDC1}🞛⒈", %p)},	undef,	"to_ascii\(\'σ．\\uFDC1🞛⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3552\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🗩-｡𐹻󐞆񥉮", %p)},	undef,	"to_ascii\(\'🗩\-｡𐹻\?\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3553\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🗩-。𐹻󐞆񥉮", %p)},	undef,	"to_ascii\(\'🗩\-\。𐹻\?\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3554\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡜-🔪｡𝟻\x{200C}𐿀", %p)},	undef,	"to_ascii\(\'𐡜\-🔪｡𝟻\\u200C\?\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3555\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡜-🔪。5\x{200C}𐿀", %p)},	undef,	"to_ascii\(\'𐡜\-🔪\。5\\u200C\?\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3557\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ß．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dß．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3559\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ß．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dß．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3561\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ß.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dß\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3563\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ß.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dß\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3565\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}SS.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSS\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3567\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}SS.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSS\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3569\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dss\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3571\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dss\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3573\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}Ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSs\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3575\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}Ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSs\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3577\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}SS．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSS．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3579\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}SS．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSS．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3581\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dss．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3583\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dss．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3585\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}Ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSs．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3587\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}Ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSs．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3589\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("9󠇥．󪴴ᢓ", %p)},	undef,	"to_ascii\(\'9\󠇥．\?ᢓ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3591\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9󠇥.󪴴ᢓ", %p)},	undef,	"to_ascii\(\'9\󠇥\.\?ᢓ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3592\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{FFA0}.𐫭🠗ß⽟", %p)},	undef,	"to_ascii\(\'\\u200C\\uFFA0\.𐫭🠗ß⽟\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3593\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{1160}.𐫭🠗ß玉", %p)},	undef,	"to_ascii\(\'\\u200C\\u1160\.𐫭🠗ß玉\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3595\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{1160}.𐫭🠗SS玉", %p)},	undef,	"to_ascii\(\'\\u200C\\u1160\.𐫭🠗SS玉\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3597\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{1160}.𐫭🠗ss玉", %p)},	undef,	"to_ascii\(\'\\u200C\\u1160\.𐫭🠗ss玉\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3599\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{1160}.𐫭🠗Ss玉", %p)},	undef,	"to_ascii\(\'\\u200C\\u1160\.𐫭🠗Ss玉\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3601\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{FFA0}.𐫭🠗SS⽟", %p)},	undef,	"to_ascii\(\'\\u200C\\uFFA0\.𐫭🠗SS⽟\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3603\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{FFA0}.𐫭🠗ss⽟", %p)},	undef,	"to_ascii\(\'\\u200C\\uFFA0\.𐫭🠗ss⽟\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3605\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{FFA0}.𐫭🠗Ss⽟", %p)},	undef,	"to_ascii\(\'\\u200C\\uFFA0\.𐫭🠗Ss⽟\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3607\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒Ⴖ\x{0366}．\x{200C}", %p)},	undef,	"to_ascii\(\'︒Ⴖ\\u0366．\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3609\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。Ⴖ\x{0366}.\x{200C}", %p)},	undef,	"to_ascii\(\'\。Ⴖ\\u0366\.\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3611\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("。ⴖ\x{0366}.\x{200C}", %p)},	"xn--hva754s.",	"to_ascii\(\'\。ⴖ\\u0366\.\\u200C\'\)\ \[data\/IdnaTest\.txt\:3613\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--hva754s.", %p)},	"xn--hva754s.",	"to_ascii\(\'xn\-\-hva754s\.\'\)\ \[data\/IdnaTest\.txt\:3615\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴖ\x{0366}.", %p)},	"xn--hva754s.",	"to_ascii\(\'ⴖ\\u0366\.\'\)\ \[data\/IdnaTest\.txt\:3616\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴖ\x{0366}.", %p)},	undef,	"to_ascii\(\'Ⴖ\\u0366\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3617\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒ⴖ\x{0366}．\x{200C}", %p)},	undef,	"to_ascii\(\'︒ⴖ\\u0366．\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3618\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08BB}．\x{200C}Ⴃ𞀒", %p)},	undef,	"to_ascii\(\'\\u08BB．\\u200CႣ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3620\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08BB}.\x{200C}Ⴃ𞀒", %p)},	undef,	"to_ascii\(\'\\u08BB\.\\u200CႣ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3622\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{08BB}.\x{200C}ⴃ𞀒", %p)},	"xn--hzb.xn--ukj4430l",	"to_ascii\(\'\\u08BB\.\\u200Cⴃ\?\'\)\ \[data\/IdnaTest\.txt\:3624\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--hzb.xn--ukj4430l", %p)},	"xn--hzb.xn--ukj4430l",	"to_ascii\(\'xn\-\-hzb\.xn\-\-ukj4430l\'\)\ \[data\/IdnaTest\.txt\:3626\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{08BB}.ⴃ𞀒", %p)},	"xn--hzb.xn--ukj4430l",	"to_ascii\(\'\\u08BB\.ⴃ\?\'\)\ \[data\/IdnaTest\.txt\:3627\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{08BB}.Ⴃ𞀒", %p)},	undef,	"to_ascii\(\'\\u08BB\.Ⴃ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3628\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{08BB}．\x{200C}ⴃ𞀒", %p)},	"xn--hzb.xn--ukj4430l",	"to_ascii\(\'\\u08BB．\\u200Cⴃ\?\'\)\ \[data\/IdnaTest\.txt\:3629\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}\x{200C}。２䫷󠧷", %p)},	undef,	"to_ascii\(\'\\u200D\\u200C\。２䫷\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3631\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200C}。2䫷󠧷", %p)},	undef,	"to_ascii\(\'\\u200D\\u200C\。2䫷\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3633\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𞀤󜠐。򈬖", %p)},	undef,	"to_ascii\(\'\-\?\?\。\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3635\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󳛂︒\x{200C}㟀．\x{0624}⒈", %p)},	undef,	"to_ascii\(\'\?︒\\u200C㟀．\\u0624⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3636\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󳛂︒\x{200C}㟀．\x{0648}\x{0654}⒈", %p)},	undef,	"to_ascii\(\'\?︒\\u200C㟀．\\u0648\\u0654⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3638\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󳛂。\x{200C}㟀.\x{0624}1.", %p)},	undef,	"to_ascii\(\'\?\。\\u200C㟀\.\\u06241\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3640\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󳛂。\x{200C}㟀.\x{0648}\x{0654}1.", %p)},	undef,	"to_ascii\(\'\?\。\\u200C㟀\.\\u0648\\u06541\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3642\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑲜\x{07CA}𝅼。-\x{200D}", %p)},	undef,	"to_ascii\(\'\?\\u07CA𝅼\。\-\\u200D\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:3644\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}．Ⴉ≠𐫶", %p)},	undef,	"to_ascii\(\'\\u200C．Ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3646\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}．Ⴉ=\x{0338}𐫶", %p)},	undef,	"to_ascii\(\'\\u200C．Ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3648\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.Ⴉ≠𐫶", %p)},	undef,	"to_ascii\(\'\\u200C\.Ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3650\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.Ⴉ=\x{0338}𐫶", %p)},	undef,	"to_ascii\(\'\\u200C\.Ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3652\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.ⴉ=\x{0338}𐫶", %p)},	undef,	"to_ascii\(\'\\u200C\.ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3654\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.ⴉ≠𐫶", %p)},	undef,	"to_ascii\(\'\\u200C\.ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3656\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}．ⴉ=\x{0338}𐫶", %p)},	undef,	"to_ascii\(\'\\u200C．ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3658\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}．ⴉ≠𐫶", %p)},	undef,	"to_ascii\(\'\\u200C．ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3660\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。≯ς", %p)},	undef,	"to_ascii\(\'\\u0750\。\≯ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3662\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。>\x{0338}ς", %p)},	undef,	"to_ascii\(\'\\u0750\。\>\\u0338ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3663\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。>\x{0338}Σ", %p)},	undef,	"to_ascii\(\'\\u0750\。\>\\u0338Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3664\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。≯Σ", %p)},	undef,	"to_ascii\(\'\\u0750\。\≯Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3665\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。≯σ", %p)},	undef,	"to_ascii\(\'\\u0750\。\≯σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3666\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。>\x{0338}σ", %p)},	undef,	"to_ascii\(\'\\u0750\。\>\\u0338σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3667\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07FC}𐸆.𓖏︒񊨩Ⴐ", %p)},	undef,	"to_ascii\(\'\\u07FC\?\.\?︒\?Ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3668\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07FC}𐸆.𓖏。񊨩Ⴐ", %p)},	undef,	"to_ascii\(\'\\u07FC\?\.\?\。\?Ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3669\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07FC}𐸆.𓖏。񊨩ⴐ", %p)},	undef,	"to_ascii\(\'\\u07FC\?\.\?\。\?ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3670\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07FC}𐸆.𓖏︒񊨩ⴐ", %p)},	undef,	"to_ascii\(\'\\u07FC\?\.\?︒\?ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3671\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴥ⚭󠖫⋃｡𑌼", %p)},	undef,	"to_ascii\(\'Ⴥ\⚭\?\⋃｡𑌼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3672\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴥ⚭󠖫⋃。𑌼", %p)},	undef,	"to_ascii\(\'Ⴥ\⚭\?\⋃\。𑌼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3673\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴥ⚭󠖫⋃。𑌼", %p)},	undef,	"to_ascii\(\'ⴥ\⚭\?\⋃\。𑌼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3674\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴥ⚭󠖫⋃｡𑌼", %p)},	undef,	"to_ascii\(\'ⴥ\⚭\?\⋃｡𑌼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3675\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄈。󠷳\x{0844}", %p)},	undef,	"to_ascii\(\'🄈\。\?\\u0844\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3676\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("7,。󠷳\x{0844}", %p)},	undef,	"to_ascii\(\'7\,\。\?\\u0844\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3677\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮\x{0846}。섖쮖ß", %p)},	undef,	"to_ascii\(\'\≮\\u0846\。섖쮖ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3678\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}\x{0846}。섖쮖ß", %p)},	undef,	"to_ascii\(\'\<\\u0338\\u0846\。섖쮖ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3679\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}\x{0846}。섖쮖SS", %p)},	undef,	"to_ascii\(\'\<\\u0338\\u0846\。섖쮖SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3680\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮\x{0846}。섖쮖SS", %p)},	undef,	"to_ascii\(\'\≮\\u0846\。섖쮖SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3681\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮\x{0846}。섖쮖ss", %p)},	undef,	"to_ascii\(\'\≮\\u0846\。섖쮖ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3682\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}\x{0846}。섖쮖ss", %p)},	undef,	"to_ascii\(\'\<\\u0338\\u0846\。섖쮖ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3683\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}\x{0846}。섖쮖Ss", %p)},	undef,	"to_ascii\(\'\<\\u0338\\u0846\。섖쮖Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3684\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮\x{0846}。섖쮖Ss", %p)},	undef,	"to_ascii\(\'\≮\\u0846\。섖쮖Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3685\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("󠆓⛏-。ꡒ", %p)},	undef,	"to_ascii\(\'\󠆓\⛏\-\。ꡒ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3686\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{07BB}𐹳\x{0626}𑁆。\x{08A7}\x{06B0}\x{200C}ᢒ", %p)},	undef,	"to_ascii\(\'\\u07BB𐹳\\u0626𑁆\。\\u08A7\\u06B0\\u200Cᢒ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3687\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07BB}𐹳\x{064A}𑁆\x{0654}。\x{08A7}\x{06B0}\x{200C}ᢒ", %p)},	undef,	"to_ascii\(\'\\u07BB𐹳\\u064A𑁆\\u0654\。\\u08A7\\u06B0\\u200Cᢒ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3688\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0816}.𐨕𚚕", %p)},	undef,	"to_ascii\(\'\\u0816\.𐨕\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3689\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("--。𽊆\x{0767}𐽋𞠬", %p)},	undef,	"to_ascii\(\'\-\-\。\?\\u0767\?𞠬\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3690\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򛭦𐋥𹸐.≯\x{08B0}\x{08A6}󔛣", %p)},	undef,	"to_ascii\(\'\?𐋥\?\.\≯\\u08B0\\u08A6\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3691\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򛭦𐋥𹸐.>\x{0338}\x{08B0}\x{08A6}󔛣", %p)},	undef,	"to_ascii\(\'\?𐋥\?\.\>\\u0338\\u08B0\\u08A6\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3692\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䔛󠇒򤸞𐹧．-䤷", %p)},	undef,	"to_ascii\(\'䔛\󠇒\?𐹧．\-䤷\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3693\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䔛󠇒򤸞𐹧.-䤷", %p)},	undef,	"to_ascii\(\'䔛\󠇒\?𐹧\.\-䤷\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3694\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹩．\x{200D}-", %p)},	undef,	"to_ascii\(\'𐹩．\\u200D\-\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:3695\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹩.\x{200D}-", %p)},	undef,	"to_ascii\(\'𐹩\.\\u200D\-\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:3697\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񂈦帷｡≯萺\x{1DC8}-", %p)},	undef,	"to_ascii\(\'\?帷｡\≯萺\\u1DC8\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3699\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񂈦帷｡>\x{0338}萺\x{1DC8}-", %p)},	undef,	"to_ascii\(\'\?帷｡\>\\u0338萺\\u1DC8\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3700\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񂈦帷。≯萺\x{1DC8}-", %p)},	undef,	"to_ascii\(\'\?帷\。\≯萺\\u1DC8\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3701\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񂈦帷。>\x{0338}萺\x{1DC8}-", %p)},	undef,	"to_ascii\(\'\?帷\。\>\\u0338萺\\u1DC8\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3702\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}攌\x{ABED}。ᢖ-Ⴘ", %p)},	undef,	"to_ascii\(\'\\u200D攌\\uABED\。ᢖ\-Ⴘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3703\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}攌\x{ABED}。ᢖ-ⴘ", %p)},	"xn--p9ut19m.xn----mck373i",	"to_ascii\(\'\\u200D攌\\uABED\。ᢖ\-ⴘ\'\)\ \[data\/IdnaTest\.txt\:3705\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("xn--p9ut19m.xn----mck373i", %p)},	"xn--p9ut19m.xn----mck373i",	"to_ascii\(\'xn\-\-p9ut19m\.xn\-\-\-\-mck373i\'\)\ \[data\/IdnaTest\.txt\:3707\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("攌\x{ABED}.ᢖ-ⴘ", %p)},	"xn--p9ut19m.xn----mck373i",	"to_ascii\(\'攌\\uABED\.ᢖ\-ⴘ\'\)\ \[data\/IdnaTest\.txt\:3708\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("攌\x{ABED}.ᢖ-Ⴘ", %p)},	undef,	"to_ascii\(\'攌\\uABED\.ᢖ\-Ⴘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3709\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ꖨ．⒗３툒۳", %p)},	undef,	"to_ascii\(\'\\u200Cꖨ．⒗３툒۳\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3710\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ꖨ．⒗３툒۳", %p)},	undef,	"to_ascii\(\'\\u200Cꖨ．⒗３툒۳\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3712\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{200C}ꖨ.16.3툒۳", %p)},	"xn--9r8a.16.xn--3-nyc0117m",	"to_ascii\(\'\\u200Cꖨ\.16\.3툒۳\'\)\ \[data\/IdnaTest\.txt\:3714\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{200C}ꖨ.16.3툒۳", %p)},	"xn--9r8a.16.xn--3-nyc0117m",	"to_ascii\(\'\\u200Cꖨ\.16\.3툒۳\'\)\ \[data\/IdnaTest\.txt\:3716\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("xn--9r8a.16.xn--3-nyc0117m", %p)},	"xn--9r8a.16.xn--3-nyc0117m",	"to_ascii\(\'xn\-\-9r8a\.16\.xn\-\-3\-nyc0117m\'\)\ \[data\/IdnaTest\.txt\:3718\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ꖨ.16.3툒۳", %p)},	"xn--9r8a.16.xn--3-nyc0117m",	"to_ascii\(\'ꖨ\.16\.3툒۳\'\)\ \[data\/IdnaTest\.txt\:3719\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ꖨ.16.3툒۳", %p)},	"xn--9r8a.16.xn--3-nyc0117m",	"to_ascii\(\'ꖨ\.16\.3툒۳\'\)\ \[data\/IdnaTest\.txt\:3720\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⒈걾6.𐱁\x{06D0}", %p)},	undef,	"to_ascii\(\'⒈걾6\.𐱁\\u06D0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3721\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈걾6.𐱁\x{06D0}", %p)},	undef,	"to_ascii\(\'⒈걾6\.𐱁\\u06D0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3722\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("1.걾6.𐱁\x{06D0}", %p)},	"1.xn--6-945e.xn--glb1794k",	"to_ascii\(\'1\.걾6\.𐱁\\u06D0\'\)\ \[data\/IdnaTest\.txt\:3723\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("1.걾6.𐱁\x{06D0}", %p)},	"1.xn--6-945e.xn--glb1794k",	"to_ascii\(\'1\.걾6\.𐱁\\u06D0\'\)\ \[data\/IdnaTest\.txt\:3724\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("1.xn--6-945e.xn--glb1794k", %p)},	"1.xn--6-945e.xn--glb1794k",	"to_ascii\(\'1\.xn\-\-6\-945e\.xn\-\-glb1794k\'\)\ \[data\/IdnaTest\.txt\:3725\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐲞𝟶≮≮.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐲞𝟶\≮\≮\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3726\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐲞𝟶<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐲞𝟶\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3727\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐲞0≮≮.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐲞0\≮\≮\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3728\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐲞0<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐲞0\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3729\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳞0<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐳞0\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3730\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳞0≮≮.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐳞0\≮\≮\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3731\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳞𝟶<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐳞𝟶\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3732\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳞𝟶≮≮.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐳞𝟶\≮\≮\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3733\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0AE3}.𐹺\x{115F}", %p)},	undef,	"to_ascii\(\'\\u0AE3\.𐹺\\u115F\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3734\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝟏𝨙⸖.\x{200D}", %p)},	"xn--1-5bt6845n.",	"to_ascii\(\'𝟏𝨙\⸖\.\\u200D\'\)\ \[data\/IdnaTest\.txt\:3735\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("1𝨙⸖.\x{200D}", %p)},	"xn--1-5bt6845n.",	"to_ascii\(\'1𝨙\⸖\.\\u200D\'\)\ \[data\/IdnaTest\.txt\:3737\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("xn--1-5bt6845n.", %p)},	"xn--1-5bt6845n.",	"to_ascii\(\'xn\-\-1\-5bt6845n\.\'\)\ \[data\/IdnaTest\.txt\:3739\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("1𝨙⸖.", %p)},	"xn--1-5bt6845n.",	"to_ascii\(\'1𝨙\⸖\.\'\)\ \[data\/IdnaTest\.txt\:3740\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞤐≠\x{0726}\x{1A60}｡-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'\?\≠\\u0726\\u1A60｡\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3741\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤐=\x{0338}\x{0726}\x{1A60}｡-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'\?\=\\u0338\\u0726\\u1A60｡\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤐≠\x{0726}\x{1A60}。-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'\?\≠\\u0726\\u1A60\。\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3745\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤐=\x{0338}\x{0726}\x{1A60}。-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'\?\=\\u0338\\u0726\\u1A60\。\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3747\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹰\x{0368}-ꡧ｡\x{0675}", %p)},	undef,	"to_ascii\(\'𐹰\\u0368\-ꡧ｡\\u0675\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3749\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹰\x{0368}-ꡧ。\x{0627}\x{0674}", %p)},	undef,	"to_ascii\(\'𐹰\\u0368\-ꡧ\。\\u0627\\u0674\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3750\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("F󠅟｡򏗅♚", %p)},	undef,	"to_ascii\(\'F\󠅟｡\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3751\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("F󠅟。򏗅♚", %p)},	undef,	"to_ascii\(\'F\󠅟\。\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3752\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("f󠅟。򏗅♚", %p)},	undef,	"to_ascii\(\'f\󠅟\。\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3753\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("f󠅟｡򏗅♚", %p)},	undef,	"to_ascii\(\'f\󠅟｡\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3754\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0B4D}𑄴\x{1DE9}。𝟮Ⴘ𞀨񃥇", %p)},	undef,	"to_ascii\(\'\\u0B4D𑄴\\u1DE9\。𝟮Ⴘ\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3755\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0B4D}𑄴\x{1DE9}。2Ⴘ𞀨񃥇", %p)},	undef,	"to_ascii\(\'\\u0B4D𑄴\\u1DE9\。2Ⴘ\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3756\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0B4D}𑄴\x{1DE9}。2ⴘ𞀨񃥇", %p)},	undef,	"to_ascii\(\'\\u0B4D𑄴\\u1DE9\。2ⴘ\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3757\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0B4D}𑄴\x{1DE9}。𝟮ⴘ𞀨񃥇", %p)},	undef,	"to_ascii\(\'\\u0B4D𑄴\\u1DE9\。𝟮ⴘ\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3758\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򓠭\x{200C}\x{200C}⒈。勉𑁅", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u200C⒈\。勉𑁅\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3759\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򓠭\x{200C}\x{200C}1.。勉𑁅", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u200C1\.\。勉𑁅\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3761\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡃ.玿񫈜󕞐", %p)},	undef,	"to_ascii\(\'ᡃ\.玿\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3763\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}｡⒈≯𝟵", %p)},	undef,	"to_ascii\(\'\\u200C\\u200C｡⒈\≯𝟵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3764\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}｡⒈>\x{0338}𝟵", %p)},	undef,	"to_ascii\(\'\\u200C\\u200C｡⒈\>\\u0338𝟵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3766\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}。1.≯9", %p)},	undef,	"to_ascii\(\'\\u200C\\u200C\。1\.\≯9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3768\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}。1.>\x{0338}9", %p)},	undef,	"to_ascii\(\'\\u200C\\u200C\。1\.\>\\u03389\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3770\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}\x{1DE0}򐀁.𺻆≯𐮁", %p)},	undef,	"to_ascii\(\'\\u115F\\u1DE0\?\.\?\≯𐮁\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3772\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}\x{1DE0}򐀁.𺻆>\x{0338}𐮁", %p)},	undef,	"to_ascii\(\'\\u115F\\u1DE0\?\.\?\>\\u0338𐮁\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3773\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄫𝩤\x{200D}\x{063E}.𝩩-\x{081E}󑼩", %p)},	undef,	"to_ascii\(\'\󠄫𝩤\\u200D\\u063E\.𝩩\-\\u081E\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3774\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{20DA}．𑘿-", %p)},	undef,	"to_ascii\(\'\\u20DA．𑘿\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3776\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{20DA}.𑘿-", %p)},	undef,	"to_ascii\(\'\\u20DA\.𑘿\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3777\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("䮸ß.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_ascii\(\'䮸ß\.\?\?紙\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3778\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䮸SS.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_ascii\(\'䮸SS\.\?\?紙\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3779\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䮸ss.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_ascii\(\'䮸ss\.\?\?紙\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3780\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䮸Ss.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_ascii\(\'䮸Ss\.\?\?紙\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3781\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-Ⴞ.-𝩨⅔𐦕", %p)},	undef,	"to_ascii\(\'\-Ⴞ\.\-𝩨⅔𐦕\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3782\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-Ⴞ.-𝩨2⁄3𐦕", %p)},	undef,	"to_ascii\(\'\-Ⴞ\.\-𝩨2\⁄3𐦕\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3783\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("-ⴞ.-𝩨2⁄3𐦕", %p)},	undef,	"to_ascii\(\'\-ⴞ\.\-𝩨2\⁄3𐦕\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:3784\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("-ⴞ.-𝩨⅔𐦕", %p)},	undef,	"to_ascii\(\'\-ⴞ\.\-𝩨⅔𐦕\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:3785\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󧈯𐹯\x{0AC2}｡򖢨𐮁񇼖ᡂ", %p)},	undef,	"to_ascii\(\'\?𐹯\\u0AC2｡\?𐮁\?ᡂ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3786\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧈯𐹯\x{0AC2}。򖢨𐮁񇼖ᡂ", %p)},	undef,	"to_ascii\(\'\?𐹯\\u0AC2\。\?𐮁\?ᡂ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3787\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1082}-\x{200D}\x{A8EA}．ꡊ\x{200D}񼸳", %p)},	undef,	"to_ascii\(\'\\u1082\-\\u200D\\uA8EA．ꡊ\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3788\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1082}-\x{200D}\x{A8EA}.ꡊ\x{200D}񼸳", %p)},	undef,	"to_ascii\(\'\\u1082\-\\u200D\\uA8EA\.ꡊ\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3790\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("۱。≠\x{0668}", %p)},	undef,	"to_ascii\(\'۱\。\≠\\u0668\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3792\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("۱。=\x{0338}\x{0668}", %p)},	undef,	"to_ascii\(\'۱\。\=\\u0338\\u0668\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3793\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𑈵廊.𐠍", %p)},	undef,	"to_ascii\(\'𑈵廊\.𐠍\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3794\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}\x{0356}-．-Ⴐ\x{0661}", %p)},	undef,	"to_ascii\(\'\\u200D\\u0356\-．\-Ⴐ\\u0661\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3795\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{0356}-.-Ⴐ\x{0661}", %p)},	undef,	"to_ascii\(\'\\u200D\\u0356\-\.\-Ⴐ\\u0661\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3797\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200D}\x{0356}-.-ⴐ\x{0661}", %p)},	undef,	"to_ascii\(\'\\u200D\\u0356\-\.\-ⴐ\\u0661\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3799\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200D}\x{0356}-．-ⴐ\x{0661}", %p)},	undef,	"to_ascii\(\'\\u200D\\u0356\-．\-ⴐ\\u0661\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3801\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{063A}\x{0661}挏󾯐.-", %p)},	undef,	"to_ascii\(\'\\u063A\\u0661挏\?\.\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3803\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06EF}｡𐹧𞤽", %p)},	undef,	"to_ascii\(\'\\u06EF｡𐹧\?\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3804\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06EF}。𐹧𞤽", %p)},	undef,	"to_ascii\(\'\\u06EF\。𐹧\?\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3805\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_ascii\(\'Ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3806\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_ascii\(\'Ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3807\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_ascii\(\'Ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3808\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_ascii\(\'Ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3809\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_ascii\(\'ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3810\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_ascii\(\'ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3811\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_ascii\(\'ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3812\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_ascii\(\'ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3813\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠎃󗭞\x{06B7}𐹷｡≯\x{200C}\x{1DFE}", %p)},	undef,	"to_ascii\(\'\?\?\\u06B7𐹷｡\≯\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3814\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠎃󗭞\x{06B7}𐹷｡>\x{0338}\x{200C}\x{1DFE}", %p)},	undef,	"to_ascii\(\'\?\?\\u06B7𐹷｡\>\\u0338\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3816\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠎃󗭞\x{06B7}𐹷。≯\x{200C}\x{1DFE}", %p)},	undef,	"to_ascii\(\'\?\?\\u06B7𐹷\。\≯\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3818\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠎃󗭞\x{06B7}𐹷。>\x{0338}\x{200C}\x{1DFE}", %p)},	undef,	"to_ascii\(\'\?\?\\u06B7𐹷\。\>\\u0338\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3820\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᛎ󠅍󠐕\x{200D}｡𐹾𐹪𐻝-", %p)},	undef,	"to_ascii\(\'ᛎ\󠅍\?\\u200D｡𐹾𐹪\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3822\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᛎ󠅍󠐕\x{200D}。𐹾𐹪𐻝-", %p)},	undef,	"to_ascii\(\'ᛎ\󠅍\?\\u200D\。𐹾𐹪\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3824\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐹶.𐫂", %p)},	undef,	"to_ascii\(\'𐹶\.𐫂\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3826\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ß\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_ascii\(\'ß\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3827\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ß\x{200D}\x{103A}。1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'ß\\u200D\\u103A\。1\.\'\)\ \[data\/IdnaTest\.txt\:3829\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("SS\x{200D}\x{103A}。1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'SS\\u200D\\u103A\。1\.\'\)\ \[data\/IdnaTest\.txt\:3831\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ss\x{200D}\x{103A}。1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'ss\\u200D\\u103A\。1\.\'\)\ \[data\/IdnaTest\.txt\:3833\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("Ss\x{200D}\x{103A}。1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'Ss\\u200D\\u103A\。1\.\'\)\ \[data\/IdnaTest\.txt\:3835\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("xn--ss-f4j.1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'xn\-\-ss\-f4j\.1\.\'\)\ \[data\/IdnaTest\.txt\:3837\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ss\x{103A}.1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'ss\\u103A\.1\.\'\)\ \[data\/IdnaTest\.txt\:3838\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("SS\x{103A}.1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'SS\\u103A\.1\.\'\)\ \[data\/IdnaTest\.txt\:3839\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("Ss\x{103A}.1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'Ss\\u103A\.1\.\'\)\ \[data\/IdnaTest\.txt\:3840\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_ascii\(\'SS\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3841\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_ascii\(\'ss\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3843\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_ascii\(\'Ss\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3845\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0B4D}\x{200C}𙶵𞻘。\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0B4D\\u200C\?\?\。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3847\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐮅｡\x{06BC}🁕", %p)},	undef,	"to_ascii\(\'𐮅｡\\u06BC🁕\'\)\ throws\ error\ B3\ \[data\/IdnaTest\.txt\:3849\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐮅。\x{06BC}🁕", %p)},	undef,	"to_ascii\(\'𐮅\。\\u06BC🁕\'\)\ throws\ error\ B3\ \[data\/IdnaTest\.txt\:3850\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0620}\x{17D2}。𐫔󠀧\x{200C}𑈵", %p)},	undef,	"to_ascii\(\'\\u0620\\u17D2\。𐫔\?\\u200C𑈵\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3851\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񋉕.𞣕𞤊", %p)},	undef,	"to_ascii\(\'\?\.𞣕\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3853\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿．ß\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿．ß\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3854\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿.ß\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿\.ß\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3856\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿.SS\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿\.SS\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3858\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿.ss\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿\.ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3859\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿.Ss\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿\.Ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3860\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--clb2593k.xn--ss-toj6092t", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'xn\-\-clb2593k\.xn\-\-ss\-toj6092t\'\)\ \[data\/IdnaTest\.txt\:3861\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--clb2593k.xn--zca216edt0r", %p)},	"xn--clb2593k.xn--zca216edt0r",	"to_ascii\(\'xn\-\-clb2593k\.xn\-\-zca216edt0r\'\)\ \[data\/IdnaTest\.txt\:3862\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿．SS\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿．SS\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3863\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿．ss\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿．ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3864\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿．Ss\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿．Ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3865\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𝟠≮\x{200C}｡󠅱\x{17B4}", %p)},	undef,	"to_ascii\(\'𝟠\≮\\u200C｡\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3866\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟠<\x{0338}\x{200C}｡󠅱\x{17B4}", %p)},	undef,	"to_ascii\(\'𝟠\<\\u0338\\u200C｡\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3868\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8≮\x{200C}。󠅱\x{17B4}", %p)},	undef,	"to_ascii\(\'8\≮\\u200C\。\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3870\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8<\x{0338}\x{200C}。󠅱\x{17B4}", %p)},	undef,	"to_ascii\(\'8\<\\u0338\\u200C\。\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3872\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ≯︒񄂯．Ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\≯︒\?．Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3874\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ>\x{0338}︒񄂯．Ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\>\\u0338︒\?．Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3875\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ≯。񄂯.Ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\≯\。\?\.Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3876\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ>\x{0338}。񄂯.Ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\>\\u0338\。\?\.Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3877\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ>\x{0338}。񄂯.ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\>\\u0338\。\?\.ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3878\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ≯。񄂯.ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\≯\。\?\.ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3879\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ>\x{0338}︒񄂯．ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\>\\u0338︒\?．ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3880\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ≯︒񄂯．ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\≯︒\?．ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3881\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0F9F}．-\x{082A}", %p)},	undef,	"to_ascii\(\'\\u0F9F．\-\\u082A\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3882\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0F9F}.-\x{082A}", %p)},	undef,	"to_ascii\(\'\\u0F9F\.\-\\u082A\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3883\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ᵬ󠆠．핒⒒⒈􈄦", %p)},	undef,	"to_ascii\(\'ᵬ\󠆠．핒⒒⒈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3884\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᵬ󠆠．핒⒒⒈􈄦", %p)},	undef,	"to_ascii\(\'ᵬ\󠆠．핒⒒⒈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3885\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᵬ󠆠.핒11.1.􈄦", %p)},	undef,	"to_ascii\(\'ᵬ\󠆠\.핒11\.1\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3886\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᵬ󠆠.핒11.1.􈄦", %p)},	undef,	"to_ascii\(\'ᵬ\󠆠\.핒11\.1\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3887\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ς𑓂𐋢．\x{0668}", %p)},	undef,	"to_ascii\(\'ς𑓂𐋢．\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3888\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ς𑓂𐋢.\x{0668}", %p)},	undef,	"to_ascii\(\'ς𑓂𐋢\.\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3889\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Σ𑓂𐋢.\x{0668}", %p)},	undef,	"to_ascii\(\'Σ𑓂𐋢\.\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3890\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("σ𑓂𐋢.\x{0668}", %p)},	undef,	"to_ascii\(\'σ𑓂𐋢\.\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3891\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Σ𑓂𐋢．\x{0668}", %p)},	undef,	"to_ascii\(\'Σ𑓂𐋢．\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3892\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("σ𑓂𐋢．\x{0668}", %p)},	undef,	"to_ascii\(\'σ𑓂𐋢．\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3893\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{A953}\x{200C}𐋻\x{200D}.\x{2DF8}𞿄𐹲", %p)},	undef,	"to_ascii\(\'\\uA953\\u200C𐋻\\u200D\.\\u2DF8\?𐹲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3894\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⊼。񪧖\x{0695}", %p)},	undef,	"to_ascii\(\'\⊼\。\?\\u0695\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3896\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯬񖋔。󜳥", %p)},	undef,	"to_ascii\(\'\?\?\。\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3897\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0601}𑍧\x{07DD}。ς򬍘🀞\x{17B5}", %p)},	undef,	"to_ascii\(\'\\u0601𑍧\\u07DD\。ς\?🀞\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3898\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0601}𑍧\x{07DD}。Σ򬍘🀞\x{17B5}", %p)},	undef,	"to_ascii\(\'\\u0601𑍧\\u07DD\。Σ\?🀞\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3899\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0601}𑍧\x{07DD}。σ򬍘🀞\x{17B5}", %p)},	undef,	"to_ascii\(\'\\u0601𑍧\\u07DD\。σ\?🀞\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3900\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐳲\x{0646}󠺐。\x{ABED}𝟥", %p)},	undef,	"to_ascii\(\'\-𐳲\\u0646\?\。\\uABED𝟥\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3901\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐳲\x{0646}󠺐。\x{ABED}3", %p)},	undef,	"to_ascii\(\'\-𐳲\\u0646\?\。\\uABED3\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3902\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐲲\x{0646}󠺐。\x{ABED}3", %p)},	undef,	"to_ascii\(\'\-𐲲\\u0646\?\。\\uABED3\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3903\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐲲\x{0646}󠺐。\x{ABED}𝟥", %p)},	undef,	"to_ascii\(\'\-𐲲\\u0646\?\。\\uABED𝟥\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3904\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠴦｡񲨕≮𐦜", %p)},	undef,	"to_ascii\(\'\\u200C\?｡\?\≮𐦜\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3905\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠴦｡񲨕<\x{0338}𐦜", %p)},	undef,	"to_ascii\(\'\\u200C\?｡\?\<\\u0338𐦜\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3907\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠴦。񲨕≮𐦜", %p)},	undef,	"to_ascii\(\'\\u200C\?\。\?\≮𐦜\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3909\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠴦。񲨕<\x{0338}𐦜", %p)},	undef,	"to_ascii\(\'\\u200C\?\。\?\<\\u0338𐦜\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3911\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈✌򟬟．𝟡񠱣", %p)},	undef,	"to_ascii\(\'⒈\✌\?．𝟡\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3913\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.✌򟬟.9񠱣", %p)},	undef,	"to_ascii\(\'1\.\✌\?\.9\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3914\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑆾𞤬𐮆.\x{0666}\x{1DD4}", %p)},	undef,	"to_ascii\(\'𑆾\?𐮆\.\\u0666\\u1DD4\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3915\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ς．\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'ς．\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3916\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ς.\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'ς\.\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3917\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("Σ.\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'Σ\.\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3918\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("σ.\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'σ\.\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3919\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("Σ．\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'Σ．\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3920\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("σ．\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'σ．\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3921\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𑰶\x{200C}≯𐳐．\x{085B}", %p)},	undef,	"to_ascii\(\'\?\\u200C\≯𐳐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3922\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}>\x{0338}𐳐．\x{085B}", %p)},	undef,	"to_ascii\(\'\?\\u200C\>\\u0338𐳐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3924\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}≯𐳐.\x{085B}", %p)},	undef,	"to_ascii\(\'\?\\u200C\≯𐳐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3926\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}>\x{0338}𐳐.\x{085B}", %p)},	undef,	"to_ascii\(\'\?\\u200C\>\\u0338𐳐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3928\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}>\x{0338}𐲐.\x{085B}", %p)},	undef,	"to_ascii\(\'\?\\u200C\>\\u0338𐲐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3930\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}≯𐲐.\x{085B}", %p)},	undef,	"to_ascii\(\'\?\\u200C\≯𐲐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3932\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}>\x{0338}𐲐．\x{085B}", %p)},	undef,	"to_ascii\(\'\?\\u200C\>\\u0338𐲐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3934\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}≯𐲐．\x{085B}", %p)},	undef,	"to_ascii\(\'\?\\u200C\≯𐲐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3936\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("羚｡≯", %p)},	undef,	"to_ascii\(\'羚｡\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3938\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("羚｡>\x{0338}", %p)},	undef,	"to_ascii\(\'羚｡\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3939\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("羚。≯", %p)},	undef,	"to_ascii\(\'羚\。\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3940\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("羚。>\x{0338}", %p)},	undef,	"to_ascii\(\'羚\。\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3941\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑓂\x{1759}．\x{08A8}", %p)},	undef,	"to_ascii\(\'𑓂\\u1759．\\u08A8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3942\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑓂\x{1759}.\x{08A8}", %p)},	undef,	"to_ascii\(\'𑓂\\u1759\.\\u08A8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3943\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}｡\x{0663}ҠჀ𝟑", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D｡\\u0663ҠჀ𝟑\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3944\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}。\x{0663}ҠჀ3", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D\。\\u0663ҠჀ3\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3946\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}。\x{0663}ҡⴠ3", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D\。\\u0663ҡⴠ3\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3948\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}。\x{0663}Ҡⴠ3", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D\。\\u0663Ҡⴠ3\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3950\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}｡\x{0663}ҡⴠ𝟑", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D｡\\u0663ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3952\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}｡\x{0663}Ҡⴠ𝟑", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D｡\\u0663Ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3954\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ᡷ。𐹢\x{08E0}", %p)},	undef,	"to_ascii\(\'ᡷ\。𐹢\\u08E0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3956\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}ß", %p)},	undef,	"to_ascii\(\'\?\\u1BF3｡\\u0666\?\\u17D2ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3957\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}ß", %p)},	undef,	"to_ascii\(\'\?\\u1BF3\。\\u0666\?\\u17D2ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3958\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}SS", %p)},	undef,	"to_ascii\(\'\?\\u1BF3\。\\u0666\?\\u17D2SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3959\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}ss", %p)},	undef,	"to_ascii\(\'\?\\u1BF3\。\\u0666\?\\u17D2ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3960\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}Ss", %p)},	undef,	"to_ascii\(\'\?\\u1BF3\。\\u0666\?\\u17D2Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3961\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}SS", %p)},	undef,	"to_ascii\(\'\?\\u1BF3｡\\u0666\?\\u17D2SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3962\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}ss", %p)},	undef,	"to_ascii\(\'\?\\u1BF3｡\\u0666\?\\u17D2ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}Ss", %p)},	undef,	"to_ascii\(\'\?\\u1BF3｡\\u0666\?\\u17D2Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3964\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}򤽎𑲛.󠔢︒≠", %p)},	undef,	"to_ascii\(\'\\u0664\?\?\.\?︒\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3965\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}򤽎𑲛.󠔢︒=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0664\?\?\.\?︒\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3966\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}򤽎𑲛.󠔢。≠", %p)},	undef,	"to_ascii\(\'\\u0664\?\?\.\?\。\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3967\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}򤽎𑲛.󠔢。=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0664\?\?\.\?\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3968\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕ỗ⒈．򑬒񡘮\x{085B}𝟫", %p)},	undef,	"to_ascii\(\'➆\?ỗ⒈．\?\?\\u085B𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3969\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕o\x{0302}\x{0303}⒈．򑬒񡘮\x{085B}𝟫", %p)},	undef,	"to_ascii\(\'➆\?o\\u0302\\u0303⒈．\?\?\\u085B𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3970\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕ỗ1..򑬒񡘮\x{085B}9", %p)},	undef,	"to_ascii\(\'➆\?ỗ1\.\.\?\?\\u085B9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3971\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕o\x{0302}\x{0303}1..򑬒񡘮\x{085B}9", %p)},	undef,	"to_ascii\(\'➆\?o\\u0302\\u03031\.\.\?\?\\u085B9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3972\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕O\x{0302}\x{0303}1..򑬒񡘮\x{085B}9", %p)},	undef,	"to_ascii\(\'➆\?O\\u0302\\u03031\.\.\?\?\\u085B9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3973\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕Ỗ1..򑬒񡘮\x{085B}9", %p)},	undef,	"to_ascii\(\'➆\?Ỗ1\.\.\?\?\\u085B9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3974\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕O\x{0302}\x{0303}⒈．򑬒񡘮\x{085B}𝟫", %p)},	undef,	"to_ascii\(\'➆\?O\\u0302\\u0303⒈．\?\?\\u085B𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3975\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕Ỗ⒈．򑬒񡘮\x{085B}𝟫", %p)},	undef,	"to_ascii\(\'➆\?Ỗ⒈．\?\?\\u085B𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3976\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200D}｡𞤘", %p)},	"xn--ye6h",	"to_ascii\(\'\\u200D｡\?\'\)\ \[data\/IdnaTest\.txt\:3977\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200D}。𞤘", %p)},	"xn--ye6h",	"to_ascii\(\'\\u200D\。\?\'\)\ \[data\/IdnaTest\.txt\:3979\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--ye6h", %p)},	"xn--ye6h",	"to_ascii\(\'xn\-\-ye6h\'\)\ \[data\/IdnaTest\.txt\:3981\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤺", %p)},	"xn--ye6h",	"to_ascii\(\'\?\'\)\ \[data\/IdnaTest\.txt\:3982\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0829}\x{0724}.ᢣ", %p)},	undef,	"to_ascii\(\'\\u0829\\u0724\.ᢣ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3983\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{073C}\x{200C}-。𓐾ß", %p)},	undef,	"to_ascii\(\'\\u073C\\u200C\-\。\?ß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3984\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{073C}\x{200C}-。𓐾SS", %p)},	undef,	"to_ascii\(\'\\u073C\\u200C\-\。\?SS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3986\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{073C}\x{200C}-。𓐾ss", %p)},	undef,	"to_ascii\(\'\\u073C\\u200C\-\。\?ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3988\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{073C}\x{200C}-。𓐾Ss", %p)},	undef,	"to_ascii\(\'\\u073C\\u200C\-\。\?Ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3990\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ς🃡⒗.\x{0CC6}仧\x{0756}", %p)},	undef,	"to_ascii\(\'\\u200Cς🃡⒗\.\\u0CC6仧\\u0756\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3992\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200C}ς🃡16..\x{0CC6}仧\x{0756}", %p)},	undef,	"to_ascii\(\'\\u200Cς🃡16\.\.\\u0CC6仧\\u0756\'\)\ throws\ error\ V5\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:3994\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200C}Σ🃡16..\x{0CC6}仧\x{0756}", %p)},	undef,	"to_ascii\(\'\\u200CΣ🃡16\.\.\\u0CC6仧\\u0756\'\)\ throws\ error\ V5\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:3996\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200C}σ🃡16..\x{0CC6}仧\x{0756}", %p)},	undef,	"to_ascii\(\'\\u200Cσ🃡16\.\.\\u0CC6仧\\u0756\'\)\ throws\ error\ V5\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:3998\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}Σ🃡⒗.\x{0CC6}仧\x{0756}", %p)},	undef,	"to_ascii\(\'\\u200CΣ🃡⒗\.\\u0CC6仧\\u0756\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4000\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}σ🃡⒗.\x{0CC6}仧\x{0756}", %p)},	undef,	"to_ascii\(\'\\u200Cσ🃡⒗\.\\u0CC6仧\\u0756\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4002\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("-.𞸚", %p)},	undef,	"to_ascii\(\'\-\.𞸚\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4004\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-.\x{0638}", %p)},	undef,	"to_ascii\(\'\-\.\\u0638\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4005\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򏛓\x{0683}.\x{0F7E}\x{0634}", %p)},	undef,	"to_ascii\(\'\?\\u0683\.\\u0F7E\\u0634\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4006\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FE6}\x{0843}񽶬.𐮏", %p)},	undef,	"to_ascii\(\'\\u0FE6\\u0843\?\.𐮏\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4007\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2񎨠\x{07CB}ß。ᠽ", %p)},	undef,	"to_ascii\(\'2\?\\u07CBß\。ᠽ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4008\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2񎨠\x{07CB}SS。ᠽ", %p)},	undef,	"to_ascii\(\'2\?\\u07CBSS\。ᠽ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4009\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2񎨠\x{07CB}ss。ᠽ", %p)},	undef,	"to_ascii\(\'2\?\\u07CBss\。ᠽ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4010\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2񎨠\x{07CB}Ss。ᠽ", %p)},	undef,	"to_ascii\(\'2\?\\u07CBSs\。ᠽ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4011\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}≮．\x{06CE}ß-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\≮．\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4012\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}<\x{0338}．\x{06CE}ß-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\<\\u0338．\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4014\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}≮.\x{06CE}ß-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\≮\.\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4016\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}<\x{0338}.\x{06CE}ß-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\<\\u0338\.\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4018\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}<\x{0338}.\x{06CE}SS-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\<\\u0338\.\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4020\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}≮.\x{06CE}SS-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\≮\.\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4022\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}≮.\x{06CE}ss-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\≮\.\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4024\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}<\x{0338}.\x{06CE}ss-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\<\\u0338\.\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4026\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}<\x{0338}.\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\<\\u0338\.\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4028\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}≮.\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\≮\.\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4030\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}<\x{0338}．\x{06CE}SS-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\<\\u0338．\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4032\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}≮．\x{06CE}SS-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\≮．\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4034\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}≮．\x{06CE}ss-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\≮．\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4036\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}<\x{0338}．\x{06CE}ss-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\<\\u0338．\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4038\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}<\x{0338}．\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\<\\u0338．\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4040\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㸳\x{07CA}≮．\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_ascii\(\'㸳\\u07CA\≮．\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4042\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-򷝬\x{135E}𑜧.\x{1DEB}-︒", %p)},	undef,	"to_ascii\(\'\-\?\\u135E𑜧\.\\u1DEB\-︒\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4044\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-򷝬\x{135E}𑜧.\x{1DEB}-。", %p)},	undef,	"to_ascii\(\'\-\?\\u135E𑜧\.\\u1DEB\-\。\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4045\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒.򚠡\x{1A59}", %p)},	undef,	"to_ascii\(\'︒\.\?\\u1A59\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4046\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。.򚠡\x{1A59}", %p)},	undef,	"to_ascii\(\'\。\.\?\\u1A59\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4047\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{0323}\x{2DE1}。\x{200C}⓾\x{200C}\x{06B9}", %p)},	undef,	"to_ascii\(\'\\u0323\\u2DE1\。\\u200C⓾\\u200C\\u06B9\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4048\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞠶ᠴ\x{06DD}｡\x{1074}𞤵󠅦", %p)},	undef,	"to_ascii\(\'𞠶ᠴ\\u06DD｡\\u1074\?\󠅦\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B1\ \[data\/IdnaTest\.txt\:4050\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠶ᠴ\x{06DD}。\x{1074}𞤵󠅦", %p)},	undef,	"to_ascii\(\'𞠶ᠴ\\u06DD\。\\u1074\?\󠅦\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B1\ \[data\/IdnaTest\.txt\:4051\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰺.-򑟏", %p)},	undef,	"to_ascii\(\'\?\.\-\?\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:4052\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠻩．赏", %p)},	undef,	"to_ascii\(\'\?．赏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4053\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠻩.赏", %p)},	undef,	"to_ascii\(\'\?\.赏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4054\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06B0}ᠡ｡Ⴁ", %p)},	undef,	"to_ascii\(\'\\u06B0ᠡ｡Ⴁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4055\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06B0}ᠡ。Ⴁ", %p)},	undef,	"to_ascii\(\'\\u06B0ᠡ\。Ⴁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4056\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{06B0}ᠡ。ⴁ", %p)},	undef,	"to_ascii\(\'\\u06B0ᠡ\。ⴁ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4057\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{06B0}ᠡ｡ⴁ", %p)},	undef,	"to_ascii\(\'\\u06B0ᠡ｡ⴁ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4058\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{20DE}Ⴊ\x{06BB}ς｡-", %p)},	undef,	"to_ascii\(\'\\u20DEႪ\\u06BBς｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4059\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{20DE}Ⴊ\x{06BB}ς。-", %p)},	undef,	"to_ascii\(\'\\u20DEႪ\\u06BBς\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4060\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{20DE}ⴊ\x{06BB}ς。-", %p)},	undef,	"to_ascii\(\'\\u20DEⴊ\\u06BBς\。\-\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4061\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{20DE}Ⴊ\x{06BB}Σ。-", %p)},	undef,	"to_ascii\(\'\\u20DEႪ\\u06BBΣ\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4062\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{20DE}ⴊ\x{06BB}σ。-", %p)},	undef,	"to_ascii\(\'\\u20DEⴊ\\u06BBσ\。\-\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4063\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{20DE}Ⴊ\x{06BB}σ。-", %p)},	undef,	"to_ascii\(\'\\u20DEႪ\\u06BBσ\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4064\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{20DE}ⴊ\x{06BB}ς｡-", %p)},	undef,	"to_ascii\(\'\\u20DEⴊ\\u06BBς｡\-\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4065\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{20DE}Ⴊ\x{06BB}Σ｡-", %p)},	undef,	"to_ascii\(\'\\u20DEႪ\\u06BBΣ｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4066\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{20DE}ⴊ\x{06BB}σ｡-", %p)},	undef,	"to_ascii\(\'\\u20DEⴊ\\u06BBσ｡\-\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4067\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{20DE}Ⴊ\x{06BB}σ｡-", %p)},	undef,	"to_ascii\(\'\\u20DEႪ\\u06BBσ｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4068\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴍ．񍇦\x{200C}", %p)},	undef,	"to_ascii\(\'Ⴍ．\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4069\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴍ.񍇦\x{200C}", %p)},	undef,	"to_ascii\(\'Ⴍ\.\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4071\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴍ.񍇦\x{200C}", %p)},	undef,	"to_ascii\(\'ⴍ\.\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4073\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴍ．񍇦\x{200C}", %p)},	undef,	"to_ascii\(\'ⴍ．\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4075\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򉟂󠵣.𐫫\x{1A60}󴺖\x{1B44}", %p)},	undef,	"to_ascii\(\'\?\?\.𐫫\\u1A60\?\\u1B44\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4077\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯❊ᠯ｡𐹱⺨", %p)},	undef,	"to_ascii\(\'\≯\❊ᠯ｡𐹱⺨\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4078\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}❊ᠯ｡𐹱⺨", %p)},	undef,	"to_ascii\(\'\>\\u0338\❊ᠯ｡𐹱⺨\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4079\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯❊ᠯ。𐹱⺨", %p)},	undef,	"to_ascii\(\'\≯\❊ᠯ\。𐹱⺨\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4080\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}❊ᠯ。𐹱⺨", %p)},	undef,	"to_ascii\(\'\>\\u0338\❊ᠯ\。𐹱⺨\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4081\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("􁕜𐹧𞭁𐹩。Ⴈ𐫮Ⴏ", %p)},	undef,	"to_ascii\(\'\?𐹧\?𐹩\。Ⴈ𐫮Ⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4082\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("􁕜𐹧𞭁𐹩。ⴈ𐫮ⴏ", %p)},	undef,	"to_ascii\(\'\?𐹧\?𐹩\。ⴈ𐫮ⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4083\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𞠂。\x{A926}", %p)},	undef,	"to_ascii\(\'𞠂\。\\uA926\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4084\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𝟔𐹫．\x{0733}\x{1037}９ꡇ", %p)},	undef,	"to_ascii\(\'𝟔𐹫．\\u0733\\u1037９ꡇ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4085\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𝟔𐹫．\x{1037}\x{0733}９ꡇ", %p)},	undef,	"to_ascii\(\'𝟔𐹫．\\u1037\\u0733９ꡇ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4086\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("6𐹫.\x{1037}\x{0733}9ꡇ", %p)},	undef,	"to_ascii\(\'6𐹫\.\\u1037\\u07339ꡇ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4087\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0724}\x{0603}𞲶．\x{06D8}", %p)},	undef,	"to_ascii\(\'\\u0724\\u0603\?．\\u06D8\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4088\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0724}\x{0603}𞲶.\x{06D8}", %p)},	undef,	"to_ascii\(\'\\u0724\\u0603\?\.\\u06D8\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4089\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("✆񱔩ꡋ．\x{0632}\x{200D}𞣴", %p)},	undef,	"to_ascii\(\'\✆\?ꡋ．\\u0632\\u200D\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4090\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("✆񱔩ꡋ.\x{0632}\x{200D}𞣴", %p)},	undef,	"to_ascii\(\'\✆\?ꡋ\.\\u0632\\u200D\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4092\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0845}񃾰𞸍-．≠򃁟𑋪", %p)},	undef,	"to_ascii\(\'\\u0845\?𞸍\-．\≠\?𑋪\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4094\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0845}񃾰𞸍-．=\x{0338}򃁟𑋪", %p)},	undef,	"to_ascii\(\'\\u0845\?𞸍\-．\=\\u0338\?𑋪\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4095\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0845}񃾰\x{0646}-.≠򃁟𑋪", %p)},	undef,	"to_ascii\(\'\\u0845\?\\u0646\-\.\≠\?𑋪\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4096\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0845}񃾰\x{0646}-.=\x{0338}򃁟𑋪", %p)},	undef,	"to_ascii\(\'\\u0845\?\\u0646\-\.\=\\u0338\?𑋪\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4097\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟛．笠", %p)},	"3.xn--6vz",	"to_ascii\(\'𝟛．笠\'\)\ \[data\/IdnaTest\.txt\:4098\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟛．笠", %p)},	"3.xn--6vz",	"to_ascii\(\'𝟛．笠\'\)\ \[data\/IdnaTest\.txt\:4099\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3.笠", %p)},	"3.xn--6vz",	"to_ascii\(\'3\.笠\'\)\ \[data\/IdnaTest\.txt\:4100\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3.xn--6vz", %p)},	"3.xn--6vz",	"to_ascii\(\'3\.xn\-\-6vz\'\)\ \[data\/IdnaTest\.txt\:4101\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200D}.Ⴞ𐋷", %p)},	undef,	"to_ascii\(\'\-\\u200D\.Ⴞ𐋷\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4102\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-\x{200D}.ⴞ𐋷", %p)},	undef,	"to_ascii\(\'\-\\u200D\.ⴞ𐋷\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4104\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}ςß\x{0731}．\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200Dςß\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4106\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ςß\x{0731}.\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200Dςß\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4108\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ΣSS\x{0731}.\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200DΣSS\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4110\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}σss\x{0731}.\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200Dσss\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4112\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}Σss\x{0731}.\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200DΣss\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4114\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}Σß\x{0731}.\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200DΣß\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4116\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}σß\x{0731}.\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200Dσß\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4118\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ΣSS\x{0731}．\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200DΣSS\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4120\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}σss\x{0731}．\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200Dσss\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4122\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}Σss\x{0731}．\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200DΣss\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4124\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}Σß\x{0731}．\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200DΣß\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4126\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}σß\x{0731}．\x{0BCD}", %p)},	undef,	"to_ascii\(\'\\u200Dσß\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4128\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠．\x{200D}", %p)},	undef,	"to_ascii\(\'\≠．\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4130\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}．\x{200D}", %p)},	undef,	"to_ascii\(\'\=\\u0338．\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4132\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠.\x{200D}", %p)},	undef,	"to_ascii\(\'\≠\.\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4134\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}.\x{200D}", %p)},	undef,	"to_ascii\(\'\=\\u0338\.\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4136\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FC01}｡\x{0C81}ᠼ▗򒁋", %p)},	undef,	"to_ascii\(\'\\uFC01｡\\u0C81ᠼ\▗\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4138\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0626}\x{062D}。\x{0C81}ᠼ▗򒁋", %p)},	undef,	"to_ascii\(\'\\u0626\\u062D\。\\u0C81ᠼ\▗\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4139\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{064A}\x{0654}\x{062D}。\x{0C81}ᠼ▗򒁋", %p)},	undef,	"to_ascii\(\'\\u064A\\u0654\\u062D\。\\u0C81ᠼ\▗\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4140\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}ς．ς𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDς．ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4141\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}ς.ς𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDς\.ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4142\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}Σ.Σ𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDΣ\.Σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4143\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}σ.ς𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDσ\.ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4144\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}σ.σ𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDσ\.σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4145\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}Σ.σ𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDΣ\.σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4146\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}Σ.ς𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDΣ\.ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4147\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}Σ．Σ𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDΣ．Σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4148\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}σ．ς𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDσ．ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4149\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}σ．σ𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDσ．σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4150\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}Σ．σ𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDΣ．σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4151\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧋵\x{09CD}Σ．ς𐨿", %p)},	undef,	"to_ascii\(\'\?\\u09CDΣ．ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4152\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫓\x{07D8}牅\x{08F8}｡𞦤\x{1A17}򱍰Ⴙ", %p)},	undef,	"to_ascii\(\'𐫓\\u07D8牅\\u08F8｡\?\\u1A17\?Ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4153\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫓\x{07D8}牅\x{08F8}。𞦤\x{1A17}򱍰Ⴙ", %p)},	undef,	"to_ascii\(\'𐫓\\u07D8牅\\u08F8\。\?\\u1A17\?Ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4154\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫓\x{07D8}牅\x{08F8}。𞦤\x{1A17}򱍰ⴙ", %p)},	undef,	"to_ascii\(\'𐫓\\u07D8牅\\u08F8\。\?\\u1A17\?ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4155\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫓\x{07D8}牅\x{08F8}｡𞦤\x{1A17}򱍰ⴙ", %p)},	undef,	"to_ascii\(\'𐫓\\u07D8牅\\u08F8｡\?\\u1A17\?ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4156\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񣤒｡륧", %p)},	undef,	"to_ascii\(\'\?｡륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4157\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񣤒｡륧", %p)},	undef,	"to_ascii\(\'\?｡륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4158\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񣤒。륧", %p)},	undef,	"to_ascii\(\'\?\。륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4159\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񣤒。륧", %p)},	undef,	"to_ascii\(\'\?\。륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4160\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹷\x{200D}。󉵢", %p)},	undef,	"to_ascii\(\'𐹷\\u200D\。\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴘ\x{06C2}𑲭｡-", %p)},	undef,	"to_ascii\(\'Ⴘ\\u06C2\?｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4163\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴘ\x{06C1}\x{0654}𑲭｡-", %p)},	undef,	"to_ascii\(\'Ⴘ\\u06C1\\u0654\?｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4164\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴘ\x{06C2}𑲭。-", %p)},	undef,	"to_ascii\(\'Ⴘ\\u06C2\?\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4165\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴘ\x{06C1}\x{0654}𑲭。-", %p)},	undef,	"to_ascii\(\'Ⴘ\\u06C1\\u0654\?\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4166\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴘ\x{06C1}\x{0654}𑲭。-", %p)},	undef,	"to_ascii\(\'ⴘ\\u06C1\\u0654\?\。\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4167\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴘ\x{06C2}𑲭。-", %p)},	undef,	"to_ascii\(\'ⴘ\\u06C2\?\。\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4168\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴘ\x{06C1}\x{0654}𑲭｡-", %p)},	undef,	"to_ascii\(\'ⴘ\\u06C1\\u0654\?｡\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4169\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴘ\x{06C2}𑲭｡-", %p)},	undef,	"to_ascii\(\'ⴘ\\u06C2\?｡\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4170\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{A806}\x{067B}₆ᡐ。🛇\x{FCDD}", %p)},	undef,	"to_ascii\(\'\\uA806\\u067B₆ᡐ\。🛇\\uFCDD\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4171\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{A806}\x{067B}6ᡐ。🛇\x{064A}\x{0645}", %p)},	undef,	"to_ascii\(\'\\uA806\\u067B6ᡐ\。🛇\\u064A\\u0645\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4172\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򸍂.㇄ᡟ𐫂\x{0622}", %p)},	undef,	"to_ascii\(\'\?\.㇄ᡟ𐫂\\u0622\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4173\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򸍂.㇄ᡟ𐫂\x{0627}\x{0653}", %p)},	undef,	"to_ascii\(\'\?\.㇄ᡟ𐫂\\u0627\\u0653\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4174\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07DF}򵚌。-\x{07E9}", %p)},	undef,	"to_ascii\(\'\\u07DF\?\。\-\\u07E9\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:4175\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς\x{0643}⾑．\x{200C}ᢟ\x{200C}⒈", %p)},	undef,	"to_ascii\(\'ς\\u0643⾑．\\u200Cᢟ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4176\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς\x{0643}襾.\x{200C}ᢟ\x{200C}1.", %p)},	undef,	"to_ascii\(\'ς\\u0643襾\.\\u200Cᢟ\\u200C1\.\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:4178\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ\x{0643}襾.\x{200C}ᢟ\x{200C}1.", %p)},	undef,	"to_ascii\(\'Σ\\u0643襾\.\\u200Cᢟ\\u200C1\.\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:4180\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ\x{0643}襾.\x{200C}ᢟ\x{200C}1.", %p)},	undef,	"to_ascii\(\'σ\\u0643襾\.\\u200Cᢟ\\u200C1\.\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:4182\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ\x{0643}⾑．\x{200C}ᢟ\x{200C}⒈", %p)},	undef,	"to_ascii\(\'Σ\\u0643⾑．\\u200Cᢟ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4184\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ\x{0643}⾑．\x{200C}ᢟ\x{200C}⒈", %p)},	undef,	"to_ascii\(\'σ\\u0643⾑．\\u200Cᢟ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4186\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡆ𑓝．𞵆", %p)},	undef,	"to_ascii\(\'ᡆ\?．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4188\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡆ𑓝.𞵆", %p)},	undef,	"to_ascii\(\'ᡆ\?\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4189\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0A4D}𦍓\x{1DEE}｡\x{200C}\x{08BD}񝹲", %p)},	undef,	"to_ascii\(\'\\u0A4D𦍓\\u1DEE｡\\u200C\\u08BD\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4190\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0A4D}𦍓\x{1DEE}。\x{200C}\x{08BD}񝹲", %p)},	undef,	"to_ascii\(\'\\u0A4D𦍓\\u1DEE\。\\u200C\\u08BD\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4192\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{062E}\x{0748}񅪪-．\x{200C}먿", %p)},	undef,	"to_ascii\(\'\\u062E\\u0748\?\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4194\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{062E}\x{0748}񅪪-．\x{200C}먿", %p)},	undef,	"to_ascii\(\'\\u062E\\u0748\?\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4196\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{062E}\x{0748}񅪪-.\x{200C}먿", %p)},	undef,	"to_ascii\(\'\\u062E\\u0748\?\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4198\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{062E}\x{0748}񅪪-.\x{200C}먿", %p)},	undef,	"to_ascii\(\'\\u062E\\u0748\?\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4200\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("􋿦｡ᠽ", %p)},	undef,	"to_ascii\(\'\?｡ᠽ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4202\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("􋿦。ᠽ", %p)},	undef,	"to_ascii\(\'\?\。ᠽ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4203\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("嬃𝍌．\x{200D}\x{0B44}", %p)},	undef,	"to_ascii\(\'嬃𝍌．\\u200D\\u0B44\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4204\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("嬃𝍌.\x{200D}\x{0B44}", %p)},	undef,	"to_ascii\(\'嬃𝍌\.\\u200D\\u0B44\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4206\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0602}𝌪≯．𚋲򵁨", %p)},	undef,	"to_ascii\(\'\\u0602𝌪\≯．\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4208\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0602}𝌪>\x{0338}．𚋲򵁨", %p)},	undef,	"to_ascii\(\'\\u0602𝌪\>\\u0338．\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4209\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0602}𝌪≯.𚋲򵁨", %p)},	undef,	"to_ascii\(\'\\u0602𝌪\≯\.\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4210\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0602}𝌪>\x{0338}.𚋲򵁨", %p)},	undef,	"to_ascii\(\'\\u0602𝌪\>\\u0338\.\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4211\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򫾥\x{08B7}\x{17CC}\x{A9C0}.𞼠", %p)},	undef,	"to_ascii\(\'\?\\u08B7\\u17CC\\uA9C0\.\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4212\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.񟛤", %p)},	undef,	"to_ascii\(\'\\u200C\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4213\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򺛕Ⴃ䠅．𐸑", %p)},	undef,	"to_ascii\(\'\?Ⴃ䠅．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4215\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򺛕Ⴃ䠅.𐸑", %p)},	undef,	"to_ascii\(\'\?Ⴃ䠅\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4216\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򺛕ⴃ䠅.𐸑", %p)},	undef,	"to_ascii\(\'\?ⴃ䠅\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4217\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򺛕ⴃ䠅．𐸑", %p)},	undef,	"to_ascii\(\'\?ⴃ䠅．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF1}𐹳𐹵𞤚｡𝟨Ⴅ", %p)},	undef,	"to_ascii\(\'\\u1BF1𐹳𐹵\?｡𝟨Ⴅ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4219\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF1}𐹳𐹵𞤚。6Ⴅ", %p)},	undef,	"to_ascii\(\'\\u1BF1𐹳𐹵\?\。6Ⴅ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4220\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{1BF1}𐹳𐹵𞤚。6ⴅ", %p)},	undef,	"to_ascii\(\'\\u1BF1𐹳𐹵\?\。6ⴅ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4221\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{1BF1}𐹳𐹵𞤚｡𝟨ⴅ", %p)},	undef,	"to_ascii\(\'\\u1BF1𐹳𐹵\?｡𝟨ⴅ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4222\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-｡︒", %p)},	undef,	"to_ascii\(\'\-｡︒\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4223\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。。", %p)},	undef,	"to_ascii\(\'\-\。\。\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:4224\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07DB}Ⴠ｡-⁵--", %p)},	undef,	"to_ascii\(\'\\u07DBჀ｡\-⁵\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4225\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07DB}Ⴠ。-5--", %p)},	undef,	"to_ascii\(\'\\u07DBჀ\。\-5\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4226\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{07DB}ⴠ。-5--", %p)},	undef,	"to_ascii\(\'\\u07DBⴠ\。\-5\-\-\'\)\ throws\ error\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4227\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{07DB}ⴠ｡-⁵--", %p)},	undef,	"to_ascii\(\'\\u07DBⴠ｡\-⁵\-\-\'\)\ throws\ error\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4228\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("≯\x{D8DD}󠑕｡𐹷𐹻≯𐷒", %p)},	undef,	"to_ascii\(\'\≯\\uD8DD\?｡𐹷𐹻\≯\?\'\)\ throws\ error\ P1\ V6\ B1\ A3\ \[data\/IdnaTest\.txt\:4229\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{D8DD}󠑕｡𐹷𐹻>\x{0338}𐷒", %p)},	undef,	"to_ascii\(\'\>\\u0338\\uD8DD\?｡𐹷𐹻\>\\u0338\?\'\)\ throws\ error\ P1\ V6\ B1\ A3\ \[data\/IdnaTest\.txt\:4230\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯\x{D8DD}󠑕。𐹷𐹻≯𐷒", %p)},	undef,	"to_ascii\(\'\≯\\uD8DD\?\。𐹷𐹻\≯\?\'\)\ throws\ error\ P1\ V6\ B1\ A3\ \[data\/IdnaTest\.txt\:4231\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{D8DD}󠑕。𐹷𐹻>\x{0338}𐷒", %p)},	undef,	"to_ascii\(\'\>\\u0338\\uD8DD\?\。𐹷𐹻\>\\u0338\?\'\)\ throws\ error\ P1\ V6\ B1\ A3\ \[data\/IdnaTest\.txt\:4232\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㍔\x{08E6}\x{077C}\x{200D}。\x{0346}򁳊𝅶\x{0604}", %p)},	undef,	"to_ascii\(\'㍔\\u08E6\\u077C\\u200D\。\\u0346\?\?\\u0604\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4233\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ルーブル\x{08E6}\x{077C}\x{200D}。\x{0346}򁳊𝅶\x{0604}", %p)},	undef,	"to_ascii\(\'ルーブル\\u08E6\\u077C\\u200D\。\\u0346\?\?\\u0604\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4235\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ルーフ\x{3099}ル\x{08E6}\x{077C}\x{200D}。\x{0346}򁳊𝅶\x{0604}", %p)},	undef,	"to_ascii\(\'ルーフ\\u3099ル\\u08E6\\u077C\\u200D\。\\u0346\?\?\\u0604\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4237\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}.F", %p)},	"f",	"to_ascii\(\'\\u200D\.F\'\)\ \[data\/IdnaTest\.txt\:4239\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("f", %p)},	"f",	"to_ascii\(\'f\'\)\ \[data\/IdnaTest\.txt\:4241\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}㨲｡ß", %p)},	"xn--9bm.ss",	"to_ascii\(\'\\u200D㨲｡ß\'\)\ \[data\/IdnaTest\.txt\:4242\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}㨲。ß", %p)},	"xn--9bm.ss",	"to_ascii\(\'\\u200D㨲\。ß\'\)\ \[data\/IdnaTest\.txt\:4244\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}㨲。SS", %p)},	"xn--9bm.ss",	"to_ascii\(\'\\u200D㨲\。SS\'\)\ \[data\/IdnaTest\.txt\:4246\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9bm.ss", %p)},	"xn--9bm.ss",	"to_ascii\(\'xn\-\-9bm\.ss\'\)\ \[data\/IdnaTest\.txt\:4248\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㨲.ss", %p)},	"xn--9bm.ss",	"to_ascii\(\'㨲\.ss\'\)\ \[data\/IdnaTest\.txt\:4249\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}㨲｡SS", %p)},	"xn--9bm.ss",	"to_ascii\(\'\\u200D㨲｡SS\'\)\ \[data\/IdnaTest\.txt\:4250\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0605}\x{067E}｡\x{08A8}", %p)},	undef,	"to_ascii\(\'\\u0605\\u067E｡\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4252\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0605}\x{067E}。\x{08A8}", %p)},	undef,	"to_ascii\(\'\\u0605\\u067E\。\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4253\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("⾑\x{0753}𞤁。𐹵\x{0682}", %p)},	undef,	"to_ascii\(\'⾑\\u0753\?\。𐹵\\u0682\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4254\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("襾\x{0753}𞤁。𐹵\x{0682}", %p)},	undef,	"to_ascii\(\'襾\\u0753\?\。𐹵\\u0682\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4255\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񦴻ς-\x{20EB}｡\x{0754}-ꡛ", %p)},	undef,	"to_ascii\(\'\?ς\-\\u20EB｡\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4256\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񦴻ς-\x{20EB}。\x{0754}-ꡛ", %p)},	undef,	"to_ascii\(\'\?ς\-\\u20EB\。\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4257\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񦴻Σ-\x{20EB}。\x{0754}-ꡛ", %p)},	undef,	"to_ascii\(\'\?Σ\-\\u20EB\。\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4258\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񦴻σ-\x{20EB}。\x{0754}-ꡛ", %p)},	undef,	"to_ascii\(\'\?σ\-\\u20EB\。\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4259\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񦴻Σ-\x{20EB}｡\x{0754}-ꡛ", %p)},	undef,	"to_ascii\(\'\?Σ\-\\u20EB｡\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4260\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񦴻σ-\x{20EB}｡\x{0754}-ꡛ", %p)},	undef,	"to_ascii\(\'\?σ\-\\u20EB｡\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4261\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}．􀸨", %p)},	undef,	"to_ascii\(\'\\u200D．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4262\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}.􀸨", %p)},	undef,	"to_ascii\(\'\\u200D\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4264\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񣭻񌥁｡≠𝟲", %p)},	undef,	"to_ascii\(\'\?\?｡\≠𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4266\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񣭻񌥁｡=\x{0338}𝟲", %p)},	undef,	"to_ascii\(\'\?\?｡\=\\u0338𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4267\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񣭻񌥁。≠6", %p)},	undef,	"to_ascii\(\'\?\?\。\≠6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4268\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񣭻񌥁。=\x{0338}6", %p)},	undef,	"to_ascii\(\'\?\?\。\=\\u03386\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4269\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅊ᡭ\x{200D}.𐥡", %p)},	undef,	"to_ascii\(\'\󠅊ᡭ\\u200D\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4270\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C40}\x{0855}𐥛𑄴．󭰵", %p)},	undef,	"to_ascii\(\'\\u0C40\\u0855\?𑄴．\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4272\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C40}\x{0855}𐥛𑄴.󭰵", %p)},	undef,	"to_ascii\(\'\\u0C40\\u0855\?𑄴\.\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4273\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤮。𑇊\x{200C}≯\x{1CE6}", %p)},	undef,	"to_ascii\(\'\?\。𑇊\\u200C\≯\\u1CE6\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4274\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤮。𑇊\x{200C}>\x{0338}\x{1CE6}", %p)},	undef,	"to_ascii\(\'\?\。𑇊\\u200C\>\\u0338\\u1CE6\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4276\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄀𝟕.𞤌񛗓Ⴉ", %p)},	undef,	"to_ascii\(\'\󠄀𝟕\.\?\?Ⴉ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4278\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄀7.𞤌񛗓Ⴉ", %p)},	undef,	"to_ascii\(\'\󠄀7\.\?\?Ⴉ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4279\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄀7.𞤌񛗓ⴉ", %p)},	undef,	"to_ascii\(\'\󠄀7\.\?\?ⴉ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4280\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄀𝟕.𞤌񛗓ⴉ", %p)},	undef,	"to_ascii\(\'\󠄀𝟕\.\?\?ⴉ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4281\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("閃9𝩍。Ↄ\x{0669}\x{08B1}\x{0B4D}", %p)},	undef,	"to_ascii\(\'閃9𝩍\。Ↄ\\u0669\\u08B1\\u0B4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4282\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("閃9𝩍。ↄ\x{0669}\x{08B1}\x{0B4D}", %p)},	undef,	"to_ascii\(\'閃9𝩍\。ↄ\\u0669\\u08B1\\u0B4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4283\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{AAF6}ᢏ\x{0E3A}２.𐋢\x{0745}\x{0F9F}︒", %p)},	undef,	"to_ascii\(\'\\uAAF6ᢏ\\u0E3A２\.𐋢\\u0745\\u0F9F︒\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4284\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{AAF6}ᢏ\x{0E3A}2.𐋢\x{0745}\x{0F9F}。", %p)},	undef,	"to_ascii\(\'\\uAAF6ᢏ\\u0E3A2\.𐋢\\u0745\\u0F9F\。\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4285\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󅴧｡≠-󠙄⾛", %p)},	undef,	"to_ascii\(\'\?｡\≠\-\?⾛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4286\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󅴧｡=\x{0338}-󠙄⾛", %p)},	undef,	"to_ascii\(\'\?｡\=\\u0338\-\?⾛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4287\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󅴧。≠-󠙄走", %p)},	undef,	"to_ascii\(\'\?\。\≠\-\?走\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4288\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󅴧。=\x{0338}-󠙄走", %p)},	undef,	"to_ascii\(\'\?\。\=\\u0338\-\?走\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4289\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{076E}\x{0604}Ⴊ。-≠\x{1160}", %p)},	undef,	"to_ascii\(\'\\u076E\\u0604Ⴊ\。\-\≠\\u1160\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4290\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{076E}\x{0604}Ⴊ。-=\x{0338}\x{1160}", %p)},	undef,	"to_ascii\(\'\\u076E\\u0604Ⴊ\。\-\=\\u0338\\u1160\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4291\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{076E}\x{0604}ⴊ。-=\x{0338}\x{1160}", %p)},	undef,	"to_ascii\(\'\\u076E\\u0604ⴊ\。\-\=\\u0338\\u1160\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4292\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{076E}\x{0604}ⴊ。-≠\x{1160}", %p)},	undef,	"to_ascii\(\'\\u076E\\u0604ⴊ\。\-\≠\\u1160\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4293\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FB4F}𐹧𝟒≯｡\x{200C}", %p)},	undef,	"to_ascii\(\'\\uFB4F𐹧𝟒\≯｡\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ \[data\/IdnaTest\.txt\:4294\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FB4F}𐹧𝟒>\x{0338}｡\x{200C}", %p)},	undef,	"to_ascii\(\'\\uFB4F𐹧𝟒\>\\u0338｡\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ \[data\/IdnaTest\.txt\:4296\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}\x{05DC}𐹧4≯。\x{200C}", %p)},	undef,	"to_ascii\(\'\\u05D0\\u05DC𐹧4\≯\。\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ \[data\/IdnaTest\.txt\:4298\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}\x{05DC}𐹧4>\x{0338}。\x{200C}", %p)},	undef,	"to_ascii\(\'\\u05D0\\u05DC𐹧4\>\\u0338\。\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ \[data\/IdnaTest\.txt\:4300\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟎。甯", %p)},	"0.xn--qny",	"to_ascii\(\'𝟎\。甯\'\)\ \[data\/IdnaTest\.txt\:4302\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0。甯", %p)},	"0.xn--qny",	"to_ascii\(\'0\。甯\'\)\ \[data\/IdnaTest\.txt\:4303\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.xn--qny", %p)},	"0.xn--qny",	"to_ascii\(\'0\.xn\-\-qny\'\)\ \[data\/IdnaTest\.txt\:4304\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.甯", %p)},	"0.xn--qny",	"to_ascii\(\'0\.甯\'\)\ \[data\/IdnaTest\.txt\:4305\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("-⾆．\x{AAF6}", %p)},	undef,	"to_ascii\(\'\-⾆．\\uAAF6\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4306\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("-舌.\x{AAF6}", %p)},	undef,	"to_ascii\(\'\-舌\.\\uAAF6\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4307\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-｡ᢘ", %p)},	undef,	"to_ascii\(\'\-｡ᢘ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4308\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。ᢘ", %p)},	undef,	"to_ascii\(\'\-\。ᢘ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4309\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂴Ⴋ.≮", %p)},	undef,	"to_ascii\(\'🂴Ⴋ\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4310\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂴Ⴋ.<\x{0338}", %p)},	undef,	"to_ascii\(\'🂴Ⴋ\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4311\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂴ⴋ.<\x{0338}", %p)},	undef,	"to_ascii\(\'🂴ⴋ\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4312\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂴ⴋ.≮", %p)},	undef,	"to_ascii\(\'🂴ⴋ\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4313\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("璼𝨭｡\x{200C}󠇟", %p)},	"xn--gky8837e.",	"to_ascii\(\'璼𝨭｡\\u200C\󠇟\'\)\ \[data\/IdnaTest\.txt\:4314\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("璼𝨭。\x{200C}󠇟", %p)},	"xn--gky8837e.",	"to_ascii\(\'璼𝨭\。\\u200C\󠇟\'\)\ \[data\/IdnaTest\.txt\:4316\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("xn--gky8837e.", %p)},	"xn--gky8837e.",	"to_ascii\(\'xn\-\-gky8837e\.\'\)\ \[data\/IdnaTest\.txt\:4318\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("璼𝨭.", %p)},	"xn--gky8837e.",	"to_ascii\(\'璼𝨭\.\'\)\ \[data\/IdnaTest\.txt\:4319\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0669}8񂍽｡-5🞥", %p)},	undef,	"to_ascii\(\'\\u06698\?｡\-5🞥\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4320\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0669}8񂍽。-5🞥", %p)},	undef,	"to_ascii\(\'\\u06698\?\。\-5🞥\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4321\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200C\.\\u200C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:4322\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}튛.\x{0716}", %p)},	"xn--157b.xn--gnb",	"to_ascii\(\'\\u200D튛\.\\u0716\'\)\ \[data\/IdnaTest\.txt\:4324\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}튛.\x{0716}", %p)},	"xn--157b.xn--gnb",	"to_ascii\(\'\\u200D튛\.\\u0716\'\)\ \[data\/IdnaTest\.txt\:4326\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--157b.xn--gnb", %p)},	"xn--157b.xn--gnb",	"to_ascii\(\'xn\-\-157b\.xn\-\-gnb\'\)\ \[data\/IdnaTest\.txt\:4328\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("튛.\x{0716}", %p)},	"xn--157b.xn--gnb",	"to_ascii\(\'튛\.\\u0716\'\)\ \[data\/IdnaTest\.txt\:4329\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("튛.\x{0716}", %p)},	"xn--157b.xn--gnb",	"to_ascii\(\'튛\.\\u0716\'\)\ \[data\/IdnaTest\.txt\:4330\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡋ𐹰𞽳.\x{0779}ⴞ", %p)},	undef,	"to_ascii\(\'ᡋ𐹰\?\.\\u0779ⴞ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4331\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡋ𐹰𞽳.\x{0779}Ⴞ", %p)},	undef,	"to_ascii\(\'ᡋ𐹰\?\.\\u0779Ⴞ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4332\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐷃\x{0662}𝅻𝟧．𐹮𐹬Ⴇ", %p)},	undef,	"to_ascii\(\'\?\\u0662𝅻𝟧．𐹮𐹬Ⴇ\'\)\ throws\ error\ P1\ V6\ B4\ B1\ \[data\/IdnaTest\.txt\:4333\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐷃\x{0662}𝅻5.𐹮𐹬Ⴇ", %p)},	undef,	"to_ascii\(\'\?\\u0662𝅻5\.𐹮𐹬Ⴇ\'\)\ throws\ error\ P1\ V6\ B4\ B1\ \[data\/IdnaTest\.txt\:4334\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐷃\x{0662}𝅻5.𐹮𐹬ⴇ", %p)},	undef,	"to_ascii\(\'\?\\u0662𝅻5\.𐹮𐹬ⴇ\'\)\ throws\ error\ P1\ V6\ B4\ B1\ \[data\/IdnaTest\.txt\:4335\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐷃\x{0662}𝅻𝟧．𐹮𐹬ⴇ", %p)},	undef,	"to_ascii\(\'\?\\u0662𝅻𝟧．𐹮𐹬ⴇ\'\)\ throws\ error\ P1\ V6\ B4\ B1\ \[data\/IdnaTest\.txt\:4336\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴗ．\x{05C2}𑄴\x{A9B7}񘃨", %p)},	undef,	"to_ascii\(\'Ⴗ．\\u05C2𑄴\\uA9B7\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4337\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴗ．𑄴\x{05C2}\x{A9B7}񘃨", %p)},	undef,	"to_ascii\(\'Ⴗ．𑄴\\u05C2\\uA9B7\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4338\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴗ.𑄴\x{05C2}\x{A9B7}񘃨", %p)},	undef,	"to_ascii\(\'Ⴗ\.𑄴\\u05C2\\uA9B7\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4339\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴗ.𑄴\x{05C2}\x{A9B7}񘃨", %p)},	undef,	"to_ascii\(\'ⴗ\.𑄴\\u05C2\\uA9B7\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴗ．𑄴\x{05C2}\x{A9B7}񘃨", %p)},	undef,	"to_ascii\(\'ⴗ．𑄴\\u05C2\\uA9B7\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4341\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴗ．\x{05C2}𑄴\x{A9B7}񘃨", %p)},	undef,	"to_ascii\(\'ⴗ．\\u05C2𑄴\\uA9B7\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟾𾤘．򇕛\x{066C}", %p)},	undef,	"to_ascii\(\'𝟾\?．\?\\u066C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4343\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8𾤘.򇕛\x{066C}", %p)},	undef,	"to_ascii\(\'8\?\.\?\\u066C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4344\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈酫︒。\x{08D6}", %p)},	undef,	"to_ascii\(\'⒈酫︒\。\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4345\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1.酫。。\x{08D6}", %p)},	undef,	"to_ascii\(\'1\.酫\。\。\\u08D6\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:4346\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{2DE3}\x{200C}≮\x{1A6B}.\x{200C}\x{0E3A}", %p)},	undef,	"to_ascii\(\'\\u2DE3\\u200C\≮\\u1A6B\.\\u200C\\u0E3A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4347\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DE3}\x{200C}<\x{0338}\x{1A6B}.\x{200C}\x{0E3A}", %p)},	undef,	"to_ascii\(\'\\u2DE3\\u200C\<\\u0338\\u1A6B\.\\u200C\\u0E3A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4349\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞪂。ႷႽ¹\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。ႷႽ¹\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4351\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞪂。ႷႽ1\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。ႷႽ1\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4353\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞪂。ⴗⴝ1\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。ⴗⴝ1\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4355\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞪂。Ⴗⴝ1\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。Ⴗⴝ1\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4357\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞪂。ⴗⴝ¹\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。ⴗⴝ¹\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4359\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞪂。Ⴗⴝ¹\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。Ⴗⴝ¹\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4361\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑄴𑄳2.𞳿󠀳-", %p)},	undef,	"to_ascii\(\'𑄴𑄳2\.\?\?\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:4363\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕲󟶶\x{0665}｡񀁁𑄳𞤃\x{0710}", %p)},	undef,	"to_ascii\(\'\?\?\\u0665｡\?𑄳\?\\u0710\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:4364\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕲󟶶\x{0665}。񀁁𑄳𞤃\x{0710}", %p)},	undef,	"to_ascii\(\'\?\?\\u0665\。\?𑄳\?\\u0710\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:4365\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0720}򲠽𐹢\x{17BB}｡ςᢈ🝭\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0720\?𐹢\\u17BB｡ςᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4366\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0720}򲠽𐹢\x{17BB}。ςᢈ🝭\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0720\?𐹢\\u17BB\。ςᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4368\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0720}򲠽𐹢\x{17BB}。Σᢈ🝭\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0720\?𐹢\\u17BB\。Σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4370\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0720}򲠽𐹢\x{17BB}。σᢈ🝭\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0720\?𐹢\\u17BB\。σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4372\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0720}򲠽𐹢\x{17BB}｡Σᢈ🝭\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0720\?𐹢\\u17BB｡Σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4374\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0720}򲠽𐹢\x{17BB}｡σᢈ🝭\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0720\?𐹢\\u17BB｡σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4376\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}--≮。𐹧", %p)},	undef,	"to_ascii\(\'\\u200D\-\-\≮\。𐹧\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4378\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}--<\x{0338}。𐹧", %p)},	undef,	"to_ascii\(\'\\u200D\-\-\<\\u0338\。𐹧\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4380\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A806}。𻚏\x{0FB0}⒕", %p)},	undef,	"to_ascii\(\'\\uA806\。\?\\u0FB0⒕\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4382\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A806}。𻚏\x{0FB0}14.", %p)},	undef,	"to_ascii\(\'\\uA806\。\?\\u0FB014\.\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4383\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򮉂\x{06BC}．𑆺\x{0669}", %p)},	undef,	"to_ascii\(\'\?\\u06BC．𑆺\\u0669\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4384\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򮉂\x{06BC}.𑆺\x{0669}", %p)},	undef,	"to_ascii\(\'\?\\u06BC\.𑆺\\u0669\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁎\x{06D0}-。𞤴", %p)},	undef,	"to_ascii\(\'\?\\u06D0\-\。\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4386\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𝟠4󠇗𝈻．\x{200D}𐋵⛧\x{200D}", %p)},	"xn--84-s850a.xn--59h6326e",	"to_ascii\(\'𝟠4\󠇗𝈻．\\u200D𐋵\⛧\\u200D\'\)\ \[data\/IdnaTest\.txt\:4387\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("84󠇗𝈻.\x{200D}𐋵⛧\x{200D}", %p)},	"xn--84-s850a.xn--59h6326e",	"to_ascii\(\'84\󠇗𝈻\.\\u200D𐋵\⛧\\u200D\'\)\ \[data\/IdnaTest\.txt\:4389\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--84-s850a.xn--59h6326e", %p)},	"xn--84-s850a.xn--59h6326e",	"to_ascii\(\'xn\-\-84\-s850a\.xn\-\-59h6326e\'\)\ \[data\/IdnaTest\.txt\:4391\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("84𝈻.𐋵⛧", %p)},	"xn--84-s850a.xn--59h6326e",	"to_ascii\(\'84𝈻\.𐋵\⛧\'\)\ \[data\/IdnaTest\.txt\:4392\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-\x{0601}｡ᡪ", %p)},	undef,	"to_ascii\(\'\-\\u0601｡ᡪ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4393\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{0601}。ᡪ", %p)},	undef,	"to_ascii\(\'\-\\u0601\。ᡪ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4394\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𝟕．謖ß≯", %p)},	undef,	"to_ascii\(\'\≮𝟕．謖ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4395\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𝟕．謖ß>\x{0338}", %p)},	undef,	"to_ascii\(\'\<\\u0338𝟕．謖ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4396\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮7.謖ß≯", %p)},	undef,	"to_ascii\(\'\≮7\.謖ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4397\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}7.謖ß>\x{0338}", %p)},	undef,	"to_ascii\(\'\<\\u03387\.謖ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4398\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}7.謖SS>\x{0338}", %p)},	undef,	"to_ascii\(\'\<\\u03387\.謖SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4399\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮7.謖SS≯", %p)},	undef,	"to_ascii\(\'\≮7\.謖SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4400\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮7.謖ss≯", %p)},	undef,	"to_ascii\(\'\≮7\.謖ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4401\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}7.謖ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\<\\u03387\.謖ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4402\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}7.謖Ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\<\\u03387\.謖Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4403\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮7.謖Ss≯", %p)},	undef,	"to_ascii\(\'\≮7\.謖Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4404\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𝟕．謖SS>\x{0338}", %p)},	undef,	"to_ascii\(\'\<\\u0338𝟕．謖SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4405\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𝟕．謖SS≯", %p)},	undef,	"to_ascii\(\'\≮𝟕．謖SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4406\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𝟕．謖ss≯", %p)},	undef,	"to_ascii\(\'\≮𝟕．謖ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4407\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𝟕．謖ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\<\\u0338𝟕．謖ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4408\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𝟕．謖Ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\<\\u0338𝟕．謖Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4409\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𝟕．謖Ss≯", %p)},	undef,	"to_ascii\(\'\≮𝟕．謖Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4410\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("朶Ⴉ𞪡.𝨽\x{0825}📻-", %p)},	undef,	"to_ascii\(\'朶Ⴉ\?\.𝨽\\u0825📻\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4411\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("朶ⴉ𞪡.𝨽\x{0825}📻-", %p)},	undef,	"to_ascii\(\'朶ⴉ\?\.𝨽\\u0825📻\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4412\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐤎。󑿰\x{200C}≮\x{200D}", %p)},	undef,	"to_ascii\(\'𐤎\。\?\\u200C\≮\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4413\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐤎。󑿰\x{200C}<\x{0338}\x{200D}", %p)},	undef,	"to_ascii\(\'𐤎\。\?\\u200C\<\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4415\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񭜎⒈｡\x{200C}𝟤", %p)},	undef,	"to_ascii\(\'\?⒈｡\\u200C𝟤\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񭜎1.。\x{200C}2", %p)},	undef,	"to_ascii\(\'\?1\.\。\\u200C2\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4419\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠟊𐹤\x{200D}．𐹳󙄵𐹶", %p)},	undef,	"to_ascii\(\'\?𐹤\\u200D．𐹳\?𐹶\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4421\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠟊𐹤\x{200D}.𐹳󙄵𐹶", %p)},	undef,	"to_ascii\(\'\?𐹤\\u200D\.𐹳\?𐹶\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4423\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤴𐹻𑓂𐭝．\x{094D}\x{FE07}􉛯", %p)},	undef,	"to_ascii\(\'\?𐹻𑓂𐭝．\\u094D\\uFE07\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4425\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤴𐹻𑓂𐭝.\x{094D}\x{FE07}􉛯", %p)},	undef,	"to_ascii\(\'\?𐹻𑓂𐭝\.\\u094D\\uFE07\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4426\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0668}｡𐹠𐹽񗮶", %p)},	undef,	"to_ascii\(\'\\u0668｡𐹠𐹽\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4427\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0668}。𐹠𐹽񗮶", %p)},	undef,	"to_ascii\(\'\\u0668\。𐹠𐹽\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4428\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1160}񍀜.8򶾵\x{069C}", %p)},	undef,	"to_ascii\(\'\\u1160\?\.8\?\\u069C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4429\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}\x{200C}󠆪｡ß𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'\\u200D\\u200C\󠆪｡ß𑓃\'\)\ \[data\/IdnaTest\.txt\:4430\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}\x{200C}󠆪。ß𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'\\u200D\\u200C\󠆪\。ß𑓃\'\)\ \[data\/IdnaTest\.txt\:4432\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}\x{200C}󠆪。SS𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'\\u200D\\u200C\󠆪\。SS𑓃\'\)\ \[data\/IdnaTest\.txt\:4434\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}\x{200C}󠆪。ss𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'\\u200D\\u200C\󠆪\。ss𑓃\'\)\ \[data\/IdnaTest\.txt\:4436\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}\x{200C}󠆪。Ss𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'\\u200D\\u200C\󠆪\。Ss𑓃\'\)\ \[data\/IdnaTest\.txt\:4438\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--ss-bh7o", %p)},	"xn--ss-bh7o",	"to_ascii\(\'xn\-\-ss\-bh7o\'\)\ \[data\/IdnaTest\.txt\:4440\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'ss𑓃\'\)\ \[data\/IdnaTest\.txt\:4441\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("SS𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'SS𑓃\'\)\ \[data\/IdnaTest\.txt\:4442\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Ss𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'Ss𑓃\'\)\ \[data\/IdnaTest\.txt\:4443\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}\x{200C}󠆪｡SS𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'\\u200D\\u200C\󠆪｡SS𑓃\'\)\ \[data\/IdnaTest\.txt\:4444\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}\x{200C}󠆪｡ss𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'\\u200D\\u200C\󠆪｡ss𑓃\'\)\ \[data\/IdnaTest\.txt\:4446\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}\x{200C}󠆪｡Ss𑓃", %p)},	"xn--ss-bh7o",	"to_ascii\(\'\\u200D\\u200C\󠆪｡Ss𑓃\'\)\ \[data\/IdnaTest\.txt\:4448\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("︒\x{200C}ヶ䒩.ꡪ", %p)},	undef,	"to_ascii\(\'︒\\u200Cヶ䒩\.ꡪ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4450\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("。\x{200C}ヶ䒩.ꡪ", %p)},	"xn--qekw60d.xn--gd9a",	"to_ascii\(\'\。\\u200Cヶ䒩\.ꡪ\'\)\ \[data\/IdnaTest\.txt\:4452\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("xn--qekw60d.xn--gd9a", %p)},	"xn--qekw60d.xn--gd9a",	"to_ascii\(\'xn\-\-qekw60d\.xn\-\-gd9a\'\)\ \[data\/IdnaTest\.txt\:4454\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ヶ䒩.ꡪ", %p)},	"xn--qekw60d.xn--gd9a",	"to_ascii\(\'ヶ䒩\.ꡪ\'\)\ \[data\/IdnaTest\.txt\:4455\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}⒈𤮍.󢓋\x{1A60}", %p)},	undef,	"to_ascii\(\'\\u200C⒈𤮍\.\?\\u1A60\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4456\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}1.𤮍.󢓋\x{1A60}", %p)},	undef,	"to_ascii\(\'\\u200C1\.𤮍\.\?\\u1A60\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4458\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈\x{200C}𐫓󠀺。\x{1A60}񤰵\x{200D}", %p)},	undef,	"to_ascii\(\'⒈\\u200C𐫓\?\。\\u1A60\?\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4460\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.\x{200C}𐫓󠀺。\x{1A60}񤰵\x{200D}", %p)},	undef,	"to_ascii\(\'1\.\\u200C𐫓\?\。\\u1A60\?\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:4462\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝅵｡𝟫𞀈䬺⒈", %p)},	undef,	"to_ascii\(\'\?｡𝟫\?䬺⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4464\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝅵。9𞀈䬺1.", %p)},	undef,	"to_ascii\(\'\?\。9\?䬺1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4465\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򡼺≯。盚\x{0635}", %p)},	undef,	"to_ascii\(\'\?\≯\。盚\\u0635\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4466\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򡼺>\x{0338}。盚\x{0635}", %p)},	undef,	"to_ascii\(\'\?\>\\u0338\。盚\\u0635\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4467\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񿰭\x{05B4}。-󠁊𐢸≯", %p)},	undef,	"to_ascii\(\'\-\?\\u05B4\。\-\?\?\≯\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4468\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񿰭\x{05B4}。-󠁊𐢸>\x{0338}", %p)},	undef,	"to_ascii\(\'\-\?\\u05B4\。\-\?\?\>\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4469\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󿭓\x{1B44}\x{200C}\x{0A4D}．𐭛񳋔", %p)},	undef,	"to_ascii\(\'\?\\u1B44\\u200C\\u0A4D．𐭛\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4470\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󿭓\x{1B44}\x{200C}\x{0A4D}.𐭛񳋔", %p)},	undef,	"to_ascii\(\'\?\\u1B44\\u200C\\u0A4D\.𐭛\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4471\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("⾇.\x{067D}𞤴\x{06BB}\x{200D}", %p)},	"xn--8c1a.xn--2ib8jn539l",	"to_ascii\(\'⾇\.\\u067D\?\\u06BB\\u200D\'\)\ \[data\/IdnaTest\.txt\:4472\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("舛.\x{067D}𞤴\x{06BB}\x{200D}", %p)},	"xn--8c1a.xn--2ib8jn539l",	"to_ascii\(\'舛\.\\u067D\?\\u06BB\\u200D\'\)\ \[data\/IdnaTest\.txt\:4474\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--8c1a.xn--2ib8jn539l", %p)},	"xn--8c1a.xn--2ib8jn539l",	"to_ascii\(\'xn\-\-8c1a\.xn\-\-2ib8jn539l\'\)\ \[data\/IdnaTest\.txt\:4476\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("舛.\x{067D}𞤴\x{06BB}", %p)},	"xn--8c1a.xn--2ib8jn539l",	"to_ascii\(\'舛\.\\u067D\?\\u06BB\'\)\ \[data\/IdnaTest\.txt\:4477\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("4򭆥。\x{0767}≯", %p)},	undef,	"to_ascii\(\'4\?\。\\u0767\≯\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:4478\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4򭆥。\x{0767}>\x{0338}", %p)},	undef,	"to_ascii\(\'4\?\。\\u0767\>\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:4479\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲔏𞫨񺿂硲．\x{06AD}", %p)},	undef,	"to_ascii\(\'\?\?\?硲．\\u06AD\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4480\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲔏𞫨񺿂硲.\x{06AD}", %p)},	undef,	"to_ascii\(\'\?\?\?硲\.\\u06AD\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4481\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.\x{FE08}\x{0666}Ⴆ℮", %p)},	undef,	"to_ascii\(\'\\u200C\.\\uFE08\\u0666Ⴆ℮\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4482\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}.\x{FE08}\x{0666}ⴆ℮", %p)},	undef,	"to_ascii\(\'\\u200C\.\\uFE08\\u0666ⴆ℮\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4484\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{06A3}．\x{0D4D}\x{200D}Ϟ", %p)},	undef,	"to_ascii\(\'\\u06A3．\\u0D4D\\u200DϞ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4486\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06A3}.\x{0D4D}\x{200D}Ϟ", %p)},	undef,	"to_ascii\(\'\\u06A3\.\\u0D4D\\u200DϞ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4487\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06A3}.\x{0D4D}\x{200D}ϟ", %p)},	undef,	"to_ascii\(\'\\u06A3\.\\u0D4D\\u200Dϟ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4488\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06A3}．\x{0D4D}\x{200D}ϟ", %p)},	undef,	"to_ascii\(\'\\u06A3．\\u0D4D\\u200Dϟ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4489\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200C}𞸇𑘿。\x{0623}𐮂-腍", %p)},	undef,	"to_ascii\(\'\\u200C𞸇𑘿\。\\u0623𐮂\-腍\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4490\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200C}𞸇𑘿。\x{0627}\x{0654}𐮂-腍", %p)},	undef,	"to_ascii\(\'\\u200C𞸇𑘿\。\\u0627\\u0654𐮂\-腍\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4492\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200C}\x{062D}𑘿。\x{0623}𐮂-腍", %p)},	undef,	"to_ascii\(\'\\u200C\\u062D𑘿\。\\u0623𐮂\-腍\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4494\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200C}\x{062D}𑘿。\x{0627}\x{0654}𐮂-腍", %p)},	undef,	"to_ascii\(\'\\u200C\\u062D𑘿\。\\u0627\\u0654𐮂\-腍\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4496\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-򭷙\x{066B}纛｡𝟛񭤇🄅", %p)},	undef,	"to_ascii\(\'\-\?\\u066B纛｡𝟛\?🄅\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4498\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-򭷙\x{066B}纛。3񭤇4,", %p)},	undef,	"to_ascii\(\'\-\?\\u066B纛\。3\?4\,\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4499\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🔔．Ⴂ\x{07CC}\x{0BCD}𐋮", %p)},	undef,	"to_ascii\(\'🔔．Ⴂ\\u07CC\\u0BCD𐋮\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4500\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🔔.Ⴂ\x{07CC}\x{0BCD}𐋮", %p)},	undef,	"to_ascii\(\'🔔\.Ⴂ\\u07CC\\u0BCD𐋮\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4501\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("🔔.ⴂ\x{07CC}\x{0BCD}𐋮", %p)},	undef,	"to_ascii\(\'🔔\.ⴂ\\u07CC\\u0BCD𐋮\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:4502\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("🔔．ⴂ\x{07CC}\x{0BCD}𐋮", %p)},	undef,	"to_ascii\(\'🔔．ⴂ\\u07CC\\u0BCD𐋮\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:4503\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("軥\x{06B3}.-𖬵", %p)},	undef,	"to_ascii\(\'軥\\u06B3\.\-𖬵\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4504\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹤\x{07CA}\x{06B6}.𐨂-", %p)},	undef,	"to_ascii\(\'𐹤\\u07CA\\u06B6\.𐨂\-\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:4505\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("-󠅱0｡\x{17CF}\x{1DFD}톇십", %p)},	undef,	"to_ascii\(\'\-\󠅱0｡\\u17CF\\u1DFD톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4506\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("-󠅱0｡\x{17CF}\x{1DFD}톇십", %p)},	undef,	"to_ascii\(\'\-\󠅱0｡\\u17CF\\u1DFD톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4507\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("-󠅱0。\x{17CF}\x{1DFD}톇십", %p)},	undef,	"to_ascii\(\'\-\󠅱0\。\\u17CF\\u1DFD톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4508\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("-󠅱0。\x{17CF}\x{1DFD}톇십", %p)},	undef,	"to_ascii\(\'\-\󠅱0\。\\u17CF\\u1DFD톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4509\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ꡰ︒--｡\x{17CC}靈𐹢񘳮", %p)},	undef,	"to_ascii\(\'ꡰ︒\-\-｡\\u17CC靈𐹢\?\'\)\ throws\ error\ P1\ V2\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4510\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡰ。--。\x{17CC}靈𐹢񘳮", %p)},	undef,	"to_ascii\(\'ꡰ\。\-\-\。\\u17CC靈𐹢\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4511\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}ႿႵრ｡\x{0B4D}", %p)},	undef,	"to_ascii\(\'\\u115FႿႵრ｡\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4512\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}ႿႵრ。\x{0B4D}", %p)},	undef,	"to_ascii\(\'\\u115FႿႵრ\。\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4513\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}ⴟⴕრ。\x{0B4D}", %p)},	undef,	"to_ascii\(\'\\u115Fⴟⴕრ\。\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4514\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}Ⴟⴕრ。\x{0B4D}", %p)},	undef,	"to_ascii\(\'\\u115FႿⴕრ\。\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4515\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}ⴟⴕრ｡\x{0B4D}", %p)},	undef,	"to_ascii\(\'\\u115Fⴟⴕრ｡\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4516\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}Ⴟⴕრ｡\x{0B4D}", %p)},	undef,	"to_ascii\(\'\\u115FႿⴕრ｡\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4517\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄃𐹠.\x{0664}󠅇", %p)},	undef,	"to_ascii\(\'🄃𐹠\.\\u0664\󠅇\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4518\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2,𐹠.\x{0664}󠅇", %p)},	undef,	"to_ascii\(\'2\,𐹠\.\\u0664\󠅇\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4519\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򻲼\x{200C}\x{FC5B}．\x{07D2}\x{0848}\x{1BF3}", %p)},	undef,	"to_ascii\(\'\?\\u200C\\uFC5B．\\u07D2\\u0848\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4520\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򻲼\x{200C}\x{0630}\x{0670}.\x{07D2}\x{0848}\x{1BF3}", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u0630\\u0670\.\\u07D2\\u0848\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4522\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200D}𞵪\x{200C}。ᡘ𑲭\x{17B5}", %p)},	undef,	"to_ascii\(\'\\u200D\\u200D\?\\u200C\。ᡘ\?\\u17B5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4524\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞷻。⚄񗑇𑁿", %p)},	undef,	"to_ascii\(\'\?\。\⚄\?𑁿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4526\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A8C4}≠．𞠨\x{0667}", %p)},	undef,	"to_ascii\(\'\\uA8C4\≠．𞠨\\u0667\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4527\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A8C4}=\x{0338}．𞠨\x{0667}", %p)},	undef,	"to_ascii\(\'\\uA8C4\=\\u0338．𞠨\\u0667\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4528\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A8C4}≠.𞠨\x{0667}", %p)},	undef,	"to_ascii\(\'\\uA8C4\≠\.𞠨\\u0667\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4529\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A8C4}=\x{0338}.𞠨\x{0667}", %p)},	undef,	"to_ascii\(\'\\uA8C4\=\\u0338\.𞠨\\u0667\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4530\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𝟛𝆪\x{A8C4}｡\x{A8EA}-", %p)},	undef,	"to_ascii\(\'𝟛𝆪\\uA8C4｡\\uA8EA\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4531\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𝟛\x{A8C4}𝆪｡\x{A8EA}-", %p)},	undef,	"to_ascii\(\'𝟛\\uA8C4𝆪｡\\uA8EA\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4532\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("3\x{A8C4}𝆪。\x{A8EA}-", %p)},	undef,	"to_ascii\(\'3\\uA8C4𝆪\。\\uA8EA\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4533\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{075F}\x{1BA2}\x{103A}Ⴇ.4", %p)},	undef,	"to_ascii\(\'\\u075F\\u1BA2\\u103AႧ\.4\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4534\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{075F}\x{1BA2}\x{103A}ⴇ.4", %p)},	undef,	"to_ascii\(\'\\u075F\\u1BA2\\u103Aⴇ\.4\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4535\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ᄹ｡\x{0ECA}򠯤󠄞", %p)},	undef,	"to_ascii\(\'ᄹ｡\\u0ECA\?\󠄞\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4536\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᄹ。\x{0ECA}򠯤󠄞", %p)},	undef,	"to_ascii\(\'ᄹ\。\\u0ECA\?\󠄞\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4537\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴆ򻢩．󠆡\x{FE09}𞤍", %p)},	undef,	"to_ascii\(\'Ⴆ\?．\󠆡\\uFE09\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4538\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴆ򻢩.󠆡\x{FE09}𞤍", %p)},	undef,	"to_ascii\(\'Ⴆ\?\.\󠆡\\uFE09\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4539\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴆ򻢩.󠆡\x{FE09}𞤍", %p)},	undef,	"to_ascii\(\'ⴆ\?\.\󠆡\\uFE09\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4540\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴆ򻢩．󠆡\x{FE09}𞤍", %p)},	undef,	"to_ascii\(\'ⴆ\?．\󠆡\\uFE09\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4541\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß\x{080B}︒\x{067B}．帼F∬\x{200C}", %p)},	undef,	"to_ascii\(\'ß\\u080B︒\\u067B．帼F\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4542\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ß\x{080B}。\x{067B}.帼F∫∫\x{200C}", %p)},	undef,	"to_ascii\(\'ß\\u080B\。\\u067B\.帼F\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4544\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ß\x{080B}。\x{067B}.帼f∫∫\x{200C}", %p)},	undef,	"to_ascii\(\'ß\\u080B\。\\u067B\.帼f\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4546\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("SS\x{080B}。\x{067B}.帼F∫∫\x{200C}", %p)},	undef,	"to_ascii\(\'SS\\u080B\。\\u067B\.帼F\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4548\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ss\x{080B}。\x{067B}.帼f∫∫\x{200C}", %p)},	undef,	"to_ascii\(\'ss\\u080B\。\\u067B\.帼f\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4550\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("Ss\x{080B}。\x{067B}.帼F∫∫\x{200C}", %p)},	undef,	"to_ascii\(\'Ss\\u080B\。\\u067B\.帼F\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4552\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ß\x{080B}︒\x{067B}．帼f∬\x{200C}", %p)},	undef,	"to_ascii\(\'ß\\u080B︒\\u067B．帼f\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4554\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS\x{080B}︒\x{067B}．帼F∬\x{200C}", %p)},	undef,	"to_ascii\(\'SS\\u080B︒\\u067B．帼F\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4556\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{080B}︒\x{067B}．帼f∬\x{200C}", %p)},	undef,	"to_ascii\(\'ss\\u080B︒\\u067B．帼f\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4558\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{080B}︒\x{067B}．帼F∬\x{200C}", %p)},	undef,	"to_ascii\(\'Ss\\u080B︒\\u067B．帼F\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4560\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󘪗｡𐹴𞨌\x{200D}", %p)},	undef,	"to_ascii\(\'\?｡𐹴\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4562\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󘪗。𐹴𞨌\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。𐹴\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4564\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗛨.򅟢𝟨\x{A8C4}", %p)},	undef,	"to_ascii\(\'\?\.\?𝟨\\uA8C4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4566\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗛨.򅟢6\x{A8C4}", %p)},	undef,	"to_ascii\(\'\?\.\?6\\uA8C4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4567\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1AB2}\x{FD8E}。-۹ႱႨ", %p)},	undef,	"to_ascii\(\'\\u1AB2\\uFD8E\。\-۹ႱႨ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4568\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1AB2}\x{0645}\x{062E}\x{062C}。-۹ႱႨ", %p)},	undef,	"to_ascii\(\'\\u1AB2\\u0645\\u062E\\u062C\。\-۹ႱႨ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4569\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{1AB2}\x{0645}\x{062E}\x{062C}。-۹ⴑⴈ", %p)},	undef,	"to_ascii\(\'\\u1AB2\\u0645\\u062E\\u062C\。\-۹ⴑⴈ\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4570\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{1AB2}\x{0645}\x{062E}\x{062C}。-۹Ⴑⴈ", %p)},	undef,	"to_ascii\(\'\\u1AB2\\u0645\\u062E\\u062C\。\-۹Ⴑⴈ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4571\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{1AB2}\x{FD8E}。-۹ⴑⴈ", %p)},	undef,	"to_ascii\(\'\\u1AB2\\uFD8E\。\-۹ⴑⴈ\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4572\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{1AB2}\x{FD8E}。-۹Ⴑⴈ", %p)},	undef,	"to_ascii\(\'\\u1AB2\\uFD8E\。\-۹Ⴑⴈ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4573\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤤．-\x{08A3}︒", %p)},	undef,	"to_ascii\(\'\?．\-\\u08A3︒\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4574\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤤.-\x{08A3}。", %p)},	undef,	"to_ascii\(\'\?\.\-\\u08A3\。\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:4575\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}𐺨.\x{0859}--", %p)},	undef,	"to_ascii\(\'\\u200C\?\.\\u0859\-\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ \[data\/IdnaTest\.txt\:4576\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋸󮘋Ⴢ.Ⴁ", %p)},	undef,	"to_ascii\(\'𐋸\?Ⴢ\.Ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4578\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋸󮘋ⴢ.ⴁ", %p)},	undef,	"to_ascii\(\'𐋸\?ⴢ\.ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4579\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋸󮘋Ⴢ.ⴁ", %p)},	undef,	"to_ascii\(\'𐋸\?Ⴢ\.ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4580\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗑿\x{A806}₄򩞆｡𲩧󠒹ς", %p)},	undef,	"to_ascii\(\'\?\\uA806₄\?｡\?\?ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4581\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗑿\x{A806}4򩞆。𲩧󠒹ς", %p)},	undef,	"to_ascii\(\'\?\\uA8064\?\。\?\?ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4582\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗑿\x{A806}4򩞆。𲩧󠒹Σ", %p)},	undef,	"to_ascii\(\'\?\\uA8064\?\。\?\?Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4583\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗑿\x{A806}4򩞆。𲩧󠒹σ", %p)},	undef,	"to_ascii\(\'\?\\uA8064\?\。\?\?σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4584\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗑿\x{A806}₄򩞆｡𲩧󠒹Σ", %p)},	undef,	"to_ascii\(\'\?\\uA806₄\?｡\?\?Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4585\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗑿\x{A806}₄򩞆｡𲩧󠒹σ", %p)},	undef,	"to_ascii\(\'\?\\uA806₄\?｡\?\?σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4586\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠆀\x{0723}。\x{1DF4}\x{0775}", %p)},	undef,	"to_ascii\(\'\󠆀\\u0723\。\\u1DF4\\u0775\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4587\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐹱\x{0842}𝪨｡𬼖Ⴑ\x{200D}", %p)},	undef,	"to_ascii\(\'𐹱\\u0842𝪨｡\?Ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4588\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹱\x{0842}𝪨。𬼖Ⴑ\x{200D}", %p)},	undef,	"to_ascii\(\'𐹱\\u0842𝪨\。\?Ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4590\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹱\x{0842}𝪨。𬼖ⴑ\x{200D}", %p)},	undef,	"to_ascii\(\'𐹱\\u0842𝪨\。\?ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4592\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹱\x{0842}𝪨｡𬼖ⴑ\x{200D}", %p)},	undef,	"to_ascii\(\'𐹱\\u0842𝪨｡\?ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4594\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1714}𐭪󠙘\x{200D}｡-𐹴", %p)},	undef,	"to_ascii\(\'\\u1714𐭪\?\\u200D｡\-𐹴\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4596\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1714}𐭪󠙘\x{200D}。-𐹴", %p)},	undef,	"to_ascii\(\'\\u1714𐭪\?\\u200D\。\-𐹴\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4598\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾢬｡\x{0729}︒쯙𝟧", %p)},	undef,	"to_ascii\(\'\?｡\\u0729︒쯙𝟧\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4600\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾢬｡\x{0729}︒쯙𝟧", %p)},	undef,	"to_ascii\(\'\?｡\\u0729︒쯙𝟧\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4601\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾢬。\x{0729}。쯙5", %p)},	undef,	"to_ascii\(\'\?\。\\u0729\。쯙5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4602\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾢬。\x{0729}。쯙5", %p)},	undef,	"to_ascii\(\'\?\。\\u0729\。쯙5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4603\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤟-。\x{0762}≮뻐", %p)},	undef,	"to_ascii\(\'\?\-\。\\u0762\≮뻐\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B2\ \[data\/IdnaTest\.txt\:4604\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤟-。\x{0762}<\x{0338}뻐", %p)},	undef,	"to_ascii\(\'\?\-\。\\u0762\<\\u0338뻐\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B2\ \[data\/IdnaTest\.txt\:4605\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥩-򊫠．\x{08B4}≠", %p)},	undef,	"to_ascii\(\'\?\-\?．\\u08B4\≠\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4606\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥩-򊫠．\x{08B4}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\-\?．\\u08B4\=\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4607\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥩-򊫠.\x{08B4}≠", %p)},	undef,	"to_ascii\(\'\?\-\?\.\\u08B4\≠\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4608\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥩-򊫠.\x{08B4}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\-\?\.\\u08B4\=\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4609\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񅂏ςႼ．\x{0661}", %p)},	undef,	"to_ascii\(\'\-\?ςႼ．\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4610\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񅂏ςႼ.\x{0661}", %p)},	undef,	"to_ascii\(\'\-\?ςႼ\.\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4611\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񅂏ςⴜ.\x{0661}", %p)},	undef,	"to_ascii\(\'\-\?ςⴜ\.\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4612\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񅂏ΣႼ.\x{0661}", %p)},	undef,	"to_ascii\(\'\-\?ΣႼ\.\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4613\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񅂏σⴜ.\x{0661}", %p)},	undef,	"to_ascii\(\'\-\?σⴜ\.\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4614\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񅂏Σⴜ.\x{0661}", %p)},	undef,	"to_ascii\(\'\-\?Σⴜ\.\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4615\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񅂏ςⴜ．\x{0661}", %p)},	undef,	"to_ascii\(\'\-\?ςⴜ．\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4616\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񅂏ΣႼ．\x{0661}", %p)},	undef,	"to_ascii\(\'\-\?ΣႼ．\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4617\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񅂏σⴜ．\x{0661}", %p)},	undef,	"to_ascii\(\'\-\?σⴜ．\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4618\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񅂏Σⴜ．\x{0661}", %p)},	undef,	"to_ascii\(\'\-\?Σⴜ．\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4619\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{17CA}.\x{200D}𝟮𑀿", %p)},	undef,	"to_ascii\(\'\\u17CA\.\\u200D𝟮𑀿\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4620\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{17CA}.\x{200D}2𑀿", %p)},	undef,	"to_ascii\(\'\\u17CA\.\\u200D2𑀿\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4622\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("≯𝟖｡\x{1A60}𐫓򟇑", %p)},	undef,	"to_ascii\(\'\≯𝟖｡\\u1A60𐫓\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4624\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}𝟖｡\x{1A60}𐫓򟇑", %p)},	undef,	"to_ascii\(\'\>\\u0338𝟖｡\\u1A60𐫓\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4625\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯8。\x{1A60}𐫓򟇑", %p)},	undef,	"to_ascii\(\'\≯8\。\\u1A60𐫓\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4626\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}8。\x{1A60}𐫓򟇑", %p)},	undef,	"to_ascii\(\'\>\\u03388\。\\u1A60𐫓\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4627\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑲫Ↄ\x{0664}｡\x{200C}", %p)},	undef,	"to_ascii\(\'\?Ↄ\\u0664｡\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4628\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑲫Ↄ\x{0664}。\x{200C}", %p)},	undef,	"to_ascii\(\'\?Ↄ\\u0664\。\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4630\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑲫ↄ\x{0664}。\x{200C}", %p)},	undef,	"to_ascii\(\'\?ↄ\\u0664\。\\u200C\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4632\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑲫ↄ\x{0664}｡\x{200C}", %p)},	undef,	"to_ascii\(\'\?ↄ\\u0664｡\\u200C\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4634\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0C00}𝟵\x{200D}\x{FC9D}.\x{200D}\x{0750}⒈", %p)},	undef,	"to_ascii\(\'\\u0C00𝟵\\u200D\\uFC9D\.\\u200D\\u0750⒈\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4636\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0C00}9\x{200D}\x{0628}\x{062D}.\x{200D}\x{0750}1.", %p)},	undef,	"to_ascii\(\'\\u0C009\\u200D\\u0628\\u062D\.\\u200D\\u07501\.\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4638\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{AAF6}。嬶ß葽", %p)},	undef,	"to_ascii\(\'\\uAAF6\。嬶ß葽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4640\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{AAF6}。嬶SS葽", %p)},	undef,	"to_ascii\(\'\\uAAF6\。嬶SS葽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4641\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{AAF6}。嬶ss葽", %p)},	undef,	"to_ascii\(\'\\uAAF6\。嬶ss葽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4642\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{AAF6}。嬶Ss葽", %p)},	undef,	"to_ascii\(\'\\uAAF6\。嬶Ss葽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4643\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𑚶⒈。񞻡𐹺", %p)},	undef,	"to_ascii\(\'𑚶⒈\。\?𐹺\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4644\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑚶1.。񞻡𐹺", %p)},	undef,	"to_ascii\(\'𑚶1\.\。\?𐹺\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:4645\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑜤︒≮．񚕽\x{05D8}𞾩", %p)},	undef,	"to_ascii\(\'𑜤︒\≮．\?\\u05D8\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4646\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑜤︒<\x{0338}．񚕽\x{05D8}𞾩", %p)},	undef,	"to_ascii\(\'𑜤︒\<\\u0338．\?\\u05D8\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4647\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑜤。≮.񚕽\x{05D8}𞾩", %p)},	undef,	"to_ascii\(\'𑜤\。\≮\.\?\\u05D8\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4648\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑜤。<\x{0338}.񚕽\x{05D8}𞾩", %p)},	undef,	"to_ascii\(\'𑜤\。\<\\u0338\.\?\\u05D8\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4649\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆋\x{0603}񏦤.⇁ς򏋈򺇥", %p)},	undef,	"to_ascii\(\'\󠆋\\u0603\?\.\⇁ς\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4650\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆋\x{0603}񏦤.⇁Σ򏋈򺇥", %p)},	undef,	"to_ascii\(\'\󠆋\\u0603\?\.\⇁Σ\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4651\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆋\x{0603}񏦤.⇁σ򏋈򺇥", %p)},	undef,	"to_ascii\(\'\󠆋\\u0603\?\.\⇁σ\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4652\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς𑐽𵢈𑜫｡𞬩\x{200C}𐫄", %p)},	undef,	"to_ascii\(\'ς\?\?𑜫｡\?\\u200C𐫄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4653\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς𑐽𵢈𑜫。𞬩\x{200C}𐫄", %p)},	undef,	"to_ascii\(\'ς\?\?𑜫\。\?\\u200C𐫄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4655\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ𑐽𵢈𑜫。𞬩\x{200C}𐫄", %p)},	undef,	"to_ascii\(\'Σ\?\?𑜫\。\?\\u200C𐫄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4657\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ𑐽𵢈𑜫。𞬩\x{200C}𐫄", %p)},	undef,	"to_ascii\(\'σ\?\?𑜫\。\?\\u200C𐫄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4659\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ𑐽𵢈𑜫｡𞬩\x{200C}𐫄", %p)},	undef,	"to_ascii\(\'Σ\?\?𑜫｡\?\\u200C𐫄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4661\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ𑐽𵢈𑜫｡𞬩\x{200C}𐫄", %p)},	undef,	"to_ascii\(\'σ\?\?𑜫｡\?\\u200C𐫄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4663\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-򵏽｡-\x{FC4C}\x{075B}", %p)},	undef,	"to_ascii\(\'\-\?｡\-\\uFC4C\\u075B\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4665\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-򵏽。-\x{0646}\x{062D}\x{075B}", %p)},	undef,	"to_ascii\(\'\-\?\。\-\\u0646\\u062D\\u075B\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4666\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⺢򇺅𝟤｡\x{200D}🚷", %p)},	undef,	"to_ascii\(\'⺢\?𝟤｡\\u200D🚷\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4667\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⺢򇺅2。\x{200D}🚷", %p)},	undef,	"to_ascii\(\'⺢\?2\。\\u200D🚷\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4669\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0CF8}\x{200D}\x{2DFE}𐹲｡򤐶", %p)},	undef,	"to_ascii\(\'\\u0CF8\\u200D\\u2DFE𐹲｡\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4671\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0CF8}\x{200D}\x{2DFE}𐹲。򤐶", %p)},	undef,	"to_ascii\(\'\\u0CF8\\u200D\\u2DFE𐹲\。\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4673\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹢．Ⴍ₉⁸", %p)},	undef,	"to_ascii\(\'𐹢．Ⴍ₉⁸\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4675\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹢.Ⴍ98", %p)},	undef,	"to_ascii\(\'𐹢\.Ⴍ98\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4676\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹢.ⴍ98", %p)},	undef,	"to_ascii\(\'𐹢\.ⴍ98\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4677\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹢．ⴍ₉⁸", %p)},	undef,	"to_ascii\(\'𐹢．ⴍ₉⁸\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4678\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}\x{034F}｡ß\x{08E2}⒚≯", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F｡ß\\u08E2⒚\≯\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4679\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}｡ß\x{08E2}⒚>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F｡ß\\u08E2⒚\>\\u0338\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4681\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}。ß\x{08E2}19.≯", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F\。ß\\u08E219\.\≯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4683\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}。ß\x{08E2}19.>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F\。ß\\u08E219\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4685\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}。SS\x{08E2}19.>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F\。SS\\u08E219\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4687\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}。SS\x{08E2}19.≯", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F\。SS\\u08E219\.\≯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4689\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}。ss\x{08E2}19.≯", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F\。ss\\u08E219\.\≯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4691\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}。ss\x{08E2}19.>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F\。ss\\u08E219\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4693\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}。Ss\x{08E2}19.>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F\。Ss\\u08E219\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4695\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}。Ss\x{08E2}19.≯", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F\。Ss\\u08E219\.\≯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4697\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}｡SS\x{08E2}⒚>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F｡SS\\u08E2⒚\>\\u0338\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4699\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}｡SS\x{08E2}⒚≯", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F｡SS\\u08E2⒚\≯\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4701\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}｡ss\x{08E2}⒚≯", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F｡ss\\u08E2⒚\≯\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4703\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}｡ss\x{08E2}⒚>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F｡ss\\u08E2⒚\>\\u0338\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4705\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}｡Ss\x{08E2}⒚>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F｡Ss\\u08E2⒚\>\\u0338\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4707\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{034F}｡Ss\x{08E2}⒚≯", %p)},	undef,	"to_ascii\(\'\\u200C\\u034F｡Ss\\u08E2⒚\≯\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4709\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𞥍ᡌ．𣃔", %p)},	undef,	"to_ascii\(\'\\u200C\?ᡌ．𣃔\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4711\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𞥍ᡌ.𣃔", %p)},	undef,	"to_ascii\(\'\\u200C\?ᡌ\.𣃔\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4713\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D0}򜬝-񡢬。\x{0FA0}Ⴛ𞷏𝆬", %p)},	undef,	"to_ascii\(\'\\u07D0\?\-\?\。\\u0FA0Ⴛ\?𝆬\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:4715\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D0}򜬝-񡢬。\x{0FA0}ⴛ𞷏𝆬", %p)},	undef,	"to_ascii\(\'\\u07D0\?\-\?\。\\u0FA0ⴛ\?𝆬\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:4716\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𝨥。⫟𑈾", %p)},	undef,	"to_ascii\(\'𝨥\。\⫟\?\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4717\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⾛\x{0753}.Ⴕ𞠬\x{0604}\x{200D}", %p)},	undef,	"to_ascii\(\'⾛\\u0753\.Ⴕ𞠬\\u0604\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4718\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走\x{0753}.Ⴕ𞠬\x{0604}\x{200D}", %p)},	undef,	"to_ascii\(\'走\\u0753\.Ⴕ𞠬\\u0604\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4720\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走\x{0753}.ⴕ𞠬\x{0604}\x{200D}", %p)},	undef,	"to_ascii\(\'走\\u0753\.ⴕ𞠬\\u0604\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4722\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛\x{0753}.ⴕ𞠬\x{0604}\x{200D}", %p)},	undef,	"to_ascii\(\'⾛\\u0753\.ⴕ𞠬\\u0604\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4724\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-ᢗ\x{200C}🄄.𑜢", %p)},	undef,	"to_ascii\(\'\-ᢗ\\u200C🄄\.𑜢\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4726\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-ᢗ\x{200C}3,.𑜢", %p)},	undef,	"to_ascii\(\'\-ᢗ\\u200C3\,\.𑜢\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4728\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠𐸁𹏁\x{200C}.Ⴚ򳄠", %p)},	undef,	"to_ascii\(\'\≠\?\?\\u200C\.Ⴚ\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4730\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}𐸁𹏁\x{200C}.Ⴚ򳄠", %p)},	undef,	"to_ascii\(\'\=\\u0338\?\?\\u200C\.Ⴚ\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4732\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}𐸁𹏁\x{200C}.ⴚ򳄠", %p)},	undef,	"to_ascii\(\'\=\\u0338\?\?\\u200C\.ⴚ\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4734\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠𐸁𹏁\x{200C}.ⴚ򳄠", %p)},	undef,	"to_ascii\(\'\≠\?\?\\u200C\.ⴚ\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4736\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{0669}｡󠇀𑇊", %p)},	undef,	"to_ascii\(\'\\u0669｡\󠇀𑇊\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4738\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{0669}。󠇀𑇊", %p)},	undef,	"to_ascii\(\'\\u0669\。\󠇀𑇊\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4739\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{1086}𞶀≯⒍。-", %p)},	undef,	"to_ascii\(\'\\u1086\?\≯⒍\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4740\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1086}𞶀>\x{0338}⒍。-", %p)},	undef,	"to_ascii\(\'\\u1086\?\>\\u0338⒍\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4741\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1086}𞶀≯6.。-", %p)},	undef,	"to_ascii\(\'\\u1086\?\≯6\.\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ A4_2\ \[data\/IdnaTest\.txt\:4742\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1086}𞶀>\x{0338}6.。-", %p)},	undef,	"to_ascii\(\'\\u1086\?\>\\u03386\.\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ A4_2\ \[data\/IdnaTest\.txt\:4743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17B4}.쮇-", %p)},	undef,	"to_ascii\(\'\\u17B4\.쮇\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:4744\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17B4}.쮇-", %p)},	undef,	"to_ascii\(\'\\u17B4\.쮇\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:4745\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𑓂。⒈-􀪛", %p)},	undef,	"to_ascii\(\'\\u200C𑓂\。⒈\-\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4746\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𑓂。1.-􀪛", %p)},	undef,	"to_ascii\(\'\\u200C𑓂\。1\.\-\?\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:4748\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈\x{FEAE}\x{200C}。\x{20E9}🖞\x{200C}𖬴", %p)},	undef,	"to_ascii\(\'⒈\\uFEAE\\u200C\。\\u20E9🖞\\u200C𖬴\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4750\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("1.\x{0631}\x{200C}。\x{20E9}🖞\x{200C}𖬴", %p)},	undef,	"to_ascii\(\'1\.\\u0631\\u200C\。\\u20E9🖞\\u200C𖬴\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4752\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󌭇｡𝟐\x{1BA8}\x{07D4}", %p)},	undef,	"to_ascii\(\'\?｡𝟐\\u1BA8\\u07D4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4754\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󌭇。2\x{1BA8}\x{07D4}", %p)},	undef,	"to_ascii\(\'\?\。2\\u1BA8\\u07D4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4755\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FD8F}򫳺.ς\x{200D}𐹷", %p)},	undef,	"to_ascii\(\'\\uFD8F\?\.ς\\u200D𐹷\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:4756\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0645}\x{062E}\x{0645}򫳺.ς\x{200D}𐹷", %p)},	undef,	"to_ascii\(\'\\u0645\\u062E\\u0645\?\.ς\\u200D𐹷\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:4758\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0645}\x{062E}\x{0645}򫳺.Σ\x{200D}𐹷", %p)},	undef,	"to_ascii\(\'\\u0645\\u062E\\u0645\?\.Σ\\u200D𐹷\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:4760\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0645}\x{062E}\x{0645}򫳺.σ\x{200D}𐹷", %p)},	undef,	"to_ascii\(\'\\u0645\\u062E\\u0645\?\.σ\\u200D𐹷\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:4762\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FD8F}򫳺.Σ\x{200D}𐹷", %p)},	undef,	"to_ascii\(\'\\uFD8F\?\.Σ\\u200D𐹷\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:4764\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FD8F}򫳺.σ\x{200D}𐹷", %p)},	undef,	"to_ascii\(\'\\uFD8F\?\.σ\\u200D𐹷\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:4766\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒎\x{06C1}\x{0605}｡\x{AAF6}۵𐇽", %p)},	undef,	"to_ascii\(\'⒎\\u06C1\\u0605｡\\uAAF6۵𐇽\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4768\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("7.\x{06C1}\x{0605}。\x{AAF6}۵𐇽", %p)},	undef,	"to_ascii\(\'7\.\\u06C1\\u0605\。\\uAAF6۵𐇽\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4769\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-ᡥ᠆󍲭。\x{0605}\x{1A5D}𐹡", %p)},	undef,	"to_ascii\(\'\-ᡥ᠆\?\。\\u0605\\u1A5D𐹡\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4770\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}.\x{06BD}\x{0663}\x{0596}", %p)},	"xn--hcb32bni",	"to_ascii\(\'\\u200D\.\\u06BD\\u0663\\u0596\'\)\ \[data\/IdnaTest\.txt\:4771\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hcb32bni", %p)},	"xn--hcb32bni",	"to_ascii\(\'xn\-\-hcb32bni\'\)\ \[data\/IdnaTest\.txt\:4773\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BD}\x{0663}\x{0596}", %p)},	"xn--hcb32bni",	"to_ascii\(\'\\u06BD\\u0663\\u0596\'\)\ \[data\/IdnaTest\.txt\:4774\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㒧۱.Ⴚ\x{0678}\x{200D}", %p)},	undef,	"to_ascii\(\'㒧۱\.Ⴚ\\u0678\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4775\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㒧۱.Ⴚ\x{064A}\x{0674}\x{200D}", %p)},	undef,	"to_ascii\(\'㒧۱\.Ⴚ\\u064A\\u0674\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4777\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("㒧۱.ⴚ\x{064A}\x{0674}\x{200D}", %p)},	undef,	"to_ascii\(\'㒧۱\.ⴚ\\u064A\\u0674\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4779\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("㒧۱.ⴚ\x{0678}\x{200D}", %p)},	undef,	"to_ascii\(\'㒧۱\.ⴚ\\u0678\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4781\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0F94}ꡋ-．-𖬴", %p)},	undef,	"to_ascii\(\'\\u0F94ꡋ\-．\-𖬴\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4783\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0F94}ꡋ-.-𖬴", %p)},	undef,	"to_ascii\(\'\\u0F94ꡋ\-\.\-𖬴\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4784\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񿒳-⋢\x{200C}．标-", %p)},	undef,	"to_ascii\(\'\?\-\⋢\\u200C．标\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:4785\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񿒳-⊑\x{0338}\x{200C}．标-", %p)},	undef,	"to_ascii\(\'\?\-\⊑\\u0338\\u200C．标\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:4787\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񿒳-⋢\x{200C}.标-", %p)},	undef,	"to_ascii\(\'\?\-\⋢\\u200C\.标\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:4789\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񿒳-⊑\x{0338}\x{200C}.标-", %p)},	undef,	"to_ascii\(\'\?\-\⊑\\u0338\\u200C\.标\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:4791\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{0671}．ς\x{07DC}", %p)},	undef,	"to_ascii\(\'\\u0671．ς\\u07DC\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4793\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{0671}.ς\x{07DC}", %p)},	undef,	"to_ascii\(\'\\u0671\.ς\\u07DC\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4794\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{0671}.Σ\x{07DC}", %p)},	undef,	"to_ascii\(\'\\u0671\.Σ\\u07DC\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4795\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{0671}.σ\x{07DC}", %p)},	undef,	"to_ascii\(\'\\u0671\.σ\\u07DC\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4796\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{0671}．Σ\x{07DC}", %p)},	undef,	"to_ascii\(\'\\u0671．Σ\\u07DC\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4797\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{0671}．σ\x{07DC}", %p)},	undef,	"to_ascii\(\'\\u0671．σ\\u07DC\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4798\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񼈶\x{0605}．\x{08C1}\x{200D}𑑂𱼱", %p)},	undef,	"to_ascii\(\'\?\\u0605．\\u08C1\\u200D\?\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4799\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񼈶\x{0605}.\x{08C1}\x{200D}𑑂𱼱", %p)},	undef,	"to_ascii\(\'\?\\u0605\.\\u08C1\\u200D\?\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4801\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹾𐋩𞵜｡\x{1BF2}", %p)},	undef,	"to_ascii\(\'𐹾𐋩\?｡\\u1BF2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4803\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹾𐋩𞵜。\x{1BF2}", %p)},	undef,	"to_ascii\(\'𐹾𐋩\?\。\\u1BF2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4804\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6\x{1160}\x{1C33}󠸧.򟜊锰\x{072C}ς", %p)},	undef,	"to_ascii\(\'6\\u1160\\u1C33\?\.\?锰\\u072Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4805\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6\x{1160}\x{1C33}󠸧.򟜊锰\x{072C}Σ", %p)},	undef,	"to_ascii\(\'6\\u1160\\u1C33\?\.\?锰\\u072CΣ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4806\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6\x{1160}\x{1C33}󠸧.򟜊锰\x{072C}σ", %p)},	undef,	"to_ascii\(\'6\\u1160\\u1C33\?\.\?锰\\u072Cσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4807\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06B3}\x{FE04}񅎦𝟽｡𐹽", %p)},	undef,	"to_ascii\(\'\\u06B3\\uFE04\?𝟽｡𐹽\'\)\ throws\ error\ P1\ V6\ B2\ B1\ \[data\/IdnaTest\.txt\:4808\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06B3}\x{FE04}񅎦7。𐹽", %p)},	undef,	"to_ascii\(\'\\u06B3\\uFE04\?7\。𐹽\'\)\ throws\ error\ P1\ V6\ B2\ B1\ \[data\/IdnaTest\.txt\:4809\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮧．\x{200C}⫞", %p)},	undef,	"to_ascii\(\'\?．\\u200C\⫞\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4810\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮧.\x{200C}⫞", %p)},	undef,	"to_ascii\(\'\?\.\\u200C\⫞\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4812\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-񕉴.\x{06E0}ᢚ-", %p)},	undef,	"to_ascii\(\'\-\?\.\\u06E0ᢚ\-\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4814\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("⌁\x{200D}𑄴．\x{200C}𝟩\x{066C}", %p)},	undef,	"to_ascii\(\'\⌁\\u200D𑄴．\\u200C𝟩\\u066C\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4815\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("⌁\x{200D}𑄴.\x{200C}7\x{066C}", %p)},	undef,	"to_ascii\(\'\⌁\\u200D𑄴\.\\u200C7\\u066C\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4817\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("︒\x{FD05}\x{0E37}\x{FEFC}。岓\x{1BF2}󠾃ᡂ", %p)},	undef,	"to_ascii\(\'︒\\uFD05\\u0E37\\uFEFC\。岓\\u1BF2\?ᡂ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4819\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。\x{0635}\x{0649}\x{0E37}\x{0644}\x{0627}。岓\x{1BF2}󠾃ᡂ", %p)},	undef,	"to_ascii\(\'\。\\u0635\\u0649\\u0E37\\u0644\\u0627\。岓\\u1BF2\?ᡂ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4820\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𐹨。8𑁆", %p)},	undef,	"to_ascii\(\'𐹨\。8𑁆\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4821\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞀕\x{0D43}．ꡚ\x{08FA}𐹰\x{0D44}", %p)},	undef,	"to_ascii\(\'\?\\u0D43．ꡚ\\u08FA𐹰\\u0D44\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4822\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞀕\x{0D43}.ꡚ\x{08FA}𐹰\x{0D44}", %p)},	undef,	"to_ascii\(\'\?\\u0D43\.ꡚ\\u08FA𐹰\\u0D44\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4823\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󆩏𐦹\x{0303}｡󠍅", %p)},	undef,	"to_ascii\(\'\?\?\\u0303｡\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4824\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󆩏𐦹\x{0303}。󠍅", %p)},	undef,	"to_ascii\(\'\?\?\\u0303\。\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4825\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("ᢌ．-\x{085A}", %p)},	undef,	"to_ascii\(\'ᢌ．\-\\u085A\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4826\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("ᢌ.-\x{085A}", %p)},	undef,	"to_ascii\(\'ᢌ\.\-\\u085A\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4827\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𥛛𑘶｡𐹬𐲸\x{0BCD}", %p)},	undef,	"to_ascii\(\'𥛛𑘶｡𐹬\?\\u0BCD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4828\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𥛛𑘶。𐹬𐲸\x{0BCD}", %p)},	undef,	"to_ascii\(\'𥛛𑘶\。𐹬\?\\u0BCD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4829\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴐ\x{077F}．\x{200C}", %p)},	undef,	"to_ascii\(\'Ⴐ\\u077F．\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4830\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴐ\x{077F}.\x{200C}", %p)},	undef,	"to_ascii\(\'Ⴐ\\u077F\.\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4832\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ⴐ\x{077F}.\x{200C}", %p)},	undef,	"to_ascii\(\'ⴐ\\u077F\.\\u200C\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4834\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ⴐ\x{077F}．\x{200C}", %p)},	undef,	"to_ascii\(\'ⴐ\\u077F．\\u200C\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4836\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("🄅𑲞-⒈。\x{200D}ᠩ\x{06A5}", %p)},	undef,	"to_ascii\(\'🄅\?\-⒈\。\\u200Dᠩ\\u06A5\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4838\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4,𑲞-1.。\x{200D}ᠩ\x{06A5}", %p)},	undef,	"to_ascii\(\'4\,\?\-1\.\。\\u200Dᠩ\\u06A5\'\)\ throws\ error\ P1\ V6\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:4840\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗀤。𞤪򮿋", %p)},	undef,	"to_ascii\(\'\?\。\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4842\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{05C1}۲｡𐮊\x{066C}𝨊鄨", %p)},	undef,	"to_ascii\(\'\\u05C1۲｡𐮊\\u066C𝨊鄨\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:4843\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{05C1}۲。𐮊\x{066C}𝨊鄨", %p)},	undef,	"to_ascii\(\'\\u05C1۲\。𐮊\\u066C𝨊鄨\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:4844\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞭳-ꡁ。\x{1A69}\x{0BCD}-", %p)},	undef,	"to_ascii\(\'\?\-ꡁ\。\\u1A69\\u0BCD\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:4845\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1039}-𚮭🞢．ß", %p)},	undef,	"to_ascii\(\'\\u1039\-\?🞢．ß\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4846\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1039}-𚮭🞢.ß", %p)},	undef,	"to_ascii\(\'\\u1039\-\?🞢\.ß\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4847\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1039}-𚮭🞢.SS", %p)},	undef,	"to_ascii\(\'\\u1039\-\?🞢\.SS\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4848\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1039}-𚮭🞢．SS", %p)},	undef,	"to_ascii\(\'\\u1039\-\?🞢．SS\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4849\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FCF2}-\x{200C}｡Ⴟ\x{200C}␣", %p)},	undef,	"to_ascii\(\'\\uFCF2\-\\u200C｡Ⴟ\\u200C\␣\'\)\ throws\ error\ P1\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:4850\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0640}\x{064E}\x{0651}-\x{200C}。Ⴟ\x{200C}␣", %p)},	undef,	"to_ascii\(\'\\u0640\\u064E\\u0651\-\\u200C\。Ⴟ\\u200C\␣\'\)\ throws\ error\ P1\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:4852\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0640}\x{064E}\x{0651}-\x{200C}。ⴟ\x{200C}␣", %p)},	undef,	"to_ascii\(\'\\u0640\\u064E\\u0651\-\\u200C\。ⴟ\\u200C\␣\'\)\ throws\ error\ V3\ B3\ \[data\/IdnaTest\.txt\:4854\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{FCF2}-\x{200C}｡ⴟ\x{200C}␣", %p)},	undef,	"to_ascii\(\'\\uFCF2\-\\u200C｡ⴟ\\u200C\␣\'\)\ throws\ error\ V3\ B3\ \[data\/IdnaTest\.txt\:4856\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0D4D}-\x{200D}\x{200C}｡񥞧₅≠", %p)},	undef,	"to_ascii\(\'\\u0D4D\-\\u200D\\u200C｡\?₅\≠\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4858\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0D4D}-\x{200D}\x{200C}｡񥞧₅=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0D4D\-\\u200D\\u200C｡\?₅\=\\u0338\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4860\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0D4D}-\x{200D}\x{200C}。񥞧5≠", %p)},	undef,	"to_ascii\(\'\\u0D4D\-\\u200D\\u200C\。\?5\≠\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4862\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0D4D}-\x{200D}\x{200C}。񥞧5=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0D4D\-\\u200D\\u200C\。\?5\=\\u0338\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4864\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("锣。\x{0A4D}󠘻󠚆", %p)},	undef,	"to_ascii\(\'锣\。\\u0A4D\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4866\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{063D}𑈾．\x{0649}\x{200D}\x{A92B}", %p)},	"xn--8gb2338k.xn--lhb0154f",	"to_ascii\(\'\\u063D\?．\\u0649\\u200D\\uA92B\'\)\ \[data\/IdnaTest\.txt\:4867\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{063D}𑈾.\x{0649}\x{200D}\x{A92B}", %p)},	"xn--8gb2338k.xn--lhb0154f",	"to_ascii\(\'\\u063D\?\.\\u0649\\u200D\\uA92B\'\)\ \[data\/IdnaTest\.txt\:4869\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--8gb2338k.xn--lhb0154f", %p)},	"xn--8gb2338k.xn--lhb0154f",	"to_ascii\(\'xn\-\-8gb2338k\.xn\-\-lhb0154f\'\)\ \[data\/IdnaTest\.txt\:4871\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{063D}𑈾.\x{0649}\x{A92B}", %p)},	"xn--8gb2338k.xn--lhb0154f",	"to_ascii\(\'\\u063D\?\.\\u0649\\uA92B\'\)\ \[data\/IdnaTest\.txt\:4872\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0666}⁴Ⴅ．\x{08BD}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0666⁴Ⴅ．\\u08BD\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4873\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0666}4Ⴅ.\x{08BD}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06664Ⴅ\.\\u08BD\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4875\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{0666}4ⴅ.\x{08BD}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06664ⴅ\.\\u08BD\\u200C\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4877\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{0666}⁴ⴅ．\x{08BD}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0666⁴ⴅ．\\u08BD\\u200C\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4879\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ჁႱ6\x{0318}。ß\x{1B03}", %p)},	undef,	"to_ascii\(\'ჁႱ6\\u0318\。ß\\u1B03\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4881\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ⴡⴑ6\x{0318}。ß\x{1B03}", %p)},	"xn--6-8cb7433a2ba.xn--ss-2vq",	"to_ascii\(\'ⴡⴑ6\\u0318\。ß\\u1B03\'\)\ \[data\/IdnaTest\.txt\:4882\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ჁႱ6\x{0318}。SS\x{1B03}", %p)},	undef,	"to_ascii\(\'ჁႱ6\\u0318\。SS\\u1B03\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4884\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ⴡⴑ6\x{0318}。ss\x{1B03}", %p)},	"xn--6-8cb7433a2ba.xn--ss-2vq",	"to_ascii\(\'ⴡⴑ6\\u0318\。ss\\u1B03\'\)\ \[data\/IdnaTest\.txt\:4885\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴡⴑ6\x{0318}。Ss\x{1B03}", %p)},	undef,	"to_ascii\(\'Ⴡⴑ6\\u0318\。Ss\\u1B03\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4886\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("xn--6-8cb7433a2ba.xn--ss-2vq", %p)},	"xn--6-8cb7433a2ba.xn--ss-2vq",	"to_ascii\(\'xn\-\-6\-8cb7433a2ba\.xn\-\-ss\-2vq\'\)\ \[data\/IdnaTest\.txt\:4887\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ⴡⴑ6\x{0318}.ss\x{1B03}", %p)},	"xn--6-8cb7433a2ba.xn--ss-2vq",	"to_ascii\(\'ⴡⴑ6\\u0318\.ss\\u1B03\'\)\ \[data\/IdnaTest\.txt\:4888\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ჁႱ6\x{0318}.SS\x{1B03}", %p)},	undef,	"to_ascii\(\'ჁႱ6\\u0318\.SS\\u1B03\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4889\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴡⴑ6\x{0318}.Ss\x{1B03}", %p)},	undef,	"to_ascii\(\'Ⴡⴑ6\\u0318\.Ss\\u1B03\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4890\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("xn--6-8cb7433a2ba.xn--zca894k", %p)},	"xn--6-8cb7433a2ba.xn--zca894k",	"to_ascii\(\'xn\-\-6\-8cb7433a2ba\.xn\-\-zca894k\'\)\ \[data\/IdnaTest\.txt\:4891\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ⴡⴑ6\x{0318}.ß\x{1B03}", %p)},	"xn--6-8cb7433a2ba.xn--ss-2vq",	"to_ascii\(\'ⴡⴑ6\\u0318\.ß\\u1B03\'\)\ \[data\/IdnaTest\.txt\:4892\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򋡐｡≯𑋪", %p)},	undef,	"to_ascii\(\'\?｡\≯𑋪\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4894\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򋡐｡>\x{0338}𑋪", %p)},	undef,	"to_ascii\(\'\?｡\>\\u0338𑋪\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4895\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򋡐。≯𑋪", %p)},	undef,	"to_ascii\(\'\?\。\≯𑋪\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4896\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򋡐。>\x{0338}𑋪", %p)},	undef,	"to_ascii\(\'\?\。\>\\u0338𑋪\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4897\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{065A}۲。\x{200C}-\x{1BF3}\x{08E2}", %p)},	undef,	"to_ascii\(\'\\u065A۲\。\\u200C\-\\u1BF3\\u08E2\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4898\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄏𖬴󠲽｡\x{FFA0}", %p)},	undef,	"to_ascii\(\'\󠄏𖬴\?｡\\uFFA0\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4900\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄏𖬴󠲽。\x{1160}", %p)},	undef,	"to_ascii\(\'\󠄏𖬴\?\。\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4901\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß⒈\x{0760}\x{D7AE}．􉖲󠅄\x{0605}򉔯", %p)},	undef,	"to_ascii\(\'ß⒈\\u0760\\uD7AE．\?\󠅄\\u0605\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4902\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß1.\x{0760}\x{D7AE}.􉖲󠅄\x{0605}򉔯", %p)},	undef,	"to_ascii\(\'ß1\.\\u0760\\uD7AE\.\?\󠅄\\u0605\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:4903\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS1.\x{0760}\x{D7AE}.􉖲󠅄\x{0605}򉔯", %p)},	undef,	"to_ascii\(\'SS1\.\\u0760\\uD7AE\.\?\󠅄\\u0605\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:4904\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS⒈\x{0760}\x{D7AE}．􉖲󠅄\x{0605}򉔯", %p)},	undef,	"to_ascii\(\'SS⒈\\u0760\\uD7AE．\?\󠅄\\u0605\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4905\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss⒈\x{0760}\x{D7AE}．􉖲󠅄\x{0605}򉔯", %p)},	undef,	"to_ascii\(\'ss⒈\\u0760\\uD7AE．\?\󠅄\\u0605\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4906\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss⒈\x{0760}\x{D7AE}．􉖲󠅄\x{0605}򉔯", %p)},	undef,	"to_ascii\(\'Ss⒈\\u0760\\uD7AE．\?\󠅄\\u0605\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4907\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠭔.𐋱₂", %p)},	undef,	"to_ascii\(\'\?\.𐋱₂\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4908\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠭔.𐋱2", %p)},	undef,	"to_ascii\(\'\?\.𐋱2\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4909\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0716}\x{0947}。-ß\x{06A5}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0716\\u0947\。\-ß\\u06A5\\u200C\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:4910\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0716}\x{0947}。-SS\x{06A5}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0716\\u0947\。\-SS\\u06A5\\u200C\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:4912\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0716}\x{0947}。-ss\x{06A5}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0716\\u0947\。\-ss\\u06A5\\u200C\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:4914\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0716}\x{0947}。-Ss\x{06A5}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0716\\u0947\。\-Ss\\u06A5\\u200C\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:4916\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BA9}\x{200D}\x{062A}񡚈．\x{1CD5}䷉Ⴡ", %p)},	undef,	"to_ascii\(\'\\u1BA9\\u200D\\u062A\?．\\u1CD5䷉Ⴡ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4918\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BA9}\x{200D}\x{062A}񡚈.\x{1CD5}䷉Ⴡ", %p)},	undef,	"to_ascii\(\'\\u1BA9\\u200D\\u062A\?\.\\u1CD5䷉Ⴡ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4920\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BA9}\x{200D}\x{062A}񡚈.\x{1CD5}䷉ⴡ", %p)},	undef,	"to_ascii\(\'\\u1BA9\\u200D\\u062A\?\.\\u1CD5䷉ⴡ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4922\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BA9}\x{200D}\x{062A}񡚈．\x{1CD5}䷉ⴡ", %p)},	undef,	"to_ascii\(\'\\u1BA9\\u200D\\u062A\?．\\u1CD5䷉ⴡ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4924\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DBF}.ß\x{200D}", %p)},	undef,	"to_ascii\(\'\\u2DBF\.ß\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4926\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DBF}.SS\x{200D}", %p)},	undef,	"to_ascii\(\'\\u2DBF\.SS\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4928\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DBF}.ss\x{200D}", %p)},	undef,	"to_ascii\(\'\\u2DBF\.ss\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4930\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DBF}.Ss\x{200D}", %p)},	undef,	"to_ascii\(\'\\u2DBF\.Ss\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4932\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}︒.\x{062A}≯ꡂ", %p)},	undef,	"to_ascii\(\'\\u1BF3︒\.\\u062A\≯ꡂ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4934\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}︒.\x{062A}>\x{0338}ꡂ", %p)},	undef,	"to_ascii\(\'\\u1BF3︒\.\\u062A\>\\u0338ꡂ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4935\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}。.\x{062A}≯ꡂ", %p)},	undef,	"to_ascii\(\'\\u1BF3\。\.\\u062A\≯ꡂ\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ B2\ B3\ \[data\/IdnaTest\.txt\:4936\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}。.\x{062A}>\x{0338}ꡂ", %p)},	undef,	"to_ascii\(\'\\u1BF3\。\.\\u062A\>\\u0338ꡂ\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ B2\ B3\ \[data\/IdnaTest\.txt\:4937\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮≠񏻃｡-𫠆\x{06B7}𐹪", %p)},	undef,	"to_ascii\(\'\≮\≠\?｡\-𫠆\\u06B7𐹪\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4938\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}=\x{0338}񏻃｡-𫠆\x{06B7}𐹪", %p)},	undef,	"to_ascii\(\'\<\\u0338\=\\u0338\?｡\-𫠆\\u06B7𐹪\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4939\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮≠񏻃。-𫠆\x{06B7}𐹪", %p)},	undef,	"to_ascii\(\'\≮\≠\?\。\-𫠆\\u06B7𐹪\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4940\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}=\x{0338}񏻃。-𫠆\x{06B7}𐹪", %p)},	undef,	"to_ascii\(\'\<\\u0338\=\\u0338\?\。\-𫠆\\u06B7𐹪\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4941\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹡\x{0777}。ꡂ", %p)},	undef,	"to_ascii\(\'𐹡\\u0777\。ꡂ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4942\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴉ𝆅񔻅\x{0619}.ß𐧦𐹳\x{0775}", %p)},	undef,	"to_ascii\(\'Ⴉ𝆅\?\\u0619\.ß𐧦𐹳\\u0775\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4943\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴉ𝆅񔻅\x{0619}.ß𐧦𐹳\x{0775}", %p)},	undef,	"to_ascii\(\'ⴉ𝆅\?\\u0619\.ß𐧦𐹳\\u0775\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4944\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴉ𝆅񔻅\x{0619}.SS𐧦𐹳\x{0775}", %p)},	undef,	"to_ascii\(\'Ⴉ𝆅\?\\u0619\.SS𐧦𐹳\\u0775\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4945\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴉ𝆅񔻅\x{0619}.ss𐧦𐹳\x{0775}", %p)},	undef,	"to_ascii\(\'ⴉ𝆅\?\\u0619\.ss𐧦𐹳\\u0775\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4946\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴉ𝆅񔻅\x{0619}.Ss𐧦𐹳\x{0775}", %p)},	undef,	"to_ascii\(\'Ⴉ𝆅\?\\u0619\.Ss𐧦𐹳\\u0775\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4947\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{0643}𐧾↙.񊽡", %p)},	undef,	"to_ascii\(\'\\u200D\\u0643𐧾\↙\.\?\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:4948\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("梉。\x{200C}", %p)},	"xn--7zv.",	"to_ascii\(\'梉\。\\u200C\'\)\ \[data\/IdnaTest\.txt\:4950\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7zv.", %p)},	"xn--7zv.",	"to_ascii\(\'xn\-\-7zv\.\'\)\ \[data\/IdnaTest\.txt\:4952\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("梉.", %p)},	"xn--7zv.",	"to_ascii\(\'梉\.\'\)\ \[data\/IdnaTest\.txt\:4953\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡣ-≠.\x{200D}𞤗𐅢Ↄ", %p)},	undef,	"to_ascii\(\'ꡣ\-\≠\.\\u200D\?𐅢Ↄ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4954\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡣ-=\x{0338}.\x{200D}𞤗𐅢Ↄ", %p)},	undef,	"to_ascii\(\'ꡣ\-\=\\u0338\.\\u200D\?𐅢Ↄ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4956\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡣ-=\x{0338}.\x{200D}𞤗𐅢ↄ", %p)},	undef,	"to_ascii\(\'ꡣ\-\=\\u0338\.\\u200D\?𐅢ↄ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4958\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡣ-≠.\x{200D}𞤗𐅢ↄ", %p)},	undef,	"to_ascii\(\'ꡣ\-\≠\.\\u200D\?𐅢ↄ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4960\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς⒐𝆫⸵｡𐱢🄊𝟳", %p)},	undef,	"to_ascii\(\'ς⒐𝆫\⸵｡\?🄊𝟳\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4962\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς9.𝆫⸵。𐱢9,7", %p)},	undef,	"to_ascii\(\'ς9\.𝆫\⸵\。\?9\,7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ9.𝆫⸵。𐱢9,7", %p)},	undef,	"to_ascii\(\'Σ9\.𝆫\⸵\。\?9\,7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4964\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ9.𝆫⸵。𐱢9,7", %p)},	undef,	"to_ascii\(\'σ9\.𝆫\⸵\。\?9\,7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4965\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ⒐𝆫⸵｡𐱢🄊𝟳", %p)},	undef,	"to_ascii\(\'Σ⒐𝆫\⸵｡\?🄊𝟳\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4966\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ⒐𝆫⸵｡𐱢🄊𝟳", %p)},	undef,	"to_ascii\(\'σ⒐𝆫\⸵｡\?🄊𝟳\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4967\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{0853}．\x{200C}ß", %p)},	"xn--iwb.ss",	"to_ascii\(\'\\u0853．\\u200Cß\'\)\ \[data\/IdnaTest\.txt\:4968\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{0853}.\x{200C}ß", %p)},	"xn--iwb.ss",	"to_ascii\(\'\\u0853\.\\u200Cß\'\)\ \[data\/IdnaTest\.txt\:4970\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{0853}.\x{200C}SS", %p)},	"xn--iwb.ss",	"to_ascii\(\'\\u0853\.\\u200CSS\'\)\ \[data\/IdnaTest\.txt\:4972\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{0853}.\x{200C}ss", %p)},	"xn--iwb.ss",	"to_ascii\(\'\\u0853\.\\u200Css\'\)\ \[data\/IdnaTest\.txt\:4974\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{0853}.\x{200C}Ss", %p)},	"xn--iwb.ss",	"to_ascii\(\'\\u0853\.\\u200CSs\'\)\ \[data\/IdnaTest\.txt\:4976\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("xn--iwb.ss", %p)},	"xn--iwb.ss",	"to_ascii\(\'xn\-\-iwb\.ss\'\)\ \[data\/IdnaTest\.txt\:4978\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{0853}.ss", %p)},	"xn--iwb.ss",	"to_ascii\(\'\\u0853\.ss\'\)\ \[data\/IdnaTest\.txt\:4979\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{0853}．\x{200C}SS", %p)},	"xn--iwb.ss",	"to_ascii\(\'\\u0853．\\u200CSS\'\)\ \[data\/IdnaTest\.txt\:4980\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{0853}．\x{200C}ss", %p)},	"xn--iwb.ss",	"to_ascii\(\'\\u0853．\\u200Css\'\)\ \[data\/IdnaTest\.txt\:4982\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{0853}．\x{200C}Ss", %p)},	"xn--iwb.ss",	"to_ascii\(\'\\u0853．\\u200CSs\'\)\ \[data\/IdnaTest\.txt\:4984\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񯶣-.\x{200D}\x{074E}\x{A94D}󠻨", %p)},	undef,	"to_ascii\(\'\?\-\.\\u200D\\u074E\\uA94D\?\'\)\ throws\ error\ P1\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:4986\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䃚蟥-。-񽒘⒈", %p)},	undef,	"to_ascii\(\'䃚蟥\-\。\-\?⒈\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4988\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䃚蟥-。-񽒘1.", %p)},	undef,	"to_ascii\(\'䃚蟥\-\。\-\?1\.\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4989\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹸䚵-ꡡ。⺇", %p)},	undef,	"to_ascii\(\'𐹸䚵\-ꡡ\。⺇\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4990\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𑄳。\x{1ADC}𐹻", %p)},	undef,	"to_ascii\(\'𑄳\。\\u1ADC𐹻\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4991\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𐹻.⒎𑂵\x{06BA}\x{0602}", %p)},	undef,	"to_ascii\(\'\≮𐹻\.⒎𑂵\\u06BA\\u0602\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4992\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𐹻.⒎𑂵\x{06BA}\x{0602}", %p)},	undef,	"to_ascii\(\'\<\\u0338𐹻\.⒎𑂵\\u06BA\\u0602\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4993\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𐹻.7.𑂵\x{06BA}\x{0602}", %p)},	undef,	"to_ascii\(\'\≮𐹻\.7\.𑂵\\u06BA\\u0602\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4994\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𐹻.7.𑂵\x{06BA}\x{0602}", %p)},	undef,	"to_ascii\(\'\<\\u0338𐹻\.7\.𑂵\\u06BA\\u0602\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4995\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢔ≠􋉂.\x{200D}𐋢", %p)},	undef,	"to_ascii\(\'ᢔ\≠\?\.\\u200D𐋢\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4996\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢔ=\x{0338}􋉂.\x{200D}𐋢", %p)},	undef,	"to_ascii\(\'ᢔ\=\\u0338\?\.\\u200D𐋢\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4998\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐩁≮񣊛≯．\x{066C}𞵕⳿", %p)},	undef,	"to_ascii\(\'𐩁\≮\?\≯．\\u066C\?⳿\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:5000\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐩁<\x{0338}񣊛>\x{0338}．\x{066C}𞵕⳿", %p)},	undef,	"to_ascii\(\'𐩁\<\\u0338\?\>\\u0338．\\u066C\?⳿\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:5001\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐩁≮񣊛≯.\x{066C}𞵕⳿", %p)},	undef,	"to_ascii\(\'𐩁\≮\?\≯\.\\u066C\?⳿\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:5002\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐩁<\x{0338}񣊛>\x{0338}.\x{066C}𞵕⳿", %p)},	undef,	"to_ascii\(\'𐩁\<\\u0338\?\>\\u0338\.\\u066C\?⳿\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:5003\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-｡⺐", %p)},	undef,	"to_ascii\(\'\-｡⺐\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:5004\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。⺐", %p)},	undef,	"to_ascii\(\'\-\。⺐\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:5005\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠰩𑲬．\x{065C}", %p)},	undef,	"to_ascii\(\'\?\?．\\u065C\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:5006\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠰩𑲬.\x{065C}", %p)},	undef,	"to_ascii\(\'\?\?\.\\u065C\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:5007\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐍺.񚇃\x{200C}", %p)},	undef,	"to_ascii\(\'𐍺\.\?\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5008\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{063D}\x{06E3}.𐨎", %p)},	undef,	"to_ascii\(\'\\u063D\\u06E3\.𐨎\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5010\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("漦Ⴙς.񡻀𐴄", %p)},	undef,	"to_ascii\(\'漦Ⴙς\.\?\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5011\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("漦ⴙς.񡻀𐴄", %p)},	undef,	"to_ascii\(\'漦ⴙς\.\?\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5012\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("漦ႹΣ.񡻀𐴄", %p)},	undef,	"to_ascii\(\'漦ႹΣ\.\?\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5013\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("漦ⴙσ.񡻀𐴄", %p)},	undef,	"to_ascii\(\'漦ⴙσ\.\?\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5014\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("漦Ⴙσ.񡻀𐴄", %p)},	undef,	"to_ascii\(\'漦Ⴙσ\.\?\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5015\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹫踧\x{0CCD}򫚇.󜀃⒈𝨤", %p)},	undef,	"to_ascii\(\'𐹫踧\\u0CCD\?\.\?⒈𝨤\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:5016\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹫踧\x{0CCD}򫚇.󜀃1.𝨤", %p)},	undef,	"to_ascii\(\'𐹫踧\\u0CCD\?\.\?1\.𝨤\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:5017\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}≮．󠟪𹫏-", %p)},	undef,	"to_ascii\(\'\\u200D\≮．\?\?\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:5018\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}<\x{0338}．󠟪𹫏-", %p)},	undef,	"to_ascii\(\'\\u200D\<\\u0338．\?\?\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:5020\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}≮.󠟪𹫏-", %p)},	undef,	"to_ascii\(\'\\u200D\≮\.\?\?\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:5022\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}<\x{0338}.󠟪𹫏-", %p)},	undef,	"to_ascii\(\'\\u200D\<\\u0338\.\?\?\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:5024\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200D}襔。Ⴜ5ꡮ񵝏", %p)},	undef,	"to_ascii\(\'\\u200D\\u200D襔\。Ⴜ5ꡮ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5026\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200D}襔。ⴜ5ꡮ񵝏", %p)},	undef,	"to_ascii\(\'\\u200D\\u200D襔\。ⴜ5ꡮ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5028\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫜𑌼\x{200D}．婀", %p)},	"xn--ix9c26l.xn--q0s",	"to_ascii\(\'𐫜𑌼\\u200D．婀\'\)\ \[data\/IdnaTest\.txt\:5030\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫜𑌼\x{200D}.婀", %p)},	"xn--ix9c26l.xn--q0s",	"to_ascii\(\'𐫜𑌼\\u200D\.婀\'\)\ \[data\/IdnaTest\.txt\:5032\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--ix9c26l.xn--q0s", %p)},	"xn--ix9c26l.xn--q0s",	"to_ascii\(\'xn\-\-ix9c26l\.xn\-\-q0s\'\)\ \[data\/IdnaTest\.txt\:5034\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫜𑌼.婀", %p)},	"xn--ix9c26l.xn--q0s",	"to_ascii\(\'𐫜𑌼\.婀\'\)\ \[data\/IdnaTest\.txt\:5035\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󠅽︒︒𐹯｡⬳\x{1A78}", %p)},	undef,	"to_ascii\(\'\󠅽︒︒𐹯｡\⬳\\u1A78\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:5036\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("󠅽。。𐹯。⬳\x{1A78}", %p)},	undef,	"to_ascii\(\'\󠅽\。\。𐹯\。\⬳\\u1A78\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5037\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𝟖ß．󠄐-\x{DBDA}Ⴏ", %p)},	undef,	"to_ascii\(\'𝟖ß．\󠄐\-\\uDBDAႯ\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5038\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8ß.󠄐-\x{DBDA}Ⴏ", %p)},	undef,	"to_ascii\(\'8ß\.\󠄐\-\\uDBDAႯ\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5039\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8ß.󠄐-\x{DBDA}ⴏ", %p)},	undef,	"to_ascii\(\'8ß\.\󠄐\-\\uDBDAⴏ\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5040\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8SS.󠄐-\x{DBDA}Ⴏ", %p)},	undef,	"to_ascii\(\'8SS\.\󠄐\-\\uDBDAႯ\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5041\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8ss.󠄐-\x{DBDA}ⴏ", %p)},	undef,	"to_ascii\(\'8ss\.\󠄐\-\\uDBDAⴏ\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5042\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟖ß．󠄐-\x{DBDA}ⴏ", %p)},	undef,	"to_ascii\(\'𝟖ß．\󠄐\-\\uDBDAⴏ\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5043\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟖SS．󠄐-\x{DBDA}Ⴏ", %p)},	undef,	"to_ascii\(\'𝟖SS．\󠄐\-\\uDBDAႯ\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5044\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟖ss．󠄐-\x{DBDA}ⴏ", %p)},	undef,	"to_ascii\(\'𝟖ss．\󠄐\-\\uDBDAⴏ\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5045\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟖Ss．󠄐-\x{DBDA}Ⴏ", %p)},	undef,	"to_ascii\(\'𝟖Ss．\󠄐\-\\uDBDAႯ\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5046\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200D}󠋟.\x{200C}𐹣Ⴅ", %p)},	undef,	"to_ascii\(\'\-\\u200D\?\.\\u200C𐹣Ⴅ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:5047\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200D}󠋟.\x{200C}𐹣ⴅ", %p)},	undef,	"to_ascii\(\'\-\\u200D\?\.\\u200C𐹣ⴅ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:5049\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B9}\x{200D}큷𻶡｡₂", %p)},	undef,	"to_ascii\(\'\\uA9B9\\u200D큷\?｡₂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5051\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B9}\x{200D}큷𻶡｡₂", %p)},	undef,	"to_ascii\(\'\\uA9B9\\u200D큷\?｡₂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5053\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B9}\x{200D}큷𻶡。2", %p)},	undef,	"to_ascii\(\'\\uA9B9\\u200D큷\?\。2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5055\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B9}\x{200D}큷𻶡。2", %p)},	undef,	"to_ascii\(\'\\uA9B9\\u200D큷\?\。2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5057\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{DF4D}.🄄𞯘", %p)},	undef,	"to_ascii\(\'\\uDF4D\.🄄\?\'\)\ throws\ error\ P1\ V6\ B1\ A3\ \[data\/IdnaTest\.txt\:5059\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{DF4D}.3,𞯘", %p)},	undef,	"to_ascii\(\'\\uDF4D\.3\,\?\'\)\ throws\ error\ P1\ V6\ B1\ A3\ \[data\/IdnaTest\.txt\:5060\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝨖𐩙。\x{06DD}󀡶\x{A8C5}⒈", %p)},	undef,	"to_ascii\(\'𝨖\?\。\\u06DD\?\\uA8C5⒈\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:5061\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝨖𐩙。\x{06DD}󀡶\x{A8C5}1.", %p)},	undef,	"to_ascii\(\'𝨖\?\。\\u06DD\?\\uA8C51\.\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:5062\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򒈣\x{05E1}\x{06B8}。Ⴈ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\\u05E1\\u06B8\。Ⴈ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5063\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򒈣\x{05E1}\x{06B8}。ⴈ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\\u05E1\\u06B8\。ⴈ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5065\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󀚶𝨱\x{07E6}⒈．𑗝髯\x{200C}", %p)},	undef,	"to_ascii\(\'\?𝨱\\u07E6⒈．𑗝髯\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:5067\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󀚶𝨱\x{07E6}1..𑗝髯\x{200C}", %p)},	undef,	"to_ascii\(\'\?𝨱\\u07E61\.\.𑗝髯\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ B5\ A4_2\ \[data\/IdnaTest\.txt\:5069\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐫀．\x{0689}𑌀", %p)},	"xn--pw9c.xn--fjb8658k",	"to_ascii\(\'𐫀．\\u0689𑌀\'\)\ \[data\/IdnaTest\.txt\:5071\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐫀.\x{0689}𑌀", %p)},	"xn--pw9c.xn--fjb8658k",	"to_ascii\(\'𐫀\.\\u0689𑌀\'\)\ \[data\/IdnaTest\.txt\:5072\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("xn--pw9c.xn--fjb8658k", %p)},	"xn--pw9c.xn--fjb8658k",	"to_ascii\(\'xn\-\-pw9c\.xn\-\-fjb8658k\'\)\ \[data\/IdnaTest\.txt\:5073\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𑋪．𐳝", %p)},	undef,	"to_ascii\(\'𑋪．𐳝\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5074\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𑋪.𐳝", %p)},	undef,	"to_ascii\(\'𑋪\.𐳝\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5075\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𑋪.𐲝", %p)},	undef,	"to_ascii\(\'𑋪\.𐲝\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5076\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𑋪．𐲝", %p)},	undef,	"to_ascii\(\'𑋪．𐲝\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5077\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("≠膣。\x{0F83}", %p)},	undef,	"to_ascii\(\'\≠膣\。\\u0F83\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:5078\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}膣。\x{0F83}", %p)},	undef,	"to_ascii\(\'\=\\u0338膣\。\\u0F83\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:5079\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񰀎-\x{077D}｡ß", %p)},	undef,	"to_ascii\(\'\?\-\\u077D｡ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5080\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񰀎-\x{077D}。ß", %p)},	undef,	"to_ascii\(\'\?\-\\u077D\。ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5081\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񰀎-\x{077D}。SS", %p)},	undef,	"to_ascii\(\'\?\-\\u077D\。SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5082\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񰀎-\x{077D}｡SS", %p)},	undef,	"to_ascii\(\'\?\-\\u077D｡SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5083\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς𐹠ᡚ𑄳．⾭𐹽𽐖𐫜", %p)},	undef,	"to_ascii\(\'ς𐹠ᡚ𑄳．⾭𐹽\?𐫜\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5084\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς𐹠ᡚ𑄳.靑𐹽𽐖𐫜", %p)},	undef,	"to_ascii\(\'ς𐹠ᡚ𑄳\.靑𐹽\?𐫜\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5085\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ𐹠ᡚ𑄳.靑𐹽𽐖𐫜", %p)},	undef,	"to_ascii\(\'Σ𐹠ᡚ𑄳\.靑𐹽\?𐫜\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5086\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ𐹠ᡚ𑄳.靑𐹽𽐖𐫜", %p)},	undef,	"to_ascii\(\'σ𐹠ᡚ𑄳\.靑𐹽\?𐫜\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5087\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ𐹠ᡚ𑄳．⾭𐹽𽐖𐫜", %p)},	undef,	"to_ascii\(\'Σ𐹠ᡚ𑄳．⾭𐹽\?𐫜\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5088\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ𐹠ᡚ𑄳．⾭𐹽𽐖𐫜", %p)},	undef,	"to_ascii\(\'σ𐹠ᡚ𑄳．⾭𐹽\?𐫜\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:5089\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋷。\x{200D}", %p)},	"xn--r97c.",	"to_ascii\(\'𐋷\。\\u200D\'\)\ \[data\/IdnaTest\.txt\:5090\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--r97c.", %p)},	"xn--r97c.",	"to_ascii\(\'xn\-\-r97c\.\'\)\ \[data\/IdnaTest\.txt\:5092\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋷.", %p)},	"xn--r97c.",	"to_ascii\(\'𐋷\.\'\)\ \[data\/IdnaTest\.txt\:5093\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑰳𑈯。⥪", %p)},	undef,	"to_ascii\(\'\?𑈯\。\⥪\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5094\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𑆀䁴񤧣．Ⴕ𝟜\x{200C}\x{0348}", %p)},	undef,	"to_ascii\(\'𑆀䁴\?．Ⴕ𝟜\\u200C\\u0348\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5095\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑆀䁴񤧣.Ⴕ4\x{200C}\x{0348}", %p)},	undef,	"to_ascii\(\'𑆀䁴\?\.Ⴕ4\\u200C\\u0348\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5097\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑆀䁴񤧣.ⴕ4\x{200C}\x{0348}", %p)},	undef,	"to_ascii\(\'𑆀䁴\?\.ⴕ4\\u200C\\u0348\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5099\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑆀䁴񤧣．ⴕ𝟜\x{200C}\x{0348}", %p)},	undef,	"to_ascii\(\'𑆀䁴\?．ⴕ𝟜\\u200C\\u0348\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5101\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("憡\x{DF1F}\x{200C}Ⴔ.𐋮\x{200D}≠", %p)},	undef,	"to_ascii\(\'憡\\uDF1F\\u200CႴ\.𐋮\\u200D\≠\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:5103\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("憡\x{DF1F}\x{200C}Ⴔ.𐋮\x{200D}=\x{0338}", %p)},	undef,	"to_ascii\(\'憡\\uDF1F\\u200CႴ\.𐋮\\u200D\=\\u0338\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:5105\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("憡\x{DF1F}\x{200C}ⴔ.𐋮\x{200D}=\x{0338}", %p)},	undef,	"to_ascii\(\'憡\\uDF1F\\u200Cⴔ\.𐋮\\u200D\=\\u0338\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:5107\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("憡\x{DF1F}\x{200C}ⴔ.𐋮\x{200D}≠", %p)},	undef,	"to_ascii\(\'憡\\uDF1F\\u200Cⴔ\.𐋮\\u200D\≠\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:5109\]") or ($@ and diag($@));


exit(0);
