=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Nqo - Package for language N’Ko

=cut

package Locale::CLDR::Locales::Nqo;
# This file auto generated from Data\common\main\nqo.xml
#	on Thu 29 Feb  5:43:51 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'af' => 'ߊߝߙߌߞߊ߲߯ߛߑߞߊ߲',
 				'agq' => 'ߊߜ߭ߍߡߑߞߊ߲',
 				'ak' => 'ߊߞߊ߲ߞߊ',
 				'am' => 'ߊߡߑߤߊߙߌ',
 				'ar' => 'ߊߙߓߎߞߊ߲',
 				'ar_001' => 'ߊߙߊߓߎߞߊ߲ ߘߐߞߣߍߣߍ߲',
 				'as' => 'ߊߛߊߡߍߞߊ߲',
 				'asa' => 'ߊߖ߭ߎߞߊ߲',
 				'ast' => 'ߊߛߑߕߎߙߌߞߊ߲',
 				'az' => 'ߊߖߍߙߑߓߊߦߌߖߊߞߊ߲',
 				'az@alt=short' => 'ߊߖߋߙߌߞߊ߲',
 				'bas' => 'ߓߛߊߞߊ߲',
 				'be' => 'ߓߌߟߏߙߎ߳ߛߌߞߊ߲',
 				'bem' => 'ߓߋ߲ߓߊߞߊ߲',
 				'bez' => 'ߓߋߣߊߞߊ߲',
 				'bg' => 'ߓߌߟߑߜ߭ߊߙߌߞߊ߲',
 				'bm' => 'ߒߞߏ ߡߊߟߌ',
 				'bn' => 'ߓߍ߲ߜ߭ߊߟߌߞߊ߲',
 				'bo' => 'ߕߌߓߋߕߌߞߊ߲',
 				'br' => 'ߓߙߋߕߐ߲ߞߊ߲',
 				'brx' => 'ߓߏߘߏߞߊ߲',
 				'bs' => 'ߓߐߛߑߣߌߞߊ߲',
 				'ca' => 'ߞߕߊߟߊ߲ߞߊ߲',
 				'ccp' => 'ߞߏߘߊ߫ ߗߊߜ߭ߑߡߊߞߊ߲',
 				'ce' => 'ߗߋߗߋߣߌߞߊ߲',
 				'ceb' => 'ߛߋߓߎߥߊߞߊ߲',
 				'cgg' => 'ߞߌߜ߭ߊߞߊ߲',
 				'chr' => 'ߗߋߙߏߞߌߞߊ߲',
 				'ckb' => 'ߛߏߙߊߣߌߞߊ߲',
 				'ckb@alt=menu' => 'ߛߏߙߊߣߌ߫ ߞߎߙߑߘߎߞߊ߲',
 				'co' => 'ߞߐߙߑߛߌߞߊ߲',
 				'cs' => 'ߗߍߞߌߞߊ߲',
 				'cu' => 'ߛߌߟߊߝ߭ߐ߲ߞߊ߲ ߓߊ߬ߕߏ߬ߓߏ߲߬ߞߊ߲',
 				'cy' => 'ߜ߭ߟߏߥߊߞߊ߲',
 				'da' => 'ߘߊߣߏߥߊߞߊ߲',
 				'dav' => 'ߕߊߦߌߕߊߞߊ߲',
 				'de' => 'ߊߟߑߡߊ߲ߞߊ߲',
 				'de_AT' => 'ߏߕߑߙߌߛߌ߬ ߊߟߑߡߊߞߊ߲',
 				'de_CH' => 'ߛߥߌߛ ߊߟߑߡߊ߲ߞߊ߲',
 				'dje' => 'ߖ߭ߍߙߑߡߊߞߊ߲',
 				'doi' => 'ߘߏߜ߭ߙߌߞߊ߲',
 				'dsb' => 'ߛߏߙߊߓ-ߓߊߛߑߞߊ߲',
 				'dua' => 'ߘߎߥߟߊߞߊ߲',
 				'dyo' => 'ߝߐߢߌ߫ ߖߏ߬ߟߊ߬ߞߊ߲',
 				'dz' => 'ߖ߭ߏ߲ߜ߭ߊߞߊ߲',
 				'ebu' => 'ߋ߲ߓߎߞߊ߲',
 				'ee' => 'ߋߥߋߞߊ߲',
 				'el' => 'ߜ߭ߙߍ߬ߞߌ߬ߞߊ߲',
 				'en' => 'ߊ߲߬ߜߑߟߋ߬ߞߊ߲',
 				'en_AU' => 'ߐߛߑߕߙߊߟߌ߫ ߊ߲߬ߜ߭ߑߟߋ߬ߞߊ߲',
 				'en_CA' => 'ߞߣߊߘߊ߫ ߊ߲߬ߜ߭ߑߟߋ߬ߞߊ߲',
 				'en_GB' => 'ߓߙߌߕߊ߲ߓߊ߫ ߊ߲߬ߜ߭ߑߟߋ߬ߞߊ߲',
 				'en_GB@alt=short' => 'ߡ.ߟ. ߊ߲߬ߜ߭ߑߟߋ߲߬ߞߊ߲',
 				'en_US' => 'ߊߡߋߙߌߞߌ߬ ߊ߲߬ߜ߭ߑߟߋ߬ߞߊ߲',
 				'en_US@alt=short' => 'ߞ.ߘ. ߊ߲߬ߜ߭ߑߟߋ߬ߞߊ߲',
 				'eo' => 'ߍߛߑߔߋߙߊ߲ߕߏߞߊ߲',
 				'es' => 'ߊߛߌߔߞߊ߲',
 				'es_419' => 'ߊߡߋߙߌߞߌ߬ ߊߛߌߔߊ߲ߞߊ߲ ߟߊ߬ߕߍ߬ߡߊ',
 				'es_ES' => 'ߊߛߌߔߊ߲߫ ߊߛߌߔߊ߲ߞߊ߲',
 				'es_MX' => 'ߡߍߞߑߛߌߞ ߊߛߌߔߊ߲ߞߊ߲',
 				'et' => 'ߍߛߑߕߏߣߌߞߊ߲',
 				'eu' => 'ߓߊߛߑߞߌߞߊ߲',
 				'ewo' => 'ߋߥߏ߲ߘߏߞߊ߲',
 				'fa' => 'ߝߊ߯ߙߛߌߞߊ߲',
 				'fa_AF' => 'ߘߊߙߌߞߊ߲',
 				'ff' => 'ߝߎߟߊߞߊ߲',
 				'fi' => 'ߝߍߣߏߥߊߞߊ߲',
 				'fil' => 'ߝߟߌߔߌ߲ߞߊ߲',
 				'fo' => 'ߝߋߙߏߞߊ',
 				'fr' => 'ߝߊ߬ߙߊ߲߬ߛߌ߬ߞߊ߲',
 				'fr_CA' => 'ߞߣߊߘߊ߫ ߝߊ߬ߙߊ߲߬ߛߌ߬ߞߊ߲',
 				'fr_CH' => 'ߛߥߌߛ ߝߙߊ߬ߛߌ߬ߞߊ߲',
 				'frc' => 'ߞߊߘߌ߫ ߝߊ߬ߙߊ߲߬ߛߌ߬ߞߊ߲',
 				'fur' => 'ߝߙߌߥߎߟߊߞߊ߲',
 				'fy' => 'ߕߟߋ߬ߓߋ ߝߙߌߛߐ߲ߞߊ߲',
 				'ga' => 'ߌߙߑߟߊ߲ߘߌߞߊ߲',
 				'gd' => 'ߋߞߐߛߌ߬ ߖ߭ߋߏߟߌߞߊ߲',
 				'gl' => 'ߜ߭ߊߟߌߛߌߞߊ߲',
 				'gsw' => 'ߛߥߌߛߌ߬ ߊߟߑߡߊ߲ߞߊ߲',
 				'gu' => 'ߜ߭ߎߖߙߊߞߊ߲',
 				'guz' => 'ߜߎ߭ߛߌߞߊ߲',
 				'gv' => 'ߡߊߣߏߥߊߞߊ߲',
 				'ha' => 'ߤߊߥߎߛߊߞߊ߲',
 				'haw' => 'ߤߥߊߦߌߞߊ߲',
 				'he' => 'ߋߓߙߋߞߊ߲',
 				'hi' => 'ߍ߲ߘߎߞߊ߲',
 				'hmn' => 'ߡߐ߲ߜ߭ߑߞߊ߲',
 				'hr' => 'ߞߙߏߥߊߛߌߞߊ߲',
 				'hsb' => 'ߛߏߙߊߓߎ߫ ߛߊ߲ߘߐ߫ ߞߊ߲',
 				'ht' => 'ߤߊߦߌߕߌ߫ ߕߊ߬ߓߎ߰ߛߌ߬ߞߊ߲',
 				'hu' => 'ߤߐ߲ߜ߭ߙߌߞߊ߲',
 				'hy' => 'ߊߙߊߡߋߣߌߞߊ߲',
 				'ia' => 'ߍ߲ߕߍߙߑߟߌ߲ߜ߭ߏߥߊߞߊ߲',
 				'id' => 'ߍ߲ߘߣߏߛߌߞߊ߲',
 				'ig' => 'ߊߜߏߞߊ߲',
 				'ii' => 'ߛߌߛߎߥߊ߲߫ ߦߌߞߊ߲',
 				'is' => 'ߌߛߑߟߊ߲ߘߌߞߊ߲',
 				'it' => 'ߌߕߊߟߌߞߊ߲',
 				'ja' => 'ߖ߭ߊߔߐ߲ߞߊ߲',
 				'jgo' => 'ߒߜ߭ߏ߲ߓߊߞߊ߲',
 				'jmc' => 'ߡߊߗߊߡߋߞߊ߲',
 				'jv' => 'ߖ߭ߝ߭ߊߣߊߞߊ߲',
 				'ka' => 'ߖ߭ߋߐߙߑߖ߭ߌߞߊ߲',
 				'kab' => 'ߞߊߓߟߌߞߊ߲',
 				'kam' => 'ߞߊ߲ߓߊߞߊ߲',
 				'kde' => 'ߡߊߞߐ߲ߘߋߞߊ߲',
 				'kea' => 'ߜߙߋߞߎ߲ߝߙߌߛߌߞߊ߲',
 				'kgp' => 'ߞߍ߲ߜ߭ߊ߲ߞߊ߲',
 				'khq' => 'ߞߏߙߌߦߊߗߣߌߞߊ߲',
 				'ki' => 'ߞߌߞߌߦߎߞߊ߲',
 				'kk' => 'ߞߖ߭ߊߞߌߞߊ߲',
 				'kkj' => 'ߞߊߞߏߞߊ߲',
 				'kl' => 'ߜ߭ߙߏߟߊ߲ߘߌߞߊ߲',
 				'kln' => 'ߞߊߟߊ߲ߖߌߞߊ߲',
 				'km' => 'ߞߑߡߍߙߑߞߊ߲',
 				'kn' => 'ߞߊ߲ߣߊߘߊߞߊ߲',
 				'ko' => 'ߞߏߙߋߞߊ߲',
 				'kok' => 'ߞߐ߲ߞߊߣߌߞߊ߲',
 				'ks' => 'ߞߊߛߑߡߙߌߞߊ߲',
 				'ksb' => 'ߛߊ߲ߓߟߊߞߊ߲',
 				'ksf' => 'ߓߊߝߌߞߊ߲',
 				'ksh' => 'ߞߐߟߑߗߌߞߊ߲',
 				'ku' => 'ߞߎߙߑߘߎߞߊ߲',
 				'kw' => 'ߞߐߙߑߣߌߞߌߞߊ߲',
 				'ky' => 'ߞߌߙߑߞߌߖ߭ߑߞߊ߲',
 				'la' => 'ߟߊ߬ߕߍ߲߬ߞߊ߲',
 				'lag' => 'ߟߊ߲ߖߌߞߊ߲',
 				'lb' => 'ߟߎߞߑߛߊ߲ߓߎ߯ߙߎߞߊ߲',
 				'lg' => 'ߜ߭ߊ߲ߘߊߞߊ߲',
 				'lij' => 'ߟߌ߭ߎ߳ߙߌߞߊ߲',
 				'lkt' => 'ߟߊߞߏߕߊߞߊ߲',
 				'ln' => 'ߟߌ߲ߜ߭ߟߊߞߊ߲',
 				'lo' => 'ߟߊߏߞߊ߲',
 				'lou' => 'ߟߌߖ߭ߌߦߊߣߌ߫ ߕߊ߬ߓߎ߰ߛߌ߬ߞߊ߲',
 				'lrc' => 'ߕߟߋ߬ߓߐ ߟߏߙߌߞߊ߲',
 				'lt' => 'ߟߌߕߎ߳ߦߊߣߌߞߊ߲',
 				'lu' => 'ߞߊߕߊ߲ߜ߭ߊ߫-ߗߌ߬ߟߎ߬ߓߊ߬ߞߊ߲',
 				'luo' => 'ߟߎ߳ߏߞߊ߲',
 				'luy' => 'ߟߎ߳ߦߌߞߊ߲',
 				'lv' => 'ߟߋߕߐ߲ߞߊ߲',
 				'mai' => 'ߡߊߗߟߌߞߊ߲',
 				'mas' => 'ߡߊ߯ߛߊߞߊ߲',
 				'mer' => 'ߡߋߙߎߞߊ߲',
 				'mfe' => 'ߡߏߙߌߛ ߕߊ߬ߓߎ߰ߛߌ߬ߞߊ߲',
 				'mg' => 'ߡߊߟߑߜ߭ߊߛߌߞߊ߲',
 				'mgh' => 'ߡߊߞߎߞߊ߲',
 				'mgo' => 'ߡߋߕߊߞߊ߲',
 				'mi' => 'ߡߊߏߙߌߞߊ߲',
 				'mk' => 'ߡߊߛߋߘߏߣߌߞߊ߲',
 				'ml' => 'ߡߟߊߦߟߊߡߑߞߊ߲',
 				'mn' => 'ߡߐ߲ߜ߭ߐߟߌߞߊ߲',
 				'mni' => 'ߡߊߣߌߔߎߙߌߞߊ߲',
 				'mr' => 'ߡߙߊߕߌߞߊ߲',
 				'ms' => 'ߡߊߟߍߞߊ߲',
 				'mt' => 'ߡߊߟߑߕߍߞߊ߲',
 				'mua' => 'ߡߎ߲ߘߊ߲ߞߊ߲',
 				'mul' => 'ߞߊ߲ߥߙߍߞߊ߲',
 				'my' => 'ߓߙߌߡߊ߲ߞߊ߲',
 				'mzn' => 'ߡߊߖ߭ߊ߲ߘߋߙߊߣߞߊ߲',
 				'naq' => 'ߣߡߊߞߊ߲',
 				'nb' => 'ߣߐߙߑߝ߭ߍߖ߭ ߓߏߞߑߡߊߟߑߞߊ߲',
 				'nd' => 'ߕߟߋ߬ߓߐ ߒߘߓߋߟߋߞߊ߲',
 				'nds' => 'ߊߟߑߡߊ߲ߘߎ߯-ߓߊߛߑߞߊ߲',
 				'nds_NL' => 'ߤߏߟߊ߲ߘߌ߬ ߓߊߛߊߞߑߛߐ߲ߞߊ߲',
 				'ne' => 'ߣߋߔߌߟߌߞߊ߲',
 				'nl' => 'ߣߍ߯ߙߑߟߊ߲ߘߌߞߊ߲',
 				'nl_BE' => 'ߝߌߟߊߡߊ߲ߞߊ߲',
 				'nmg' => 'ߒߜ߭ߎ߲ߓߊߞߊ߲',
 				'nn' => 'ߣߐߙߑߝ߭ߍߖ߭ ߢߙߐߛߌߞߊ߲',
 				'nnh' => 'ߒߖߋ߲ߓߎ߲ߞߊ߲',
 				'no' => 'ߣߐߙߑߝ߭ߍߖ߭ߌߞߊ߲',
 				'nqo' => 'ߒߞߏ',
 				'nus' => 'ߣߎߦߋߞߊ߲',
 				'nv' => 'ߣߝ߭ߊߖߏߞߊ߲',
 				'ny' => 'ߛߋߥߞߊ߲',
 				'nyn' => 'ߢߊ߲ߞߏߟߋߞߊ߲',
 				'om' => 'ߏߙߏߡߏߞߊ߲',
 				'or' => 'ߏߖߊߞߊ߲',
 				'os' => 'ߏߛߍߕߌߞߊ߲',
 				'pa' => 'ߔߍ߲ߖߊߓߌߞߊ߲',
 				'pcm' => 'ߖߋ߬ߟߌ߬ߓߊߟߊ߫ ߔߌߘߑߜ߭ߍ߲ߞߊ߲',
 				'pl' => 'ߔߟߏߣߍߞߊ߲',
 				'prg' => 'ߔߎߙߛߌߞߊ߲',
 				'ps' => 'ߔߊߛߑߕߏߞߊ߲',
 				'pt' => 'ߔߕߏ߬ߞߌ߬ߞߊ߲',
 				'pt_BR' => 'ߓߙߋߖ߭ߌߟ ߔߕߏ߬ߞߌ߬ߞߊ߲',
 				'pt_PT' => 'ߋߙߐߔߎ߬ ߔߕߏ߬ߞߌ߬ߞߊ߲',
 				'qu' => 'ߞߋߛߎߥߊߞߊ߲',
 				'rhg' => 'ߙߏߤߌ߲ߜ߭ߊ',
 				'rm' => 'ߙߏߡߊ߲ߛߌߞߊ߲',
 				'rn' => 'ߙߎ߲ߘߌߞߊ߲',
 				'ro' => 'ߙߏߡߍߞߊ߲',
 				'ro_MD' => 'ߡߐߟߑߘߊߝ߭ߌߞߊ߲',
 				'rof' => 'ߙߏ߲ߓߏߞߊ߲',
 				'ru' => 'ߌ߬ߙߛߌ߬ߞߊ߲',
 				'rw' => 'ߞߌ߲ߦߊߙߎߥߊ߲ߘߊߞߊ߲',
 				'rwk' => 'ߙߥߊߞߊ߲',
 				'sa' => 'ߛߊߛߑߞߙߌߞߊ߲',
 				'sah' => 'ߌߦߊߞߎߕߌߞߊ߲',
 				'saq' => 'ߛߊ߲ߓߙߎߞߊ߲',
 				'sat' => 'ߛߊ߲ߕߊߟߌߞߊ߲',
 				'sbp' => 'ߌߛߊ߲ߜ߭ߎߞߊ߲',
 				'sd' => 'ߛߌ߲ߘߌߞߊ߲',
 				'se' => 'ߛߋߡߌ߫ ߕߟߋ߬ߓߐ߬ߞߊ߲',
 				'seh' => 'ߛߌߛߋߣߊߞߊ߲',
 				'ses' => 'ߞߏߦߌߙߊߓߙߏ߫ ߛߋߣߌߞߊ߲',
 				'sg' => 'ߛߊ߲ߜߵߏߞߊ߲',
 				'shi' => 'ߗߑߟߋߥߎߞߊ߲',
 				'si' => 'ߛߌ߲ߜ߭ߟߊߞߊ߲',
 				'sk' => 'ߛߑߟߏߝ߭ߊߞߌߞߊ߲',
 				'sl' => 'ߛߑߟߏߝ߭ߋߣߌߞߊ߲',
 				'sm' => 'ߛߊߡߏߥߊߞߊ߲',
 				'smn' => 'ߌߣߊߙߌ߫ ߛߊߡߌߞߊ߲',
 				'sn' => 'ߛߏߣߊߞߊ߲',
 				'so' => 'ߛߏߡߊߟߌߞߊ߲',
 				'sq' => 'ߊߟߑߓߊߣߌߞߊ߲',
 				'sr' => 'ߛߍߙߑߓߌߞߊ߲',
 				'st' => 'ߛߕߏ߫ ߥߙߏ߬ߘߎ߰ߞߊ߲',
 				'su' => 'ߛߎ߲ߘߣߊߞߊ߲',
 				'sv' => 'ߛߎߥߍߘߌߞߊ߲',
 				'sw' => 'ߛߎߥߊߤߟߌߞߊ߲',
 				'ta' => 'ߕߊߡߎߟߌߞߊ߲',
 				'te' => 'ߕߋߟߎߜ߭ߎߞߊ߲',
 				'teo' => 'ߕߋߛߏߞߊ߲',
 				'tg' => 'ߕߊߖߞߌߞߊ߲',
 				'th' => 'ߕߊߦߌߞߊ߲',
 				'ti' => 'ߕߜ߭ߌߙߌߢߊߞߊ߲',
 				'tk' => 'ߕߎߙߞߌߡߍߣߌߞߊ߲',
 				'to' => 'ߕߏ߲ߖ߭ߌߞߊ߲',
 				'tr' => 'ߕߙߎߞߌߞߊ߲',
 				'tt' => 'ߕߊߕߊߙߌߞߊ߲',
 				'twq' => 'ߕߛߊߥߊߜ߭ߌߞߊ߲',
 				'tzm' => 'ߊߕߌߟߊ߲ߕߊ߫ ߕߊ߲ߓߊ߲ ߊߡߊ߲ߖ߭ߌ߲ߞߊ߲',
 				'ug' => 'ߥߌߜ߭ߎ߯ߙߎߞߊ߲',
 				'uk' => 'ߎߞߌߙߍߣߌߞߊ߲',
 				'und' => 'ߞߊ߲߫ ߘߊ߲߬ߠߊ߬ߕߍ߰ߓߊߟߌ',
 				'ur' => 'ߎߙߘߎߞߊ߲',
 				'uz' => 'ߎߖ߭ߑߓߋߞߌߞߊ߲',
 				'vai' => 'ߒߝ߭ߊߦߌ߲ߞߊ߲',
 				'vi' => 'ߝ߭ߌߦߋߕߌߣߊߡߌߞߊ߲',
 				'vo' => 'ߝ߭ߏߟߊߔߎߞߊ߲',
 				'vun' => 'ߝ߭ߎߖߏߞߊ߲',
 				'wae' => 'ߥߊߟߑߛߍߙߌߞߊ߲',
 				'wo' => 'ߥߟߐߝߐߞߊ߲',
 				'xh' => 'ߛߏߖ߭ߊߞߊ߲',
 				'xog' => 'ߛߏߜ߭ߊߞߊ߲',
 				'yav' => 'ߦߊ߲ߜߌߞߊ߲',
 				'yi' => 'ߦߘߌߛߌߞߊ߲',
 				'yo' => 'ߙߦߏߓߊߞߊ߲',
 				'yue' => 'ߞߊ߲ߕߏߣߊߞߊ߲',
 				'yue@alt=menu' => 'ߞߊ߲ߕߏߣߊ ߛߣߌߥߊߞߊ߲',
 				'zgh' => 'ߡߊ߬ߙߐߞߎ߬ ߢߊߓߘߍߡߊ',
 				'zh' => 'ߛߣߌߥߊߞߊ߲',
 				'zh@alt=menu' => 'ߛߣߌߥߊ ߡߊ߲ߘߊߙߍ߲ߞߊ߲',
 				'zh_Hans' => 'ߛߣߌߥߊߞߊ߲ ߘߐߞߣߍߣߍ߲',
 				'zh_Hans@alt=long' => 'ߡߊ߲ߘߊߙߍ߲ ߘߐߞߣߍߣߍ߲',
 				'zh_Hant' => 'ߛߣߌߥߊߞߊ߲ ߦߋ߲ߢߐ߲߯ߠߊ',
 				'zh_Hant@alt=long' => 'ߡߊ߲ߘߊߙߍ߲ߞߊ߲ ߢߋ߲ߢߐ߲߯ߠߊ',
 				'zu' => 'ߖ߭ߟߎߞߊ߲',
 				'zxx' => 'ߞߊ߲߫ ߘߐߞߏߟߏ߲',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'ߊߘߑߟߊߡ',
 			'Aghb' => 'ߊߜ߭ߑߓߊߣߌ',
 			'Ahom' => 'ߊߤߏ߲',
 			'Arab' => 'ߊߙߊߓߎ',
 			'Aran' => 'ߣߊߛߑߕߊߟߌߞ',
 			'Armi' => 'ߝߊ߰ߡߊ߬ߟߊ-ߊߙߊߡߋ',
 			'Armn' => 'ߊߙߌߡߋߣߌ',
 			'Avst' => 'ߊߝ߭ߋߛߑߕߌ',
 			'Bali' => 'ߓߊߟߌߣߍ',
 			'Bamu' => 'ߓߊߡߎ߲',
 			'Bass' => 'ߓߊ߯ߛߊ',
 			'Batk' => 'ߓߕߊߞ',
 			'Beng' => 'ߓߍ߲ߜ߭ߊߟߌ',
 			'Bhks' => 'ߓߊߦߌߞߑߛߎߞߌ',
 			'Bopo' => 'ߔߓߏߡߝߏ',
 			'Brah' => 'ߓߑߙߊߤߡߌ',
 			'Brai' => 'ߓߑߙߊߦߌ',
 			'Bugi' => 'ߓߎߜ߭ߌ',
 			'Buhd' => 'ߓߎߤߌߘ',
 			'Cakm' => 'ߗߍߞߑߡߊ',
 			'Cans' => 'ߞߣߊߘߊ߫ ߘߎ߰ߙߋ߲߬ ߛߓߍ߬ߛߎ߲߬ ߞߝߊ ߟߊߘߍ߬ߣߍ߲',
 			'Cari' => 'ߞߊ߯ߙߌ',
 			'Cham' => 'ߛߊ߲',
 			'Cher' => 'ߛߋߙߐߞ',
 			'Chrs' => 'ߞߏߙߊߦߌߛߑߡߌ',
 			'Copt' => 'ߞߐߔߑߕ',
 			'Cpmn' => 'ߛߌߔߙߏ-ߡߌߣߏߞߊ',
 			'Cprt' => 'ߛߔߙߌߐߕ ߜߋ߲߬ߞߝߊ',
 			'Cyrl' => 'ߛߙߌߟߌߞ',
 			'Deva' => 'ߘߋߝ߭ߣߊߜ߭ߊߙߌ߫',
 			'Diak' => 'ߊߞߎ߯ߙߎ',
 			'Dogr' => 'ߘߏߜ߭ߑߙߌ',
 			'Dsrt' => 'ߘߖ߭ߋߙߋ',
 			'Dupl' => 'ߛߑߕߋߣߏߜ߭ߙߊߝߌ ߘߎߔߑߟߏߦߋ',
 			'Egyp' => 'ߋߖ߭ߌߔߑߕ ߤߌߙߏߜ߭ߟߌߝߌ',
 			'Elba' => 'ߍߟߑߓߊߛߊ߲',
 			'Elym' => 'ߋߟߌߡߊߦߌߞ',
 			'Ethi' => 'ߋߗߏߔߌߞ',
 			'Geor' => 'ߖ߭ߐߙߑߖ߭ߌߞߊ',
 			'Glag' => 'ߜ߭ߑߟߊߜ߭ߏߟߌߕߌߞ',
 			'Gong' => 'ߜ߭ߏ߲ߖߌ߫ ߜ߭ߎ߲ߖߋߟߊ ߘߐ߫',
 			'Gonm' => 'ߡߛߊߙߊ߲߫-ߜ߭ߏ߲ߘߌ',
 			'Goth' => 'ߜ߭ߏߕߌߞ',
 			'Gran' => 'ߜ߭ߑߙߊ߲ߗߊ',
 			'Grek' => 'ߜ߭ߙߍ߬ߞߌ',
 			'Gujr' => 'ߜ߭ߎߖߙߊߕߌ',
 			'Guru' => 'ߜ߭ߎߙߑߡߎߞߌ',
 			'Hanb' => 'ߤߊ߲߫ ߓߔߏߡߝߏ ߘߐ߫',
 			'Hang' => 'ߤߊ߲ߜ߭ߎ',
 			'Hani' => 'ߛߌߣߏߜ߭ߙߊߡ',
 			'Hano' => 'ߤߊߣߎߣߏ',
 			'Hans' => 'ߘߐߞߣߍߣߍ߲',
 			'Hans@alt=stand-alone' => 'ߛߌߣߏߜ߭ߙߊߡ ߘߐߞߣߍߣߍ߲',
 			'Hant' => 'ߦߋߢߐ߲߯ߠߊ',
 			'Hant@alt=stand-alone' => 'ߛߌߣߏߜ߭ߙߊߡ ߦߋߢߐ߲߯ߠߊ',
 			'Hatr' => 'ߤߊߕߙߋߣߌ',
 			'Hebr' => 'ߋߓߙߋ',
 			'Hira' => 'ߤߌߙߊߜ߭ߣߊ',
 			'Hluw' => 'ߤߕߌ-ߤߙߏߜ߭ߟߌߝߌ',
 			'Hmng' => 'ߔߤߊߥ ߡߐ߲ߜ߭',
 			'Hmnp' => 'ߢߊߞߋ߲ߜ߭ ߔߎߛߑߡߐ߲ߜ߭',
 			'Hrkt' => 'ߞߊߕߊ߲ߞߣߊ',
 			'Hung' => 'ߤߐ߲ߜ߭ߙߌ߫ ߞߘߐ߬ߡߊ߲',
 			'Ital' => 'ߌߕߊߟߌߞ ߞߘߐ߬ߡߊ߲',
 			'Jamo' => 'ߖߡߏ',
 			'Java' => 'ߖ߭ߝ߭ߊߣߍߛ',
 			'Jpan' => 'ߣߌߔߐ߲߫',
 			'Kali' => 'ߞߦߊߟߌ߫',
 			'Kana' => 'ߞߕߊߞߣߊ',
 			'Khar' => 'ߞߊߙߏߗߌ߮',
 			'Khmr' => 'ߞߑߡߍߙ',
 			'Khoj' => 'ߞߏߖߞߌ',
 			'Kits' => 'ߞߌߕߊ߲߫ ߛߓߍߟߌߣߍ߲',
 			'Knda' => 'ߞߌߡߍߙ',
 			'Kore' => 'ߞߏߙߋ߫',
 			'Kthi' => 'ߞߊߦߌߗߌ߮',
 			'Lana' => 'ߟߣߊ',
 			'Laoo' => 'ߟߊߏ',
 			'Latn' => 'ߟߊ߬ߕߍ߲',
 			'Lepc' => 'ߟߋߔߑߛߊ',
 			'Limb' => 'ߟߌ߲ߓߎ',
 			'Lina' => 'ߟߌߣߍ߯ߙ ߊ',
 			'Linb' => 'ߟߌߣߍ߯ߙ ߓ',
 			'Lisu' => 'ߟߌߛߎ',
 			'Lyci' => 'ߟߛߌ',
 			'Lydi' => 'ߟߘߌ',
 			'Mahj' => 'ߡߤߊߖߊߣߌ',
 			'Maka' => 'ߡߞߊߛߊ߯ߙ',
 			'Mand' => 'ߡߊ߲߬ߘߋ߲߬ߞߊ ߡߋߛߔߏߕߊߡߌ߫',
 			'Mani' => 'ߡߊߣߌߛߋ',
 			'Marc' => 'ߡߊߙߑߛߋ',
 			'Medf' => 'ߡߋߘߑߝߘߌߙߌ߲',
 			'Mend' => 'ߡߍ߲߬ߘߋ',
 			'Merc' => 'ߡߋߞߙߏߕߌߞ ߞߎ߳ߙߑߛߌߝ',
 			'Mero' => 'ߡߋߙߏߦߕߌߞ',
 			'Mlym' => 'ߡߟߊߦߊߟߊ߲',
 			'Modi' => 'ߡߏߘߌ',
 			'Mong' => 'ߡߐ߲ߜ߭ߐߟ',
 			'Mroo' => 'ߡߑߙߏ',
 			'Mtei' => 'ߡߋߦߌߕߋ ߡߊߦߌߞ',
 			'Mult' => 'ߡߎߟߑߕߊߣߌ',
 			'Mymr' => 'ߓߙߌߡߊ߲',
 			'Nand' => 'ߣߊ߲ߘߌߣߜ߭ߊߙߌ',
 			'Narb' => 'ߕߟߋ߬ߓߐ-ߊߙߊߓߎ',
 			'Nbat' => 'ߣߓߊߕߋ',
 			'Newa' => 'ߣߋߥߊ',
 			'Nkoo' => 'ߒߞߏ',
 			'Nshu' => 'ߣߎ߳ߛߎ',
 			'Ogam' => 'ߏߜ߭ߊ߲',
 			'Olck' => 'ߏߟߑߗߞߌ',
 			'Orkh' => 'ߐߙߑߞߐ߲',
 			'Orya' => 'ߏߖߊ',
 			'Osge' => 'ߏߛߊߖ߭',
 			'Osma' => 'ߎߛߑߡߊߣߌ',
 			'Ougr' => 'ߎߜ߭ߎߙ ߞߘߐ߬ߡߊ߲',
 			'Palm' => 'ߔߊߟߑߡߙߋߣߌ',
 			'Pauc' => 'ߔߊߎ-ߛߌ߲ߤߊߥߎ',
 			'Perm' => 'ߡߙߋߡߌ߫ ߞߘߐ߬ߡߊ߲',
 			'Phag' => 'ߝߊߜ߭-ߔߊ',
 			'Phli' => 'ߝߋ߲ߟߋߥߌ߫ ߛߓߍߟߌ ߟߎ߬',
 			'Phlp' => 'ߛߏߕߌߦߋ߫ ߝߋ߲ߟߋߝ߭ߌ',
 			'Phnx' => 'ߝߋߣߌߛߌ',
 			'Plrd' => 'ߔߏߟߊߙ ߞߊ߲ߡߊߛߙߋߡߊ',
 			'Prti' => 'ߔߊߙߑߕ ߛߓߍߟߌ',
 			'Qaag' => 'ߖ߭ߊߎߜ߭ߌ',
 			'Rjng' => 'ߙߋߖ߭ߊ߲ߜ߭',
 			'Rohg' => 'ߤߊߣߝߌ',
 			'Runr' => 'ߙߎߣߌߞ',
 			'Samr' => 'ߛߡߊߙߌߕߍ߲',
 			'Sarb' => 'ߥߙߏ߬ߘߎ߮ ߊߙߊߓߎ߫ ߞߘߐ߬ߡߊ߲',
 			'Saur' => 'ߛߏߙߊߗߌߙߊ',
 			'Sgnw' => 'ߞߐߙߍߦߊ߫-ߛߓߍߟߌ ߟߎ߬',
 			'Shaw' => 'ߛߊߝ߭ߌ',
 			'Shrd' => 'ߛߙߊߘߊ',
 			'Sidd' => 'ߛߌߘߊߡ',
 			'Sind' => 'ߛߌ߲ߘߌ',
 			'Sinh' => 'ߛߌ߲ߜ߭ߟߊ',
 			'Sogd' => 'ߛߏߜ߭ߑߘߌ',
 			'Sogo' => 'ߛߏߜ߭ߑߘߌ ߞߘߐ߬ߡߊ߲',
 			'Sora' => 'ߛߏߙߊ ߛߎ߲ߔߍ߲ߜ߭',
 			'Soyo' => 'ߛߏߦߏ߲ߓߏ',
 			'Sund' => 'ߛߎ߲ߘߣߊ',
 			'Sylo' => 'ߛߌߟߏߕߌ ߣߊߜ߭ߑߙߌ',
 			'Syrc' => 'ߛߙߌߦߊߞ',
 			'Tagb' => 'ߕߜߊߣߎߥߊ',
 			'Takr' => 'ߕߊߞߙߌ',
 			'Tale' => 'ߕߊߦߌ-ߟߋ߫',
 			'Talu' => 'ߕߊߦߌ-ߟߎ߫ ߞߎߘߊ߫',
 			'Taml' => 'ߕߊߡߎߟ',
 			'Tang' => 'ߕߊ߲ߜ߭ߎߕ',
 			'Tavt' => 'ߕߊߦߌ-ߝ߭ߌߋ߫',
 			'Telu' => 'ߕߟߋߜ߭ߎ',
 			'Tfng' => 'ߕߝߌߣߊߜ߭',
 			'Tglg' => 'ߕߜ߭ߊߟ',
 			'Thaa' => 'ߕߡߊ',
 			'Thai' => 'ߕߊߦߌ',
 			'Tibt' => 'ߕߓߌߕߋߕߍ߲',
 			'Tirh' => 'ߕߌߙߎߕߊ',
 			'Tnsa' => 'ߕߊ߲ߜߑߛߊ߫',
 			'Toto' => 'ߕߏߕߏ߫',
 			'Ugar' => 'ߎߜ߭ߊߙߕߌߞ',
 			'Vaii' => 'ߒߝ߭ߊߦߌ',
 			'Vith' => 'ߝ߭ߌߕߑߞߎߜ߭ߌ߫',
 			'Wara' => 'ߥߊߙߊ߲ߜ߭ ߛߕߌ',
 			'Wcho' => 'ߥߊ߲ߗߏ',
 			'Xpeo' => 'ߝߊ߯ߙߛߌ߫ ߞߘߐߡߊ߲',
 			'Xsux' => 'ߛߎߡߋߙߏ-ߊߞߊߘߌ',
 			'Yezi' => 'ߦߋߖ߭ߘߌ',
 			'Yiii' => 'ߦߌ',
 			'Zanb' => 'ߖ߭ߣߊߓߊߖ߭ߊ߯ߙ ߝߘߎ߬ߓߍ߲',
 			'Zinh' => 'ߤߋߙߌߕߋ',
 			'Zmth' => 'ߘߡߊ߬ߟߐ߲ ߛߙߍߛߙߍߦߊߟߌ',
 			'Zsye' => 'ߋߡߏߖߌ߬',
 			'Zsym' => 'ߕߐ߰ߡߊ߬ߛߙߋ',
 			'Zxxx' => 'ߛߓߍߓߊߟߌ',
 			'Zyyy' => 'ߞߏߡߎ߲',
 			'Zzzz' => 'ߛߓߍߟߌ߫ ߡߊߟߐ߲ߓߊߟߌ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'ߞߌߢߍ߲߫',
 			'002' => 'ߝߘߊ߬ߝߌ߲߬ߠߊ߫',
 			'003' => 'ߊߡߋߙߌߞߌ߬ ߞߐ߬ߘߎ߮',
 			'005' => 'ߊߡߋߙߌߞߌ߬ ߥߙߏ߬ߘߎ߮',
 			'009' => 'ߟߌ߲ߓߊ߲ߘߎ߯',
 			'011' => 'ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߟߋ߬ߓߋ',
 			'013' => 'ߊߡߋߙߌߞߌ߬ ߕߊ߲ߓߊ߲',
 			'014' => 'ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߟߋ߬ߓߐ',
 			'015' => 'ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߞߐ߬ߘߎ߮',
 			'017' => 'ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߊ߲ߓߊ߲',
 			'018' => 'ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߥߙߏ߬ߘߎ߮',
 			'019' => 'ߊߡߋߙߌߞߌ߬',
 			'021' => 'ߞߐ߰ߘߎ߮ ߊߡߋߙߌߞߌ߬',
 			'029' => 'ߞߙߊߦߌߓ',
 			'030' => 'ߊߖ߭ߌ߫ ߕߟߋ߬ߓߐ',
 			'034' => 'ߊߖ߭ߌ߫ ߥߙߏ߬ߘߎ߮',
 			'035' => 'ߊߖ߭ߌ߫ ߥߙߏ߬ߘߎ߮-ߕߟߋ߬ߓߐ',
 			'039' => 'ߋߙߐߔߎ߬ ߥߙߏ߬ߘߎ߮',
 			'053' => 'ߐߛߑߕߙߊߟߊߖ߭ߌ߫',
 			'054' => 'ߡߋߟߊߣߋߖ߭ߌ߫',
 			'057' => 'ߡߌߞߙߏߣߋߖ߭ߌ߫ ߕߌ߲߬ߞߎߘߎ߲',
 			'061' => 'ߔߏߟߣߋߖ߭ߌ߫',
 			'142' => 'ߊߖ߭ߌ߫',
 			'143' => 'ߊߖ߭ߌ߫ ߕߊ߲ߓߊ߲',
 			'145' => 'ߊߖ߭ߌ߫ ߕߟߋ߬ߓߋ',
 			'150' => 'ߋߙߐߔߎ߬',
 			'151' => 'ߋߙߐߔߎ߬ ߕߟߋ߬ߓߐ',
 			'154' => 'ߋߙߐߔߎ߬ ߞߐ߬ߘߎ߮',
 			'155' => 'ߋߙߐߔߎ߬ ߕߟߋ߬ߓߋ',
 			'202' => 'ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߞߌ߬ߢߍ߬ߞߏ߲ߞߏ߫ ߘߎ߰ߟߊ߬-ߖߡߊߣߊ',
 			'419' => 'ߊߡߋߙߞߌ߬ ߟߊ߬ߕߍ߬ߡߊ߬ ߦߙߐ',
 			'AC' => 'ߊߛߊ߲ߛߌߦߐ߲߫ ߕߌ߲',
 			'AD' => 'ߊ߲ߘߐߙ',
 			'AE' => 'ߋߡߌߙߊߕ ߊߙߊߓߎ߫ ߘߍ߬ߣߍ߲',
 			'AF' => 'ߊߝߎߜ߭ߊߣߌߛߑߕߊ߲߫',
 			'AG' => 'ߊ߲ߕߌߞߎߥߊ߫ ߣߌ߫ ߓߊߙߑߓߎߘߊ߫',
 			'AI' => 'ߊ߲ߞߎ߳ߟߊ߫',
 			'AL' => 'ߊߟߑߓߊߣߌ߫',
 			'AM' => 'ߊߙߑߡߋߣߌ߫',
 			'AO' => 'ߊ߲ߜߏߟߊ߫',
 			'AQ' => 'ߊ߲ߕߊߙߑߛߕߌߞ',
 			'AR' => 'ߊߙߑߖ߭ߊ߲ߕߌߣ',
 			'AS' => 'ߛߊߡߏߥߊ߫ ߊߡߋߙߞߌߞߊ',
 			'AT' => 'ߏߕߑߙߌߛ',
 			'AU' => 'ߐߛߑߕߙߊߟߌ߫',
 			'AW' => 'ߊߙߎߓߊ߫',
 			'AX' => 'ߊߟߊ߲ߘ ߕߌ߲',
 			'AZ' => 'ߊߖߊߙߑߓߊߦߌߖߊ߲',
 			'BA' => 'ߓߐߛߑߣߌ߫-ߍߙߑߖ߭ߋߜ߭ߏߝ߭ߌߣ',
 			'BB' => 'ߓߊߙߑߓߊߘ',
 			'BD' => 'ߓߊ߲ߜ߭ߑߟߊߘߍߛ',
 			'BE' => 'ߓߍߟߑߖ߭ߌߞ',
 			'BF' => 'ߓߙߎߞߌߣߊ߫ ߝߊ߬ߛߏ߫',
 			'BG' => 'ߓߌߟߑߜ߭ߊ߯ߙߌ߫',
 			'BH' => 'ߓߤߊ߬ߙߊߦߌ߬ߣ',
 			'BI' => 'ߓߎߙߎ߲ߘߌ߫',
 			'BJ' => 'ߓߋߣߍ߲߫',
 			'BL' => 'ߛߍ߲ߕ-ߓߌߙߑߕߟߋߡߌ߫',
 			'BM' => 'ߓߍߙߑߓߎߘ',
 			'BN' => 'ߓߙߎߣߋ߫',
 			'BO' => 'ߓߏߟߝ߭ߌ߫',
 			'BQ' => 'ߤߏߟߊ߲ߘ ߞߊߙߌߓߋ߫',
 			'BR' => 'ߓߙߋߖ߭ߌߟ',
 			'BS' => 'ߓߤߊߡߊߛ',
 			'BT' => 'ߓߎߕߊ߲߫',
 			'BV' => 'ߓߎߝ߭ߋ߫ ߕߌ߲',
 			'BW' => 'ߓߐߛߎߥߣߊ߫',
 			'BY' => 'ߓߌߟߏߙߌߛ',
 			'BZ' => 'ߓߋߟߌߖ߭',
 			'CA' => 'ߞߣߊߘߊ߫',
 			'CC' => 'ߞߏߞߏ߫ ߕߌ߲',
 			'CD' => 'ߞߏ߲߬ߜ߭ߏ߫-ߞߌ߲ߛߊߛߊ߫',
 			'CD@alt=variant' => 'ߞߏ߲߬ߜ߭ߏ߫ ߓߍ߯ߦߊ߫ ߞߊ߲ߓߍ߲',
 			'CF' => 'ߕߊ߲ߓߊ߲-ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߞߊ߲ߓߍ߲',
 			'CG' => 'ߞߏ߲߬ߜ߭ߏ߫-ߓߙߊߖ߭ߊ߫',
 			'CG@alt=variant' => 'ߞߏ߲߬ߜ߭ߏ߫ ߞߊ߲ߓߍ߫',
 			'CH' => 'ߛߎߥߌߛ',
 			'CI' => 'ߜߋ߲-ߞߐ߰ߖߌ߬ߘߊ',
 			'CI@alt=variant' => 'ߜߋ߲-ߞߐ߰ߖߌ߬ߘߊ ߞߊ߲ߓߍ߲',
 			'CK' => 'ߞߎߞ ߕߌ߲',
 			'CL' => 'ߛ߭ߟߌ߫',
 			'CM' => 'ߞߊߡߋߙߎ߲',
 			'CN' => 'ߛߌߣ',
 			'CO' => 'ߞߏߟߐ߲ߓߌ߫',
 			'CP' => 'ߞߟߌߔߍߙߑߕߐ߲߫ ߕߌ߲',
 			'CR' => 'ߞߐߛߑߕߊ߫ ߙߌߞߊ߫',
 			'CU' => 'ߞߎ߳ߓߊ߫',
 			'CV' => 'ߜߙߋߞߎ߲߫-ߝߙߌߛߌ߫',
 			'CW' => 'ߞߎߙߛߊߏ߫',
 			'CX' => 'ߞߙߌߛߑߕߌߡߊ߫ ߕߌ߲',
 			'CY' => 'ߛߌߔߑߙߎ߫',
 			'CZ' => 'ߗߍߞ',
 			'CZ@alt=variant' => 'ߗߍߞ ߞߊ߲ߓߍ߲',
 			'DE' => 'ߊߟߑߡߊ߲ߘߎ߯',
 			'DG' => 'ߖߋߜ߭ߏ߫-ߜ߭ߊߙߑߛߌߦߊ߫',
 			'DJ' => 'ߖߌߓߎߕߌ߫',
 			'DK' => 'ߘߊߣߌߡߊߙߑߞ',
 			'DM' => 'ߘߏߡߣߌߞ',
 			'DO' => 'ߘߏߡߣߌߞ ߞߊ߲ߓߍ߲',
 			'DZ' => 'ߊߟߑߖ߭ߋߙߌ߫',
 			'EA' => 'ߛߋߎߕߊ߫ ߣߌ߫ ߡߋߟߌߣߊ߫',
 			'EC' => 'ߕߍߡߊߓߊ߲߮',
 			'EE' => 'ߋߛߑߕߏߣߌ߫',
 			'EG' => 'ߋߖ߭ߌߔߑߕ',
 			'EH' => 'ߞߌ߲߬ߢߍ߬ߞߏ߲ߞߏ߫ ߕߟߋ߬ߓߋ',
 			'ER' => 'ߋߙߕߌߙߋ߫',
 			'ES' => 'ߊߛߌߔߊ߲߫',
 			'ET' => 'ߋߗߏߔߌ߫',
 			'EU' => 'ߋߙߐߔߎ߬ ߘߍ߭',
 			'EZ' => 'ߋߙߐߔߎ߬ ߞߣߍ',
 			'FI' => 'ߝߍ߲ߟߊ߲ߘ',
 			'FJ' => 'ߝߖߌ߫',
 			'FK' => 'ߡߊߟߎ߲ߌ߲߫ ߕߌ߲',
 			'FK@alt=variant' => 'ߡߊߟߎ߲ߌ߲߫ ߕߌ߲ ( ߝߊߟߑߞߑߟߊ߲ ߕߌ߲ )',
 			'FM' => 'ߡߌߞߙߏߣߋߖ߭ߌ߫',
 			'FO' => 'ߝߋߙߏߦߋ߫ ߕߌ߲',
 			'FR' => 'ߝߊ߬ߙߊ߲߬ߛߌ߫',
 			'GA' => 'ߜ߭ߊߓߐ߲߫',
 			'GB' => 'ߡߊ߲߬ߛߊ߬ߟߊ߫ ߟߊߘߍ߬ߣߍ߲',
 			'GB@alt=short' => 'ߡ.ߟ.',
 			'GD' => 'ߜ߭ߙߋߣߊߘ',
 			'GE' => 'ߖ߭ߋߐߙߑߖ߭ߌ߫',
 			'GF' => 'ߝߊ߲߬ߙߊ߲߬ߛߌ߫ ߜ߭ߎ߳ߦߊߣ',
 			'GG' => 'ߜ߭ߋߙߑߣߋߖ߭ߌ߫',
 			'GH' => 'ߜ߭ߊ߯ߣߊ߫',
 			'GI' => 'ߜ߭ߌߓߙߊߟߑߕߊߙ',
 			'GL' => 'ߜ߭ߎߙߎ߲ߟߊ߲ߘ',
 			'GM' => 'ߜ߭ߊ߲ߓߌ߫',
 			'GN' => 'ߖߌ߬ߣߍ߫',
 			'GP' => 'ߜ߭ߎߥߊߘߋߟߎߔ',
 			'GQ' => 'ߕߍߡߊߓߊ߲߮-ߖߌ߬ߣߍ߫',
 			'GR' => 'ߜ߭ߙߍ߬ߞߌ߬',
 			'GS' => 'ߖ߭ߐߙߑߖ߭ߌ߫ ߥߙߏ߬ߘߎ߮ ߣߌ߫ ߛߊ߲ߘߎߥߌߛ ߕߌ߲',
 			'GT' => 'ߜ߭ߎߥߊߕߋߡߟߊ߫',
 			'GU' => 'ߜ߭ߎߥߊߡ',
 			'GW' => 'ߖߌ߬ߣߍ߫ ߓߌߛߊߥߏ߫',
 			'GY' => 'ߜ߭ߎߦߊߣ',
 			'HK' => 'ߛߌߣ ߕߌ߲߬ߞߎߘߎ߲߫ ߡߊߡߙߊ߬ߣߍ߲ ߤߐ߲ߞߐ߲߫',
 			'HK@alt=short' => 'ߤߐ߲ߞߐ߲߫',
 			'HM' => 'ߡߊߞߑߘߏߣߊߟߑߘ ߕߌ߲',
 			'HN' => 'ߤߎ߲ߘߎߙߊ߫',
 			'HR' => 'ߞߙߏߥߊߛߌ߫',
 			'HT' => 'ߤߊߦߕߌ߫',
 			'HU' => 'ߤߐ߲ߜ߭ߙߌ߫',
 			'IC' => 'ߞߣߊߙߌ߫ ߕߌ߲',
 			'ID' => 'ߍ߲ߘߣߏߖ߭ߌ߫',
 			'IE' => 'ߌߙߑߟߊ߲ߘ',
 			'IL' => 'ߌߛߑߙߊߍߟ',
 			'IM' => 'ߡߊ߲߯ ߕߌ߲',
 			'IN' => 'ߌߘߎ߬',
 			'IO' => 'ߓߙߌߕߊ߲ߓߊ߫ ߟߊ߫ ߌ߲ߘߎ߫ ߟߌ߲ߓߊ߲ ߞߣߍ',
 			'IQ' => 'ߌߙߊߞߌ߬',
 			'IR' => 'ߌߙߊ߲߫',
 			'IS' => 'ߌߛߑߟߊߘ',
 			'IT' => 'ߌߕߊߟߌ߫',
 			'JE' => 'ߖߋߙߑߖ߭ߌ߫',
 			'JM' => 'ߖ߭ߡߊߦߌߞ',
 			'JO' => 'ߖߐߙߑߘߊߣߌ߫',
 			'JP' => 'ߖ߭ߊߔߐ߲߫',
 			'KE' => 'ߞߋߣߌߦߊ߫',
 			'KG' => 'ߞߌߙߑߜ߭ߌߛߑߕߊ߲߫',
 			'KH' => 'ߞߊ߲ߓߐߘߑߖ',
 			'KI' => 'ߞߙߌߓߊߕߌ߫',
 			'KM' => 'ߞߡߐߙ',
 			'KN' => 'ߛߍ߲ߕ-ߞߙߌߛߑߕߐߝ ߣߌ߫ ߢߝ߭ߋ߫',
 			'KP' => 'ߞߐ߬ߘߎ߮ ߞߏ߯ߙߋ߫',
 			'KR' => 'ߕߟߋ߬ߓߋ ߞߏ߯ߙߋ߫',
 			'KW' => 'ߞߎ߬ߥߊ߬ߕ',
 			'KY' => 'ߓߊ߲߬ߓߊ߬-ߕߌ߲',
 			'KZ' => 'ߞߖ߭ߊߞߌߛߑߕߊ߲߫',
 			'LA' => 'ߟߊߐߛ',
 			'LB' => 'ߟߌߓߊ߲߫',
 			'LC' => 'ߛߍ߲ߕ-ߟߎ߳ߛߌ߫',
 			'LI' => 'ߟߎߛߑߕߊ߲ߛߑߕߍ߲߫',
 			'LK' => 'ߛߙߌߟߊ߲ߞߊ߫',
 			'LR' => 'ߟߌߓߋߙߌߦߊ߫',
 			'LS' => 'ߟߋߛߕߏ߫',
 			'LT' => 'ߟߎߕߎ߳ߦߊߣߌ߫',
 			'LU' => 'ߟߎߜ߭ߑߛߊ߲ߓߎ߯ߙ',
 			'LV' => 'ߟߋߕߏߣߌ߫',
 			'LY' => 'ߟߓߌ߫',
 			'MA' => 'ߡߊ߬ߙߐߞߎ߬',
 			'MC' => 'ߡߏߣߊߞߏ߫',
 			'MD' => 'ߡߐߟߑߘߊߝ߭ߌ߫',
 			'ME' => 'ߡߐ߲ߕߣߋߜ߭ߙߏ߫',
 			'MF' => 'ߛߍ߲ߕ-ߡߊߙߑߕߍ߲߫',
 			'MG' => 'ߡߘߊߜ߭ߛߑߞߊ߯ߙ',
 			'MH' => 'ߡߊߙߑߛߊߟ ߕߌ߲',
 			'MK' => 'ߞߐ߬ߘߎ߮ ߡߊߛߋߘߏߣߌ߫',
 			'ML' => 'ߡߊ߬ߟߌ߬',
 			'MM' => 'ߡߌߦߊߡߊ߯ߙ ( ߓߙߌߡߊߣߌ߫ )',
 			'MN' => 'ߡߐ߲ߜ߭ߐߟߌ߫',
 			'MO' => 'ߛߌߣ ߕߌ߲߬ߞߎߘߎ߲߫ ߡߊߡߙߊ߬ߣߍ߲ ߡߞߊߥߏ߫',
 			'MO@alt=short' => 'ߡߞߊߥߏ߫',
 			'MP' => 'ߡߊߙߌߦߊߣ ߞߐ߬ߘߎ߮ ߕߌ߲',
 			'MQ' => 'ߡߊߙߑߕߣߌߞ',
 			'MR' => 'ߡߏߙߌߕߊߣߌ߫',
 			'MS' => 'ߡߐ߲ߗߋߙߊ߫',
 			'MT' => 'ߡߊߟߑߕ',
 			'MU' => 'ߡߏߙߌߛ',
 			'MV' => 'ߡߊߟߑߘߌߝ߭',
 			'MW' => 'ߡߟߊߥߌ߫',
 			'MX' => 'ߡߍߞߑߛߌߞ',
 			'MY' => 'ߡߊߟߍߘߎ߯',
 			'MZ' => 'ߡߏߖ߭ߊ߲ߓߌߞ',
 			'NA' => 'ߣߊߡߌ߲ߓߌ߫',
 			'NC' => 'ߞߊߟߋߘߏߣߌ߫-ߞߎߘߊ߫',
 			'NE' => 'ߖߋ߬ߟߌ߬ߓߊߘߎ߯',
 			'NF' => 'ߣߐߙߑߝߐߟߑߞ',
 			'NG' => 'ߖߋ߬ߟߌ߬ߓߊ߬ߟߊ߫',
 			'NI' => 'ߣߌߞߙߊߜ߭ߎߥߊ߫',
 			'NL' => 'ߤߏߟߊ߲ߘ',
 			'NO' => 'ߣߐߙߑߝ߭ߍߖ',
 			'NP' => 'ߣߋߔߊߟ',
 			'NR' => 'ߣߏ߯ߙߎ߫',
 			'NU' => 'ߣߎ߳ߋ߫',
 			'NZ' => 'ߖ߭ߋߟߊ߲ߘߌ߫-ߞߎߘߊ߫',
 			'OM' => 'ߏߡߊ߲߫',
 			'PA' => 'ߔߣߊߡߊ߫',
 			'PE' => 'ߔߋߙߎ߫',
 			'PF' => 'ߝߊ߬ߙߊ߲߬ߛߌ߫ ߔߏߟߌߣߋߖ߭ߌ߫',
 			'PG' => 'ߡߊߡߎߥߊߖ߭ߌ߫ ߖߌ߬ߣߍ߬-ߞߎߘߊ߫',
 			'PH' => 'ߝߟߌߔߌ߲ߣ',
 			'PK' => 'ߔߊߞߌߛߑߕߊ߲߫',
 			'PL' => 'ߔߏߟߐߢ',
 			'PM' => 'ߛߍ߲ߕ-ߔߍ߯ߙ ߣߌ߫ ߡߌ߲ߞߋߟߐ߲߫',
 			'PN' => 'ߔߌߕߑߞߍ߲ ߕߌ߲',
 			'PR' => 'ߔߐߙߑߕߏ߫-ߙߌߞߏ߫',
 			'PS' => 'ߔߊߟߍߛߑߕߌߣ ߞߣߍ',
 			'PS@alt=short' => 'ߔߊߟߍߛߑߕߌߣ',
 			'PT' => 'ߔߐߙߑߕߎߜ߭ߊߟ',
 			'PW' => 'ߔߟߊߐߛ',
 			'PY' => 'ߔߙߊߜ߭ߏߦߋ߫',
 			'QA' => 'ߞߊߕߊ߯ߙ',
 			'QO' => 'ߟߌ߲ߓߊ߲ߘߎ߯ ߕߌ߲߬ߞߎߘߎ߲ ߦߙߐ߫ ߡߊߕߊ߯ߣߍ߲',
 			'RE' => 'ߟߊ߬ߘߍ',
 			'RO' => 'ߙߎߡߊߣߌ߫',
 			'RS' => 'ߛߍߙߑߓߌ߫',
 			'RU' => 'ߌߙߌ߬ߛߌ߫',
 			'RW' => 'ߙߎߥߊ߲ߘߊ߫',
 			'SA' => 'ߛߎ߰ߘߎ߬ߟߊ߫-ߡߊ߲߬ߛߊ߬ߟߊ',
 			'SB' => 'ߛߊߟߏߡߐ߲߫ ߕߌ߲',
 			'SC' => 'ߛߋߦߌߛߍߟ',
 			'SD' => 'ߛߎߘߊ߲߫',
 			'SE' => 'ߛߎߥߍߘ',
 			'SG' => 'ߛߌ߲ߜ߭ߊߔߎߙ',
 			'SH' => 'ߛߍ߲ߕ-ߋߟߍߣ',
 			'SI' => 'ߛߑߟߏߝ߭ߋߣߌ߫',
 			'SJ' => 'ߛߊߟߑߓߊߙ ߣߌ߫ ߖ߭ߊ߲ ߡߊߦߍ߲߫',
 			'SK' => 'ߛߑߟߏߝ߭ߊߞߌ߫',
 			'SL' => 'ߛߙߊ߬ߟߏ߲߫',
 			'SM' => 'ߛߍߕ-ߡߊߙߍ߲߫',
 			'SN' => 'ߛߣߍ߬ߜߊ߯ߟߌ߫',
 			'SO' => 'ߛߏߡߊߟߌ߫',
 			'SR' => 'ߛߎߙߑߣߊߡ',
 			'SS' => 'ߥߙߏ߬ߘߎ߮ ߛߎ߬ߘߊ߲߫',
 			'ST' => 'ߛߊߥߕߏߡߋ߫ ߣߌ߫ ߔߑߙߍ߲ߛߌߔ',
 			'SV' => 'ߛߊߟߑߝ߭ߊߘߐߙ',
 			'SX' => 'ߛߍ߲ߕ-ߡߊߙߑߕߍ߲߫ ( ߤߏߟߊ߲ߘ ߝߊ߲߭ߝߍ߬ )',
 			'SY' => 'ߛߙߌ߫',
 			'SZ' => 'ߒߛߎߥߊߕߣߌ߫',
 			'SZ@alt=variant' => 'ߛߑߥߊߖ߭ߌߟߊ߲ߘ',
 			'TA' => 'ߞߎ߲ߓߊ߫ ߕߑߙߌߛߑߕߊ߫',
 			'TC' => 'ߕߎߙߑߞߌ߫ ߣߌ߫ ߞߊߦߌߞ',
 			'TD' => 'ߗߊߘ',
 			'TF' => 'ߝߊ߬ߙߊ߲߬ߛߌ߫ ߘߎ߰ߞߟߏ ߓߊߙߌ ߘߐ߫',
 			'TG' => 'ߕߜ߭ߏ߫',
 			'TH' => 'ߕߊߦߌߘߎ߯',
 			'TJ' => 'ߕߊߖߞߌߛߑߕߊ߲߫',
 			'TK' => 'ߕߏߞߋߟߊߏ߫',
 			'TL' => 'ߕߌߡߐߙ ߕߟߋ߬ߓߐ߬ߝߊ߲',
 			'TL@alt=variant' => 'ߕߌߡߐߙ ߕߟߋ߬ߓߐ',
 			'TM' => 'ߕߎߙߑߞߌߡߋߣߌߛߑߕߊ߲߫',
 			'TN' => 'ߕߎߣߖ߭ߌ߫',
 			'TO' => 'ߕߏ߲ߜ߭ߊ߫',
 			'TR' => 'ߕߎߙߑߞߌ߫',
 			'TT' => 'ߕߙߌߣߌߕߋ߫ ߣߌ߫ ߕߏߓߊߜ߭ߏ߫',
 			'TV' => 'ߕߎߝ߭ߊߟߎ߫',
 			'TW' => 'ߕߊߦߌߥߊ߲߫',
 			'TZ' => 'ߕߊ߲ߖ߭ߊߣߌ߫',
 			'UA' => 'ߎ߳ߞߑߙߍߣ',
 			'UG' => 'ߎߜ߭ߊ߲ߘߊ߫',
 			'UM' => 'ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲ ߘߌߣߍ߲߫ ߕߌ߲߫ ߡߊߕߊ߯ߣߍ߲',
 			'UN' => 'ߡߊ߲߬ߕߏ߲߫ ߠߊߘߍ߬ߣߍ߲ ߛߌ߬ߝߏ߲߬ߧߊ߬ߟߌ',
 			'US' => 'ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲',
 			'US@alt=short' => 'ߞ.ߘ.',
 			'UY' => 'ߎ߳ߙߑߜ߭ߋߦߌ߫',
 			'UZ' => 'ߎߖ߭ߑߓߋߞߌߛߑߕߊ߲߫',
 			'VA' => 'ߝ߭ߊߕߌߞߊ߲߫ ߞߊ߬ߝߏ',
 			'VC' => 'ߛߍ߲ߕ-ߝ߭ߍߛߊ߲ ߜ߭ߙߋߣߊߘߌ߫',
 			'VE' => 'ߝ߭ߣߋߖ߭ߎߦߋߟߊ߫',
 			'VG' => 'ߓߙߌߕߊ߲ߓߊ߫ ߕߌ߲߫ ߞߊߓߊ߲',
 			'VI' => 'ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲ ߕߌ߲߫ ߞߊߓߊ߲߫',
 			'VN' => 'ߝ߭ߌߦߍߕߑߣߊߡ',
 			'VU' => 'ߝ߭ߊߣߎߦߊߕߎ߫',
 			'WF' => 'ߥߊߟߌߛߌ߫ ߣߌ߫ ߝߕߎߣߊ߫',
 			'WS' => 'ߛߊߡߏߥߊ߫',
 			'XA' => 'ߔߛߏߘߏ߫ ߊߞߑߛߊ߲',
 			'XB' => 'ߔߛߔߘߏ߫-ߓߘߌ߫',
 			'XK' => 'ߞߛߏߝ߭ߏ߫',
 			'YE' => 'ߦߡߊߣߌ߲߫',
 			'YT' => 'ߡߊߦߐߕ',
 			'ZA' => 'ߥߙߏ߬ߘߎ߮ ߝߘߊ߬ߝߌ߲߬ߠߊ߫',
 			'ZM' => 'ߖ߭ߊ߲ߓߌ߫',
 			'ZW' => 'ߖ߭ߌ߲ߓߊߓߏߦߋ߫',
 			'ZZ' => 'ߕߌ߲߬ߞߎߘߎ߲߫ ߕߊ߲߬ߠߊߕߍ߰ߓߊߟߌ',

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{ߜߟߊ߬ߜߟߊ߬ߡߊ},
 			'UK' => q{ߓߙߌߕߊ߲ߓߊ߫ ߡߊ߲߬ߛߊ߬ߟߊ (ߓ.ߡ.)},
 			'US' => q{ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲ (ߞ.ߘ.)},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'ߞߊ߲: {0}',
 			'script' => 'ߛߓߍߟߌ: {0}',
 			'region' => 'ߕߌ߲߬ߞߎߘߎ߲: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ߨ ߩ ߪ]},
			main => qr{[߫ ߬ ߭ ߮ ߯ ߰ ߱ ߲ ߳ ߊ ߋ ߌ ߍ ߎ ߏ ߐ ߑ ߒ ߓ ߔ ߕ ߖ ߗ ߘ ߙ ߚ ߛ ߜ ߝ ߞ ߟ ߠ ߡ ߢ ߣ ߤ ߥ ߦ ߧ ߴ ߵ]},
			numbers => qr{[\- ‑ ، . % ‰ + ߀ ߁ ߂ ߃ ߄ ߅ ߆ ߇ ߈ ߉]},
			punctuation => qr{[߸ ߹ ߷]},
		};
	},
EOT
: sub {
		return {};
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ߟߏ߲),
						'other' => q(ߟߏ߲ ߜߍ {0}),
						'per' => q(ߟߏ߲ ߠߊ߫ {0}),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ߟߏ߲),
						'other' => q(ߟߏ߲ ߜߍ {0}),
						'per' => q(ߟߏ߲ ߠߊ߫ {0}),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ߦߟߍ߬ߘߐ߬ߞߍ),
						'other' => q(ߦߟߍ߬ߘߐ߬ߞߍ {0}),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ߦߟߍ߬ߘߐ߬ߞߍ),
						'other' => q(ߦߟߍ߬ߘߐ߬ߞߍ {0}),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'other' => q(ߕߎ߬ߡߊ߬ߙߋ߲ {0}),
						'per' => q(ߕߎ߬ߡߊ߬ߙߋ߲ ߞߘߐ߫ {0}),
					},
					# Core Unit Identifier
					'hour' => {
						'other' => q(ߕߎ߬ߡߊ߬ߙߋ߲ {0}),
						'per' => q(ߕߎ߬ߡߊ߬ߙߋ߲ ߞߘߐ߫ {0}),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(ߝߌ߬ߟߊ߲߬ߢߊ߲߯ߕߊ),
						'other' => q(ߝߌ߬ߟߊ߲߬ߢߊ߲߯ߕߊ {0}),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(ߝߌ߬ߟߊ߲߬ߢߊ߲߯ߕߊ),
						'other' => q(ߝߌ߬ߟߊ߲߬ߢߊ߲߯ߕߊ {0}),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ߝߌ߬ߟߊ߲߬ߥߊ߰ߘߋ߲),
						'other' => q(ߝߌ߬ߟߊ߲߬ߥߊ߰ߘߋ߲ {0}),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ߝߌ߬ߟߊ߲߬ߥߊ߰ߘߋ߲),
						'other' => q(ߝߌ߬ߟߊ߲߬ߥߊ߰ߘߋ߲ {0}),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(ߡߌ߬ߛߍ߲),
						'other' => q(ߡߌ߬ߛߍ߲ {0}),
						'per' => q(ߡߌ߬ߛߍ߲ ߠߊ߫ {0}),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(ߡߌ߬ߛߍ߲),
						'other' => q(ߡߌ߬ߛߍ߲ {0}),
						'per' => q(ߡߌ߬ߛߍ߲ ߠߊ߫ {0}),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ߞߊߙߏ),
						'other' => q(ߞߊߙߏ {0}),
						'per' => q(ߞߊߙߏ ߟߊ߫ {0}),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ߞߊߙߏ),
						'other' => q(ߞߊߙߏ {0}),
						'per' => q(ߞߊߙߏ ߟߊ߫ {0}),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ߝߌ߬ߟߊ߲߬ߞߏߦߋ),
						'other' => q(ߝߌ߬ߟߊ߲߬ߞߏߦߋ {0}),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ߝߌ߬ߟߊ߲߬ߞߏߦߋ),
						'other' => q(ߝߌ߬ߟߊ߲߬ߞߏߦߋ {0}),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ߝߌ߬ߟߊ߲),
						'other' => q(ߝߌ߬ߟߊ߲ {0}),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ߝߌ߬ߟߊ߲),
						'other' => q(ߝߌ߬ߟߊ߲ {0}),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ߞߎ߲߬ߢߐ߮),
						'other' => q(ߞߎ߲߬ߢߐ߮ {0}),
						'per' => q(ߞߎ߲߬ߢߐ߮ ߟߊ߫ {0}),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ߞߎ߲߬ߢߐ߮),
						'other' => q(ߞߎ߲߬ߢߐ߮ {0}),
						'per' => q(ߞߎ߲߬ߢߐ߮ ߟߊ߫ {0}),
					},
					# Long Unit Identifier
					'duration-year' => {
						'per' => q(ߛߊ߲߭ ߠߊ߫ {0}),
					},
					# Core Unit Identifier
					'year' => {
						'per' => q(ߛߊ߲߭ ߠߊ߫ {0}),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'duration-century' => {
						'other' => q(ߝߊ߯ߘߞ{0}),
					},
					# Core Unit Identifier
					'century' => {
						'other' => q(ߝߊ߯ߘߞ{0}),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ߟߏ߲),
						'other' => q(ߟ{0}),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ߟߏ߲),
						'other' => q(ߟ{0}),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ߦߟߍ߬ߘߐ߬ߞߍ),
						'other' => q(ߦߟߍ߬ߘߞ{0}),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ߦߟߍ߬ߘߐ߬ߞߍ),
						'other' => q(ߦߟߍ߬ߘߞ{0}),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'other' => q(ߕ{0}),
					},
					# Core Unit Identifier
					'hour' => {
						'other' => q(ߕ{0}),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'other' => q(ߝߢ{0}),
					},
					# Core Unit Identifier
					'microsecond' => {
						'other' => q(ߝߢ{0}),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'other' => q(ߝߥ{0}),
					},
					# Core Unit Identifier
					'millisecond' => {
						'other' => q(ߝߥ{0}),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'other' => q(ߡߌ߬ߛ{0}),
					},
					# Core Unit Identifier
					'minute' => {
						'other' => q(ߡߌ߬ߛ{0}),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ߞߊߙߏ),
						'other' => q(ߞ.{0}),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ߞߊߙߏ),
						'other' => q(ߞ.{0}),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ߝߞ),
						'other' => q(ߝߞ{0}),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ߝߞ),
						'other' => q(ߝߞ{0}),
					},
					# Long Unit Identifier
					'duration-second' => {
						'other' => q(ߝ{0}),
					},
					# Core Unit Identifier
					'second' => {
						'other' => q(ߝ{0}),
					},
					# Long Unit Identifier
					'duration-year' => {
						'other' => q(ߛߊ߲߭{0}),
					},
					# Core Unit Identifier
					'year' => {
						'other' => q(ߛߊ߲߭{0}),
					},
				},
				'short' => {
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ߝߊ߯ߘߐߞߍ),
						'other' => q(ߝߊ߯ߘߐߞߍ {0}),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ߝߊ߯ߘߐߞߍ),
						'other' => q(ߝߊ߯ߘߐߞߍ {0}),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ߟ),
						'other' => q(ߟ {0}),
						'per' => q({0}/ߟ),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ߟ),
						'other' => q(ߟ {0}),
						'per' => q({0}/ߟ),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ߦߟߍ߬ߘ),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ߦߟߍ߬ߘ),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ߕߎ߬ߡߊ߬ߙߋ߲),
						'other' => q(ߕ {0}),
						'per' => q({0}/ߕ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ߕߎ߬ߡߊ߬ߙߋ߲),
						'other' => q(ߕ {0}),
						'per' => q({0}/ߕ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(ߝߢ),
						'other' => q(ߝߢ {0}),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(ߝߢ),
						'other' => q(ߝߢ {0}),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ߝߥ),
						'other' => q(ߝߥ {0}),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ߝߥ),
						'other' => q(ߝߥ {0}),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(ߡߌ߬ߛ),
						'other' => q(ߡߌ߬ߛ {0}),
						'per' => q({0}/ߡߌ߬ߛ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(ߡߌ߬ߛ),
						'other' => q(ߡߌ߬ߛ {0}),
						'per' => q({0}/ߡߌ߬ߛ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ߞ.),
						'other' => q(ߞ. {0}),
						'per' => q({0}/ߞ.),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ߞ.),
						'other' => q(ߞ. {0}),
						'per' => q({0}/ߞ.),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ߝߌ߬ߟߞ),
						'other' => q(ߝߞ {0}),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ߝߌ߬ߟߞ),
						'other' => q(ߝߞ {0}),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ߝ),
						'other' => q(ߝ {0}),
						'per' => q({0}/ߝ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ߝ),
						'other' => q(ߝ {0}),
						'per' => q({0}/ߝ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ߞߎ߲߬ߢ),
						'other' => q(ߞߎ߲߬ߢ{0}),
						'per' => q({0}/ߞߎ߲߬ߢ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ߞߎ߲߬ߢ),
						'other' => q(ߞߎ߲߬ߢ{0}),
						'per' => q({0}/ߞߎ߲߬ߢ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ߛߊ߲߭),
						'other' => q(ߛߊ߲߭ {0}),
						'per' => q({0}/ߛߊ߲߭),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ߛߊ߲߭),
						'other' => q(ߛߊ߲߭ {0}),
						'per' => q({0}/ߛߊ߲߭),
					},
				},
			} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'nkoo',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'nkoo',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'group' => q(،),
		},
	} }
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AOA' => {
			symbol => 'ߊ߲ߜ߭ߎ',
			display_name => {
				'currency' => q(ߊ߲ߜ߭ߏߟߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߊ߲ߖ߭ߊ),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(ߊ߲ߜ߭ߏߟߊ߫ ߞߎߥߊ߲ߖ߭ߊ \( ߁߉߇߇–߁߉߉߀ \)),
			},
		},
		'AON' => {
			symbol => 'ߊߜ߭ߞ',
			display_name => {
				'currency' => q(ߊ߲ߜ߭ߏߟߊ߫ ߞߎߥߊߖ߭ߊ߫ ߞߎߘߊ \( ߁߉߉߀–߂߀߀߀ \)),
			},
		},
		'AOR' => {
			symbol => 'ߊߜ߭ߝ',
			display_name => {
				'currency' => q(ߊ߲ߜ߭ߏߟߊ߫ ߞߎߥߊߖ߭ߊ ߝߊ߲߬ߞߊߘߏ߲߬ߣߍ߲ \( ߁߉߉߅–߁߉߉߉ \)),
			},
		},
		'BIF' => {
			symbol => 'ߓߙߝ',
			display_name => {
				'currency' => q(ߓߎߙߎ߲ߘߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲),
			},
		},
		'BWP' => {
			symbol => 'ߓߥߔ',
			display_name => {
				'currency' => q(ߓߐߛߎߥߣߊߞߊ ߟߎ߬ ߟߊ߫ ߔߎߟߊ),
			},
		},
		'CDF' => {
			symbol => 'ߞߝ',
			display_name => {
				'currency' => q(ߞߏ߲߬ߜ߭ߏ߬ߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲),
			},
		},
		'CVE' => {
			symbol => 'ߍߛߞ',
			display_name => {
				'currency' => q(ߜߙߋߞߎ߲߫ ߝߙߌߛߌߞߊ ߟߎ߬ ߍߛߑߞߎߘߐߛ),
			},
		},
		'DJF' => {
			symbol => 'ߖߓߝ',
			display_name => {
				'currency' => q(ߖߌߓߎߕߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲),
			},
		},
		'DZD' => {
			symbol => 'ߊߟߘ',
			display_name => {
				'currency' => q(ߊߟߌߖ߭ߋߙߌߞߊ ߟߎ߬ ߟߊ߫ ߘߌ߬ߣߊ߯ߙߌ),
			},
		},
		'EGP' => {
			symbol => 'ߡߛߔ',
			display_name => {
				'currency' => q(ߡߌߛߌߙߊ߲ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬),
			},
		},
		'ERN' => {
			symbol => 'ߋߙߝ',
			display_name => {
				'currency' => q(ߋߙߌߕߙߋߞߊ ߟߎ߬ ߟߊ߫ ߣߊߝߑߞߊ),
			},
		},
		'ETB' => {
			symbol => 'ߋߗߓ',
			display_name => {
				'currency' => q(ߋߗߏߔߌߞߊ ߟߎ߬ ߟߊ߫ ߓߌߙߑߛ),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(ߛߘߌ),
				'other' => q(ߜ߭ߊ߯ߣߊ߫ ߛߘߌ \( ߁߉߆߇–߂߀߀߇ \)),
			},
		},
		'GHS' => {
			symbol => 'ߜ߭ߛߘ',
			display_name => {
				'currency' => q(ߜ߭ߊ߯ߣߊ߫ ߛߘߌ),
				'other' => q(ߜ߭ߊ߯ߣߞߊ ߟߎ߬ ߛߘߌ),
			},
		},
		'GMD' => {
			symbol => 'ߜ߭ߓߘ',
			display_name => {
				'currency' => q(ߜ߭ߊ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߘߟߊߛߌ߫),
			},
		},
		'GNF' => {
			symbol => '߿',
			display_name => {
				'currency' => q(ߖߌ߬ߣߍ߬ߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲),
			},
		},
		'GNS' => {
			symbol => 'ߖߛ߾',
			display_name => {
				'currency' => q(ߖߌ߬ߣߍ߬ߞߊ ߟߎ߬ ߟߊ߫ ߛߟߌ),
			},
		},
		'GQE' => {
			symbol => 'ߕߖߋ',
			display_name => {
				'currency' => q(ߕߍߡߊߓߊ߲߮ ߖߌ߬ߣߍ߬ߞߊ ߟߎ߬ ߟߊ߫ ߋߞߥߋߟߋ),
			},
		},
		'GWE' => {
			symbol => 'ߖߓߍ',
			display_name => {
				'currency' => q(ߖߌߣߍ߫ ߓߌߛߊߥߏߞߊ ߟߎ߬ ߟߊ߫ ߍߛߑߞߎߘߐߛ),
			},
		},
		'GWP' => {
			symbol => 'ߖߓߔ',
			display_name => {
				'currency' => q(ߖߌߣߍ߫ ߓߌߛߊߥߏߞߊ ߟߎ߬ ߟߊ߫ ߔߋߖ߭ߏ),
			},
		},
		'KES' => {
			symbol => 'ߞߋߛ',
			display_name => {
				'currency' => q(ߝߋߣߌߦߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭),
			},
		},
		'KMF' => {
			symbol => 'ߞߡߝ',
			display_name => {
				'currency' => q(ߞߐߡ߲߯ߙߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲),
			},
		},
		'LRD' => {
			symbol => 'ߟ߾',
			display_name => {
				'currency' => q(ߟߌߓߋߙߌߦߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊߙ),
			},
		},
		'LSL' => {
			symbol => 'ߟߛߟ',
			display_name => {
				'currency' => q(ߟߋߛߕߏߞߊ ߟߎ߬ ߟߊ߫ ߟߏߕߌ),
			},
		},
		'LYD' => {
			symbol => 'ߟߓߘ',
			display_name => {
				'currency' => q(ߟߓߌ߫ ߘߌ߬ߣߊ߯ߙ),
				'other' => q(ߟߓߌߞߊ ߟߎ߬ ߟߊ߫ ߘߌ߬ߣߊ߯ߙ),
			},
		},
		'MAD' => {
			symbol => 'ߡߘߤ',
			display_name => {
				'currency' => q(ߡߊ߬ߙߐߞߎ߬ ߘߌ߬ߙߑߤߊߡ),
				'other' => q(ߡߊ߬ߙߐ߬ߞߎ߬ߞߊ ߟߎ߬ ߟߊ߫ ߘߌ߬ߙߑߤߊߡ),
			},
		},
		'MAF' => {
			symbol => 'ߡߙߝ',
			display_name => {
				'currency' => q(ߡߊ߬ߙߐ߬ߞߎߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲),
			},
		},
		'MGA' => {
			symbol => 'ߡߘߙ',
			display_name => {
				'currency' => q(ߡߘߊߜ߭ߊߛߑߞߊ߯ߙߌߞߊ ߟߎ߬ ߟߊ߫ ߊߙߌߦߊߙߌ),
			},
		},
		'MGF' => {
			symbol => 'ߡߘߝ',
			display_name => {
				'currency' => q(ߡߘߊߜ߭ߊߑߞߊ߯ߙߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲),
			},
		},
		'MLF' => {
			symbol => 'ߡߝ',
			display_name => {
				'currency' => q(ߡߊߟߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲),
			},
		},
		'MRO' => {
			symbol => 'ߡߙߏ',
			display_name => {
				'currency' => q(ߡߏߙߌߕߊߣߌߞߊ ߟߎ߬ ߟߊ߫ ߎ߬ߜ߭ߌߦߊ \( ߁߉߇߃–߂߀߁߇ \)),
			},
		},
		'MRU' => {
			symbol => 'ߡߎߜ߭',
			display_name => {
				'currency' => q(ߡߏߙߌߕߊߣߌߞߊ ߟߎ߬ ߟߊ߫ ߎ߬ߜ߭ߌߦߊ),
			},
		},
		'MUR' => {
			symbol => 'ߡߙߔ',
			display_name => {
				'currency' => q(ߡߏߙߛߌߞߊ ߟߎ߬ ߟߊ߫ ߙߔߎ),
			},
		},
		'MWK' => {
			symbol => 'ߡߟߞ',
			display_name => {
				'currency' => q(ߡߟߊߥߌߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߛߊ),
			},
		},
		'MZE' => {
			symbol => 'ߡߖ߭ߋ',
			display_name => {
				'currency' => q(ߡߏߖ߭ߊ߲ߓߞߌߞߊ ߟߎ߬ ߟߊ߫ ߍߛߑߞߎߘߏߛ),
			},
		},
		'MZM' => {
			symbol => 'ߡߖߡ',
			display_name => {
				'currency' => q(ߡߏߖ߭ߊ߲ߓߞߌߞߊ ߟߎ߬ ߟߊ߫ ߡߋߕߌߞ \( ߁߉߈߀–߂߀߀߆ \)),
			},
		},
		'MZN' => {
			symbol => 'ߡߖ߭ߡ',
			display_name => {
				'currency' => q(ߡߏߖ߭ߊ߲ߓߞߌߞߊ ߟߎ߬ ߟߊ߫ ߡߋߕߌߞߊߟ),
			},
		},
		'NAD' => {
			symbol => 'ߣߡߘ',
			display_name => {
				'currency' => q(ߣߊߡߌ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ),
			},
		},
		'NGN' => {
			symbol => 'ߖߣ',
			display_name => {
				'currency' => q(ߖߋ߬ߟߌ߬ߓߊ߬ߞߊ ߟߎ߬ ߟߊ߫ ߣߍߙߊ),
			},
		},
		'RHD' => {
			symbol => 'ߖ߭ߓߘ',
			display_name => {
				'currency' => q(ߖ߭ߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ),
			},
		},
		'RWF' => {
			symbol => 'ߙߥߝ',
			display_name => {
				'currency' => q(ߙߎߥߊ߲ߘߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲),
			},
		},
		'SCR' => {
			symbol => 'ߛߛߥ',
			display_name => {
				'currency' => q(ߛߋߦߌߛߍߟߌߞߊ ߟߎ߬ ߟߊ߫ ߙߎߔߌ),
			},
		},
		'SDD' => {
			symbol => 'ߛߘߘ',
			display_name => {
				'currency' => q(ߛߎ߬ߘߊ߲߬ߞߊ ߟߎ߬ ߘߌ߬ߣߊ߯ߙ \( ߁߉߉߂–߂߀߀߇ \)),
			},
		},
		'SDG' => {
			symbol => 'ߛߘߜ߭',
			display_name => {
				'currency' => q(ߛߎߘߊ߲ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬),
			},
		},
		'SDP' => {
			symbol => 'ߛߘߔ',
			display_name => {
				'currency' => q(ߛߎ߬ߘ߲ߊ߬ߞߊ ߟߊ߫ ߔߐߣߌ߬ \( ߁߉߅߆–߂߀߀߇ \)),
			},
		},
		'SHP' => {
			symbol => 'ߛߤߔ',
			display_name => {
				'currency' => q(ߛߍ߲ߕ ߤߌߟߋߣߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬),
			},
		},
		'SLE' => {
			symbol => 'ߛߙߔ',
			display_name => {
				'currency' => q(ߛߙߊ߬ߟߏ߲߬ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(ߛߙߊ߬ߟߏ߲߬ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬ - 1964-2022),
			},
		},
		'SOS' => {
			symbol => 'ߛߡߛ',
			display_name => {
				'currency' => q(ߛߏߡߊߟߌߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭),
			},
		},
		'SSP' => {
			symbol => 'ߛߛߔ',
			display_name => {
				'currency' => q(ߛߎ߬ߘߊ߲߬ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬),
			},
		},
		'STD' => {
			symbol => 'ߛߕߘ',
			display_name => {
				'currency' => q(ߛߊߏߕߏߡߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߓߙߊߛ \( ߁߉߇߇– ߂߀߁߇ \)),
			},
		},
		'STN' => {
			symbol => 'ߛߔߘ',
			display_name => {
				'currency' => q(ߛߊߏߕߏߡߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߓߙߊߛ),
			},
		},
		'SZL' => {
			symbol => 'ߛߖ߭ߟ',
			display_name => {
				'currency' => q(ߛߑߥߊߕߣߞߊ ߟߎ߬ ߟߌߟߊ߲ߖ߭ߋߣߌߛ),
			},
		},
		'TND' => {
			symbol => 'ߕߣߘ',
			display_name => {
				'currency' => q(ߕߎߣߛߌߞߊ ߟߎ߬ ߟߊ߫ ߘߌ߬ߣߊ߯ߙ),
			},
		},
		'TZS' => {
			symbol => 'ߕߖ߭ߛ',
			display_name => {
				'currency' => q(ߕߊ߲ߖ߭ߊ߯ߣߌߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭),
			},
		},
		'UGS' => {
			symbol => 'ߎߜ߭ߥ',
			display_name => {
				'currency' => q(ߎߜ߭ߊ߲ߘߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭ \( ߁߉߆߆–߁߉߈߇ \)),
			},
		},
		'UGX' => {
			symbol => 'ߎߜ߭ߛ',
			display_name => {
				'currency' => q(ߎߜ߭ߊ߲ߘߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭),
			},
		},
		'XAF' => {
			symbol => 'ߝߛߝ',
			display_name => {
				'currency' => q(ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߊ߲ߓߊ߲ ߠߎ߬ ߝߊߙߊ߲߫ ߛߍߝߊ),
			},
		},
		'XOF' => {
			symbol => '߾',
			display_name => {
				'currency' => q(ߝߊߙߊ߲߫ ߛߍߝߊ),
			},
		},
		'ZAR' => {
			symbol => 'ߥߝߙ',
			display_name => {
				'currency' => q(ߥߙߏ߬ߘߎ߮ ߝߘߊ߬ߝߌ߲߬ߠߞߊ ߟߎ߬ ߟߊ߫ ߙߊ߲ߘ),
			},
		},
		'ZMK' => {
			symbol => 'ߖ߭ߓߞ',
			display_name => {
				'currency' => q(ߖ߭ߊ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߛߊ \( ߁߉߆߈–߂߀߁߂ \)),
			},
		},
		'ZMW' => {
			symbol => 'ߖ߭ߓߥ',
			display_name => {
				'currency' => q(ߖ߭ߊ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߛߊ),
			},
		},
		'ZRN' => {
			symbol => 'ߖ߭ߙ',
			display_name => {
				'currency' => q(ߖ߭ߊ߬ߦߌ߬ߞߊ ߟߎ߬ ߟߊ߫ ߖ߭ߊ߬ߦߌߙ \( ߁߉߉߃–߁߉߉߈ \)),
			},
		},
		'ZRZ' => {
			symbol => 'ߖ߭ߙߖ߭',
			display_name => {
				'currency' => q(ߖ߭ߊߦߙߌߞߊ ߟߎ߫ ߟߊ߫ ߖ߭ߊ߬ߦߌߙ \( ߁߉߇߁–߁߉߉߃ \)),
			},
		},
		'ZWD' => {
			symbol => 'ߖ߭ߥߘ',
			display_name => {
				'currency' => q(ߖߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ \(߁߉߈߀–߂߀߀߈ \)),
			},
		},
		'ZWL' => {
			symbol => 'ߖ߭ߥߟ',
			display_name => {
				'currency' => q(ߖ߭ߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ \( ߂߀߀߉ \)),
			},
		},
		'ZWR' => {
			symbol => 'ߖ߭ߥߙ',
			display_name => {
				'currency' => q(ߖ߭ߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ \( ߂߀߀߈ \)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ߓߌ߲ߠ',
							'ߞߏ߲ߞ',
							'ߕߙߊ',
							'ߞߏ߲ߘ',
							'ߘߓߊ߬ߕ',
							'ߥߊ߬ߛ',
							'ߞߊ߬ߙ',
							'ߘߓߊ߬ߓ',
							'ߕߎߟߊߝߌ߲',
							'ߞߏ߲ߓ',
							'ߣߍߣ',
							'ߞߏߟ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ߓߌ߲ߠߊߥߎߟߋ߲',
							'ߞߏ߲ߞߏߜߍ',
							'ߕߙߊߓߊ',
							'ߞߏ߲ߞߏߘߌ߬ߓߌ',
							'ߘߓߊ߬ߕߊ',
							'ߥߊ߬ߛߌ߬ߥߙߊ',
							'ߞߊ߬ߙߌߝߐ߭',
							'ߘߓߊ߬ߓߌߟߊ',
							'ߕߎߟߊߝߌ߲',
							'ߞߏ߲ߓߌߕߌ߮',
							'ߣߍߣߍߓߊ',
							'ߞߏߟߌ߲ߞߏߟߌ߲'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ߓ',
							'ߞ',
							'ߕ',
							'ߞ',
							'ߘ',
							'ߥ',
							'ߞ',
							'ߘ',
							'ߕ',
							'ߞ',
							'ߣ',
							'ߞ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ߞߐ߬ߓ',
						tue => 'ߞߐ߬ߟߏ߲',
						wed => 'ߞߎߣ',
						thu => 'ߓߌߟ',
						fri => 'ߛߌ߬ߣ',
						sat => 'ߞߍ߲ߘ',
						sun => 'ߞߊ߯ߙ'
					},
					short => {
						mon => 'ߞߐ߬',
						tue => 'ߞߐ߬ߟߏ߲',
						wed => 'ߞߎ',
						thu => 'ߓߌ',
						fri => 'ߛߌ߬',
						sat => 'ߞߍ߲',
						sun => 'ߞߊ߯'
					},
					wide => {
						mon => 'ߞߐ߬ߓߊ߬ߟߏ߲',
						tue => 'ߞߐ߬ߟߏ߲',
						wed => 'ߞߎߣߎ߲ߟߏ߲',
						thu => 'ߓߌߟߏ߲',
						fri => 'ߛߌ߬ߣߌ߲߬ߟߏ߲',
						sat => 'ߞߍ߲ߘߍߟߏ߲',
						sun => 'ߞߊ߯ߙߌߟߏ߲'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ߞߐ߬ߓ',
						tue => 'ߞߐ߬ߟ',
						wed => 'ߞߎߣ',
						thu => 'ߓߌߟ',
						fri => 'ߛߌ߬ߣ',
						sat => 'ߞߍ߲ߘ',
						sun => 'ߞߊ߯ߙ'
					},
					narrow => {
						mon => 'ߞ',
						tue => 'ߞ',
						wed => 'ߞ',
						thu => 'ߓ',
						fri => 'ߛ',
						sat => 'ߞ',
						sun => 'ߞ'
					},
					short => {
						mon => 'ߞߐ߬ߓ',
						tue => 'ߞߐ߬ߟ',
						wed => 'ߞߎ',
						thu => 'ߓߌ',
						fri => 'ߛߌ߬',
						sat => 'ߞߍ߲',
						sun => 'ߞߊ߯'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ߞߛ߁',
						1 => 'ߞߛ߂',
						2 => 'ߞߛ߃',
						3 => 'ߞߛ߄'
					},
					wide => {0 => 'ߞߊߙߏߛߓߊ߫ ߁߭',
						1 => 'ߞߊߙߏߛߓߊ߫ ߂߲',
						2 => 'ߞߊߙߏߛߓߊ߫ ߃߲',
						3 => 'ߞߊߙߏߛߓߊ߫ ߄߲'
					},
				},
				'stand-alone' => {
					narrow => {0 => '߁',
						1 => '߂',
						2 => '߃',
						3 => '߄'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{ߛ},
					'pm' => q{ߥ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			abbreviated => {
				'0' => 'ߌߛ. ߡ. ߢߍ߫',
				'1' => 'ߌߛ. ߡ. ߞߐ߫'
			},
			narrow => {
				'0' => 'ߌߛ. ߢߍ߫',
				'1' => 'ߌߛ. ߞߐ߫'
			},
			wide => {
				'0' => 'ߌߛߊ߫ ߡߏߦߌ ߢߍ߫',
				'1' => 'ߌߛߊ߫ ߡߏߦߌ ߞߐ߫'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			yMMMd => q{y / dd MMM},
			yMd => q{y / dd / MM},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtFormat => q(ߜ߭ߕߖ{0}),
		gmtZeroFormat => q(ߜ߭ߕߖ),
		regionFormat => q({0} ߕߎ߬ߡߊ),
		regionFormat => q({0} ߕߎ߬ߡߊ߬-ߦߟߍߡߊ߲),
		regionFormat => q({0} ߕߎ߬ߡߊ߬-ߦߟߍߡߊ߲ߓߊߟߌ),
		'Africa/Abidjan' => {
			exemplarCity => q#ߊߓߌߖߊ߲߬#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ߊߞߙߊ߫#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ߊ߬ߘߌ߫ ߛߊ߬ߓߋߓߊ߫#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ߊߟߑߖ߭ߋ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ߊߛߑߡߙߊ߫#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ߓߡߊ߬ߞߐ߫#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ߓߊ߲ߜ߭ߌ߫#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ߓߊ߲ߖߎߟ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ߓߌߛߊߥߏ߫#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ߓߑߟߊ߲ߕߌ߯ߙ#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ߓߙߖ߭ߊߝ߭ߌߟ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ߓߎߖ߭ߎ߲ߓߎߙߊ߫#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ߞߍ߯ߙ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ߞߛߊߓߎߟߊ߲ߞߊ߫#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ߞߐߣߊߞߙߌ߫#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ߘߊ߬ߞߊ߯ߙߎ߫#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ߘߊ߯ߙ-ߛߊ߬ߟߊ߯ߡ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ߖߌߓߎߕߌ߫#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ߘߎߥߟߊ߫#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ߟߊ߯ߦߎߣ#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ߝߙߌߕߐ߲߬#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ߜ߭ߊߓߏߙߐߣ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ߤߙߊߙߋ߫#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ߖ߭ߎߥߊߣߍߛߑߓߎ߯ߙ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ߖߎߓߊ߫#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ߞߊ߲ߔߟߊ߫#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ߞߊߙߑߕߎߡ#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ߞߌߜ߭ߊߟߌ߫#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ߞߌ߲ߛߊߛߊ߫#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ߟߋߜ߭ߐߛ#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ߟߌߓߙߋߝ߭ߌߟ#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ߟߏߡߋ߫#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ߟߎߥߊ߲ߘߊ߫#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ߟߎߓߎ߲ߓߊߛߌ߫#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ߟߎߛߞߊ߫#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ߡߟߊߓߏ߫#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ߡߊߔߎߕߏ߫#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ߡߊߛߋߙߎ߫#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ߒߓߊߓߊߣ#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#ߡߏߜ߭ߊߘߌߛߏ߫#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#ߡߏ߬ߙߏߝ߭ߌߦߊ߫#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ߣߊߦߙߏߓߌ߫#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ߒߖߊߡߋߣߊ߫#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ߢߊߡߋ߫#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ߣߎߥߊߞߑߛߐߕ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ߥߜ߭ߊ߬ߘߜ߭ߎ߫#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ߔߐߙߑߕߏ߫-ߣߝ߭ߏ߫#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ߛߊߏ-ߕߏߡߋ߫#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ߕߙߌߔߟߌ߫ ( ߟߓߌ߫ )#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ߕߎߣߌߛ#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ߥߌ߲ߘߐߞ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߊ߲ߓߊ߲ ߕߎ߬ߡߊ߬ߙߋ߲ ߢߊߓߘߍ#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#ߝߘߊ߬ߌ߲߬ߠߊ߫ ߓߟߋ߬ߓߐ ߕߎ߬ߡߊ߬ߙߋ߲ ߢߊߓߘߍ#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#ߝߘߌ߬ߝߌ߲߬ߠߊ߫ ߥߙߏ߬ߘߎ߮ ߕߎ߬ߡߊ߬ߙߋ߲ ߢߊߓߘߍ#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߟߋ߬ߓߋ ߕߟߋ߬ߡߊ߬ ߕߎߡߊߙߋ߲#,
				'generic' => q#ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߟߋ߬ߓߋ ߕߎ߬ߡߊ߬ߙߋ߲#,
				'standard' => q#ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߟߋ߬ߓߋ ߕߎ߬ߡߊ߬ߙߋ߲ ߢߊߓߘߍ#,
			},
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ߜߦߋߞߎ߲߫-ߝߙߌߛߌ߫#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ߛߍ߲ߕ ߤߋߟߍߣ#,
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#ߜߙߋߞߎ߲߫-ߝߙߌߛߌ߫ ߕߟߋ߬ߡߊ߬ ߕߎߡߊߙߋ߲#,
				'generic' => q#ߜߙߋߞߎ߲߫-ߝߙߌߛߌ߫ ߕߎ߬ߡߊ߬ߙߋ߲#,
				'standard' => q#ߜߙߋߞߎ߲߫-ߝߙߌߛߌ߫ ߕߎ߬ߡߊ߬ߙߋ߲ ߢߊߓߘߍ#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ߐߛߑߕߙߊߟߌ߫ ߘߎ߰ߞߟߏ ߣߌ߫ ߝߊ߬ߙߊ߲߬ߛߌ߫ ߊ߲ߕߊߙߑߕߌߞ ߕߎ߬ߡߊ߬ߙߋ#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ߜ߭ߙߋߣߍߕ ߕߎ߬ߡߊ߬ߘߊ#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ߊ߲ߕߣߊߣߊߙߌߝ߭ߏ߫#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ߛߊߜ߭ߐߛ#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ߞߐߡߐ߯ߙ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ߞߍߙߑߜ߭ߋߟߍ߲߫#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ߡߊߤߋ߫#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ߡߏߙߌߛ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#ߡߊߦߐߕ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ߙߋߣߌߦߐ߲߫#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ߍ߲ߘߎ߫ ߟߌ߲ߓߊ߲ߘߎ߯ ߕߎ߬ߡߊ߬ߙߋ߲#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#ߡߏߙߌߛ ߕߟߋ߬ߡߊ߬ ߕߎߡߊߙߋ߲#,
				'generic' => q#ߡߏߙߌߛ ߕߎ߬ߡߊ߬ߙߋ߲#,
				'standard' => q#ߡߏߙߌߛ ߕߎ߬ߡߊ߬ߙߋ߲ ߢߊߓߘߍ#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ߙߋߣߌߦߐ߲߫ ߕߎ߬ߡߊ߬ߙߋ߲#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#ߛߋߦߌߛߌߟ ߕߎ߬ߡߊ߬ߙߋ߲#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
