/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tika.server.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStatus {
    private static final Logger LOG = LoggerFactory.getLogger(ServerStatus.class);
    private AtomicLong counter = new AtomicLong(0L);
    private Map<Long, TaskStatus> tasks = new HashMap<Long, TaskStatus>();
    private STATUS status = STATUS.OPERATING;

    public synchronized long start(TASK task, String fileName) {
        long taskId = this.counter.incrementAndGet();
        this.tasks.put(taskId, new TaskStatus(task, Instant.now(), fileName));
        return taskId;
    }

    public synchronized void complete(long taskId) throws IllegalArgumentException {
        TaskStatus status = this.tasks.remove(taskId);
        if (status == null) {
            throw new IllegalArgumentException("TaskId is not in map:" + taskId);
        }
    }

    public synchronized void setStatus(STATUS status) {
        this.status = status;
    }

    public synchronized STATUS getStatus() {
        return this.status;
    }

    public synchronized Map<Long, TaskStatus> getTasks() {
        HashMap<Long, TaskStatus> ret = new HashMap<Long, TaskStatus>();
        ret.putAll(this.tasks);
        return ret;
    }

    public synchronized long getFilesProcessed() {
        return this.counter.get();
    }

    public synchronized boolean isOperating() {
        return this.status == STATUS.OPERATING;
    }

    public static enum TASK {
        PARSE,
        DETECT,
        TRANSLATE;

    }

    public static enum STATUS {
        OPERATING(0),
        HIT_MAX(1),
        TIMEOUT(2),
        ERROR(3),
        PARENT_REQUESTED_SHUTDOWN(4),
        PARENT_EXCEPTION(5);

        private final int shutdownCode;

        static STATUS lookup(int i) {
            STATUS[] values = STATUS.values();
            if (i < 0 || i >= values.length) {
                throw new ArrayIndexOutOfBoundsException(i + " is not acceptable for an array of length " + values.length);
            }
            return STATUS.values()[i];
        }

        private STATUS(int shutdownCode) {
            this.shutdownCode = shutdownCode;
        }

        int getShutdownCode() {
            return this.shutdownCode;
        }

        byte getByte() {
            return (byte)this.shutdownCode;
        }
    }

    static enum DIRECTIVES {
        PING(0),
        PING_ACTIVE_SERVER_TASKS(1),
        SHUTDOWN(2);

        private final byte b;

        private DIRECTIVES(byte b) {
            this.b = b;
        }

        byte getByte() {
            return this.b;
        }
    }
}

