package Perl::Staff;

use warnings;
use strict;

=encoding utf8

=head1 NAME

Perl::Staff - People working for Perl

=head1 VERSION

Version 0.03

=cut

our $VERSION = '0.03';

=head1 SYNOPSIS

Actually this is just a list of people working as "Perl::Staff" on events
showing Perl to the outside world.

The Perl community is quite active but some kind of closed as few new people
join. "Outside world" are all people either using or not using Perl, but
not using the powerful Perl community resources like CPAN, Perlmonks and
others.

We created t-shirts with "Perl::Staff" printed on them first for CeBit 2010
in Germany and this is how Perl::Staff was born.

=head1 EXPORT

Anybody here may be exportable to other events, just talk to them if you
need help planning an event or need Perl::Staff for helping on the event.

=head1 IMPORT

If you want to become Perl::Staff and get listed here, just pick an event
where you'd like to give a Perl talk or export Perl to non-community
people in any way. Join the events mailing list for more information on events
and how you could help, come to the event and we'll try to get you a
Perl::Staff t-shirt and add you to the list.

When you're thinking about running a booth or helping there on an event and got
any questions, feel free to contact any of the Perl::Staff (contact information
are usually shown on the blog pages).

=head1 EVENTS 2010

=head2 FOSDEM

Event planning page: L<http://www.perlfoundation.org/perl5/index.cgi?events_2010_fosdem>

=head3 Gábor Szabó

(main coordinator)

Event report: 

=over 4

=item * FOSDEM report

L<http://szabgab.com/blog/2010/02/1266052953.html>

=back

=head3 Claudio Ramirez

Event report: 

=over 4

=item * Fosdem 2010 impressions

L<http://nxadm.wordpress.com/2010/02/19/fosdem-2010-impressions/>

=back

=head3 Dirk DeNijs

=head3 Dave Cross

=head3 Erik Colson

=head3 Salve J. Nilsen

L<http://www.nuug-foundation.no/no/FOSDEM-2010/> in Norwegian

=head2 CeBit

Event planning page: L<http://www.perlfoundation.org/perl5/index.cgi?events_2010_cebit>

=head3 Gábor Szabó

(main coordinator)

Event reports:

=over 4

=item * Two days into CeBIT

L<http://szabgab.com/blog/2010/03/1267676778.html>

=item * Perl on CeBIT

L<http://szabgab.com/blog/2010/03/1267974609.html>

=item * Another report about CeBIT, Perl and the community

L<http://szabgab.com/blog/2010/03/1268387636.html>

=back

=head3 Renee Bäcker

(main coordinator)

Did a talk on Perl on CeBit:

=over 4

=item * Slides

L<http://renee-baecker.de/talks/CeBIT2010.pdf>

=item * Skript 

L<http://renee-baecker.de/talks/CeBIT2010_Skript.pdf>

=back

Event reports:

=over 4

=item * Perl@CeBIT - Tag 0

L<http://reneeb-perlblog.blogspot.com/2010/03/perlcebit-tag-0.html>

=item * Perl@CeBIT - Tag 1

L<http://reneeb-perlblog.blogspot.com/2010/03/perlcebit-tag-1.html>

=item * Perl@CeBIT - Tag 2

L<http://reneeb-perlblog.blogspot.com/2010/03/perlcebit-tag-2.html>

=item * Perl@CeBIT - Tag 3

L<http://reneeb-perlblog.blogspot.com/2010/03/perlcebit-tag-3.html>

=item * Perl@CeBIT - Tag 4

L<http://reneeb-perlblog.blogspot.com/2010/03/perlcebit-tag-4.html>

=item * Perl@CeBIT - Tag 5

L<http://reneeb-perlblog.blogspot.com/2010/03/perlcebit-tag-5.html>

=back

=head3 Robert 'phaylon' Sedlacek

Event report: 

=over 4

=item * Perl in Germany - My CeBIT Recap

L<http://blogs.perl.org/user/robert_phaylon_sedlacek/2010/03/perl-in-germany-my-cebit-recap.html>

=back

=head3 Sebastian Willing

Event report:

=over 4

=item * CeBit 2010 is over

L<http://padre-ide.de/blog/?p=111>

=back

=head3 Torsten Raudssus

use Moose;

=head3 Thomas Fahle

Event report: 

=over 4

=item * Perl@CeBIT2010

L<http://thomas-fahle.blogspot.com/2010/03/perlcebit2010.html>

=back

=head3 Bernhard Schmalhofer

=head3 Oliver Krüger

=head3 Michael Daum

=item * Foswiki on CeBit 2010

L<http://blog.foswiki.org/2010/03/foswiki-on-cebit-2010/>

=back

=cut

=head1 AUTHOR

Perl event staff

=head1 SUPPORT

Look at the Perl foundation events list at http://www.perlfoundation.org/perl5/index.cgi?events

=head1 COPYRIGHT & LICENSE

Copyright 2010 Perl event staff, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1; # End of Perl::Staff
