/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class COSStandardOutputStream
extends FilterOutputStream {
    public static final byte[] CRLF = "\r\n".getBytes();
    public static final byte[] LF = "\n".getBytes();
    public static final byte[] EOL = System.getProperty("line.separator").getBytes();
    private long pos = 0L;
    private boolean onNewLine = false;

    public COSStandardOutputStream(OutputStream out) {
        super(out);
    }

    public long getPos() {
        return this.pos;
    }

    public boolean isOnNewLine() {
        return this.onNewLine;
    }

    public void setOnNewLine(boolean newOnNewLine) {
        this.onNewLine = newOnNewLine;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.setOnNewLine(false);
        this.out.write(b, off, len);
        this.pos += (long)len;
    }

    public void write(int b) throws IOException {
        this.setOnNewLine(false);
        this.out.write(b);
        ++this.pos;
    }

    public void writeCRLF() throws IOException {
        this.write(CRLF);
    }

    public void writeEOL() throws IOException {
        if (!this.isOnNewLine()) {
            this.write(EOL);
            this.setOnNewLine(true);
        }
    }

    public void writeLF() throws IOException {
        this.write(LF);
    }
}

