/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.graph;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;

public class AdjacencyEdge<T extends GenericSegment> {
    protected T nodeFrom;
    protected T nodeTo;
    public static final int REL_LEFT = 0;
    public static final int REL_RIGHT = 1;
    public static final int REL_ABOVE = 2;
    public static final int REL_BELOW = 3;
    protected float weight;
    protected boolean ruled;
    protected int direction;

    public AdjacencyEdge(T nodeFrom, T nodeTo, int direction) {
        this.nodeFrom = nodeFrom;
        this.nodeTo = nodeTo;
        this.direction = direction;
        this.ruled = false;
    }

    public AdjacencyEdge(T nodeFrom, T nodeTo, int direction, float weight) {
        this.nodeFrom = nodeFrom;
        this.nodeTo = nodeTo;
        this.direction = direction;
        this.weight = weight;
        this.ruled = false;
    }

    public T getNodeFrom() {
        return this.nodeFrom;
    }

    public void setNodeFrom(T nodeFrom) {
        this.nodeFrom = nodeFrom;
    }

    public T getNodeTo() {
        return this.nodeTo;
    }

    public void setNodeTo(T nodeTo) {
        this.nodeTo = nodeTo;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public float lowCoord() {
        switch (this.direction) {
            case 0: {
                return ((GenericSegment)this.nodeTo).getX2();
            }
            case 1: {
                return ((GenericSegment)this.nodeFrom).getX2();
            }
            case 2: {
                return ((GenericSegment)this.nodeFrom).getY2();
            }
            case 3: {
                return ((GenericSegment)this.nodeTo).getY2();
            }
        }
        return -1.0f;
    }

    public float hiCoord() {
        switch (this.direction) {
            case 0: {
                return ((GenericSegment)this.nodeFrom).getX1();
            }
            case 1: {
                return ((GenericSegment)this.nodeTo).getX1();
            }
            case 2: {
                return ((GenericSegment)this.nodeTo).getY1();
            }
            case 3: {
                return ((GenericSegment)this.nodeFrom).getY1();
            }
        }
        return -1.0f;
    }

    public float midCoord() {
        return (this.lowCoord() + this.hiCoord()) / 2.0f;
    }

    public boolean isHorizontal() {
        return this.direction == 0 || this.direction == 1;
    }

    public boolean isVertical() {
        return this.direction == 2 || this.direction == 3;
    }

    public float physicalLength() {
        switch (this.direction) {
            case 0: {
                return ((GenericSegment)this.nodeFrom).getX1() - ((GenericSegment)this.nodeTo).getX2();
            }
            case 1: {
                return ((GenericSegment)this.nodeTo).getX1() - ((GenericSegment)this.nodeFrom).getX2();
            }
            case 2: {
                return ((GenericSegment)this.nodeTo).getY1() - ((GenericSegment)this.nodeFrom).getY2();
            }
            case 3: {
                return ((GenericSegment)this.nodeFrom).getY1() - ((GenericSegment)this.nodeTo).getY2();
            }
        }
        return -1.0f;
    }

    public GenericSegment toEnlargedBoundingSegment() {
        float newY2;
        float newY1;
        float newX2;
        float newX1;
        float tolerance = 0.0f;
        if (this.nodeFrom instanceof TextSegment && this.nodeTo instanceof TextSegment) {
            float afs = Utils.avg(((TextSegment)this.nodeFrom).getFontSize(), ((TextSegment)this.nodeTo).getFontSize());
            tolerance = afs * 0.25f;
        }
        switch (this.direction) {
            case 0: {
                newX1 = ((GenericSegment)this.nodeTo).getX2();
                newX2 = ((GenericSegment)this.nodeFrom).getX1();
                newY1 = Utils.minimum(((GenericSegment)this.nodeFrom).getY1(), ((GenericSegment)this.nodeTo).getY1());
                newY2 = Utils.maximum(((GenericSegment)this.nodeFrom).getY2(), ((GenericSegment)this.nodeTo).getY2());
                break;
            }
            case 1: {
                newX2 = ((GenericSegment)this.nodeTo).getX1();
                newX1 = ((GenericSegment)this.nodeFrom).getX2();
                newY1 = Utils.minimum(((GenericSegment)this.nodeFrom).getY1(), ((GenericSegment)this.nodeTo).getY1());
                newY2 = Utils.maximum(((GenericSegment)this.nodeFrom).getY2(), ((GenericSegment)this.nodeTo).getY2());
                break;
            }
            case 2: {
                newY1 = ((GenericSegment)this.nodeFrom).getY2() - tolerance;
                newY2 = ((GenericSegment)this.nodeTo).getY1() + tolerance;
                newX1 = Utils.minimum(((GenericSegment)this.nodeFrom).getX1(), ((GenericSegment)this.nodeTo).getX1());
                newX2 = Utils.maximum(((GenericSegment)this.nodeFrom).getX2(), ((GenericSegment)this.nodeTo).getX2());
                break;
            }
            case 3: {
                newY2 = ((GenericSegment)this.nodeFrom).getY1() + tolerance;
                newY1 = ((GenericSegment)this.nodeTo).getY2() - tolerance;
                newX1 = Utils.minimum(((GenericSegment)this.nodeFrom).getX1(), ((GenericSegment)this.nodeTo).getX1());
                newX2 = Utils.maximum(((GenericSegment)this.nodeFrom).getX2(), ((GenericSegment)this.nodeTo).getX2());
                break;
            }
            default: {
                newX1 = -1.0f;
                newX2 = -1.0f;
                newY1 = -1.0f;
                newY2 = -1.0f;
            }
        }
        return new GenericSegment(newX1, newX2, newY1, newY2);
    }

    public GenericSegment toBoundingSegment() {
        float newY2;
        float newY1;
        float newX2;
        float newX1;
        switch (this.direction) {
            case 0: {
                newX1 = ((GenericSegment)this.nodeTo).getX2();
                newX2 = ((GenericSegment)this.nodeFrom).getX1();
                newY1 = Utils.minimum(((GenericSegment)this.nodeFrom).getY1(), ((GenericSegment)this.nodeTo).getY1());
                newY2 = Utils.maximum(((GenericSegment)this.nodeFrom).getY2(), ((GenericSegment)this.nodeTo).getY2());
                break;
            }
            case 1: {
                newX2 = ((GenericSegment)this.nodeTo).getX1();
                newX1 = ((GenericSegment)this.nodeFrom).getX2();
                newY1 = Utils.minimum(((GenericSegment)this.nodeFrom).getY1(), ((GenericSegment)this.nodeTo).getY1());
                newY2 = Utils.maximum(((GenericSegment)this.nodeFrom).getY2(), ((GenericSegment)this.nodeTo).getY2());
                break;
            }
            case 2: {
                newY1 = ((GenericSegment)this.nodeFrom).getY2();
                newY2 = ((GenericSegment)this.nodeTo).getY1();
                newX1 = Utils.minimum(((GenericSegment)this.nodeFrom).getX1(), ((GenericSegment)this.nodeTo).getX1());
                newX2 = Utils.maximum(((GenericSegment)this.nodeFrom).getX2(), ((GenericSegment)this.nodeTo).getX2());
                break;
            }
            case 3: {
                newY2 = ((GenericSegment)this.nodeFrom).getY1();
                newY1 = ((GenericSegment)this.nodeTo).getY2();
                newX1 = Utils.minimum(((GenericSegment)this.nodeFrom).getX1(), ((GenericSegment)this.nodeTo).getX1());
                newX2 = Utils.maximum(((GenericSegment)this.nodeFrom).getX2(), ((GenericSegment)this.nodeTo).getX2());
                break;
            }
            default: {
                newX1 = -1.0f;
                newX2 = -1.0f;
                newY1 = -1.0f;
                newY2 = -1.0f;
            }
        }
        return new GenericSegment(newX1, newX2, newY1, newY2);
    }

    public float getFontSize() {
        if (!(this.nodeFrom instanceof TextSegment) || !(this.nodeTo instanceof TextSegment)) {
            return -1.0f;
        }
        TextSegment nFrom = (TextSegment)this.nodeFrom;
        TextSegment nTo = (TextSegment)this.nodeTo;
        return (nFrom.getFontSize() + nTo.getFontSize()) / 2.0f;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public String toString() {
        String direction_text = "?";
        if (this.direction == 2) {
            direction_text = "above";
        }
        if (this.direction == 3) {
            direction_text = "below";
        }
        if (this.direction == 0) {
            direction_text = "left";
        }
        if (this.direction == 1) {
            direction_text = "right";
        }
        return "AdjacencyEdge:  Direction: " + direction_text + "\n NodeFrom: " + this.nodeFrom + "\nNodeTo: " + this.nodeTo + "direction: " + this.direction + "\n";
    }

    public boolean isRuled() {
        return this.ruled;
    }

    public void setRuled(boolean ruled) {
        this.ruled = ruled;
    }
}

