#!/usr/bin/perl

package eBay::API::XML::Call::GetSearchResultsExpress::GetSearchResultsExpressResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSearchResultsExpressResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSearchResultsExpress::GetSearchResultsExpressResponseType

=head1 DESCRIPTION

The GetSearchResultsExpress response contains the listings that match the query or
ID specified in the request, related eBay catalog product information, and a
histogram showing the the quantity (count) of matching items in Express
departments, aisles, and product types. The results may be limited by filters that
were specified in the request.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSearchResultsExpress::GetSearchResultsExpressResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::DomainHistogramType;
use eBay::API::XML::DataType::ItemArrayType;
use eBay::API::XML::DataType::ProductArrayType;


my @gaProperties = ( [ 'EntriesPerPage', 'xs:int', '', '', '' ]
	, [ 'HasMoreEntries', 'xs:boolean', '', '', '' ]
	, [ 'Histogram', 'ns:DomainHistogramType', ''
	     ,'eBay::API::XML::DataType::DomainHistogramType', '1' ]
	, [ 'ItemArray', 'ns:ItemArrayType', ''
	     ,'eBay::API::XML::DataType::ItemArrayType', '1' ]
	, [ 'PageNumber', 'xs:int', '', '', '' ]
	, [ 'ProductArray', 'ns:ProductArrayType', ''
	     ,'eBay::API::XML::DataType::ProductArrayType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setEntriesPerPage()

Indicates the number of item and product results per page that you
originally requested (not the number of items or products
that were returned).
To determine how many items or products were actually returned,
count the number of Item nodes in ItemArray (if any) and the
number of Product nodes in ProductArray (if any).

Max: 200
Min: 1

#    Argument: 'xs:int'

=cut

sub setEntriesPerPage {
  my $self = shift;
  $self->{'EntriesPerPage'} = shift
}

=head2 getEntriesPerPage()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getEntriesPerPage {
  my $self = shift;
  return $self->{'EntriesPerPage'};
}


=head2 setHasMoreEntries()

If true, there are additional item and/or product results (on higher-
numbered pages) that match the query. To retrieve them, call
GetSearchResultsExpress again and increment the page number or specify a
higher value for EntriesPerPage in the request.

#    Argument: 'xs:boolean'

=cut

sub setHasMoreEntries {
  my $self = shift;
  $self->{'HasMoreEntries'} = shift
}

=head2 isHasMoreEntries()

  Returned: Always
#    Returns: 'xs:boolean'

=cut

sub isHasMoreEntries {
  my $self = shift;
  return $self->{'HasMoreEntries'};
}


=head2 setHistogram()

Indicates the quantity of items and catalog products that fall into
departments, aisles, and/or product types that match the criteria in the
request. The sort order is controlled by the value of HistogramSort in the
request. Only returned when matching data is found and HistogramDetails is
Coarse (the default) or Fine.<br>
<br>
When HistogramDetails==Coarse and no DepartmentName, AisleName, or
ProductTypeName is specified in the request, Express only returns
histogram details for departments. In this particular case, Express
returns no histogram details when no departments match the request.
This could occur when Express only finds matching results in
stand-alone product types or stand-alone aisles (because they aren't
grouped into departments).

#    Argument: 'ns:DomainHistogramType'

=cut

sub setHistogram {
  my $self = shift;
  $self->{'Histogram'} = shift
}

=head2 getHistogram()

  Returned: Conditionally
#    Returns: 'ns:DomainHistogramType'

=cut

sub getHistogram {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Histogram'
		,'eBay::API::XML::DataType::DomainHistogramType');
}


=head2 setItemArray()

Contains a list of items on Express that match all the criteria specified in
the request. The sort order is controlled by the value of ItemSort in the
request. Only returned when matching data is found and ItemDetails is Coarse
(the default) or Fine.<br>
<br>
If the same seller has listed multiple items with the same title and
costs, only one of
those items is returned by default. This is treated as a consolidated
(deduped) search result item
that represents the seller's other, identical items.
If you want to retrieve all duplicates for an item, pass the seller's
user ID in the SellerID field
in the request. Use the results to identify items with duplicate
titles and costs.<br>
<br>
Items can belong to multiple departments, aisles, or product types at
any given time,
and this information is not stored or returned in the item data. To
determine which items
are currently available in a given domain, specify the
DepartmentName, AisleName, or ProductTypeName
in the request.

#    Argument: 'ns:ItemArrayType'

=cut

sub setItemArray {
  my $self = shift;
  $self->{'ItemArray'} = shift
}

=head2 getItemArray()

  Returned: Conditionally
#    Returns: 'ns:ItemArrayType'

=cut

sub getItemArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemArray'
		,'eBay::API::XML::DataType::ItemArrayType');
}


=head2 setPageNumber()

Indicates the page of data returned by the current call.

Max: Min: 1

#    Argument: 'xs:int'

=cut

sub setPageNumber {
  my $self = shift;
  $self->{'PageNumber'} = shift
}

=head2 getPageNumber()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getPageNumber {
  my $self = shift;
  return $self->{'PageNumber'};
}


=head2 setProductArray()

Contains a list of eBay catalog products have been used to pre-fill
listings that match the criteria specified in the request. The sort order
is controlled by the value of ProductSort in the request. Only returned
when matching data is found and ProductDetails is Coarse (the default) or
Fine. To determine which products are currently available in a given
domain, specify the DepartmentName, AisleName, or ProductTypeName in the
request.

#    Argument: 'ns:ProductArrayType'

=cut

sub setProductArray {
  my $self = shift;
  $self->{'ProductArray'} = shift
}

=head2 getProductArray()

  Returned: Conditionally
#    Returns: 'ns:ProductArrayType'

=cut

sub getProductArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ProductArray'
		,'eBay::API::XML::DataType::ProductArrayType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
