# Generated by default/object.tt
package Paws::CodeArtifact::ResourcePolicy;
  use Moose;
  has Document => (is => 'ro', isa => 'Str', request_name => 'document', traits => ['NameInRequest']);
  has ResourceArn => (is => 'ro', isa => 'Str', request_name => 'resourceArn', traits => ['NameInRequest']);
  has Revision => (is => 'ro', isa => 'Str', request_name => 'revision', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::ResourcePolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::ResourcePolicy object:

  $service_obj->Method(Att1 => { Document => $value, ..., Revision => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::ResourcePolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->Document

=head1 DESCRIPTION

An AWS CodeArtifact resource policy that contains a resource ARN,
document details, and a revision.

=head1 ATTRIBUTES


=head2 Document => Str

The resource policy formatted in JSON.


=head2 ResourceArn => Str

The ARN of the resource associated with the resource policy


=head2 Revision => Str

The current revision of the resource policy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

