/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.feature.system;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.maltparser.core.config.ConfigurationRegistry;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.AbstractFeatureFactory;
import org.maltparser.core.feature.FeatureException;
import org.maltparser.core.feature.function.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionDescription {
    private String name;
    private Class<?> functionClass;
    private boolean hasSubfunctions;
    private boolean hasFactory;

    public FunctionDescription(String name, Class<?> functionClass, boolean hasSubfunctions, boolean hasFactory) {
        this.setName(name);
        this.setFunctionClass(functionClass);
        this.setHasSubfunctions(hasSubfunctions);
        this.setHasFactory(hasFactory);
    }

    public Function newFunction(ConfigurationRegistry registry) throws MaltChainedException {
        if (this.hasFactory) {
            for (Class c : registry.keySet()) {
                try {
                    c.asSubclass(this.functionClass);
                }
                catch (ClassCastException e) {
                    continue;
                }
                return ((AbstractFeatureFactory)registry.get(c)).makeFunction(this.name);
            }
            return null;
        }
        Constructor<?>[] constructors = this.functionClass.getConstructors();
        if (constructors.length == 0) {
            try {
                return (Function)this.functionClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new FeatureException("The function '" + this.functionClass.getName() + "' cannot be initialized. ", e);
            }
            catch (IllegalAccessException e) {
                throw new FeatureException("The function '" + this.functionClass.getName() + "' cannot be initialized. ", e);
            }
        }
        Class<?>[] params = constructors[0].getParameterTypes();
        if (params.length == 0) {
            try {
                return (Function)this.functionClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new FeatureException("The function '" + this.functionClass.getName() + "' cannot be initialized. ", e);
            }
            catch (IllegalAccessException e) {
                throw new FeatureException("The function '" + this.functionClass.getName() + "' cannot be initialized. ", e);
            }
        }
        Object[] arguments = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (this.hasSubfunctions && params[i] == String.class) {
                arguments[i] = this.name;
                continue;
            }
            arguments[i] = registry.get(params[i]);
            if (arguments[i] != null) continue;
            return null;
        }
        try {
            return (Function)constructors[0].newInstance(arguments);
        }
        catch (InstantiationException e) {
            throw new FeatureException("The function '" + this.functionClass.getName() + "' cannot be initialized. ", e);
        }
        catch (IllegalAccessException e) {
            throw new FeatureException("The function '" + this.functionClass.getName() + "' cannot be initialized. ", e);
        }
        catch (InvocationTargetException e) {
            throw new FeatureException("The function '" + this.functionClass.getName() + "' cannot be initialized. ", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getFunctionClass() {
        return this.functionClass;
    }

    public void setFunctionClass(Class<?> functionClass) {
        this.functionClass = functionClass;
    }

    public boolean isHasSubfunctions() {
        return this.hasSubfunctions;
    }

    public void setHasSubfunctions(boolean hasSubfunctions) {
        this.hasSubfunctions = hasSubfunctions;
    }

    public boolean isHasFactory() {
        return this.hasFactory;
    }

    public void setHasFactory(boolean hasFactory) {
        this.hasFactory = hasFactory;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!this.name.equalsIgnoreCase(((FunctionDescription)obj).getName())) {
            return false;
        }
        return this.functionClass.equals(((FunctionDescription)obj).getFunctionClass());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("->");
        sb.append(this.functionClass.getName());
        return sb.toString();
    }
}

