/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.BeanParamInfo;
import org.apache.cxf.jaxrs.model.BeanResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.model.SubresourceKey;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;

public class ClassResourceInfo
extends BeanResourceInfo {
    private URITemplate uriTemplate;
    private MethodDispatcher methodDispatcher;
    private ResourceProvider resourceProvider;
    private ConcurrentHashMap<SubresourceKey, ClassResourceInfo> subResources = new ConcurrentHashMap();
    private boolean enableStatic;
    private boolean createdFromModel;
    private String consumesTypes;
    private String producesTypes;
    private Set<String> nameBindings = Collections.emptySet();
    private ClassResourceInfo parent;
    private Set<String> injectedSubInstances = new HashSet<String>();

    public ClassResourceInfo(ClassResourceInfo cri) {
        super(cri.getBus());
        if (!cri.isCreatedFromModel() || InjectionUtils.isConcreteClass(cri.getServiceClass())) {
            throw new IllegalArgumentException();
        }
        this.root = cri.root;
        this.serviceClass = cri.serviceClass;
        this.uriTemplate = cri.uriTemplate;
        this.methodDispatcher = new MethodDispatcher(cri.methodDispatcher, this);
        this.subResources = cri.subResources;
        this.paramFields = cri.paramFields;
        this.paramMethods = cri.paramMethods;
        this.enableStatic = true;
        this.nameBindings = cri.nameBindings;
        this.parent = cri.parent;
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot, boolean enableStatic, Bus bus) {
        super(theResourceClass, theServiceClass, theRoot, theRoot || enableStatic, bus);
        this.enableStatic = enableStatic;
        if (this.resourceClass != null) {
            this.nameBindings = AnnotationUtils.getNameBindings(this.serviceClass.getAnnotations());
        }
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot, boolean enableStatic, boolean createdFromModel, Bus bus) {
        this(theResourceClass, theServiceClass, theRoot, enableStatic, bus);
        this.createdFromModel = createdFromModel;
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> c, boolean theRoot, boolean enableStatic, boolean createdFromModel, String consumesTypes, String producesTypes, Bus bus) {
        this(theResourceClass, theResourceClass, theRoot, enableStatic, createdFromModel, bus);
        this.consumesTypes = consumesTypes;
        this.producesTypes = producesTypes;
    }

    public ClassResourceInfo(Class<?> theResourceClass) {
        this(theResourceClass, true);
    }

    public ClassResourceInfo(Class<?> theResourceClass, boolean theRoot) {
        this(theResourceClass, theResourceClass, theRoot);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass) {
        this(theResourceClass, theServiceClass, false);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot) {
        this(theResourceClass, theServiceClass, theRoot, false, BusFactory.getDefaultBus(true));
    }

    public ClassResourceInfo findResource(Class<?> typedClass, Class<?> instanceClass) {
        instanceClass = this.enableStatic ? typedClass : instanceClass;
        SubresourceKey key = new SubresourceKey(typedClass, instanceClass);
        return this.subResources.get(key);
    }

    @Override
    public boolean contextsAvailable() {
        return super.contextsAvailable() && (this.isRoot() || this.parent != null);
    }

    public ClassResourceInfo getSubResource(Class<?> typedClass, Class<?> instanceClass) {
        return this.getSubResource(typedClass, instanceClass, null, this.enableStatic, null);
    }

    public ClassResourceInfo getSubResource(Class<?> typedClass, Class<?> instanceClass, Object instance) {
        instanceClass = this.enableStatic ? typedClass : instanceClass;
        return this.getSubResource(typedClass, instanceClass, instance, this.enableStatic, JAXRSUtils.getCurrentMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassResourceInfo getSubResource(Class<?> typedClass, Class<?> instanceClass, Object instance, boolean resolveContexts, Message message) {
        SubresourceKey key = new SubresourceKey(typedClass, instanceClass);
        ClassResourceInfo cri = this.subResources.get(key);
        if (cri == null && (cri = ResourceUtils.createClassResourceInfo(typedClass, instanceClass, this, false, resolveContexts, this.getBus())) != null) {
            if (message != null) {
                cri.initBeanParamInfo(ServerProviderFactory.getInstance(message));
            }
            this.subResources.putIfAbsent(key, cri);
        }
        if (resolveContexts && cri != null && cri.isSingleton() && instance != null && cri.contextsAvailable()) {
            ClassResourceInfo classResourceInfo = this;
            synchronized (classResourceInfo) {
                if (!this.injectedSubInstances.contains(instance.toString())) {
                    ProviderInfo appProvider;
                    Application app = null;
                    if (message != null && (appProvider = (ProviderInfo)message.getExchange().getEndpoint().get(Application.class.getName())) != null) {
                        app = (Application)appProvider.getProvider();
                    }
                    InjectionUtils.injectContextProxiesAndApplication(cri, instance, app);
                    this.injectedSubInstances.add(instance.toString());
                }
            }
        }
        return cri;
    }

    public void addSubClassResourceInfo(ClassResourceInfo cri) {
        this.subResources.putIfAbsent(new SubresourceKey(cri.getResourceClass(), cri.getServiceClass()), cri);
    }

    public Collection<ClassResourceInfo> getSubResources() {
        return Collections.unmodifiableCollection(this.subResources.values());
    }

    public Set<String> getNameBindings() {
        if (this.parent == null) {
            return this.nameBindings;
        }
        return this.parent.getNameBindings();
    }

    public void setNameBindings(Set<String> names) {
        this.nameBindings = names;
    }

    public Set<String> getAllowedMethods() {
        HashSet<String> methods = new HashSet<String>();
        for (OperationResourceInfo o : this.methodDispatcher.getOperationResourceInfos()) {
            String method = o.getHttpMethod();
            if (method == null) continue;
            methods.add(method);
        }
        return methods;
    }

    public URITemplate getURITemplate() {
        return this.uriTemplate;
    }

    public void setURITemplate(URITemplate u) {
        this.uriTemplate = u;
    }

    public MethodDispatcher getMethodDispatcher() {
        return this.methodDispatcher;
    }

    public void setMethodDispatcher(MethodDispatcher md) {
        this.methodDispatcher = md;
    }

    public boolean hasSubResources() {
        return !this.subResources.isEmpty();
    }

    public boolean isCreatedFromModel() {
        return this.createdFromModel;
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void setResourceProvider(ResourceProvider rp) {
        this.resourceProvider = rp;
    }

    public List<MediaType> getProduceMime() {
        if (this.producesTypes != null) {
            return JAXRSUtils.parseMediaTypes(this.producesTypes);
        }
        Produces produces = AnnotationUtils.getClassAnnotation(this.getServiceClass(), Produces.class);
        if (produces != null || this.parent == null) {
            return JAXRSUtils.getProduceTypes(produces);
        }
        return this.parent.getProduceMime();
    }

    public List<MediaType> getConsumeMime() {
        if (this.consumesTypes != null) {
            return JAXRSUtils.parseMediaTypes(this.consumesTypes);
        }
        Consumes consumes = AnnotationUtils.getClassAnnotation(this.getServiceClass(), Consumes.class);
        if (consumes != null || this.parent == null) {
            return JAXRSUtils.getConsumeTypes(consumes);
        }
        return this.parent.getConsumeMime();
    }

    public Path getPath() {
        return AnnotationUtils.getClassAnnotation(this.getServiceClass(), Path.class);
    }

    @Override
    public boolean isSingleton() {
        if (this.parent == null) {
            return this.resourceProvider != null && this.resourceProvider.isSingleton();
        }
        return this.parent.isSingleton();
    }

    public void setParent(ClassResourceInfo parent) {
        this.parent = parent;
    }

    public ClassResourceInfo getParent() {
        return this.parent;
    }

    public void initBeanParamInfo(ServerProviderFactory factory) {
        if (factory != null) {
            Set<OperationResourceInfo> oris = this.getMethodDispatcher().getOperationResourceInfos();
            for (OperationResourceInfo ori : oris) {
                List<Parameter> params = ori.getParameters();
                for (Parameter param : params) {
                    if (param.getType() != ParameterType.BEAN) continue;
                    Class<?> cls = ori.getMethodToInvoke().getParameterTypes()[param.getIndex()];
                    BeanParamInfo bpi = new BeanParamInfo(cls, this.getBus());
                    factory.addBeanParamInfo(bpi);
                }
            }
            List<Method> methods = super.getParameterMethods();
            for (Method m : methods) {
                if (m.getAnnotation(BeanParam.class) == null) continue;
                BeanParamInfo bpi = new BeanParamInfo(m.getParameterTypes()[0], this.getBus());
                factory.addBeanParamInfo(bpi);
            }
            List<Field> fields = super.getParameterFields();
            for (Field f : fields) {
                if (f.getAnnotation(BeanParam.class) == null) continue;
                BeanParamInfo bpi = new BeanParamInfo(f.getType(), this.getBus());
                factory.addBeanParamInfo(bpi);
            }
        }
    }

    @Override
    public void clearThreadLocalProxies() {
        super.clearThreadLocalProxies();
        if (!this.injectedSubInstances.isEmpty()) {
            for (ClassResourceInfo sub : this.subResources.values()) {
                if (sub == this) continue;
                sub.clearThreadLocalProxies();
            }
        }
    }

    public void injectContexts(Object resourceObject, OperationResourceInfo ori, Message inMessage) {
        boolean contextsAvailable = this.contextsAvailable();
        boolean paramsAvailable = this.paramsAvailable();
        if (contextsAvailable || paramsAvailable) {
            Object realResourceObject = ClassHelper.getRealObject(resourceObject);
            if (paramsAvailable) {
                JAXRSUtils.injectParameters(ori, this, realResourceObject, inMessage);
            }
            if (contextsAvailable) {
                InjectionUtils.injectContexts(realResourceObject, this, inMessage);
            }
        }
    }
}

