/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class MetaBox
extends AbstractContainerBox {
    public static final String TYPE = "meta";
    private int version;
    private int flags;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    protected final long parseVersionAndFlags(ByteBuffer content) {
        this.version = IsoTypeReader.readUInt8(content);
        this.flags = IsoTypeReader.readUInt24(content);
        return 4L;
    }

    protected final void writeVersionAndFlags(ByteBuffer bb) {
        IsoTypeWriter.writeUInt8(bb, this.version);
        IsoTypeWriter.writeUInt24(bb, this.flags);
    }

    public MetaBox() {
        super(TYPE);
    }

    public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        dataSource.read(bb);
        this.parseVersionAndFlags((ByteBuffer)bb.rewind());
        this.initContainer(dataSource, contentSize - 4L, boxParser);
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer bb = ByteBuffer.allocate(4);
        this.writeVersionAndFlags(bb);
        writableByteChannel.write((ByteBuffer)bb.rewind());
        this.writeContainer(writableByteChannel);
    }

    public long getSize() {
        long s = this.getContainerSize();
        long t = 4L;
        return s + t + (long)(this.largeBox || s + t >= 0x100000000L ? 16 : 8);
    }
}

