# Generated by default/object.tt
package Paws::SecurityHub::AwsApiGatewayV2RouteSettings;
  use Moose;
  has DataTraceEnabled => (is => 'ro', isa => 'Bool');
  has DetailedMetricsEnabled => (is => 'ro', isa => 'Bool');
  has LoggingLevel => (is => 'ro', isa => 'Str');
  has ThrottlingBurstLimit => (is => 'ro', isa => 'Int');
  has ThrottlingRateLimit => (is => 'ro', isa => 'Num');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsApiGatewayV2RouteSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsApiGatewayV2RouteSettings object:

  $service_obj->Method(Att1 => { DataTraceEnabled => $value, ..., ThrottlingRateLimit => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsApiGatewayV2RouteSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->DataTraceEnabled

=head1 DESCRIPTION

Contains route settings for a stage.

=head1 ATTRIBUTES


=head2 DataTraceEnabled => Bool

Indicates whether data trace logging is enabled. Data trace logging
affects the log entries that are pushed to CloudWatch Logs. Supported
only for WebSocket APIs.


=head2 DetailedMetricsEnabled => Bool

Indicates whether detailed metrics are enabled.


=head2 LoggingLevel => Str

The logging level. The logging level affects the log entries that are
pushed to CloudWatch Logs. Supported only for WebSocket APIs.

If the logging level is C<ERROR>, then the logs only include
error-level entries.

If the logging level is C<INFO>, then the logs include both C<ERROR>
events and extra informational events.

Valid values: C<OFF> | C<ERROR> | C<INFO>


=head2 ThrottlingBurstLimit => Int

The throttling burst limit.


=head2 ThrottlingRateLimit => Num

The throttling rate limit.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

