# Generated by default/object.tt
package Paws::CloudFront::Distribution;
  use Moose;
  has ActiveTrustedKeyGroups => (is => 'ro', isa => 'Paws::CloudFront::ActiveTrustedKeyGroups');
  has ActiveTrustedSigners => (is => 'ro', isa => 'Paws::CloudFront::ActiveTrustedSigners');
  has AliasICPRecordals => (is => 'ro', isa => 'ArrayRef[Paws::CloudFront::AliasICPRecordal]', request_name => 'AliasICPRecordal', traits => ['NameInRequest']);
  has ARN => (is => 'ro', isa => 'Str', required => 1);
  has DistributionConfig => (is => 'ro', isa => 'Paws::CloudFront::DistributionConfig', required => 1);
  has DomainName => (is => 'ro', isa => 'Str', required => 1);
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has InProgressInvalidationBatches => (is => 'ro', isa => 'Int', required => 1);
  has LastModifiedTime => (is => 'ro', isa => 'Str', required => 1);
  has Status => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::Distribution

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::Distribution object:

  $service_obj->Method(Att1 => { ActiveTrustedKeyGroups => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::Distribution object:

  $result = $service_obj->Method(...);
  $result->Att1->ActiveTrustedKeyGroups

=head1 DESCRIPTION

A distribution tells CloudFront where you want content to be delivered
from, and the details about how to track and manage content delivery.

=head1 ATTRIBUTES


=head2 ActiveTrustedKeyGroups => L<Paws::CloudFront::ActiveTrustedKeyGroups>

CloudFront automatically adds this field to the response if
youE<rsquo>ve configured a cache behavior in this distribution to serve
private content using key groups. This field contains a list of key
groups and the public keys in each key group that CloudFront can use to
verify the signatures of signed URLs or signed cookies.


=head2 ActiveTrustedSigners => L<Paws::CloudFront::ActiveTrustedSigners>

We recommend using C<TrustedKeyGroups> instead of C<TrustedSigners>.

CloudFront automatically adds this field to the response if
youE<rsquo>ve configured a cache behavior in this distribution to serve
private content using trusted signers. This field contains a list of
AWS account IDs and the active CloudFront key pairs in each account
that CloudFront can use to verify the signatures of signed URLs or
signed cookies.


=head2 AliasICPRecordals => ArrayRef[L<Paws::CloudFront::AliasICPRecordal>]

AWS services in China customers must file for an Internet Content
Provider (ICP) recordal if they want to serve content publicly on an
alternate domain name, also known as a CNAME, that they've added to
CloudFront. AliasICPRecordal provides the ICP recordal status for
CNAMEs associated with distributions.

For more information about ICP recordals, see Signup, Accounts, and
Credentials
(https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html)
in I<Getting Started with AWS services in China>.


=head2 B<REQUIRED> ARN => Str

The ARN (Amazon Resource Name) for the distribution. For example:
C<arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5>, where
C<123456789012> is your AWS account ID.


=head2 B<REQUIRED> DistributionConfig => L<Paws::CloudFront::DistributionConfig>

The current configuration information for the distribution. Send a
C<GET> request to the C</I<CloudFront API version>/distribution
ID/config> resource.


=head2 B<REQUIRED> DomainName => Str

The domain name corresponding to the distribution, for example,
C<d111111abcdef8.cloudfront.net>.


=head2 B<REQUIRED> Id => Str

The identifier for the distribution. For example: C<EDFDVBD632BHDS5>.


=head2 B<REQUIRED> InProgressInvalidationBatches => Int

The number of invalidation batches currently in progress.


=head2 B<REQUIRED> LastModifiedTime => Str

The date and time the distribution was last modified.


=head2 B<REQUIRED> Status => Str

This response element indicates the current status of the distribution.
When the status is C<Deployed>, the distribution's information is fully
propagated to all CloudFront edge locations.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

