# Generated by default/object.tt
package Paws::SageMaker::ProjectSummary;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str', required => 1);
  has ProjectArn => (is => 'ro', isa => 'Str', required => 1);
  has ProjectDescription => (is => 'ro', isa => 'Str');
  has ProjectId => (is => 'ro', isa => 'Str', required => 1);
  has ProjectName => (is => 'ro', isa => 'Str', required => 1);
  has ProjectStatus => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ProjectSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ProjectSummary object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., ProjectStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ProjectSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

Information about a project.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CreationTime => Str

The time that the project was created.


=head2 B<REQUIRED> ProjectArn => Str

The Amazon Resource Name (ARN) of the project.


=head2 ProjectDescription => Str

The description of the project.


=head2 B<REQUIRED> ProjectId => Str

The ID of the project.


=head2 B<REQUIRED> ProjectName => Str

The name of the project.


=head2 B<REQUIRED> ProjectStatus => Str

The status of the project.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

