# Generated by default/object.tt
package Paws::LexModelsV2::BotVersionSummary;
  use Moose;
  has BotName => (is => 'ro', isa => 'Str', request_name => 'botName', traits => ['NameInRequest']);
  has BotStatus => (is => 'ro', isa => 'Str', request_name => 'botStatus', traits => ['NameInRequest']);
  has BotVersion => (is => 'ro', isa => 'Str', request_name => 'botVersion', traits => ['NameInRequest']);
  has CreationDateTime => (is => 'ro', isa => 'Str', request_name => 'creationDateTime', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::BotVersionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::BotVersionSummary object:

  $service_obj->Method(Att1 => { BotName => $value, ..., Description => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::BotVersionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->BotName

=head1 DESCRIPTION

Summary information about a bot version returned by the ListBotVersions
operation.

=head1 ATTRIBUTES


=head2 BotName => Str

The name of the bot associated with the version.


=head2 BotStatus => Str

The status of the bot. When the status is available, the version of the
bot is ready for use.


=head2 BotVersion => Str

The numeric version of the bot, or C<DRAFT> to indicate that this is
the version of the bot that can be updated..


=head2 CreationDateTime => Str

A timestamp of the date and time that the version was created.


=head2 Description => Str

The description of the version.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

