package Net::Async::Spotify::API::Player;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::API::Generated::Player);

=encoding utf8

=head1 NAME

Net::Async::Spotify::API::Player - Package representing Main Spotify Player API

=head1 DESCRIPTION

Main module for an Autogenerated one L<Net::Async::Spotify::API::Generated::Player>.
Will hold all extra functionality for Spotify Player API

=head1 METHODS

=cut

sub new {
    my $self  = (shift)->next::method(@_);
    $self->mapping->{get_information_about_the_users_current_playback}{response} = ['currentlyplayingcontext'];
    $self->mapping->{get_a_users_available_devices}{response} = ['Devices'];
    return $self;
}

1;
