# Generated by default/object.tt
package Paws::IoTEvents::SNSTopicPublishAction;
  use Moose;
  has Payload => (is => 'ro', isa => 'Paws::IoTEvents::Payload', request_name => 'payload', traits => ['NameInRequest']);
  has TargetArn => (is => 'ro', isa => 'Str', request_name => 'targetArn', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::SNSTopicPublishAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::SNSTopicPublishAction object:

  $service_obj->Method(Att1 => { Payload => $value, ..., TargetArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::SNSTopicPublishAction object:

  $result = $service_obj->Method(...);
  $result->Att1->Payload

=head1 DESCRIPTION

Information required to publish the Amazon SNS message.

=head1 ATTRIBUTES


=head2 Payload => L<Paws::IoTEvents::Payload>

You can configure the action payload when you send a message as an
Amazon SNS push notification.


=head2 B<REQUIRED> TargetArn => Str

The ARN of the Amazon SNS target where the message is sent.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

