package Acme::MetaSyntactic::octothorpe;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.001';
__PACKAGE__->init();
1;

=encoding iso-8859-1

=head1 NAME

Acme::MetaSyntactic::octothorpe - The octothorpe theme

=head1 DESCRIPTION

Names for the C<#> symbol.

See L<http://www.sigtel.com/tel_tech_octothorpe.html>
about how the name I<octothorpe> was created. See also
L<http://www.worldwidewords.org/weirdwords/ww-oct1.htm> for other stories.

If you know another name for C<#> that is not included in this list,
please send it to me, with a reference to back up your claim. Thanks.

=head1 CONTRIBUTORS

Philippe "BooK" Bruhat, inspired by David Landgren's presentation of
L<Acme::DonMartin>, Sbastien Aperghis-Tramoni.

=head1 CHANGES

=over 4

=item *

2013-02-18 - v1.001

Sbastien Aperghis-Tramoni submitted a new name (I<diamond>),
published in Acme-MetaSyntactic-Themes version 1.030.

=item *

2012-05-07 - v1.000

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2005-07-25

Introduced in Acme-MetaSyntactic version 0.32.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
comment_sign
crosshatch
crunch
diamond
fence
flash
gate
grid
gridlet
hash
hash_mark
hash_sign
hex
mesh
noughts_and_crosses
number_sign
octalthorpe
octothorn
octothorp
octothorpe
pig_pen
pound
pound_sign
scratchmark
sharp
splat
square
thud
thump
tic_tac_toe
widget_mark
