package Shipment::UPS::WSDL::ShipTypes::ShipmentChargesType;
$Shipment::UPS::WSDL::ShipTypes::ShipmentChargesType::VERSION = '3.08';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/Ship/v1.0'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %TransportationCharges_of : ATTR(:get<TransportationCharges>);
    my %ServiceOptionsCharges_of : ATTR(:get<ServiceOptionsCharges>);
    my %TotalCharges_of : ATTR(:get<TotalCharges>);

    __PACKAGE__->_factory(
        [   qw(        TransportationCharges
              ServiceOptionsCharges
              TotalCharges

            )
        ],
        {   'TransportationCharges' => \%TransportationCharges_of,
            'ServiceOptionsCharges' => \%ServiceOptionsCharges_of,
            'TotalCharges'          => \%TotalCharges_of,
        },
        {   'TransportationCharges' =>
              'Shipment::UPS::WSDL::ShipTypes::ShipChargeType',
            'ServiceOptionsCharges' =>
              'Shipment::UPS::WSDL::ShipTypes::ShipChargeType',
            'TotalCharges' => 'Shipment::UPS::WSDL::ShipTypes::ShipChargeType',
        },
        {

            'TransportationCharges' => 'TransportationCharges',
            'ServiceOptionsCharges' => 'ServiceOptionsCharges',
            'TotalCharges'          => 'TotalCharges',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::ShipTypes::ShipmentChargesType

=head1 VERSION

version 3.08

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ShipmentChargesType from the namespace http://www.ups.com/XMLSchema/XOLTWS/Ship/v1.0.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * TransportationCharges (min/maxOccurs: 1/1)

=item * ServiceOptionsCharges (min/maxOccurs: 1/1)

=item * TotalCharges (min/maxOccurs: 1/1)

=back

=head1 NAME

Shipment::UPS::WSDL::ShipTypes::ShipmentChargesType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::ShipTypes::ShipmentChargesType
   TransportationCharges =>  { # Shipment::UPS::WSDL::ShipTypes::ShipChargeType
     CurrencyCode =>  $some_value, # string
     MonetaryValue =>  $some_value, # string
   },
   ServiceOptionsCharges => {}, # Shipment::UPS::WSDL::ShipTypes::ShipChargeType
   TotalCharges => {}, # Shipment::UPS::WSDL::ShipTypes::ShipChargeType
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
