package Shipment::FedEx::WSDL::ShipTypes::ReturnEMailDetail;
{
  $Shipment::FedEx::WSDL::ShipTypes::ReturnEMailDetail::VERSION = '0.02';
}
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://fedex.com/ws/ship/v9' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %MerchantPhoneNumber_of :ATTR(:get<MerchantPhoneNumber>);
my %AllowedSpecialServices_of :ATTR(:get<AllowedSpecialServices>);

__PACKAGE__->_factory(
    [ qw(        MerchantPhoneNumber
        AllowedSpecialServices

    ) ],
    {
        'MerchantPhoneNumber' => \%MerchantPhoneNumber_of,
        'AllowedSpecialServices' => \%AllowedSpecialServices_of,
    },
    {
        'MerchantPhoneNumber' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'AllowedSpecialServices' => 'Shipment::FedEx::WSDL::ShipTypes::ReturnEMailAllowedSpecialServiceType',
    },
    {

        'MerchantPhoneNumber' => 'MerchantPhoneNumber',
        'AllowedSpecialServices' => 'AllowedSpecialServices',
    }
);

} # end BLOCK







1;




__END__
=pod

=head1 NAME

Shipment::FedEx::WSDL::ShipTypes::ReturnEMailDetail

=head1 VERSION

version 0.02

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ReturnEMailDetail from the namespace http://fedex.com/ws/ship/v9.

Return Email Details

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * MerchantPhoneNumber (min/maxOccurs: 0/1)

=item * AllowedSpecialServices (min/maxOccurs: 0/unbounded)

=back

=head1 NAME

Shipment::FedEx::WSDL::ShipTypes::ReturnEMailDetail

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::ShipTypes::ReturnEMailDetail
   MerchantPhoneNumber =>  $some_value, # string
   AllowedSpecialServices => $some_value, # ReturnEMailAllowedSpecialServiceType
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHORS

=over 4

=item *

Andrew Baerg <baergaj@cpan.org>

=item *

Al Newkirk <awncorp@cpan.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2010 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

