# Generated by default/object.tt
package Paws::GameLift::GameSessionQueue;
  use Moose;
  has CustomEventData => (is => 'ro', isa => 'Str');
  has Destinations => (is => 'ro', isa => 'ArrayRef[Paws::GameLift::GameSessionQueueDestination]');
  has FilterConfiguration => (is => 'ro', isa => 'Paws::GameLift::FilterConfiguration');
  has GameSessionQueueArn => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has NotificationTarget => (is => 'ro', isa => 'Str');
  has PlayerLatencyPolicies => (is => 'ro', isa => 'ArrayRef[Paws::GameLift::PlayerLatencyPolicy]');
  has PriorityConfiguration => (is => 'ro', isa => 'Paws::GameLift::PriorityConfiguration');
  has TimeoutInSeconds => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::GameSessionQueue

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::GameSessionQueue object:

  $service_obj->Method(Att1 => { CustomEventData => $value, ..., TimeoutInSeconds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::GameSessionQueue object:

  $result = $service_obj->Method(...);
  $result->Att1->CustomEventData

=head1 DESCRIPTION

Configuration for a game session placement mechanism that processes
requests for new game sessions. A queue can be used on its own or as
part of a matchmaking solution.

B<Related actions>

CreateGameSessionQueue | DescribeGameSessionQueues |
UpdateGameSessionQueue

=head1 ATTRIBUTES


=head2 CustomEventData => Str

Information that is added to all events that are related to this game
session queue.


=head2 Destinations => ArrayRef[L<Paws::GameLift::GameSessionQueueDestination>]

A list of fleets and/or fleet aliases that can be used to fulfill game
session placement requests in the queue. Destinations are identified by
either a fleet ARN or a fleet alias ARN, and are listed in order of
placement preference.


=head2 FilterConfiguration => L<Paws::GameLift::FilterConfiguration>

A list of locations where a queue is allowed to place new game
sessions. Locations are specified in the form of AWS Region codes, such
as C<us-west-2>. If this parameter is not set, game sessions can be
placed in any queue location.


=head2 GameSessionQueueArn => Str

The Amazon Resource Name (ARN
(https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
that is assigned to a GameLift game session queue resource and uniquely
identifies it. ARNs are unique across all Regions. Format is
C<arn:aws:gamelift:E<lt>regionE<gt>::gamesessionqueue/E<lt>queue
nameE<gt>>. In a GameLift game session queue ARN, the resource ID
matches the I<Name> value.


=head2 Name => Str

A descriptive label that is associated with game session queue. Queue
names must be unique within each Region.


=head2 NotificationTarget => Str

An SNS topic ARN that is set up to receive game session placement
notifications. See Setting up notifications for game session placement
(https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html).


=head2 PlayerLatencyPolicies => ArrayRef[L<Paws::GameLift::PlayerLatencyPolicy>]

A set of policies that act as a sliding cap on player latency. FleetIQ
works to deliver low latency for most players in a game session. These
policies ensure that no individual player can be placed into a game
with unreasonably high latency. Use multiple policies to gradually
relax latency requirements a step at a time. Multiple policies are
applied based on their maximum allowed latency, starting with the
lowest value.


=head2 PriorityConfiguration => L<Paws::GameLift::PriorityConfiguration>

Custom settings to use when prioritizing destinations and locations for
game session placements. This configuration replaces the FleetIQ
default prioritization process. Priority types that are not explicitly
named will be automatically applied at the end of the prioritization
process.


=head2 TimeoutInSeconds => Int

The maximum time, in seconds, that a new game session placement request
remains in the queue. When a request exceeds this time, the game
session placement changes to a C<TIMED_OUT> status.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

