/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.harakiri.HarakiriMonitor;
import org.couchbase.mock.http.StateGrabber;

class BucketsStreamingHandler
implements Observer {
    private final Socket rawSocket;
    private final OutputStream output;
    private final Bucket bucket;
    private final HarakiriMonitor monitor;
    private final Lock updateHandlerLock = new ReentrantLock();
    private final Condition condHasUpdatedConfig = this.updateHandlerLock.newCondition();
    private volatile boolean hasUpdatedConfig = false;
    private volatile boolean shouldTerminate = false;
    private final ByteBuffer dummyBuf = ByteBuffer.allocate(1);
    private static final byte[] chunkedDelimiter = "\n\n\n\n".getBytes();

    public BucketsStreamingHandler(HarakiriMonitor monitor, Bucket bucket, Socket socket) {
        this.bucket = bucket;
        this.monitor = monitor;
        this.rawSocket = socket;
        try {
            this.output = socket.getOutputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private byte[] getConfigBytes() {
        return StateGrabber.getBucketJSON(this.bucket).getBytes();
    }

    private void writeChunk(byte[] chunk) throws IOException {
        String s = String.format("%x\r\n", chunk.length);
        this.output.write(s.getBytes());
        this.output.write(chunk);
        this.output.write("\r\n".getBytes());
    }

    private void writeConfigBytes(byte[] payload) throws IOException {
        this.writeChunk(payload);
        this.writeChunk(chunkedDelimiter);
        this.output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        this.updateHandlerLock.lock();
        try {
            this.hasUpdatedConfig = true;
            this.condHasUpdatedConfig.signalAll();
        }
        finally {
            this.updateHandlerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfClosed() throws IOException {
        SocketChannel ch = this.rawSocket.getChannel();
        ch.configureBlocking(false);
        this.dummyBuf.rewind();
        try {
            int nBytes = ch.read(this.dummyBuf);
            boolean bl = nBytes == 0;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            ch.configureBlocking(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean streamNewConfig() throws InterruptedException {
        this.updateHandlerLock.lock();
        boolean isLocked = true;
        try {
            while (!this.shouldTerminate && !this.hasUpdatedConfig) {
                this.condHasUpdatedConfig.await(10L, TimeUnit.MILLISECONDS);
                try {
                    if (this.checkIfClosed()) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (ClosedChannelException ex) {
                    boolean bl = false;
                    return bl;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    boolean bl = false;
                    if (isLocked) {
                        this.updateHandlerLock.unlock();
                    }
                    return bl;
                }
            }
            isLocked = false;
            this.updateHandlerLock.unlock();
            if (this.hasUpdatedConfig) {
                this.writeConfigBytes(this.getConfigBytes());
                this.hasUpdatedConfig = false;
                boolean ex = true;
                return ex;
            }
            boolean ex = false;
            return ex;
            {
                catch (IOException e) {
                    this.shouldTerminate = false;
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (isLocked) {
                this.updateHandlerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStreaming() throws IOException, InterruptedException {
        this.bucket.configReadLock();
        byte[] configBytes = this.getConfigBytes();
        this.updateHandlerLock.lock();
        if (this.monitor != null) {
            this.monitor.addObserver(this);
        }
        this.bucket.configReadUnlock();
        try {
            this.writeConfigBytes(configBytes);
        }
        finally {
            this.updateHandlerLock.unlock();
        }
        while (this.streamNewConfig()) {
        }
        this.output.close();
    }
}

