package TheSchwartz::JobScheduler::Job;
## no critic (ControlStructures::ProhibitPostfixControls)

use strict;
use warnings;

# ABSTRACT: TheSchwartz Job class

our $VERSION = '0.001'; # VERSION: generated by DZP::OurPkgVersion

use Moo;

sub as_hashref {
    my $self = shift;

    my %data;
    $data{jobid}         = $self->jobid         if ( defined $self->jobid );
    $data{funcid}        = $self->funcid        if ( defined $self->funcid );
    $data{arg}           = $self->arg           if ( defined $self->arg );
    $data{uniqkey}       = $self->uniqkey       if ( defined $self->uniqkey );
    $data{insert_time}   = $self->insert_time   if ( defined $self->insert_time );
    $data{run_after}     = $self->run_after     if ( defined $self->run_after );
    $data{grabbed_until} = $self->grabbed_until if ( defined $self->grabbed_until );
    $data{priority}      = $self->priority      if ( defined $self->priority );
    $data{coalesce}      = $self->coalesce      if ( defined $self->coalesce );

    return \%data;
}

has jobid         => ( is => 'rw', default => sub { undef }, );
has funcid        => ( is => 'rw', default => sub { undef }, );
has arg           => ( is => 'rw', default => sub { undef }, );
has uniqkey       => ( is => 'rw', default => sub { undef }, );
has insert_time   => ( is => 'rw', default => sub { undef }, );
has run_after     => ( is => 'rw', default => sub { time }, );
has grabbed_until => ( is => 'rw', default => sub { 0 }, );
has priority      => ( is => 'rw', default => sub { undef }, );
has coalesce      => ( is => 'rw', default => sub { undef }, );
has funcname      => ( is => 'rw', default => sub { undef }, );

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

TheSchwartz::JobScheduler::Job - TheSchwartz Job class

=head1 VERSION

version 0.001

=head1 SYNOPSIS

    use TheSchwartz::JobScheduler::Job;

    my $job1 = TheSchwartz::JobScheduler::Job->new;
    $job1->funcname("WorkerName");
    $job1->arg({ foo => "bar" });
    $job1->uniqkey("uniqkey");
    $job1->run_after( time + 60 );

    my $job2 = TheSchwartz::JobScheduler::Job->new(
        funcname => 'WorkerName',
        arg => { foo => 'baz' },
        );

=head1 DESCRIPTION

The Job class makes it easier to create TheSchwartz jobs with different parameters.

=head1 METHODS

=head2 as_hashref

Get Job as a hashref.

Accessors:

=over 8

=item jobid

=item funcid

=item arg

=item uniqkey

=item insert_time

=item run_after

=item grabbed_until

=item priority

=item coalesce

=item funcname

=back

=head1 AUTHOR

Mikko Koivunalho <mikkoi@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by Mikko Koivunalho.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
