/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.MessageListener2;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.testdriver.Environment;
import net.sf.saxon.testdriver.ErrorCollector;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriver;
import net.sf.saxon.testdriver.TestOutcome;
import net.sf.saxon.testdriver.Xslt30TestReport;
import net.sf.saxon.trace.XSLTTraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xslt30TestSuiteDriverHE
extends TestDriver {
    protected Set<String> alwaysOn = new HashSet<String>();
    protected Set<String> needsEE = new HashSet<String>();
    protected Set<String> needsPE = new HashSet<String>();
    protected Set<String> alwaysOff = new HashSet<String>();

    public Xslt30TestSuiteDriverHE() {
        this.spec = Spec.XT30;
        this.setDependencyData();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-?")) {
            Xslt30TestSuiteDriverHE.usage();
        }
        new Xslt30TestSuiteDriverHE().go(args);
    }

    protected static void usage() {
        System.err.println("java com.saxonica.testdriver.Xslt30TestSuiteDriver[HE] testsuiteDir catalog [-o:resultsdir] [-s:testSetName] [-t:testNamePattern] [-bytecode:on|off|debug] [-export] [-tree] [-lang] [-save] [-streaming:off|std|ext] [-xt30:on] [-T] [-js]");
    }

    @Override
    public String catalogNamespace() {
        return "http://www.w3.org/2012/10/xslt-test-catalog";
    }

    @Override
    protected void writeResultFilePreamble(Processor processor, XdmNode catalog) throws Exception {
        super.writeResultFilePreamble(processor, catalog);
    }

    @Override
    public void processSpec(String specStr) {
        if (specStr.equals("XT10")) {
            this.spec = Spec.XT10;
        } else if (specStr.equals("XT20")) {
            this.spec = Spec.XT20;
        } else if (specStr.equals("XT30")) {
            this.spec = Spec.XT30;
        } else {
            throw new IllegalArgumentException("Unknown spec " + specStr);
        }
        this.resultsDoc = new Xslt30TestReport(this, this.spec);
    }

    @Override
    protected void createGlobalEnvironments(XdmNode catalog, XPathCompiler xpc) throws SaxonApiException {
        for (XdmItem env : xpc.evaluate("//environment", (XdmItem)catalog)) {
            Environment.processEnvironment(this, xpc, env, this.globalEnvironments, (Environment)this.localEnvironments.get("default"));
        }
    }

    protected boolean isSlow(String testName) {
        return testName.startsWith("regex-classes") || testName.equals("normalize-unicode-008") || testName.equals("function-1031") && this.driverProc.getSaxonEdition().equals("HE");
    }

    @Override
    protected void runTestCase(XdmNode testCase, XPathCompiler xpath) throws SaxonApiException {
        XdmNode assertion;
        String select;
        boolean staticError;
        boolean strictStreamability;
        String xsltLanguageVersion;
        TestOutcome outcome = new TestOutcome(this);
        String testName = testCase.getAttributeValue(new QName("name"));
        String testSetName = testCase.getParent().getAttributeValue(new QName("name"));
        if (this.exceptionsMap.containsKey("$" + testSetName)) {
            ++this.notrun;
            XdmNode exceptionElement = (XdmNode)this.exceptionsMap.get("$" + testSetName);
            this.resultsDoc.writeTestcaseElement(testName, exceptionElement.getAttributeValue(new QName("report")), exceptionElement.axisIterator(Axis.CHILD, new QName("reason")).next().getStringValue());
            return;
        }
        if (this.exceptionsMap.containsKey(testName)) {
            ++this.notrun;
            XdmNode exceptionElement = (XdmNode)this.exceptionsMap.get(testName);
            this.resultsDoc.writeTestcaseElement(testName, exceptionElement.getAttributeValue(new QName("report")), exceptionElement.axisIterator(Axis.CHILD, new QName("reason")).next().getStringValue());
            return;
        }
        if (this.isSlow(testName)) {
            ++this.notrun;
            this.resultsDoc.writeTestcaseElement(testName, "tooBig", "requires excessive resources");
            return;
        }
        XdmItem specAtt = xpath.evaluateSingle("(/test-set/dependencies/spec/@value, ./dependencies/spec/@value)[last()]", (XdmItem)testCase);
        String spec = specAtt == null ? "XSLT10+" : specAtt.toString();
        Environment env = this.getEnvironment(testCase, xpath);
        if (env == null) {
            this.resultsDoc.writeTestcaseElement(testName, "notRun", "test catalog error");
            ++this.notrun;
            return;
        }
        for (XdmItem dep : xpath.evaluate("(/test-set/dependencies/*, ./dependencies/*)", (XdmItem)testCase)) {
            if (this.ensureDependencySatisfied((XdmNode)dep, env)) continue;
            ++this.notrun;
            String type = ((XdmNode)dep).getNodeName().getLocalName();
            String value = ((XdmNode)dep).getAttributeValue(new QName("", "value"));
            value = value == null ? type : type + ":" + value;
            if ("false".equals(((XdmNode)dep).getAttributeValue(new QName("", "satisfied")))) {
                value = "!" + value;
            }
            String message = "dependency not satisfied: " + value;
            if (value.startsWith("feature:")) {
                message = "requires optional " + value;
            }
            this.resultsDoc.writeTestcaseElement(testName, "n/a", message);
            return;
        }
        if (env.failedToBuild) {
            this.resultsDoc.writeTestcaseElement(testName, "fail", "unable to build environment");
            this.noteFailure(testSetName, testName);
            return;
        }
        if (!env.usable) {
            this.resultsDoc.writeTestcaseElement(testName, "n/a", "environment dependencies not satisfied");
            ++this.notrun;
            return;
        }
        if (testName.contains("environment-variable")) {
            EnvironmentVariableResolver resolver = new EnvironmentVariableResolver(){

                public Set<String> getAvailableEnvironmentVariables() {
                    HashSet<String> strings = new HashSet<String>();
                    strings.add("QTTEST");
                    strings.add("QTTEST2");
                    strings.add("QTTESTEMPTY");
                    return strings;
                }

                public String getEnvironmentVariable(String name) {
                    if (name.equals("QTTEST")) {
                        return "42";
                    }
                    if (name.equals("QTTEST2")) {
                        return "other";
                    }
                    if (name.equals("QTTESTEMPTY")) {
                        return "";
                    }
                    return null;
                }
            };
            env.processor.setConfigurationProperty("http://saxon.sf.net/feature/environmentVariableResolver", (Object)resolver);
        }
        if (testName.contains("load-xquery-module")) {
            env.processor.getUnderlyingConfiguration().setModuleURIResolver(new ModuleURIResolver(){

                public StreamSource[] resolve(String moduleURI, String baseURI, String[] locations) throws XPathException {
                    File file = (File)Xslt30TestSuiteDriverHE.this.queryModules.get(moduleURI);
                    if (file == null) {
                        return null;
                    }
                    try {
                        StreamSource ss = new StreamSource(new FileInputStream(file), baseURI);
                        return new StreamSource[]{ss};
                    }
                    catch (FileNotFoundException e) {
                        throw new XPathException((Throwable)e);
                    }
                }
            });
        }
        XdmNode testInput = (XdmNode)xpath.evaluateSingle("test", (XdmItem)testCase);
        XdmNode stylesheet = (XdmNode)xpath.evaluateSingle("stylesheet[not(@role='secondary')]", (XdmItem)testInput);
        XdmNode postureAndSweep = (XdmNode)xpath.evaluateSingle("posture-and-sweep", (XdmItem)testInput);
        XdmNode principalPackage = (XdmNode)xpath.evaluateSingle("package[@role='principal']", (XdmItem)testInput);
        XdmValue usedPackages = xpath.evaluate("package[@role='secondary']", (XdmItem)testInput);
        XsltExecutable sheet = env.xsltExecutable;
        ErrorCollector collector = new ErrorCollector();
        if (this.quiet) {
            collector.setLogger(new Logger(){

                public void println(String message, int severity) {
                }

                public StreamResult asStreamResult() {
                    return null;
                }
            });
        }
        String string = xsltLanguageVersion = spec.contains("XSLT30") || spec.contains("XSLT20+") ? "3.0" : "2.0";
        if (postureAndSweep != null && this.runPostureAndSweepTests) {
            this.runStreamabilityTests(xpath, testCase);
            return;
        }
        if (postureAndSweep != null && !this.runPostureAndSweepTests) {
            return;
        }
        boolean bl = strictStreamability = xpath.evaluate("result//error[@code='XTSE3430']", (XdmItem)testCase).size() > 0;
        if (strictStreamability) {
            env.processor.setConfigurationProperty("http://saxon.sf.net/feature/strictStreamability", (Object)true);
            env.resetActions.add(new Environment.ResetAction(){

                public void reset(Environment env) {
                    env.processor.setConfigurationProperty("http://saxon.sf.net/feature/strictStreamability", (Object)false);
                }
            });
        }
        boolean bl2 = staticError = xpath.evaluate("result//error[starts-with(@code, 'XTSE')]", (XdmItem)testCase).size() > 0;
        if (staticError && this.jitFlag) {
            env.xsltCompiler.setJustInTimeCompilation(false);
            env.resetActions.add(new Environment.ResetAction(){

                public void reset(Environment env) {
                    env.xsltCompiler.setJustInTimeCompilation(true);
                }
            });
        }
        if (stylesheet != null) {
            String fileName = stylesheet.getAttributeValue(new QName("file"));
            StreamSource styleSource = new StreamSource(testCase.getBaseURI().resolve(fileName).toString());
            XsltCompiler compiler = env.xsltCompiler;
            compiler.setErrorListener((ErrorListener)((Object)collector));
            this.initPatternOptimization(compiler);
            compiler.clearParameters();
            this.prepareForSQL(compiler.getProcessor());
            for (XdmItem param : xpath.evaluate("param[@static=('yes','true','1')]", (XdmItem)testInput)) {
                XdmValue value;
                String name = ((XdmNode)param).getAttributeValue(new QName("name"));
                select = ((XdmNode)param).getAttributeValue(new QName("select"));
                try {
                    value = xpath.evaluate(select, null);
                }
                catch (SaxonApiException e) {
                    System.err.println("*** Error evaluating parameter " + name + ": " + e.getMessage());
                    throw e;
                }
                compiler.setParameter(new QName(name), value);
            }
            for (XdmItem pack : usedPackages) {
                String fileName2 = ((XdmNode)pack).getAttributeValue(new QName("file"));
                StreamSource styleSource2 = new StreamSource(testCase.getBaseURI().resolve(fileName2).toString());
                XsltPackage xpack = compiler.compilePackage((Source)styleSource2);
                xpack = this.exportImportPackage(testName, testSetName, outcome, compiler, xpack, collector);
                compiler.importPackage(xpack);
            }
            sheet = this.exportImport(testName, testSetName, outcome, compiler, sheet, collector, styleSource);
            String optimizationAssertion = (String)this.optimizationAssertions.get(testName);
            if (optimizationAssertion != null && sheet != null) {
                try {
                    this.assertOptimization(sheet, optimizationAssertion);
                    System.err.println("Optimization OK: " + optimizationAssertion);
                }
                catch (SaxonApiException e) {
                    System.err.println("Optimization assertion failed: " + optimizationAssertion);
                }
            }
        } else if (principalPackage != null) {
            XsltCompiler compiler = env.xsltCompiler;
            compiler.setErrorListener((ErrorListener)((Object)collector));
            compiler.clearParameters();
            for (XdmItem param : xpath.evaluate("param[@static=('yes','true','1')]", (XdmItem)testInput)) {
                XdmValue value;
                String name = ((XdmNode)param).getAttributeValue(new QName("name"));
                String select2 = ((XdmNode)param).getAttributeValue(new QName("select"));
                try {
                    value = xpath.evaluate(select2, null);
                }
                catch (SaxonApiException e) {
                    System.err.println("*** Error evaluating parameter " + name + ": " + e.getMessage());
                    throw e;
                }
                compiler.setParameter(new QName(name), value);
            }
            for (XdmItem pack : usedPackages) {
                String fileName = ((XdmNode)pack).getAttributeValue(new QName("file"));
                StreamSource styleSource = new StreamSource(testCase.getBaseURI().resolve(fileName).toString());
                XsltPackage xpack = compiler.compilePackage((Source)styleSource);
                compiler.importPackage(xpack);
            }
            String fileName = principalPackage.getAttributeValue(new QName("file"));
            StreamSource styleSource = new StreamSource(testCase.getBaseURI().resolve(fileName).toString());
            try {
                XsltPackage xpack = compiler.compilePackage((Source)styleSource);
                sheet = xpack.link();
            }
            catch (SaxonApiException err) {
                System.err.println(err.getMessage());
                outcome.setException(err);
                outcome.setErrorsReported(collector.getErrorCodes());
            }
            catch (Exception err) {
                err.printStackTrace();
                System.err.println(err.getMessage());
                outcome.setException(new SaxonApiException((Throwable)err));
                outcome.setErrorsReported(collector.getErrorCodes());
            }
            sheet = this.exportImport(testName, testSetName, outcome, compiler, sheet, collector, styleSource);
        }
        XdmValue initialMatchSelection = null;
        XdmNode initialMode = (XdmNode)xpath.evaluateSingle("initial-mode", (XdmItem)testInput);
        XdmNode initialFunction = (XdmNode)xpath.evaluateSingle("initial-function", (XdmItem)testInput);
        XdmNode initialTemplate = (XdmNode)xpath.evaluateSingle("initial-template", (XdmItem)testInput);
        QName initialModeName = null;
        if (initialMode != null) {
            String attValue = initialMode.getAttributeValue(new QName("name"));
            initialModeName = "#unnamed".equals(attValue) ? new QName("xsl", "http://www.w3.org/1999/XSL/Transform", "unnamed") : ("#default".equals(attValue) ? new QName("xsl", "http://www.w3.org/1999/XSL/Transform", "default") : Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, (XdmItem)testInput, "initial-mode/@name"));
            select = initialMode.getAttributeValue(new QName("select"));
            if (select != null) {
                initialMatchSelection = env.xpathCompiler.evaluate(select, null);
                if (this.runWithJS) {
                    this.resultsDoc.writeTestcaseElement(testName, "n/a", "Test driver limitation: cannot set initial match selection");
                    ++this.notrun;
                    return;
                }
            }
        }
        QName initialTemplateName = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, (XdmItem)testInput, "initial-template/@name");
        QName initialFunctionName = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, (XdmItem)testInput, "initial-function/@name");
        if (this.runWithJS && !outcome.isException()) {
            this.initializeForSaxonJS(xpath, outcome, testName, env, testInput, initialMode, initialTemplate, initialModeName, initialTemplateName, initialFunctionName);
            return;
        }
        if (sheet != null && !this.runWithJS) {
            boolean failure;
            XdmItem contextItem = env.contextItem;
            String outputUri = xpath.evaluate("string(output/@file)", (XdmItem)testInput).toString();
            if ("".equals(outputUri)) {
                outputUri = null;
            }
            URI baseOut = new File(this.resultsDir + "/results/output.xml").toURI();
            String baseOutputURI = new File(this.resultsDir + "/results/output.xml").toURI().toString();
            if (outputUri != null) {
                baseOutputURI = baseOut.resolve(outputUri).toString();
            }
            if (failure = this.useXslt30Transformer ? this.runWithXslt30Transformer(testCase, xpath, outcome, testName, testSetName, env, testInput, sheet, collector, xsltLanguageVersion, contextItem, initialMode, initialFunction, initialTemplate, initialModeName, initialMatchSelection, initialTemplateName, baseOutputURI) : this.runWithXsltTransformer(xpath, outcome, testName, testSetName, env, testInput, sheet, collector, contextItem, initialMode, initialModeName, initialTemplateName, baseOutputURI)) {
                return;
            }
        }
        for (Environment.ResetAction action : env.resetActions) {
            action.reset(env);
        }
        env.resetActions.clear();
        boolean expectEarlyExit = ((XdmAtomicValue)xpath.evaluateSingle("result/@early-exit-possible = 'true'", (XdmItem)testCase)).getBooleanValue();
        if (expectEarlyExit != collector.isMadeEarlyExit()) {
            outcome.setComment(expectEarlyExit ? "Failed to make early exit" : "Unexpected early exit");
        }
        if ((assertion = (XdmNode)xpath.evaluateSingle("result/*", (XdmItem)testCase)) == null) {
            this.noteFailure(testSetName, testName);
            this.resultsDoc.writeTestcaseElement(testName, "fail", "No test assertions found");
            return;
        }
        XPathCompiler assertionXPath = env.processor.newXPathCompiler();
        assertionXPath.setSchemaAware(true);
        assertionXPath.setBaseURI(assertion.getBaseURI());
        boolean success = outcome.testAssertion(assertion, outcome.getPrincipalResultDoc(), assertionXPath, xpath, this.debug);
        if (success) {
            ++this.successes;
            this.resultsDoc.writeTestcaseElement(testName, "pass", outcome.getComment());
        } else if (outcome.getWrongErrorMessage() != null) {
            outcome.setComment(outcome.getWrongErrorMessage());
            ++this.wrongErrorResults;
            ++this.successes;
            this.resultsDoc.writeTestcaseElement(testName, "wrongError", outcome.getComment());
        } else {
            this.noteFailure(testSetName, testName);
            if (outcome.getException() != null && outcome.getComment() == null) {
                outcome.setComment(outcome.getException().getMessage());
            }
            this.resultsDoc.writeTestcaseElement(testName, "fail", outcome.getComment());
        }
    }

    protected void initializeForSaxonJS(XPathCompiler xpath, TestOutcome outcome, String testName, Environment env, XdmNode testInput, XdmNode initialMode, XdmNode initialTemplate, QName initialModeName, QName initialTemplateName, QName initialFunctionName) throws SaxonApiException {
    }

    public void runJSTransform(Environment env, TestOutcome outcome, QName initialTemplateName, QName initialModeName, QName initialFunctionName, URI baseOutputURI) {
    }

    private boolean runWithXsltTransformer(XPathCompiler xpath, final TestOutcome outcome, String testName, String testSetName, Environment env, XdmNode testInput, XsltExecutable sheet, ErrorCollector collector, XdmItem contextItem, XdmNode initialMode, QName initialModeName, QName initialTemplateName, String baseOutputURI) {
        try {
            XsltTransformer transformer = sheet.load();
            transformer.setURIResolver((URIResolver)env);
            transformer.setBaseOutputURI(baseOutputURI);
            if (env.unparsedTextResolver != null) {
                transformer.getUnderlyingController().setUnparsedTextURIResolver(env.unparsedTextResolver);
            }
            if (initialTemplateName != null) {
                transformer.setInitialTemplate(initialTemplateName);
            }
            if (initialMode != null) {
                try {
                    transformer.setInitialMode(initialModeName);
                }
                catch (IllegalArgumentException e) {
                    if (e.getCause() instanceof XPathException) {
                        collector.fatalError((TransformerException)((Object)((XPathException)e.getCause())));
                        throw new SaxonApiException(e.getCause());
                    }
                    throw e;
                }
            }
            for (XdmItem param : xpath.evaluate("param[not(@static='yes')]", (XdmItem)testInput)) {
                XdmValue value;
                String name = ((XdmNode)param).getAttributeValue(new QName("name"));
                String select = ((XdmNode)param).getAttributeValue(new QName("select"));
                try {
                    value = xpath.evaluate(select, null);
                }
                catch (SaxonApiException e) {
                    System.err.println("*** Error evaluating parameter " + name + ": " + e.getMessage());
                    throw e;
                }
                transformer.setParameter(new QName(name), value);
                this.setGlobalParameter(new QName(name), value);
            }
            if (contextItem != null) {
                transformer.setInitialContextNode((XdmNode)contextItem);
            }
            if (env.streamedFile != null) {
                transformer.setSource((Source)new StreamSource(env.streamedFile));
            } else if (env.streamedContent != null) {
                transformer.setSource((Source)new StreamSource(new StringReader(env.streamedContent), "inlineDoc"));
            }
            for (QName varName : env.params.keySet()) {
                transformer.setParameter(varName, env.params.get(varName));
                this.setGlobalParameter(varName, env.params.get(varName));
            }
            transformer.setErrorListener((ErrorListener)((Object)collector));
            transformer.setMessageListener(new MessageListener(){

                public void message(XdmNode content, boolean terminate, SourceLocator locator) {
                    outcome.addXslMessage(content);
                    System.err.println(content.getStringValue());
                }
            });
            StringWriter sw = new StringWriter();
            Serializer serializer = env.processor.newSerializer((Writer)sw);
            transformer.setDestination((Destination)serializer);
            transformer.getUnderlyingController().setOutputURIResolver((OutputURIResolver)new OutputResolver(env.processor, outcome, true));
            transformer.transform();
            outcome.setPrincipalSerializedResult(sw.toString());
            if (this.saveResults) {
                this.saveResultsToFile(sw.toString(), new File(this.resultsDir + "/results/" + testSetName + "/" + testName + ".out"));
                Map<URI, TestOutcome.SingleResultDoc> xslResultDocuments = outcome.getSecondaryResultDocuments();
                for (Map.Entry<URI, TestOutcome.SingleResultDoc> entry : xslResultDocuments.entrySet()) {
                    URI key = entry.getKey();
                    if (key == null) continue;
                    String path = key.getPath();
                    String serialization = outcome.serialize(env.processor, entry.getValue());
                    this.saveResultsToFile(serialization, new File(path));
                }
            }
            if (env.streamedContent != null) {
                transformer.setSource((Source)new StreamSource(new StringReader(env.streamedContent), "inlineDoc"));
            }
            XdmDestination destination = new XdmDestination();
            transformer.setDestination((Destination)destination);
            transformer.getUnderlyingController().setOutputURIResolver((OutputURIResolver)new OutputResolver(env.processor, outcome, false));
            transformer.transform();
            outcome.setPrincipalResult((XdmValue)destination.getXdmNode());
            outcome.setWarningsReported(collector.getFoundWarnings());
        }
        catch (SaxonApiException err) {
            outcome.setException(err);
            if (collector.getErrorCodes().isEmpty()) {
                outcome.addReportedError(err.getErrorCode().getLocalName());
            } else {
                outcome.setErrorsReported(collector.getErrorCodes());
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            this.noteFailure(testSetName, testName);
            this.resultsDoc.writeTestcaseElement(testName, "fail", "*** crashed " + err.getClass() + ": " + err.getMessage());
            return true;
        }
        return false;
    }

    protected void setGlobalParameter(QName qName, XdmValue value) {
    }

    protected boolean runWithXslt30Transformer(XdmNode testCase, XPathCompiler xpath, final TestOutcome outcome, String testName, String testSetName, Environment env, XdmNode testInput, XsltExecutable sheet, ErrorCollector collector, String xsltLanguageVersion, XdmItem contextItem, XdmNode initialMode, XdmNode initialFunction, XdmNode initialTemplate, QName initialModeName, XdmValue initialMatchSelection, QName initialTemplateName, String baseOutputURI) {
        try {
            XdmValue[] params;
            XdmNode needsSerialization;
            boolean assertsSerial = xpath.evaluate("result//(assert-serialization|assert-serialization-error|serialization-matches)", (XdmItem)testCase).size() > 0;
            boolean resultAsTree = env.outputTree;
            boolean serializationDeclared = env.outputSerialize;
            XdmNode needsTree = (XdmNode)xpath.evaluateSingle("output/@tree", (XdmItem)testInput);
            if (needsTree != null) {
                resultAsTree = needsTree.getStringValue().equals("yes");
            }
            if ((needsSerialization = (XdmNode)xpath.evaluateSingle("output/@serialize", (XdmItem)testInput)) != null) {
                serializationDeclared = needsSerialization.getStringValue().equals("yes");
            }
            boolean resultSerialized = serializationDeclared || assertsSerial;
            Xslt30Transformer transformer = sheet.load30();
            transformer.setURIResolver((URIResolver)env);
            if (env.unparsedTextResolver != null) {
                transformer.getUnderlyingController().setUnparsedTextURIResolver(env.unparsedTextResolver);
            }
            if (this.tracing) {
                transformer.setTraceListener((TraceListener)new XSLTTraceListener());
            }
            Map<QName, XdmValue> caseGlobalParams = this.getNamedParameters(xpath, testInput, false, false);
            Map<QName, XdmValue> caseStaticParams = this.getNamedParameters(xpath, testInput, true, false);
            HashMap<QName, XdmValue> globalParams = new HashMap<QName, XdmValue>(env.params);
            globalParams.putAll(caseStaticParams);
            globalParams.putAll(caseGlobalParams);
            transformer.setStylesheetParameters(globalParams);
            if (contextItem != null) {
                transformer.setGlobalContextItem(contextItem);
            }
            transformer.setErrorListener((ErrorListener)((Object)collector));
            transformer.setBaseOutputURI(baseOutputURI);
            transformer.setMessageListener(new MessageListener2(){

                public void message(XdmNode content, QName errorCode, boolean terminate, SourceLocator locator) {
                    outcome.addXslMessage(content);
                    System.err.println(content.getStringValue());
                }
            });
            XdmValue result = null;
            StringWriter sw = new StringWriter();
            Serializer serializer = env.processor.newSerializer((Writer)sw);
            OutputResolver serializingOutput = new OutputResolver(env.processor, outcome, true);
            Controller controller = transformer.getUnderlyingController();
            controller.setOutputURIResolver((OutputURIResolver)serializingOutput);
            Serializer dest = null;
            if (resultAsTree) {
                controller.setOutputURIResolver((OutputURIResolver)new OutputResolver(env.processor, outcome, false));
                dest = new XdmDestination();
            } else {
                controller.setBuildTree(false);
            }
            if (resultSerialized) {
                dest = serializer;
            }
            StreamSource src = null;
            if (env.streamedFile != null) {
                src = new StreamSource(env.streamedFile);
            } else if (env.streamedContent != null) {
                src = new StreamSource(new StringReader(env.streamedContent), "inlineDoc");
            } else if (initialTemplate == null && contextItem != null) {
                src = ((XdmNode)contextItem).getUnderlyingNode();
            }
            if (src == null && initialFunction == null && initialTemplateName == null && initialModeName == null) {
                initialTemplateName = new QName("xsl", "http://www.w3.org/1999/XSL/Transform", "initial-template");
            }
            try {
                if (initialModeName != null) {
                    transformer.setInitialMode(initialModeName);
                } else {
                    controller.getInitialMode();
                }
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() instanceof XPathException) {
                    collector.fatalError((TransformerException)((Object)((XPathException)e.getCause())));
                    throw new SaxonApiException(e.getCause());
                }
                throw e;
            }
            if (initialMode != null || initialTemplate != null) {
                XdmNode init = initialMode == null ? initialTemplate : initialMode;
                params = this.getNamedParameters(xpath, init, false, false);
                Map<QName, XdmValue> tunnelledParams = this.getNamedParameters(xpath, init, false, true);
                if (xsltLanguageVersion.equals("2.0")) {
                    if (!params.isEmpty() || !tunnelledParams.isEmpty()) {
                        System.err.println("*** Initial template parameters ignored for XSLT 2.0");
                    }
                } else {
                    transformer.setInitialTemplateParameters((Map)params, false);
                    transformer.setInitialTemplateParameters(tunnelledParams, true);
                }
            }
            if (initialTemplateName != null) {
                transformer.setGlobalContextItem(contextItem);
                if (dest == null) {
                    result = transformer.callTemplate(initialTemplateName);
                } else {
                    transformer.callTemplate(initialTemplateName, (Destination)dest);
                }
            } else if (initialFunction != null) {
                QName name = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, (XdmItem)initialFunction, "@name");
                params = this.getParameters(xpath, initialFunction);
                if (dest == null) {
                    result = transformer.callFunction(name, params);
                } else {
                    transformer.callFunction(name, params, (Destination)dest);
                }
            } else if (initialMatchSelection != null) {
                if (dest == null) {
                    result = transformer.applyTemplates(initialMatchSelection);
                } else {
                    transformer.applyTemplates(initialMatchSelection, (Destination)dest);
                }
            } else if (dest == null) {
                result = transformer.applyTemplates((Source)src);
            } else {
                transformer.applyTemplates((Source)src, (Destination)dest);
            }
            outcome.setWarningsReported(collector.getFoundWarnings());
            if (resultAsTree && !resultSerialized) {
                result = ((XdmDestination)dest).getXdmNode();
            }
            if (resultSerialized) {
                outcome.setPrincipalSerializedResult(sw.toString());
            }
            outcome.setPrincipalResult(result);
            if (this.saveResults) {
                String s = sw.toString();
                if (!resultSerialized && result != null) {
                    StringWriter sw2 = new StringWriter();
                    Serializer se = env.processor.newSerializer((Writer)sw2);
                    se.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                    env.processor.writeXdmValue(result, (Destination)se);
                    se.close();
                    s = sw2.toString();
                }
                this.saveResultsToFile(s, new File(this.resultsDir + "/results/" + testSetName + "/" + testName + ".out"));
                Map<URI, TestOutcome.SingleResultDoc> xslResultDocuments = outcome.getSecondaryResultDocuments();
                for (Map.Entry<URI, TestOutcome.SingleResultDoc> entry : xslResultDocuments.entrySet()) {
                    URI key = entry.getKey();
                    String path = key.getPath();
                    String serialization = outcome.serialize(env.processor, entry.getValue());
                    this.saveResultsToFile(serialization, new File(path));
                }
            }
        }
        catch (SaxonApiException err) {
            if (err.getCause() instanceof XPathException && !((XPathException)err.getCause()).hasBeenReported()) {
                System.err.println("Thrown exception " + ((XPathException)err.getCause()).getErrorCodeLocalPart() + ": " + err.getCause().getMessage());
            }
            outcome.setException(err);
            if (collector.getErrorCodes().isEmpty()) {
                if (err.getErrorCode() == null) {
                    outcome.addReportedError("Error_with_no_error_code");
                } else {
                    outcome.addReportedError(err.getErrorCode().getLocalName());
                }
            } else {
                outcome.setErrorsReported(collector.getErrorCodes());
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            this.noteFailure(testSetName, testName);
            this.resultsDoc.writeTestcaseElement(testName, "fail", "*** crashed " + err.getClass() + ": " + err.getMessage());
            return true;
        }
        return false;
    }

    protected void initPatternOptimization(XsltCompiler compiler) {
    }

    protected XsltExecutable exportImport(String testName, String testSetName, TestOutcome outcome, XsltCompiler compiler, XsltExecutable sheet, ErrorCollector collector, Source styleSource) {
        try {
            if (this.export) {
                sheet = this.exportStylesheet(testName, testSetName, compiler, sheet, styleSource);
            } else if (sheet == null) {
                sheet = compiler.compile(styleSource);
            }
        }
        catch (SaxonApiException err) {
            outcome.setException(err);
            if (err.getErrorCode() != null) {
                collector.getErrorCodes().add(err.getErrorCode().getLocalName());
            }
            outcome.setErrorsReported(collector.getErrorCodes());
        }
        catch (Exception err) {
            err.printStackTrace();
            System.err.println(err.getMessage());
            outcome.setException(new SaxonApiException((Throwable)err));
            outcome.setErrorsReported(collector.getErrorCodes());
        }
        return sheet;
    }

    protected XsltExecutable exportStylesheet(String testName, String testSetName, XsltCompiler compiler, XsltExecutable sheet, Source styleSource) throws SaxonApiException {
        try {
            File exportFile = new File(this.resultsDir + "/export/" + testSetName + "/" + testName + ".sef");
            XsltPackage compiledPack = compiler.compilePackage(styleSource);
            compiledPack.save(exportFile);
            sheet = this.reloadExportedStylesheet(compiler, exportFile);
        }
        catch (SaxonApiException e) {
            block4: {
                try {
                    compiler.getErrorListener().error((TransformerException)((Object)XPathException.makeXPathException((Exception)((Object)e))));
                }
                catch (TransformerException te) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            throw e;
        }
        return sheet;
    }

    protected XsltExecutable reloadExportedStylesheet(XsltCompiler compiler, File exportFile) throws SaxonApiException {
        return compiler.loadExecutablePackage(exportFile.toURI());
    }

    private XsltPackage exportImportPackage(String testName, String testSetName, TestOutcome outcome, XsltCompiler compiler, XsltPackage pack, ErrorCollector collector) {
        try {
            if (this.export) {
                try {
                    File exportFile = new File(this.resultsDir + "/export/" + testSetName + "/" + testName + ".base.sef");
                    pack.save(exportFile);
                    return compiler.loadLibraryPackage(exportFile.toURI());
                }
                catch (SaxonApiException e) {
                    compiler.getErrorListener().error((TransformerException)((Object)XPathException.makeXPathException((Exception)((Object)e))));
                    throw e;
                }
            }
            return pack;
        }
        catch (SaxonApiException err) {
            outcome.setException(err);
            if (err.getErrorCode() != null) {
                collector.getErrorCodes().add(err.getErrorCode().getLocalName());
            }
            outcome.setErrorsReported(collector.getErrorCodes());
        }
        catch (Exception err) {
            err.printStackTrace();
            System.err.println(err.getMessage());
            outcome.setException(new SaxonApiException((Throwable)err));
            outcome.setErrorsReported(collector.getErrorCodes());
        }
        return pack;
    }

    public void runStreamabilityTests(XPathCompiler xpc, XdmNode testCase) {
    }

    protected Map<QName, XdmValue> getNamedParameters(XPathCompiler xpath, XdmNode node, boolean getStatic, boolean tunnel) throws SaxonApiException {
        HashMap<QName, XdmValue> params = new HashMap<QName, XdmValue>();
        int i = 1;
        String staticTest = getStatic ? "@static='yes'" : "not(@static='yes')";
        for (XdmItem param : xpath.evaluate("param[" + staticTest + "]", (XdmItem)node)) {
            XdmValue value;
            boolean required;
            QName name = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, param, "@name");
            String select = ((XdmNode)param).getAttributeValue(new QName("select"));
            String tunnelled = ((XdmNode)param).getAttributeValue(new QName("tunnel"));
            QName as = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, param, "@as");
            boolean bl = required = tunnel == (tunnelled != null && tunnelled.equals("yes"));
            if (name == null) {
                System.err.println("*** No name for parameter " + i + " in initial-template");
                throw new SaxonApiException("*** No name for parameter " + i + " in initial-template");
            }
            try {
                value = xpath.evaluate(select, null);
                ++i;
            }
            catch (SaxonApiException e) {
                System.err.println("*** Error evaluating parameter " + name + " in initial-template : " + e.getMessage());
                throw e;
            }
            if (as != null) {
                value = new XdmAtomicValue(((AtomicValue)value.getUnderlyingValue()).getStringValue(), new ItemTypeFactory(xpath.getProcessor()).getAtomicType(as));
            }
            if (!required) continue;
            params.put(name, value);
        }
        return params;
    }

    protected XdmValue[] getParameters(XPathCompiler xpath, XdmNode node) throws SaxonApiException {
        ArrayList<XdmValue> params = new ArrayList<XdmValue>();
        int i = 1;
        for (XdmItem param : xpath.evaluate("param[not(@static='yes')]", (XdmItem)node)) {
            XdmValue value;
            String select = ((XdmNode)param).getAttributeValue(new QName("select"));
            try {
                value = xpath.evaluate(select, null);
                ++i;
            }
            catch (SaxonApiException e) {
                System.err.println("*** Error evaluating parameter " + i + " in initial-function : " + e.getMessage());
                throw e;
            }
            params.add(value);
        }
        return params.toArray(new XdmValue[params.size()]);
    }

    protected void saveResultsToFile(String content, File file) {
        try {
            if (!file.exists()) {
                File directory = file.getParentFile();
                if (directory != null && !directory.exists()) {
                    directory.mkdirs();
                }
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file);
            writer.append(content);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("*** Failed to save results to " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    protected void assertOptimization(XsltExecutable stylesheet, String assertion) throws SaxonApiException {
        XdmDestination builder = new XdmDestination();
        stylesheet.explain((Destination)builder);
        builder.close();
        XdmNode expressionTree = builder.getXdmNode();
        XPathCompiler xpe = stylesheet.getProcessor().newXPathCompiler();
        XPathSelector exp = xpe.compile(assertion).load();
        exp.setContextItem((XdmItem)expressionTree);
        XdmAtomicValue bv = (XdmAtomicValue)exp.evaluateSingle();
        if (bv == null || !bv.getBooleanValue()) {
            this.println("** Optimization assertion failed");
            this.println(expressionTree.toString());
            throw new SaxonApiException("Expected optimization not performed");
        }
    }

    protected void setDependencyData() {
        this.alwaysOn.add("feature/disabling_output_escaping");
        this.alwaysOn.add("feature/serialization");
        this.alwaysOn.add("feature/namespace_axis");
        this.alwaysOn.add("feature/dtd");
        this.alwaysOn.add("feature/built_in_derived_types");
        this.alwaysOn.add("feature/remote_http");
        this.alwaysOn.add("feature/xsl-stylesheet-processing-instruction");
        this.alwaysOn.add("feature/fn-transform-XSLT");
        this.alwaysOn.add("available_documents");
        this.alwaysOn.add("ordinal_scheme_name");
        this.alwaysOn.add("default_calendar_in_date_formatting_functions");
        this.alwaysOn.add("supported_calendars_in_date_formatting_functions");
        this.alwaysOn.add("maximum_number_of_decimal_digits");
        this.alwaysOn.add("default_output_encoding");
        this.alwaysOn.add("unparsed_text_encoding");
        this.alwaysOn.add("recognize_id_as_uri_fragment");
        this.alwaysOn.add("feature/XPath_3.1");
        this.needsPE.add("feature/backwards_compatibility");
        this.needsPE.add("feature/Saxon-PE");
        this.needsPE.add("feature/dynamic_evaluation");
        this.needsEE.add("languages_for_numbering");
        this.needsEE.add("feature/streaming");
        this.needsEE.add("feature/schema_aware");
        this.needsEE.add("feature/Saxon-EE");
        this.needsEE.add("feature/xquery_invocation");
        this.needsEE.add("feature/higher_order_functions");
        this.alwaysOn.add("detect_accumulator_cycles");
    }

    @Override
    public boolean ensureDependencySatisfied(XdmNode dependency, Environment env) {
        boolean needed;
        String type = dependency.getNodeName().getLocalName();
        String value = dependency.getAttributeValue(new QName("value"));
        String tv = type + "/" + (value == null ? "*" : value);
        boolean inverse = "false".equals(dependency.getAttributeValue(new QName("satisfied")));
        boolean bl = needed = !"false".equals(dependency.getAttributeValue(new QName("satisfied")));
        if (this.alwaysOn.contains(type) || this.alwaysOn.contains(tv)) {
            return needed;
        }
        if (this.alwaysOff.contains(type) || this.alwaysOff.contains(tv)) {
            return !needed;
        }
        String edition = env.processor.getSaxonEdition();
        if (this.needsPE.contains(type) || this.needsPE.contains(tv)) {
            return (edition.equals("PE") || edition.equals("EE")) == needed;
        }
        if (this.needsEE.contains(type) || this.needsEE.contains(tv)) {
            return edition.equals("EE") == needed;
        }
        if ("spec".equals(type)) {
            boolean atLeast = value.endsWith("+");
            value = value.replace("+", "");
            String specName = this.spec.specAndVersion.replace("XT", "XSLT");
            int order = value.compareTo(specName);
            return atLeast ? order <= 0 : order == 0;
        }
        if ("feature".equals(type)) {
            if ("XML_1.1".equals(value)) {
                String requiredVersion = inverse ? "1.0" : "1.1";
                final String oldVersion = env.processor.getXmlVersion();
                if (env != null) {
                    env.resetActions.add(new Environment.ResetAction(){

                        public void reset(Environment env) {
                            env.processor.setXmlVersion(oldVersion);
                        }
                    });
                    env.processor.setXmlVersion(requiredVersion);
                    return true;
                }
                return false;
            }
            if ("XSD_1.1".equals(value)) {
                String requiredVersion = inverse ? "1.0" : "1.1";
                final String oldVersion = (String)env.processor.getConfigurationProperty("http://saxon.sf.net/feature/xsd-version");
                if (!oldVersion.equals(requiredVersion)) {
                    env.processor.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", (Object)requiredVersion);
                    env.resetActions.add(new Environment.ResetAction(){

                        public void reset(Environment env) {
                            env.processor.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", (Object)oldVersion);
                        }
                    });
                }
                return true;
            }
            if ("higher_order_functions".equals(value)) {
                return (edition.equals("PE") || edition.equals("EE")) ^ inverse;
            }
            if ("simple-uca-fallback".equals(value)) {
                return !inverse;
            }
            if ("advanced-uca-fallback".equals(value)) {
                return (edition.equals("PE") || edition.equals("EE")) ^ inverse;
            }
            System.err.println("*** Unknown feature in HE: " + value);
            return env.processor.getSaxonEdition().equals("HE") ? Boolean.valueOf(false) : null;
        }
        if ("default_language_for_numbering".equals(type)) {
            final String old = (String)env.processor.getConfigurationProperty("http://saxon.sf.net/feature/defaultLanguage");
            if (!value.equals(old)) {
                env.processor.setConfigurationProperty("http://saxon.sf.net/feature/defaultLanguage", (Object)value);
                env.resetActions.add(new Environment.ResetAction(){

                    public void reset(Environment env) {
                        env.processor.setConfigurationProperty("http://saxon.sf.net/feature/defaultLanguage", (Object)old);
                    }
                });
            }
            return true;
        }
        if ("enable_assertions".equals(type)) {
            boolean on = !inverse;
            final boolean old = env.xsltCompiler.isAssertionsEnabled();
            env.xsltCompiler.setAssertionsEnabled(on);
            env.resetActions.add(new Environment.ResetAction(){

                public void reset(Environment env) {
                    env.xsltCompiler.setAssertionsEnabled(old);
                }
            });
            return true;
        }
        if ("extension-function".equals(type)) {
            if (value.equals("Q{http://relaxng.org/ns/structure/1.0}schema-report#1")) {
                try {
                    Configuration config = env.processor.getUnderlyingConfiguration();
                    Object sf = config.getInstance("net.cfoster.saxonjing.SchemaFunction", null);
                    env.processor.registerExtensionFunction((ExtensionFunctionDefinition)sf);
                    Object sfd = config.getInstance("net.cfoster.saxonjing.SchemaReportFunction", null);
                    env.processor.registerExtensionFunction((ExtensionFunctionDefinition)sfd);
                    return true;
                }
                catch (XPathException err) {
                    System.err.println("Failed to load Saxon-Jing extension functions");
                    return false;
                }
            }
            return false;
        }
        if ("year_component_values".equals(type)) {
            if ("support year zero".equals(value)) {
                if (env != null) {
                    env.processor.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", (Object)(inverse ? "1.0" : "1.1"));
                    return true;
                }
                return false;
            }
            return !inverse;
        }
        if ("additional_normalization_form".equals(type)) {
            if (value.equals("support FULLY-NORMALIZED")) {
                return inverse;
            }
            return !inverse;
        }
        if ("on-multiple-match".equals(type)) {
            env.resetActions.add(new Environment.ResetAction(){

                public void reset(Environment env) {
                    env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(1);
                }
            });
            if (value.equals("error")) {
                env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(2);
            } else {
                env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(0);
            }
            return true;
        }
        if ("ignore-doc-failure".equals(type)) {
            env.resetActions.add(new Environment.ResetAction(){

                public void reset(Environment env) {
                    env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(1);
                }
            });
            if (value.equals("false")) {
                env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(2);
            } else {
                env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(0);
            }
            return true;
        }
        if ("combinations_for_numbering".equals(type)) {
            if (value.equals("COPTIC EPACT DIGIT ONE") || value.equals("SINHALA ARCHAIC DIGIT ONE") || value.equals("MENDE KIKAKUI DIGIT ONE")) {
                return false;
            }
            return !inverse;
        }
        if ("xsd-version".equals(type)) {
            return env.processor.getSaxonEdition().equals("HE") ? Boolean.valueOf(false) : null;
        }
        if ("sweep_and_posture".equals(type)) {
            return env.processor.getSaxonEdition().equals("HE") ? Boolean.valueOf(inverse) : null;
        }
        if ("unicode-version".equals(type)) {
            return value.equals("6.0");
        }
        this.println("**** dependency not recognized for HE: " + type);
        return false;
    }

    protected static QName getQNameAttribute(XPathCompiler xpath, XdmItem contextItem, String attributePath) throws SaxonApiException {
        String exp = "for $att in " + attributePath + " return if (contains($att, ':')) then resolve-QName($att, $att/..) else " + " if (contains($att,'{')) then QName(substring-before(substring-after($att,'{'),'}'),substring-after($att,'}')) else" + " if ($att = '#unnamed') then QName('http://saxon.sf.net/', 'unnamed') else " + " if ($att = '#default') then QName('http://saxon.sf.net/', 'default') else " + " QName('', $att)";
        XdmAtomicValue qname = (XdmAtomicValue)xpath.evaluateSingle(exp, contextItem);
        return qname == null ? null : (QName)qname.getValue();
    }

    protected static class OutputResolver
    implements OutputURIResolver {
        private Processor proc;
        private TestOutcome outcome;
        private Destination destination;
        private StringWriter stringWriter;
        boolean serialized;
        URI uri;

        public OutputResolver(Processor proc, TestOutcome outcome, boolean serialized) {
            this.proc = proc;
            this.outcome = outcome;
            this.serialized = serialized;
        }

        public OutputResolver newInstance() {
            return new OutputResolver(this.proc, this.outcome, this.serialized);
        }

        public Result resolve(String href, String base) throws XPathException {
            try {
                this.uri = new URI(base).resolve(href);
                if (this.serialized) {
                    this.stringWriter = new StringWriter();
                    StreamResult result = new StreamResult(this.stringWriter);
                    result.setSystemId(this.uri.toString());
                    return result;
                }
                this.destination = new XdmDestination();
                ((XdmDestination)this.destination).setBaseURI(this.uri);
                return this.destination.getReceiver(this.proc.getUnderlyingConfiguration());
            }
            catch (SaxonApiException e) {
                throw new XPathException((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new XPathException((Throwable)e);
            }
        }

        public void close(Result result) throws XPathException {
            if (this.serialized) {
                this.outcome.setSecondaryResult(this.uri, null, this.stringWriter == null ? "" : this.stringWriter.toString());
            } else {
                XdmDestination xdm = (XdmDestination)this.destination;
                if (xdm != null) {
                    this.outcome.setSecondaryResult(xdm.getBaseURI(), (XdmValue)xdm.getXdmNode(), null);
                }
            }
        }
    }
}

