# Generated by default/object.tt
package Paws::CostExplorer::EBSResourceUtilization;
  use Moose;
  has EbsReadBytesPerSecond => (is => 'ro', isa => 'Str');
  has EbsReadOpsPerSecond => (is => 'ro', isa => 'Str');
  has EbsWriteBytesPerSecond => (is => 'ro', isa => 'Str');
  has EbsWriteOpsPerSecond => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::EBSResourceUtilization

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::EBSResourceUtilization object:

  $service_obj->Method(Att1 => { EbsReadBytesPerSecond => $value, ..., EbsWriteOpsPerSecond => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::EBSResourceUtilization object:

  $result = $service_obj->Method(...);
  $result->Att1->EbsReadBytesPerSecond

=head1 DESCRIPTION

The EBS field that contains a list of EBS metrics associated with the
current instance.

=head1 ATTRIBUTES


=head2 EbsReadBytesPerSecond => Str

The maximum size of read operations per second


=head2 EbsReadOpsPerSecond => Str

The maximum number of read operations per second.


=head2 EbsWriteBytesPerSecond => Str

The maximum size of write operations per second.


=head2 EbsWriteOpsPerSecond => Str

The maximum number of write operations per second.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

