use strict;
use Test::More;
use Vector::QRCode::EPS;

can_ok 'Vector::QRCode::EPS', 'generate';

my $data = Vector::QRCode::EPS->generate(
    text => 'This is a test',
);
isa_ok $data, 'PostScript::Simple';

my $expect = do {local $/; <DATA>};
like $data->get, qr/$expect/, 'expected data';
$data->output('/tmp/doa.eps');

done_testing;

__DATA__
0.0392156862745098 0.0392156862745098 0.0392156862745098 setrgbcolor
0 ux 0 uy 0.476190476190476 ux 0.476190476190476 uy box fill
0.476190476190476 ux 0 uy 0.952380952380952 ux 0.476190476190476 uy box fill
0.952380952380952 ux 0 uy 1.42857142857143 ux 0.476190476190476 uy box fill
1.42857142857143 ux 0 uy 1.9047619047619 ux 0.476190476190476 uy box fill
1.9047619047619 ux 0 uy 2.38095238095238 ux 0.476190476190476 uy box fill
2.38095238095238 ux 0 uy 2.85714285714286 ux 0.476190476190476 uy box fill
2.85714285714286 ux 0 uy 3.33333333333333 ux 0.476190476190476 uy box fill
3.80952380952381 ux 0 uy 4.28571428571429 ux 0.476190476190476 uy box fill
4.28571428571429 ux 0 uy 4.76190476190476 ux 0.476190476190476 uy box fill
5.23809523809524 ux 0 uy 5.71428571428571 ux 0.476190476190476 uy box fill
5.71428571428571 ux 0 uy 6.19047619047619 ux 0.476190476190476 uy box fill
6.19047619047619 ux 0 uy 6.66666666666667 ux 0.476190476190476 uy box fill
7.61904761904762 ux 0 uy 8.09523809523809 ux 0.476190476190476 uy box fill
9.04761904761905 ux 0 uy 9.52380952380952 ux 0.476190476190476 uy box fill
9.52380952380952 ux 0 uy 10 ux 0.476190476190476 uy box fill
0 ux 0.476190476190476 uy 0.476190476190476 ux 0.952380952380952 uy box fill
2.85714285714286 ux 0.476190476190476 uy 3.33333333333333 ux 0.952380952380952 uy box fill
3.80952380952381 ux 0.476190476190476 uy 4.28571428571429 ux 0.952380952380952 uy box fill
4.76190476190476 ux 0.476190476190476 uy 5.23809523809524 ux 0.952380952380952 uy box fill
5.23809523809524 ux 0.476190476190476 uy 5.71428571428571 ux 0.952380952380952 uy box fill
7.14285714285714 ux 0.476190476190476 uy 7.61904761904762 ux 0.952380952380952 uy box fill
8.09523809523809 ux 0.476190476190476 uy 8.57142857142857 ux 0.952380952380952 uy box fill
9.04761904761905 ux 0.476190476190476 uy 9.52380952380952 ux 0.952380952380952 uy box fill
0 ux 0.952380952380952 uy 0.476190476190476 ux 1.42857142857143 uy box fill
0.952380952380952 ux 0.952380952380952 uy 1.42857142857143 ux 1.42857142857143 uy box fill
1.42857142857143 ux 0.952380952380952 uy 1.9047619047619 ux 1.42857142857143 uy box fill
1.9047619047619 ux 0.952380952380952 uy 2.38095238095238 ux 1.42857142857143 uy box fill
2.85714285714286 ux 0.952380952380952 uy 3.33333333333333 ux 1.42857142857143 uy box fill
3.80952380952381 ux 0.952380952380952 uy 4.28571428571429 ux 1.42857142857143 uy box fill
5.23809523809524 ux 0.952380952380952 uy 5.71428571428571 ux 1.42857142857143 uy box fill
5.71428571428571 ux 0.952380952380952 uy 6.19047619047619 ux 1.42857142857143 uy box fill
6.66666666666667 ux 0.952380952380952 uy 7.14285714285714 ux 1.42857142857143 uy box fill
7.14285714285714 ux 0.952380952380952 uy 7.61904761904762 ux 1.42857142857143 uy box fill
7.61904761904762 ux 0.952380952380952 uy 8.09523809523809 ux 1.42857142857143 uy box fill
8.09523809523809 ux 0.952380952380952 uy 8.57142857142857 ux 1.42857142857143 uy box fill
9.52380952380952 ux 0.952380952380952 uy 10 ux 1.42857142857143 uy box fill
0 ux 1.42857142857143 uy 0.476190476190476 ux 1.9047619047619 uy box fill
0.952380952380952 ux 1.42857142857143 uy 1.42857142857143 ux 1.9047619047619 uy box fill
1.42857142857143 ux 1.42857142857143 uy 1.9047619047619 ux 1.9047619047619 uy box fill
1.9047619047619 ux 1.42857142857143 uy 2.38095238095238 ux 1.9047619047619 uy box fill
2.85714285714286 ux 1.42857142857143 uy 3.33333333333333 ux 1.9047619047619 uy box fill
4.28571428571429 ux 1.42857142857143 uy 4.76190476190476 ux 1.9047619047619 uy box fill
5.23809523809524 ux 1.42857142857143 uy 5.71428571428571 ux 1.9047619047619 uy box fill
5.71428571428571 ux 1.42857142857143 uy 6.19047619047619 ux 1.9047619047619 uy box fill
6.19047619047619 ux 1.42857142857143 uy 6.66666666666667 ux 1.9047619047619 uy box fill
7.14285714285714 ux 1.42857142857143 uy 7.61904761904762 ux 1.9047619047619 uy box fill
7.61904761904762 ux 1.42857142857143 uy 8.09523809523809 ux 1.9047619047619 uy box fill
8.09523809523809 ux 1.42857142857143 uy 8.57142857142857 ux 1.9047619047619 uy box fill
9.04761904761905 ux 1.42857142857143 uy 9.52380952380952 ux 1.9047619047619 uy box fill
0 ux 1.9047619047619 uy 0.476190476190476 ux 2.38095238095238 uy box fill
0.952380952380952 ux 1.9047619047619 uy 1.42857142857143 ux 2.38095238095238 uy box fill
1.42857142857143 ux 1.9047619047619 uy 1.9047619047619 ux 2.38095238095238 uy box fill
1.9047619047619 ux 1.9047619047619 uy 2.38095238095238 ux 2.38095238095238 uy box fill
2.85714285714286 ux 1.9047619047619 uy 3.33333333333333 ux 2.38095238095238 uy box fill
3.80952380952381 ux 1.9047619047619 uy 4.28571428571429 ux 2.38095238095238 uy box fill
4.28571428571429 ux 1.9047619047619 uy 4.76190476190476 ux 2.38095238095238 uy box fill
5.23809523809524 ux 1.9047619047619 uy 5.71428571428571 ux 2.38095238095238 uy box fill
5.71428571428571 ux 1.9047619047619 uy 6.19047619047619 ux 2.38095238095238 uy box fill
8.09523809523809 ux 1.9047619047619 uy 8.57142857142857 ux 2.38095238095238 uy box fill
9.04761904761905 ux 1.9047619047619 uy 9.52380952380952 ux 2.38095238095238 uy box fill
0 ux 2.38095238095238 uy 0.476190476190476 ux 2.85714285714286 uy box fill
2.85714285714286 ux 2.38095238095238 uy 3.33333333333333 ux 2.85714285714286 uy box fill
3.80952380952381 ux 2.38095238095238 uy 4.28571428571429 ux 2.85714285714286 uy box fill
4.28571428571429 ux 2.38095238095238 uy 4.76190476190476 ux 2.85714285714286 uy box fill
6.19047619047619 ux 2.38095238095238 uy 6.66666666666667 ux 2.85714285714286 uy box fill
9.04761904761905 ux 2.38095238095238 uy 9.52380952380952 ux 2.85714285714286 uy box fill
9.52380952380952 ux 2.38095238095238 uy 10 ux 2.85714285714286 uy box fill
0 ux 2.85714285714286 uy 0.476190476190476 ux 3.33333333333333 uy box fill
0.476190476190476 ux 2.85714285714286 uy 0.952380952380952 ux 3.33333333333333 uy box fill
0.952380952380952 ux 2.85714285714286 uy 1.42857142857143 ux 3.33333333333333 uy box fill
1.42857142857143 ux 2.85714285714286 uy 1.9047619047619 ux 3.33333333333333 uy box fill
1.9047619047619 ux 2.85714285714286 uy 2.38095238095238 ux 3.33333333333333 uy box fill
2.38095238095238 ux 2.85714285714286 uy 2.85714285714286 ux 3.33333333333333 uy box fill
2.85714285714286 ux 2.85714285714286 uy 3.33333333333333 ux 3.33333333333333 uy box fill
3.80952380952381 ux 2.85714285714286 uy 4.28571428571429 ux 3.33333333333333 uy box fill
4.28571428571429 ux 2.85714285714286 uy 4.76190476190476 ux 3.33333333333333 uy box fill
5.23809523809524 ux 2.85714285714286 uy 5.71428571428571 ux 3.33333333333333 uy box fill
5.71428571428571 ux 2.85714285714286 uy 6.19047619047619 ux 3.33333333333333 uy box fill
6.19047619047619 ux 2.85714285714286 uy 6.66666666666667 ux 3.33333333333333 uy box fill
6.66666666666667 ux 2.85714285714286 uy 7.14285714285714 ux 3.33333333333333 uy box fill
7.14285714285714 ux 2.85714285714286 uy 7.61904761904762 ux 3.33333333333333 uy box fill
7.61904761904762 ux 2.85714285714286 uy 8.09523809523809 ux 3.33333333333333 uy box fill
8.09523809523809 ux 2.85714285714286 uy 8.57142857142857 ux 3.33333333333333 uy box fill
8.57142857142857 ux 2.85714285714286 uy 9.04761904761905 ux 3.33333333333333 uy box fill
9.04761904761905 ux 2.85714285714286 uy 9.52380952380952 ux 3.33333333333333 uy box fill
9.52380952380952 ux 2.85714285714286 uy 10 ux 3.33333333333333 uy box fill
3.80952380952381 ux 3.33333333333333 uy 4.28571428571429 ux 3.80952380952381 uy box fill
4.28571428571429 ux 3.33333333333333 uy 4.76190476190476 ux 3.80952380952381 uy box fill
5.71428571428571 ux 3.33333333333333 uy 6.19047619047619 ux 3.80952380952381 uy box fill
6.19047619047619 ux 3.33333333333333 uy 6.66666666666667 ux 3.80952380952381 uy box fill
7.61904761904762 ux 3.33333333333333 uy 8.09523809523809 ux 3.80952380952381 uy box fill
8.09523809523809 ux 3.33333333333333 uy 8.57142857142857 ux 3.80952380952381 uy box fill
8.57142857142857 ux 3.33333333333333 uy 9.04761904761905 ux 3.80952380952381 uy box fill
0.476190476190476 ux 3.80952380952381 uy 0.952380952380952 ux 4.28571428571429 uy box fill
0.952380952380952 ux 3.80952380952381 uy 1.42857142857143 ux 4.28571428571429 uy box fill
1.42857142857143 ux 3.80952380952381 uy 1.9047619047619 ux 4.28571428571429 uy box fill
1.9047619047619 ux 3.80952380952381 uy 2.38095238095238 ux 4.28571428571429 uy box fill
2.85714285714286 ux 3.80952380952381 uy 3.33333333333333 ux 4.28571428571429 uy box fill
4.28571428571429 ux 3.80952380952381 uy 4.76190476190476 ux 4.28571428571429 uy box fill
4.76190476190476 ux 3.80952380952381 uy 5.23809523809524 ux 4.28571428571429 uy box fill
5.71428571428571 ux 3.80952380952381 uy 6.19047619047619 ux 4.28571428571429 uy box fill
7.61904761904762 ux 3.80952380952381 uy 8.09523809523809 ux 4.28571428571429 uy box fill
9.04761904761905 ux 3.80952380952381 uy 9.52380952380952 ux 4.28571428571429 uy box fill
9.52380952380952 ux 3.80952380952381 uy 10 ux 4.28571428571429 uy box fill
0.476190476190476 ux 4.28571428571429 uy 0.952380952380952 ux 4.76190476190476 uy box fill
1.42857142857143 ux 4.28571428571429 uy 1.9047619047619 ux 4.76190476190476 uy box fill
1.9047619047619 ux 4.28571428571429 uy 2.38095238095238 ux 4.76190476190476 uy box fill
3.33333333333333 ux 4.28571428571429 uy 3.80952380952381 ux 4.76190476190476 uy box fill
3.80952380952381 ux 4.28571428571429 uy 4.28571428571429 ux 4.76190476190476 uy box fill
5.71428571428571 ux 4.28571428571429 uy 6.19047619047619 ux 4.76190476190476 uy box fill
7.61904761904762 ux 4.28571428571429 uy 8.09523809523809 ux 4.76190476190476 uy box fill
9.04761904761905 ux 4.28571428571429 uy 9.52380952380952 ux 4.76190476190476 uy box fill
0 ux 4.76190476190476 uy 0.476190476190476 ux 5.23809523809524 uy box fill
0.952380952380952 ux 4.76190476190476 uy 1.42857142857143 ux 5.23809523809524 uy box fill
1.42857142857143 ux 4.76190476190476 uy 1.9047619047619 ux 5.23809523809524 uy box fill
2.38095238095238 ux 4.76190476190476 uy 2.85714285714286 ux 5.23809523809524 uy box fill
2.85714285714286 ux 4.76190476190476 uy 3.33333333333333 ux 5.23809523809524 uy box fill
4.76190476190476 ux 4.76190476190476 uy 5.23809523809524 ux 5.23809523809524 uy box fill
5.23809523809524 ux 4.76190476190476 uy 5.71428571428571 ux 5.23809523809524 uy box fill
5.71428571428571 ux 4.76190476190476 uy 6.19047619047619 ux 5.23809523809524 uy box fill
6.66666666666667 ux 4.76190476190476 uy 7.14285714285714 ux 5.23809523809524 uy box fill
7.61904761904762 ux 4.76190476190476 uy 8.09523809523809 ux 5.23809523809524 uy box fill
8.57142857142857 ux 4.76190476190476 uy 9.04761904761905 ux 5.23809523809524 uy box fill
9.04761904761905 ux 4.76190476190476 uy 9.52380952380952 ux 5.23809523809524 uy box fill
9.52380952380952 ux 4.76190476190476 uy 10 ux 5.23809523809524 uy box fill
0.476190476190476 ux 5.23809523809524 uy 0.952380952380952 ux 5.71428571428571 uy box fill
0.952380952380952 ux 5.23809523809524 uy 1.42857142857143 ux 5.71428571428571 uy box fill
1.42857142857143 ux 5.23809523809524 uy 1.9047619047619 ux 5.71428571428571 uy box fill
2.38095238095238 ux 5.23809523809524 uy 2.85714285714286 ux 5.71428571428571 uy box fill
3.33333333333333 ux 5.23809523809524 uy 3.80952380952381 ux 5.71428571428571 uy box fill
4.28571428571429 ux 5.23809523809524 uy 4.76190476190476 ux 5.71428571428571 uy box fill
5.71428571428571 ux 5.23809523809524 uy 6.19047619047619 ux 5.71428571428571 uy box fill
6.19047619047619 ux 5.23809523809524 uy 6.66666666666667 ux 5.71428571428571 uy box fill
7.14285714285714 ux 5.23809523809524 uy 7.61904761904762 ux 5.71428571428571 uy box fill
7.61904761904762 ux 5.23809523809524 uy 8.09523809523809 ux 5.71428571428571 uy box fill
8.09523809523809 ux 5.23809523809524 uy 8.57142857142857 ux 5.71428571428571 uy box fill
8.57142857142857 ux 5.23809523809524 uy 9.04761904761905 ux 5.71428571428571 uy box fill
9.04761904761905 ux 5.23809523809524 uy 9.52380952380952 ux 5.71428571428571 uy box fill
9.52380952380952 ux 5.23809523809524 uy 10 ux 5.71428571428571 uy box fill
0 ux 5.71428571428571 uy 0.476190476190476 ux 6.19047619047619 uy box fill
0.476190476190476 ux 5.71428571428571 uy 0.952380952380952 ux 6.19047619047619 uy box fill
0.952380952380952 ux 5.71428571428571 uy 1.42857142857143 ux 6.19047619047619 uy box fill
1.9047619047619 ux 5.71428571428571 uy 2.38095238095238 ux 6.19047619047619 uy box fill
2.38095238095238 ux 5.71428571428571 uy 2.85714285714286 ux 6.19047619047619 uy box fill
2.85714285714286 ux 5.71428571428571 uy 3.33333333333333 ux 6.19047619047619 uy box fill
3.33333333333333 ux 5.71428571428571 uy 3.80952380952381 ux 6.19047619047619 uy box fill
3.80952380952381 ux 5.71428571428571 uy 4.28571428571429 ux 6.19047619047619 uy box fill
4.76190476190476 ux 5.71428571428571 uy 5.23809523809524 ux 6.19047619047619 uy box fill
5.23809523809524 ux 5.71428571428571 uy 5.71428571428571 ux 6.19047619047619 uy box fill
5.71428571428571 ux 5.71428571428571 uy 6.19047619047619 ux 6.19047619047619 uy box fill
6.19047619047619 ux 5.71428571428571 uy 6.66666666666667 ux 6.19047619047619 uy box fill
6.66666666666667 ux 5.71428571428571 uy 7.14285714285714 ux 6.19047619047619 uy box fill
8.57142857142857 ux 5.71428571428571 uy 9.04761904761905 ux 6.19047619047619 uy box fill
3.80952380952381 ux 6.19047619047619 uy 4.28571428571429 ux 6.66666666666667 uy box fill
4.76190476190476 ux 6.19047619047619 uy 5.23809523809524 ux 6.66666666666667 uy box fill
5.23809523809524 ux 6.19047619047619 uy 5.71428571428571 ux 6.66666666666667 uy box fill
0 ux 6.66666666666667 uy 0.476190476190476 ux 7.14285714285714 uy box fill
0.476190476190476 ux 6.66666666666667 uy 0.952380952380952 ux 7.14285714285714 uy box fill
0.952380952380952 ux 6.66666666666667 uy 1.42857142857143 ux 7.14285714285714 uy box fill
1.42857142857143 ux 6.66666666666667 uy 1.9047619047619 ux 7.14285714285714 uy box fill
1.9047619047619 ux 6.66666666666667 uy 2.38095238095238 ux 7.14285714285714 uy box fill
2.38095238095238 ux 6.66666666666667 uy 2.85714285714286 ux 7.14285714285714 uy box fill
2.85714285714286 ux 6.66666666666667 uy 3.33333333333333 ux 7.14285714285714 uy box fill
3.80952380952381 ux 6.66666666666667 uy 4.28571428571429 ux 7.14285714285714 uy box fill
4.76190476190476 ux 6.66666666666667 uy 5.23809523809524 ux 7.14285714285714 uy box fill
5.71428571428571 ux 6.66666666666667 uy 6.19047619047619 ux 7.14285714285714 uy box fill
6.66666666666667 ux 6.66666666666667 uy 7.14285714285714 ux 7.14285714285714 uy box fill
7.14285714285714 ux 6.66666666666667 uy 7.61904761904762 ux 7.14285714285714 uy box fill
7.61904761904762 ux 6.66666666666667 uy 8.09523809523809 ux 7.14285714285714 uy box fill
8.09523809523809 ux 6.66666666666667 uy 8.57142857142857 ux 7.14285714285714 uy box fill
8.57142857142857 ux 6.66666666666667 uy 9.04761904761905 ux 7.14285714285714 uy box fill
9.04761904761905 ux 6.66666666666667 uy 9.52380952380952 ux 7.14285714285714 uy box fill
9.52380952380952 ux 6.66666666666667 uy 10 ux 7.14285714285714 uy box fill
0 ux 7.14285714285714 uy 0.476190476190476 ux 7.61904761904762 uy box fill
2.85714285714286 ux 7.14285714285714 uy 3.33333333333333 ux 7.61904761904762 uy box fill
4.28571428571429 ux 7.14285714285714 uy 4.76190476190476 ux 7.61904761904762 uy box fill
4.76190476190476 ux 7.14285714285714 uy 5.23809523809524 ux 7.61904761904762 uy box fill
5.23809523809524 ux 7.14285714285714 uy 5.71428571428571 ux 7.61904761904762 uy box fill
6.66666666666667 ux 7.14285714285714 uy 7.14285714285714 ux 7.61904761904762 uy box fill
9.52380952380952 ux 7.14285714285714 uy 10 ux 7.61904761904762 uy box fill
0 ux 7.61904761904762 uy 0.476190476190476 ux 8.09523809523809 uy box fill
0.952380952380952 ux 7.61904761904762 uy 1.42857142857143 ux 8.09523809523809 uy box fill
1.42857142857143 ux 7.61904761904762 uy 1.9047619047619 ux 8.09523809523809 uy box fill
1.9047619047619 ux 7.61904761904762 uy 2.38095238095238 ux 8.09523809523809 uy box fill
2.85714285714286 ux 7.61904761904762 uy 3.33333333333333 ux 8.09523809523809 uy box fill
4.28571428571429 ux 7.61904761904762 uy 4.76190476190476 ux 8.09523809523809 uy box fill
5.71428571428571 ux 7.61904761904762 uy 6.19047619047619 ux 8.09523809523809 uy box fill
6.66666666666667 ux 7.61904761904762 uy 7.14285714285714 ux 8.09523809523809 uy box fill
7.61904761904762 ux 7.61904761904762 uy 8.09523809523809 ux 8.09523809523809 uy box fill
8.09523809523809 ux 7.61904761904762 uy 8.57142857142857 ux 8.09523809523809 uy box fill
8.57142857142857 ux 7.61904761904762 uy 9.04761904761905 ux 8.09523809523809 uy box fill
9.52380952380952 ux 7.61904761904762 uy 10 ux 8.09523809523809 uy box fill
0 ux 8.09523809523809 uy 0.476190476190476 ux 8.57142857142857 uy box fill
0.952380952380952 ux 8.09523809523809 uy 1.42857142857143 ux 8.57142857142857 uy box fill
1.42857142857143 ux 8.09523809523809 uy 1.9047619047619 ux 8.57142857142857 uy box fill
1.9047619047619 ux 8.09523809523809 uy 2.38095238095238 ux 8.57142857142857 uy box fill
2.85714285714286 ux 8.09523809523809 uy 3.33333333333333 ux 8.57142857142857 uy box fill
5.71428571428571 ux 8.09523809523809 uy 6.19047619047619 ux 8.57142857142857 uy box fill
6.66666666666667 ux 8.09523809523809 uy 7.14285714285714 ux 8.57142857142857 uy box fill
7.61904761904762 ux 8.09523809523809 uy 8.09523809523809 ux 8.57142857142857 uy box fill
8.09523809523809 ux 8.09523809523809 uy 8.57142857142857 ux 8.57142857142857 uy box fill
8.57142857142857 ux 8.09523809523809 uy 9.04761904761905 ux 8.57142857142857 uy box fill
9.52380952380952 ux 8.09523809523809 uy 10 ux 8.57142857142857 uy box fill
0 ux 8.57142857142857 uy 0.476190476190476 ux 9.04761904761905 uy box fill
0.952380952380952 ux 8.57142857142857 uy 1.42857142857143 ux 9.04761904761905 uy box fill
1.42857142857143 ux 8.57142857142857 uy 1.9047619047619 ux 9.04761904761905 uy box fill
1.9047619047619 ux 8.57142857142857 uy 2.38095238095238 ux 9.04761904761905 uy box fill
2.85714285714286 ux 8.57142857142857 uy 3.33333333333333 ux 9.04761904761905 uy box fill
3.80952380952381 ux 8.57142857142857 uy 4.28571428571429 ux 9.04761904761905 uy box fill
4.76190476190476 ux 8.57142857142857 uy 5.23809523809524 ux 9.04761904761905 uy box fill
6.66666666666667 ux 8.57142857142857 uy 7.14285714285714 ux 9.04761904761905 uy box fill
7.61904761904762 ux 8.57142857142857 uy 8.09523809523809 ux 9.04761904761905 uy box fill
8.09523809523809 ux 8.57142857142857 uy 8.57142857142857 ux 9.04761904761905 uy box fill
8.57142857142857 ux 8.57142857142857 uy 9.04761904761905 ux 9.04761904761905 uy box fill
9.52380952380952 ux 8.57142857142857 uy 10 ux 9.04761904761905 uy box fill
0 ux 9.04761904761905 uy 0.476190476190476 ux 9.52380952380952 uy box fill
2.85714285714286 ux 9.04761904761905 uy 3.33333333333333 ux 9.52380952380952 uy box fill
5.71428571428571 ux 9.04761904761905 uy 6.19047619047619 ux 9.52380952380952 uy box fill
6.66666666666667 ux 9.04761904761905 uy 7.14285714285714 ux 9.52380952380952 uy box fill
9.52380952380952 ux 9.04761904761905 uy 10 ux 9.52380952380952 uy box fill
0 ux 9.52380952380952 uy 0.476190476190476 ux 10 uy box fill
0.476190476190476 ux 9.52380952380952 uy 0.952380952380952 ux 10 uy box fill
0.952380952380952 ux 9.52380952380952 uy 1.42857142857143 ux 10 uy box fill
1.42857142857143 ux 9.52380952380952 uy 1.9047619047619 ux 10 uy box fill
1.9047619047619 ux 9.52380952380952 uy 2.38095238095238 ux 10 uy box fill
2.38095238095238 ux 9.52380952380952 uy 2.85714285714286 ux 10 uy box fill
2.85714285714286 ux 9.52380952380952 uy 3.33333333333333 ux 10 uy box fill
4.76190476190476 ux 9.52380952380952 uy 5.23809523809524 ux 10 uy box fill
5.71428571428571 ux 9.52380952380952 uy 6.19047619047619 ux 10 uy box fill
6.66666666666667 ux 9.52380952380952 uy 7.14285714285714 ux 10 uy box fill
7.14285714285714 ux 9.52380952380952 uy 7.61904761904762 ux 10 uy box fill
7.61904761904762 ux 9.52380952380952 uy 8.09523809523809 ux 10 uy box fill
8.09523809523809 ux 9.52380952380952 uy 8.57142857142857 ux 10 uy box fill
8.57142857142857 ux 9.52380952380952 uy 9.04761904761905 ux 10 uy box fill
9.04761904761905 ux 9.52380952380952 uy 9.52380952380952 ux 10 uy box fill
9.52380952380952 ux 9.52380952380952 uy 10 ux 10 uy box fill
%%EOF
