# Generated by default/object.tt
package Paws::CloudFront::OriginRequestPolicy;
  use Moose;
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has LastModifiedTime => (is => 'ro', isa => 'Str', required => 1);
  has OriginRequestPolicyConfig => (is => 'ro', isa => 'Paws::CloudFront::OriginRequestPolicyConfig', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::OriginRequestPolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::OriginRequestPolicy object:

  $service_obj->Method(Att1 => { Id => $value, ..., OriginRequestPolicyConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::OriginRequestPolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->Id

=head1 DESCRIPTION

An origin request policy.

When itE<rsquo>s attached to a cache behavior, the origin request
policy determines the values that CloudFront includes in requests that
it sends to the origin. Each request that CloudFront sends to the
origin includes the following:

=over

=item *

The request body and the URL path (without the domain name) from the
viewer request.

=item *

The headers that CloudFront automatically includes in every origin
request, including C<Host>, C<User-Agent>, and C<X-Amz-Cf-Id>.

=item *

All HTTP headers, cookies, and URL query strings that are specified in
the cache policy or the origin request policy. These can include items
from the viewer request and, in the case of headers, additional ones
that are added by CloudFront.

=back

CloudFront sends a request when it canE<rsquo>t find an object in its
cache that matches the request. If you want to send values to the
origin and also include them in the cache key, use C<CachePolicy>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Id => Str

The unique identifier for the origin request policy.


=head2 B<REQUIRED> LastModifiedTime => Str

The date and time when the origin request policy was last modified.


=head2 B<REQUIRED> OriginRequestPolicyConfig => L<Paws::CloudFront::OriginRequestPolicyConfig>

The origin request policy configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

