/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.dbd.jdbc;

import com.vizdom.ber.BerIdentifier;
import com.vizdom.ber.BerNull;
import com.vizdom.ber.BerObject;
import com.vizdom.ber.BerObjectFactory;
import com.vizdom.ber.BerOctetString;
import com.vizdom.ber.BerSequence;
import com.vizdom.dbd.jdbc.BerHash;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class ConnectRequest
extends BerSequence {
    static final BerIdentifier gIDENTIFIER = new BerIdentifier(64, 32, 11);
    static final BerObjectFactory gFACTORY = new BerObjectFactory(){

        @Override
        public boolean acceptsIdentifier(BerIdentifier anIdentifier) {
            return anIdentifier.equals(gIDENTIFIER);
        }

        @Override
        public BerObject createBerObject() {
            return new ConnectRequest();
        }
    };
    private static final int sURL = 0;
    private static final int sUSERNAME = 1;
    private static final int sPASSWORD = 2;
    private static final int sCHARACTER_ENCODING = 3;
    private static final int sPROPERTIES = 4;

    private ConnectRequest() {
    }

    String getURL(String aCharacterEncoding) throws UnsupportedEncodingException {
        return ((BerOctetString)this.mSequence[0]).toString(aCharacterEncoding);
    }

    String getUser(String aCharacterEncoding) throws UnsupportedEncodingException {
        if (this.mSequence[1] instanceof BerNull) {
            return null;
        }
        return ((BerOctetString)this.mSequence[1]).toString(aCharacterEncoding);
    }

    String getPassword(String aCharacterEncoding) throws UnsupportedEncodingException {
        if (this.mSequence[2] instanceof BerNull) {
            return null;
        }
        return ((BerOctetString)this.mSequence[2]).toString(aCharacterEncoding);
    }

    String getCharacterEncoding() throws UnsupportedEncodingException {
        return ((BerOctetString)this.mSequence[3]).toString("ASCII");
    }

    Properties getProperties(String aCharacterEncoding) throws UnsupportedEncodingException {
        Hashtable<String, String> h = ((BerHash)this.mSequence[4]).toHashtable(aCharacterEncoding);
        Properties p = new Properties();
        Enumeration<String> keys = h.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            p.put(key, h.get(key));
        }
        return p;
    }

    @Override
    public BerIdentifier getIdentifier() {
        return gIDENTIFIER;
    }

    @Override
    public String toString() {
        return "Connect";
    }
}

