/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.ber;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class BerContentsInputStream
extends FilterInputStream {
    private final int mMaxCount;
    private int mCount = 0;

    BerContentsInputStream(InputStream anIn, int aMaxCount) {
        super(anIn);
        this.mMaxCount = aMaxCount;
    }

    public int getCount() {
        return this.mCount;
    }

    @Override
    public int read() throws IOException {
        if (this.mCount == this.mMaxCount) {
            return -1;
        }
        int b = this.in.read();
        if (b != -1) {
            ++this.mCount;
        }
        return b;
    }

    @Override
    public int read(byte[] aBuffer, int anOffset, int aLength) throws IOException {
        if (this.mCount == this.mMaxCount) {
            return -1;
        }
        int length = Math.min(aLength, this.mMaxCount - this.mCount);
        int count = this.in.read(aBuffer, anOffset, length);
        if (count != -1) {
            this.mCount += count;
        }
        return count;
    }
}

