/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.List;

public final class KeepLargestBlockFilter
implements BoilerpipeFilter {
    public static final KeepLargestBlockFilter INSTANCE = new KeepLargestBlockFilter();

    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        int maxNumWords = -1;
        TextBlock largestBlock = null;
        for (TextBlock tb : textBlocks) {
            if (!tb.isContent() || tb.getNumWords() <= maxNumWords) continue;
            largestBlock = tb;
            maxNumWords = tb.getNumWords();
        }
        for (TextBlock tb : textBlocks) {
            if (tb == largestBlock) {
                tb.setIsContent(true);
                continue;
            }
            tb.setIsContent(false);
            tb.addLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT");
        }
        return true;
    }
}

