
=begin comment

Smartcat Integration API

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: v1

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program.
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package Smartcat::Client::TranslationMemoriesApi;

require 5.6.0;
use strict;
use warnings;
use utf8;
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use Smartcat::Client::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata( 'method_documentation' => {} );

sub new {
    my $class = shift;
    my $api_client;

    if ( $_[0] && ref $_[0] && ref $_[0] eq 'Smartcat::Client::ApiClient' ) {
        $api_client = $_[0];
    }
    else {
        $api_client = Smartcat::Client::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}

#
# translation_memories_create_empty_tm
#
#
#
# @param CreateTranslationMemoryModel $model  (required)
{
    my $params = {
        'model' => {
            data_type   => 'CreateTranslationMemoryModel',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'translation_memories_create_empty_tm'}
      = {
        summary => '',
        params  => $params,
        returns => 'string',
      };
}

# @return string
#
sub translation_memories_create_empty_tm {
    my ( $self, %args ) = @_;

    # verify the required parameter 'model' is set
    unless ( exists $args{'model'} ) {
        croak(
"Missing the required parameter 'model' when calling translation_memories_create_empty_tm"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/translationmemory';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}
      ->select_header_content_type( 'application/json', 'text/json' );

    my $_body_data;

    # body params
    if ( exists $args{'model'} ) {
        $_body_data = $args{'model'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'string', $response );
    return $_response_object;
}

#
# translation_memories_export_file
#
#
#
# @param string $tm_id  (required)
# @param string $export_mode  (required)
# @param boolean $with_tags  (required)
{
    my $params = {
        'tm_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
        'export_mode' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
        'with_tags' => {
            data_type   => 'boolean',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'translation_memories_export_file'} = {
        summary => '',
        params  => $params,
        returns => 'Object',
    };
}

# @return Object
#
sub translation_memories_export_file {
    my ( $self, %args ) = @_;

    # verify the required parameter 'tm_id' is set
    unless ( exists $args{'tm_id'} ) {
        croak(
"Missing the required parameter 'tm_id' when calling translation_memories_export_file"
        );
    }

    # verify the required parameter 'export_mode' is set
    unless ( exists $args{'export_mode'} ) {
        croak(
"Missing the required parameter 'export_mode' when calling translation_memories_export_file"
        );
    }

    # verify the required parameter 'with_tags' is set
    unless ( exists $args{'with_tags'} ) {
        croak(
"Missing the required parameter 'with_tags' when calling translation_memories_export_file"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/translationmemory/{tmId}/file';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'export_mode'} ) {
        $query_params->{'exportMode'} =
          $self->{api_client}->to_query_value( $args{'export_mode'} );
    }

    # query params
    if ( exists $args{'with_tags'} ) {
        $query_params->{'withTags'} =
          $self->{api_client}->to_query_value( $args{'with_tags'} );
    }

    # path params
    if ( exists $args{'tm_id'} ) {
        my $_base_variable = "{" . "tmId" . "}";
        my $_base_value = $self->{api_client}->to_path_value( $args{'tm_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'Object', $response );
    return $_response_object;
}

#
# translation_memories_get_meta_info
#
# Receiving TM details
#
# @param string $tm_id TM ID (required)
{
    my $params = {
        'tm_id' => {
            data_type   => 'string',
            description => 'TM ID',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'translation_memories_get_meta_info'} =
      {
        summary => 'Receiving TM details',
        params  => $params,
        returns => 'TranslationMemoryModel',
      };
}

# @return TranslationMemoryModel
#
sub translation_memories_get_meta_info {
    my ( $self, %args ) = @_;

    # verify the required parameter 'tm_id' is set
    unless ( exists $args{'tm_id'} ) {
        croak(
"Missing the required parameter 'tm_id' when calling translation_memories_get_meta_info"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/translationmemory/{tmId}';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'tm_id'} ) {
        my $_base_variable = "{" . "tmId" . "}";
        my $_base_value = $self->{api_client}->to_path_value( $args{'tm_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'TranslationMemoryModel', $response );
    return $_response_object;
}

#
# translation_memories_get_pending_tasks
#
# Receive a collection of TMX import tasks
#
{
    my $params = {};
    __PACKAGE__->method_documentation->{
        'translation_memories_get_pending_tasks'} = {
        summary => 'Receive a collection of TMX import tasks',
        params  => $params,
        returns => 'ARRAY[TMImportTaskModel]',
        };
}

# @return ARRAY[TMImportTaskModel]
#
sub translation_memories_get_pending_tasks {
    my ( $self, %args ) = @_;

    # parse inputs
    my $_resource_path = '/api/integration/v1/translationmemory/task';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'ARRAY[TMImportTaskModel]', $response );
    return $_response_object;
}

#
# translation_memories_get_tm_translations
#
#
#
# @param TMMatchesRequest $request  (required)
# @param string $tm_id  (required)
{
    my $params = {
        'request' => {
            data_type   => 'TMMatchesRequest',
            description => '',
            required    => '1',
        },
        'tm_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{
        'translation_memories_get_tm_translations'} = {
        summary => '',
        params  => $params,
        returns => 'SegmentWithMatchesModel',
        };
}

# @return SegmentWithMatchesModel
#
sub translation_memories_get_tm_translations {
    my ( $self, %args ) = @_;

    # verify the required parameter 'request' is set
    unless ( exists $args{'request'} ) {
        croak(
"Missing the required parameter 'request' when calling translation_memories_get_tm_translations"
        );
    }

    # verify the required parameter 'tm_id' is set
    unless ( exists $args{'tm_id'} ) {
        croak(
"Missing the required parameter 'tm_id' when calling translation_memories_get_tm_translations"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/translationmemory/matches';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}
      ->select_header_content_type( 'application/json', 'text/json' );

    # query params
    if ( exists $args{'tm_id'} ) {
        $query_params->{'tmId'} =
          $self->{api_client}->to_query_value( $args{'tm_id'} );
    }

    my $_body_data;

    # body params
    if ( exists $args{'request'} ) {
        $_body_data = $args{'request'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'SegmentWithMatchesModel', $response );
    return $_response_object;
}

#
# translation_memories_get_translation_memories_batch
#
#
#
# @param string $last_processed_id  (required)
# @param int $batch_size  (required)
# @param string $source_language  (optional)
# @param string $target_language  (optional)
# @param string $client_id  (optional)
# @param string $search_name  (optional)
{
    my $params = {
        'last_processed_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
        'batch_size' => {
            data_type   => 'int',
            description => '',
            required    => '1',
        },
        'source_language' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
        'target_language' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
        'client_id' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
        'search_name' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
    };
    __PACKAGE__->method_documentation->{
        'translation_memories_get_translation_memories_batch'} = {
        summary => '',
        params  => $params,
        returns => 'ARRAY[TranslationMemoryModel]',
        };
}

# @return ARRAY[TranslationMemoryModel]
#
sub translation_memories_get_translation_memories_batch {
    my ( $self, %args ) = @_;

    # verify the required parameter 'last_processed_id' is set
    unless ( exists $args{'last_processed_id'} ) {
        croak(
"Missing the required parameter 'last_processed_id' when calling translation_memories_get_translation_memories_batch"
        );
    }

    # verify the required parameter 'batch_size' is set
    unless ( exists $args{'batch_size'} ) {
        croak(
"Missing the required parameter 'batch_size' when calling translation_memories_get_translation_memories_batch"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/translationmemory';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'last_processed_id'} ) {
        $query_params->{'lastProcessedId'} =
          $self->{api_client}->to_query_value( $args{'last_processed_id'} );
    }

    # query params
    if ( exists $args{'batch_size'} ) {
        $query_params->{'batchSize'} =
          $self->{api_client}->to_query_value( $args{'batch_size'} );
    }

    # query params
    if ( exists $args{'source_language'} ) {
        $query_params->{'sourceLanguage'} =
          $self->{api_client}->to_query_value( $args{'source_language'} );
    }

    # query params
    if ( exists $args{'target_language'} ) {
        $query_params->{'targetLanguage'} =
          $self->{api_client}->to_query_value( $args{'target_language'} );
    }

    # query params
    if ( exists $args{'client_id'} ) {
        $query_params->{'clientId'} =
          $self->{api_client}->to_query_value( $args{'client_id'} );
    }

    # query params
    if ( exists $args{'search_name'} ) {
        $query_params->{'searchName'} =
          $self->{api_client}->to_query_value( $args{'search_name'} );
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object = $self->{api_client}
      ->deserialize( 'ARRAY[TranslationMemoryModel]', $response );
    return $_response_object;
}

#
# translation_memories_import
#
# TMX import to TM
#
# @param string $tm_id TM ID (required)
# @param boolean $replace_all_content Requirement to replace the contents of the TM completely (required)
# @param File $tmx_file Uploaded TMX file (required)
{
    my $params = {
        'tm_id' => {
            data_type   => 'string',
            description => 'TM ID',
            required    => '1',
        },
        'replace_all_content' => {
            data_type => 'boolean',
            description =>
              'Requirement to replace the contents of the TM completely',
            required => '1',
        },
        'tmx_file' => {
            data_type   => 'File',
            description => 'Uploaded TMX file',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'translation_memories_import'} = {
        summary => 'TMX import to TM',
        params  => $params,
        returns => undef,
    };
}

# @return void
#
sub translation_memories_import {
    my ( $self, %args ) = @_;

    # verify the required parameter 'tm_id' is set
    unless ( exists $args{'tm_id'} ) {
        croak(
"Missing the required parameter 'tm_id' when calling translation_memories_import"
        );
    }

    # verify the required parameter 'replace_all_content' is set
    unless ( exists $args{'replace_all_content'} ) {
        croak(
"Missing the required parameter 'replace_all_content' when calling translation_memories_import"
        );
    }

    # verify the required parameter 'tmx_file' is set
    unless ( exists $args{'tmx_file'} ) {
        croak(
"Missing the required parameter 'tmx_file' when calling translation_memories_import"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/translationmemory/{tmId}';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if ( exists $args{'replace_all_content'} ) {
        $query_params->{'replaceAllContent'} =
          $self->{api_client}->to_query_value( $args{'replace_all_content'} );
    }

    # path params
    if ( exists $args{'tm_id'} ) {
        my $_base_variable = "{" . "tmId" . "}";
        my $_base_value = $self->{api_client}->to_path_value( $args{'tm_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # form params
    if ( exists $args{'tmx_file'} ) {
        $form_params->{'tmxFile'} = [] unless defined $form_params->{'tmxFile'};
        push @{ $form_params->{'tmxFile'} }, $args{'tmx_file'};
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

#
# translation_memories_remove_specific_import_task
#
# Remove a given import task
#
# @param string $task_id ID of the task for import to the TM (required)
{
    my $params = {
        'task_id' => {
            data_type   => 'string',
            description => 'ID of the task for import to the TM',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{
        'translation_memories_remove_specific_import_task'} = {
        summary => 'Remove a given import task',
        params  => $params,
        returns => undef,
        };
}

# @return void
#
sub translation_memories_remove_specific_import_task {
    my ( $self, %args ) = @_;

    # verify the required parameter 'task_id' is set
    unless ( exists $args{'task_id'} ) {
        croak(
"Missing the required parameter 'task_id' when calling translation_memories_remove_specific_import_task"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/translationmemory/task/{taskId}';

    my $_method       = 'DELETE';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'task_id'} ) {
        my $_base_variable = "{" . "taskId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'task_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

#
# translation_memories_remove_translation_memory
#
# Delete the TM
#
# @param string $tm_id TM ID (required)
{
    my $params = {
        'tm_id' => {
            data_type   => 'string',
            description => 'TM ID',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{
        'translation_memories_remove_translation_memory'} = {
        summary => 'Delete the TM',
        params  => $params,
        returns => undef,
        };
}

# @return void
#
sub translation_memories_remove_translation_memory {
    my ( $self, %args ) = @_;

    # verify the required parameter 'tm_id' is set
    unless ( exists $args{'tm_id'} ) {
        croak(
"Missing the required parameter 'tm_id' when calling translation_memories_remove_translation_memory"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/translationmemory/{tmId}';

    my $_method       = 'DELETE';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'tm_id'} ) {
        my $_base_variable = "{" . "tmId" . "}";
        my $_base_value = $self->{api_client}->to_path_value( $args{'tm_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

#
# translation_memories_set_tm_target_languages
#
# Set an array of target languages required by the TM
#
# @param string $tm_id TM ID (required)
# @param ARRAY[string] $target_languages Array of the required target languages (required)
{
    my $params = {
        'tm_id' => {
            data_type   => 'string',
            description => 'TM ID',
            required    => '1',
        },
        'target_languages' => {
            data_type   => 'ARRAY[string]',
            description => 'Array of the required target languages',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{
        'translation_memories_set_tm_target_languages'} = {
        summary => 'Set an array of target languages required by the TM',
        params  => $params,
        returns => undef,
        };
}

# @return void
#
sub translation_memories_set_tm_target_languages {
    my ( $self, %args ) = @_;

    # verify the required parameter 'tm_id' is set
    unless ( exists $args{'tm_id'} ) {
        croak(
"Missing the required parameter 'tm_id' when calling translation_memories_set_tm_target_languages"
        );
    }

    # verify the required parameter 'target_languages' is set
    unless ( exists $args{'target_languages'} ) {
        croak(
"Missing the required parameter 'target_languages' when calling translation_memories_set_tm_target_languages"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/translationmemory/{tmId}/targets';

    my $_method       = 'PUT';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}
      ->select_header_content_type( 'application/json', 'text/json' );

    # path params
    if ( exists $args{'tm_id'} ) {
        my $_base_variable = "{" . "tmId" . "}";
        my $_base_value = $self->{api_client}->to_path_value( $args{'tm_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # body params
    if ( exists $args{'target_languages'} ) {
        $_body_data = $args{'target_languages'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

1;
