package Google::Ads::AdWords::v201809::DraftAsyncError;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201809' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %baseCampaignId_of :ATTR(:get<baseCampaignId>);
my %draftId_of :ATTR(:get<draftId>);
my %draftCampaignId_of :ATTR(:get<draftCampaignId>);
my %asyncError_of :ATTR(:get<asyncError>);
my %baseAdGroupId_of :ATTR(:get<baseAdGroupId>);
my %draftAdGroupId_of :ATTR(:get<draftAdGroupId>);

__PACKAGE__->_factory(
    [ qw(        baseCampaignId
        draftId
        draftCampaignId
        asyncError
        baseAdGroupId
        draftAdGroupId

    ) ],
    {
        'baseCampaignId' => \%baseCampaignId_of,
        'draftId' => \%draftId_of,
        'draftCampaignId' => \%draftCampaignId_of,
        'asyncError' => \%asyncError_of,
        'baseAdGroupId' => \%baseAdGroupId_of,
        'draftAdGroupId' => \%draftAdGroupId_of,
    },
    {
        'baseCampaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'draftId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'draftCampaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'asyncError' => 'Google::Ads::AdWords::v201809::ApiError',
        'baseAdGroupId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'draftAdGroupId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'baseCampaignId' => 'baseCampaignId',
        'draftId' => 'draftId',
        'draftCampaignId' => 'draftCampaignId',
        'asyncError' => 'asyncError',
        'baseAdGroupId' => 'baseAdGroupId',
        'draftAdGroupId' => 'draftAdGroupId',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201809::DraftAsyncError

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DraftAsyncError from the namespace https://adwords.google.com/api/adwords/cm/v201809.

An error that has occurred while asynchronously processing the promotion of a draft. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * baseCampaignId


=item * draftId


=item * draftCampaignId


=item * asyncError


=item * baseAdGroupId


=item * draftAdGroupId




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

