#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 5;

use Games::Sudoku::Pdf;
#diag 'API2: ', $PDF::API2::VERSION, ', Table: ', $PDF::Table::VERSION;

my %params = (
  author          => 'Test::More',
  subject         => 'some stuff',
  keywords        => 'birthday',
  pageFormat      => 'Ledger', 
  puzzlesPerPage  => '5x3',
  # module output to terminal confuses prove : "Tests out of sequence"
  quiet => 1,
);

my $sudoku_writer = Games::Sudoku::Pdf->new( %params );
ok($sudoku_writer, 'writer created');
my $pdf_obj = $sudoku_writer->{pdf};

while (<DATA>) {
  chomp;
  my ($clues, $jigsaw, $extraRegion, $bottomLine) = split /\|/;

  $sudoku_writer->add_puzzle(
    clues       => $clues, 
    jigsaw      => $jigsaw, 
    extraRegion => $extraRegion,
    bottomLine  => $bottomLine
  );
}

my $page_count = $pdf_obj->can('page_count') ? $pdf_obj->page_count() : $pdf_obj->pages();
is($page_count, 2, "page count"); 

my ($head) = (($pdf_obj->can('to_string') ? $pdf_obj->to_string() : $pdf_obj->stringify()) =~ /^(.+?)>> stream/s);

like($head, qr/^%PDF-1\.4/, "magic number"); 
like($head, qr/\/CreationDate \(D:[0-9]{14}(Z|[-+]\d\d'\d\d'?)\)/, "creation date"); 
like($head, qr/\/Author \($params{author}\)/, "meta author"); 

__DATA__
..............3.85..1.2.......5.7.....4...1...9.......5......73..2.1........4...9
.......12........3..23..4....18....5.6..7.8.......9.....85.....9...4.5..47...6...
.2..5.7..4..1....68....3...2....8..3.4..2.5.....6...1...2.9.....9......57.4...9..
........3..1..56...9..4..7......9.5.7.......8.5.4.2....8..2..9...35..1..6........
12.3....435....1....4........54..2..6...7.........8.9...31..5.......9.7.....6...8
1.......2.9.4...5...6...7...5.9.3.......7.......85..4.7.....6...3...9.8...2.....1
.......39.....1..5..3.5.8....8.9...6.7...2...1..4.......9.8..5..2....6..4..7.....
12.3.....4.....3....3.5......42..5......8...9.6...5.7...15..2......9..6......7..8
..3..6.8....1..2......7...4..9..8.6..3..4...1.7.2.....3....5.....5...6..98.....5.
1.......9..67...2..8....4......75.3...5..2....6.3......9....8..6...4...1..25...6.
..489.2..........462.1......56.7841.....5.....1846.35......7.417..........1.495..|||Standard Sudoku
..2.389.1.49.............7.........7.9.....4.1.........5.............23.2.697.3..|111223334122253334122253334111254444166555447666658777699958887699958887699988777||Standard Sudoku jigsaw
..4..2..7...4..65....7....8..5..8.6.....1.....6.9..2..5....4....29..1...6..5..8..||X|X-Sudoku
..87.......7...6.9......58...51.6...............9.72...34......4.9...7.......14..|111222333111122333144422233145552636444555666474855569778886669777889999777888999|X|X-Sudoku jigsaw
..5..78...2..8....1.4.....95..34.................98..54.....9.8....1..4...79..2..||H|Hyper Sudoku
...29.158.1.5.....8......4.............1.9.............7......1.....3.8.698.17...|111222233112222333411253333414556666414555676444455676888859776888999977889999777|H|Hyper Sudoku jigsaw
....4.95........47.1....82......639..9.....6..452......67....1.85........23.6....||P|Percent Sudoku
...8...9....7................214.5.6.9.....8.3.7.598................5....5...4...|122223333112222333111124433516664444516564674555566674885597777888999977888899997|P|Percent Sudoku jigsaw
.3..169...5.34....6...5...8.4..6.................2..9.2...9...1....31.6...657..3.||C|Color Sudoku
..4........3..26...1.48....8...29...............13...9....71.5...92..4........8..|112222223111112433551122433655777433655777443665777443665889944665899999688888899|C|Color Sudoku jigsaw
4.59732....86..5.9.1...8..6....37...............24....8..1...3.5.4..91....37859.4||D|Center dot Sudoku
47.....21........6.26.5..9.938....1..5.....7..6....235.4..1.76.7........68.....57|112222334112222334112553334611155334666654444677559994677755899677888899677888899|D|Center dot Sudoku jigsaw
438.6......6.....2....3.......9.3.46.67...95.19.7.6.......9....2.....6......4.375||A|Asterisk Sudoku
6.3.9...8.....8...4..1..7..2..3.1.6.....4.....7.5.4..1..9..5..3...6.....3...7.1.5|111223333111222333441225533411225666444555666444588996775588966777888999777788999|A|Asterisk Sudoku jigsaw
.29....7357.6........2...9.3.64......5.7.1.4......59.6.4...6........2.3523....76.||G|Girandola Sudoku
81...32...56...8....31.....1.52......6.....1......13.2.....84....4...15...85...29|111123334111222344611222334655522344677555334667885554677888994667888999677789999|G|Girandola Sudoku jigsaw
